/*! START TRANSACTION */;
CREATE TABLE abilities (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(7,4),
  lower_ci_bound DECIMAL(7,4),
  upper_ci_bound DECIMAL(7,4),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.1', 'IM', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.1', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.2', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.3', 'IM', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.3', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.4', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.a.4', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.1', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.3', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.4', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.4', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.5', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.6', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.6', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.7', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.b.7', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.c.2', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.d.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.1', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.3', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.f.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.a.3', 'LV', 1.00, 8, 0.3780, 0.2592, 1.7408, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.1', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.2', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.3', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.b.4', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.1', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.2', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.a.4', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.1', 'LV', 4.50, 8, 0.2673, 3.9762, 5.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.3', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.4', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.4', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.5', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.5', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.6', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.7', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.a.7', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.3', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.4', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '1.A.4.b.5', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.1', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.3', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.4', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.a.4', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.4', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.6', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.6', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.b.7', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.c.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.d.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.d.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.3', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.e.3', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.f.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.1.g.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.a.3', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.2', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.a.4', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.3', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.3', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.6', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.1', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.2', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.5', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.6', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.b.7', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.d.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.d.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.3', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.e.3', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.1', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.2', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.a.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.2', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.1', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.2', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.1', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.2', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.3', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.a.4', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.b.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.b.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.3.c.4', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.3', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.4', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.5', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.5', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.6', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.4', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '1.A.4.b.5', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.3', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.3', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.4', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.6', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.b.7', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.d.1', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.f.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.1.g.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.2', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.a.3', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.2', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.a.4', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.6', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.1', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.2', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.1', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.6', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.c.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.e.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.f.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.a.3', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.2', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.a.4', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.6', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.2', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2015-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.1', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.3', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.4', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.c.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.d.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.1.g.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.2', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.a.3', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.2', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.3', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.b.4', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.2', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.2.c.3', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.a.4', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.2', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.3', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.4', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.5', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.5', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.6', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.6', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.7', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.a.7', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.2', 'LV', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.3', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '1.A.4.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.3', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.5', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.5', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.6', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.6', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.c.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.c.1', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.c.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.c.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.d.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.f.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.f.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.f.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.g.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.2', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.3', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.a.3', 'LV', 2.12, 8, 0.2950, 1.5467, 2.7033, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.1', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.2', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.2', 'LV', 1.00, 8, 0.4226, 0.1717, 1.8283, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.b.4', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.1', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.2', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.1', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.2', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.3', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.a.4', 'LV', 1.25, 8, 0.4532, 0.3618, 2.1382, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.b.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.b.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.1', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.3.c.4', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.3', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.4', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.5', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.5', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.6', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.6', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.7', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.a.7', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.1', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.2', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.3', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.4', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '1.A.4.b.5', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.1', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.2', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.6', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.d.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.f.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.1.g.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.1', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.2', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.3', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.a.3', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.1', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.2', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.4', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.b.4', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.2', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.a.4', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.3', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.3', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.6', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.7', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.a.7', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.2', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.4', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.4', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '1.A.4.b.5', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.1', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.2', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.3', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.2', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.5', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.6', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.c.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.c.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.c.2', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.c.2', 'LV', 4.25, 8, 0.3134, 3.6358, 4.8642, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.d.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.d.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.f.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.f.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.g.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.g.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.g.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.1.g.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.1', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.2', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.a.3', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.1', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.2', 'LV', 1.62, 8, 0.4199, 0.8019, 2.4481, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.a.4', 'LV', 1.38, 8, 0.2631, 0.8594, 1.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.b.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.b.1', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.1', 'LV', 4.12, 8, 0.2950, 3.5467, 4.7033, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.2', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.2', 'LV', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.3', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.4', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.5', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.5', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.6', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.6', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.1', 'LV', 1.00, 8, 0.3780, 0.2592, 1.7408, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.2', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.3', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.4', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.2950, 3.2967, 4.4533, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '1.A.4.b.5', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.2', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.2', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.3', 'LV', 4.88, 8, 0.2266, 4.4309, 5.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.1', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.2', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.3', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.5', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.5', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.6', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.7', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.b.7', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.c.2', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.d.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.d.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.3', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.e.3', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.f.2', 'LV', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.1.g.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.3', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.a.3', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.2', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.a.4', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.3', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.6', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.6', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.1', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.2', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.4', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '1.A.4.b.5', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.1', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.1', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.2', 'IM', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.2', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.3', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.3', 'LV', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.4', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.a.4', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.1', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.1', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.2', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.3', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.3', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.4', 'IM', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.4', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.5', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.5', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.6', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.6', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.b.7', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.c.1', 'IM', 3.88, 8, 0.2950, 3.2967, 4.4533, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.c.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.c.2', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.c.2', 'LV', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.d.1', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.d.1', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.1', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.1', 'LV', 3.12, 8, 0.3981, 2.3447, 3.9053, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.2', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.2', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.3', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.e.3', 'LV', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.f.2', 'IM', 2.75, 8, 0.4119, 1.9427, 3.5573, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.f.2', 'LV', 2.75, 8, 0.5590, 1.6543, 3.8457, 'Y', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.g.1', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.g.1', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.1.g.2', 'LV', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.3', 'IM', 2.25, 8, 0.3134, 1.6358, 2.8642, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.a.3', 'LV', 1.88, 8, 0.4407, 1.0113, 2.7387, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.1', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.2', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.2', 'LV', 2.88, 8, 0.3504, 2.1883, 3.5617, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.3', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.3', 'LV', 1.75, 8, 0.3660, 1.0327, 2.4673, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.6', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.6', 'LV', 0.88, 8, 0.3981, 0.0947, 1.6553, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.1', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.2', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.2', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.4', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.5', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '1.A.4.b.5', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.4', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.1', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.6', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.6', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.b.7', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.c.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.3', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.1', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.f.2', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.1', 'LV', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.2', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.3', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.a.3', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.2', 'LV', 1.75, 8, 0.3134, 1.1358, 2.3642, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.3', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.b.4', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.2', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.2.c.3', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.1', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.2', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.3', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.4', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.a.4', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.b.1', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.3', 'LV', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.3.c.4', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.1', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.4', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.4', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.5', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.5', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.6', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.6', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.7', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.a.7', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.2', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.4', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2021-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.4', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.1', 'LV', 3.75, 8, 0.3134, 3.1358, 4.3642, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.3', 'LV', 4.62, 8, 0.2631, 4.1094, 5.1406, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.5', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.6', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.6', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.b.7', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.d.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.1', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.2', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.2', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.3', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.e.3', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.1', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.f.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.1', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.1', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.2', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.3', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.a.3', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.1', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.2', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.b.4', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.2', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.1', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.3', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.a.4', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.b.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.b.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.3', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.3.c.4', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.3', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.3', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.6', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.6', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.3', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.4', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '1.A.4.b.5', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2022-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.1', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.1', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.2', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.2', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.3', 'LV', 4.25, 8, 0.2500, 3.7600, 4.7400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.a.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.1', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.2', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.2', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.3', 'LV', 4.12, 8, 0.2950, 3.5467, 4.7033, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.4', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.5', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.6', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.6', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.b.7', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.1', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.2', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.c.2', 'LV', 3.50, 8, 0.3273, 2.8584, 4.1416, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.d.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.d.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.3', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.e.3', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.1', 'LV', 1.75, 8, 0.3134, 1.1358, 2.3642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.f.2', 'LV', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.1', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.1', 'LV', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.1.g.2', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.1', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.1', 'LV', 2.25, 8, 0.4532, 1.3618, 3.1382, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.2', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.2', 'LV', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.a.3', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.1', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.1', 'LV', 2.62, 8, 0.4605, 1.7224, 3.5276, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.2', 'IM', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.2', 'LV', 2.12, 8, 0.4407, 1.2613, 2.9887, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.3', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.3', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.4', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.b.4', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.1', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.1', 'LV', 2.38, 8, 0.4605, 1.4724, 3.2776, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.2', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.2.c.3', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.1', 'LV', 0.62, 8, 0.4199, 0.0000, 1.4481, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.2', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.3', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.4', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.a.4', 'LV', 2.00, 8, 0.3780, 1.2592, 2.7408, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.b.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.b.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.1', 'LV', 0.50, 8, 0.3780, 0.0000, 1.2408, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.2', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.3', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.3.c.4', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.1', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.3', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.4', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.5', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.5', 'LV', 1.25, 8, 0.4119, 0.4427, 2.0573, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.6', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.6', 'LV', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.7', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.a.7', 'LV', 0.88, 8, 0.3981, 0.0947, 1.6553, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.1', 'IM', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.1', 'LV', 2.38, 8, 0.4199, 1.5519, 3.1981, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.2', 'LV', 2.75, 8, 0.3134, 2.1358, 3.3642, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.3', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.4', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.5', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '1.A.4.b.5', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2011-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.1', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.1', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.2', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.2', 'LV', 4.12, 8, 0.2950, 3.5467, 4.7033, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.3', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.3', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.4', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.a.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.1', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.1', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.2', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.2', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.3', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.3', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.4', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.5', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.5', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.6', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.6', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.b.7', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.c.1', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.c.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.c.2', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.d.1', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.1', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.3', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.e.3', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.f.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.f.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.f.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.f.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.g.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.g.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.g.2', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.1.g.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.2', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.3', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.a.3', 'LV', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.1', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.2', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.3', 'IM', 1.50, 8, 0.2673, 1.0000, 2.0238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.3', 'LV', 0.88, 8, 0.4407, 0.0113, 1.7387, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.4', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.b.4', 'LV', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.1', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.2', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.2.c.3', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.2', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.3', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.4', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.a.4', 'LV', 2.12, 8, 0.3981, 1.3447, 2.9053, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.b.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.b.1', 'LV', 1.62, 8, 0.4199, 0.8019, 2.4481, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.1', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.1', 'LV', 1.50, 8, 0.3780, 0.7592, 2.2408, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.3', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.4', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.3.c.4', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.2', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.2', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.3', 'IM', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.3', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.6', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.6', 'LV', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.7', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.a.7', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.2', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.4', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.5', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '1.A.4.b.5', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.3', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.5', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.6', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.b.7', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.d.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.1', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.3', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.e.3', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.1', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.f.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.1.g.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.2', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.3', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.a.3', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.3', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.b.4', 'LV', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.2', 'LV', 0.50, 8, 0.3273, 0.0000, 1.1416, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.2.c.3', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.1', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.2', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.4', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.a.4', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.b.1', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.1', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.3', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.3.c.4', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.4', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.4', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.5', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.5', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.6', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.7', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.a.7', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.1', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.2', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.2', 'LV', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.4', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.1', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.2', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.2', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.3', 'IM', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.3', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.4', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.a.4', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.1', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.6', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.6', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.7', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.b.7', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.c.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.c.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.c.2', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.c.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.d.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.1', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.2', 'IM', 3.25, 8, 0.3134, 2.6358, 3.8642, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.3', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.e.3', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.f.1', 'IM', 2.38, 8, 0.3239, 1.7402, 3.0098, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.f.1', 'LV', 2.00, 8, 0.4629, 1.0927, 2.9073, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.f.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.f.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.g.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.g.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.g.2', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.1.g.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.3', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.a.3', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.2', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.2', 'LV', 1.75, 8, 0.3134, 1.1358, 2.3642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.3', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.3', 'LV', 1.88, 8, 0.3981, 1.0947, 2.6553, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.4', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.b.4', 'LV', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.1', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.1', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.3', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.4', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.a.4', 'LV', 2.25, 8, 0.4119, 1.4427, 3.0573, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.b.1', 'IM', 1.25, 8, 0.2500, 1.0000, 1.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.b.1', 'LV', 0.38, 8, 0.3750, 0.0000, 1.1100, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.1', 'IM', 2.00, 8, 0.2673, 1.4762, 2.5238, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.1', 'LV', 1.75, 8, 0.4119, 0.9427, 2.5573, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.4', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.3.c.4', 'LV', 1.25, 8, 0.4119, 0.4427, 2.0573, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.2', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.2', 'LV', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.3', 'IM', 3.12, 8, 0.2950, 2.5467, 3.7033, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.3', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.4', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.4', 'LV', 1.25, 8, 0.3660, 0.5327, 1.9673, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.5', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.5', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.6', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.6', 'LV', 2.50, 8, 0.4226, 1.6717, 3.3283, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.7', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.a.7', 'LV', 1.75, 8, 0.3134, 1.1358, 2.3642, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.1', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.2', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.3', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.3', 'LV', 1.38, 8, 0.3750, 0.6400, 2.1100, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.4', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.4', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.5', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '1.A.4.b.5', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2016-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.2', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.2', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.3', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.c.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.f.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.2', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.3', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.a.4', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.3', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.3', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.6', 'LV', 1.12, 8, 0.1250, 0.8800, 1.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.1', 'IM', 3.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.1', 'LV', 4.12, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.2', 'IM', 3.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.2', 'LV', 4.08, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.3', 'IM', 3.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.3', 'LV', 4.12, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.4', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.a.4', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.1', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.1', 'LV', 3.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.2', 'IM', 3.16, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.2', 'LV', 3.33, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.3', 'IM', 3.92, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.3', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.4', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.4', 'LV', 3.96, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.5', 'IM', 3.63, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.5', 'LV', 3.79, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.6', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.6', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.7', 'IM', 3.21, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.b.7', 'LV', 3.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.c.1', 'IM', 3.08, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.c.1', 'LV', 3.13, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.c.2', 'IM', 3.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.c.2', 'LV', 3.08, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.d.1', 'IM', 2.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.d.1', 'LV', 2.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.1', 'IM', 2.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.1', 'LV', 2.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.2', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.2', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.3', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.e.3', 'LV', 2.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.f.1', 'IM', 1.59, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.f.1', 'LV', 0.92, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.f.2', 'IM', 2.54, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.f.2', 'LV', 2.62, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.g.1', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.g.1', 'LV', 2.88, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.g.2', 'IM', 2.54, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.1.g.2', 'LV', 2.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.1', 'IM', 1.79, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.1', 'LV', 1.25, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.2', 'IM', 1.79, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.2', 'LV', 1.13, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.3', 'IM', 2.04, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.a.3', 'LV', 1.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.1', 'IM', 1.83, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.1', 'LV', 1.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.2', 'IM', 1.67, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.2', 'LV', 1.00, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.3', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.3', 'LV', 0.58, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.4', 'IM', 1.41, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.b.4', 'LV', 0.54, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.1', 'IM', 1.37, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.1', 'LV', 0.58, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.2', 'IM', 1.25, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.2', 'LV', 0.33, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.3', 'IM', 1.17, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.2.c.3', 'LV', 0.29, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.1', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.1', 'LV', 0.58, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.2', 'IM', 1.17, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.2', 'LV', 0.21, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.3', 'IM', 1.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.3', 'LV', 0.67, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.4', 'IM', 1.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.a.4', 'LV', 1.12, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.b.1', 'IM', 1.37, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.b.1', 'LV', 0.58, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.1', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.1', 'LV', 0.63, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.2', 'IM', 1.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.2', 'LV', 0.00, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.3', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.3', 'LV', 0.42, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.4', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.3.c.4', 'LV', 0.42, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.1', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.1', 'LV', 3.54, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.2', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.2', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.3', 'IM', 2.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.3', 'LV', 1.96, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.4', 'IM', 1.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.4', 'LV', 0.29, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.5', 'IM', 1.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.5', 'LV', 0.33, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.6', 'IM', 1.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.6', 'LV', 1.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.7', 'IM', 1.29, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.a.7', 'LV', 0.33, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.1', 'IM', 1.92, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.1', 'LV', 1.79, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.2', 'IM', 2.08, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.2', 'LV', 2.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.3', 'IM', 1.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.3', 'LV', 0.37, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.4', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.4', 'LV', 3.63, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.5', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '1.A.4.b.5', 'LV', 3.54, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.6', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.6', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.7', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.b.7', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.c.1', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.c.1', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2017-07-01', 'Analyst');
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.c.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.d.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.1', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.e.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.f.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.f.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.g.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.3', 'IM', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.a.3', 'LV', 1.38, 8, 0.4199, 0.5519, 2.1981, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.2', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.4', 'IM', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.a.4', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.1', 'IM', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.1', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.3', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.3', 'LV', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.6', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.1', 'LV', 1.88, 8, 0.2950, 1.2967, 2.4533, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.2', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.2', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.4', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '1.A.4.b.5', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.1', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.3', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.3', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.4', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.4', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.5', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.5', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.6', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.6', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.1', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.c.2', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.d.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.d.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.1', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.3', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.e.3', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.f.2', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.1.g.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.3', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.a.3', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.2', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.a.4', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.3', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.6', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.6', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.1', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.2', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.4', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.1', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.3', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.2', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.6', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.6', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.b.7', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.c.2', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.1.g.2', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.2', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.a.3', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.2', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.3', 'LV', 0.38, 8, 0.1830, 0.0164, 0.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.a.4', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.3', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.6', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.7', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.a.7', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.1', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.2', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '1.A.4.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.3', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.a.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.5', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.b.7', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.d.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.3', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.f.2', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.1.g.2', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.1', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.2', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.3', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.a.3', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.1', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.a.4', 'LV', 1.25, 8, 0.3660, 0.5327, 1.9673, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.2', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.3', 'IM', 2.38, 8, 0.2631, 1.8594, 2.8906, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.3', 'LV', 2.00, 8, 0.3273, 1.3584, 2.6416, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.6', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.6', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '1.A.4.b.5', 'LV', 5.00, 8, 0.0000, 5.0000, 5.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.1', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.1', 'LV', 4.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.2', 'IM', 3.63, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.2', 'LV', 3.83, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.3', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.3', 'LV', 4.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.4', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.a.4', 'LV', 3.71, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.1', 'IM', 3.09, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.1', 'LV', 3.17, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.2', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.2', 'LV', 3.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.3', 'IM', 3.92, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.3', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.4', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.4', 'LV', 3.83, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.5', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.5', 'LV', 3.80, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.6', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.6', 'LV', 3.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.7', 'IM', 3.37, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.b.7', 'LV', 3.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.c.1', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.c.1', 'LV', 2.79, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.c.2', 'IM', 2.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.c.2', 'LV', 2.88, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.d.1', 'IM', 2.38, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.d.1', 'LV', 2.46, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.1', 'IM', 2.50, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.1', 'LV', 2.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.2', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.2', 'LV', 3.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.3', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.e.3', 'LV', 2.71, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.f.1', 'IM', 2.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.f.1', 'LV', 1.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.f.2', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.f.2', 'LV', 3.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.g.1', 'IM', 3.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.g.1', 'LV', 2.88, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.g.2', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.1.g.2', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.1', 'IM', 2.87, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.1', 'LV', 2.79, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.2', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.2', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.3', 'IM', 2.83, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.a.3', 'LV', 2.79, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.1', 'IM', 3.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.1', 'LV', 3.08, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.2', 'IM', 2.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.2', 'LV', 3.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.3', 'IM', 2.13, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.3', 'LV', 2.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.4', 'IM', 2.04, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.b.4', 'LV', 1.71, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.1', 'IM', 2.17, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.1', 'LV', 2.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.2', 'IM', 1.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.2', 'LV', 1.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.3', 'IM', 1.71, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.2.c.3', 'LV', 1.04, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.1', 'IM', 2.33, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.1', 'LV', 2.42, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.2', 'IM', 1.21, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.2', 'LV', 0.37, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.3', 'IM', 1.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.3', 'LV', 1.63, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.4', 'IM', 2.58, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.a.4', 'LV', 2.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.b.1', 'IM', 2.13, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.b.1', 'LV', 1.67, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.1', 'IM', 2.17, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.1', 'LV', 2.17, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.2', 'IM', 1.08, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.2', 'LV', 0.17, NULL, NULL, NULL, NULL, 'N', 'Y', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.3', 'IM', 2.00, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.3', 'LV', 1.63, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.4', 'IM', 1.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.3.c.4', 'LV', 1.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.1', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.1', 'LV', 3.42, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.2', 'IM', 2.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.2', 'LV', 3.00, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.3', 'IM', 2.83, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.3', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.4', 'IM', 1.84, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.4', 'LV', 1.13, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.5', 'IM', 1.96, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.5', 'LV', 1.25, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.6', 'IM', 2.59, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.6', 'LV', 2.38, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.7', 'IM', 1.88, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.a.7', 'LV', 1.50, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.1', 'IM', 2.42, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.1', 'LV', 2.29, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.2', 'IM', 2.50, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.2', 'LV', 2.42, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.3', 'IM', 1.87, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.3', 'LV', 1.34, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.4', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.4', 'LV', 3.21, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.5', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', NULL, '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '1.A.4.b.5', 'LV', 3.04, NULL, NULL, NULL, NULL, 'N', 'N', '2020-11-01', 'Analyst - Transition');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.3', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.a.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.6', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.6', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.7', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.b.7', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.1', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.c.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.3', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.e.3', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.1', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.1', 'LV', 1.38, 8, 0.2631, 0.8594, 1.8906, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.f.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.2', 'IM', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.1.g.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.a.3', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.1', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.2', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.1', 'LV', 1.50, 8, 0.3273, 0.8584, 2.1416, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.2', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.2', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.1', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.2', 'LV', 0.25, 8, 0.2500, 0.0000, 0.7400, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.3', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.3', 'LV', 0.62, 8, 0.3239, 0.0000, 1.2598, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.2266, 1.6809, 2.5691, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.a.4', 'LV', 1.62, 8, 0.3239, 0.9902, 2.2598, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.b.1', 'IM', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.b.1', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.1', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.3', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.3.c.4', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.2', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.4', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.4', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.5', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.5', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.6', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.6', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.7', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.a.7', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.2', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.3', 'LV', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.4', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.a.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.1', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.5', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.6', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.7', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.c.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.d.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.d.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.e.3', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.1.g.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.1', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.2', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.a.3', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.2', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.2', 'LV', 0.88, 8, 0.2950, 0.2967, 1.4533, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.1', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.2', 'LV', 0.62, 8, 0.2631, 0.1094, 1.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.3', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.a.4', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.b.1', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.1', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.3', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.3.c.4', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.3', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.6', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.6', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.4', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '1.A.4.b.5', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.1', 'IM', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.1', 'LV', 4.88, 8, 0.2266, 4.4309, 5.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.2', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.3', 'IM', 4.38, 8, 0.1830, 4.0164, 4.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.3', 'LV', 5.00, 8, 0.1890, 4.6296, 5.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.4', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.a.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.3', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.4', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.4', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.5', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.6', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.6', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.7', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.b.7', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.1', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.3', 'IM', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.e.3', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.f.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.2', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.2', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.a.3', 'LV', 1.38, 8, 0.3239, 0.7402, 2.0098, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.2', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.1', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.1', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.2', 'LV', 0.88, 8, 0.2266, 0.4309, 1.3191, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.1', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.2', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.3', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.a.4', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.b.1', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.1', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.1', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.3', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.4', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.3.c.4', 'LV', 0.62, 8, 0.1830, 0.2664, 0.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.3', 'LV', 1.50, 8, 0.2673, 0.9762, 2.0238, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.6', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.1', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.2', 'IM', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.4', 'IM', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.5', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '1.A.4.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.1', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.2', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.2', 'LV', 4.50, 8, 0.1890, 4.1296, 4.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.3', 'LV', 4.88, 8, 0.1250, 4.6300, 5.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.4', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.a.4', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.1', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.2', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.3', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.4', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.7', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.b.7', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.c.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.e.3', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.2', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.f.2', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.1', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.a.3', 'LV', 1.12, 8, 0.3504, 0.4383, 1.8117, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.3', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.3', 'LV', 0.25, 8, 0.1637, 0.0000, 0.5708, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.a.4', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.2', 'LV', 2.62, 8, 0.2631, 2.1094, 3.1406, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.3', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.6', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.6', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.1', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.2', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '1.A.4.b.5', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2018-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.1', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.1', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.2', 'IM', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.2', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.3', 'LV', 4.75, 8, 0.1637, 4.4292, 5.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.a.4', 'LV', 4.62, 8, 0.1830, 4.2664, 4.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.1', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.2', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.2', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.3', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.4', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.4', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.5', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.b.7', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.1', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.c.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.d.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.2', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.1', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.1', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.f.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.1.g.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.1', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.2', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.3', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.a.3', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.1', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.2', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.b.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.2', 'LV', 0.50, 8, 0.3273, 0.0000, 1.1416, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.4', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.a.4', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.b.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.b.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.3.c.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.1', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.3', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.3', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.6', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.1', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.5', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '1.A.4.b.5', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2020-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.1', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.1', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.2', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.2', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.3', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.3', 'LV', 4.25, 8, 0.1637, 3.9292, 4.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.4', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.a.4', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.1', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.1', 'LV', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.2', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.2', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.3', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.3', 'LV', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.4', 'IM', 4.00, 8, 0.2673, 3.4762, 4.5238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.4', 'LV', 4.38, 8, 0.2631, 3.8594, 4.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.5', 'IM', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.5', 'LV', 4.12, 8, 0.2266, 3.6809, 4.5691, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.6', 'IM', 3.88, 8, 0.2266, 3.4309, 4.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.6', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.7', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.b.7', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.c.1', 'IM', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.c.1', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.c.2', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.c.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.d.1', 'LV', 3.00, 8, 0.2673, 2.4762, 3.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.1', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.2', 'IM', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.2', 'LV', 3.25, 8, 0.2500, 2.7600, 3.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.3', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.e.3', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.f.1', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.f.1', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.f.2', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.f.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.g.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.g.1', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.g.2', 'IM', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.1.g.2', 'LV', 3.00, 8, 0.3273, 2.3584, 3.6416, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.2', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.a.3', 'LV', 3.00, 8, 0.1890, 2.6296, 3.3704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.2', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.2', 'LV', 1.88, 8, 0.3504, 1.1883, 2.5617, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.3', 'IM', 1.88, 8, 0.2266, 1.4309, 2.3191, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.3', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.b.4', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.1', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.2', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.2', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.2.c.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.1', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.3', 'LV', 1.00, 8, 0.2673, 0.4762, 1.5238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.4', 'IM', 2.00, 8, 0.1890, 1.6296, 2.3704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.a.4', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.b.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.b.1', 'LV', 1.25, 8, 0.2500, 0.7600, 1.7400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.1', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.3', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.3', 'LV', 1.25, 8, 0.3134, 0.6358, 1.8642, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.3.c.4', 'LV', 1.12, 8, 0.2950, 0.5467, 1.7033, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.1', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.1', 'LV', 3.75, 8, 0.2500, 3.2600, 4.2400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.2', 'IM', 3.12, 8, 0.2266, 2.6809, 3.5691, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.3', 'IM', 2.88, 8, 0.2950, 2.2967, 3.4533, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.3', 'LV', 3.50, 8, 0.2673, 2.9762, 4.0238, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.6', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.6', 'LV', 2.00, 8, 0.3780, 1.2592, 2.7408, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.1', 'LV', 2.75, 8, 0.2500, 2.2600, 3.2400, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.4', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.4', 'LV', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.5', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '1.A.4.b.5', 'LV', 3.62, 8, 0.2631, 3.1094, 4.1406, 'N', 'N', '2014-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.2', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.4', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.a.4', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.3', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.4', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.5', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.5', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.6', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.6', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.7', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.c.2', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.d.1', 'LV', 2.50, 8, 0.2673, 1.9762, 3.0238, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.1', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.3', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.e.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.f.2', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.3', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.a.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.1', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.2', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.2', 'LV', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.3', 'LV', 0.75, 8, 0.2500, 0.2600, 1.2400, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.4', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.b.4', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.1', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.2', 'LV', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.3', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.2.c.3', 'LV', 1.00, 8, 0.3273, 0.3584, 1.6416, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.1', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.2', 'IM', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.2', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.3', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.3', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.4', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.a.4', 'LV', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.b.1', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.1', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.3', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.3.c.4', 'LV', 1.12, 8, 0.2266, 0.6809, 1.5691, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.3', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.3', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.5', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.5', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.6', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.6', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.1', 'IM', 2.25, 8, 0.2500, 1.7600, 2.7400, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.1', 'LV', 1.75, 8, 0.2500, 1.2600, 2.2400, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.4', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.4', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '1.A.4.b.5', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.1', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.2', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.3', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.4', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.a.4', 'LV', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.3', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.4', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.5', 'IM', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.6', 'IM', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.6', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.b.7', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.c.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.d.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.d.1', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.2', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.3', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.e.3', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.2', 'IM', 2.38, 8, 0.1830, 2.0164, 2.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.f.2', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.1', 'IM', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.1.g.2', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.1', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.1', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.2', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.a.3', 'LV', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.1', 'LV', 0.88, 8, 0.3504, 0.1883, 1.5617, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.2', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.2', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.3', 'LV', 0.75, 8, 0.3134, 0.1358, 1.3642, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.4', 'IM', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.b.4', 'LV', 0.50, 8, 0.2673, 0.0000, 1.0238, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.1', 'IM', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.1', 'LV', 0.75, 8, 0.1637, 0.4292, 1.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.2', 'IM', 1.25, 8, 0.1637, 1.0000, 1.5708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.2', 'LV', 0.38, 8, 0.2631, 0.0000, 0.8906, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.3', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.2.c.3', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.1', 'IM', 1.50, 8, 0.1890, 1.1296, 1.8704, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.1', 'LV', 0.50, 8, 0.1890, 0.1296, 0.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.2', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.2', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.3', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.3', 'LV', 0.88, 8, 0.1250, 0.6300, 1.1200, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.4', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.a.4', 'LV', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.b.1', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.b.1', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.1', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.1', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.2', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.2', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.3', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.3', 'LV', 1.38, 8, 0.1830, 1.0164, 1.7336, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.4', 'IM', 1.88, 8, 0.1250, 1.6300, 2.1200, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.3.c.4', 'LV', 1.00, 8, 0.1890, 0.6296, 1.3704, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.1', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.2', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.3', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.3', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.4', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.4', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.5', 'IM', 1.12, 8, 0.1250, 1.0000, 1.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.5', 'LV', 0.12, 8, 0.1250, 0.0000, 0.3700, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.6', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.6', 'LV', 1.62, 8, 0.1830, 1.2664, 1.9836, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.7', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.a.7', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.1', 'LV', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.2', 'LV', 2.88, 8, 0.2266, 2.4309, 3.3191, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.3', 'IM', 1.00, 8, 0.0000, 1.0000, 1.0000, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.3', 'LV', 0.00, 8, 0.0000, 0.0000, 0.0000, 'N', 'Y', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.4', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.4', 'LV', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.5', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '1.A.4.b.5', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2023-08-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.1', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.1', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.2', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.2', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.3', 'IM', 4.12, 8, 0.1250, 3.8800, 4.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.3', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.4', 'IM', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.a.4', 'LV', 4.00, 8, 0.0000, 4.0000, 4.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.1', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.1', 'LV', 3.50, 8, 0.1890, 3.1296, 3.8704, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.2', 'IM', 3.38, 8, 0.1830, 3.0164, 3.7336, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.2', 'LV', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.3', 'IM', 4.00, 8, 0.1890, 3.6296, 4.3704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.3', 'LV', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.4', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.4', 'LV', 3.88, 8, 0.1250, 3.6300, 4.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.5', 'IM', 3.62, 8, 0.1830, 3.2664, 3.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.5', 'LV', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.6', 'IM', 3.75, 8, 0.1637, 3.4292, 4.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.6', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.7', 'IM', 3.25, 8, 0.1637, 2.9292, 3.5708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.b.7', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.1', 'IM', 3.38, 8, 0.2631, 2.8594, 3.8906, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.2', 'IM', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.c.2', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.d.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.d.1', 'LV', 2.75, 8, 0.1637, 2.4292, 3.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.1', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.1', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.2', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.2', 'LV', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.3', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.e.3', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.1', 'IM', 2.12, 8, 0.1250, 1.8800, 2.3700, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.1', 'LV', 1.62, 8, 0.2631, 1.1094, 2.1406, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.2', 'IM', 2.50, 8, 0.1890, 2.1296, 2.8704, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.f.2', 'LV', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.1', 'IM', 3.00, 8, 0.0000, 3.0000, 3.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.1', 'LV', 3.12, 8, 0.1250, 2.8800, 3.3700, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.2', 'IM', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.1.g.2', 'LV', 2.88, 8, 0.1250, 2.6300, 3.1200, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.1', 'IM', 2.62, 8, 0.1830, 2.2664, 2.9836, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.1', 'LV', 2.25, 8, 0.1637, 1.9292, 2.5708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.2', 'IM', 2.00, 8, 0.0000, 2.0000, 2.0000, 'N', NULL, '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '1.A.2.a.2', 'LV', 1.75, 8, 0.1637, 1.4292, 2.0708, 'N', 'N', '2017-07-01', 'Analyst');
INSERT INTO abilities (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, n