CREATE TABLE work_styles (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.a', 'IM', 4.55, 27, 0.16, 4.21, 4.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.b', 'IM', 4.43, 27, 0.18, 4.06, 4.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.1.c', 'IM', 4.75, 27, 0.12, 4.50, 4.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.2.b', 'IM', 4.97, 27, 0.03, 4.90, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.a', 'IM', 4.44, 27, 0.14, 4.16, 4.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.b', 'IM', 4.22, 27, 0.20, 3.81, 4.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.3.c', 'IM', 3.67, 26, 0.32, 3.01, 4.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.a', 'IM', 4.52, 27, 0.12, 4.26, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.b', 'IM', 4.75, 27, 0.12, 4.49, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.4.c', 'IM', 4.20, 27, 0.22, 3.75, 4.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.a', 'IM', 4.65, 27, 0.13, 4.38, 4.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.b', 'IM', 4.49, 27, 0.12, 4.24, 4.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.5.c', 'IM', 4.80, 27, 0.11, 4.57, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.6', 'IM', 4.54, 27, 0.18, 4.17, 4.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.a', 'IM', 4.27, 27, 0.24, 3.79, 4.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '1.C.7.b', 'IM', 4.45, 27, 0.17, 4.09, 4.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.b', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.1.c', 'IM', 4.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.2.b', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.a', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.b', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.3.c', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.a', 'IM', 4.15, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.b', 'IM', 3.96, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.4.c', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.b', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.5.c', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.6', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.7.a', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '1.C.7.b', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.a', 'IM', 4.18, 55, 0.14, 3.91, 4.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.b', 'IM', 4.04, 55, 0.13, 3.79, 4.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.1.c', 'IM', 4.35, 55, 0.11, 4.13, 4.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.2.b', 'IM', 4.59, 55, 0.10, 4.39, 4.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.a', 'IM', 4.16, 55, 0.16, 3.84, 4.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.b', 'IM', 4.06, 55, 0.19, 3.68, 4.43, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.3.c', 'IM', 3.57, 55, 0.24, 3.08, 4.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.a', 'IM', 4.31, 55, 0.16, 3.98, 4.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.b', 'IM', 4.33, 55, 0.12, 4.08, 4.58, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.4.c', 'IM', 4.09, 55, 0.17, 3.75, 4.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.a', 'IM', 4.54, 55, 0.11, 4.32, 4.76, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.b', 'IM', 4.25, 55, 0.15, 3.95, 4.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.5.c', 'IM', 4.30, 55, 0.17, 3.95, 4.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.6', 'IM', 3.99, 55, 0.19, 3.60, 4.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.a', 'IM', 3.65, 55, 0.20, 3.25, 4.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '1.C.7.b', 'IM', 4.03, 55, 0.22, 3.60, 4.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.a', 'IM', 4.10, 27, 0.16, 3.77, 4.43, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.b', 'IM', 4.32, 27, 0.16, 4.00, 4.65, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.1.c', 'IM', 4.56, 27, 0.11, 4.34, 4.78, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.2.b', 'IM', 4.03, 27, 0.19, 3.64, 4.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.a', 'IM', 4.51, 27, 0.16, 4.19, 4.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.b', 'IM', 3.81, 27, 0.21, 3.39, 4.24, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.3.c', 'IM', 3.70, 27, 0.24, 3.21, 4.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.a', 'IM', 4.18, 26, 0.20, 3.77, 4.60, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.b', 'IM', 4.35, 27, 0.15, 4.04, 4.66, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.4.c', 'IM', 4.42, 27, 0.14, 4.13, 4.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.a', 'IM', 4.51, 27, 0.14, 4.22, 4.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.b', 'IM', 4.48, 27, 0.14, 4.20, 4.76, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.5.c', 'IM', 4.17, 27, 0.16, 3.83, 4.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.6', 'IM', 4.04, 27, 0.15, 3.74, 4.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.a', 'IM', 3.99, 27, 0.18, 3.61, 4.37, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '1.C.7.b', 'IM', 3.88, 27, 0.15, 3.56, 4.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.a', 'IM', 4.32, 37, 0.11, 4.10, 4.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.b', 'IM', 4.23, 37, 0.17, 3.88, 4.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.1.c', 'IM', 4.53, 37, 0.26, 4.01, 5.00, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.2.b', 'IM', 4.37, 37, 0.19, 3.98, 4.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.a', 'IM', 4.08, 37, 0.20, 3.68, 4.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.b', 'IM', 3.37, 36, 0.23, 2.89, 3.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.3.c', 'IM', 3.80, 37, 0.21, 3.37, 4.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.a', 'IM', 3.87, 37, 0.19, 3.48, 4.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.b', 'IM', 4.01, 37, 0.22, 3.57, 4.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.4.c', 'IM', 4.31, 37, 0.14, 4.04, 4.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.a', 'IM', 4.35, 37, 0.17, 4.00, 4.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.b', 'IM', 4.32, 37, 0.16, 3.99, 4.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.5.c', 'IM', 4.17, 37, 0.17, 3.82, 4.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.6', 'IM', 3.88, 37, 0.17, 3.54, 4.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.a', 'IM', 4.15, 37, 0.14, 3.86, 4.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '1.C.7.b', 'IM', 4.00, 37, 0.15, 3.69, 4.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.b', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.1.c', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.2.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.3.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.4.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.a', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.5.c', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.6', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '1.C.7.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.a', 'IM', 3.97, 45, 0.09, 3.80, 4.14, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.b', 'IM', 3.98, 45, 0.13, 3.71, 4.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.1.c', 'IM', 4.24, 44, 0.09, 4.07, 4.41, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.2.b', 'IM', 3.95, 45, 0.23, 3.48, 4.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.a', 'IM', 4.30, 45, 0.09, 4.11, 4.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.b', 'IM', 4.03, 45, 0.23, 3.57, 4.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.3.c', 'IM', 3.65, 45, 0.17, 3.31, 4.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.a', 'IM', 4.53, 44, 0.13, 4.28, 4.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.b', 'IM', 4.44, 45, 0.14, 4.15, 4.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.4.c', 'IM', 4.19, 45, 0.09, 4.02, 4.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.a', 'IM', 4.69, 45, 0.09, 4.50, 4.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.b', 'IM', 4.34, 45, 0.12, 4.11, 4.57, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.5.c', 'IM', 4.73, 45, 0.09, 4.54, 4.92, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.6', 'IM', 4.11, 45, 0.11, 3.89, 4.34, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.7.a', 'IM', 3.85, 45, 0.09, 3.66, 4.04, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '1.C.7.b', 'IM', 4.04, 45, 0.12, 3.80, 4.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.a', 'IM', 3.91, 26, 0.22, 3.45, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.b', 'IM', 4.03, 26, 0.17, 3.67, 4.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.1.c', 'IM', 4.36, 26, 0.15, 4.05, 4.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.2.b', 'IM', 4.15, 26, 0.29, 3.57, 4.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.a', 'IM', 4.33, 26, 0.18, 3.95, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.b', 'IM', 3.71, 26, 0.36, 2.98, 4.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.3.c', 'IM', 3.69, 26, 0.40, 2.88, 4.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.a', 'IM', 4.10, 26, 0.17, 3.75, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.b', 'IM', 4.16, 26, 0.22, 3.70, 4.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.4.c', 'IM', 4.19, 26, 0.12, 3.95, 4.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.a', 'IM', 4.54, 26, 0.13, 4.28, 4.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.b', 'IM', 4.67, 25, 0.13, 4.40, 4.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.5.c', 'IM', 4.67, 26, 0.13, 4.39, 4.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.6', 'IM', 3.80, 26, 0.18, 3.43, 4.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.a', 'IM', 3.70, 26, 0.20, 3.29, 4.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '1.C.7.b', 'IM', 4.25, 26, 0.17, 3.91, 4.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.a', 'IM', 4.06, 17, 0.12, 3.80, 4.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.b', 'IM', 3.92, 17, 0.07, 3.78, 4.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.1.c', 'IM', 4.07, 17, 0.07, 3.92, 4.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.2.b', 'IM', 4.47, 17, 0.10, 4.27, 4.68, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.a', 'IM', 4.47, 17, 0.09, 4.28, 4.66, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.b', 'IM', 4.31, 17, 0.22, 3.84, 4.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.3.c', 'IM', 3.99, 17, 0.27, 3.42, 4.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.a', 'IM', 4.09, 17, 0.28, 3.49, 4.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.b', 'IM', 4.20, 16, 0.13, 3.92, 4.47, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.4.c', 'IM', 4.16, 17, 0.11, 3.93, 4.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.a', 'IM', 4.33, 17, 0.17, 3.97, 4.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.b', 'IM', 4.68, 17, 0.11, 4.44, 4.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.5.c', 'IM', 4.55, 17, 0.25, 4.01, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.6', 'IM', 4.06, 17, 0.28, 3.48, 4.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.7.a', 'IM', 3.73, 17, 0.16, 3.40, 4.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', '1.C.7.b', 'IM', 4.19, 17, 0.12, 3.94, 4.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.a', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.1.c', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.2.b', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.a', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.b', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.3.c', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.a', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.4.c', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.a', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.b', 'IM', 4.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.5.c', 'IM', 5.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.6', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '1.C.7.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.a', 'IM', 4.56, 24, 0.17, 4.20, 4.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.b', 'IM', 4.52, 24, 0.17, 4.17, 4.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.1.c', 'IM', 4.49, 24, 0.21, 4.06, 4.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.2.b', 'IM', 3.99, 24, 0.23, 3.51, 4.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.a', 'IM', 4.15, 25, 0.15, 3.83, 4.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.b', 'IM', 3.04, 25, 0.14, 2.76, 3.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.3.c', 'IM', 3.08, 25, 0.20, 2.68, 3.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.a', 'IM', 4.06, 25, 0.14, 3.77, 4.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.b', 'IM', 4.61, 25, 0.13, 4.35, 4.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.4.c', 'IM', 3.75, 25, 0.18, 3.38, 4.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.a', 'IM', 4.50, 25, 0.16, 4.18, 4.82, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.b', 'IM', 4.39, 25, 0.12, 4.13, 4.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.5.c', 'IM', 4.92, 25, 0.05, 4.82, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.6', 'IM', 3.70, 25, 0.22, 3.24, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.7.a', 'IM', 3.35, 25, 0.13, 3.07, 3.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '1.C.7.b', 'IM', 4.79, 25, 0.09, 4.60, 4.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.a', 'IM', 4.12, 34, 0.08, 3.95, 4.28, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.b', 'IM', 4.19, 34, 0.10, 3.98, 4.40, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.1.c', 'IM', 4.31, 34, 0.13, 4.04, 4.57, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.2.b', 'IM', 4.49, 34, 0.15, 4.19, 4.80, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.a', 'IM', 4.29, 34, 0.13, 4.03, 4.55, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.b', 'IM', 4.10, 34, 0.15, 3.80, 4.40, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.3.c', 'IM', 3.61, 33, 0.14, 3.32, 3.91, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.a', 'IM', 4.28, 34, 0.20, 3.87, 4.69, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.b', 'IM', 4.25, 34, 0.13, 3.98, 4.53, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.4.c', 'IM', 4.34, 33, 0.17, 4.00, 4.69, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.a', 'IM', 4.43, 34, 0.12, 4.18, 4.69, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.b', 'IM', 4.72, 34, 0.08, 4.55, 4.89, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.5.c', 'IM', 4.48, 33, 0.11, 4.27, 4.70, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.6', 'IM', 4.04, 33, 0.15, 3.74, 4.35, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.a', 'IM', 3.75, 33, 0.19, 3.37, 4.13, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '1.C.7.b', 'IM', 4.09, 33, 0.20, 3.68, 4.51, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.a', 'IM', 3.94, 17, 0.18, 3.56, 4.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.b', 'IM', 3.92, 17, 0.21, 3.47, 4.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.1.c', 'IM', 4.74, 17, 0.14, 4.44, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.2.b', 'IM', 4.63, 17, 0.17, 4.27, 4.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.a', 'IM', 4.59, 17, 0.17, 4.22, 4.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.b', 'IM', 3.97, 17, 0.32, 3.30, 4.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.3.c', 'IM', 3.73, 17, 0.33, 3.03, 4.43, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.a', 'IM', 4.24, 17, 0.21, 3.78, 4.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.b', 'IM', 4.20, 16, 0.19, 3.80, 4.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.4.c', 'IM', 4.14, 17, 0.21, 3.70, 4.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.a', 'IM', 4.47, 16, 0.23, 3.98, 4.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.b', 'IM', 4.75, 17, 0.16, 4.42, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.5.c', 'IM', 4.83, 17, 0.13, 4.55, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.6', 'IM', 4.06, 17, 0.14, 3.76, 4.37, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.7.a', 'IM', 3.57, 17, 0.24, 3.05, 4.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '1.C.7.b', 'IM', 4.47, 17, 0.19, 4.06, 4.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.a', 'IM', 4.14, 21, 0.10, 3.92, 4.35, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.b', 'IM', 3.95, 21, 0.12, 3.71, 4.19, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.1.c', 'IM', 4.21, 21, 0.16, 3.88, 4.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.2.b', 'IM', 4.48, 21, 0.11, 4.24, 4.71, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.a', 'IM', 4.29, 21, 0.12, 4.05, 4.54, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.b', 'IM', 4.06, 21, 0.15, 3.75, 4.37, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.3.c', 'IM', 3.81, 21, 0.19, 3.42, 4.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.a', 'IM', 4.15, 20, 0.12, 3.90, 4.40, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.b', 'IM', 4.38, 21, 0.11, 4.15, 4.61, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.4.c', 'IM', 4.13, 21, 0.12, 3.89, 4.38, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.a', 'IM', 4.46, 21, 0.11, 4.22, 4.69, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.b', 'IM', 4.41, 21, 0.16, 4.07, 4.75, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.5.c', 'IM', 4.57, 21, 0.08, 4.40, 4.73, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.6', 'IM', 3.80, 21, 0.24, 3.30, 4.30, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.a', 'IM', 4.35, 21, 0.16, 4.02, 4.68, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '1.C.7.b', 'IM', 4.41, 21, 0.15, 4.09, 4.73, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.a', 'IM', 3.82, 23, 0.17, 3.46, 4.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.b', 'IM', 4.00, 23, 0.19, 3.60, 4.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.1.c', 'IM', 4.37, 23, 0.16, 4.03, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.2.b', 'IM', 4.46, 23, 0.15, 4.16, 4.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.a', 'IM', 4.15, 23, 0.13, 3.87, 4.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.b', 'IM', 3.66, 23, 0.20, 3.24, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.3.c', 'IM', 3.28, 23, 0.24, 2.79, 3.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.a', 'IM', 4.06, 23, 0.13, 3.78, 4.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.b', 'IM', 4.09, 23, 0.21, 3.64, 4.53, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.4.c', 'IM', 4.16, 23, 0.16, 3.83, 4.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.a', 'IM', 4.67, 23, 0.10, 4.47, 4.88, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.b', 'IM', 4.52, 23, 0.15, 4.21, 4.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.5.c', 'IM', 4.32, 23, 0.17, 3.97, 4.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.6', 'IM', 3.83, 23, 0.21, 3.38, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.7.a', 'IM', 4.06, 23, 0.20, 3.65, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '1.C.7.b', 'IM', 4.29, 23, 0.19, 3.90, 4.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.a', 'IM', 4.16, 21, 0.17, 3.80, 4.53, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.b', 'IM', 3.98, 21, 0.20, 3.56, 4.41, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.1.c', 'IM', 4.33, 21, 0.16, 4.00, 4.65, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.2.b', 'IM', 4.20, 21, 0.30, 3.58, 4.81, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.a', 'IM', 4.31, 21, 0.20, 3.91, 4.72, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.b', 'IM', 4.13, 21, 0.19, 3.72, 4.53, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.3.c', 'IM', 3.00, 21, 0.41, 2.16, 3.85, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.a', 'IM', 4.03, 21, 0.03, 3.97, 4.08, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.b', 'IM', 4.62, 21, 0.16, 4.29, 4.95, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.4.c', 'IM', 4.02, 21, 0.13, 3.75, 4.28, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.a', 'IM', 4.36, 21, 0.16, 4.03, 4.68, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.b', 'IM', 4.07, 20, 0.24, 3.57, 4.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.5.c', 'IM', 4.48, 21, 0.17, 4.13, 4.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.6', 'IM', 3.92, 21, 0.16, 3.59, 4.25, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.7.a', 'IM', 3.51, 21, 0.27, 2.95, 4.08, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '1.C.7.b', 'IM', 4.08, 21, 0.22, 3.63, 4.53, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.a', 'IM', 3.81, 29, 0.16, 3.49, 4.13, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.b', 'IM', 3.89, 29, 0.18, 3.52, 4.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.1.c', 'IM', 4.13, 29, 0.13, 3.86, 4.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.2.b', 'IM', 4.53, 29, 0.12, 4.29, 4.78, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.a', 'IM', 4.20, 27, 0.10, 4.00, 4.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.b', 'IM', 3.58, 27, 0.17, 3.22, 3.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.3.c', 'IM', 3.12, 27, 0.18, 2.76, 3.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.a', 'IM', 4.02, 27, 0.15, 3.72, 4.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.b', 'IM', 4.12, 27, 0.15, 3.80, 4.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.4.c', 'IM', 3.79, 26, 0.15, 3.48, 4.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.a', 'IM', 4.53, 27, 0.09, 4.35, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.b', 'IM', 4.47, 27, 0.09, 4.29, 4.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.5.c', 'IM', 4.34, 29, 0.12, 4.09, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.6', 'IM', 4.19, 29, 0.11, 3.97, 4.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.7.a', 'IM', 3.68, 29, 0.16, 3.34, 4.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '1.C.7.b', 'IM', 4.19, 29, 0.11, 3.97, 4.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.1.c', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.2.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.3.c', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.b', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.4.c', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.5.c', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.6', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.a', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '1.C.7.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.a', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.b', 'IM', 4.07, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.1.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.2.b', 'IM', 4.41, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.b', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.3.c', 'IM', 3.53, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.b', 'IM', 4.40, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.4.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.a', 'IM', 4.54, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.b', 'IM', 4.28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.5.c', 'IM', 4.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.6', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.7.a', 'IM', 3.74, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', '1.C.7.b', 'IM', 4.07, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.1.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.2.b', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.b', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.3.c', 'IM', 3.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.4.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.5.c', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.6', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.7.a', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.1.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.2.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.3.c', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.4.c', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.b', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.5.c', 'IM', 4.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.6', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '1.C.7.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.b', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.1.c', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.2.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.a', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.b', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.3.c', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.a', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.4.c', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.5.c', 'IM', 4.88, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.a', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '1.C.7.b', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.a', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.1.c', 'IM', 4.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.2.b', 'IM', 4.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.a', 'IM', 4.37, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.b', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.3.c', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.a', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.b', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.4.c', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.a', 'IM', 4.56, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.b', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.5.c', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.6', 'IM', 3.65, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '1.C.7.b', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.a', 'IM', 3.97, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.b', 'IM', 4.08, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.1.c', 'IM', 4.21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.2.b', 'IM', 4.18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.a', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.b', 'IM', 3.69, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.3.c', 'IM', 3.20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.a', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.b', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.4.c', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.a', 'IM', 4.53, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.b', 'IM', 4.18, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.5.c', 'IM', 4.39, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.6', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.7.a', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9013.00', '1.C.7.b', 'IM', 3.98, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.2.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.3.c', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.a', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.5.c', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.6', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.a', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '1.C.7.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.a', 'IM', 3.60, 27, 0.21, 3.17, 4.02, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.b', 'IM', 3.61, 27, 0.26, 3.08, 4.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.1.c', 'IM', 3.98, 27, 0.28, 3.40, 4.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.2.b', 'IM', 4.35, 27, 0.15, 4.04, 4.65, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.a', 'IM', 4.33, 26, 0.12, 4.08, 4.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.b', 'IM', 4.37, 27, 0.13, 4.10, 4.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.3.c', 'IM', 3.84, 27, 0.28, 3.26, 4.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.a', 'IM', 4.50, 27, 0.16, 4.18, 4.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.b', 'IM', 4.71, 27, 0.12, 4.47, 4.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.4.c', 'IM', 4.48, 27, 0.16, 4.15, 4.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.a', 'IM', 4.91, 27, 0.07, 4.77, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.b', 'IM', 4.39, 27, 0.26, 3.86, 4.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.5.c', 'IM', 4.69, 27, 0.18, 4.32, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.6', 'IM', 4.44, 27, 0.22, 3.99, 4.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.a', 'IM', 3.97, 27, 0.17, 3.63, 4.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '1.C.7.b', 'IM', 3.56, 27, 0.24, 3.06, 4.06, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.a', 'IM', 4.14, 26, 0.18, 3.77, 4.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.b', 'IM', 4.29, 26, 0.17, 3.93, 4.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.1.c', 'IM', 4.54, 26, 0.19, 4.15, 4.93, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.2.b', 'IM', 4.75, 26, 0.12, 4.50, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.a', 'IM', 4.37, 26, 0.16, 4.04, 4.70, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.b', 'IM', 4.43, 26, 0.19, 4.05, 4.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.3.c', 'IM', 3.97, 26, 0.34, 3.27, 4.66, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.a', 'IM', 4.55, 26, 0.14, 4.27, 4.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.b', 'IM', 4.20, 26, 0.19, 3.81, 4.59, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.4.c', 'IM', 4.32, 26, 0.18, 3.95, 4.69, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.a', 'IM', 4.75, 26, 0.11, 4.52, 4.98, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.b', 'IM', 4.12, 26, 0.21, 3.68, 4.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.5.c', 'IM', 4.87, 26, 0.09, 4.68, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.6', 'IM', 4.33, 26, 0.25, 3.82, 4.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.a', 'IM', 4.17, 26, 0.20, 3.77, 4.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '1.C.7.b', 'IM', 4.38, 26, 0.21, 3.95, 4.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.a', 'IM', 4.41, 40, 0.10, 4.22, 4.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.b', 'IM', 4.41, 40, 0.11, 4.19, 4.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.1.c', 'IM', 4.63, 40, 0.10, 4.43, 4.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.2.b', 'IM', 4.58, 40, 0.13, 4.31, 4.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.a', 'IM', 4.51, 40, 0.10, 4.31, 4.71, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.b', 'IM', 4.28, 40, 0.14, 3.99, 4.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.3.c', 'IM', 3.99, 40, 0.21, 3.57, 4.40, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.a', 'IM', 4.36, 40, 0.13, 4.10, 4.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.b', 'IM', 4.26, 40, 0.15, 3.96, 4.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.4.c', 'IM', 4.34, 40, 0.17, 4.01, 4.68, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.a', 'IM', 4.57, 40, 0.14, 4.29, 4.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.b', 'IM', 4.35, 40, 0.13, 4.08, 4.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.5.c', 'IM', 4.61, 40, 0.11, 4.38, 4.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.6', 'IM', 4.26, 39, 0.17, 3.91, 4.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.a', 'IM', 3.97, 40, 0.16, 3.64, 4.30, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '1.C.7.b', 'IM', 4.18, 40, 0.18, 3.81, 4.55, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.a', 'IM', 3.97, 23, 0.19, 3.59, 4.36, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.b', 'IM', 3.93, 23, 0.29, 3.33, 4.54, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.1.c', 'IM', 3.94, 23, 0.17, 3.58, 4.30, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.2.b', 'IM', 4.08, 23, 0.12, 3.83, 4.33, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.a', 'IM', 4.23, 23, 0.26, 3.70, 4.77, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.b', 'IM', 3.27, 22, 0.21, 2.84, 3.70, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.3.c', 'IM', 3.34, 23, 0.14, 3.05, 3.64, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.a', 'IM', 4.04, 23, 0.18, 3.67, 4.41, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.b', 'IM', 4.35, 23, 0.17, 3.99, 4.71, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.4.c', 'IM', 3.94, 23, 0.16, 3.60, 4.27, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.a', 'IM', 4.65, 23, 0.10, 4.44, 4.86, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.b', 'IM', 4.54, 23, 0.13, 4.28, 4.80, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.5.c', 'IM', 4.71, 23, 0.15, 4.39, 5.00, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.6', 'IM', 3.98, 23, 0.15, 3.67, 4.28, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.a', 'IM', 4.09, 23, 0.16, 3.75, 4.43, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '1.C.7.b', 'IM', 4.76, 23, 0.14, 4.48, 5.00, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.a', 'IM', 3.86, 33, 0.18, 3.50, 4.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.b', 'IM', 3.87, 33, 0.13, 3.61, 4.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.1.c', 'IM', 3.96, 33, 0.09, 3.78, 4.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.2.b', 'IM', 3.75, 32, 0.20, 3.33, 4.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.a', 'IM', 3.92, 33, 0.12, 3.67, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.b', 'IM', 3.47, 33, 0.22, 3.02, 3.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.3.c', 'IM', 3.18, 33, 0.28, 2.60, 3.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.a', 'IM', 3.81, 33, 0.24, 3.32, 4.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.b', 'IM', 3.99, 33, 0.12, 3.74, 4.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.4.c', 'IM', 4.53, 33, 0.19, 4.15, 4.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.a', 'IM', 4.37, 33, 0.16, 4.06, 4.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.b', 'IM', 4.08, 32, 0.18, 3.72, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.5.c', 'IM', 4.26, 33, 0.18, 3.88, 4.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.6', 'IM', 3.81, 33, 0.15, 3.51, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.7.a', 'IM', 3.70, 33, 0.21, 3.28, 4.12, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '1.C.7.b', 'IM', 4.42, 33, 0.17, 4.07, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.a', 'IM', 4.16, 30, 0.30, 3.54, 4.77, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.b', 'IM', 4.19, 29, 0.24, 3.70, 4.68, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.1.c', 'IM', 4.19, 30, 0.30, 3.58, 4.80, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.2.b', 'IM', 4.65, 30, 0.17, 4.31, 4.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.a', 'IM', 4.46, 30, 0.27, 3.91, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.b', 'IM', 4.35, 30, 0.26, 3.81, 4.89, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.3.c', 'IM', 4.03, 30, 0.28, 3.47, 4.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.a', 'IM', 4.54, 30, 0.18, 4.17, 4.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.b', 'IM', 4.44, 30, 0.26, 3.91, 4.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.4.c', 'IM', 4.05, 30, 0.36, 3.31, 4.79, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.a', 'IM', 4.67, 30, 0.16, 4.34, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.b', 'IM', 4.35, 30, 0.27, 3.80, 4.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.5.c', 'IM', 4.27, 30, 0.31, 3.63, 4.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.6', 'IM', 3.90, 30, 0.27, 3.35, 4.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.a', 'IM', 3.59, 30, 0.30, 2.97, 4.21, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '1.C.7.b', 'IM', 3.64, 30, 0.33, 2.97, 4.32, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.a', 'IM', 3.87, 30, 0.15, 3.57, 4.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.b', 'IM', 3.72, 30, 0.14, 3.42, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.1.c', 'IM', 4.10, 30, 0.13, 3.84, 4.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.2.b', 'IM', 4.55, 30, 0.11, 4.32, 4.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.a', 'IM', 4.25, 28, 0.07, 4.11, 4.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.b', 'IM', 4.03, 29, 0.18, 3.66, 4.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.3.c', 'IM', 3.95, 29, 0.17, 3.61, 4.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.a', 'IM', 4.44, 29, 0.17, 4.09, 4.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.b', 'IM', 4.42, 29, 0.15, 4.11, 4.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.4.c', 'IM', 4.38, 29, 0.12, 4.13, 4.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.a', 'IM', 4.56, 29, 0.12, 4.32, 4.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.b', 'IM', 4.29, 29, 0.15, 3.98, 4.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.5.c', 'IM', 4.58, 30, 0.14, 4.30, 4.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.6', 'IM', 3.93, 30, 0.17, 3.57, 4.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.a', 'IM', 3.71, 30, 0.19, 3.32, 4.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '1.C.7.b', 'IM', 3.77, 30, 0.17, 3.43, 4.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.a', 'IM', 4.53, 15, 0.19, 4.11, 4.94, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.b', 'IM', 4.90, 15, 0.09, 4.72, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.1.c', 'IM', 4.86, 14, 0.10, 4.64, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.2.b', 'IM', 4.53, 15, 0.33, 3.83, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.a', 'IM', 4.70, 15, 0.17, 4.33, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.b', 'IM', 4.34, 15, 0.17, 3.97, 4.70, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.3.c', 'IM', 4.49, 15, 0.33, 3.79, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.a', 'IM', 4.81, 15, 0.16, 4.45, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.b', 'IM', 4.73, 15, 0.17, 4.36, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.4.c', 'IM', 4.80, 15, 0.16, 4.45, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.a', 'IM', 4.92, 15, 0.08, 4.74, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.b', 'IM', 4.81, 15, 0.16, 4.46, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.5.c', 'IM', 4.72, 15, 0.17, 4.35, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.6', 'IM', 4.53, 15, 0.19, 4.12, 4.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.a', 'IM', 4.09, 15, 0.27, 3.51, 4.68, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '1.C.7.b', 'IM', 4.52, 15, 0.19, 4.11, 4.94, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.b', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.1.c', 'IM', 4.50, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.2.b', 'IM', 4.75, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.a', 'IM', 4.75, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.b', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.3.c', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.a', 'IM', 4.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.b', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.4.c', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.a', 'IM', 4.68, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.b', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.5.c', 'IM', 4.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.6', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.a', 'IM', 3.88, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '1.C.7.b', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.a', 'IM', 4.16, 25, 0.16, 3.83, 4.49, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.b', 'IM', 4.40, 25, 0.08, 4.23, 4.58, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.1.c', 'IM', 4.34, 25, 0.13, 4.07, 4.60, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.2.b', 'IM', 4.32, 25, 0.25, 3.80, 4.83, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.a', 'IM', 4.36, 25, 0.12, 4.12, 4.60, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.b', 'IM', 3.77, 25, 0.28, 3.18, 4.35, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.3.c', 'IM', 2.97, 25, 0.18, 2.60, 3.34, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.a', 'IM', 4.27, 25, 0.17, 3.93, 4.61, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.b', 'IM', 4.12, 24, 0.16, 3.78, 4.46, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.4.c', 'IM', 4.31, 25, 0.10, 4.11, 4.50, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.a', 'IM', 4.38, 25, 0.21, 3.96, 4.81, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.b', 'IM', 4.47, 25, 0.17, 4.11, 4.83, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.5.c', 'IM', 4.65, 25, 0.13, 4.39, 4.91, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.6', 'IM', 4.13, 25, 0.14, 3.83, 4.42, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.a', 'IM', 3.67, 25, 0.27, 3.11, 4.23, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '1.C.7.b', 'IM', 4.32, 25, 0.18, 3.93, 4.70, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.a', 'IM', 4.24, 19, 0.17, 3.90, 4.59, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.b', 'IM', 4.16, 19, 0.17, 3.81, 4.51, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.1.c', 'IM', 4.55, 19, 0.20, 4.14, 4.97, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.2.b', 'IM', 4.06, 19, 0.23, 3.59, 4.54, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.a', 'IM', 4.75, 19, 0.17, 4.39, 5.00, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.b', 'IM', 4.44, 19, 0.21, 4.00, 4.87, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.3.c', 'IM', 4.04, 19, 0.23, 3.55, 4.53, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.a', 'IM', 4.58, 19, 0.15, 4.27, 4.89, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.b', 'IM', 4.33, 19, 0.19, 3.93, 4.73, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.4.c', 'IM', 4.39, 19, 0.20, 3.97, 4.82, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.a', 'IM', 4.61, 19, 0.16, 4.29, 4.94, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.b', 'IM', 4.54, 19, 0.21, 4.10, 4.98, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.5.c', 'IM', 4.66, 19, 0.17, 4.31, 5.00, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.6', 'IM', 4.24, 19, 0.19, 3.84, 4.64, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.a', 'IM', 3.69, 19, 0.18, 3.30, 4.08, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '1.C.7.b', 'IM', 3.95, 19, 0.19, 3.54, 4.35, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.1.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.3.c', 'IM', 2.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.b', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.4.c', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.5.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.7.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '1.C.7.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.a', 'IM', 4.16, 29, 0.22, 3.71, 4.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.b', 'IM', 4.31, 29, 0.21, 3.88, 4.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.1.c', 'IM', 4.44, 29, 0.14, 4.15, 4.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.2.b', 'IM', 4.66, 29, 0.15, 4.35, 4.96, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.a', 'IM', 4.50, 28, 0.14, 4.22, 4.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.b', 'IM', 4.21, 28, 0.15, 3.90, 4.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.3.c', 'IM', 3.56, 28, 0.29, 2.97, 4.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.a', 'IM', 4.59, 28, 0.11, 4.36, 4.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.b', 'IM', 4.41, 28, 0.12, 4.15, 4.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.4.c', 'IM', 4.71, 28, 0.09, 4.52, 4.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.a', 'IM', 4.80, 28, 0.10, 4.60, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.b', 'IM', 4.47, 28, 0.17, 4.13, 4.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.5.c', 'IM', 4.66, 29, 0.15, 4.34, 4.97, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.6', 'IM', 4.08, 29, 0.16, 3.75, 4.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.a', 'IM', 3.77, 29, 0.21, 3.34, 4.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '1.C.7.b', 'IM', 4.06, 29, 0.30, 3.45, 4.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.1.c', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.2.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.3.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.4.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.a', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.5.c', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.6', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.a', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '1.C.7.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.a', 'IM', 4.43, 27, 0.14, 4.15, 4.71, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.b', 'IM', 4.49, 27, 0.12, 4.24, 4.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.1.c', 'IM', 4.71, 27, 0.10, 4.51, 4.90, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.2.b', 'IM', 4.85, 27, 0.06, 4.72, 4.98, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.a', 'IM', 4.52, 27, 0.11, 4.29, 4.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.b', 'IM', 4.47, 27, 0.13, 4.21, 4.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.3.c', 'IM', 4.25, 27, 0.14, 3.96, 4.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.a', 'IM', 4.67, 26, 0.09, 4.48, 4.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.b', 'IM', 4.59, 27, 0.12, 4.34, 4.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.4.c', 'IM', 4.72, 26, 0.11, 4.50, 4.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.a', 'IM', 4.75, 27, 0.12, 4.50, 4.99, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.b', 'IM', 4.34, 27, 0.15, 4.04, 4.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.5.c', 'IM', 4.85, 27, 0.08, 4.69, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.6', 'IM', 4.08, 27, 0.23, 3.61, 4.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.a', 'IM', 3.89, 27, 0.15, 3.57, 4.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '1.C.7.b', 'IM', 4.17, 27, 0.13, 3.90, 4.43, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.b', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.1.c', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.2.b', 'IM', 4.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.a', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.b', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.3.c', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.b', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.4.c', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.a', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.5.c', 'IM', 4.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.6', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.a', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '1.C.7.b', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.a', 'IM', 4.09, 18, 0.22, 3.62, 4.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.b', 'IM', 4.26, 18, 0.24, 3.74, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.1.c', 'IM', 4.11, 18, 0.22, 3.64, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.2.b', 'IM', 4.36, 18, 0.22, 3.90, 4.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.a', 'IM', 4.39, 18, 0.25, 3.87, 4.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.b', 'IM', 4.58, 18, 0.12, 4.32, 4.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.3.c', 'IM', 4.16, 18, 0.19, 3.76, 4.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.a', 'IM', 4.72, 18, 0.17, 4.36, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.b', 'IM', 4.73, 18, 0.16, 4.40, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.4.c', 'IM', 4.34, 18, 0.24, 3.84, 4.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.a', 'IM', 4.74, 18, 0.16, 4.40, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.b', 'IM', 4.87, 18, 0.12, 4.62, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.5.c', 'IM', 4.85, 18, 0.12, 4.61, 5.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.6', 'IM', 4.20, 18, 0.24, 3.70, 4.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.7.a', 'IM', 3.36, 18, 0.39, 2.55, 4.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '1.C.7.b', 'IM', 3.33, 18, 0.31, 2.67, 3.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.b', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.1.c', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.2.b', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.a', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.b', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.3.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.b', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.4.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.a', 'IM', 4.50, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.b', 'IM', 4.12, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.5.c', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.6', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.7.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '1.C.7.b', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.a', 'IM', 4.04, 21, 0.30, 3.43, 4.66, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.b', 'IM', 4.23, 21, 0.32, 3.55, 4.90, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.1.c', 'IM', 4.52, 21, 0.15, 4.21, 4.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.2.b', 'IM', 4.40, 21, 0.16, 4.07, 4.73, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.a', 'IM', 4.69, 21, 0.21, 4.26, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.b', 'IM', 4.53, 21, 0.15, 4.22, 4.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.3.c', 'IM', 3.87, 21, 0.36, 3.12, 4.62, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.a', 'IM', 4.43, 21, 0.41, 3.58, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.b', 'IM', 4.49, 21, 0.18, 4.13, 4.86, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.4.c', 'IM', 4.16, 21, 0.34, 3.45, 4.86, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.a', 'IM', 4.73, 21, 0.20, 4.31, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.b', 'IM', 4.41, 21, 0.29, 3.81, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.5.c', 'IM', 4.74, 21, 0.20, 4.32, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.6', 'IM', 4.01, 21, 0.30, 3.38, 4.65, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.7.a', 'IM', 4.03, 21, 0.30, 3.41, 4.66, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '1.C.7.b', 'IM', 3.88, 21, 0.46, 2.91, 4.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.a', 'IM', 3.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.b', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.1.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.2.b', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.b', 'IM', 3.14, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.3.c', 'IM', 3.07, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.a', 'IM', 4.07, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.b', 'IM', 4.36, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.4.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.a', 'IM', 4.46, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.b', 'IM', 4.79, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.5.c', 'IM', 4.86, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.6', 'IM', 3.50, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.a', 'IM', 3.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '1.C.7.b', 'IM', 4.25, 28, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.a', 'IM', 4.21, 23, 0.14, 3.93, 4.50, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.b', 'IM', 4.39, 24, 0.16, 4.06, 4.73, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.1.c', 'IM', 4.23, 24, 0.16, 3.91, 4.55, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.2.b', 'IM', 4.31, 24, 0.13, 4.04, 4.58, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.a', 'IM', 4.19, 23, 0.24, 3.70, 4.69, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.b', 'IM', 3.96, 24, 0.21, 3.53, 4.39, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.3.c', 'IM', 3.45, 24, 0.31, 2.82, 4.09, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.a', 'IM', 4.38, 23, 0.20, 3.97, 4.80, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.b', 'IM', 4.59, 24, 0.15, 4.28, 4.90, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.4.c', 'IM', 3.91, 24, 0.23, 3.44, 4.39, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.a', 'IM', 4.56, 24, 0.18, 4.19, 4.94, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.b', 'IM', 4.62, 24, 0.15, 4.31, 4.92, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.5.c', 'IM', 4.80, 24, 0.10, 4.58, 5.00, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.6', 'IM', 4.07, 24, 0.21, 3.63, 4.51, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.7.a', 'IM', 3.67, 24, 0.20, 3.27, 4.08, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '1.C.7.b', 'IM', 4.06, 24, 0.17, 3.70, 4.42, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.b', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.1.c', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.2.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.3.c', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.a', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.4.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.a', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.5.c', 'IM', 4.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.6', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.7.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '1.C.7.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.a', 'IM', 3.85, 20, 0.07, 3.70, 4.01, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.b', 'IM', 4.04, 20, 0.05, 3.93, 4.15, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.1.c', 'IM', 4.12, 20, 0.09, 3.93, 4.30, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.2.b', 'IM', 4.50, 20, 0.17, 4.15, 4.85, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.a', 'IM', 4.17, 20, 0.14, 3.88, 4.47, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.b', 'IM', 3.91, 20, 0.14, 3.61, 4.21, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.3.c', 'IM', 3.34, 20, 0.18, 2.97, 3.72, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.a', 'IM', 3.86, 20, 0.18, 3.48, 4.24, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.b', 'IM', 4.00, 20, 0.06, 3.88, 4.12, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.4.c', 'IM', 3.93, 20, 0.15, 3.62, 4.23, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.a', 'IM', 4.39, 20, 0.16, 4.06, 4.72, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.b', 'IM', 4.14, 20, 0.09, 3.95, 4.32, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.5.c', 'IM', 4.20, 20, 0.21, 3.76, 4.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.6', 'IM', 3.55, 20, 0.17, 3.20, 3.90, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.7.a', 'IM', 3.49, 20, 0.32, 2.82, 4.16, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '1.C.7.b', 'IM', 4.04, 20, 0.05, 3.93, 4.15, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.a', 'IM', 3.97, 16, 0.21, 3.52, 4.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.b', 'IM', 4.28, 16, 0.14, 3.99, 4.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.1.c', 'IM', 4.13, 16, 0.22, 3.67, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.2.b', 'IM', 4.09, 16, 0.26, 3.53, 4.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.a', 'IM', 4.07, 15, 0.18, 3.69, 4.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.b', 'IM', 3.30, 16, 0.18, 2.90, 3.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.3.c', 'IM', 3.39, 16, 0.25, 2.87, 3.92, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.a', 'IM', 3.77, 16, 0.23, 3.27, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.b', 'IM', 4.08, 16, 0.23, 3.59, 4.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.4.c', 'IM', 4.08, 16, 0.24, 3.58, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.a', 'IM', 4.07, 16, 0.23, 3.57, 4.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.b', 'IM', 4.25, 16, 0.16, 3.90, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.5.c', 'IM', 4.15, 16, 0.26, 3.58, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.6', 'IM', 3.60, 16, 0.20, 3.17, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.7.a', 'IM', 3.47, 16, 0.19, 3.07, 3.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '1.C.7.b', 'IM', 3.79, 16, 0.23, 3.29, 4.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.1.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.2.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.3.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.4.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.b', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.6', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.7.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '1.C.7.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.a', 'IM', 4.00, 21, 0.21, 3.57, 4.43, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.b', 'IM', 4.58, 22, 0.16, 4.26, 4.91, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.1.c', 'IM', 4.41, 22, 0.15, 4.09, 4.73, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.2.b', 'IM', 3.64, 22, 0.29, 3.04, 4.23, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.a', 'IM', 4.22, 22, 0.18, 3.85, 4.59, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.b', 'IM', 3.71, 22, 0.21, 3.27, 4.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.3.c', 'IM', 3.78, 22, 0.22, 3.33, 4.24, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.a', 'IM', 3.76, 22, 0.28, 3.19, 4.34, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.b', 'IM', 3.67, 22, 0.21, 3.23, 4.11, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.4.c', 'IM', 3.90, 22, 0.16, 3.56, 4.23, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.a', 'IM', 4.34, 22, 0.23, 3.85, 4.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.b', 'IM', 4.32, 22, 0.14, 4.04, 4.61, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.5.c', 'IM', 4.37, 22, 0.26, 3.82, 4.91, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.6', 'IM', 3.74, 22, 0.19, 3.35, 4.13, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.a', 'IM', 3.65, 22, 0.21, 3.21, 4.08, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '1.C.7.b', 'IM', 3.41, 22, 0.19, 3.00, 3.81, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.a', 'IM', 4.05, 20, 0.15, 3.74, 4.37, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.b', 'IM', 3.78, 20, 0.19, 3.38, 4.17, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.1.c', 'IM', 4.26, 19, 0.13, 3.99, 4.53, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.2.b', 'IM', 3.93, 19, 0.17, 3.56, 4.29, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.a', 'IM', 4.02, 20, 0.17, 3.66, 4.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.b', 'IM', 3.56, 20, 0.15, 3.24, 3.88, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.3.c', 'IM', 3.59, 20, 0.36, 2.83, 4.34, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.a', 'IM', 3.85, 20, 0.20, 3.43, 4.27, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.b', 'IM', 4.69, 20, 0.11, 4.46, 4.91, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.4.c', 'IM', 3.86, 20, 0.27, 3.29, 4.44, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.a', 'IM', 4.61, 20, 0.12, 4.37, 4.86, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.b', 'IM', 4.60, 20, 0.15, 4.29, 4.91, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.5.c', 'IM', 4.59, 20, 0.18, 4.22, 4.96, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.6', 'IM', 3.70, 20, 0.31, 3.05, 4.34, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.a', 'IM', 3.08, 20, 0.22, 2.62, 3.53, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '1.C.7.b', 'IM', 4.27, 20, 0.20, 3.85, 4.69, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.a', 'IM', 3.81, 29, 0.19, 3.43, 4.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.b', 'IM', 3.93, 29, 0.10, 3.74, 4.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.1.c', 'IM', 4.03, 29, 0.14, 3.74, 4.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.2.b', 'IM', 3.68, 29, 0.19, 3.28, 4.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.a', 'IM', 4.47, 29, 0.17, 4.11, 4.82, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.b', 'IM', 3.73, 29, 0.22, 3.26, 4.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.3.c', 'IM', 3.72, 28, 0.31, 3.09, 4.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.a', 'IM', 3.79, 29, 0.19, 3.41, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.b', 'IM', 4.09, 29, 0.12, 3.85, 4.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.4.c', 'IM', 4.37, 29, 0.18, 3.99, 4.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.a', 'IM', 4.35, 29, 0.19, 3.96, 4.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.b', 'IM', 4.17, 29, 0.09, 3.99, 4.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.5.c', 'IM', 4.17, 29, 0.29, 3.58, 4.76, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.6', 'IM', 3.85, 29, 0.23, 3.38, 4.32, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.a', 'IM', 3.58, 29, 0.28, 3.01, 4.14, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '1.C.7.b', 'IM', 3.83, 29, 0.17, 3.48, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.1.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.2.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.3.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.4.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.a', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.5.c', 'IM', 4.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.a', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '1.C.7.b', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.a', 'IM', 4.43, 40, 0.11, 4.20, 4.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.b', 'IM', 4.40, 40, 0.17, 4.04, 4.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.1.c', 'IM', 4.53, 40, 0.14, 4.24, 4.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.2.b', 'IM', 3.93, 40, 0.17, 3.59, 4.26, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.a', 'IM', 4.41, 40, 0.17, 4.07, 4.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.b', 'IM', 4.25, 40, 0.23, 3.79, 4.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.3.c', 'IM', 3.78, 40, 0.25, 3.27, 4.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.a', 'IM', 4.38, 40, 0.19, 4.00, 4.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.b', 'IM', 4.65, 40, 0.10, 4.44, 4.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.4.c', 'IM', 4.40, 40, 0.14, 4.11, 4.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.a', 'IM', 4.61, 40, 0.12, 4.37, 4.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.b', 'IM', 4.57, 40, 0.12, 4.32, 4.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.5.c', 'IM', 4.63, 40, 0.11, 4.42, 4.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.6', 'IM', 4.44, 40, 0.13, 4.18, 4.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.7.a', 'IM', 3.75, 40, 0.19, 3.36, 4.13, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1031.00', '1.C.7.b', 'IM', 4.21, 40, 0.14, 3.93, 4.49, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.a', 'IM', 3.70, 16, 0.12, 3.45, 3.96, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.b', 'IM', 3.66, 16, 0.19, 3.26, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.1.c', 'IM', 4.03, 16, 0.21, 3.57, 4.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.2.b', 'IM', 3.13, 16, 0.22, 2.67, 3.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.a', 'IM', 3.62, 16, 0.51, 2.53, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.b', 'IM', 3.95, 16, 0.18, 3.57, 4.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.3.c', 'IM', 3.13, 16, 0.23, 2.63, 3.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.a', 'IM', 3.98, 16, 0.27, 3.40, 4.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.b', 'IM', 3.85, 16, 0.22, 3.38, 4.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.4.c', 'IM', 3.59, 16, 0.21, 3.14, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.a', 'IM', 3.89, 16, 0.15, 3.56, 4.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.b', 'IM', 4.19, 16, 0.15, 3.88, 4.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.5.c', 'IM', 4.56, 16, 0.25, 4.04, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.6', 'IM', 3.88, 16, 0.13, 3.62, 4.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.a', 'IM', 2.99, 16, 0.37, 2.20, 3.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '1.C.7.b', 'IM', 3.12, 16, 0.39, 2.28, 3.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.a', 'IM', 3.94, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.b', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.1.c', 'IM', 4.16, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.2.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.b', 'IM', 4.04, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.3.c', 'IM', 3.64, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.a', 'IM', 4.09, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.b', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.4.c', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.a', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.b', 'IM', 4.29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.5.c', 'IM', 4.46, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.6', 'IM', 4.37, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.7.a', 'IM', 3.34, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.00', '1.C.7.b', 'IM', 4.23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.b', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.3.c', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.4.c', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.a', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '1.C.7.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.a', 'IM', 3.85, 33, 0.13, 3.59, 4.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.b', 'IM', 4.04, 33, 0.13, 3.77, 4.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.1.c', 'IM', 4.15, 33, 0.15, 3.84, 4.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.2.b', 'IM', 3.74, 33, 0.23, 3.28, 4.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.a', 'IM', 4.19, 33, 0.12, 3.95, 4.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.b', 'IM', 4.11, 33, 0.20, 3.69, 4.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.3.c', 'IM', 3.25, 33, 0.15, 2.95, 3.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.a', 'IM', 4.40, 33, 0.11, 4.16, 4.63, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.b', 'IM', 4.38, 32, 0.16, 4.05, 4.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.4.c', 'IM', 3.89, 33, 0.25, 3.39, 4.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.a', 'IM', 4.47, 33, 0.09, 4.27, 4.66, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.b', 'IM', 4.56, 33, 0.10, 4.36, 4.76, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.5.c', 'IM', 4.72, 33, 0.10, 4.51, 4.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.6', 'IM', 4.03, 33, 0.21, 3.61, 4.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.a', 'IM', 3.13, 33, 0.27, 2.58, 3.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '1.C.7.b', 'IM', 4.48, 33, 0.12, 4.23, 4.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.a', 'IM', 3.65, 16, 0.10, 3.44, 3.85, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.b', 'IM', 3.91, 17, 0.09, 3.73, 4.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.1.c', 'IM', 3.76, 17, 0.20, 3.34, 4.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.2.b', 'IM', 3.64, 17, 0.38, 2.83, 4.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.a', 'IM', 4.51, 17, 0.30, 3.87, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.b', 'IM', 4.04, 17, 0.19, 3.64, 4.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.3.c', 'IM', 3.18, 17, 0.13, 2.91, 3.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.a', 'IM', 4.37, 17, 0.21, 3.92, 4.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.b', 'IM', 4.25, 17, 0.29, 3.65, 4.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.4.c', 'IM', 4.37, 17, 0.21, 3.92, 4.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.a', 'IM', 4.52, 17, 0.14, 4.21, 4.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.b', 'IM', 4.33, 17, 0.13, 4.05, 4.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.5.c', 'IM', 4.65, 17, 0.23, 4.17, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.6', 'IM', 4.18, 17, 0.37, 3.39, 4.96, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.a', 'IM', 3.43, 17, 0.40, 2.59, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '1.C.7.b', 'IM', 3.81, 17, 0.26, 3.25, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.a', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.2.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.a', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.3.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.a', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.4.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.a', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.5.c', 'IM', 5.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.6', 'IM', 4.16, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.a', 'IM', 3.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '1.C.7.b', 'IM', 4.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.1.c', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.2.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.b', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.3.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.a', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.4.c', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.a', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '1.C.7.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.1.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.2.b', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.3.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.a', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.5.c', 'IM', 4.61, 18, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.6', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.7.a', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '1.C.7.b', 'IM', 3.68, 19, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.2.b', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.b', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.3.c', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.b', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.6', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '1.C.7.b', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.a', 'IM', 3.72, 40, 0.17, 3.38, 4.06, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.b', 'IM', 3.85, 41, 0.13, 3.59, 4.12, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.1.c', 'IM', 3.94, 41, 0.10, 3.74, 4.15, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.2.b', 'IM', 4.04, 41, 0.31, 3.42, 4.66, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.a', 'IM', 4.59, 41, 0.17, 4.25, 4.92, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.b', 'IM', 4.37, 41, 0.21, 3.95, 4.80, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.3.c', 'IM', 4.13, 41, 0.27, 3.58, 4.68, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.a', 'IM', 4.51, 41, 0.17, 4.17, 4.86, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.b', 'IM', 4.45, 41, 0.19, 4.06, 4.84, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.4.c', 'IM', 4.43, 41, 0.18, 4.06, 4.80, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.a', 'IM', 4.49, 41, 0.17, 4.14, 4.85, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.b', 'IM', 4.57, 41, 0.17, 4.23, 4.92, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.5.c', 'IM', 4.63, 41, 0.15, 4.32, 4.94, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.6', 'IM', 4.22, 41, 0.22, 3.78, 4.67, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.a', 'IM', 3.75, 41, 0.36, 3.02, 4.47, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '1.C.7.b', 'IM', 4.03, 41, 0.31, 3.41, 4.64, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.a', 'IM', 4.03, 13, 0.26, 3.46, 4.60, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.b', 'IM', 3.88, 13, 0.32, 3.20, 4.57, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.1.c', 'IM', 3.89, 13, 0.32, 3.20, 4.58, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.2.b', 'IM', 3.80, 13, 0.21, 3.33, 4.26, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.a', 'IM', 3.98, 13, 0.30, 3.32, 4.64, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.b', 'IM', 3.88, 13, 0.32, 3.19, 4.57, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.3.c', 'IM', 3.40, 13, 0.68, 1.91, 4.89, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.a', 'IM', 3.65, 13, 0.49, 2.57, 4.72, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.b', 'IM', 3.40, 13, 0.48, 2.35, 4.44, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.4.c', 'IM', 3.40, 13, 0.48, 2.36, 4.44, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.a', 'IM', 4.16, 13, 0.36, 3.38, 4.95, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.b', 'IM', 3.75, 13, 0.35, 2.98, 4.51, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.5.c', 'IM', 4.16, 13, 0.36, 3.37, 4.95, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.6', 'IM', 3.40, 13, 0.48, 2.35, 4.44, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.a', 'IM', 2.97, 13, 0.44, 2.02, 3.92, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '1.C.7.b', 'IM', 3.31, 13, 0.49, 2.24, 4.38, 'N', TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.b', 'IM', 4.37, 19, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.1.c', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.2.b', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.3.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.4.c', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.a', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.b', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.7.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '1.C.7.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.a', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.b', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.1.c', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.2.b', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.3.c', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.a', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.b', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.a', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.b', 'IM', 4.46, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.5.c', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.a', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '1.C.7.b', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.2.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.3.c', 'IM', 2.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.a', 'IM', 4.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.5.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.6', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.1.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.2.b', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.3.c', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.b', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.4.c', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.5.c', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.a', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '1.C.7.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.1.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.2.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.a', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.3.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.4.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.a', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.5.c', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.6', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '1.C.7.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.a', 'IM', 4.02, 24, 0.33, 3.34, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.b', 'IM', 4.19, 24, 0.11, 3.97, 4.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.1.c', 'IM', 4.33, 24, 0.26, 3.80, 4.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.2.b', 'IM', 4.01, 24, 0.16, 3.68, 4.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.a', 'IM', 4.73, 24, 0.13, 4.48, 4.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.b', 'IM', 4.24, 24, 0.27, 3.68, 4.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.3.c', 'IM', 4.37, 24, 0.21, 3.94, 4.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.a', 'IM', 4.63, 24, 0.14, 4.34, 4.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.b', 'IM', 4.79, 24, 0.10, 4.58, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.4.c', 'IM', 4.71, 24, 0.13, 4.44, 4.97, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.a', 'IM', 4.87, 24, 0.07, 4.73, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.b', 'IM', 4.90, 24, 0.06, 4.77, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.5.c', 'IM', 4.45, 24, 0.19, 4.06, 4.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.6', 'IM', 4.01, 24, 0.11, 3.78, 4.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.a', 'IM', 4.07, 24, 0.31, 3.44, 4.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '1.C.7.b', 'IM', 3.81, 24, 0.13, 3.55, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.b', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.1.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.2.b', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.a', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.3.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.b', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.a', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.5.c', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.6', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.7.a', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '1.C.7.b', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.a', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.1.c', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.2.b', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.b', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.3.c', 'IM', 3.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.a', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.b', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.4.c', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.a', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.b', 'IM', 4.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.5.c', 'IM', 4.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.6', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '1.C.7.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.1.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.2.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.3.c', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.4.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.6', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.a', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '1.C.7.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.1.c', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.2.b', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.b', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.3.c', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.a', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.4.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.a', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.b', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.6', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '1.C.7.b', 'IM', 4.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.a', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.b', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.1.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.2.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.b', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.3.c', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.a', 'IM', 3.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.b', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.4.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.a', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.b', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.5.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.6', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.2.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.3.c', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.4.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.a', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.5.c', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.b', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.1.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.2.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.3.c', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.4.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.5.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.6', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.7.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '1.C.7.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.a', 'IM', 3.77, 22, 0.19, 3.37, 4.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.b', 'IM', 4.14, 22, 0.19, 3.75, 4.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.1.c', 'IM', 4.31, 22, 0.14, 4.01, 4.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.2.b', 'IM', 3.70, 22, 0.22, 3.23, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.a', 'IM', 3.90, 22, 0.21, 3.46, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.b', 'IM', 3.53, 22, 0.27, 2.98, 4.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.3.c', 'IM', 3.20, 22, 0.28, 2.62, 3.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.a', 'IM', 3.64, 22, 0.22, 3.19, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.b', 'IM', 3.60, 22, 0.24, 3.10, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.4.c', 'IM', 3.99, 22, 0.16, 3.65, 4.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.a', 'IM', 4.38, 22, 0.17, 4.03, 4.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.b', 'IM', 4.45, 22, 0.16, 4.12, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.5.c', 'IM', 4.12, 22, 0.15, 3.81, 4.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.6', 'IM', 3.98, 22, 0.23, 3.51, 4.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.7.a', 'IM', 3.82, 22, 0.21, 3.37, 4.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '1.C.7.b', 'IM', 3.92, 22, 0.19, 3.52, 4.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.a', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.b', 'IM', 4.06, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.1.c', 'IM', 4.08, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.2.b', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.b', 'IM', 3.26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.3.c', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.a', 'IM', 3.90, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.b', 'IM', 4.10, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.4.c', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.a', 'IM', 4.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.b', 'IM', 4.88, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.5.c', 'IM', 4.89, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.6', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.7.a', 'IM', 3.07, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2011.00', '1.C.7.b', 'IM', 4.44, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.a', 'IM', 3.62, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.1.c', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.2.b', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.a', 'IM', 3.72, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.b', 'IM', 3.19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.3.c', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.a', 'IM', 3.66, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.b', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.4.c', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.a', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.b', 'IM', 4.43, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.5.c', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.6', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.7.a', 'IM', 2.80, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2023.00', '1.C.7.b', 'IM', 3.97, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.a', 'IM', 3.70, 35, 0.13, 3.44, 3.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.b', 'IM', 3.93, 35, 0.17, 3.59, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.1.c', 'IM', 4.02, 35, 0.19, 3.63, 4.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.2.b', 'IM', 3.40, 35, 0.31, 2.77, 4.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.a', 'IM', 4.22, 34, 0.12, 3.97, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.b', 'IM', 3.40, 34, 0.21, 2.97, 3.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.3.c', 'IM', 3.61, 34, 0.11, 3.39, 3.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.a', 'IM', 4.02, 34, 0.20, 3.60, 4.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.b', 'IM', 4.20, 34, 0.14, 3.92, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.4.c', 'IM', 3.87, 34, 0.29, 3.29, 4.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.a', 'IM', 4.58, 34, 0.08, 4.42, 4.75, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.b', 'IM', 4.75, 34, 0.06, 4.63, 4.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.5.c', 'IM', 4.81, 35, 0.08, 4.64, 4.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.6', 'IM', 4.05, 34, 0.05, 3.95, 4.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.a', 'IM', 3.02, 35, 0.13, 2.75, 3.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '1.C.7.b', 'IM', 4.59, 35, 0.11, 4.37, 4.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.1.c', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.2.b', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.b', 'IM', 2.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.3.c', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.a', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.5.c', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.6', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.a', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '1.C.7.b', 'IM', 4.89, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.a', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.1.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.2.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.3.c', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.b', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.4.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.a', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.5.c', 'IM', 5.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.6', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.a', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '1.C.7.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.a', 'IM', 4.07, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.b', 'IM', 3.73, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.1.c', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.2.b', 'IM', 2.82, 28, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.a', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.b', 'IM', 2.93, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.3.c', 'IM', 2.80, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.a', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.b', 'IM', 4.03, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.4.c', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.a', 'IM', 4.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.b', 'IM', 4.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.5.c', 'IM', 4.80, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.6', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.a', 'IM', 2.70, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2053.00', '1.C.7.b', 'IM', 4.57, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.b', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.1.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.2.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.b', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.3.c', 'IM', 3.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.5.c', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.6', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.a', 'IM', 2.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2061.00', '1.C.7.b', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.a', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.b', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.1.c', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.2.b', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.a', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.3.c', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.a', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.b', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.4.c', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.a', 'IM', 4.76, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.b', 'IM', 4.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.5.c', 'IM', 4.96, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.6', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.7.a', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2071.00', '1.C.7.b', 'IM', 4.32, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.a', 'IM', 3.75, 22, 0.22, 3.29, 4.20, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.b', 'IM', 3.85, 22, 0.14, 3.57, 4.13, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.1.c', 'IM', 3.98, 22, 0.11, 3.75, 4.22, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.2.b', 'IM', 3.63, 22, 0.15, 3.31, 3.95, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.a', 'IM', 4.15, 22, 0.20, 3.72, 4.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.b', 'IM', 3.67, 22, 0.21, 3.23, 4.11, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.3.c', 'IM', 3.53, 22, 0.14, 3.24, 3.82, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.a', 'IM', 3.87, 22, 0.20, 3.45, 4.30, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.b', 'IM', 3.98, 22, 0.21, 3.55, 4.41, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.4.c', 'IM', 3.99, 21, 0.19, 3.59, 4.38, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.a', 'IM', 4.36, 22, 0.19, 3.95, 4.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.b', 'IM', 4.09, 22, 0.18, 3.72, 4.46, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.5.c', 'IM', 4.66, 22, 0.20, 4.25, 5.00, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.6', 'IM', 3.81, 22, 0.26, 3.26, 4.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.a', 'IM', 3.01, 22, 0.13, 2.73, 3.29, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2072.00', '1.C.7.b', 'IM', 3.92, 22, 0.17, 3.57, 4.28, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.a', 'IM', 3.64, 23, 0.29, 3.04, 4.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.b', 'IM', 3.68, 23, 0.25, 3.17, 4.19, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.1.c', 'IM', 4.03, 23, 0.22, 3.57, 4.48, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.2.b', 'IM', 3.57, 23, 0.12, 3.33, 3.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.a', 'IM', 4.28, 23, 0.28, 3.71, 4.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.b', 'IM', 3.88, 23, 0.37, 3.12, 4.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.3.c', 'IM', 3.38, 23, 0.30, 2.76, 4.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.a', 'IM', 4.42, 23, 0.22, 3.97, 4.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.b', 'IM', 4.32, 23, 0.21, 3.87, 4.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.4.c', 'IM', 3.86, 23, 0.21, 3.42, 4.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.a', 'IM', 4.54, 23, 0.16, 4.21, 4.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.b', 'IM', 4.64, 23, 0.18, 4.26, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.5.c', 'IM', 4.66, 23, 0.11, 4.43, 4.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.6', 'IM', 4.38, 23, 0.24, 3.88, 4.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.a', 'IM', 3.38, 23, 0.21, 2.94, 3.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2081.00', '1.C.7.b', 'IM', 4.28, 23, 0.14, 3.98, 4.57, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.1.c', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.2.b', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.3.c', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.4.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.b', 'IM', 4.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.5.c', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.a', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2082.00', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.b', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.1.c', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.2.b', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.b', 'IM', 2.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.3.c', 'IM', 2.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.b', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.a', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.b', 'IM', 4.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.6', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.7.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.01', '1.C.7.b', 'IM', 4.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.a', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.b', 'IM', 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.1.c', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.2.b', 'IM', 3.76, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.a', 'IM', 4.12, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.b', 'IM', 3.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.3.c', 'IM', 3.36, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.a', 'IM', 4.36, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.b', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.4.c', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.a', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.b', 'IM', 4.68, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.5.c', 'IM', 4.96, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.6', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.a', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2099.04', '1.C.7.b', 'IM', 4.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.a', 'IM', 3.76, 37, 0.14, 3.48, 4.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.b', 'IM', 4.07, 37, 0.12, 3.84, 4.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.1.c', 'IM', 4.05, 37, 0.08, 3.89, 4.22, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.2.b', 'IM', 3.49, 37, 0.11, 3.27, 3.70, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.a', 'IM', 4.33, 37, 0.11, 4.11, 4.56, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.b', 'IM', 3.56, 37, 0.17, 3.21, 3.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.3.c', 'IM', 3.49, 37, 0.26, 2.96, 4.03, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.a', 'IM', 4.12, 37, 0.16, 3.80, 4.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.b', 'IM', 4.29, 36, 0.18, 3.93, 4.65, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.4.c', 'IM', 4.50, 37, 0.17, 4.16, 4.85, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.a', 'IM', 4.51, 37, 0.15, 4.21, 4.81, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.b', 'IM', 4.55, 37, 0.16, 4.22, 4.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.5.c', 'IM', 4.50, 37, 0.15, 4.21, 4.80, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.6', 'IM', 3.71, 37, 0.14, 3.43, 3.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.7.a', 'IM', 3.72, 37, 0.10, 3.51, 3.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.00', '1.C.7.b', 'IM', 4.71, 37, 0.12, 4.45, 4.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.1.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.2.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.3.c', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.b', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.4.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.5.c', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.6', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.7.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1211.01', '1.C.7.b', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.a', 'IM', 3.98, 26, 0.14, 3.71, 4.26, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.b', 'IM', 4.04, 26, 0.18, 3.67, 4.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.1.c', 'IM', 4.20, 26, 0.16, 3.86, 4.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.2.b', 'IM', 3.90, 26, 0.21, 3.47, 4.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.a', 'IM', 4.28, 26, 0.17, 3.93, 4.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.b', 'IM', 3.66, 26, 0.21, 3.24, 4.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.3.c', 'IM', 3.37, 26, 0.20, 2.96, 3.78, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.a', 'IM', 4.04, 25, 0.20, 3.63, 4.46, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.b', 'IM', 3.92, 26, 0.22, 3.47, 4.37, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.4.c', 'IM', 4.22, 25, 0.17, 3.87, 4.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.a', 'IM', 4.53, 26, 0.12, 4.29, 4.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.b', 'IM', 4.55, 25, 0.12, 4.30, 4.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.5.c', 'IM', 4.53, 26, 0.12, 4.28, 4.78, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.6', 'IM', 3.88, 26, 0.16, 3.55, 4.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.7.a', 'IM', 3.70, 26, 0.16, 3.38, 4.02, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1212.00', '1.C.7.b', 'IM', 4.44, 26, 0.11, 4.21, 4.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.a', 'IM', 3.97, 16, 0.23, 3.47, 4.47, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.b', 'IM', 3.71, 16, 0.23, 3.21, 4.21, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.1.c', 'IM', 3.95, 16, 0.24, 3.44, 4.45, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.2.b', 'IM', 3.60, 16, 0.40, 2.74, 4.45, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.a', 'IM', 4.17, 16, 0.16, 3.83, 4.51, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.b', 'IM', 3.23, 16, 0.23, 2.74, 3.72, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.3.c', 'IM', 3.06, 16, 0.22, 2.59, 3.54, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.a', 'IM', 3.01, 16, 0.18, 2.63, 3.39, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.b', 'IM', 3.62, 16, 0.26, 3.07, 4.17, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.4.c', 'IM', 3.88, 16, 0.25, 3.35, 4.41, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.a', 'IM', 3.72, 16, 0.31, 3.06, 4.38, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.b', 'IM', 4.05, 16, 0.19, 3.63, 4.46, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.5.c', 'IM', 3.90, 16, 0.23, 3.41, 4.40, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.6', 'IM', 4.01, 16, 0.18, 3.62, 4.41, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.7.a', 'IM', 3.92, 16, 0.18, 3.54, 4.31, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1221.00', '1.C.7.b', 'IM', 4.61, 16, 0.15, 4.30, 4.92, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.a', 'IM', 3.80, 37, 0.23, 3.35, 4.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.b', 'IM', 4.15, 37, 0.15, 3.84, 4.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.1.c', 'IM', 4.23, 37, 0.19, 3.85, 4.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.2.b', 'IM', 3.85, 37, 0.24, 3.37, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.a', 'IM', 4.54, 38, 0.14, 4.25, 4.82, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.b', 'IM', 3.64, 38, 0.21, 3.22, 4.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.3.c', 'IM', 3.59, 38, 0.14, 3.30, 3.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.a', 'IM', 4.23, 38, 0.15, 3.92, 4.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.b', 'IM', 4.25, 38, 0.21, 3.82, 4.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.4.c', 'IM', 4.31, 38, 0.16, 3.98, 4.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.a', 'IM', 4.45, 38, 0.22, 4.00, 4.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.b', 'IM', 4.48, 38, 0.19, 4.09, 4.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.5.c', 'IM', 4.36, 38, 0.29, 3.78, 4.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.6', 'IM', 3.98, 38, 0.24, 3.49, 4.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.7.a', 'IM', 3.88, 37, 0.17, 3.52, 4.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1231.00', '1.C.7.b', 'IM', 4.51, 38, 0.16, 4.19, 4.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.a', 'IM', 3.79, 48, 0.15, 3.49, 4.09, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.b', 'IM', 3.94, 48, 0.34, 3.25, 4.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.1.c', 'IM', 4.12, 48, 0.28, 3.56, 4.68, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.2.b', 'IM', 3.74, 48, 0.40, 2.93, 4.54, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.a', 'IM', 4.42, 46, 0.23, 3.96, 4.87, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.b', 'IM', 4.09, 47, 0.26, 3.55, 4.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.3.c', 'IM', 3.30, 47, 0.53, 2.24, 4.36, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.a', 'IM', 4.17, 47, 0.28, 3.60, 4.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.b', 'IM', 4.25, 47, 0.29, 3.66, 4.83, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.4.c', 'IM', 4.16, 47, 0.26, 3.63, 4.68, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.a', 'IM', 4.66, 47, 0.12, 4.42, 4.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.b', 'IM', 4.70, 46, 0.10, 4.49, 4.91, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.5.c', 'IM', 4.24, 47, 0.26, 3.73, 4.76, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.6', 'IM', 4.12, 47, 0.27, 3.58, 4.67, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.7.a', 'IM', 3.39, 47, 0.49, 2.41, 4.36, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1232.00', '1.C.7.b', 'IM', 4.38, 46, 0.21, 3.95, 4.81, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.1.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.b', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.3.c', 'IM', 2.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.b', 'IM', 4.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.5.c', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.6', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.00', '1.C.7.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.1.c', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.2.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.3.c', 'IM', 3.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.a', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.b', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.4.c', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.a', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.6', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.7.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1241.01', '1.C.7.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.a', 'IM', 4.01, 17, 0.26, 3.47, 4.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.b', 'IM', 4.19, 17, 0.20, 3.76, 4.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.1.c', 'IM', 4.08, 17, 0.26, 3.52, 4.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.2.b', 'IM', 3.73, 17, 0.21, 3.29, 4.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.a', 'IM', 4.39, 17, 0.21, 3.95, 4.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.b', 'IM', 3.85, 17, 0.33, 3.15, 4.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.3.c', 'IM', 3.30, 17, 0.22, 2.84, 3.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.a', 'IM', 4.17, 17, 0.24, 3.66, 4.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.b', 'IM', 3.96, 17, 0.32, 3.28, 4.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.4.c', 'IM', 4.08, 17, 0.26, 3.53, 4.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.a', 'IM', 4.36, 17, 0.23, 3.87, 4.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.b', 'IM', 4.66, 17, 0.15, 4.34, 4.97, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.5.c', 'IM', 4.47, 17, 0.23, 3.98, 4.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.6', 'IM', 4.07, 17, 0.12, 3.81, 4.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.7.a', 'IM', 3.76, 17, 0.16, 3.42, 4.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1242.00', '1.C.7.b', 'IM', 4.56, 16, 0.18, 4.18, 4.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.b', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.1.c', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.2.b', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.a', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.b', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.3.c', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.a', 'IM', 3.21, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.b', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.4.c', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.b', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.5.c', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.6', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.7.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.00', '1.C.7.b', 'IM', 4.88, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.b', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.1.c', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.2.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.b', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.3.c', 'IM', 2.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.a', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.b', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.4.c', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.5.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.6', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.7.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1243.01', '1.C.7.b', 'IM', 4.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.a', 'IM', 3.94, 40, 0.17, 3.58, 4.29, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.b', 'IM', 4.12, 40, 0.13, 3.85, 4.38, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.1.c', 'IM', 4.20, 40, 0.14, 3.91, 4.48, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.2.b', 'IM', 3.45, 40, 0.22, 3.02, 3.89, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.a', 'IM', 4.30, 40, 0.13, 4.03, 4.56, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.b', 'IM', 3.66, 40, 0.17, 3.32, 4.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.3.c', 'IM', 3.20, 40, 0.21, 2.77, 3.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.a', 'IM', 3.70, 40, 0.23, 3.23, 4.17, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.b', 'IM', 4.18, 40, 0.16, 3.87, 4.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.4.c', 'IM', 4.12, 40, 0.17, 3.78, 4.46, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.a', 'IM', 4.45, 40, 0.12, 4.21, 4.68, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.b', 'IM', 4.54, 40, 0.14, 4.26, 4.82, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.5.c', 'IM', 4.44, 40, 0.12, 4.19, 4.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.6', 'IM', 4.21, 40, 0.23, 3.75, 4.67, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.7.a', 'IM', 3.95, 40, 0.21, 3.52, 4.38, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1244.00', '1.C.7.b', 'IM', 4.50, 40, 0.14, 4.22, 4.77, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.a', 'IM', 4.43, 22, 0.21, 3.98, 4.87, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.b', 'IM', 4.40, 22, 0.21, 3.95, 4.84, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.1.c', 'IM', 4.44, 22, 0.20, 4.02, 4.87, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.2.b', 'IM', 3.48, 22, 0.59, 2.25, 4.70, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.a', 'IM', 4.56, 22, 0.23, 4.08, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.b', 'IM', 3.71, 22, 0.47, 2.74, 4.69, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.3.c', 'IM', 3.21, 22, 0.31, 2.56, 3.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.a', 'IM', 4.12, 22, 0.35, 3.38, 4.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.b', 'IM', 3.90, 22, 0.43, 3.01, 4.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.4.c', 'IM', 4.05, 22, 0.12, 3.79, 4.30, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.a', 'IM', 4.29, 22, 0.15, 3.98, 4.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.b', 'IM', 4.97, 21, 0.03, 4.91, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.5.c', 'IM', 4.64, 22, 0.20, 4.22, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.6', 'IM', 4.54, 22, 0.19, 4.14, 4.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.7.a', 'IM', 4.00, 22, 0.37, 3.23, 4.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1251.00', '1.C.7.b', 'IM', 4.74, 22, 0.14, 4.45, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.a', 'IM', 3.85, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.b', 'IM', 4.24, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.1.c', 'IM', 4.03, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.2.b', 'IM', 3.38, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.a', 'IM', 4.50, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.b', 'IM', 3.35, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.3.c', 'IM', 2.88, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.a', 'IM', 3.94, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.b', 'IM', 3.91, 33, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.4.c', 'IM', 4.35, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.a', 'IM', 4.35, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.b', 'IM', 4.91, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.5.c', 'IM', 4.42, 33, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.6', 'IM', 3.62, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.7.a', 'IM', 3.59, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1253.00', '1.C.7.b', 'IM', 4.56, 34, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.1.c', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.2.b', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.b', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.3.c', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.a', 'IM', 3.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.b', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.4.c', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.a', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.5.c', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.6', 'IM', 3.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.7.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1254.00', '1.C.7.b', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.1.c', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.2.b', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.a', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.b', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.3.c', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.a', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.4.c', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.5.c', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.6', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.7.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1255.01', '1.C.7.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.b', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.b', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.3.c', 'IM', 2.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.a', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.4.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.5.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.6', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.01', '1.C.7.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.a', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.b', 'IM', 4.09, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.1.c', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.2.b', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.a', 'IM', 4.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.b', 'IM', 3.21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.3.c', 'IM', 2.75, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.a', 'IM', 3.38, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.b', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.4.c', 'IM', 4.10, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.a', 'IM', 4.23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.b', 'IM', 4.66, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.5.c', 'IM', 4.33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.6', 'IM', 4.35, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.7.a', 'IM', 4.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.02', '1.C.7.b', 'IM', 4.55, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.1.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.2.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.3.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.a', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.4.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.5.c', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.6', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.7.a', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.03', '1.C.7.b', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.a', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.b', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.1.c', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.2.b', 'IM', 3.87, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.a', 'IM', 4.00, 29, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.b', 'IM', 3.10, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.3.c', 'IM', 3.10, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.a', 'IM', 3.83, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.b', 'IM', 4.17, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.4.c', 'IM', 4.30, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.b', 'IM', 4.43, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.5.c', 'IM', 4.17, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.6', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.7.a', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.08', '1.C.7.b', 'IM', 4.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.1.c', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.2.b', 'IM', 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.3.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.4.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.5.c', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.6', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.7.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-1299.09', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.a', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.b', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.1.c', 'IM', 4.16, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.2.b', 'IM', 3.56, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.a', 'IM', 3.97, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.b', 'IM', 2.59, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.3.c', 'IM', 2.28, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.a', 'IM', 3.34, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.b', 'IM', 3.81, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.4.c', 'IM', 3.81, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.a', 'IM', 4.38, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.b', 'IM', 4.75, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.5.c', 'IM', 4.69, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.6', 'IM', 3.44, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.a', 'IM', 3.22, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2011.00', '1.C.7.b', 'IM', 4.81, 32, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.a', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.b', 'IM', 4.62, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.1.c', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.2.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.a', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.b', 'IM', 2.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.3.c', 'IM', 2.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.b', 'IM', 3.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.4.c', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.a', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.b', 'IM', 4.71, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.5.c', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.6', 'IM', 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2021.00', '1.C.7.b', 'IM', 4.96, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.1.c', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.2.b', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.b', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.3.c', 'IM', 2.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.b', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.5.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.6', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2031.00', '1.C.7.b', 'IM', 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.1.c', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.2.b', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.b', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.3.c', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.a', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.b', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.4.c', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.a', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.5.c', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.6', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.00', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.b', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.1.c', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.2.b', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.a', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.b', 'IM', 3.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.3.c', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.a', 'IM', 3.38, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.b', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.4.c', 'IM', 3.58, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.a', 'IM', 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.b', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.5.c', 'IM', 4.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.6', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.a', 'IM', 3.42, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2041.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.1.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.2.b', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.b', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.3.c', 'IM', 2.74, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.a', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.4.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.a', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.b', 'IM', 4.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.5.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.6', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.7.a', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.01', '1.C.7.b', 'IM', 4.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.1.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.2.b', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.3.c', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.4.c', 'IM', 3.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.a', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.5.c', 'IM', 4.45, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.6', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.7.a', 'IM', 3.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2051.02', '1.C.7.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.a', 'IM', 4.03, 21, 0.25, 3.50, 4.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.b', 'IM', 3.74, 21, 0.37, 2.98, 4.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.1.c', 'IM', 3.83, 21, 0.28, 3.24, 4.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.2.b', 'IM', 3.35, 21, 0.27, 2.78, 3.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.a', 'IM', 4.23, 21, 0.25, 3.72, 4.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.b', 'IM', 3.18, 21, 0.32, 2.52, 3.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.3.c', 'IM', 2.65, 21, 0.43, 1.75, 3.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.a', 'IM', 3.15, 21, 0.27, 2.58, 3.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.b', 'IM', 3.50, 21, 0.35, 2.76, 4.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.4.c', 'IM', 3.54, 21, 0.35, 2.80, 4.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.a', 'IM', 3.85, 21, 0.35, 3.13, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.b', 'IM', 4.25, 21, 0.26, 3.70, 4.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.5.c', 'IM', 3.85, 21, 0.28, 3.25, 4.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.6', 'IM', 3.79, 21, 0.20, 3.37, 4.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.7.a', 'IM', 3.72, 21, 0.30, 3.09, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('15-2099.01', '1.C.7.b', 'IM', 4.16, 21, 0.25, 3.63, 4.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.1.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.2.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.a', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.b', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.3.c', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.4.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.b', 'IM', 4.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.5.c', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.6', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1011.00', '1.C.7.b', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.a', 'IM', 3.93, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.b', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.1.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.2.b', 'IM', 3.89, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.b', 'IM', 3.39, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.3.c', 'IM', 3.25, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.a', 'IM', 3.71, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.b', 'IM', 3.96, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.4.c', 'IM', 4.18, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.a', 'IM', 4.43, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.b', 'IM', 4.54, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.5.c', 'IM', 4.32, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.6', 'IM', 3.57, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.a', 'IM', 4.21, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1012.00', '1.C.7.b', 'IM', 4.00, 28, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.a', 'IM', 3.63, 21, 0.27, 3.07, 4.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.b', 'IM', 3.76, 21, 0.29, 3.15, 4.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.1.c', 'IM', 3.78, 21, 0.16, 3.45, 4.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.2.b', 'IM', 3.39, 21, 0.29, 2.79, 3.99, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.a', 'IM', 3.94, 21, 0.11, 3.71, 4.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.b', 'IM', 2.91, 21, 0.22, 2.44, 3.37, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.3.c', 'IM', 2.68, 21, 0.30, 2.06, 3.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.a', 'IM', 3.28, 21, 0.27, 2.72, 3.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.b', 'IM', 3.06, 21, 0.27, 2.48, 3.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.4.c', 'IM', 3.82, 21, 0.12, 3.57, 4.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.a', 'IM', 4.15, 21, 0.21, 3.72, 4.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.b', 'IM', 4.63, 21, 0.15, 4.32, 4.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.5.c', 'IM', 3.73, 21, 0.38, 2.94, 4.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.6', 'IM', 3.53, 21, 0.54, 2.40, 4.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.a', 'IM', 3.85, 21, 0.49, 2.84, 4.87, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1021.00', '1.C.7.b', 'IM', 3.59, 21, 0.43, 2.70, 4.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.a', 'IM', 3.84, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.b', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.1.c', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.2.b', 'IM', 3.90, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.a', 'IM', 4.06, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.b', 'IM', 3.26, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.3.c', 'IM', 2.97, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.a', 'IM', 3.77, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.b', 'IM', 3.81, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.4.c', 'IM', 3.90, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.a', 'IM', 4.53, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.b', 'IM', 4.70, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.5.c', 'IM', 4.74, 31, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.6', 'IM', 3.77, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.a', 'IM', 3.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.00', '1.C.7.b', 'IM', 4.47, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.a', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.b', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.1.c', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.2.b', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.a', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.b', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.3.c', 'IM', 2.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.a', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.b', 'IM', 3.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.4.c', 'IM', 3.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.a', 'IM', 4.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.b', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.5.c', 'IM', 4.48, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.6', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.a', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-1022.01', '1.C.7.b', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.a', 'IM', 4.08, 23, 0.25, 3.57, 4.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.b', 'IM', 4.04, 24, 0.14, 3.75, 4.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.1.c', 'IM', 4.12, 24, 0.16, 3.79, 4.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.2.b', 'IM', 3.38, 24, 0.40, 2.56, 4.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.a', 'IM', 3.89, 24, 0.20, 3.48, 4.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.b', 'IM', 2.97, 24, 0.40, 2.14, 3.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.3.c', 'IM', 2.77, 24, 0.25, 2.25, 3.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.a', 'IM', 3.18, 24, 0.12, 2.94, 3.43, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.b', 'IM', 4.10, 24, 0.12, 3.85, 4.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.4.c', 'IM', 4.12, 24, 0.15, 3.81, 4.43, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.a', 'IM', 4.17, 24, 0.21, 3.74, 4.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.b', 'IM', 4.69, 24, 0.12, 4.44, 4.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.5.c', 'IM', 3.88, 24, 0.44, 2.97, 4.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.6', 'IM', 3.74, 24, 0.21, 3.30, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.a', 'IM', 3.97, 24, 0.14, 3.67, 4.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2011.00', '1.C.7.b', 'IM', 4.51, 24, 0.20, 4.11, 4.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.b', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.1.c', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.2.b', 'IM', 3.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.a', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.b', 'IM', 3.31, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.3.c', 'IM', 2.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.a', 'IM', 3.81, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.b', 'IM', 3.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.4.c', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.5.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.6', 'IM', 3.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.a', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2021.00', '1.C.7.b', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.a', 'IM', 4.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.b', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.1.c', 'IM', 4.33, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.2.b', 'IM', 3.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.a', 'IM', 4.43, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.b', 'IM', 3.53, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.3.c', 'IM', 2.87, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.a', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.b', 'IM', 3.50, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.4.c', 'IM', 3.86, 29, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.a', 'IM', 4.30, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.b', 'IM', 4.40, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.5.c', 'IM', 4.63, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.6', 'IM', 3.73, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.a', 'IM', 4.13, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2031.00', '1.C.7.b', 'IM', 4.37, 30, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.1.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.2.b', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.b', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.3.c', 'IM', 2.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.a', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.4.c', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.a', 'IM', 4.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.b', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.5.c', 'IM', 4.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.6', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.a', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2041.00', '1.C.7.b', 'IM', 4.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.2.b', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.3.c', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.b', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.4.c', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.5.c', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.6', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.a', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.00', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.2.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.b', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.3.c', 'IM', 2.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.a', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.a', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.b', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.5.c', 'IM', 4.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.6', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.01', '1.C.7.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.b', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.2.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.b', 'IM', 3.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.3.c', 'IM', 2.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.a', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.4.c', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.6', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.7.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2051.02', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.a', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.b', 'IM', 3.93, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.1.c', 'IM', 4.03, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.2.b', 'IM', 3.10, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.a', 'IM', 3.97, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.b', 'IM', 2.83, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.3.c', 'IM', 2.45, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.a', 'IM', 3.38, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.b', 'IM', 3.62, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.4.c', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.a', 'IM', 3.83, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.b', 'IM', 4.59, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.5.c', 'IM', 3.90, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.6', 'IM', 3.55, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.a', 'IM', 4.10, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2061.00', '1.C.7.b', 'IM', 4.52, 29, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.a', 'IM', 4.18, 48, 0.15, 3.87, 4.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.b', 'IM', 4.38, 48, 0.13, 4.11, 4.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.1.c', 'IM', 4.18, 47, 0.21, 3.75, 4.61, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.2.b', 'IM', 3.56, 48, 0.12, 3.31, 3.81, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.a', 'IM', 4.20, 49, 0.17, 3.86, 4.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.b', 'IM', 3.50, 49, 0.21, 3.09, 3.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.3.c', 'IM', 3.06, 49, 0.13, 2.80, 3.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.a', 'IM', 4.04, 49, 0.16, 3.72, 4.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.b', 'IM', 4.11, 49, 0.20, 3.72, 4.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.4.c', 'IM', 4.15, 49, 0.13, 3.89, 4.41, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.a', 'IM', 4.21, 49, 0.18, 3.85, 4.57, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.b', 'IM', 4.45, 49, 0.13, 4.19, 4.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.5.c', 'IM', 4.31, 49, 0.15, 4.00, 4.62, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.6', 'IM', 3.79, 48, 0.19, 3.40, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.a', 'IM', 3.56, 49, 0.29, 2.97, 4.14, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2071.00', '1.C.7.b', 'IM', 4.43, 49, 0.14, 4.15, 4.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.a', 'IM', 3.57, 16, 0.14, 3.27, 3.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.b', 'IM', 3.80, 16, 0.12, 3.53, 4.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.1.c', 'IM', 4.17, 16, 0.13, 3.89, 4.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.2.b', 'IM', 3.84, 16, 0.28, 3.24, 4.43, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.a', 'IM', 4.28, 16, 0.23, 3.78, 4.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.b', 'IM', 2.84, 16, 0.10, 2.61, 3.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.3.c', 'IM', 2.59, 16, 0.29, 1.97, 3.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.a', 'IM', 3.39, 16, 0.16, 3.04, 3.73, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.b', 'IM', 3.62, 16, 0.15, 3.29, 3.95, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.4.c', 'IM', 4.13, 16, 0.18, 3.75, 4.51, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.a', 'IM', 4.58, 16, 0.12, 4.32, 4.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.b', 'IM', 4.62, 16, 0.18, 4.24, 5.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.5.c', 'IM', 4.25, 16, 0.33, 3.54, 4.97, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.6', 'IM', 3.44, 16, 0.15, 3.11, 3.77, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.a', 'IM', 3.97, 16, 0.12, 3.72, 4.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.00', '1.C.7.b', 'IM', 4.54, 16, 0.13, 4.26, 4.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.a', 'IM', 4.17, 22, 0.14, 3.89, 4.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.b', 'IM', 4.16, 22, 0.19, 3.76, 4.57, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.1.c', 'IM', 4.13, 22, 0.17, 3.77, 4.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.2.b', 'IM', 3.85, 22, 0.15, 3.55, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.a', 'IM', 4.35, 22, 0.14, 4.06, 4.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.b', 'IM', 3.64, 22, 0.20, 3.22, 4.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.3.c', 'IM', 3.05, 22, 0.29, 2.45, 3.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.a', 'IM', 3.91, 22, 0.16, 3.57, 4.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.b', 'IM', 4.16, 22, 0.15, 3.85, 4.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.4.c', 'IM', 4.38, 22, 0.21, 3.95, 4.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.a', 'IM', 4.20, 22, 0.17, 3.86, 4.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.b', 'IM', 4.54, 22, 0.11, 4.31, 4.77, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.5.c', 'IM', 4.12, 22, 0.21, 3.67, 4.57, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.6', 'IM', 3.69, 22, 0.21, 3.25, 4.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.7.a', 'IM', 4.14, 21, 0.27, 3.58, 4.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2072.01', '1.C.7.b', 'IM', 4.39, 22, 0.14, 4.10, 4.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.b', 'IM', 3.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.1.c', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.2.b', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.b', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.3.c', 'IM', 2.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.a', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.b', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.4.c', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.b', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.6', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.a', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2081.00', '1.C.7.b', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.a', 'IM', 3.92, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.b', 'IM', 4.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.1.c', 'IM', 4.22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.2.b', 'IM', 4.08, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.a', 'IM', 4.23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.b', 'IM', 4.01, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.3.c', 'IM', 3.19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.a', 'IM', 4.24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.b', 'IM', 4.14, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.4.c', 'IM', 4.12, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.a', 'IM', 4.50, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.b', 'IM', 4.51, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.5.c', 'IM', 4.86, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.6', 'IM', 3.95, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.7.a', 'IM', 3.58, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.00', '1.C.7.b', 'IM', 4.17, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.1.c', 'IM', 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.2.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.a', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.b', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.3.c', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.4.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.a', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.6', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2111.02', '1.C.7.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.a', 'IM', 4.20, 30, 0.15, 3.90, 4.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.b', 'IM', 4.22, 30, 0.09, 4.03, 4.41, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.1.c', 'IM', 4.10, 30, 0.15, 3.79, 4.40, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.2.b', 'IM', 4.01, 30, 0.17, 3.66, 4.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.a', 'IM', 4.23, 30, 0.20, 3.82, 4.64, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.b', 'IM', 3.60, 30, 0.16, 3.27, 3.93, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.3.c', 'IM', 3.09, 30, 0.29, 2.50, 3.68, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.a', 'IM', 4.21, 30, 0.15, 3.89, 4.53, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.b', 'IM', 4.16, 30, 0.17, 3.81, 4.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.4.c', 'IM', 4.26, 30, 0.15, 3.95, 4.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.a', 'IM', 4.45, 29, 0.11, 4.23, 4.67, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.b', 'IM', 4.61, 29, 0.12, 4.38, 4.85, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.5.c', 'IM', 4.33, 30, 0.14, 4.04, 4.62, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.6', 'IM', 4.21, 30, 0.12, 3.97, 4.45, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.a', 'IM', 3.97, 30, 0.17, 3.61, 4.32, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.00', '1.C.7.b', 'IM', 4.28, 30, 0.11, 4.07, 4.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.b', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.1.c', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.2.b', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.3.c', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.4.c', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.a', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.5.c', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.6', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.7.a', 'IM', 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.01', '1.C.7.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.b', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.1.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.2.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.3.c', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.b', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.4.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.5.c', 'IM', 4.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.6', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.7.a', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.02', '1.C.7.b', 'IM', 4.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.b', 'IM', 4.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.1.c', 'IM', 4.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.2.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.a', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.b', 'IM', 3.19, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.3.c', 'IM', 2.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.b', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.4.c', 'IM', 4.08, 25, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.a', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.b', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.5.c', 'IM', 4.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.6', 'IM', 3.58, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.7.a', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2112.03', '1.C.7.b', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.a', 'IM', 4.03, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.b', 'IM', 4.05, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.1.c', 'IM', 4.27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.2.b', 'IM', 3.81, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.a', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.b', 'IM', 2.85, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.3.c', 'IM', 2.60, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.a', 'IM', 3.51, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.b', 'IM', 3.83, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.4.c', 'IM', 3.56, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.b', 'IM', 4.45, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.5.c', 'IM', 4.42, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.6', 'IM', 3.95, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.7.a', 'IM', 3.81, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2121.00', '1.C.7.b', 'IM', 4.40, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.a', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.1.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.2.b', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.b', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.3.c', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.4.c', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.b', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.6', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2131.00', '1.C.7.b', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.a', 'IM', 3.90, 37, 0.16, 3.58, 4.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.b', 'IM', 4.11, 38, 0.24, 3.62, 4.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.1.c', 'IM', 3.92, 38, 0.15, 3.61, 4.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.2.b', 'IM', 4.06, 38, 0.18, 3.70, 4.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.a', 'IM', 4.42, 38, 0.12, 4.19, 4.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.b', 'IM', 3.39, 38, 0.22, 2.94, 3.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.3.c', 'IM', 3.36, 38, 0.22, 2.92, 3.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.a', 'IM', 3.87, 38, 0.11, 3.64, 4.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.b', 'IM', 3.97, 38, 0.23, 3.51, 4.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.4.c', 'IM', 4.24, 38, 0.12, 3.99, 4.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.a', 'IM', 4.49, 38, 0.11, 4.26, 4.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.b', 'IM', 4.73, 38, 0.11, 4.51, 4.95, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.5.c', 'IM', 4.45, 38, 0.22, 4.01, 4.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.6', 'IM', 3.94, 38, 0.23, 3.47, 4.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.a', 'IM', 4.64, 38, 0.17, 4.30, 4.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.00', '1.C.7.b', 'IM', 4.78, 38, 0.09, 4.59, 4.98, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.1.c', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.2.b', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.b', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.3.c', 'IM', 2.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.a', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.4.c', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.5.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.6', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.7.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.01', '1.C.7.b', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.b', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.1.c', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.2.b', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.a', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.b', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.3.c', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.a', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.b', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.4.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.b', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.5.c', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.6', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.7.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2141.02', '1.C.7.b', 'IM', 4.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.a', 'IM', 3.83, 20, 0.18, 3.45, 4.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.b', 'IM', 3.60, 20, 0.28, 3.01, 4.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.1.c', 'IM', 3.91, 20, 0.22, 3.45, 4.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.2.b', 'IM', 3.86, 20, 0.25, 3.34, 4.38, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.a', 'IM', 4.16, 20, 0.22, 3.71, 4.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.b', 'IM', 3.38, 20, 0.24, 2.88, 3.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.3.c', 'IM', 3.15, 20, 0.23, 2.67, 3.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.a', 'IM', 3.63, 20, 0.24, 3.14, 4.12, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.b', 'IM', 3.93, 20, 0.25, 3.41, 4.45, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.4.c', 'IM', 4.03, 20, 0.13, 3.76, 4.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.a', 'IM', 4.35, 20, 0.18, 3.98, 4.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.b', 'IM', 4.64, 20, 0.15, 4.33, 4.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.5.c', 'IM', 4.14, 20, 0.21, 3.70, 4.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.6', 'IM', 4.08, 20, 0.15, 3.77, 4.40, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.a', 'IM', 3.57, 20, 0.21, 3.13, 4.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2151.00', '1.C.7.b', 'IM', 4.77, 20, 0.12, 4.51, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.a', 'IM', 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.b', 'IM', 3.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.1.c', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.2.b', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.a', 'IM', 3.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.b', 'IM', 2.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.3.c', 'IM', 2.37, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.a', 'IM', 3.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.b', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.4.c', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.a', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.b', 'IM', 4.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.5.c', 'IM', 4.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.6', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.a', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2161.00', '1.C.7.b', 'IM', 4.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.a', 'IM', 3.91, 20, 0.21, 3.48, 4.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.b', 'IM', 3.86, 20, 0.20, 3.44, 4.27, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.1.c', 'IM', 4.19, 20, 0.13, 3.91, 4.47, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.2.b', 'IM', 3.60, 20, 0.15, 3.28, 3.92, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.a', 'IM', 4.16, 20, 0.08, 3.99, 4.33, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.b', 'IM', 3.39, 20, 0.30, 2.75, 4.02, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.3.c', 'IM', 3.20, 20, 0.35, 2.46, 3.93, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.a', 'IM', 3.88, 20, 0.24, 3.37, 4.38, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.b', 'IM', 3.72, 20, 0.21, 3.27, 4.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.4.c', 'IM', 3.70, 19, 0.40, 2.86, 4.55, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.a', 'IM', 4.30, 20, 0.09, 4.11, 4.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.b', 'IM', 4.38, 20, 0.11, 4.15, 4.61, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.5.c', 'IM', 4.34, 20, 0.21, 3.90, 4.78, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.6', 'IM', 3.69, 20, 0.13, 3.41, 3.96, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.a', 'IM', 3.77, 20, 0.48, 2.78, 4.77, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2171.00', '1.C.7.b', 'IM', 4.47, 20, 0.17, 4.11, 4.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.a', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.2.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.b', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.3.c', 'IM', 3.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.a', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.4.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.a', 'IM', 4.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.b', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.5.c', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.6', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.03', '1.C.7.b', 'IM', 4.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.a', 'IM', 3.87, 18, 0.08, 3.72, 4.03, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.b', 'IM', 3.88, 18, 0.21, 3.44, 4.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.1.c', 'IM', 3.92, 18, 0.33, 3.23, 4.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.2.b', 'IM', 3.48, 18, 0.24, 2.97, 3.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.a', 'IM', 3.81, 18, 0.24, 3.30, 4.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.b', 'IM', 2.78, 18, 0.36, 2.02, 3.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.3.c', 'IM', 2.80, 18, 0.15, 2.47, 3.13, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.a', 'IM', 3.50, 18, 0.24, 3.00, 4.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.b', 'IM', 4.00, 18, 0.04, 3.92, 4.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.4.c', 'IM', 3.80, 18, 0.14, 3.52, 4.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.a', 'IM', 4.15, 18, 0.09, 3.96, 4.34, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.b', 'IM', 4.38, 18, 0.22, 3.91, 4.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.5.c', 'IM', 4.02, 18, 0.07, 3.87, 4.17, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.6', 'IM', 3.51, 18, 0.16, 3.18, 3.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.7.a', 'IM', 4.19, 18, 0.34, 3.47, 4.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.05', '1.C.7.b', 'IM', 4.20, 18, 0.15, 3.89, 4.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.a', 'IM', 3.90, 18, 0.21, 3.45, 4.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.b', 'IM', 3.93, 18, 0.28, 3.34, 4.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.1.c', 'IM', 4.07, 18, 0.04, 3.98, 4.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.2.b', 'IM', 3.56, 18, 0.14, 3.26, 3.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.a', 'IM', 4.01, 18, 0.16, 3.67, 4.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.b', 'IM', 3.05, 18, 0.36, 2.28, 3.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.3.c', 'IM', 2.58, 18, 0.25, 2.05, 3.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.a', 'IM', 3.52, 18, 0.20, 3.09, 3.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.b', 'IM', 3.76, 18, 0.14, 3.46, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.4.c', 'IM', 3.82, 18, 0.15, 3.50, 4.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.a', 'IM', 4.05, 18, 0.04, 3.96, 4.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.b', 'IM', 4.59, 18, 0.14, 4.29, 4.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.5.c', 'IM', 4.26, 18, 0.26, 3.71, 4.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.6', 'IM', 3.23, 18, 0.29, 2.61, 3.85, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.7.a', 'IM', 4.32, 18, 0.17, 3.97, 4.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.06', '1.C.7.b', 'IM', 4.66, 18, 0.13, 4.38, 4.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.1.c', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.2.b', 'IM', 2.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.b', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.3.c', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.a', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.b', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.4.c', 'IM', 3.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.b', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.5.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.6', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.07', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.b', 'IM', 4.30, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.1.c', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.2.b', 'IM', 3.48, 29, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.a', 'IM', 4.13, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.b', 'IM', 3.30, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.3.c', 'IM', 2.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.a', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.b', 'IM', 3.93, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.4.c', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.a', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.b', 'IM', 4.47, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.5.c', 'IM', 4.23, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.6', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.a', 'IM', 4.20, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.08', '1.C.7.b', 'IM', 4.50, 30, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.a', 'IM', 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.b', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.1.c', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.2.b', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.a', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.b', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.3.c', 'IM', 2.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.a', 'IM', 3.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.b', 'IM', 3.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.4.c', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.a', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.b', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.5.c', 'IM', 4.12, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.6', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.7.a', 'IM', 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.09', '1.C.7.b', 'IM', 4.54, 24, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.a', 'IM', 4.23, 35, 0.20, 3.83, 4.63, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.b', 'IM', 4.28, 35, 0.19, 3.90, 4.65, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.1.c', 'IM', 4.39, 35, 0.16, 4.06, 4.72, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.2.b', 'IM', 4.05, 35, 0.26, 3.51, 4.58, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.a', 'IM', 4.22, 35, 0.19, 3.83, 4.60, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.b', 'IM', 3.39, 35, 0.18, 3.02, 3.77, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.3.c', 'IM', 3.08, 35, 0.13, 2.81, 3.35, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.a', 'IM', 3.91, 35, 0.29, 3.31, 4.51, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.b', 'IM', 4.29, 35, 0.19, 3.91, 4.67, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.4.c', 'IM', 4.37, 35, 0.18, 4.00, 4.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.a', 'IM', 4.37, 35, 0.11, 4.15, 4.59, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.b', 'IM', 4.55, 35, 0.15, 4.25, 4.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.5.c', 'IM', 4.37, 35, 0.16, 4.05, 4.68, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.6', 'IM', 4.18, 35, 0.23, 3.71, 4.65, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.7.a', 'IM', 4.01, 35, 0.12, 3.77, 4.24, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.10', '1.C.7.b', 'IM', 4.63, 35, 0.12, 4.38, 4.88, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.b', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.1.c', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.2.b', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.a', 'IM', 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.b', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.3.c', 'IM', 2.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.b', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.4.c', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.b', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.5.c', 'IM', 4.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.6', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.7.a', 'IM', 3.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-2199.11', '1.C.7.b', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.a', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.1.c', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.2.b', 'IM', 3.67, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.a', 'IM', 4.33, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.b', 'IM', 2.94, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.3.c', 'IM', 3.07, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.a', 'IM', 3.82, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.b', 'IM', 3.96, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.4.c', 'IM', 4.15, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.a', 'IM', 4.58, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.b', 'IM', 4.78, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.5.c', 'IM', 3.86, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.6', 'IM', 3.99, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.7.a', 'IM', 3.80, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3011.00', '1.C.7.b', 'IM', 4.29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.a', 'IM', 3.72, 69, 0.22, 3.28, 4.16, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.b', 'IM', 3.68, 69, 0.22, 3.25, 4.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.1.c', 'IM', 4.07, 70, 0.07, 3.93, 4.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.2.b', 'IM', 3.36, 70, 0.40, 2.56, 4.16, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.a', 'IM', 3.98, 70, 0.28, 3.43, 4.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.b', 'IM', 3.37, 70, 0.12, 3.12, 3.62, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.3.c', 'IM', 2.95, 70, 0.31, 2.34, 3.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.a', 'IM', 3.58, 70, 0.45, 2.69, 4.47, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.b', 'IM', 3.57, 70, 0.47, 2.62, 4.51, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.4.c', 'IM', 3.76, 70, 0.24, 3.29, 4.24, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.a', 'IM', 4.08, 69, 0.34, 3.40, 4.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.b', 'IM', 4.55, 70, 0.16, 4.23, 4.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.5.c', 'IM', 3.58, 69, 0.43, 2.73, 4.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.6', 'IM', 3.70, 69, 0.22, 3.25, 4.15, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.7.a', 'IM', 3.69, 70, 0.15, 3.39, 3.98, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3012.00', '1.C.7.b', 'IM', 3.85, 70, 0.25, 3.36, 4.35, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.a', 'IM', 3.74, 29, 0.22, 3.30, 4.18, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.b', 'IM', 3.60, 29, 0.18, 3.24, 3.96, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.1.c', 'IM', 4.16, 29, 0.09, 3.97, 4.35, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.2.b', 'IM', 3.61, 29, 0.16, 3.29, 3.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.a', 'IM', 4.05, 28, 0.19, 3.67, 4.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.b', 'IM', 3.35, 28, 0.20, 2.94, 3.76, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.3.c', 'IM', 3.27, 28, 0.21, 2.83, 3.71, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.a', 'IM', 3.88, 28, 0.18, 3.51, 4.24, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.b', 'IM', 3.91, 28, 0.12, 3.66, 4.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.4.c', 'IM', 3.84, 28, 0.25, 3.33, 4.35, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.a', 'IM', 4.23, 28, 0.13, 3.96, 4.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.b', 'IM', 4.84, 28, 0.09, 4.65, 5.00, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.5.c', 'IM', 4.20, 29, 0.12, 3.95, 4.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.6', 'IM', 3.58, 29, 0.41, 2.74, 4.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.a', 'IM', 4.02, 29, 0.12, 3.77, 4.28, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3013.00', '1.C.7.b', 'IM', 4.34, 29, 0.19, 3.96, 4.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.a', 'IM', 3.34, 15, 0.43, 2.43, 4.26, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.b', 'IM', 4.22, 15, 0.28, 3.62, 4.83, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.1.c', 'IM', 4.23, 15, 0.28, 3.62, 4.83, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.2.b', 'IM', 3.23, 15, 0.26, 2.67, 3.79, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.a', 'IM', 3.81, 15, 0.19, 3.41, 4.21, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.b', 'IM', 2.93, 15, 0.27, 2.36, 3.50, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.3.c', 'IM', 2.97, 15, 0.39, 2.13, 3.80, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.a', 'IM', 3.72, 15, 0.36, 2.95, 4.49, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.b', 'IM', 4.08, 15, 0.31, 3.40, 4.75, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.4.c', 'IM', 4.37, 15, 0.26, 3.82, 4.92, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.a', 'IM', 4.61, 15, 0.24, 4.10, 5.00, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.b', 'IM', 4.77, 15, 0.16, 4.43, 5.00, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.5.c', 'IM', 4.45, 15, 0.35, 3.71, 5.00, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.6', 'IM', 4.16, 15, 0.21, 3.72, 4.61, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.a', 'IM', 3.60, 15, 0.36, 2.83, 4.36, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3021.00', '1.C.7.b', 'IM', 4.47, 15, 0.19, 4.07, 4.87, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.a', 'IM', 3.83, 36, 0.14, 3.54, 4.13, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.b', 'IM', 4.03, 36, 0.21, 3.62, 4.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.1.c', 'IM', 4.23, 36, 0.18, 3.87, 4.58, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.2.b', 'IM', 3.87, 36, 0.15, 3.56, 4.18, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.a', 'IM', 4.36, 36, 0.08, 4.20, 4.53, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.b', 'IM', 3.74, 36, 0.12, 3.49, 3.99, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.3.c', 'IM', 3.58, 35, 0.13, 3.32, 3.83, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.a', 'IM', 4.05, 36, 0.30, 3.46, 4.65, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.b', 'IM', 3.94, 36, 0.17, 3.60, 4.29, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.4.c', 'IM', 4.14, 36, 0.15, 3.84, 4.44, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.a', 'IM', 4.47, 36, 0.08, 4.31, 4.64, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.b', 'IM', 4.51, 36, 0.09, 4.33, 4.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.5.c', 'IM', 4.61, 36, 0.10, 4.41, 4.82, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.6', 'IM', 3.49, 36, 0.40, 2.67, 4.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.a', 'IM', 3.74, 36, 0.14, 3.46, 4.02, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3022.00', '1.C.7.b', 'IM', 4.08, 36, 0.16, 3.75, 4.41, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.a', 'IM', 3.85, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.b', 'IM', 3.93, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.1.c', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.2.b', 'IM', 3.37, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.a', 'IM', 4.06, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.b', 'IM', 3.40, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.3.c', 'IM', 3.01, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.a', 'IM', 3.84, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.b', 'IM', 3.89, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.4.c', 'IM', 4.12, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.a', 'IM', 4.39, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.b', 'IM', 4.60, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.5.c', 'IM', 4.16, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.6', 'IM', 3.91, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.7.a', 'IM', 3.66, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3023.00', '1.C.7.b', 'IM', 4.31, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.a', 'IM', 3.83, 38, 0.32, 3.17, 4.49, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.b', 'IM', 4.29, 38, 0.12, 4.05, 4.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.1.c', 'IM', 4.33, 38, 0.13, 4.06, 4.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.2.b', 'IM', 3.24, 38, 0.41, 2.40, 4.08, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.a', 'IM', 4.13, 37, 0.22, 3.69, 4.58, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.b', 'IM', 3.69, 38, 0.22, 3.25, 4.13, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.3.c', 'IM', 2.75, 38, 0.30, 2.13, 3.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.a', 'IM', 3.94, 38, 0.20, 3.54, 4.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.b', 'IM', 3.79, 38, 0.19, 3.41, 4.17, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.4.c', 'IM', 3.98, 38, 0.12, 3.73, 4.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.a', 'IM', 4.49, 38, 0.13, 4.22, 4.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.b', 'IM', 4.73, 38, 0.09, 4.54, 4.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.5.c', 'IM', 4.15, 38, 0.15, 3.85, 4.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.6', 'IM', 3.98, 38, 0.16, 3.66, 4.30, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.a', 'IM', 3.68, 38, 0.18, 3.31, 4.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.00', '1.C.7.b', 'IM', 4.27, 38, 0.11, 4.05, 4.50, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.a', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.b', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.1.c', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.2.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.a', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.b', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.3.c', 'IM', 2.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.b', 'IM', 4.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.4.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.a', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.5.c', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.6', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3024.01', '1.C.7.b', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.a', 'IM', 3.67, 23, 0.24, 3.17, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.b', 'IM', 3.49, 23, 0.19, 3.10, 3.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.1.c', 'IM', 4.11, 23, 0.23, 3.64, 4.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.2.b', 'IM', 3.66, 23, 0.14, 3.36, 3.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.a', 'IM', 4.30, 23, 0.14, 4.01, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.b', 'IM', 3.27, 23, 0.24, 2.77, 3.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.3.c', 'IM', 2.88, 23, 0.32, 2.22, 3.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.a', 'IM', 3.23, 23, 0.34, 2.53, 3.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.b', 'IM', 4.06, 23, 0.14, 3.77, 4.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.4.c', 'IM', 3.90, 23, 0.22, 3.45, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.a', 'IM', 4.21, 23, 0.18, 3.83, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.b', 'IM', 4.26, 23, 0.18, 3.89, 4.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.5.c', 'IM', 4.23, 23, 0.17, 3.88, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.6', 'IM', 3.62, 23, 0.35, 2.89, 4.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.a', 'IM', 2.98, 23, 0.20, 2.55, 3.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3025.00', '1.C.7.b', 'IM', 3.80, 23, 0.33, 3.12, 4.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.a', 'IM', 3.88, 28, 0.05, 3.78, 3.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.b', 'IM', 3.89, 28, 0.07, 3.75, 4.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.1.c', 'IM', 4.04, 27, 0.03, 3.97, 4.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.2.b', 'IM', 3.34, 28, 0.11, 3.12, 3.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.a', 'IM', 4.10, 28, 0.06, 3.99, 4.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.b', 'IM', 3.79, 28, 0.14, 3.50, 4.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.3.c', 'IM', 3.12, 28, 0.11, 2.90, 3.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.a', 'IM', 3.98, 28, 0.13, 3.73, 4.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.b', 'IM', 4.15, 28, 0.12, 3.90, 4.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.4.c', 'IM', 3.81, 28, 0.11, 3.58, 4.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.a', 'IM', 4.35, 28, 0.07, 4.21, 4.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.b', 'IM', 4.36, 28, 0.16, 4.04, 4.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.5.c', 'IM', 4.09, 28, 0.27, 3.54, 4.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.6', 'IM', 3.90, 28, 0.06, 3.78, 4.02, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.a', 'IM', 3.75, 28, 0.33, 3.08, 4.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.00', '1.C.7.b', 'IM', 4.30, 28, 0.12, 4.06, 4.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.a', 'IM', 3.91, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.b', 'IM', 4.11, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.1.c', 'IM', 4.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.2.b', 'IM', 3.05, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.a', 'IM', 3.92, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.b', 'IM', 3.03, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.3.c', 'IM', 2.04, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.a', 'IM', 3.34, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.b', 'IM', 3.43, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.4.c', 'IM', 3.78, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.a', 'IM', 4.02, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.b', 'IM', 4.63, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.5.c', 'IM', 4.05, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.6', 'IM', 3.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.7.a', 'IM', 3.73, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3026.01', '1.C.7.b', 'IM', 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.a', 'IM', 3.63, 31, 0.13, 3.36, 3.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.b', 'IM', 3.81, 31, 0.19, 3.43, 4.18, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.1.c', 'IM', 3.92, 31, 0.09, 3.74, 4.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.2.b', 'IM', 3.37, 31, 0.13, 3.11, 3.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.a', 'IM', 3.72, 31, 0.19, 3.33, 4.10, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.b', 'IM', 3.03, 31, 0.29, 2.43, 3.63, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.3.c', 'IM', 2.89, 31, 0.15, 2.59, 3.19, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.a', 'IM', 3.46, 31, 0.38, 2.69, 4.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.b', 'IM', 3.57, 31, 0.16, 3.24, 3.90, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.4.c', 'IM', 3.73, 31, 0.16, 3.40, 4.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.a', 'IM', 4.01, 31, 0.22, 3.57, 4.46, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.b', 'IM', 4.40, 31, 0.12, 4.16, 4.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.5.c', 'IM', 3.81, 31, 0.40, 2.99, 4.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.6', 'IM', 3.63, 31, 0.13, 3.35, 3.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.a', 'IM', 3.49, 31, 0.15, 3.18, 3.80, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.00', '1.C.7.b', 'IM', 4.07, 31, 0.16, 3.73, 4.40, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.a', 'IM', 3.78, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.b', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.1.c', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.2.b', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.a', 'IM', 4.04, 26, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.b', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.3.c', 'IM', 3.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.b', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.4.c', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.a', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.b', 'IM', 4.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.5.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.6', 'IM', 3.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.7.a', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3027.01', '1.C.7.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.b', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.1.c', 'IM', 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.2.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.a', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.b', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.3.c', 'IM', 2.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.a', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.b', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.4.c', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.b', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.5.c', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.6', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.a', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.01', '1.C.7.b', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.a', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.1.c', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.2.b', 'IM', 2.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.a', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.b', 'IM', 3.08, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.3.c', 'IM', 2.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.a', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.b', 'IM', 3.64, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.4.c', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.a', 'IM', 4.24, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.b', 'IM', 4.56, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.5.c', 'IM', 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.6', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.7.a', 'IM', 3.56, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3029.08', '1.C.7.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.a', 'IM', 3.70, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.b', 'IM', 3.61, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.1.c', 'IM', 3.51, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.2.b', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.a', 'IM', 4.04, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.b', 'IM', 3.11, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.3.c', 'IM', 2.79, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.a', 'IM', 3.34, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.b', 'IM', 3.48, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.4.c', 'IM', 3.59, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.a', 'IM', 4.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.b', 'IM', 4.64, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.5.c', 'IM', 4.01, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.6', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.7.a', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('17-3031.00', '1.C.7.b', 'IM', 4.02, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.1.c', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.2.b', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.b', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.3.c', 'IM', 2.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.b', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.4.c', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.a', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.5.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1011.00', '1.C.7.b', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.b', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.1.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.2.b', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.a', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.b', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.3.c', 'IM', 2.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.4.c', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.6', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1012.00', '1.C.7.b', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.b', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.1.c', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.2.b', 'IM', 3.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.a', 'IM', 4.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.b', 'IM', 3.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.3.c', 'IM', 2.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.a', 'IM', 3.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.b', 'IM', 3.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.4.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.a', 'IM', 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.b', 'IM', 4.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.5.c', 'IM', 4.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.6', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.a', 'IM', 3.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1013.00', '1.C.7.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.b', 'IM', 4.85, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.1.c', 'IM', 4.55, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.2.b', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.b', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.3.c', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.b', 'IM', 4.15, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.4.c', 'IM', 4.25, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.b', 'IM', 4.75, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.5.c', 'IM', 4.95, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.6', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.a', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1021.00', '1.C.7.b', 'IM', 4.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.b', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.1.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.2.b', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.3.c', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.b', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.4.c', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.a', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.b', 'IM', 4.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.5.c', 'IM', 4.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.6', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.a', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1022.00', '1.C.7.b', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.a', 'IM', 3.79, 46, 0.07, 3.64, 3.93, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.b', 'IM', 3.85, 46, 0.08, 3.68, 4.01, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.1.c', 'IM', 3.94, 46, 0.09, 3.75, 4.13, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.2.b', 'IM', 3.76, 46, 0.12, 3.51, 4.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.a', 'IM', 4.24, 47, 0.12, 4.00, 4.47, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.b', 'IM', 3.48, 47, 0.12, 3.24, 3.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.3.c', 'IM', 2.84, 47, 0.16, 2.52, 3.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.a', 'IM', 3.66, 47, 0.16, 3.33, 3.99, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.b', 'IM', 3.63, 47, 0.12, 3.39, 3.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.4.c', 'IM', 3.77, 47, 0.18, 3.41, 4.12, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.a', 'IM', 3.90, 47, 0.20, 3.49, 4.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.b', 'IM', 4.00, 47, 0.08, 3.84, 4.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.5.c', 'IM', 4.22, 47, 0.13, 3.97, 4.47, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.6', 'IM', 3.92, 47, 0.08, 3.76, 4.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.a', 'IM', 3.21, 47, 0.18, 2.85, 3.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1023.00', '1.C.7.b', 'IM', 3.91, 47, 0.16, 3.60, 4.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.a', 'IM', 4.41, 30, 0.34, 3.72, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.b', 'IM', 4.51, 30, 0.26, 3.98, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.1.c', 'IM', 4.38, 29, 0.18, 4.00, 4.75, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.2.b', 'IM', 3.67, 29, 0.32, 3.01, 4.33, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.a', 'IM', 3.98, 30, 0.06, 3.85, 4.11, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.b', 'IM', 2.89, 30, 0.38, 2.12, 3.66, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.3.c', 'IM', 2.85, 29, 0.37, 2.09, 3.61, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.a', 'IM', 3.30, 30, 0.27, 2.76, 3.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.b', 'IM', 3.23, 30, 0.30, 2.63, 3.84, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.4.c', 'IM', 4.31, 30, 0.24, 3.82, 4.81, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.a', 'IM', 4.48, 30, 0.18, 4.10, 4.85, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.b', 'IM', 4.54, 30, 0.20, 4.13, 4.95, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.5.c', 'IM', 4.49, 30, 0.26, 3.97, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.6', 'IM', 4.45, 30, 0.28, 3.87, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.7.a', 'IM', 4.23, 30, 0.15, 3.92, 4.55, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.01', '1.C.7.b', 'IM', 4.85, 30, 0.10, 4.64, 5.00, 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.a', 'IM', 4.35, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.1.c', 'IM', 4.27, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.2.b', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.a', 'IM', 4.42, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.b', 'IM', 3.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.3.c', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.a', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.b', 'IM', 4.19, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.4.c', 'IM', 4.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.a', 'IM', 4.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.b', 'IM', 4.58, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.5.c', 'IM', 4.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.6', 'IM', 3.75, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.a', 'IM', 3.96, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.02', '1.C.7.b', 'IM', 4.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.a', 'IM', 4.44, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.b', 'IM', 4.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.1.c', 'IM', 4.28, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.2.b', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.a', 'IM', 3.80, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.b', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.3.c', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.a', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.b', 'IM', 3.60, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.4.c', 'IM', 3.68, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.a', 'IM', 4.16, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.5.c', 'IM', 4.80, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.6', 'IM', 3.88, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.03', '1.C.7.b', 'IM', 4.72, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.a', 'IM', 3.48, 16, 0.20, 3.05, 3.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.b', 'IM', 3.76, 16, 0.13, 3.48, 4.05, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.1.c', 'IM', 4.17, 16, 0.10, 3.96, 4.38, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.2.b', 'IM', 3.80, 16, 0.19, 3.39, 4.21, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.a', 'IM', 4.57, 15, 0.16, 4.23, 4.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.b', 'IM', 3.35, 15, 0.18, 2.97, 3.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.3.c', 'IM', 3.19, 15, 0.18, 2.79, 3.58, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.a', 'IM', 3.46, 15, 0.23, 2.96, 3.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.b', 'IM', 3.98, 15, 0.26, 3.42, 4.53, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.4.c', 'IM', 3.85, 15, 0.19, 3.44, 4.26, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.a', 'IM', 4.09, 15, 0.12, 3.84, 4.34, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.b', 'IM', 4.60, 15, 0.19, 4.19, 5.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.5.c', 'IM', 4.54, 16, 0.14, 4.25, 4.83, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.6', 'IM', 3.59, 16, 0.26, 3.04, 4.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.7.a', 'IM', 3.28, 16, 0.24, 2.77, 3.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1029.04', '1.C.7.b', 'IM', 4.39, 16, 0.25, 3.86, 4.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.a', 'IM', 3.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.1.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.2.b', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.a', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.b', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.3.c', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.a', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.4.c', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.a', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.b', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.5.c', 'IM', 4.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.6', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.7.a', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.00', '1.C.7.b', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.a', 'IM', 3.49, 17, 0.16, 3.14, 3.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.b', 'IM', 3.85, 17, 0.21, 3.41, 4.29, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.1.c', 'IM', 4.33, 17, 0.13, 4.06, 4.60, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.2.b', 'IM', 4.08, 17, 0.20, 3.66, 4.51, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.a', 'IM', 4.24, 17, 0.17, 3.88, 4.61, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.b', 'IM', 3.64, 17, 0.17, 3.27, 4.01, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.3.c', 'IM', 2.72, 17, 0.21, 2.28, 3.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.a', 'IM', 3.92, 17, 0.24, 3.42, 4.42, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.b', 'IM', 3.79, 17, 0.17, 3.43, 4.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.4.c', 'IM', 4.10, 17, 0.15, 3.78, 4.42, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.a', 'IM', 4.38, 17, 0.13, 4.11, 4.65, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.b', 'IM', 4.07, 17, 0.20, 3.64, 4.49, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.5.c', 'IM', 4.29, 17, 0.17, 3.94, 4.64, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.6', 'IM', 4.19, 17, 0.20, 3.77, 4.62, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.a', 'IM', 3.76, 17, 0.17, 3.40, 4.12, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.02', '1.C.7.b', 'IM', 3.93, 17, 0.16, 3.59, 4.27, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.a', 'IM', 4.07, 16, 0.25, 3.54, 4.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.b', 'IM', 3.79, 16, 0.24, 3.28, 4.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.1.c', 'IM', 4.17, 16, 0.11, 3.93, 4.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.2.b', 'IM', 4.30, 16, 0.37, 3.51, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.a', 'IM', 4.70, 16, 0.14, 4.41, 4.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.b', 'IM', 4.50, 16, 0.17, 4.13, 4.88, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.3.c', 'IM', 4.01, 16, 0.20, 3.59, 4.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.a', 'IM', 4.56, 16, 0.21, 4.11, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.b', 'IM', 4.07, 16, 0.16, 3.72, 4.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.4.c', 'IM', 4.35, 16, 0.18, 3.97, 4.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.a', 'IM', 4.70, 16, 0.14, 4.41, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.b', 'IM', 4.20, 16, 0.27, 3.62, 4.78, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.5.c', 'IM', 4.67, 16, 0.17, 4.32, 5.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.6', 'IM', 4.27, 16, 0.17, 3.92, 4.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.a', 'IM', 3.72, 16, 0.32, 3.05, 4.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1031.03', '1.C.7.b', 'IM', 4.00, 16, 0.29, 3.39, 4.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.a', 'IM', 3.59, 31, 0.20, 3.17, 4.00, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.b', 'IM', 3.81, 31, 0.15, 3.50, 4.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.1.c', 'IM', 3.92, 31, 0.22, 3.48, 4.36, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.2.b', 'IM', 3.77, 31, 0.17, 3.43, 4.11, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.a', 'IM', 4.16, 31, 0.13, 3.90, 4.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.b', 'IM', 3.52, 31, 0.22, 3.07, 3.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.3.c', 'IM', 2.86, 31, 0.15, 2.56, 3.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.a', 'IM', 3.76, 31, 0.16, 3.44, 4.09, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.b', 'IM', 3.83, 31, 0.18, 3.47, 4.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.4.c', 'IM', 4.08, 31, 0.18, 3.72, 4.43, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.a', 'IM', 4.31, 31, 0.09, 4.13, 4.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.b', 'IM', 4.19, 31, 0.14, 3.91, 4.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.5.c', 'IM', 4.55, 31, 0.09, 4.37, 4.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.6', 'IM', 4.06, 31, 0.17, 3.71, 4.41, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.a', 'IM', 3.34, 31, 0.19, 2.95, 3.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1032.00', '1.C.7.b', 'IM', 3.89, 31, 0.21, 3.47, 4.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.a', 'IM', 4.07, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.b', 'IM', 4.10, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.1.c', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.2.b', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.a', 'IM', 4.00, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.b', 'IM', 3.43, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.3.c', 'IM', 3.30, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.a', 'IM', 3.50, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.b', 'IM', 3.57, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.4.c', 'IM', 3.70, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.a', 'IM', 4.27, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.b', 'IM', 4.50, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.5.c', 'IM', 4.67, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.6', 'IM', 3.90, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.a', 'IM', 3.80, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1041.00', '1.C.7.b', 'IM', 4.73, 30, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.a', 'IM', 4.16, 21, 0.24, 3.67, 4.65, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.b', 'IM', 4.01, 21, 0.20, 3.60, 4.41, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.1.c', 'IM', 4.14, 21, 0.23, 3.66, 4.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.2.b', 'IM', 3.83, 21, 0.31, 3.19, 4.47, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.a', 'IM', 4.14, 21, 0.27, 3.57, 4.70, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.b', 'IM', 3.53, 21, 0.21, 3.08, 3.98, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.3.c', 'IM', 3.67, 21, 0.23, 3.20, 4.14, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.a', 'IM', 3.91, 21, 0.25, 3.39, 4.43, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.b', 'IM', 3.83, 21, 0.32, 3.17, 4.49, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.4.c', 'IM', 3.91, 21, 0.34, 3.19, 4.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.a', 'IM', 4.08, 21, 0.40, 3.24, 4.91, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.b', 'IM', 4.28, 21, 0.13, 4.01, 4.55, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.5.c', 'IM', 4.36, 21, 0.18, 3.98, 4.75, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.6', 'IM', 3.87, 21, 0.16, 3.53, 4.21, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.a', 'IM', 4.44, 21, 0.09, 4.25, 4.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-1042.00', '1.C.7.b', 'IM', 4.53, 21, 0.07, 4.39, 4.67, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.a', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.b', 'IM', 4.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.1.c', 'IM', 4.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.2.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.a', 'IM', 3.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.b', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.3.c', 'IM', 2.41, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.a', 'IM', 3.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.b', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.4.c', 'IM', 3.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.a', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.b', 'IM', 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.5.c', 'IM', 4.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.6', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2011.00', '1.C.7.b', 'IM', 4.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.a', 'IM', 4.49, 18, 0.24, 3.98, 5.00, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.b', 'IM', 4.09, 18, 0.41, 3.22, 4.95, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.1.c', 'IM', 4.38, 18, 0.18, 4.00, 4.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.2.b', 'IM', 3.53, 18, 0.26, 2.99, 4.07, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.a', 'IM', 3.59, 18, 0.26, 3.04, 4.14, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.b', 'IM', 2.67, 18, 0.27, 2.10, 3.24, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.3.c', 'IM', 2.27, 18, 0.23, 1.78, 2.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.a', 'IM', 3.07, 18, 0.47, 2.08, 4.06, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.b', 'IM', 3.46, 18, 0.52, 2.37, 4.56, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.4.c', 'IM', 3.44, 18, 0.36, 2.69, 4.20, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.a', 'IM', 3.79, 18, 0.44, 2.86, 4.73, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.b', 'IM', 4.33, 18, 0.28, 3.74, 4.93, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.5.c', 'IM', 4.18, 18, 0.25, 3.64, 4.71, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.6', 'IM', 4.10, 18, 0.19, 3.70, 4.49, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.a', 'IM', 4.50, 18, 0.22, 4.04, 4.97, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2012.00', '1.C.7.b', 'IM', 4.47, 18, 0.23, 3.99, 4.95, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.b', 'IM', 4.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.1.c', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.a', 'IM', 3.95, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.3.c', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.b', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.4.c', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.a', 'IM', 4.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.b', 'IM', 4.50, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.5.c', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.6', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2021.00', '1.C.7.b', 'IM', 4.65, 20, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.a', 'IM', 3.75, 36, 0.24, 3.26, 4.24, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.b', 'IM', 3.62, 36, 0.16, 3.30, 3.93, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.1.c', 'IM', 3.85, 36, 0.26, 3.32, 4.38, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.2.b', 'IM', 3.36, 36, 0.27, 2.81, 3.91, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.a', 'IM', 3.98, 36, 0.18, 3.61, 4.35, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.b', 'IM', 3.04, 36, 0.15, 2.74, 3.35, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.3.c', 'IM', 2.77, 36, 0.22, 2.32, 3.21, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.a', 'IM', 3.18, 36, 0.17, 2.84, 3.53, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.b', 'IM', 3.90, 36, 0.26, 3.37, 4.43, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.4.c', 'IM', 3.98, 36, 0.23, 3.51, 4.45, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.a', 'IM', 4.36, 36, 0.17, 4.01, 4.70, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.b', 'IM', 4.44, 35, 0.20, 4.03, 4.85, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.5.c', 'IM', 4.39, 36, 0.19, 4.00, 4.78, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.6', 'IM', 3.73, 36, 0.27, 3.19, 4.27, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.a', 'IM', 3.54, 36, 0.24, 3.06, 4.02, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2031.00', '1.C.7.b', 'IM', 4.40, 36, 0.19, 4.02, 4.79, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.b', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.1.c', 'IM', 4.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.2.b', 'IM', 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.b', 'IM', 2.90, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.3.c', 'IM', 2.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.a', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.b', 'IM', 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.4.c', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.a', 'IM', 3.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.b', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.5.c', 'IM', 4.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.6', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.a', 'IM', 4.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2032.00', '1.C.7.b', 'IM', 4.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.a', 'IM', 3.85, 39, 0.24, 3.36, 4.34, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.b', 'IM', 3.72, 39, 0.34, 3.03, 4.40, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.1.c', 'IM', 4.00, 39, 0.24, 3.51, 4.50, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.2.b', 'IM', 3.67, 39, 0.20, 3.26, 4.07, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.a', 'IM', 4.00, 39, 0.18, 3.64, 4.36, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.b', 'IM', 3.49, 39, 0.21, 3.07, 3.92, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.3.c', 'IM', 3.13, 39, 0.16, 2.81, 3.45, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.a', 'IM', 3.63, 39, 0.25, 3.12, 4.14, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.b', 'IM', 3.75, 39, 0.25, 3.24, 4.26, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.4.c', 'IM', 3.90, 39, 0.11, 3.67, 4.13, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.a', 'IM', 4.44, 39, 0.15, 4.14, 4.74, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.b', 'IM', 4.53, 39, 0.11, 4.30, 4.75, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.5.c', 'IM', 4.47, 39, 0.11, 4.24, 4.70, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.6', 'IM', 3.87, 39, 0.35, 3.16, 4.58, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.a', 'IM', 3.36, 39, 0.25, 2.85, 3.86, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.00', '1.C.7.b', 'IM', 4.36, 39, 0.20, 3.96, 4.76, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.b', 'IM', 4.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.1.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.2.b', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.a', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.3.c', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.a', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.b', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.4.c', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.b', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.5.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.6', 'IM', 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.7.a', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.01', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.a', 'IM', 3.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.b', 'IM', 3.91, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.1.c', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.2.b', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.a', 'IM', 4.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.b', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.3.c', 'IM', 3.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.a', 'IM', 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.b', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.4.c', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.a', 'IM', 4.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.b', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.5.c', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.6', 'IM', 3.77, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.7.a', 'IM', 3.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.02', '1.C.7.b', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.1.c', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.2.b', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.b', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.3.c', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.a', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.b', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.4.c', 'IM', 3.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.5.c', 'IM', 4.17, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.6', 'IM', 3.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.7.a', 'IM', 3.87, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2041.03', '1.C.7.b', 'IM', 4.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.a', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.b', 'IM', 4.29, 31, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.1.c', 'IM', 4.23, 31, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.2.b', 'IM', 3.45, 31, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.b', 'IM', 3.41, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.3.c', 'IM', 2.50, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.a', 'IM', 3.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.b', 'IM', 3.72, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.4.c', 'IM', 4.13, 30, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.a', 'IM', 4.19, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.b', 'IM', 4.44, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.5.c', 'IM', 4.56, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.6', 'IM', 4.00, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.a', 'IM', 3.62, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2042.00', '1.C.7.b', 'IM', 4.59, 32, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.a', 'IM', 4.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.b', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.1.c', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.2.b', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.a', 'IM', 3.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.b', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.3.c', 'IM', 2.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.a', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.b', 'IM', 3.48, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.4.c', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.a', 'IM', 4.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.b', 'IM', 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.5.c', 'IM', 4.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.6', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.a', 'IM', 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2043.00', '1.C.7.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.a', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.b', 'IM', 3.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.1.c', 'IM', 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.2.b', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.a', 'IM', 3.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.b', 'IM', 2.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.3.c', 'IM', 2.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.a', 'IM', 3.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.b', 'IM', 3.07, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.4.c', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.a', 'IM', 4.26, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.b', 'IM', 4.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.5.c', 'IM', 4.30, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.6', 'IM', 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.a', 'IM', 4.07, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-2099.01', '1.C.7.b', 'IM', 4.67, 27, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.a', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.b', 'IM', 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.1.c', 'IM', 4.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.2.b', 'IM', 3.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.a', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.b', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.3.c', 'IM', 2.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.a', 'IM', 3.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.b', 'IM', 3.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.4.c', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.b', 'IM', 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.5.c', 'IM', 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.6', 'IM', 4.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.a', 'IM', 3.91, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.00', '1.C.7.b', 'IM', 4.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.a', 'IM', 4.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.b', 'IM', 4.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.1.c', 'IM', 4.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.2.b', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.a', 'IM', 3.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.b', 'IM', 2.26, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('19-3011.01', '1.C.3.c', 'IM', 2.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO work_styles (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_