/*! START TRANSACTION */;
CREATE TABLE tools_used (
  onetsoc_code CHARACTER(10) NOT NULL,
  example CHARACTER VARYING(150) NOT NULL,
  commodity_code DECIMAL(8,0) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (commodity_code) REFERENCES unspsc_reference(commodity_code));
/*! COMMIT */;
/*! START TRANSACTION */;

INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1011.03', 'Video teleconferencing systems', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Cell phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Credit card processing machines', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Handtrucks', 24101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Humidity test chambers', 41103418);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Magnetic card readers', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Point of sale POS systems', 43211505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Surveillance cameras', 46171610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1021.00', 'Vacuum test chambers', 41103305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1031.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1031.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-1031.00', 'Wireless desktop printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2011.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2021.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2022.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2022.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2022.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2022.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2022.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2032.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-2033.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Mobile phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3012.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Mobile phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Approach detection systems', 46171608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Explosives detectors', 46171635);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Fire alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Keyless entry systems', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Physical access control systems', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Video surveillance systems', 46171612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3013.01', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Access servers', 43222625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Computer tool kits', 27113203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'File servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Industry standard architecture/peripheral component interconnect ISA/PCI cards', 43201407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Internet Information Services IIS Servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Mid-range computers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Minicomputers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Netware servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Network interface cards NIC', 43201404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Network switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Print servers', 43201537);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Punchdown tools', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Robot automation tool', 43222627);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Storage servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3021.00', 'Workstations', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.01', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3031.03', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Air samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Combustible gas monitors', 26131701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Diesel reciprocating engine generator sets', 26111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Enclosed flares', 26131608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Gas leak detectors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Gas reciprocating engine generator sets', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Micro anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Multiple gas monitors', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Open flares', 26131608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Oxygen analyzers', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Pressure gauges', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Pressure valves', 40141604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Tape measures', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Taper gauges', 41111648);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Utility trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Automated diluters', 41121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Automated microplate ELISA readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Cellular assay equipment', 41115819);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Computer inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Electrophoresis equipment', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Fourier transfer infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Handheld data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Infrared spectroscopic equipment', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Laboratory analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Laboratory benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Laboratory extraction equipment', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Laboratory moisture balances', 41111513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Liquid chromatography equipment', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'pH analyzers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.01', 'Titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Diesel-powered generators', 26111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Large volume water pumps', 40151510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Material moving cranes', 24101623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.02', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Air monitoring equipment', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Ball valves', 40141607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Belt conveyor systems', 24101712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Dust and particulate respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Electric timing devices', 46171603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Emergency alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Fermentation processing vessels', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Flow control valves FCV', 40141609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Gate butterfly valves', 40141613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Glass graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Gravity convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Hand sampling pumps', 40151506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Hazardous material spill kits', 47131905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Moisture analyzers', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Mole sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'pH probes', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Reaction flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Sample ports', 41104015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Stop valves', 40141611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.03', 'Throttle control valves TCV', 40141609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Biomass boilers', 40102001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Bubbling fluidized bed boilers', 40102001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Circulating fluidized bed boilers', 40102001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Cooling towers', 40101703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Heat recovery steam generators', 26111608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Radial stackers', 24101708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Steam boilers', 40102002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Steam turbines', 26101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.04', 'Wood feed systems', 22101715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Dam water flow controls', 40142207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Electrical circuit breakers', 39121601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Electrical switch gear', 26131808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Hydraulic power generation equipment', 26111606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Hydroelectric power generator controls', 26131803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Impulse turbines', 26101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Power transformers', 39121002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Protective ear muffs', 46181902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Protective respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Reaction turbines', 26101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3051.06', 'Turbine generators', 26101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3061.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3061.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3061.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Barcode scanners', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Barcoding labels', 55121608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Cell phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Global positioning systems GPS', 25173107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Pallet jacks', 24101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Personal protective equipment', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Radio frequency handheld terminals', 43221721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Radio frequency identification RFID devices', 43211710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Radio frequency truck-mounted terminals', 43221721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.00', 'Wireless communication and satellite positioning tools', 43223209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.04', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.04', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3071.04', 'Radio frequency identification RFID scanners', 52161522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Optical disk drives', 43201811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3111.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3121.00', 'Audio recording equipment', 46171621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3121.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3121.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3121.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3121.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'MP3 players', 52161543);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-3131.00', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Adjustable hand wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Adjustable widemouth pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Aeration pumps', 40151501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Aerosol foggers', 21101805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Air compression equipment', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Animal blood collection syringes', 42121507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Animal feeders', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Animal transportation trailers', 25181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Animal vaccination syringes', 42121507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Aquaculture tanks', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Artificial insemination kits', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Backhoe attachments', 22101713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Backhoes', 22101509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Bar code readers', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Belt conveyor systems', 24101712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Bench scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Biological filters', 40161808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Branding equipment', 21101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Brush mowers', 21101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Cage nets', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Carbon dioxide systems', 21102303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Centrifugal water pumps', 40151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Chain saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Chemical sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Chipping equipment', 27112715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Circular saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Claw hammers', 27111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Clockwork belt feeders', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Composting equipment', 21101806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Cordless power drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Corn pickers', 21101703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Dew point meters', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Digital flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Dip nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Drainage pumps', 40151531);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Drip emitters', 21102501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Dump trucks', 25101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Egg gathering equipment', 21101906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Electric timing devices', 46171603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Extended pole pruners', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Extension ladders', 30191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Farm tractors', 25101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Farm trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fertigation equipment', 21102301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fertilizer injectors', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Field cultivators', 21101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Field watering systems', 21102502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish collection nets', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish crowders', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish egg counters', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish egg sorters', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish feeders', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish graders', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish holding pens', 10131601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish incubators', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish transfer pumps', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fish traps', 21111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Four wheel drive 4WD trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fry nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Fumigation equipment', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Garden hoes', 27112008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Gardening shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Gas-powered generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Grain combines', 21101704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Grain drills', 21101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Grain dryers', 23201202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Grain scales', 41111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Grease guns', 27112901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Hacksaws', 27111559);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Handheld dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Handsaws', 27111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Hay balers', 21101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Hay mowing machines', 21101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Hay trucks', 25101611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Humidifiers', 21102303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Humidity meters', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Hydroponic equipment', 21102302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Impact sprinklers', 21101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Lawn edgers', 27112015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Lawn mowers', 27112014);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Layout squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Light evaluation meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Line cutters', 27112015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Livestock castration equipment', 42121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Manure spreaders', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Materials conveyors', 24101712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Mechanized tilling equipment', 21101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Microsprinklers', 21101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Milking equipment', 21101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Mist control systems', 21102301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Mowing equipment', 21101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Mulch spreaders', 27112907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Multipurpose pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Multipurpose tractors', 25101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Oil dispensing cans', 27112905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Overhead sprinklers', 21101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Ozone generators', 47101541);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'pH probes', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Phillips screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Pipe wrenches', 27111749);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Pneumatic cutters', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Pneumatic pruners', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Pop-up sprinklers', 21101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Portable air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Portable dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Portable power saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Portable welding equipment', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Poultry incubators', 21101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Power augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Power monitors', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Power mowers', 27112014);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Power nail guns', 27112716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Power nail pullers', 27131528);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Powered trailers', 25181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Propane torches', 23271702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Pruning tools', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Radiant heaters', 41102404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Round metal files', 27111930);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Screen filters', 40161502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Seine reels', 21111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Skid steer machines', 22101529);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Snow blowers', 22101531);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Snowplow attachments', 22101710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Soil electrical conductivity measurement devices', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Soil mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Soil pasteurizers', 21102302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Soil thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Sport utility vehicles SUVs', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Spray attachments', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Steam sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Stereo light microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Straight screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Tanker trucks', 25101610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Temperature monitors', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Tongue and groove pliers', 27112112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Transplanting equipment', 21101602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Trenchers', 22101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Trickle irrigators', 21102501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Tubing cutters', 23241610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Turbine water pumps', 40151526);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Ultraviolet light UV water disinfection systems', 47101517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Utility forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Utility knives', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Water filters', 40161502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Water level monitors', 41112504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Water test kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Weedeaters', 21101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9013.00', 'Woodworking chisels', 27111906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'DroneDeploy', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Fixed wing unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Gas detection sensors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Large-format scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Multi-rotor unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Pocket personal computers PC', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'RGB cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Thermal imaging cameras', 45121522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9021.00', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Compact digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Emergency first aid kits', 42172001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Digital projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Fire alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Interactive whiteboards', 43211903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Public address PA systems', 45111705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9032.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9033.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9033.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9033.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9033.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9033.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Drawing tablets', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Absorption equipment', 47101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Bioreactors', 41104307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Dissolved oxygen monitors', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Distillation equipment', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Extraction equipment', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Fermentation systems', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Flocculators', 47101512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Flow indicators', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Forced convection incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Gas chromatograph mass spectrometers GC-MS', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Gel electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Glass flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'High pressure liquid chromatographs HPLC', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Inverted compound microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Level indicators', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Orbital incubating shakers', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Pressure indicators', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Temperature probes', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9041.01', 'Top-loading autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9051.00', 'Computerized cash registers', 44101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9051.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9051.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9051.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9071.00', 'Video surveillance systems', 46171612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Cash registers', 44101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Credit card processing machines', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Private automatic branch exchange PABX systems', 43221504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9081.00', 'Voice mail systems', 43221519);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9111.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9111.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9111.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9111.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Color plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Digital video equipment', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.01', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Automated water sampling equipment', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Chlorine testers', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Digital pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Dissolved oxygen indicators', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Gravitational field indicators', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Multiparameter water probes', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Nitrate meters', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Nitrite meters', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Plankton nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Rain gauges', 41114405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Seines', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Stream flow gauges', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Temperature gauges', 41112222);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Total dissolved solids TDS meters', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Water conductivity testers', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Water flow meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Water quality test kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9121.02', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Barcode scanners', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Credit card machines', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Date stamps', 44103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Digital postal scales', 41111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Electronic cash registers', 44101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Mail delivery trucks', 25101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Mail sorting equipment', 44102502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Point of sale POS computer terminals', 43211505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Postage canceling machines', 44102104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Postage meters', 44102101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Postage validation imprinters', 44102101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Time clocks', 44103207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Video monitoring systems', 46171612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9131.00', 'Warning flares', 39111714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Golf carts', 25101904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Lenel Onguard', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Step ladders', 30191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9141.00', 'Video surveillance cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9151.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9151.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9151.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9151.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9151.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Chemical protective boots', 46181602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Chemical protective clothing', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Emergency alert notification systems', 43221502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Hard hats', 46181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Protective hoods', 46181710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Radiation detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9161.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Airbrushing devices', 60121253);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Arterial tubes', 42262004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Body bridges', 42261703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Cannula sets', 42293501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Casket carriages', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Casket lowering devices', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Centrifugal force pumps', 40151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Chemical pillows', 47131908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Compaction tampers', 22101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Cremation stands', 42261802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Curved suture needles', 42312206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Dump trailers', 25181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Electric mortuary aspirators', 42262104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Embalming machines', 40151564);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Embalming tables', 42261703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Funeral church trucks', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Head blocks', 42261604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Hearses', 25101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Hydro-electric aspirators', 42262104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Hypodermic syringes', 42142609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Jugular drain tubes', 42262002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Ligators', 42291802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Local exhaust ventilation LEV systems', 40101502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mausoleum lifts', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Monument lifts', 22101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary bier pins', 31162407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary cots', 42261802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary dressing tables', 42261703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary lift systems', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary operating tables', 42261703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary roller systems', 24101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mortuary vans', 25101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Mouth formers', 42262102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Needle injector guns', 42262007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Nitrile gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Numbering machines', 44102402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Pallbearer casket carriages', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Passenger vehicles', 25101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Personal protective equipment', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Protective latex gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Scalpels', 42261505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Sink covers', 42262005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Trocars', 42291635);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Vault lowering devices', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9171.00', 'Viscera bags', 42261607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Automated external defibrillators AED', 42172101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Automatic blood pressure cuffs', 42181602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Body fat calipers', 42182704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Elliptical trainers', 49201516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Emergency medical aid kits', 42172001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Exercise treadmills', 49201501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Free weights', 49201606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Height measurement rulers', 42182703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Lower body weight machines', 49201603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Manual blood pressure cuffs', 42181603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Stationary exercise bicycles', 49201503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Upper body weight machines', 49201605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.01', 'Weight measurement scales', 41111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Electronic cash registers', 44101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Payment processing terminals', 43211505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9179.02', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.01', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.02', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Closed circuit television CCTV monitoring systems', 46171622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Fire alarm monitoring systems', 46182504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Physical access control systems', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Security alarm systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.08', 'Video surveillance systems', 46171612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Adjustable widemouth pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Adjustable wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Amp clamp meters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Fall arrest systems', 46182306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Field forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Hard hats', 46181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Hydraulic torque machines', 27112720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Infrared thermography cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Lubricant oil sampling kits', 41113320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Manual torque wrenches', 27111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Megohmmeters', 41113628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Phillips head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Protective ear muffs', 46181902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Recording anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Rigging equipment', 24101611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Safety line evacuation kits', 46191609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Straight screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Tower cranes', 24101623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Vibration analyis equipment', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.09', 'Voltage testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Barometric pressure sensors', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Cup anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Digital still cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Electronic temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Handheld global positioning system GPS units', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Portable meteorological stations', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Propeller anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Pyranometers', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Recording anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.10', 'Wind vanes', 41114409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('11-9199.11', 'Subcentimeter global positioning system GPS units', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1011.00', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Bulk weighing systems', 41111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Grain testers', 41112701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Livestock scales', 41111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1021.00', 'Precision rulers', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1022.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1022.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1022.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1022.00', 'Point of sale POS systems', 43211505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1023.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Event data recorders', 25173303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Field computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Measure markers', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Mobile wireless handheld communication devices', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1031.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Compact digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Electronic digital theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Hand calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Laser facsimile machines"', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Measure markers', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1032.00', 'Tire tread depth gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Barcode scanners', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Document scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Electric typewriters', 44102602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Facial recognition systems', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Fingerprint capture devices', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Fingerprint recognition systems', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Iris recognition systems', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'License or identification card printers', 43212110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Magnetic stripe readers', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Magnifying glasses', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Point of sale POS receipt printers', 43212112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Snellen eye charts', 42183001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Testing workstations', 43211510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Ultraviolet UV lights', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.00', 'Vision screening equipment', 42183034);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Aluminum ladders', 30191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Atmosphere monitors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Bacon bomb samplers', 41104004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Benthic grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Bladder pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Bottom fill bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Box corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Bucket augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Centrifugal water sampling pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Chlorine samplers', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Chlorophyll-a probes', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Colorimetric field sampling devices', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Composite liquid waste samplers COLIWASA', 41104006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Conductance meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Continuous flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Continuous water quality monitors', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Differential photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Dissolved oxygen probes', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Double check valve bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Ekman grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Enzyme immunoassay kits', 41113309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Extractive Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Fuel fluorescence detectors FFD', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Graphite furnace atomic absorption GFAA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Gravity corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Ground penetrating radar GPR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Groundwater sampling peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Hand corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Hand sampling pumps', 40151506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Headspace vials', 41121806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Helium-neon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Hydraulic vibracorers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Inductively coupled plasma ICP spectrophotometers', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Infrared IR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Ion selective electrode ISE testers', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Kemmerer depth samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Laboratory analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Laboratory dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Laser-induced breakdown spectrometers LIBS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Laser-induced fluorescence LIF instruments', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Liquid chromatographs LC', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Liquid grab samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Magnetic locators', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Measuring cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Membrane interface probes MIP', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Mercury vapor analyzers', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Mobile cone penetrometer MCP systems', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Optical beamsplitting devices', 31242201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Passive diffusion bag PDB samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Photoionization detectors PID', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Piezoelectric sensors', 41112101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Ponar dredge samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Pond samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Portable gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Portable mass spectrometers MS', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Portable two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Power augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Progressive cavity sampling pumps', 40151553);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Reciprocating piston sampling pumps', 40151557);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Rotary hammer systems', 20111608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Russian peat borers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Sample bottles', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Sample collection chambers', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Sampling triers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Sand corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Scaffolding', 30191502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Sediment sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Shelby tube samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Specific conductance probes', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Split core samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Split spoon samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Suction-lift pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Surface acoustic wave sensors SAWS', 41111939);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Syringe pumps', 41105104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Thief samplers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Total petroleum hydrocarbon TPH analyzers', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Turbidity probes', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Ultraviolet fluorescence UVF test kits', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Van Dorn samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Van Veen grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Volatile organic compound VOC measurement devices', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Waste pile samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Wastewater samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Water quality data sondes', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Water sampling gear pumps', 40151551);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Weighted bottle samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Wheaton dip samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'Wireline samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.01', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.03', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Radio frequency identification RFID scanners', 52161522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.04', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy bone saws', 42261512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy evidence collection kits', 42261904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy fluid collection vacuum aspirators', 42261610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy knives', 42261505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy saws', 42261512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Autopsy scissors', 42261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Bone cutters', 42261512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Bone dust collectors', 42261601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Cadaver lifts', 42261809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Dictation equipment', 44102605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Digital autopsy scales', 42261606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Dissecting knives', 42261505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Dissection forceps', 42261502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Dissection scissors', 42261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Enterotomes', 42261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Floor scales', 41111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Portable x ray machines', 42201815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Postmortem blood drawing syringes', 42261903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Postmortem fingerprint equipment', 42261901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Postmortem suturing needles', 42261508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Protective coveralls', 42131601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Protective eye shields', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Rib cutters', 42261512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Skull chisels', 42261506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Specimen collection containers', 42261607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Specimen scales', 42261606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Staining dishes', 41121810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Stryker saws', 42261512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Surgical gloves', 42132205);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Surgical masks', 42131713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Surgical scalpels', 42291613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Tabletop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Toothed forceps', 42261502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.06', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.07', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1041.08', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1051.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Digital video disk DVD players', 52161516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Liquid crystal display LCD projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Office inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Video projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1071.00', 'Web conferencing cameras', 45121506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Passenger cars', 25101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Pickup trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Smart phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1074.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Digital copiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Image scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Office inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1075.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Personal computer platforms', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Teradyne Catalyst', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Teradyne J750 testers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.00', 'Workstation platforms', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Multimedia projection equipment', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Multimedia projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1081.02', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1111.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1111.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1111.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1111.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1111.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Overhead display projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Public address PA systems', 45111705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Video projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1121.00', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Passenger cars', 25101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1131.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1141.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1141.00', 'Electronic storage devices', 43201803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1141.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1141.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1141.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Liquid crystal display LCD projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Overhead display projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1151.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.01', 'Domain name servers DNS', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.01', 'Teleconferencing equipment', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1161.01', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Computer server equipment', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Storage area network equipment', 43201835);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.04', 'Teleconferencing systems', 43221522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.05', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Credit card machines', 43211702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Dot matrix printers', 43212102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'External hard drives', 43202010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Label printers', 43212101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.06', 'Thumb drives', 43202010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Approach detection systems', 46171608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Audioconferencing equipment', 45111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Card readers', 46171524);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Closed circuit television CCTV monitoring systems', 46171622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Computer network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Computer server equipment', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Digital video recorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Electronic access control systems', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Intrusion detection systems', 46171604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Mechanical access control systems', 46171619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Network video recorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-1199.07', 'X ray screening equipment', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2011.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Appraisal, mapping, and comparison data reporting systems', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Carbon monoxide detectors', 41113120);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Electronic flood maps', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Electronic maps', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Flood Insights', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Handheld distance meters', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Laser measuring devices', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Mapping and geographic analysis systems', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Mapping or location-based analysis systems', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Real estate mapping and property description systems', 55111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2023.00', 'Ultrasonic distance measurers', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2031.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2031.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2041.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2041.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2041.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2051.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2052.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2053.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2053.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2053.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2053.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2053.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2054.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2061.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2061.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2061.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2061.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Financial calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Autodialers', 43221507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2072.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2081.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2082.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2082.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2082.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.01', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Digital still cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('13-2099.04', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Liquid crystal display LCD projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Medical image database systems', 42203603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Overhead projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1211.01', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Local area network LAN analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1212.00', 'Protocol analyzers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Articulated robots', 23153202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Cluster systems', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Distributed heterogeneous computers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'File servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Free-field speakers', 52161512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Graphics workstations', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Hard disk drives', 43201803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'High end computer servers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'High-performance cluster HPC computers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'High-speed networking testbeds', 43222604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Image capture devices', 43211718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Lighting grids', 39111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Magneto optical discs', 43202001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Massively parallel processors MPP', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Microcomputers', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Mobile robots', 23153202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Network interface cards NIC', 43201404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Network storage arrays', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Pan-tilt-zoom cameras', 45121505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Quarter inch cartridge QIC tapes', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Real time motion capture systems', 43211718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Render farms', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Stereographic projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Video projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1221.00', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Asynchronous transfer mode ATM analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Cable testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Caching engines', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Cisco Systems Cisco Application Visibility and Management AVM Traffic Collector', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Communications analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Continuity testers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Copy machines', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Fabric analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Fibre channel protocol analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Load balancers', 43222622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Network address translation NAT appliances', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Port analyzer adapters', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Powerline monitors', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Remote access servers', 43222625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Synchronous optical network SONET analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'T-Birds', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Test lights', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1231.00', 'Throughput testers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Computer tool kits', 27113203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Digital tapes', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'MS-DOS-bootable disks', 43202004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Punchdown tools', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Reflectometers', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1232.00', 'Wire crimpers', 27111518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Asynchronous transfer mode ATM analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Backup servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Bit error rate testers BERT', 41111917);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Broadband aggregation equipment', 43222632);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Cable analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Cable qualification testers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Channel banks', 43222611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Communication cable testers', 41113740);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Computer network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Computer network switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Domain name servers DNS', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Fiber optic power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'File servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Firewall equipment', 43222501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'High-end database servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Integrated services digital network ISDN analyzers', 41113715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Intelligent hubs', 43222610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Lightweight directory access protocol LDAP servers', 43222625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Link analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Load balancers', 43222622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Local area network LAN analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Local area network LAN switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Mail transport servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network cabling systems', 43223305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network channel service units CSU or data service units DSU', 43222611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network connectivity testers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network server load balancers', 43222622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Network-attached storage NAS equipment', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Optical spectrum analyzers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Packet analysis equipment', 43222634);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Protocol analyzers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Radio frequency RF antennas', 43221721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Remote access servers', 43222625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Storage area network SAN switches', 43222615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Synchronous optical network SONET analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'T-Birds', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Time domain reflectometers', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Voice over internet protocol VoIP systems', 43191508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Voice switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Wide area network WAN analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Wide area network WAN switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Wireless access points WAP', 43223108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Wireless local area network WLAN controllers', 43223108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Wireless network controllers', 43222644);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.00', 'Workstations', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Aerial bucket trucks', 22101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Amplifier probes', 41111928);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Cable analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Cable cutters', 23241616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Cable plows', 22101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Cable tie guns', 27112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Circuit testers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Coaxial cable testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Combo crimping tools', 27111518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Compaction tampers', 22101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Continuity testers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Digger derricks', 20111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Digital power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Electricity monitors', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic cable splicers', 39121718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic cable strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic fault locators', 41113716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic fusion splicers', 39121718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber optic tweezers', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fiber scribes', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Field inspection microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Fish tapes', 27113101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Flat head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Infrared fiber meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Infrared thermometers', 41112202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Insulation resistance testers', 41113623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Jack termination tools', 27111511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Local area network LAN analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Nut drivers', 27111702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Open end wrenches', 27111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Optical power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Optical time domain reflectometers OTDR', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Phillips head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Pipe benders', 27112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Polarity testers', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Portable drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Power saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Punch down insertion tools', 27112603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Radio interference detection RID devices', 41111926);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Soldering irons', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Tone generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Tone test sets', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Trenchers', 22101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Voltage testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Winches', 24101608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Wire locators', 41111930);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Wire mappers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Wire pullers', 27113101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1241.01', 'Wire wrap guns', 27112161);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Hard disk drives', 43201803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1242.00', 'Tape libraries', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Copy machines', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Hard disk drives', 43201803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Load balancers', 43222622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.00', 'Tape libraries', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Data warehouse appliances', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1243.01', 'Storage servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Asynchronous transfer mode ATM analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Bit error rate testers BERT', 41111917);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Cable verifiers', 26121630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Communications analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Computer tool kits', 27113203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Load balancers', 43222622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Network switches', 43222612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Optical spectrum analyzers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Optical time domain reflectometers OTDR', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Powerline monitors', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Protocol analyzers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Punchdown tools', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Redundant array of independent disks RAID systems', 43201802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Synchronous optical network SONET analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'T-Birds', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Tape libraries', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1244.00', 'Wire crimpers', 27111518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1251.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1251.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1251.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1251.00', 'Mainframe operating systems', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1251.00', 'Serial port cards', 43201559);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Application servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Directory servers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Flash disks', 43202005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Graphics processing unit GPU', 43201503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'In circuit emulators ICE', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Multi-core central processing unit CPU', 43201503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1252.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Application servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Computer network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Directory servers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Flash disks', 43202005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Graphics processing unit GPU', 43201503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'In circuit emulators ICE', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Mainframe operating systems', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Multi-core central processing unit CPU', 43201503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1253.00', 'Supercomputers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Application servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1254.00', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Application servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.00', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Audioconferencing systems', 45111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Smart phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1255.01', 'Video gaming equipment', 52161557);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.01', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Light detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Portable data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.02', 'Synthetic aperture radar SAR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Cloud computing servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Computer hard disk drives', 43201803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Content servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Magneto optical drives', 43201812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.03', 'Tape libraries', 43201806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Blade servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Computer network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Graphics display cards', 43201401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Lightweight directory access protocol LDAP servers', 43222625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Mass storage devices', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Motherboards', 43201513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Multi-conductor cables', 26121604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Radio frequency cables', 26121623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.08', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Application servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-1299.09', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2011.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Graphing calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Optical disk drives', 43201811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Supercomputers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2021.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2031.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2041.01', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Data warehouse appliances', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.01', 'Storage servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.02', 'Handheld computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2051.02', 'Smartphones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Computer clusters', 43211515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Computer workstation setups', 43211515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'High throughput screening HTS systems', 41105505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Network file servers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Nuclear magnetic resonance NMR spectrometers', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Semiconductor-based sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('15-2099.01', 'Web servers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Architectural templates', 44111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Arm drafting machines', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Circular saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Computer-guided milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Diazo copiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Disk grinding machines', 23101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Engineering copiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Fretsaws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Hand saws', 27111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Mat knives', 60121303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Mitre boxes', 60121409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Parallel bars', 27111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Precision knives', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Soldering irons', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Thermal saws', 27111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Track drafting machines', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1011.00', 'Triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Digital camcorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Aerial imagery mapping-grade global positioning systems GPS', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Analytical stereoplotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Automatic levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Color digital camera systems', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Color inkjet plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Digital camcorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Digital image printers', 43212114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Drafting instruments', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Drafting machines', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Film processors and editors', 45121704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'French curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Geodetic ground global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Lamination systems', 44102801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Large-format aerial digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Mapping grade global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Panoramic digital line cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Photo enlargers', 45121705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Photogrammetric scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Remote sensing equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'T-squares', 44111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Templates', 44111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Type lettering sets', 44111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Video thermal imagers', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1021.00', 'Windows servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Abney levels', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Automatic levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Automatic slope lasers', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Curvimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Depth gauge tapes', 41114201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Digital laser rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Digital measuring poles', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Direct elevation rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Distance meters', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Dot lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Double right-angle prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Electronic digital levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Electronic digital theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Elevator tripods', 56101536);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Gammon reels', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Geological compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Hand levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Handheld measuring lasers', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Integrated global positioning systems GPS', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Invisible beam lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Laser plumb bobs', 27111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Line lasers', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Long range reflectorless total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Machetes', 27112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Magnetic locators', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Measuring rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Mechanical theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Philadelphia rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Plumb bobs', 27111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Pocket personal computers PC', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Pocket transits', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Prism poles', 27112813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Prismless total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Reflectorless total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Right-angle prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Road measuring wheels', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Robotic total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Robotic tripods', 56101536);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Rod levels', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Rotary lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'San Francisco rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Side scan sonars', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Single-beam echo sounders', 41115502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Single-beam transducers', 41115502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Stereoscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Surveyors leveling rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Telescopic viewers', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Tracking lasers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Tribrachs', 41115310);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Tripods', 56101536);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.00', 'Visible beam lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Absolute gravimeters', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Alidades', 41114203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Chain saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Cone penetration test probes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Dual-frequency global positioning system GPS survey units', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Gravitational field indicators', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Hypsometers', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Laser levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Laser rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Machetes', 27112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Magnetic locaters', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Mechanical theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Relative gravimeters', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Robotic total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Seismic activity recorders', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Survey levels', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Surveying gradiometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-1022.01', 'Wireline samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Acoustic emissions systems', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Anechoic chambers', 41115302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Argon-ion lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Axial flow compressor facilities', 26101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Axial flow research fans', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Axial flow turbines', 26101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Centerless grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Cluster computers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Computer numerical controlled CNC milling machines', 23242506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Digital pressure gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Digital voltmeters DVM', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Electronic flight instrument systems EFIS', 25202103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Electronic pressure scanners', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Fatigue testing machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Fiber optic interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Flight management systems FMS', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Flight simulators', 25191504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Force transducers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Impact guns', 27131502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Impinging jet apparatus', 41103309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Laboratory centrifugal pumps', 41105103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Laser Doppler velocimeters LDV', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Laser velocimeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Load frames', 41114613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Multi-axis mills', 23242505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Parallel computers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Power microwave generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Propellant combustion chambers', 41103308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Push/pull dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Reflection polariscopes', 41115315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Strain gauge balances', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Surface grinding machines', 23241402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Terminal computers', 43211510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Ultrasonic inspection equipment', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'UNIX work stations', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Vacuum facilities', 41103305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Vibration isolation tables', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Wave analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2011.00', 'Welders', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2021.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', '3T scanners', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Acoustic measurement systems', 41111939);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Acousto-optic modulators', 32101528);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Activity monitoring devices', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Aerosol analyzers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Aerosol generators', 21101805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Anthropometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Arbitrary waveform generators', 60104801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Automated particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Automatic titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Axial-torsional testing systems', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bacteria-based biosensors', 41106203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Basic stamp microcontrollers', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bio-sensors', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bio-signal amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bio-signal simulators', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Biomagnetic imaging scanners', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Biomedical device electrical safety testers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Biomimetic robots', 23101519);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bioreactors', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Camcorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Capillary electrophoresis systems', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Cardiovascular prosthetic device testers', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Cell culture bioreactors', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Chemiluminescence analyzers', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Circuit analyzers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Condensation nuclei counters CNC', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Cone-plate viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Confocal laser scanning microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Contact angle goniometers', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Defibrillator testing devices', 42203501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Deflectors', 32141104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Deoxyribonucleic acid DNA synthesizers', 41105903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Digital luxmeters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Digital sonomicrometers', 41115502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Dissolved oxygen polarographic measurement devices', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Dissolved oxygen probes', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electrical particle detectors', 41115405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electroblotting apparatus', 41105311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electrode bevelers', 41115604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electrode pullers', 41115604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electroencephalography EEG equipment', 42182308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electromyographs EMG', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electroplating apparatus', 41115604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Electrosurgery testing devices', 41113615);
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Endovascular stent-graft testing instruments', 42295001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Environmental conditions measurement devices', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Environmental growth chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Enzymatic membrane reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Enzyme-linked immunosorbent assay ELISA plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Extruders', 23151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Eye tracking devices', 43211718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Fast protein liquid chromatographs FPLC', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Finger joint flexure testers', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Flash point detectors', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Flow control devices', 41103309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Fluorospectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Footswitch sensors', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Force platforms', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Frequency shifters', 32101535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Functional magnetic resonance imaging fMRI scanners', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Gas flow control systems', 41103310);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Gel documentation systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Glass micromolds', 31141503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Grass stimulators', 42141805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Grip dynamometers', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Hardness testing devices', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'High pressure liquid chromatographs HPLC', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'High-speed digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Immuno-sensors', 41116128);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Incubator performance analyzers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Insole sensors', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Intravenous IV pump analyzers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Inverted light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ion exchange purification systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ion trap mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Isolators', 32101522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Laser ablation machines', 23241505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Load sensors', 41113616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Low-pressure impactors', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Magnetic resonance imaging MRI systems', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Maskless photolithography equipment', 42203202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Material fatigue and dynamics characterization devices', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Material tension/compression testing devices', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Medical radiation dosimeters', 42203901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microbial fermenters', 41104307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microcontrollers', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microelectrodes', 41115604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microfluidic networks', 41103314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Micromanipulation microrheology microscopes', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Micromolding lithography equipment', 31141501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microplate spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microplate washers', 41103207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microplating equipment', 41113036);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Micropumps', 42192604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Microvalves', 42192604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Molecular cytosensors', 42181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Molecular vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Motion actuators', 31251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Multi-axis kinematic knee simulators', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Multi-photon microscopes', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Non-invasive blood pressure monitor analyzers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Optical coherence tomography OCT scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Optical particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Optical particle detectors', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Optical tomographic imaging scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Optical traps', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Opto-electronic electrogoniometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Orbital shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Oxygen meters', 41111924);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pacemaker analyzers', 42203501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pacemaker testing devices', 42203501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Particle size classifiers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Patient monitoring testing devices', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Physical conditioning treadmill exercisers', 49201501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Piezoelectric ceramic transducers', 41112101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Piezoelectric sensors', 41112101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pinch gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Plant photosynthesis meters', 41106702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Plasma excitation chambers', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Plastic injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Polygraph recorders', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Polymer matrices', 41122107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Polymer scaffolds', 41122107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Positron emission tomography PET scanners', 42202401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Posturographic measurement systems', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pressure and temperature measurement devices', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pressure sensors', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pressure transducers', 41112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Prosthetic limb testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Protein gel electrophoresis', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pulsating bubble surfactometers PBS', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Pulse oximeters', 42181801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Quadrupole mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Quantum-based switching applications Q-switch electron waveguides', 41113634);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Radiation compliance testing devices', 42203901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Radio frequency amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Rapid toxicity testing systems', 41106203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Real-time polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Refractive index detectors', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Servopneumatic actuators', 31251504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Servopneumatic axial test instruments', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Single photon emission computed tomography SPECT scanners', 42202501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Skinfold calipers', 42182704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Soft materials in-vitro simulation system', 41102910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Spinal disk implant wear testers', 41114625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Spine simulators', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Spirometers', 42271602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Sterilization-in-place equipment', 42281521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Strain gauge conditioners', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Sublimation printers', 43212103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Sugar analyzers', 41113323);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Superconducting quantum interference devices SQUID', 41101806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Surface area analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Tensionmeters', 41114509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Torsiometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Total organic carbon TOC analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Toxic gas detectors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Two-point discriminators', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultra high speed magnetic resonance imaging MRI scanner machines', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultrasonic testing apparatus', 42201712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultrasound imaging scanners', 42201712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultrasound indention probes', 42201706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultrasound transducers', 42201711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultrasound wattmeters', 41113640);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultraviolet spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ultraviolet spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Ventilator performance analyzers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'Viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'X ray lithography equipment', 42203201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2031.00', 'X ray machines', 42201815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Agitators', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Benchtop mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Catalytic reactors', 41113102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Chromatographic scanning equipment', 41115702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Distillation columns', 41104812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Distillation systems', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Filtration systems', 41104925);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Gas absorbers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Heat exchangers', 40101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Laboratory evaporaters', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Lyophilizers', 23151807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Mixing tanks', 24111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Plate filter presses', 47101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Powder mixing equipment', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Sludge dryers', 47101525);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Surface analysis spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Vacuum pumps', 40151502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Vial handling systems', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2041.00', 'Wet scrubbers', 40161702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Blueprint copiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Drafting scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Drafting triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Electronic distance measuring devices', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Laser levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Microfilm readers', 45112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Precision levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Radar guns', 41111921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Rhodes arcs', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Rolling scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Steel rules', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Surveying rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Surveying wheels', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Thickness gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Traffic counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.01', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2051.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Alternating current AC power analyzers', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Alternating current AC power sources', 26101112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Bit error rate testers BERT', 41111917);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Circuit memory testers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Circuit testers', 41113642);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Color plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Communications analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Communications signal analyzers', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Digital analysis systems DAS', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Direct current DC power supplies', 26101209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Dynamic signal analyzers', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Feeler gauges', 41111617);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Impedance analyzers', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Inspection scopes', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Isolators', 32101522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Logic probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Power sensors', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Probe card devices', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Probe stations', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Protocol analyzers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Protocol exercisers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Pulse generators', 41113636);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Resistance meters', 41113635);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Sampling oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Signal source analyzers', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Thermal chambers', 41103412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Traffic generators', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Universal source generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Voltage sensors', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2061.00', 'Waveform generators', 60104801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Annealing furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Auger electron spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Cylindrical corona testers', 23152001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Diffractometers', 41101810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Diffusion furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Digital voltmeters DVM', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Doping tubes', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Electrical flow meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Electrochemical CV dopant profilers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Electrochemical etching devices', 27112305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Electron beam evaporators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Filament evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Fog chambers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Frequency drives', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Glove box systems', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Imaging spectrographs', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Laser ranging systems', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Linearization testbeds', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Low pressure chemical vapor deposition LPCVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Metal evaporation systems', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Microwave automatic load-pull tuners', 43221707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Microwave power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Mixed signal oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Molecular beam epitaxy MBE systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Noise figure meters', 41115305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Oxidation furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Oxidation tubes', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Parameter analyzers', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Pattern generator systems', 32101613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Photolithography equipment', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Photoluminescence spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Plasma ashers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Plasma reactors', 39121015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Programmable function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Pulse generators', 41113636);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Pulsed current-voltage IV analyzer', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Pyrometers', 41112204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Reactive ion etch systems', 41101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Sampling oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Secondary ion mass spectrometers SIMS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Signal analyzers', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Spin-coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Spinners', 41122401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Sweep oscillators', 41113632);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Synthesized continuous wave CW generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Tube etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Universal microwave transistor test fixtures', 41113707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Vacuum chambers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Vacuum system/thermal evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Vector signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Vertical furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Wafer steppers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Wet chemical clean benches', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'X ray guns', 41101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2071.00', 'X ray photoemission spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Communication bus analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Electronics counters', 41111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Electronics probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'High-power pulsed lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Microprocessors', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Wattmeters', 41113640);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.00', 'Wave meters', 41115301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Barcode scanners', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Cell phones', 43191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Computer network routers', 43222609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Local area network LAN analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Radio frequency identification RFID devices', 43211710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2072.01', 'Radio frequency RF antennas', 43221721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Air incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Air velocity meters', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Ambient air measurement devices', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Anaerobic growth chambers', 41103407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Argon ionization detectors', 41113626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Atomic absorption AA spectrophotometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Automatic titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Biological oxidizers', 41104002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'California bearing ratio CBR testing devices', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Capillary electrophoresis systems', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Chemostats', 41106203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Combustible gas meters', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Consolidometers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Core drill rigs', 20102007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Direct shear testing devices', 41114619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Electric pumps', 40151508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Electron capture detectors ECD', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Environmental probe systems', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Epifluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Flame emission detectors', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Fluorescence detectors', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Gas meters', 41112508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Geoprobes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Glove box systems', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Graphite furnaces', 41104604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Headspace autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Hydrological current meters', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Individual burner air measurement IBAM probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Interferometeric refractormeters', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Laser photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Limnological core loggers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Limnological coring drills', 20102007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Liquid chromatography detectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Liquid ring pumps', 40151502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Liquid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Luminometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Mercury/hybrid atomizers', 40141742);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Microbics toxicity analyzers', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Microwave digestion instruments', 41104507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Mud rotary drills', 20111611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Multi gas detector tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Multiparameter water quality instruments', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Nitrogen oxide burners', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Nutrient analyzers', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Organic carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Ozonators', 41113111);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Particulate filters', 40161506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Pitot tubes', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Plasma-mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Respirometers', 41113119);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Sample concentrators', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Sampling trains', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Scanning potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Seismographs', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Soil carbon-nitrogen CN analyzers', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Soil electrical conductivity measurement devices', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Soil modulus failure testing devices', 41113902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Soil-erodability testing devices', 41113902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Solid shear failure testing devices', 41114619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Sorbent tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Stem augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Stormwater samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Supercritical fluid extractors', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Surface area analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Thermal conductivity detectors', 41113114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Thermal/catalytic oxidizers TCO', 41104002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Total organic carbon TOC analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Trace metal analyzers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Ultraviolet UV light detectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Ultraviolet water purification systems', 41104205);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Universal fractionators', 41104811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Wave gauges', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2081.00', 'Whole air canisters', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Accelerated ageing testers', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Acoustic calibrators', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Aerosol sampling devices', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Anthropometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Ball pressure testers', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Bump testers', 41114620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Cold bend testers', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Cord anchorage pull machines', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Cord anchorage test devices', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital force gauges', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital video recorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Digital wattmeters', 41113640);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Direct current stability testing devices', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Discriminative reaction time apparatus', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Dust chambers', 41103511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Dynamic mechanical analyzers DMA', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Electric iron drop test machines', 41114620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Electrogoniometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Electrolytic corrosion testing equipment', 41114604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Electromyograph processing systems', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Feeler gauges', 41111617);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Flame hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Flex testing machines', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Flicker-fusion meters', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Force gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Force platforms', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Force transducers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Fourier transform infrared FTIR spectroscopy gas analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Glow wire testers', 41113607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Hand dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Heart rate monitors', 42181903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Heat stress monitors', 41113607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'High-flow air sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'High-pot testers', 20122403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'High-volume asbestos sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Humidity test chambers', 41103418);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Impact hammers', 41116401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Impact test balls', 41114620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Inclinometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Insulation resistance testers', 41113623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Ion chamber survey meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Isokinetic dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Isolation transformers', 39121003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Light meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Line leakage testers', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Lumbar motion monitors', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Magnetic field meters', 41113614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Microbial contaminant measurement devices', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Motion capture systems', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Multi-vapor reading instruments', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Noise dosimeters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Noise monitoring equipment', 41111939);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Octave band analyzers', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Ohmmeters', 41113631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Oscillating spray testers', 41101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Oxygen bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Oxygen index apparatus', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Particulate measurement devices', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Pendulum impact apparatus', 41114620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Physiographic recorders', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Pinch meters', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Portable oxygen consumption meters', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Push/pull dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Pycnometers', 41103316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Radio frequency signal analyzers', 43211710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Reaction time simulators', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Reference frame dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Repose angle measuring devices', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Respiratory flow rate meters', 42271602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Rheostats', 39121009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Rise of resistance measurement systems', 41113635);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Sampling probes', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Slipmeters', 60104605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Socket outlet test machines', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Socket outlet torque balance testers', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Sorbent dosimeters', 41113113);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Sorbent tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Strength evaluation systems', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Surge testing devices', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Switch testing devices', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Temperature gauges', 41112222);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Thermocouple temperature probes', 41112219);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Thermogravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Three-dimensional laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Torque gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Torsion meters', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Tribometers', 41114625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Tumbling barrel test machines', 41114620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Variable transformers', 39121003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Velometers', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Vibration analyis equipment', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Vibration testers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Volatile organic compound VOC measurement devices', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.00', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Collection hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Cone calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Counter-flow slot burners CSB', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Flame spread testers', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Flammability testers', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Floor-ceiling furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Flow tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Furniture calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Heat flux transducers', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Heat sinks', 32131001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Helium-neon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Horizontal furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Intermediate scale calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Mass flow controllers', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Methane burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Optical filters', 31241807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Orifice-plate flowmeters', 41112513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Oxygen analyzers', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Oxygen depletion calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Photoelectric cells', 32141009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Propane diffusion flame burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Radiant heaters', 41102404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Room calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Sampling probes', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Silica-carbide fiber sensors', 41112103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Silicon photodiodes', 32111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Smoke density testers', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Steiner tunnel furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2111.02', 'Wall panel furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Anechoic auditory test chambers', 41115302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Anthropometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Audio amplifiers', 32101629);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Audio equalizers', 52161517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Audio tape recorders', 52161502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Audiometers', 42182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Camera controllers', 45121623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Electrogoniometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Electrophysics infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Environmental ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Fast Fourier transform FFT spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Force plates', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Heart rate monitors', 42181903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Heated environmental chambers', 41103412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Hydraulic power units', 26101304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Inverted metallurgical microscopes', 41111718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Microcontrollers', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Motion control systems', 26111527);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Noise dosimeters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Octave band analyzers', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Optical benches', 56122001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Oxygen uptake measurement devices', 42271515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Pressure transducers', 41112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Programmable logic controller PLC controlled turntables', 24101711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Pulsed width modulation PWM drives', 26131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Radiometers', 60104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Recording microphones', 52161520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Reverberant auditory test chambers', 41115505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Sound level calibrators', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Time delay relay panel boxes', 39122329);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Torsion meters', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Variable frequency drives VFD', 32101625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.00', 'Vibration tables', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Algometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Anthropometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Automated blood pressure measurement equipment', 42181602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Body fat measurement calipers', 42182704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Digital force gauges', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Electrocardiography EKG monitors', 42181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Electroencephalography EEG equipment', 42182308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Electromagnetic motion analysis systems', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Electromyograph processing systems', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Electronic distance measuring devices', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Exercise treadmills', 49201501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Flight simulation equipment', 25191504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Goniometers or arthrometers', 42182701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Hand dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Hand sensor gloves', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Haptic devices', 43211713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Heart rate monitors', 42181903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Heat stress meters', 41113607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Inclinometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Interactive whiteboards', 43211903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Isokinetic dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Laser Doppler flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Light meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Lumbar motion monitors', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Manual blood pressure measurement equipment', 42181603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Microphones', 52161520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Motion capture systems', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Noise meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Octave band analyzers', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Oxygen analyzers', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Push/pull dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Sling psychrometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Torsiometers', 41111912);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Touch screen monitors', 43211903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Velometers', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Video goggles', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.01', 'Video projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Flow sensors', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Gel electrophoresis systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'In-target probes ITP', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Network protocol analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Pressure sensors', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Protocol analyzers', 41113718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Tektronix Communications Network & Service Analyzer NSA', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.02', 'Thermal validation systems', 41113114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2112.03', 'Scientific calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Hard hats', 46181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2121.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Abrasion testers', 41114601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Accelerated weathering machines', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Acoustic impediography equipment', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Adhesion testers', 41114614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Adiabatic bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Atomic absorption AA spectrophotometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Attritors', 23151604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Balling drums', 23191102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Band saws', 23241509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Binocular compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Cement mixers', 22101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Charpy impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Compression testing machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Computer numerical controlled CNC milling machines', 23242506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Concrete test hammers', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Counter-current mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Current versus voltage IV curve tracers', 41111908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Deionizers', 41101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Differential thermal analyzers', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Diffractometers', 41101810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Digitizing oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Drop weight impact towers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Durometers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Electrometers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Electron microprobe analyzers EMPA', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Electrostatic separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Energy dispersive x-ray spectrometers EDS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Etching equipment', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Extensometers', 41114503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Fiberscopes', 41111716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Film thickness measurement systems', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Filter presses', 40161506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Flame photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Flotation columns', 23201005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Fourier transform infrared FTIR spectroscopes', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Freeze-thaw test units', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Friction and wear testers', 41114625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Gas detectors', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Gauss meters', 41113614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Gel permeation chromatographs GPC', 41115702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Graphite element furnaces', 41104604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Gyratory crushers', 20101704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Heated walk-in environmental chambers', 41103412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'High temperature material testing systems', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'High tension separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'High-vacuum tensile testing chambers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Holding jigs', 23153018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Hot blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Inert atmosphere box furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Infrared monitors', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Isodynamic separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Jar mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Jaw crushers', 20101706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Kneading compactors', 22101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory microwave ovens', 41104507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory pulverizers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory sample splitters', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory test sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laminators', 44102801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Lapping wheels', 27111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Laser Doppler velocimeters LDV', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Linear variable differential transformers LVDT', 41111945);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Liquid conditioners', 47101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Load frames', 41114613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Magnetic separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Magnetic susceptibility balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Masonry cutters', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Mechanical sieve shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Melt spinners', 41104605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Micromanipulators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Microscope photo attachments', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Microwave autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Microwave sintering furnaces', 41103308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Microwave tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Molecular pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Optical emission spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Oscillating water tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Permeability measuring devices', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'pH testers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Pit depth gauges', 41112401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Plasma-arc furnaces', 41103308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Polishing machines', 23151604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Porosity indicators', 41113907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Pycnometers', 41103316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Reflectometers', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Rod mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Roll crushers', 20101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Rotating furnaces', 41103308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Sample presses', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Sanding machines', 27131507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Screw-driven test machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Servohydraulic test machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Slurry blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Solar simulators', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Solid state laser systems', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Solvent dryers', 41104508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Sonometers', 41115502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Specific gravity balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Spectrocolorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Stabilometers', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Stereo microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Temperature regulated shaking water baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Tension gauges', 41114509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Thermal analysis systems', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Thermogravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Twin screw extruders', 23191102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Twin-screw extruders', 23191102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ultrasonic baths', 41103712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ultrasonic dismembrators', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ultrasonicators', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ultrasound inspection equipment', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Ultraviolet UV exposure units', 41102410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Vacuum coating systems', 23151705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Vacuum evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Vacuum furnaces', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Vibration analysis equipment', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Viscosity meters', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Water burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Water-cooled saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'Wind tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'X ray fluorescence XRF analyzers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2131.00', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Acoustic emission AE sensors', 41111939);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Analog to digital converters', 32101631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Anodic wafer bonding systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Chemical-mechanical polishing equipment', 23151604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Computed tomography CT systems', 42201501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Contact lithography equipment', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Contact testers', 41113620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Cryogenic apparatus', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Deep reactive ion etchers DRIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Digital particle image velocimeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Digital to analog converters', 32101631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Dynamic strain indicators', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Environmental testing chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Evaporation systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Flip-chip wafer bonding systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Fluorescence spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Force transducers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Fused deposition modeling FDM machines', 23261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Heat exchangers', 40101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Infrared thermography cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Interferometric microscopes', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Laser digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Laser Doppler anemometers', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Laser Doppler velocimeters LDV', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Multi-pen plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Nano indentation systems', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Optical laser scanners', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Optical sensors', 41112103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Photoelastic testing machines', 41114615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Pitot tubes', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Plasma etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Position transducers', 41111926);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Precision positioning tables', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Projection lithography equipment', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Radio frequency sensors', 41111926);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Rapid thermal processing systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Servohydraulic material testing machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Spin-coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Sputtering systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Steppers', 26111516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Stylus profilometers', 41114618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Subsonic wind tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Supersonic wind tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Surface profilometers', 41114618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Torque transducers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Torsional converters', 26111519);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Vapor deposition tube furnaces', 41104604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Velocity transducers', 41111921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Vibration control systems', 23153130);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Vibration isolators', 23153130);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Vibration testers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Video editing equipment', 45111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Wafer bonding systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Wafer dicing saws', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'Wire electrical discharge machines', 23101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'X ray radiographic systems', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.00', 'X ray tubes', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Digital sonifiers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Dilatometers', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Flow reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Fluorescence detectors', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Fourier transfer infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Frequency response analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Fuel cell test stands', 23152203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Gravity convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'High pressure liquid chromatographs HPLC', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'High temperature tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Induction furnaces', 41104605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Infrared IR spectrophotometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Laboratory ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Laboratory glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Laboratory vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Load boxes', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Molding presses', 23181511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Portable emissions analyzers', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Power analyzers', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Scanning spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Surface area analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Thermal gravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Thermovolumetric analyzers TVA', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'Ultrasonic blenders', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'X ray crystallography equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.01', 'X ray photoelectric spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Anechoic chambers', 41115302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Bench drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Bench grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Carbon dioxide analyzers', 41113119);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Climate test chambers', 41115302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Disc finishing machines', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Engine test dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Five-axis machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Floor drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Gas analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Horizontal band saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Hydraulic hoists', 24101602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Hydraulic winches', 24101608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Hydrogen analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Laminar flow elements', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Metal inert gas MIG welders', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Miliohm meters', 41113631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Multitasking lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Overhead cranes', 24101620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Oxygen analyzers', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Plasma cutters', 23271404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Pressure gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Pressure indicators', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Pressure transducers', 41112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Rotary vehicle lifts', 24101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Sand blasters', 23281703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Three-axis vertical mills', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Three-dimensional prototyping printer', 23261507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Torque gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Transmission dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Vertical bandsaws', 23231101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Welders', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Wind tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2141.02', 'Workshop cranes', 24101630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Color plotting printers', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Combustible gas detectors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Digital plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Directional compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Geological hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Stratum compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2151.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Anticontamination clothing', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Face masks', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Nuclear wireline logging instruments', 20121906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Reactivity computer systems', 26142106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2161.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2171.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2171.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2171.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2171.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2171.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Air current testers', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Blower doors', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Digital infrared thermometers', 41112202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Draft gauges', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Handheld digital thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Heating system combustion analyzers', 41113102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Bandsaws', 23241509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Computer numerically controlled CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Power grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Precision positioning tables', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.05', 'Soldering irons', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Atomic force microscopes AFM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Atomic layer deposition ALD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Chemical mechanical polishing CMP systems', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Contact angle measurement systems', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Contact mask aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Countdown timers', 46171603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Critical point dryers', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Curve tracers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Deionized water systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Die saws', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Direct current DC sputtering systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Dry etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Electrochemical analyzers', 41113003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Electron beam evaporators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Electronic balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Extractive Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Four point probes', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Hotplates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Impedance meters', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Inductively coupled plasma reactive ion etchers ICP-RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Inspection microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Isolation glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Laminar flow flume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Laser ablation thin film deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Mechanical probe stations', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Metal evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Oxidation furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Parametric testers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Parylene coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Photoresist dispensing systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Picoammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Plasma enhanced chemical vapor deposition PECVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Plasma etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Polarimeters', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Pulse generators', 41113636);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Radio frequency RF sputtering systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Raman scattering spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Resistivity measurement systems', 41113635);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Semiconductor parameter analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Spectroscopic ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Spin coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Sputter deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Stepper aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Thermal chambers', 41103412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Thin film deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Thin film measurement systems', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Time interval analyzers', 41113709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Ultraviolet ozone cleaners', 42281501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Vacuum chambers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Vibration measurement systems', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Wet chemical etching systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.06', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Argon-ion lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Atomic force microscopes AFM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Autocorrelators', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Bench refractometers', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Chemical hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Chemical mechanical polishing CMP systems', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Coherent anti-Stokes Raman scattering CARS microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Confocal fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Contact lithography systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Current monitors', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Deconvolution fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Digital panel meters', 41111908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Digital storage oscilloscopes DSO', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Electron beam lithography systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Extreme ultraviolet lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Femtosecond lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Fluorescence lifetime spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Infrared viewers', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Isolation glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Laser beam profilers', 41115322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Laser Doppler vibrometers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Laser tweezers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Line scan cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Microprobe stations', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Near field scanning optical microscopes NSOM', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Near infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Nitrogen lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Optical choppers', 31242208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Optical fiber cleavers', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Optical power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Optical spectrum analyzers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Optical time domain reflectometers OTDR', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Oxidation furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Photodetectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Photodiode array detectors', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Photon counting systems', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Plasma enhanced chemical vapor deposition PECVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Polarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Probe test stations', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Pulse generators', 41113636);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Raman microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Reactive ion etchers RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Semiconductor parameter analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Single photon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Spin coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Streak cameras', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Total internal reflection fluorescence TIRF microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Tunable diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Tunable dye lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Vacuum deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Wavelength meters', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.07', 'Xenon arc lamps', 39101625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Bar code readers', 43211701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Signal conditioners', 39121020);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Sonar rings', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Torque meters', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Vision systems', 43211718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.08', 'Welding gun torches', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ashing systems', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Atmospheric furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Atomic absorption spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Atomic force microscopes AFM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Atomic layer deposition ALD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Capacitance meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Capacitance-voltage C-V plotters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Chemical mechanical polishing CMP systems', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Computer servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Confocal Raman microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Contact mask aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Critical point dryers', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Cryocut microtomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Differential interference contrast DIC microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Downstream strippers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Electron beam evaporators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Electron beam lithography systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Energy dispersive x-ray EDX spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Field emission scanning electron microscopes FESEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Filament evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Fluorescence optical microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Focused ion beam scanning electron microscopes FIB-SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Four-point probes', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Goniometers or arthrometers', 42182701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Graphics processing units GPU', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Handheld refractometers', 41115313);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Image reversal ovens', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Impedance analyzers', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Inductively coupled plasma reactive ion etchers ICP-RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Infrared microscopes', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ion mills', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Isolation glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Lapping machines', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Laser flash systems', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Laser pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Laser scanning confocal microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Low pressure chemical vapor deposition LPCVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Magnetron sputtering systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Mask writers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Metal-organic chemical vapor deposition MOCVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Molecular beam epitaxy MBE systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Nanoimprint lithography NIL systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Optical inspection microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Optical pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Optical profilers', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Oxidation furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Oxide etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Parylene deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Plasma cleaning systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Plasma enhanced chemical vapor deposition PECVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Probe stations', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Pulsed laser systems', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Raman scattering microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Raman scattering spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Reciprocating shaker water baths', 41103711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Resistance evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Scanning auger microscopes', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Scanning ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Secondary ion mass spectrometers SIMS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Semiconductor parameter analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Spectroscopic ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Spin dryers', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Spin rinse dryers', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Sputter coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Surface charge analyzers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Surface profilers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Temperature controllers', 41112214);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Thermal evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Tunable lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ultramicrotomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ultrasonic cutters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Ultraviolet UV exposure units', 41102410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Video microscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Wafer bond aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Wafer bonding systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Wafer saws', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Wafer spinners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'X-ray photoelectron spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.09', 'Zeta potential analyzers', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Barometric pressure sensors', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Cup anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Digital still cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Electronic temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Handheld global positioning system GPS units', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Light detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Portable meteorological stations', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Propeller anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Pyranometers', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Recording anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Sonic detection and ranging SODAR equipment', 41114409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.10', 'Wind vanes', 41114409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Abrasion testers', 41114601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Accelerated weathering machines', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Adhesion testers', 41114614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Apparent power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Atomic absorption spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Auger electron spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Bench ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Chronopotentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Compression testers', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Copy machines', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Coulometers', 41101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Creep testers', 41114606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Current versus voltage IV curve tracers', 41111908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Data loggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Digital imaging microscopes', 41111737);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Digital pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Digital resistance thermometers', 41112211);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Direct current DC power supplies', 26101209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Electrometers', 41113615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Electron beam evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Electron energy loss spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Energy dispersive x-ray spectrometers EDS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Environmental chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Fatigue testers', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Field emission scanning electron microscopes FESEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Film extruders', 23151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Flexure testers', 41114623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Flow coulometric detectors', 41101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Focused ion beam FIB systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Goniometers or arthrometers', 42182701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Graphics tablets', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Hand calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'High-precision balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Hipot testers', 20122403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Humidity ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Inert atmosphere glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Ion beam assisted deposition IBAD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Ion mills', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Irradiance detectors', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Laboratory tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Lifetime testers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Liquid chromatographs LC', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Load frames', 41114613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Mask aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Mechanical shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Meggers', 41113628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Micromanipulators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Moisture analyzers', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Optical scanners', 43211717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Permeation testers', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Phase angle meters', 41115305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Photoluminescence spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Photovoltaic array simulators', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Picoammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Plasma enhanced chemical vapor deposition PECVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Polarographic analyzers', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Power quality meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Pull testers', 27113101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Pyranometers', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Raman spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Reactive power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Recording ammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Reflectance spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Shear testers', 41114619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Solar simulators', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Spectrocolorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Spectroscopic ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Spin coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Sputtering systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Surface profilometers', 41114618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Thermogravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Thermopiles', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Ultraviolet UV exposure units', 41102410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Vacuum evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Vacuum laminators', 44102801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Video cameras', 45121515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-2199.11', 'X-ray photoelectron spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Architects'' scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Backlit digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Computer aided design CAD multi-unit display graphics cards', 43201401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Electronic scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Estimating keypads', 43211713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Flexible curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'French curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Graphics tablets', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Large-format digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Pressure-sensitive graphic tablets', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Print servers', 43201537);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Sonic digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'T-squares', 44111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Three-dimensional laser digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Three-dimensional motion controllers', 43211708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Three-dimensional stereoscopic projectors', 45111609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3011.00', 'Wide-format document scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Drafting curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Drafting machines', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Drafting triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'Steel rules', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3012.00', 'T-squares', 44111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Architects'' scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Backlit digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Computer aided design CAD multi-unit display graphics cards', 43201401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Cutting plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Electronic scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Estimating keypads', 43211713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Flexible curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'French curves', 44111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Graphics tablets', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Large-format digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Print servers', 43201537);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Sonic digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'T-squares', 44111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Three-dimensional laser digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Three-dimensional motion controllers', 43211708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3013.00', 'Wide-format document scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Accelerometer sensors', 41111921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Adjustable wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Air drills', 27131505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Air-supplying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Aligning punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Alignment squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Allen wrenches', 27111710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Annealing ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Aviation snips', 27111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Ball peen hammers', 27111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Bench vises', 27112102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Bleeder wrenches', 27111714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Body harnesses', 46182306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Bore gauges', 41111647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Borescopes', 41111716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Bottoming taps', 23241615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Box end wrenches', 27111705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Brazing equipment', 23271821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Brazing hearths', 23271821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Bubble emission inspection equipment', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Center punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Combination wrenches', 27111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Computer numerical controlled CNC milling machines', 23242506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Countersinks', 27112812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Depth gauges', 41112401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Depth micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Dial calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Digital force gauges', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Digital height gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Digital torque wrenches', 27111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Drive punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Dye penetrant inspection equipment', 41111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Eddy current inspection equipment', 41111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Electronic torque testers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Flat files', 27111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Flat head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Fluorescent penetrant inspection equipment', 41111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Force transducers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Gamma ray testing equipment', 41111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Gantry mills', 23242504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Gas arc welding equipment', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Gauge blocks', 41111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Go/no-go gauges', 41111619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Gyroscopes', 41111918);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Hacksaws', 27111559);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Half-round files', 27111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Hand snips', 27111519);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Hook spanner wrenches', 27111726);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Hydrasets', 24101610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Impact hammers', 41116401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Infrared inspection equipment', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Knife files', 27111943);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Layout compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Magnetic particle inspection equipment', 41111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Mallets', 27111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Mill files', 27111940);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Multi-axis mills', 23242505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Offset screwdrivers', 27111767);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Open end wrenches', 27111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Overhead cranes', 24101620);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Paint booths', 23153501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Pin punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Planer gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Plug gauges', 41111619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Plug taps', 23241615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Power screwdrivers', 27112710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Precision files', 27111944);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Pressure gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Prick punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Purifying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Pyrotechnic initiators', 12131704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Reed and Prince screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Riveting tools', 27112402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Round files', 27111930);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Safety lanyards', 46182302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Safety wire pliers', 27112160);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Scaffolding', 30191502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Scribers', 27112303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Shakers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Shielded arc welding tools', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Shot peening equipment', 23101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Skin mills', 23242505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Small hole gauges', 41111647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Snap gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Socket wrenches', 27111704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Soft face hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Soldering irons', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Split dies', 27112810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Spring calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Steel rules', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Straight chisels', 27111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Straightedges', 27111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Strain gauge balances', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Taper taps', 23241615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Telescoping gauges', 41111646);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Terminal computers', 43211510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Thickness gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Thread gauges', 41111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Torque wrenches', 27111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Torx drivers', 27111716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Tri-squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Twist drills', 23242104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Ultrasonic inspection equipment', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'V blocks', 41111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vertical turret lathes VTL', 23242305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vibration tables', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vibration testers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vibration transducers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Vixen files', 27111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Welding torches', 23271821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'Wire crimpers', 27111518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3021.00', 'X ray inspection equipment', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Blueprint machines', 43212114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Brickmasons'' trowels', 27112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Bucket augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Compression testing machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Dilatometers', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Engineers'' transits', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Evaporating dishes', 41121812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Field data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Filter papers', 40161803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Glass burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Graduated glass cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Hand augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Hand-operated boring machines', 20111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Handheld digital thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Inclinometers', 41114504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Kneading compactors', 22101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Laboratory bulb syringes', 41122004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Laboratory mechanical convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Laboratory test sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Laboratory vials', 41121806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Machetes', 27112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Mechanical sieve shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Metal cones', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Nuclear densometers', 41103303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Paving sample splitters', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'pH testers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Pocket penetrometers', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Precipitation gauges', 41114403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Precision levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Pycnometers', 41103316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Rotary rock drills', 20102102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Rubber mallets', 27111617);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Seismographs', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Sledgehammers', 27111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Slump cones', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Small-gauge surface drilling rigs', 20122820);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil density testers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil resistivity test kits', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil sampling tubes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Soil testing kits', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Split spoon samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Stabilometers', 41114603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Straightedges', 27111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Stream flow gauges', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Surveying rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Tamping rods', 22101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Thin-walled Shelby tubes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Torvanes', 41114619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Vibration monitors', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3022.00', 'Wide-mouthed funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Adjustable widemouth pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Adjustable wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Alternating current AC generators', 26111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Ammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Analog current meters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Analog multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Anti-static heel grounders', 46182102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Bench lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Brushless direct current DC motors', 26101209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Computerized numerical control CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Current probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Desoldering stations', 23271607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Digital logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Digital plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Digital voltmeters DVM', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Direct current DC potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Dual power supplies', 26111611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Harmonic analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Impedance meters', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Inductance capacitance resistance LCR meters', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Magnetic pickup tools', 27112109);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Metal-oxide varistors MOV', 32121603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Microcomputers', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Microprocessors', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Microwave frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Nanosecond universal counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Ohmmeters', 41113631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Optical time domain reflectometers OTDR', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Phase shift indicators', 41113602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Phase shifters', 32101524);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Power drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Power quality analyzers', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Power screwdrivers', 27112710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Probe stations', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Pulse generators', 41113636);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Q meters', 41113634);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Radio frequency RF amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Radio frequency RF signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Radio frequency RF spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Reflow ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Signal measuring equipment', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Soldering equipment', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Soldering stations', 23271607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Standing wave ratio SWR meters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Stroboscopes', 41111921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Tachometers', 41112802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Transformers', 39121003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Voltage probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Voltage testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wattmeters', 41113640);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Welders', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Welding goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Welding hoods', 46181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wire crimpers', 27111518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wire cutters', 27111511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wire strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wire wrap guns', 27112161);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3023.00', 'Wrist anti-static straps', 46182101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Analog oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Computerized numerical control CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Conductivity sensors', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Digital tachometers', 41112802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Direct current DC power supplies', 26101209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'DroneDeploy', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Fixed wing unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Force gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Framing squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Heat treatment furnaces', 40101831);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Hex wrenches', 27111710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Hipot testers', 20122403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Hyperspectral imaging equipment', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Iron workers', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Laser alignment tools', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Laser engravers', 23101515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Manual mills', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Megohmmeters', 41113628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Metal inert gas MIG welders', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Multi-rotor unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Multispectral imaging equipment', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Open end wrenches', 27111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Pipe benders', 27112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Pipe threading machines', 23241511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Pneumatic electric converters', 39121008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Portable welding equipment', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Pressure gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Pressure sensors', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Protective goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Proximity sensors', 41111926);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Robotic welders', 23153204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Selective laser sintering SLS systems', 23261505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Socket wrench sets', 27111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Soldering equipment', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Thermal cameras', 41115325);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Three dimensional laser scanners', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Three-dimensional prototyping printers', 23261507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Tungsten inert gas TIG welding equipment', 23271407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'Wire strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.00', 'X-Y positioning tables', 23153018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Adjustable widemouth pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Chart recorders', 41111906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Copy machines', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Electric drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Force gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Hydraulic dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Laser interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Open end wrenches', 27111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Potentiometers', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Programmable automation controllers PAC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Robotic teach pendants', 23153204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Shielded arc welding tools', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Soldering tools', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Volt-ohm meters VOM', 41113631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Waveform monitors', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3024.01', 'Workshop cranes', 24101630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', '13C nuclear magnetic resonance NMR spectrometers', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Aeration pumps', 40151501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Aerobic laboratory scale reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Air monitoring equipment', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Air velocity meters', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Airborne particulate samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Anaerobic laboratory glove bags', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Anaerobic laboratory scale reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Argon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Autotitration systems', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Benchtop nephelometers', 41113026);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Benchtop refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Biological oxidizers', 41104002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'California bearing ratio CBR testing devices', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Camera-equipped microscopes', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Chemical fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Dessicator chambers', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Dichotomous particulate matter samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Differential mobility analyzers', 41113903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Digester apparatus', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Drop volume tensiometers', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Dynamic contact angle apparatus', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Electrophoresis equipment', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Electrophoresis tanks', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Enzyme-linked immunosorbent assay ELISA plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Epifluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Fecal coliform constant temperature shaker baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Fermenters', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Filter press simulators', 47101525);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Filtering funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Flatbed scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Flow injection analyzers', 41103309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Fluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Fraction collectors', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Freezers', 41103005);
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'French presses', 41101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Gas mass spectroscopes', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Gel documentation systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Glassware adapters', 41121815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Glassware condensers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Groundwater pumps', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Groundwater sampling equipment', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Hazardous material protective clothing', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Heated environmental chambers', 41103412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Heating mantles', 41102405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'High pressure liquid chromatograph HPLC with ultraviolet/visible UV/Vis absorbance detectors', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'High-pressure/temperature reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'High-speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Hot plate stirrers', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Incubator shakers', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Interferometeric refractormeters', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Inverted microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ion selective electrode ISE meters', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laboratory centrifugal pumps', 41105103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laboratory scales', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laboratory shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Liquid mass spectroscopes', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Liquid scintillation equipment', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Low pressure liquid chromatographs with fraction collectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Low pressure reverse osmosis water treatment systems', 41104204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Mechanical convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Mercury analysis equipment', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Meters', 41112504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Microtox toxicity systems', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Mixer mills', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Multistage agar impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ozone bubble contactors', 49241708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ozone concentration percentage meters', 41113111);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ozone generators', 49241708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Pan balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Particulate filters', 40161506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Plasma spectrometers', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Proton nuclear magnetic resonance NMR spectrometers', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Reciprocating pumps', 40151509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Respirometers', 41113119);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Rotavapors', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Scanning microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Simultaneous static and dynamic light scattering systems', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Single particle spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil carbon-nitrogen CN analyzers', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil expansion testers', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil particle size testers', 41113903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil permeability testers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Soil vapor sampling equipment', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Specific ion probes', 41115608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Sterilizer chambers', 42281515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Streaming current detectors', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Supercritical fluid extractors', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Surface area analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Thermal conductivity detectors', 41113114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Titrimeters', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Total internal reflection fluorescence TIRF microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Total organic carbon TOC analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Total organic halide analyzers', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Toxicity analyzers', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Tracer gas detectors', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Tractor mounted drill rigs', 20122820);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Two-vortex mixers', 41103814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ultra pure water systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ultrafiltration cells', 47101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Ultraviolet UV spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Universal fractionators', 41104811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Video microscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Visible spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water distillation units', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water quality monitors', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Water sampling pumps', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3025.00', 'Zeta meters', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', '3-axis computer numerically controlled CNC milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Adjustable hand wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Air conditioning units', 40101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Air heaters', 40101818);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Air purifying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Angle plates', 27111827);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Autocollimators', 31242204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Automated vision systems', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Automatic microhardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Band saws', 23241509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Belt conveyors', 24101712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Bench grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Bioreactors', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Blow molding machines', 23151501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Boring tools', 23101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Centrifugal casting machines', 23161510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computer numerical control CNC vertical lathes', 23242306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computer numerical controlled CNC milling machines', 23242506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computerized numerical control CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computerized numerical control CNC routers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Computerized numerical control CNC turning centers', 23101511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Deburring tools', 27111526);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Dial calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Dial indicators', 41111630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital logic probes', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Dilatometers', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Direct computer-controlled coordinate measuring machines DCC-CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Dye penetrant inspection equipment', 41111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Dynamic actuators', 31251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Eddy current inspection equipment', 41111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Edge finders', 27111823);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Electric boilers', 40102003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Electrical discharge machines EDM', 23101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Engine lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Extruding machines', 23151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Fatigue testing machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Filtration systems', 41104925);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Fused deposition modeling FDM machines', 23261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Gas-powered generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Gauge blocks', 41111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Go/no-go gauges', 41111619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Grinders', 27111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Heat exchangers', 40101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Height gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Hex key sets', 27111710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Horizontal milling machines', 23242507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'In-line flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Induction melting units', 40101831);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Laboratory centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Laboratory glassware washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Laser cutting equipment', 23241505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Machinist rules', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Magnetic inspection equipment', 41111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Manual hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Melting point apparatus', 41112203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Mixing tanks', 24111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Optical power meters', 41113717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Optical spectrum analyzers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Optical time domain reflectometers OTDR', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Osmometers', 41113027);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Parallel sets', 27111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Pedestal grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Permanent mold casting machines', 23161510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Phillips head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Pin gauges', 41111644);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Pipe bending mandrels', 23251808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Pipe reamers', 23241619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Plastic injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Portable air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Power drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Power production turbines', 26101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Precision rulers', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Production robots', 23101519);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Programmable automation controllers PAC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Programmable function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Protective face shields', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Scissor lifts', 24101617);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Servohydraulic tensile testing machines', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Signal analyzers', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Soldering equipment', 23271604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Steam boilers', 40102002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Straight screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Surface grinding machines', 23241402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Thermoplastic injection molding presses', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Three-dimensional laser digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Three-dimensional prototyping printer', 23261507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Toolmaker''s microscopes', 41111702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Universal testing machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'V blocks', 41111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Vacuum gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Vacuum pumps', 40151502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Vertical machining centers', 23242403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Vertical spindle mills', 23242306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Viscosity meters', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Wire splicers', 39121718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.00', 'Wire strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Atomic force microscopes AFM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Atomic layer deposition ALD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Auger electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Bake ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Bourdon tube gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Capacitance manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Capacitively coupled plasma CCP reactors', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Chemical aprons', 46181501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Chemical baths', 41103702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Chemical mechanical polishing CMP systems', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Chemical protective aprons', 46181501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Contact aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Contact printers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Cryogenic gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Deionization water systems', 47101511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Dielectric deposition tools', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Digital pattern generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Electron beam evaporators', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Electron beam writers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Energy dispersive x-ray EDX spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Extreme ultraviolet EUV systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Eyewash stations', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Face shields', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Field emission scanning electron microscopes FESEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Fluorescence optical microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Focused ion beam FIB etching tools', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Focused ion beam scanning electron microscopes FIB-SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Four-point probes', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Gowning gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Helium leak detectors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Hotplates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Inductively coupled plasma reactive ion etchers ICP-RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Infrared spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ion gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ion implanters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ion mills', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ionization gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Isolation glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Linewidth measurement systems', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Low pressure chemical vapor deposition LPCVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Magnetron plasma sputter reactors', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Mask aligners', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Mask writers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Metal-organic chemical vapor deposition MOCVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Molecular beam epitaxy MBE systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Molecular vapor deposition MVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Nanoimprint lithography NIL systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Optical profilers', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Optical thin film measurement systems', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Optical tweezers', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Oxidation furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Parallel plate reactive ion etchers RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Parametric analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Photoelectron spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Photoresist dispensing systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Photoresist spin coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Pirani gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Plasma enhanced chemical vapor deposition PECVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Plasma etchers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Protective gowns', 46181532);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Residual gas analyzers', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Safety showers', 46182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Scanning acoustic microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Secondary ion mass spectrometers SIMS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Spectroscopic ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Spin dryers', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Spin processors', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Sputter coaters', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Thermal evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Turbo pumps', 40151526);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ultrasonic welding equipment', 23271402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Ultraviolet ozone cleaners', 42281501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Vacuum contact printers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Vacuum hotplates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Wafer substrate bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3026.01', 'Zeta potential analyzers', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Absorption dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Adjustable wrenches', 27111707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Angle grinders', 27112749);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Arc welding equipment', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Arc-joint pliers', 27112113);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Band saws', 23241509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Belt sanders', 27112739);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Bench grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Bend test fixtures', 41114614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Binocular compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Bore gauges', 41111647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Boring machines', 23101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Brazing equipment', 23271821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'C clamps', 27112120);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Center punches', 27111505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Centerless grinding machines', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Clamp-on ammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Claw hammers', 27111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Cold cut chop saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Combination milling machines', 23242507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Combination squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Compression testers', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Compression testing machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Computerized numerical control CNC vertical milling machines', 23242403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Computerized scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Constant temperature baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Cylindrical grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dial calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dial indicators', 41111630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Digital hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Digitizing tablets', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Drafting plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dry rod ovens', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dual centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dual column bandsaws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Durometers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dynamic mechanical analyzers DMA', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Electronic comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Electronic strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Extrusion machines', 23151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Fatigue testers', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Fatigue testing machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Fluid meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Force sensors', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Freon recovery equipment', 40151502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Fused deposition modeling FDM machines', 23261501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Gas welding equipment', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Go/no-go gauges', 41111619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Granite surface plates', 23153019);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Grinding machines', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Guided bend weld test units', 41114614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hacksaws', 27111559);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hand brakes', 23251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Heat treatment furnaces', 40101831);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hex keys', 27111710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'High-voltage amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hydraulic benches', 56122001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hydraulic universal testers', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Hydrostatics benches', 56122001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Internal grinding machines', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Laminated object manufacturing LOM systems', 23261503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Lapping machines', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Layout squares', 27111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Linear amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Locking pliers', 27112115);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Long nose pliers', 27112134);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Manual load frames', 41114613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Marking gauges', 27112305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Metal cutting dies', 23251802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Metal cutting taps', 23241615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Metal inert gas MIG welders', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Metal inert gas MIG welding equipment', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Metallographs', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Micro lathes', 23242304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Micro mills', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Microfluidic particle imaging velocimetry PIV systems', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Microprocessors', 32101626);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Mill files', 27111940);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Milling machines', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Nut drivers', 27111702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Offset screwdrivers', 27111767);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Open channel flow apparatuses', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Oxyacetylene welding equipment', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Oxygen bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Pedestal grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Phillips head screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Photoelastic testing machines', 41114615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Plane-parallel gauge blocks', 41111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Plastic injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Pneumatic ratchets', 27131501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Polarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Polishing machines', 23242605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Portable welding equipment', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Positioning jigs', 23153018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Power drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Power grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Power shears', 27111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Power sheet metal shears', 27111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Pressure sensors', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Punch presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Ring gauges', 41111632);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Rotameters', 41112503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Rotational molders', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Screw gauge micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Screw pitch gauges', 41114504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Screw thread gauges', 41111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Scribers', 27112303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Scroll saws', 27112735);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Selective laser sintering SLS systems', 23261505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Servohydraulic load frames', 41114613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Shear testers', 41114619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Sheet metal slitters', 23241629);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Shielded arc welding tools', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Signal conditioners', 39121020);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Sine bars', 41111645);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Slip joint pliers', 27112113);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Slotted screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Snap gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Socket wrench sets', 27111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Soldering equipment', 23271604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Spirit levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Spot welders', 23271406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Steel rules', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Stick welding machines', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Straight screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Superfinishing machines', 23101510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Surface grinding machines', 23241402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Switched amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Taper plug gauges', 41111648);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Three-dimensional laser digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Three-dimensional prototyping printer', 23261507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Tool grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Torque meters', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Torsion testers', 41114622);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Track burning machines', 23241506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Tungsten inert gas TIG welding equipment', 23271407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Twin-screw extruders', 23191102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Twist drills', 23242104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Ultrasound inspection equipment', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Universal testing machines', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Utility knives', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Vacuum molders', 23151508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Vernier height gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Vibration monitors', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Vibration testers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Welding masks', 46181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Wind tunnels', 41112516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Wire cutters', 27111511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.00', 'Wire strippers', 27111510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Chassis dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Compression testers', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Computer numerical controlled CNC milling machines', 23242506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Computerized numerical control CNC turning centers', 23101511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Crack detection equipment', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Electronic engine analyzers', 41111917);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Engine lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Environmental chambers', 41103413);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Exhaust gas analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Flow benches', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Force gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Frequency counters', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'High-vacuum tensile testing chambers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Ignition oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Leakage testers', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Metal inert gas MIG welders', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Pin gauges', 41111644);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Plasma cutters', 23271404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Timing lights', 41111921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Tungsten inert gas TIG welding equipment', 23271407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3027.01', 'Vibration testers', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Acoustic emissions systems', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Acoustic testers', 41111939);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Amp meters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Binocular polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Black lights', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Capacitance testers', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Closed circuit television systems', 52161505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Computer assisted tomography CAT inspection equipment', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Depth gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Digital micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Digital refractometers', 41115313);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Eddy current inspection equipment', 41111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Electric hoists', 24101602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Electrical conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Fiber optic strain sensors', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Fluorescent microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Gamma ray testing equipment', 41111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Gauss meters', 41113614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Ground penetrating radar GPR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Handheld accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Handheld sprayers', 27112903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Height gauges', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Immersion tanks', 24111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Infrared thermographic scanners', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Inspection endoscopes', 41111716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Laser alignment tools', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Light meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Load indenters', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Magnifying glasses', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Metallurgical microscopes', 41111718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Microwave meters', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Neutron detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Piezoelectric sensors', 41112101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Portable microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Power drills', 27112703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Precision rulers', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Radiation detection badges', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Recirculating hot air drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Remote reading electronic thermometers', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Schmidt rebound hammers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Stereo microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Timing equipment', 46171603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Two-channel oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Ultrasound inspection equipment', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Velocity meters', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Vibration analysis equipment', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Volt meters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Width gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'Windsor probes', 41114602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'X ray equipment', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.01', 'X ray microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Abrasive grinding machines', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Analog oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Atomic force microscopes AFM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Autocollimators', 31242204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Bench refractometers', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Bit error rate testers BERT', 41111917);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Chemical protective face shields', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Chemical vapor deposition CVD systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Collimators', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Common path interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Computerized numerical control CNC band saws', 23101512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Computerized numerical control CNC drill presses', 23241801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Computerized numerical control CNC lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Computerized numerical control CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Contact profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Coordinate measuring machines CMM', 41111920);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Cutoff saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Depth gauges', 41112401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Die bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Die saws', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Die shears', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Diffractometers', 41101810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Digital logic analyzers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Digital logic probes', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Electron beam evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Electron cyclotron resonance ECR reactive ion etchers RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Excimer lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fabry-Perot interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fiber cleavers', 23101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fiber optic fault locators', 41113716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fiber polishers', 23101510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Fusion splicers', 39121718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Gas lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Hand calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Hardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Humidity chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Ion lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Isolators', 32101522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Lab jacks', 24101612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laboratory forceps', 41122405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laser cutting machines', 23241505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laser drills', 23241505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laser heat treatment equipment', 40101831);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laser marking machines', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Laser welders', 23271405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Liquid dye lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Logic pulsers', 41113704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Loupes', 41111714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Mach-Zehnder interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Magnifiers', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Mechanical steppers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Michelson interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Micropositioners', 23153018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Multifunction digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Non contact profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical alignment scopes', 31242101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical mounts', 31242101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical rails', 31242104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Optical spectrum analyzers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Phase-shifting interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Photoelectric power meters', 41113708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Plasma strippers', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Positioning stages', 23153018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Protective gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Protective gowns', 46181532);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Rapid thermal annealers RTA', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Reflow ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Semiconductor detectors', 32111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Semiconductor parameter analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Shearing interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Soldering irons', 23271603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Solid state lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Spherometers', 41114506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Sputter deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Temperature chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Twyman-Green interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Vacuum deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Vernier micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Wafer bonding systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Wavelength meters', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Wire bonders', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Wire pull testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3029.08', 'Wire saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', '3D laser scanning systems', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Alidades', 41114203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Automatic optical pendulum leveling systems', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Axes', 27112005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Chain saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Community base station global positioning systems GPS', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Distance meters', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Drafting compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Drafting kits', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Drafting templates', 44111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Echosounders', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Electronic digital/bar-code leveling systems', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Electronic distance measuring devices', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Electrotapes', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Engineering scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Extensometers', 41114503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Fathometer sonar equipment', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Geodetic leveling rods', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Geological compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Ground vibration sensing equipment', 20122615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Hand levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Handheld data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Hatchets', 27111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Jackhammers', 27131504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Laser distance measuring equipment', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Laser scanner coordinate capturing equipment', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Leveling bubbles', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Machetes', 27112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Magnetic field pipe locators', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Mallets', 27111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Measuring chains', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Measuring rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Metal detectors', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Multibeam sonar equipment', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Optical pendulum levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Plane tables', 41114203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Plumb bobs', 27111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Pocket personal computers PC', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Portable hydrographic surveying equipment', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Pre-programmed coordinate geometry COGO calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Prism poles', 27112813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Programmable calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Ranger data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Real-time kinematics RTK global positioning systems GPS', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Robotic survey measuring instruments', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Side scan sonars', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Sight targets', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Survey instrument control units', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'T-squares', 44111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Telescoping pole saws', 27111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Tellurometers', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Templates', 44111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Transit levels', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Triangles', 44111810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Tribrach level bubble adjusting blocks', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Tribrach optical plummet adjusting cylinders', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Tripods', 56101536);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Vertical/target rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('17-3031.00', 'Wheeled measuring devices', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Analytic balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Animal blood analyzers', 41115815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Animal catching equipment', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Animal feed mixers', 21101904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Animal feeders', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Animal heater lamps', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Artificial insemination kits', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Automatic carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Balling guns', 42121507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Blood collection syringes', 42142616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Brooders', 21101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Bunsen burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Calf pullers', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Calf restraints', 10141609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Captive bolt stunners', 23221101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Cattle scales', 41111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Cattle squeeze chutes', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Circulating water baths', 41103701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Computerized cattle feeders', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Conductance meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Dehorners', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Dissecting kits', 41102915);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Ear punches', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Electric stunners', 23221101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Electronic laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Evacuated blood collection tubes', 41104107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Fiber digesters', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Fraction collectors', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Gel electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Glass pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Graduated beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Handheld digital thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Hot plate stirrers', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Hybridization chambers', 41104511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Imaging microscopes', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Infrared IR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laboratory drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laboratory fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laboratory vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laboratory water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laminar flow cabinets', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Laser densitometers', 41103303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Liquid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Livestock scales', 41111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Meat choppers', 23181603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Meat grinders', 48101605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Microultracentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Orbital shaking water baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Oxygen meters', 41111924);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Poultry incubators', 21101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Refrigerated benchtop centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Scanning densitometers', 41103303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Scientific calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Slab dryers', 41105302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Specimen collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Tissue culture incubators', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Ultrasonic water baths', 41103712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Ultrasound probes', 42201706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Ultraviolet UV visible spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Veterinary emasculators', 42121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1011.00', 'Volumetric flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Air sampling systems', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Amino acid analyzers', 41115801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Amylographs', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Anaerobic growth chambers', 41103407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Automatic diluters', 41121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Bacterial identification systems', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Batch fryers', 48101509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Benchtop nephelometers', 41113026);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Biological safety cabinets', 42281515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Bioreactors', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Blast freezers', 24131607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Carbon dioxide CO2 laboratory incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Color difference meters', 41111940);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Commercial microwave ovens', 48101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Computerized calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Coulter counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Darkfield microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Dehydration equipment', 41104208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Dejuicers', 23181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Differential refractometers', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Drum dryers', 23181505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Dynamic light scattering equipment', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Dynamic mechanical analyzers DMA', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Electronic laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Emulsifiers', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Epifluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Extractors', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Fermenting tanks', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Food choppers', 48101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Food crushers', 23181507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Food dehydrators', 23181505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Food mixers', 48101608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Food slicers', 48101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Fraction collectors', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Freeze drying equipment', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Fruit presses', 23181507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Gel electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Glucose analyzers', 41113323);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Griddles', 48101511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Grills', 48101512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Heat exchangers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'High speed refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Ice cream freezers', 23181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Induction cooktops', 48101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Infrared IR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Jet cooking systems', 23181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laboratory lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laboratory mechanical convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laboratory mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laboratory water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Laser colony counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Macro kjeldahls', 41104815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Meat grinders', 48101605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Meat saws', 23181604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Melting point apparatus', 41112203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Membrane filtration systems', 41104921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Micro kjeldahls', 41104815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Microbial monitoring systems', 41103403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Nitrogen analyzers', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Orbital shaking water baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Oxygen analyzers', 41113110);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Piston filling machines', 23181501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Plate heat exchangers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Programmable incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Pulper finishers', 23181507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Pulsifiers', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Ranges', 48101521);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Reflectance spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Refrigerated benchtop centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Retort sterilization equipment', 41104801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Roasting equipment', 23181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Rotary evaporators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Scanning plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Specific gravity fat analyzers', 41104807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Spiral platers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Steam blanchers', 23181508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Steam kettles', 48101524);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Stomachers', 41101502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Strain testers', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Stuffers', 23181501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Thermal gravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Thermal processing equipment', 23181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Torsion gelometers', 41103315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Tubular heat exchangers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Ultraviolet UV spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Vacuum packagers', 23152903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'Water activity meters', 41104207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1012.00', 'X ray crystallography equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Calibrated soil scoops', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Canopy analyzers', 41115301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Cell tissue culture incubators', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Circulating water baths', 41103701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Digital pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Epifluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Flame photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Fluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Gamma ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Gel documentation systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Gel dryers', 41105302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Gel electrophoresis systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Glass flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Graduated glass cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Ground penetrating radar GPR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Hand augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Heat flux plates', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'High speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Hot water shaking baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Inductively coupled plasma atomic emission spectrometers ICP-AES', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Infrared cameras', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Infrared gas analyzers', 41113106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory grinders', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory growth chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laboratory test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Laser particle sizers', 41113903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Light detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Luminometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Lysimeters', 41114403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Microtiter plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Organic carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Osmometers', 41113027);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Porometers', 41113906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Precision balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Psychrometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Reciprocating shaker water baths', 41103711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Refrigerated microfuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Sample containers', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Soil analysis hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Soil moisture neutron probes', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Soil thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Synthetic aperture radar SAR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Tensiometers', 41114509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1013.00', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Amino acid analyzers', 41115801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Analytical ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Argon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Auto gamma counters', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Automated electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Automatic pipetters', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Automatic x ray film developers', 42203702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Basic vapor pressure osmometers', 41113027);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Biofreezers', 41103006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Biological safety hoods', 46181710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Brewster angle microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Capillary electrophoresis equipment', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cell sorters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Chemical fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Chemistry analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Circular dichroism spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Circulating water cooling systems', 41103007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Computerized axial tomography CAT scan equipment', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Confocal microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Continuous flow centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cryocut microtomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cryogenic freezers', 41103006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cryomicroscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cryostat tissue microtomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cryotransmission electron microscopes', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Cytospin centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Darkroom equipment', 42203707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Dichroic beamsplitters', 31242201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Dual wavelength spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Electroencephalography EEG equipment', 42182308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Electron paramagnetic resonance EPR spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Electron spin resonance spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Electrophoresis power supplies', 41105303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Fermenters', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Filtering funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Flexi-dry lyophilizers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Fluorescence spectroscopes', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Fourier transform infrared FTIR spectroscopes', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Gamma ray irradiators', 26142001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Gel boxes', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Glassware adaptors', 41121815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Glassware condensers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Growth chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Heat blocks', 41102422);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Heat incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Heating mantles', 41102405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Hemoglobin analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'High-pressure high-temperature reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'High-pressure liquid chromatographs', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Hot plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Inverted microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ionometers', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Isothermal titration calorimeters ITC', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Krypton lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laboratory convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Langmuir balances', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Large upright microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laser Doppler zeta potential analyzers', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laser induced temperature jump nanosecond relaxation spectrometer systems', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laser particle sizers', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Laser tweezers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Light scattering devices', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Linear accelerators', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Liquid nuclear magnetic resonance NMR equipment', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Magnetic piconewton-force transducers', 41112101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Magnetic tweezers', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Medical magnetic resonance imaging MRI equipment', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Medical magnetic resonance imaging MRI microscopes', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Megafuge centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Mettler balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microcalorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microdosimeters', 42203901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microinjectors', 41115715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microphysiometers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Microsusceptometers', 41113112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Mossbauer spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Multi-angle elastic-light scattering systems', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Multichannel detectors', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Nanoscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Near-field light microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Neodymium-doped yttrium aluminum garnet Nd:YAG lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Optical tweezers', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Orbital shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Pasteur pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Peptide synthesizers', 41103809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Phosphorimager video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Phosphorimagers', 41101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Positron emission tomography PET scanners', 42202401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Power amplifiers', 39121020);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Protein sequencers', 41115823);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Raman difference spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Rotating anode X ray generators', 41101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Sample concentrators', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Sapphire lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Sartorius balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Scanning laser microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Shaking waterbaths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Solid state diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Solid-state nuclear magnetic resonance NMR equipment', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Sonicators', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Specific gravity balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Spectropolarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Stopped-flow spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Synchrotrons', 41101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Tabletop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Thermal imagers', 41112202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Top-loading electronic balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Transillumination microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ultramicrotomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ultraviolet UV spectroscopes', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Ultraviolet UV transilluminators', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Vacuum freezers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Vibratome tissue sectioning systems', 41102909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Video enhanced differential interference contrast microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Video positioning equipment', 45121623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'Water purification units', 41104205);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'X ray crystallography equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1021.00', 'X ray microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', '8-channel electronic pipettes', 41121508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Alcohol lamps', 41102402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Anaerobic growth chambers', 41103407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Argon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Automated gram stainers', 41105203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Automated microbial identification systems', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Automatic cell sorters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Automatic coverslipper', 41102922);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Automatic pipetters', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bacteriological incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bacticinerators', 42281502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bioaerosol impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Biological safety hoods', 46181710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bioreactors', 41104307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bright field light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Bubble counters', 41111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Charge coupled device CCD color digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Chemical safety showers', 46182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Colony counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Compound binocular light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Coplin jars', 41121810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Culture bottles', 41122104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Culture tubes', 41121706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Darkroom developing tanks', 45141602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Deionized DI water systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Desktop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Dichotomous particulate matter samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Direct heat dry wall carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Dissecting microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Dry bath incubators', 41102422);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Electronic sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Electroporators', 41106208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Enzyme-linked immunosorbent assay ELISA plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Erlenmeyer flask clamps', 41121815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Eyewash fountains', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Fecal coliform water baths', 41103701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Floor shakers', 41103813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Fluorescence activated cell sorters', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Fluorescent microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'French presses', 41101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gas-powered generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gel documentation systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gel electrophoresis boxes', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gel support frames', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Gel transfer apparatus', 41105311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Graduated glass laboratory cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Hardy Diagnostics HUGO', 55111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Heat blocks', 41102422);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Heating stirplates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Helium-neon lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'HEPA filtered biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'High pressure liquid chromatographs HPLC', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'High-speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Hybridization ovens', 41104511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Impedance meters', 41113621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Infrared gas analyzers', 41113106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Infrared IR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Inoculating loops', 41122108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Inverted microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory gas burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory glassware washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory heat exchange condensing devices', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory membrane filtering devices', 41104921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory refrigerators', 41103011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laminar flow cabinets', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Liquid chromatograph devices', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Liquid impingers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Liquid nitrogen storage equipment', 41103006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Magnetic laboratory stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Membrane filtration systems', 41104921);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Micro balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Microcalorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Micromanipulators', 41111735);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Mid-infrared spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Multiplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Multistage agar impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Multiwell trays', 41122808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Oil-immersion microscope lenses', 41111705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Orbital shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Orbital shaking water baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Osmometers', 41113027);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Photomicroscopes', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Pipette pumps', 41121514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Precision pan balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Prepared agar plates', 41106217);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Protective gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Protective laboratory coats', 46181533);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Raman spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Rechargeable electronic pipette fillers', 41121517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Recording thermometers', 41112221);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Refrigerated benchtop centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Refrigerated recirculating water baths', 41103709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Rotator mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Safety shoes', 46181605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Sectioned petri plates', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Semidry blotting apparatus', 41105311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Serology rotators', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Sonicators', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Staining dishes', 41121810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Steroclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Test tube racks', 41122804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Tissue homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Transilluminators', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Ultra cold biological freezers', 41103005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Ultraviolet UV lamps', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Visible spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Visible/UV light scanning spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Vortex mixers', 41103814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Water purification systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'Water sample collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1022.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Adjustable widemouth pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Aerial nets', 41102507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Animal transmitters', 52161523);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Animal traps', 10191701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Archery bows', 49181602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Axes', 27112005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Benthic samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Boat trailers', 25181713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Bongo nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Canoes', 25111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Carbon dioxide CO2 monitors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Climbing belts', 46182306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Compasses', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Compound binocular light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Counting chambers', 41111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Culvert traps', 49131603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'D-ring nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dart guns', 46101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dip net samplers', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dissecting microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dissecting tools', 60103915);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Dust masks', 46182001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Egg candlers', 21101906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Ekman dredges', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Extension ladders', 30191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Field thermometers', 41112212);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Fish traps', 21111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Flow meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Folsom plankton splitters', 41104001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Foot snares', 49131603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Geodetic ground global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Gill nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Graduated glass laboratory cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Hand lenses', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Hard hats', 46181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Jellyfish scoops', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Jet skis', 25111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory forceps', 41122405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory freezers', 41103005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laboratory mechanical convection incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laser hypsometers', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Leather gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Light traps', 10191703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Mesh sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Metric measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Mist nets', 49131603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Monopan balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Multiplate samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Nitrile gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Odonata nets', 41102507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Photomicroscopes', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Plankton nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Portable refractometers', 41115313);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Radio telemetry equipment', 52161523);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Rubber rafts', 25111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Rulers', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Salinity meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Scintillation vials', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Secchi disks', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Seines', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Self-contained underwater breathing apparatus SCUBA equipment', 49141504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Sieve buckets', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Sledgehammers', 27111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Small power boats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Snorkels', 49141505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Snowmobiles', 25101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Specimen collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Spotting scopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Spring scales', 41111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Stainless steel scalpel blades', 42291613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Sterilizing ovens', 42281502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Sweeping nets', 41102507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Tree corers', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Tree top peeper and video probe systems', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Volumeters', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Water pumps', 40151510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Water sample collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1023.00', 'Water thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Automated cell counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Automated DNA sequencing equipment', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Automated microscopes', 41111735);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Automatic carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Bacterial plate incubators', 41104406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Centrifuge tubes', 41121703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Chemical hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Cloning cylinders', 41121812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Cloning kits', 41106610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Computerized axial tomography CAT scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Cooled benchtop centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Deoxyribonucleic acid DNA synthesizers', 41105903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Dissecting microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Electrophoresis cameras', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Emergency eye wash stations', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Fluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Gel electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Gel imaging apparatus', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Gradiant thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Heat blocks', 41102422);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Inverted binocular microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory binocular optical microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory chemical autoclaves', 42281501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory floor centrifuges', 41103905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory freezers', 41103011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory orbital shakers', 41103811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory transfer pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laboratory water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Magnetic resonance imaging MRI systems', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Magnetic stirring hot plates', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Manual single channel positive displacement pipettes', 41121505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Manual single channel repeating pipetters', 41121506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Multichannel micropipettes', 41121508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Nucleic acid hybridization ovens', 41104511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'pH analyzers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Phosphorimagers', 41101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Polymerase chain reaction PCR thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Robotic fluidics stations', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Scanning laser confocal microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Serological kits', 41116126);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Tabletop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Ultraviolet-Visible UV/VIS spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Variable volume pipettes', 41121510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Vortex rotators', 41103814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Water purification systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.02', 'Yeast culture incubators', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Binocular optical microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Capillary electrophoresis equipment', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Fast protein liquid chromatographs FPLC', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Gel electrophoresis equipment', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Mass spectrometry equipment', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Phosphorimagers', 41101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Robotic liquid handlers', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.03', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Agar plates', 41106217);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Automated microscopes', 41111735);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Automatic pipetters', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Benchtop lyophilizers', 23151807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Bioreactors', 41104403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Biosafety cabinets', 41103507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Bunsen burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Carbolite ovens', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Centrifugal evaporators', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Digestion units', 41104304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Dip nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Dissecting microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Distillation units', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Electronic precision balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Electrophoresis chambers', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Fermenters', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Fluid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'French presses', 41101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Gas autoclaves', 42281501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'General purpose laboratory test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Glass burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Glass graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Glass washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Handheld digital thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Heated magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Heated stir plates', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Inoculating loops', 41122108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Inverted compound microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory bulb syringes', 41122004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory forceps', 41122405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory hot plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laboratory microwave ovens', 41104507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laminar flow cabinets', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Luminometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Mechanical laboratory incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Mercury barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Microscope digital cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Microtiter plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Microtomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Multiwell microplates', 41113036);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Navigational compasses', 41112901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Orbital shaking water baths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Pasteur pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Phosporimagers', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Plankton nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Plastic cuvettes', 41121813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Plastic laboratory tubing', 41105108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Portable dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Propane jet freezers', 41103005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Refrigerated benchtop centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Respirometers', 41113119);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Salinity meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Scanning laser confocal microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Scientific calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Sonicators', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Specimen collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Spreading rods', 41121802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Swinging bucket centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Test tube shakers', 41103814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Tissue culture plates', 41122107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Top-loading electronic balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Ultramicrotomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Ultraviolet UV transilluminators', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Ultraviolet UV visible spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Ultraviolet water purification systems', 41104205);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Vacuum dehydration units', 41104208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Vacuum evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Vertical drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Video imaging systems', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Video microscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Water flow gauges', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Water-jacketed CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Weather stations', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'X ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1029.04', 'Zoom microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Dumpy levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Dutch augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Laser distance measurement systems', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Compact digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Double-ring infiltrometers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Global positioning system GPS devices', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Gram scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Hand sieves', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Impact penetrometers', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Laser plumb bobs', 27111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Measuring tapes', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Plant canopy analyzers', 41115301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Portable dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Quadrat frames', 41104015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Robel poles', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Single-ring infiltrometers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Soil sampling scoops', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Stereoscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Strain gauges', 41111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.02', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'All-terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Animal trapping equipment', 10191701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Augers', 27112040);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Automated external defibrillators AED', 42172101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Backpack tanks', 46191612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Boat trailers', 25181713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Brush cutters', 27112035);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Canoes', 25111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Chainsaws', 27112746);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Claw hammers', 27111618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Digital still cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Drip torches', 12131707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Dump trucks', 25101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Electronic cash registers', 44101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Emergency medical first aid kits', 42172001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Fire rakes', 46191605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Fire swatters', 46191605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Fishing poles', 49131501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Forest fire shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Global positioning system GPS devices', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Hand pruners', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Hand rakes', 27112003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'High-pressure pumper units', 25101704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Horse bridles', 10141601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Horse reins', 10141604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Horse saddles', 10141501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Horse trailers', 25181703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Kayaks', 25111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Law enforcement handguns', 46101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Leaf blowers', 27112701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Light pickup trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Line trimmers', 27112035);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Mobile radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Mountain bikes', 25161505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Multiline telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Multipurpose pliers', 27112107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Multipurpose shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Multipurpose tractors', 25101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Passenger vans', 25101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Patrol motorboats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Phillips screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Point of sale POS computer terminals', 43211505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Pontoon boats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Power mowers', 27112014);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Snow skis', 49151502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Straight screwdrivers', 27111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Surveillance binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Survey levels', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Survey transits', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Tanker trucks', 25101610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Utility knives', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Water testing kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Weed sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Wood chippers', 27112715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1031.03', 'Work vans', 25101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'All-terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Backpack sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Brush chippers', 27112715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Bucket trucks', 22101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Chainsaws', 27112746);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Digital clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Forestry axes', 27112005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Global positioning system GPS devices', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Hand pruners', 27112007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Hand saws', 27111508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Handheld dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Hip chains', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Multipurpose front end loaders', 22101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Multipurpose skid steer loaders', 22101529);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Navigational compasses', 41112901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Pole pruners', 27112047);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Power loppers', 27112039);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Power pruners', 27112038);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Steel measuring tapes', 41114201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Stump grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Tree scale sticks', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1032.00', 'Weed sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1041.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Absorption tubes', 41115720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Atomic absorption AA spectrophotometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Automated centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Automated deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Beta counters', 41113403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Blood gas machines', 41115805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Bone ultrasound densitometers', 42201704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Capillary electrophoresis equipment', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Carbon dioxide CO2 incubators', 41104411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Cell disruptors', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Chemistry analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Chromatographic tubes', 41115720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Coagulation machines', 41115809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Cold vapor atomic absorption spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Computerized axial tomography CAT scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Confocal microscopes', 41111723);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Coulter counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Crossflow filtration systems', 41104925);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Cuvettes', 41121813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Cyclotrons', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Deoxyribonucleic acid DNA synthesizers', 41105903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Developing tanks', 41115713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Differential cell counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Electrical conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Electrocardiography EKG machines', 42181701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Electrophoresis power systems', 41105303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Fermenters', 41104301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Filter funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Fixed-angle microfuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Flame atomic absorption spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Flame photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Fourier Transform IR spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Gamma counters', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Gel documentation systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Gel dryers', 41105302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Gel electrophoresis boxes', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Glassware washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Graphite furnace atomic absorption spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Heat lamps', 41102404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Heating blocks', 41102422);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Hematology analyzers', 41115815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'High-pressure liquid chromatographs', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'High-resolution functional magnetic resonance imaging MRI equipment', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'High-speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Hot air ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Hot plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Laboratory evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Laminar flow hoods', 41103504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Measuring cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Medical magnetic resonance imaging MRI equipment', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Mercury analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Microarrayer scanners', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Microdiffusion dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Microscope/video camera stations', 41111737);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Pasteur pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Peptide synthesizers', 41103809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Plate washers', 41103207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Positron emission tomography PET scanners', 42202401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Powder funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Recording spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Refrigerated swinging bucket centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Rotary evaporators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Selective ion meters', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Speed vacs', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Spray atomizers', 41101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Steam distillation apparatus', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Tabletop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Thin layer chromatography equipment', 41115706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Thin layer chromatography plates', 41113036);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ultralow freezers', 41103005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ultrasound imaging scanners', 42201712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ultraviolet UV crosslinkers', 41105316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Ultraviolet-Visible UV/VIS spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Volumetric flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-1042.00', 'Vortex mixers', 41103814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Atomic absorption AA spectroscopes', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Automated telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Baseband recorders', 41111907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Charge-coupled device CCD imagers', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Dobsonian telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Doppler Rayleigh laser imaging ranging and detecting LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Ebert-Fastie spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Echelle spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Electron beam ion traps EBIT', 41113625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'European VLBI Network EVN telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'High powered binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'High resolution spectrographs', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Low resolution imaging spectrographs', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Multi-object spectrographs MOS', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Near-infrared imagers and spectrometers NIRI', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Near-infrared integral field spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Optical interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Optical telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Planetary radar transmitters', 52161523);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Pulsar processors', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Radio antennas', 43221706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Radio telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Reflector telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Refracting telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Resonance fluorescence laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Scanning telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Schmidt-Cassegrain telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Scientific calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Single-dish radio telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Solar telescope filters', 31242202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Solar telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Thermal evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Tilting filter photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Very large array VLA telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Very long baseline array VLBA telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Wide-field mosaic charge-coupled device CCD cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'Wideband pulsar processors', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2011.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Analog frequency analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Analog sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Annealing furnaces', 41104609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Arbitrary function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Argon ion lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Atomic emission detectors AED', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Betatrons', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Big G torsion balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Capacitance bridges', 41113604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Cavity dumpers or drivers', 31241804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Computed tomography CT scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Conditioning amplifiers', 32101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Cryostats', 41103003);
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Cyclotrons', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Diffusion pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Diffusion-pumped vacuum systems', 41103305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Digital multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Digital plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Digital sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Digital voltmeters DVM', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Double monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Friction-force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Galvanostats', 41113619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Gamma ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Gas chromatography GC injectors', 41115715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Gaussmeters', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Geiger-Muller counters', 60105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Grating monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Headspace autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Helium lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Helium refrigerators', 41103006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High intensity UV sources', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High vacuum equipment', 41103305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High-energy accelerators', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High-resolution semiconductor detectors', 32111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High-resolution spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'High-speed video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Ionization chambers', 41113625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Isotope ratio mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laboratory box furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laboratory centrifugal pumps', 41105103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laboratory electromagnets', 60104910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laboratory tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Laser power meters', 41115322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Leak detection equipment', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Light scattering devices', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Linear accelerators', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Liquid helium level sensors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Magnetic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Magnetic resonance imaging MRI systems', 42201609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Measuring microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Mickelson interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Microwave interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Multiple diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Nanovoltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Neutron detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Optical beamsplitting devices', 31242201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Optical choppers', 31242208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Optical detectors', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Optical tables', 31242207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Optical tweezers', 27112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Photodetectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Photon counting systems', 41115304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Pinhole filters', 31241807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Pistonphones', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Portable fast Fourier transform FFT analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Positive ion accelerators', 42203001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Power amplifiers', 39121020);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Prism spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Programmable phase modulators', 31242202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Pulsed nitrogen lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Radiation detecting film badges', 42203902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Radiofrequency RF generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Scanning monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Scintillation probes', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Semiconductor parameter analyzers', 41113706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Signal generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Single frequency dye lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Sound intensity probes', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Spring scales', 41111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Surface profilometers', 41114618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Telescopes', 41111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Thermoluminescent dosimeters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Turbo-pumped vacuum systems', 41103305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Two-channel dynamic signal analyzers', 41113647);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Two-channel fast Fourier transform FFT analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Two-channel network analyzers', 41113711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Vacuum stations', 41103306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Vernier force sensors', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Vibrating sample magnetometers', 41101806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Vibration exciters', 41103805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Visible spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'X ray crystallography equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'X ray photoemission spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2012.00', 'Zeeman split lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Air quality samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Air temperature thermometers', 41114408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Analog anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Digital anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Doppler radar equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Graphic tablets', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Hygrometers', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Light meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Mercury barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Next Generation Weather Radar NEXRAD', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Psychrometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Radiosonde launchers', 41114404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Rain gauges', 41114405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Relative humidity gauges', 41114408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Soil temperature probes', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Solarimeters', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Storm chase vehicles', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Surface temperature probes', 41112212);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Temperature and humidity data loggers', 41114408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Tipping bucket rain gauges', 41114405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Weather balloons', 41114411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Weather observation stations', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2021.00', 'Whirling hygrometers', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Air dryers', 41102412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Airfree/waterfree solvent purification systems', 41104812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Alcohol lamps', 41102402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Annealing ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Atomic absorption AA spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Automatic peptide synthesizers', 41103809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Autotitrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Benchtop lyophilizers', 23151807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Box furnace ovens', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Bunsen burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Capillary electrophoresis systems', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Carbon hydrogen nitrogen CHN elemental analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Centrifugal evaporator concentrators', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Chemical centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Closed cycle refrigerators', 41103023);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Cold trap evaporators', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Combustion furnaces', 41103308);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Conductance meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Conductivity detectors', 41113114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Cryogenic refrigerators', 41103011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Cuvettes', 41121813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Deflagration spoons', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Densitometers', 41103303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Digital electrophoresis documentation and analysis systems', 41105315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Digital gel analyzer systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Diode lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Distillation ovens', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Distilling units', 41104801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Dye lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Electrochemical analyzers', 41113003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Floor centrifuges', 41103905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Flow injection analyzers', 41103309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Fraction collectors', 41105305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Galvanostats', 41113619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Gas chromatograph mass spectrometers GC-MS', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Glassware washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Grinder mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Helium-cadmium lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'High-performance liquid chromatographs', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'High-pressure high-temperature reactors', 23151804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'High-pressure liquid chromatography systems', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'High-speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Hot plates with magnetic stirrers', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Hydrogenation apparatus', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Immersion probes', 41111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Inductively coupled plasma mass spectrometers ICP-MS', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Inert atmosphere glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Infrared IR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Inverted microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Ion analyzers', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Ion selective electrode ISE meters', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Karl Fischer titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Lab heat exchangers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Laboratory presses', 41101707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Laser power meters', 41115322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Liquid chromatographs LC', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Liquid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Luminescence spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Magnetic susceptibility balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Melting point apparatus', 41112203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Mercury lamp photolysis systems', 41111704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Micro electrobalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Microdistillation ovens', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Microinjectors', 41115715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Microplate spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Microwave digestion systems', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Mini synthesizers', 41103809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Monocular microscopes', 41111702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Multiwell microplates', 41113036);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Nanoscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Neodymium-doped yttrium aluminum garnet Nd:YAG lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Nitrogen lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Nuclear magnetic resonance NMR spectrometers', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Oscillating disc rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Oxygen bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Photochemical reactors', 41115716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Picosecond lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Pipetting stations', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Plasticorders', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Polarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Polarographic analyzers', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Pressure sensors', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Reagent pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Refrigerated circulators', 41103007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Refrigerated high-speed centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Respirometers', 41113119);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Rotary evaporators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Shaking incubators', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Shaking waterbaths', 41103710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Signal average storage scopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Single crystal x ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Solar simulators', 41104503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Solvent recyclers', 41102919);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Sonicators', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Speed-vac concentrators', 41104816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Split-hinge furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Stereo zoom microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Strip chart recorders', 41111906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Stripping analyzers', 41115807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Syringe pumps', 41105104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Tabletop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Tensile testers', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Thermal gravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Thistle tubes', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Tissue culture plates', 41122107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Top-loading electronic balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Tube magnetic mixers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Tubular furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Ultraviolet-visible spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'Well tissue culture plates', 41122102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2031.00', 'X ray diffraction equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Accelerometers', 41113639);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Annealing ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Atomic absorption AA spectroscopes', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Auger electron spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Backscatter detectors', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ball-on-disk tribometers', 41114625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Blungers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Box furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Capacitance manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Capillary rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Charge-coupled device CCD cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Cold isostatic presses', 23151607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Computerized numerical control CNC machining centers', 23101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Cone viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Contact angle goniometers', 41103317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Creep testing equipment', 41114606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Crystal growers', 41102706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Diamond wafering saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Dielectric spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Differential thermal analyzers', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Digital oscilloscopes', 41113638);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Dilatometers', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Double push rod dilatometers', 41113033);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Dynamic actuators', 31251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Dynamic light scattering equipment', 41102703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Dynamic mechanical analyzers DMA', 41113009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Electrode furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Electrolytic etching machines', 27112305);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Erosion testers', 41114601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Extruding machines', 23151503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Field emission scanning electron microscopes', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Fourier transform infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Freeze dryers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Function generators', 41115320);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Gamma ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Gas chromatograph mass spectrometers GC-MS', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Glove box systems', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Grinding spindles', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'High vacuum evaporation systems', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'High-speed cutoff saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'High-vacuum manifolds', 41104019);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Horizontal tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Hot isostatic presses', 23151607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Hot mounting presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Hydraulic presses', 27121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Imaging ellipsometers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Impact testers', 41114612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Induction furnaces', 41104605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Inductively coupled plasma mass spectrometers ICP-MS', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Industrial computed tomography CT scanners', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Interferometric microscopes', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ion analyzers', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Laboratory analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Laboratory water purification systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Laser interferometers', 41115306);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Linear variable differential transformers LVDT', 41111945);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Load cells', 41112108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Macrohardness testers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Manual grinders', 27111905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Metal evaporation chambers', 41104803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Metallographic microscopes', 41111718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Microcalorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Microscope digital cameras', 41111706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Mobile mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Mossbauer spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Multisample autoclaves', 41114604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Nanoscope atomic force microscopes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Neutron reflectometers', 41115316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Nitrogen furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Optical profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Peltier cooled solid-state detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Petrographic microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Plasma arc melting furnaces', 40101831);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Plate viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Pore sizers', 41113907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Potentiostats', 41113633);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Profilometers', 41114508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Programmable logic controllers PLC', 32101628);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Pulverizers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Quartz crystal microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Quartz crystal thickness monitors', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Raman scattering spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Reactive ion etchers RIE', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Rotational viscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Salt spray chambers', 41114604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Scanning Kelvin probes', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Scanning probe microscopes SPM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Scanning tunneling microscopes STM', 41111724);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Scratch testers', 41114601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Screw injection molding machines', 23151504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Secondary ion mass spectrometers SIMS', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Sedigraphs', 41113903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Semi-microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Semiautomatic grinders', 27112704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Servohydraulic test machines', 41114608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Shaker ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Slurry abrasion testers', 41114601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Sonic modulus testers', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Spectrofluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Sputter deposition systems', 23211101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Static actuators', 31251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Stereo microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Stylus profilometers', 41114618);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Swaging tools', 27111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Tape casters', 23161510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Thermal gravimetric analyzers', 41113010);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Thermal spray torches', 23271702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Theta-theta diffractometers', 41101810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Titanium autoclaves', 41114604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Transmission electron microscopes TEM', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Tube furnaces', 41104603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ultra high temperature furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ultra microbalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ultraprecision lathes', 23242303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ultrasonic analyzers', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'UV exposure chambers', 41114625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Vibrating sample magnetometers', 41101806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'Vibratory polishers', 23131509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2032.00', 'X ray generators', 41101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Aerosol spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Air quality dataloggers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Air/soil temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Airboats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Ambient air quality monitoring systems', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Ammonia meters', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Analog survey meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Atmospheric deposition collectors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Automatic samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Bomb samplers', 41104004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Bottom dredge samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Carbon monoxide meters', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Chlorine dioxide meters', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Chlorine meters', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Closed pipe Doppler water flow meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Coliform testing systems', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Combustible gas monitors', 26131701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Comparator water test kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Core samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Depth meters', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Digital survey meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Dosimeters', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Drop count industrial water test kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Electromagnetic field EMF meters', 41113614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Evaporation gauge sensors', 41114403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Explosimeters', 41113104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Fiberglass metering manholes', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Field radiological measuring devices', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Fuel temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Gas spillage detectors', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Geiger-Mueller meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Groundwater monitoring systems', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Hand held augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Heat stress monitors', 41113607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'HNu photoionization detectors PID', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Ionization chambers', 41113625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Lead air sampling kits', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Lead water sampling kits', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Liquid samplers', 41104006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Mercury monitors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Multichannel analyzers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Multiparameter water quality instruments', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Nephelometers', 41113026);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Noise dosimeters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Oil water interface meters', 41113314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Ozone meters', 41113111);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Particulate samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Photoionization detectors PID', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Pocket personal computers PC', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Psychrometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Radon monitors', 41113115);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Rain water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Scintillation probes', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Smoke generators', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Soil analysis kits', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Soil gas sampling systems', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Soil probes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Stormwater samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Submersible water data loggers', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Toxic mold test kits', 41116146);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Viscosity meters', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Water quality testing photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.00', 'Water velocity flow meters', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'High-performance cluster HPC computers', 43211502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2041.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Abney levels', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Agitators', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Alternating field demagnitizers', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Analog map measurers', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Argon plasma atomic emission spectroscopes', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Atomic absorption AA spectrophotometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Automated core analysis systems', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Axes', 27112005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Biological dredges', 22101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Borehole cameras', 20121913);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Bottom sampling equipment', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Brunauer-Emmett-Teller BET surface area analyzers', 41113107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Cathodoluminescence scopes', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Chisel hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Chromatographic scanners', 41115702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Computed tomography CT scanners', 42201511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Core splitters', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Crack hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Degaussing wands', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digital alkalinity titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digital map measurers', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digital seismographs', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Digitizing tablets', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Earth resistivity meters', 41113807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Echosounders', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electrical conductivity cells', 41115610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electrical conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electron microprobes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electronic bench scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Fluid inclusion microscopes', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Fusion fluxes', 41104018);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Gamma ray scintillometers', 41102702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Gamma ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Geo/paleo picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Geological compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Geological stratum compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Geophones', 20122605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Gravity meters', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Ground penetrating radar GPR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Hand levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Hand magnifying lenses', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'High temperature laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Hydraulic earth drills', 20102102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Illuminated microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Impulse magnetizers', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Isodynamic separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Jaw crushers', 20101706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Laboratory rock pulverizers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Laser rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Laser theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Long range radar equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Magnetic susceptibility measurement systems', 41113112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Magnetic susceptibility/anisotropy systems', 41113112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Magnetic susceptibility/temperature systems', 41113112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mapping dividers', 44111803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mapping scale sets', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mechanical earth drills', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mercury analyzers', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Microgravimeters', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Microsplitters', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Mobile wireless handheld communication devices', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Motorized mortars/pestles', 41101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Multibeam echosounders', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'One-atmosphere furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Penetrometers', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Petrographic microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Plankton nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Pneumatic airscribes', 27131502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Pocket magnetic susceptibility meters', 41113112);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Pocket transits', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Portable organic vapor analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Powered rock-coring drills', 20102101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Pry bars', 27112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Radiation detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Reverse osmosis systems', 41104204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rock chisels', 27111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rock magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rock picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rock saws', 20101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rotary grinders', 20101713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Roto torque mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Rotoevaporators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Sand grain size gauges', 41113908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Sediment piston corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Sediment samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Seismic activity recorders', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Seismic stations', 41114105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Seismographs', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Short-range radar equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Side scan sonars', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Sieve shakers', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Soft face hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Stereo microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Stereoscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Submicron particle size analyzers', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Sun compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Temperature profile recorders', 41112207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Test sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Thermal specimen demagnitizers', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Thermistor chains', 32121610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Towed sonars', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Tree corers', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Tube samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Tubular water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Ultrasonic sieve cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Ultraviolet UV lamps', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Underwater cameras', 45121512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Underwater sediment bearing strength probes', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Vertical sketchmasters', 44111812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Vibrating sample magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Video microscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Water current meters', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Water sampler bottles', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'Winches', 24101608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'X ray fluorescence spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2042.00', 'X ray fluorescence XRF lead detectors', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Biological oxygen demand water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Cellular telemetry system water level monitors', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Core samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Data logging pressure/temperature sensors', 20122902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Dip nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Doppler current and depth meters', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Double-packer systems', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Drive-point piezometers', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Erosion monitors', 41113902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Extensometers', 41114503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Filter flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Flow-through field fluorometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Groundwater data logging instruments', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Groundwater sampling peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Handheld data collection units', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Hydraulic fracturing systems', 41114105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Hydrological current meters', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Ice meters', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'In-situ pore water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Inclinometers', 41114504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Instream sediment collectors', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Light density meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Map templates', 44111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Multi-port sampling systems to monitor groundwater', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Multiparameter water quality instruments', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Oil water interface meters', 41113314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Pore pressure piezometers', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Portable pumping and sampling systems', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Radar equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Radiological monitoring equipment', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Salinity meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Sediment samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Sieve shakers', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Sounding reels', 41104011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Specific gravity hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Spring scales', 41111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Standpipe multi-packer systems for long-term monitoring of deep boreholes', 20121913);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Stream flow gauges', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Submersible pressure and level sensors', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Submersible water quality sensors', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Subsurface grab water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Suction samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Surface water velocity measurement probes', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Swing water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Underwater temperature recorders', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Underwater video cameras', 45121512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Well/surface water dataloggers', 20122903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2043.00', 'Wireless data collection systems', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Airborne imaging systems', 45121510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Airfield lighting equipment', 39111612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'DJI GS Pro', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Doppler Rayleigh laser imaging ranging and detecting LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'DroneDeploy', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'DroneLogbook', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Fixed wing unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Global positioning system GPS devices', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Ground control targets', 25202204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Hyperspectral imaging equipment', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Landing pad', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Multi-rotor unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Multispectral imaging equipment', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Power generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Spaceborne imaging systems', 45121510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Spectral imaging systems', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Synthetic aperture radar SAR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Thermal imaging systems', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-2099.01', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', 'Data scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', 'Maintrame computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3011.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Optical character readers', 43211717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3022.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Liquid crystal display LCD video projectors', 45111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3032.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Biofeedback equipment', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3033.00', 'Universal serial bus USB flash drives', 43201813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Computer scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Overhead projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3034.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Auditory stimulation equipment', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Block pattern sets', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Facial electromyography equipment', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Grip testing devices', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Pegboards', 42251504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Pocket smell tests', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Respiration measurement equipment', 42271505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Skin conductance testing equipment', 42141804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Visual stimulation test equipment', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.02', 'Wisconsin Card Sorting Test', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Auditory stimulation equipment', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Block pattern sets', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Facial electromyography equipment', 42181516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Grip testing devices', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Pegboards', 42251504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Pocket smell tests', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Respiration measurement equipment', 42271505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Skin conductance testing equipment', 42141804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Visual stimulation test equipment', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3039.03', 'Wisconsin Card Sorting Test', 42251502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Digital video recorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3041.00', 'Videoconferencing equipment', 45111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', '10-key calculators', 44101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Digital camcorders', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Drafting scales', 44111807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Microfiche readers', 45112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Overhead projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Photocopiers', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Slide projectors', 45111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3051.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Alidades', 41114203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Bench scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Bucket augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Cold chisels', 27111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Conductance meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Conductivity probes', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Countertop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Crack hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Dental burs', 42151614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Dental picks', 42151631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Deoxyribonucleic acid DNA analyzers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Dial calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digital calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digital levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Directional compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Drying racks', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Dust masks', 46182001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Electrical resistivity instruments', 41113807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Electron microprobes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Electronic topload scales', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Enzyme-linked immunosorbent assay ELISA plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'External lavalier microphones', 52161520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Film processors', 45141602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Flat-ended shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Flatbed scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Fluorometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Gel electrophoresis boxes', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Geophysical magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Glass burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Graded sieves', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Ground penetrating radar GPR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'High resolution industrial computed tomography CT scanners', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Hot stir plates', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Hydraulic drilling rigs', 20122820);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Immersion thermostats', 41112209);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Inductively coupled plasma emission spectroscopes ICP-ES', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Inductively coupled plasma mass spectroscopes ICP-MS', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Industrial micro computed tomography CT scanners', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory binocular microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory glove boxes', 41103406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory precision balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory refrigerators', 41103011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory scalpels', 41122407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory vacuum dryers', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laboratory water purification systems', 41104206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laser line levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Laser scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Lufkin tape measures', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Luminescence readers', 41113002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Magnetic stirring bars', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Mandibulometers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Marshalltown trowels', 27112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Mesh sifting screens', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Metal detectors', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Metallurgical microscopes', 41111718);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Oil immersion microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Petrographic microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Plains trowels', 27112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Platform scales', 41111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Plumb bobs', 27111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Pneumatic airscribes', 27131502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Pneumatic chisels', 27131504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Pocket loupes', 41111714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Polymerase chain reaction PCR hoods', 41103506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Polymerase chain reaction PCR thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Portable gamma spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Portable x ray machines', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Precision rulers', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Precision saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Protective gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Remote sensing equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Rock picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Round point shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Sandblasters', 27131507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Scuba diving equipment', 49141504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Selective ion meters', 41115606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Shaker screens', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Side scan sonars', 41115501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Slide hammers', 27111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Slide scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Sliding calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Soil probes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Spreading calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Stereo zoom microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Thermomixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Thin section saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Transcription equipment', 44102605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Tree ring sampling kits', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Ultrasonic cleaning machines', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Ultraviolet UV crosslinkers', 41105316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Ultraviolet UV transilluminators', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Underwater digital cameras', 45121512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Underwater still cameras', 45121512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Vacuum freeze-drying chambers', 41104701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Vernier calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'Water screening devices', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'X ray cabinets', 41111808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3091.00', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Abney levels', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Atomic emission spectroscopes', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Automatic levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Cathodoluminescence microscopes', 41111721);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Chain saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Compaction meters', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Crosscut saws', 21102204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Deionizers', 41101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Demagnetizing equipment', 41113803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Digital imaging microscopes', 41111737);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Digitizers', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Dutch augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Electromagnetic current meters', 41113614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Electronic precision balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Flatbed scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Flow meters', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Four wheel drive 4WD vehicles', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Gas-mixing furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Gravity convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Ground penetrating radar GPR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Handheld data loggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'High temperature laboratory box furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'High-speed centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Hiller corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Humidity sensors', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Infrared IR thermometers', 41112202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Ion chromatographs', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laboratory analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laboratory dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laboratory sample splitters', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Large format printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laser levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Laser particle sizers', 41113903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Livingstone corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Lysimeters', 41114403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Mechanical current meters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Optical comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Petrographic microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'pH analyzers', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Photosynthetically active radiation PAR meters', 41114407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Portable data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Portable fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Portable weather stations', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Powered rock-coring drills', 20102101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Powered vibracorers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Pressure plate apparatus', 41113906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Research motorboats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Rock saws', 20101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Russian corers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Salinity meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sample storage refrigerators', 41103011);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sediment coring equipment', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sediment samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sediment traps', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Seismic stations', 41114105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sieve shakers', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Soil mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Soil moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sonic anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Sonic sifters', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Spinner magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Stereo light microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Stereo zoom microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Stereographic microscopes', 41111703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Submersible pressure sensors', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Survey altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Temperature sensors', 41112105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Total dissolved solids TDS meters', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Tree increment borers', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Truck-mounted drilling rigs', 20122820);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Turbidity probes', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Ultrasonic sieving systems', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Video cameras', 45121515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Video microscopes', 41111708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Water current meters', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'Wind direction sensors', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'X ray diffraction equipment', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3092.00', 'X ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Analog-to-digital converters', 45111701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Computer inkjet printers', 43212104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Digital still cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Microfiche readers', 45112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Microfilm readers', 45112001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Microphones', 52161520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3093.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Conference phones', 45111901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Digital audio recorders', 52161535);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Digital video disk DVD players', 52161516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3094.00', 'Overhead display projectors', 45111607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Blueprint machines', 43212114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-3099.01', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Aerosol foggers', 21101805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Aerosol generators', 21101805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Agricultural tractors', 25101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Air samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Animal chutes', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Animal head-locks', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Animal measuring sticks', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Animal tatooers', 21101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Artificial insemination syringes', 42121507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Balers', 21101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Bed shapers', 21101506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Blood collection syringes', 42142616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Callicrate banding systems', 42121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Chemical sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Chisel cultivators', 21101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Combine harvesters', 21101704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Compound binocular light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Crop sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Cultivators', 21101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Dipping vats', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Disks', 21101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Egg incubators', 21101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Egg setters or hatchers', 21101903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Elastrator bands', 42121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Electronic bench scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Electronic counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Fertilizer or seed spreaders', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Gas welders', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Grain augers', 24101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Granule applicators', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Harrows', 21101502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Harvesters', 21101703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Heavy cargo trucks', 25101611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Hypodermic syringes', 42142609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Infrared lamps', 39101613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Insect collectors', 41102507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Laboratory mechanical convection incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Laboratory separators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Ladders', 30191501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Light trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Livestock scales', 41111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Metal inert gas MIG welders', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Milk cooling equipment', 21101908);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Milking machines', 21101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Mowers', 21101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Nitrogen test meters', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Personal digital assistants PDA', 43211504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Planters', 21101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Planting sleds', 21101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Plows', 21101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Pollen collectors', 41104015);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Portable refractometers', 41115313);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Power dusters', 21101802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Power saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Pruning shears', 21102204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Rakes', 21101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Reach pole saws', 21102204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Reverse osmosis systems', 41104204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Sample vials', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Shielded arc welding tools', 23271409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Soil moisture neutron probes', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Soil sterilizers', 42281502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Spray-dip machines', 21101902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Steam sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Surface thermometers', 41112212);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Sweep cultivator shovels', 21101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Temperature controlled reach-in growth chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Temperature gauges', 41114408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Threshers', 21101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Tracked bulldozers', 22101522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Trenchers', 22101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Vaccination syringes', 42142614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Vacuum blood collection tubes', 41104107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Weather instruments', 41114410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.00', 'Weight meters', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Air clutches', 21101607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Automatic boom control systems', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Automatic land leveling systems', 41112904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Autosteering systems', 41112904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Fertilizer spreading equipment', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Field personal computers PC', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Lightbar guidance systems', 41112904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Moisture monitors', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Seed drills', 21101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Soil electrical conductivity measurement devices', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Soil samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Sprayer application equipment', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Tractor mounted soil probes', 41113904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Variable rate applicators', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4012.01', 'Yield monitor systems', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Agar plates', 41106217);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Anaerobic jars', 41104303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Bioluminometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Boiling water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Bunsen burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Colony counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Color testing equipment', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Compound binocular light microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Distilling equipment', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Dry bulb thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Enzyme-linked immunosorbent assay ELISA plate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Eyewash fountains', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Fluorescent microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Gas analyzers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'General purpose laboratory test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Grinders', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Handheld thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Hot air ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Inoculation tubes', 41122106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory clamps', 41122413);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory coats', 46181532);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory glass burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory hot plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory knives', 41122406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory mechanical convection incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory stirring rods', 41121802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory strainers', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laboratory tongs', 41122404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Magnetic retrievers', 27112109);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Magnetic stir bars', 41122401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Metal detectors', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Microwell readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Moisture balances', 41111513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Mortars and pestles', 41101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Particle size testing equipment', 41101809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Pasteur pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Precision scales', 41111507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Safety showers', 46182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Siphons', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Steam autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Steam sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Temperature probes', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Ultraviolet UV lights', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Universal indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Vacuum ovens', 41104509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Viscosity testing equipment', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Water activity meters', 41104207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Wet bulb thermometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4013.00', 'Zhan cups', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Aerobic growth chambers', 41103410);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Agitators', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Amino acid analyzers', 41115801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Anaerobic growth chambers', 41103407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Analytical balances', 41111517);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Automated cell counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Automated microplate ELISA readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Automated tissue/slide stainers', 41102905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Automatic pipetters', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Bioanalyzers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Biological containment hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Coulter counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Cytofluorographs', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Deoxyribonucleic acid DNA sequencers', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Deoxyribonucleic acid DNA synthesizers', 41105903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Dissection microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Distillation equipment', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Electrophorators', 41105303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Electrophoresis boxes', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Flow cytometers', 41115821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Fluoride electrodes', 41115608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Fluorometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Full-face respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Gel chromatography equipment', 41104902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Gel imaging apparatus', 41105304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Glass washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Hematology cell counters', 41111948);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'High-voltage electrophoresis apparatus', 41105307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Hybridization ovens', 41104511);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Imaging systems', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Incubator microscopes', 41104424);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Inherit sequencing analysis systems', 41115811);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Inoculating loops', 41122108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Inverted microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Laboratory ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Light/tissue culture microscopes', 41111712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Liquid handling robots', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Liquid nitrogen freezers', 41103006);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Microcentrifuges', 41103901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Microplate readers', 41113037);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Microplate shakers', 41104405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Microplate washers', 41103207);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Multichannel pipetters', 41121508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Paraffin embedding consoles', 41102901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Petri dishes', 41122101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Polymerase chain reaction PCR equipment', 41106312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Polymerase chain reaction PCR thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Protein sequencers', 41115823);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Radioactive counters', 41113404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Refrigerated centrifuges', 41103904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Robotic laboratory equipment', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Stirring hotplates', 41102423);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Test tubes', 41121701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Titration burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Ultralow freezers', 41103005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Ultramicrotomes', 41102916);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Ultrasonic cleaners', 42282017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Ultraviolet water purification systems', 41104205);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Vacuum dehydration units', 41104208);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Volumetric glassware', 41121510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Water jacketed incubators', 41104415);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4021.00', 'Waterbaths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Abbe refractometers', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Agitation tanks', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ammeters', 41113601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Aneroid barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Asbestos gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Atomic absorption AA spectroscopes', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Atomic emissions spectroscopes', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Automated microviscometers', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Automated polarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Automatic buret cleaners', 41103203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Automatic burets', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Automatic pipette cleaners', 41103203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Autotitrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ball mills', 41101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Beckmann thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bell jars', 41121810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bimetallic strip thermometers', 41111915);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bomb calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bourdon gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bubble flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bubble-cap fractionating columns', 41104810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Buchner funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Bunsen burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Canister gas masks', 46182003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Capillary tubing', 41105108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Cartesian manostats', 41112402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Chromatography developing tanks', 41115713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Chromatography microsyringes', 41122001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Claisen flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Closed-end manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Comparators', 41113702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Computer-controlled pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Constant temperature water baths', 41103706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Cooling baths', 41103709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Cork borer sets', 41122503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Coulometers', 41101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Dessicators', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Deuterium lamps', 41115418);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Differential refractometers', 41115312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Differential scanning calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Diffusion pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Digital handheld thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Distilling condensers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Drying pistols', 41123004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Dust and particulate respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Dye lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Electronic toploading balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Evaporating dishes', 41121812);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Evaporator rotators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Exhaust hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Explosion-proof fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Eyewash fountains', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Face shields', 46181702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Filter pumps', 40161506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Finger pumps', 41105104);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Flame photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Fluid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Fluorimeters', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Fourier transfer infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gas burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gas drying tubes', 41105108);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gas leak detectors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Geiger-Muller counters', 60105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Glass burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Glass laboratory crucibles', 41122201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Glass tubing', 41121816);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gooch crucibles', 41122202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Graphing calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Graphite furnaces', 41104604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gravitational field indicators', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Gravity convection ovens', 41104501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Hazardous material protective clothing', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Heating mantles', 41102405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'High pressure sodium lamps', 39101617);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Hirsch funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Hollow cathode lamps', 41115418);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Homogenizers', 41101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Hot air blowers', 41102412);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Immersion heaters', 40101815);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Infrared IR spectroscopes', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Infrared lamps', 39101613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ion exchange chromatography equipment', 41115704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ionization gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory blenders', 41101518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory centrifugal pumps', 41105103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory heating plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory pressing equipment', 41101707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory tongs', 41122404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory vacuum hand pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Laminar flow burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Lecture bottles', 24111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Liquid chromatography equipment', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Liquid chromatography/mass spectrometry LC/MS equipment', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Liquid transfer pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Liquid-filled remote thermometers', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Lyophilizers', 23151807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Magnetic agitators', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Magnetic stirring bars', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Mainframe computers', 43211512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'McLeod gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Meker burners', 41102401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Mercury barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Mercury vapor lamps', 39101615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Metering pumps', 41105105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Molecular stills', 41104810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Monochromators', 41113025);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Mortars and pestles', 41101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Muffle furnaces', 41104601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Nebulizers', 41101503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Nuclear magnetic resonance NMR spectroscopes', 41115409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Optical beamsplitting devices', 31242201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Optical pyrometers', 41112204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Organic carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Perchloric acid hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'pH indicators', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Photo detectors', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Photocells', 39121528);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Photomultiplier tubes', 41115720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Pirani gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Plastic cuvettes', 41121813);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Polarimeters', 41115314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Polarizers', 31242202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Pressure gauges', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Pull spring balances', 41111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Pycnometers', 41103316);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Radiation detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Radioisotope fume hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Reaction flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Reflux condensers', 41104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Refrigerated coolers', 41103008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Rheometers', 41112502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Rotameters', 41112503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Rotary evaporators', 41104804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ruby lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Safety gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Safety showers', 46182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Sample crushers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Single-pan balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Steam baths', 41102426);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Tension gauges', 41114509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Test tube clamps', 41122413);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Thermal conductivity detectors', 41113114);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Thermocouples', 41112206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Thinlayer chromatography analyzers', 41115706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Titrators', 41115602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Torsion balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Transfer pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Triple beam balances', 41111512);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'U-tube manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ultracentrifuges', 41103907);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ultraviolet UV lamps', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ultraviolet UV light detectors', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Ultraviolet UV spectroscopes', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Unequal-arm balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Utility clamps', 41122413);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Vacuum flask traps', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Vacuum gauges', 41112406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Vapor monitor badges', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Velometers', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Viscosity meters', 41103312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Voltmeters', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Volume displacement pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Volumetric flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Volumetric glass pipettes', 41121510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Water aspirators', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4031.00', 'Westphal balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Air current test kits', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Air monitoring equipment', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Air sampling impingers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Air sampling primary flow calibrators', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Area sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Autoclaves', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Binocular light compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Bioaerosol impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Bladder water sampling pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Carbon monoxide monitors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Carpet sampling pump kits', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Centrifugal water sampling pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Chloride test kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Chlorinated hydrocarbon testing equipment', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'CO2 monitors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Colorimetric field sampling devices', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Detector tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Digital hand meters', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Digitizing tablets', 43211712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Dilution systems', 41121502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Electronic pump calibrators', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Explosive gas monitors', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Field data collection computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Flow monitoring equipment', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Freon detectors', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Hach field kits', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Halide meters', 41113105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Halogen leak detectors', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Handheld laser particle counters', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Humidity sticks', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Hygrometers', 41112301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Indoor air quality IAQ monitors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Infiltrometers', 41113905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Interface probes', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Landfill gas collection systems', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Landfill gas detection systems', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Large-format plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Lead air sampling kits', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Lead soil sampling kits', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Lead surface sampling kits', 41113321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Lead water sampling kits', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Low-flow pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Lux or light meter', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Micromanometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Micropurge sampling equipment', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Nephelometers', 41113026);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Noise dosimeters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Noise logging analyzers', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Noise monitoring instruments', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Ozone generators', 49241708);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Particulate monitors', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Particulate samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Passive samplers for organic vapors', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Photoionization detectors PID', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Pilot tubes', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Pocket personal computers PC', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Polarized light microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Pump flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Purge pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Radon detection devices', 41113115);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Salinity meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Sequential air samplers', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Sewer surveillance cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Soil vapor extraction units', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Sound level meters', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Velocity meters', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Velometers', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Vibration monitors', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Volt-ohm meters VOM', 41113631);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water chemistry analysis equipment', 41113319);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water sample extraction pumps', 40151520);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water sample extraction tubes', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water sampling augers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water sampling bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water sampling pumps', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Water well depth meters', 41114302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4042.00', 'Zero air generators', 47101513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Abney levels', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Automatic burets', 41121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Binocular polarizing microscopes', 41111725);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Calorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Carbon hydrogen nitrogen CHN analyzers', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Chipmunk crushers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Conductivity indicators', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Cryogenic magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital chlorine testers', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital hydrometers', 41113024);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital micropipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Digital seismographs', 41114106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Directional compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Dissolved organic carbon analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Dissolved oxygen meters', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Dissolved salt meters', 41115613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Earth drills', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Electronic digital levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Electronic digital theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Electronic distance meters', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Electronic laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Erlenmeyer flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Fluorescence microscopes', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Fourier transfer infrared FTIR spectrometers', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Gas chromatography equipment', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'General purpose burets', 41121808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Geological hammers', 27111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Glass beakers', 41121803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Glass dropping pipettes', 41121513);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Glass funnels', 41121809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Glass graduated cylinders', 41121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Glass laboratory crucibles', 41122201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Gravitational field indicators', 41113808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Ground penetrating radar GPR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Groundwater sampling peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Hand augers', 27111509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Hand lenses', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Hand levels', 27111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Heated magnetic stirrers', 41103806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'High pressure liquid chromatograph HPLC equipment', 41115707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Hydraulic vibracorers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Inductively coupled plasma ICP optical emission spectrometers', 41115411);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Jaw crushers', 20101706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laboratory drying ovens', 41104510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laboratory pulverizers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laboratory sieves', 41105003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laboratory vacuum pumps', 41105101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Laser rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Microwave digestion systems', 41104806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Optical particle detectors', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Phase contrast microscopes', 41111719);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Piezometers', 41111927);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Pocket transits', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Portable dataloggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Power rock coring drills', 20102101);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Proton magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Rock picks', 27111605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Rock saws', 20101504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Rotary pulverizers', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Sample microsplitters', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Scanning electron microscopes SEM', 41111720);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Scientific calculators', 44101808);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Shatterboxes', 41101705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Sieve shakers', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Single crystal x ray diffractometers', 41102704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Soil core samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Spinner magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Stadia rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Surveillance binoculars', 41111717);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Survey altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Terrain conductivity meters', 41115609);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Top-loading electronic balances', 41111501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Total sulfur analyzers', 41113113);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Turbidimeters', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Ultraviolet-Visible UV/VIS spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Volumetric flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Water distillation units', 41104802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'Water sampling bailers', 41104005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4043.00', 'X ray fluorescence XRF spectrometers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Air purifying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Airline respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Area gamma monitors', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Atmosphere supplying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Condensate demineralizers', 47101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Contamination probes', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Control rod drives', 26142106);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Digital ratemeters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Digital signal analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Digital spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Eddy current testing equipment', 41111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Emergency diesel generators', 26111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Fuel handling systems', 15131601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Gamma exit/entrance contamination monitors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Gantry cranes', 24101619);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Hot cell remote viewing devices', 26141802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Leak detection equipment', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Level transmitters', 41111938);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Master-slave manipulators', 26141801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Metal active gas MAG welding equipment', 23271707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Metal inert gas MIG welding equipment', 23271408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Multichannel analyzers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'New fuel elevators', 24101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Non-contact thermometers', 41112210);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Pipe camera inspection systems', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Plasma arc cutting torches', 23271821);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Pocket dosimeters', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Portable two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Portal monitors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Pressure cleaners', 47121805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Pressure demand respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Protective coveralls', 46181503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Protective gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Protective shoe covers', 46181606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Radiation survey meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Scintillation detectors', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Seismic monitoring instruments', 26142117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Spent fuel handling machines', 26142407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Ultrasonic flaw detectors', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Ultrasonic thickness gauges', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Vibration monitors', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Video borescopes', 41111716);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.00', 'Videoscopes', 41111737);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Air purifying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Air sampling devices', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Airline respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Alpha air monitors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Alpha/beta counting systems', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Alpha/beta surface contamination monitors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Area gamma monitors', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Atmosphere supplying respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Contamination probes', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Cryogenic microcalorimeters', 41112201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Cryostats', 41103003);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Digital ratemeters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Digital signal analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Digital spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Dose rate monitors', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Electron microscopes', 41111711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Gamma ray detectors', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Gamma ray spectrometers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Geiger-Muller counters', 60105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Ionization chambers', 41113625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Liquid scintillation counters', 41103301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Multichannel analyzers', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Neutron detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Neutron dose-rate meters', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Neutron spectrometers', 41115407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Nuclear moisture/density gauges', 26141906);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Portable data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Portable spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Portable survey radiation meters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Portal monitors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Pressure demand respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Proportional counters', 41113005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Protective coveralls', 46181503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Protective gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Protective shoe covers', 46181606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Radiological detectors', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Sodium Iodide NaI scintillation detectors', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Thermoluminescent dosimeters', 41111929);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Tritium/Noble gas monitors', 26141902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4051.02', 'Whole body counters', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Computer data input scanners', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Computer laser printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Multi-line telephone systems', 43191507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Photocopying equipment', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4061.00', 'Transcription equipment', 44102605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Aerial bucket trucks', 22101803);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Airboats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'All terrain vehicles ATV', 25101905);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Altimeters', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Amphibious excavators', 22101526);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Aquatic weed harvesters', 22101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Axes', 27112005);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Backhoes', 22101509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Basal area factor BAF prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Boats', 25111802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Brush hooks', 21102203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Brush trucks', 25101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Bulldozers', 22101523);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Chain saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Clearing hooks', 21102202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Clinometers', 41114001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Crown densitometers', 41113802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Diameter tapes', 41114201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Dibblers', 21101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Dump trucks', 25101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Electronic rain gauges ERR', 41114405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Electroshocking boats', 25111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Excavators', 22101526);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Farm tractors', 25101901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Fertilizer spreaders', 21101804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Field data recorders', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Field personal computers PC', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Fire plows', 22101701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Forestry rain gauges', 41114405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Forklifts', 24101603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Frame nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Front end loaders', 22101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Geological compasses', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Gill nets', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Girdling tools', 21102201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Global positioning system GPS data collectors', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Grass whips', 21102202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Gunjets for pressurized sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Handheld refractometers', 41115313);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Harrows', 21101502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Hydraulic dredges', 22101514);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Hydraulic truck-mounted cranes', 24101624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Hypsometers', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Increment borers', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Laser rangefinders', 41111603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Laser surveying equipment', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Laser tree measuring devices', 41111615);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Lawn mowers', 27112014);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Leaf area meter scanning instruments', 43211711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Loggers'' tapes', 41114201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Macroalgae harvesters', 21111602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Magnetic locators', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Mantax computer tree calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'McLeod tools', 46191605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Measuring wheels', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Metal detectors', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Pickup trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Planimeters', 60103409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Planters', 21101601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Plug spades', 21102203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Pocket transits', 41113801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Prisms', 31241502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Pruning saws', 21102204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Pulaski tools', 46191605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Relaskops', 41111614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Remote sensing equipment', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Remote video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Rubber-tired bulldozers', 22101523);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Seed drills', 21101604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Seines', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Slurry buckets', 22101702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Snowplows', 22101710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Soil augers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Soil moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Soil probes', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Sprayers', 21101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Stadia rods', 41114202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Stream flow gauges', 41114301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Survey levels', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Survey transits', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Tensiometers', 41114509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Terrain torches', 12131707);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Theodolites', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Total stations', 41114204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Track bulldozers', 22101522);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Trail motorbikes', 25101801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Trawls', 21111504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Tree corers', 21102206);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Tree planter spades', 21102203);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Truck cranes', 24101625);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Truck-mounted water pumps', 40151510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Trucks', 25101507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Tugboats', 25111506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Video editing equipment', 45111805);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Water level recorders', 41114303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Water monitoring meters', 41112504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Water monitoring samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Water samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Water trucks', 25101610);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Watermark soil moisture data collectors', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Wedges', 27112504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Wheeler pentaprism calipers', 41111621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Wildland fire pumper trucks', 25101704);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Winch trucks', 25101602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4071.00', 'Winches', 24101608);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', '35 millimeter cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Benchtop mixers', 41103801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Biohazard suits', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Blood collection kits', 42261904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Body fluid collection kits', 42261904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Breathalyzers', 46151604);
/*! COMMIT */;
/*! START TRANSACTION */;
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Colored camera filters', 45121603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Crime scene evidence flags', 55121715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Crime scene tape measures', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Cyanoacrylate fuming chambers', 46151712);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Deoxyribonucleic acid DNA collection kits', 42261904);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Distance measuring wheels', 41111616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Drug testing kits', 46151606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Electronic measuring devices', 41111613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Electronic precision balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Electrostatic dust print lifters', 46151711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Evidence collection containers', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Evidence scissors', 41122408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Fingerprint brushes', 46151702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Fingerprint evidence kits', 46151706);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Fingerprint recognition systems', 43211714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Footwear protectors', 46181606);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Fuming hot plates', 41102406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Gel lifters', 46151711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Glass specimen jars', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Glassware washers', 41103202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Gunshot residue kits', 41113322);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Hand held magnifiers', 41111713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Handheld digital thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Handheld evidence collection computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Impression casting kits', 46151711);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Infrared light sources', 39101613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Insect collection containers', 41102501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Insect swoop nets', 41102503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Inspection mirrors', 27111814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Laboratory benchtop centrifuges', 41103903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Large format cameras', 45121501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Laser trajectory kits', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Long-wave ultraviolet UV lamps', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Medical hemostats', 42294913);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Metal detectors', 41111903);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Microscope slides', 41122601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Mobile data computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Navigational compasses', 41112901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Optical compound microscopes', 41111709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Photo markers', 55121731);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Photographic scales', 41111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Plastic evidence tweezers', 41122409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Plastic specimen jars', 41104118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Pointed scalpels', 41122407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Police vans', 25101505);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Portable generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Portable lasers', 41115307);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Portable two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Postmortem print spoons', 42261901);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Protective latex gloves', 46181504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Protective masks', 42131713);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Protractors', 44111806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Reciprocating saws', 27112709);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Rounded scalpels', 41122407);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Safety glasses', 46181802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Sexual assault evidence collection kits', 42181506);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Shovels', 27112004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Sifting screens', 41105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Spades', 27112002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Stainless steel scissors', 41122408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Stainless steel spatulas', 41122403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Stainless steel tweezers', 41122409);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Steam sterilizers', 42281508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Steel measuring tape', 27111801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Thermocyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Ultraviolet UV camera lens filters', 45121603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Ultraviolet UV lights', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'Utility knives', 27111503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4092.00', 'UV forensic goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Absorbance spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Adhesion testers', 41114614);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Autosamplers', 41115714);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Bolt tension meters', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Coating thickness gauges', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Copy machines', 44101501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Dew point meters', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Durometers', 41114611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Dynamometers', 41114501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Flowmeters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Fluorescence spectrophotometers', 41115406);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Force gauges', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Gas chromatographs', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Gel casters', 41105301);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Gel electrophoresis systems', 41105314);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'High performance liquid chromatography systems', 41115705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Imaging systems', 41111722);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Incubators', 41104402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Laser facsimile machines', 44101508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Levelmeters', 41113710);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Mass spectrometers', 41115404);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Microfilm systems', 45121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Micrometers', 41111601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'pH meters', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Replica Tape', 31201527);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Sonic testers', 41111623);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Sonicators', 41102914);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Spark Testers', 41113637);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Stroboscopes', 41115317);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Surface profile gauges', 27112312);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Tachometers', 41112802);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Tension meters', 41114621);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Textile moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Thermal cyclers', 41102421);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Torque testers', 41111934);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Torque wrenches', 27111715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Total organic carbon TOC analyzers', 41113315);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Ultrasonic flaw detectors', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Ultrasonic thickness gauges', 41111804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Ultraviolet spectroscopes', 41115403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Vibration meters', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.01', 'Wastewater samplers', 41104007);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Airfield lighting equipment', 39111612);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'DJI GS Pro', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'DroneDeploy', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Field computers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Fixed wing unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Gamma ray scintillometers', 41102702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Geophysical magnetometers', 41113806);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Global positioning system GPS devices', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Global positioning system GPS receivers', 52161518);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Ground control targets', 25202204);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Hyperspectral imaging equipment', 41115402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Landing pad', 25201604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Laptop computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Large format printers', 43212105);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Laser imaging detection and ranging LIDAR systems', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Multi-rotor unmanned aerial vehicles UAV', 25131801);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Multispectral imaging equipment', 41115408);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Photo enlargers', 45121705);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Plotters', 43212107);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Power generators', 26111604);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Radiometers', 60104814);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Spectrum analyzers', 41115303);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Synthetic aperture radar SAR', 41115201);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Tablet computers', 43211509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Thermal infrared remote sensing equipment', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Thermal infrared sensors', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Two way radios', 43191510);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-4099.03', 'Web servers', 43211501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Aerosol monitoring instruments', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Air flow monitors', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Air sampling impingers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Air sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Audiometers', 42182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Barometers', 41114402);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Benzene detector tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Cascade impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Charcoal absorption tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Chemical detection tubes', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Chlorine monitors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Colorimeters', 41115318);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Combustible gas meters', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Compressed air guns', 27131502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Desktop computers', 43211507);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Dissolved oxygen monitors', 41115611);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Dry gas meters', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Emergency eye wash stations', 46181810);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Emergency shower stations', 46182401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Fire extinguishers', 46191601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Gamma radiation survey meters', 41113405);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Gas leak testing equipment', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Geiger-Muller counters', 60105002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Gravimetric dust samplers', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Handheld thermometers', 41112213);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'High-volume air sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Humidity measurement equipment', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Laboratory balances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Laboratory transfer pipettes', 41121509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Liquid leak testing equipment', 41111932);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Low-volume air sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Lux or light meter', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Medical measuring tapes', 42182702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Microliter syringes', 41122004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Mold sampling equipment', 41116146);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Multi-gas detectors', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Notebook computers', 43211503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Particle sensors', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Peristaltic pumps', 41105102);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Personal protective suits', 46181509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'pH monitors', 41115603);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Photometer', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Pressure meters', 41112403);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Protective ear muffs', 46181902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Psychrometers', 41112302);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Radiation monitoring instruments', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Refrigerant leak detectors', 41111932);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Rotameters', 41112503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Safety goggles', 46181804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Safety shoes', 46181605);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Sample vials', 41104017);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Sampling trains', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Self-contained breathing apparatus', 46182004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Smoke generating tubes', 41111809);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Soil testing kits', 41113910);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Sorbent tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Spirometers', 42271602);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Turbidity monitors', 47101516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Ultraviolet UV digital meters', 41115701);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Vibration measurement equipment', 41114624);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Volumetric flasks', 41121804);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'Wet test meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5011.00', 'X ray fluorescence XRF lead testing analyzers', 41115401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Aerosol meters', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Aerosol photometers', 41115311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Air compressors', 40151601);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Air flow calibrators', 41112509);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Air quality dataloggers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Airflow indicators', 41111931);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Anemometers', 41114401);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Carbon monoxide sensors', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Cascade impactors', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Combustible gas detectors', 46171613);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Cyclone samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Data acquisition equipment', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Data loggers', 43211715);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Diffusive air samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Digital cameras', 45121504);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Digital video cameras', 45121516);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Dry-gas meters', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Dust collectors', 40161503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Electrobalances', 41111502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Electrochemical gas monitors', 41113118);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Electronic bubble meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Electronic pump calibrators', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Electrostatic precipitators', 41105001);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Flame ionization detectors FID', 41113004);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Flow hoods', 41103502);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Gas chromatographs GC', 41115703);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Gas detector tubes', 41113116);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Gilibrators', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Grab samplers', 41113909);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Half-face respirators', 46182002);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Handheld calculators', 44101807);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Heat stress monitors', 41113607);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Impingers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Infrared analyzers', 41115321);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Infrared thermometers', 41112202);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Inspection lamps', 39101616);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Light meters', 41115309);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Manometers', 41103311);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Mass flow meters', 41112501);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Medical measuring tapes', 42182702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Mercury vapor analyzers', 41113117);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Microbial samplers', 41104008);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Moisture meters', 41112304);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Multimeters', 41113630);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Octave band analyzers', 41115503);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Oxygen monitors', 42271515);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Particle counters', 41111902);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Particle sensors', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Particulate monitors', 41104016);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Passive dosimeters', 26141702);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Passive samplers', 41113103);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Personal computers', 43211508);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-5012.00', 'Personal sampling pumps', 41104009);
INSERT INTO tools_used (onetsoc_code, example, commodity_code) VALUES ('19-501