CREATE TABLE emerging_tasks (
  onetsoc_code CHARACTER(10) NOT NULL,
  task CHARACTER VARYING(1000) NOT NULL,
  category CHARACTER VARYING(8) NOT NULL,
  original_task_id DECIMAL(8,0),
  writein_total DECIMAL(3,0) NOT NULL,
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (original_task_id) REFERENCES task_statements(task_id));

INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3051.02', 'Conduct employee safety training.', 'New', NULL, 9, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-3051.06', 'Train employees in power plant operations.', 'New', NULL, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9071.00', 'Monitor the performance of the gaming floor, relocating games and installing new games as necessary.', 'New', NULL, 6, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('11-9171.00', 'Deliver death certificates to medical facilities or offices to obtain signatures from legally authorized persons.', 'New', NULL, 6, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Contact vendors to locate replacement parts for vehicles.', 'New', NULL, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Discuss insurance claims with customers or damage claimants.', 'New', NULL, 13, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1032.00', 'Review repair cost estimates and negotiate with automobile repair shops to secure agreement on cost of repairs.', 'Revision', 7247, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1041.03', 'Develop guidelines for nondiscriminatory employment practices, such as affirmative action plans and equal opportunity employment policies.', 'Revision', 20722, 13, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1041.03', 'Train employees on equal opportunity laws, guidelines, or policies, such as discrimination, diversity, harassment, or affirmative action.', 'New', NULL, 13, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1041.07', 'Develop regulatory strategies for products.', 'New', NULL, 4, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1121.00', 'Contact potential clients, meet with professional and trade associations, and produce brochures and other publications to promote conference, convention, and trade show services.', 'Revision', 1228, 8, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1121.00', 'Plan and develop programs, agendas, budgets, menus, and services according to customer requirements.', 'Revision', 1213, 7, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1141.00', 'Develop and administer compensation programs such as merit or incentive pay.', 'New', NULL, 11, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-1199.05', 'Deliver sustainability training to employees.', 'New', NULL, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('13-2053.00', 'Answer agents'' questions about insurance coverage.', 'New', NULL, 7, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-2021.00', 'Mentor others on mathematical techniques.', 'New', NULL, 6, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('15-2031.00', 'Review research literature.', 'New', NULL, 4, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-1011.00', 'Inspect the condition of structures.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-1021.00', 'Estimate resources, such as production hours, required for projects.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2011.00', 'Develop software for aerospace systems.', 'New', NULL, 6, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2041.00', 'Develop computer models of chemical processes.', 'New', NULL, 4, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2071.00', 'Develop software to control electrical systems.', 'New', NULL, 9, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2081.00', 'Attend professional conferences to share information.', 'New', NULL, 4, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2111.02', 'Review building plans to verify compliance with fire code.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Analyze meteorological data.', 'New', NULL, 7, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Design electrical interconnections.', 'New', NULL, 5, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Design wind turbine components.', 'New', NULL, 7, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-2199.10', 'Estimate energy production by analyzing wind data.', 'New', NULL, 15, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('17-3013.00', 'Create bills of materials.', 'New', NULL, 5, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1021.00', 'Analyze biochemical or biophysical data.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1023.00', 'Conduct literature reviews.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1023.00', 'Develop or make recommendations on management systems and plans for wildlife populations and habitat, consulting with stakeholders and the public at large to explore options.', 'Revision', 1495, 13, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.02', 'Apply herbicide to eliminate harmful plants.', 'New', NULL, 7, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.03', 'Provide care for park program animals.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1031.03', 'Train staff on park programs.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1041.00', 'Write articles for publication in professional journals.', 'New', NULL, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-1041.00', 'Write grant applications for funding epidemiologic research.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2012.00', 'Perform peer reviews of scientific papers.', 'New', NULL, 7, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2041.03', 'Conduct life cycle assessments of products.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-2043.00', 'Prepare reports or presentations describing research results, using illustrations, maps, appendices, and other information.', 'Revision', 18618, 7, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3011.00', 'Review documents written by others.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3041.00', 'Explain sociological research to the general public.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-3041.00', 'Write grants to obtain funding for research projects.', 'New', NULL, 4, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Calibrate, maintain, and repair chemical instrumentation sensing elements and sampling system equipment, using calibration instruments and hand tools.', 'Revision', 7608, 11, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Document results from radiation and contamination surveys.', 'New', NULL, 5, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Inspect, test, and maintain respiratory protection equipment.', 'New', NULL, 9, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4051.02', 'Write radiological work permits.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4061.00', 'Write grant proposals.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4071.00', 'Develop contracts related to operations.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4071.00', 'Monitor environmental conditions such as temperature or humidity.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4071.00', 'Write reports on forestry or conservation activities.', 'New', NULL, 7, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Analyze data from computers or other digital media sources for evidence related to criminal activity.', 'New', NULL, 7, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Analyze DNA data to identify DNA donor profiles.', 'New', NULL, 9, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Examine footwear, tire tracks or other types of impressions.', 'New', NULL, 7, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Examine physical evidence, such as hair, biological fluids, fiber, wood, or soil residues to obtain information about its source and composition.', 'Revision', 1585, 6, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Measure and sketch crime scenes to document evidence.', 'New', NULL, 14, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-4092.00', 'Train others, such as new personnel, on crime scene investigation techniques, including the collection and packaging of evidence.', 'New', NULL, 9, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('19-5011.00', 'Write reports.', 'New', NULL, 4, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1012.00', 'Counsel individuals or groups to help them understand and overcome personal, social, or behavioral problems affecting their educational or vocational situations.', 'Revision', 5605, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1012.00', 'Refer students to outside counseling services.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1013.00', 'Diagnose mental and emotional disorders in clients.', 'New', NULL, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1022.00', 'Conduct psychological assessment of clients.', 'New', NULL, 6, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('21-1093.00', 'Teach parenting techniques to family members.', 'New', NULL, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1011.00', 'Negotiate contractual agreements.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1011.00', 'Work in environmental law, representing the state, federal agencies, public interest groups, waste disposal companies, or construction firms.', 'Revision', 3794, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-1023.00', 'Issue search or arrest warrants.', 'Revision', 21182, 8, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('23-2011.00', 'Prepare, edit, or review legal documents, including legislation, briefs, pleadings, appeals, wills, contracts, and real estate closing statements.', 'Revision', 1634, 6, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1022.00', 'Hire adjunct faculty.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1042.00', 'Write letters of recommendation for students.', 'New', NULL, 10, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1043.00', 'Monitor research program budgets.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1051.00', 'Prepare and deliver lectures to undergraduate or graduate students on topics such as structural geology, micrometeorology, atmospheric thermodynamics, and physics.', 'Revision', 5849, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1054.00', 'Review articles to determine their suitability for publication.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1061.00', 'Hire new faculty.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1066.00', 'Mentor other faculty members.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1067.00', 'Give presentations to community groups.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1067.00', 'Review manuscripts.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1067.00', 'Write letters of recommendation for students.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1081.00', 'Deliver presentations at professional conferences.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1082.00', 'Serve as a mentor.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1121.00', 'Direct theater productions.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1121.00', 'Mentor students.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1125.00', 'Evaluate faculty members.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-1193.00', 'Monitor department budgets.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-2059.01', 'Discuss with education professionals the physical abilities or disabilities of students and the accommodations required to enhance their school performance.', 'Revision', 17015, 8, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-4031.00', 'Open and close the library.', 'New', NULL, 6, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('25-9044.00', 'Correspond with students through email to address their questions and concerns.', 'New', NULL, 8, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1012.00', 'Pack products for shipping.', 'New', NULL, 4, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Prepare digital files for printing.', 'New', NULL, 4, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Research the target audience of projects.', 'New', NULL, 4, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1024.00', 'Write or edit copy for clients.', 'New', NULL, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-1025.00', 'Research health and safety code requirements to inform design.', 'New', NULL, 8, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3041.00', 'Respond to questions from the public.', 'New', NULL, 8, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3041.00', 'Write text, such as headlines, stories, articles, editorials, or newsletters.', 'Revision', 21000, 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3092.00', 'File exhibits.', 'New', NULL, 15, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3092.00', 'Perform secretarial tasks for the court.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-3092.00', 'Swear in witnesses.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-4011.00', 'Purchase audio or video equipment.', 'New', NULL, 7, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-4012.00', 'Develop budgets.', 'New', NULL, 10, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-4021.00', 'Engage in research to learn technological developments and techniques or to develop new photographic procedures and materials.', 'Revision', 9363, 6, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('27-4032.00', 'Write scripts.', 'New', NULL, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1011.00', 'Provide guidance to patients on exercises they can perform to improve mobility.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1011.00', 'Take x-rays.', 'New', NULL, 6, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1022.00', 'Evaluate and treat problems related to the temperomandibular joint (TMJ).', 'New', NULL, 7, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1023.00', 'Advise patients to comply with treatment plans.', 'New', NULL, 13, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1024.00', 'Examine patients to diagnose oral health conditions and diseases.', 'New', NULL, 11, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1071.00', 'Refer patients to other healthcare providers.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1122.00', 'Recommend adaptive equipment to individuals to increase independence in daily living activities.', 'New', NULL, 5, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1126.00', 'Attend high-risk and caesarian section infant deliveries to provide neonatal respiratory care as needed.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1161.00', 'Evaluate mental health of patients.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1161.00', 'Screen patients for gynecologic conditions such as infections.', 'New', NULL, 4, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1211.00', 'Place invasive intravascular monitors into patients.', 'New', NULL, 5, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1211.00', 'Teach anesthesiology principles to residents.', 'New', NULL, 12, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-1223.00', 'Perform mental health evaluations to provide information to courts of law on patients'' mental states.', 'New', NULL, 6, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2012.00', 'Perform quality control analyses to ensure accuracy of test results.', 'New', NULL, 8, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2031.00', 'Perform general administrative tasks, such as answering telephones, scheduling appointments, or ordering supplies or equipment.', 'Revision', 15234, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2033.00', 'Schedule patients for nuclear medicine exams and procedures.', 'New', NULL, 8, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2035.00', 'Comfort patients during exams or request sedatives or other medication from physicians for patients with anxiety or claustrophobia.', 'Revision', 19234, 4, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2035.00', 'Review physicians'' orders to confirm prescribed exams.', 'New', NULL, 5, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2055.00', 'Schedule surgical procedures for patients.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2055.00', 'Transport patients to and from the operating room.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2057.00', 'Order supplies.', 'New', NULL, 4, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-2057.00', 'Perform examinations using ophthalmic equipment, such as autorefractors, phoropters, tomographs, or retinoscopes.', 'Revision', 19250, 4, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9091.00', 'Develop emergency action plans for sports facilities.', 'New', NULL, 5, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('29-9099.01', 'Test patients for sexually transmitted infections.', 'New', NULL, 5, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-1121.00', 'Assist patients with toileting and incontinent care.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-1121.00', 'Feed patients.', 'New', NULL, 6, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-1122.00', 'Administer bedside or personal care, such as assistance with ambulation, dressing, feeding, or personal hygiene.', 'Revision', 2370, 18, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-2012.00', 'Sanitize equipment.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-9093.00', 'Order medical supplies for healthcare facilities or laboratories.', 'New', NULL, 6, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('31-9097.00', 'Confirm the identities of patients by verifying their personal information.', 'New', NULL, 4, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3012.00', 'Take fingerprints of arrestees, prisoners, or the general public.', 'New', NULL, 9, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.02', 'Take fingerprints.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3021.06', 'Identify gaps in information.', 'New', NULL, 4, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-3041.00', 'Perform traffic control duties such as setting up barricades and temporary signs, placing bags on parking meters to limit their use, or directing traffic or pedestrians.', 'Revision', 7949, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('33-9021.00', 'Serve documents to parties named in legal proceedings.', 'New', NULL, 5, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-2011.00', 'Take out garbage.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-3011.00', 'Provide customers with directions or answers to questions.', 'New', NULL, 18, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('35-9011.00', 'Prepare food, such as sandwiches, for customers.', 'New', NULL, 9, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-1012.00', 'Repair irrigation systems.', 'New', NULL, 7, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3011.00', 'Move furniture.', 'New', NULL, 8, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3012.00', 'Establish driving routes for pesticide applications.', 'New', NULL, 7, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('37-3012.00', 'Record information about pesticide applications, such as the type used and amount applied.', 'New', NULL, 9, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2011.00', 'Teach owners how to train their dogs.', 'New', NULL, 13, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2011.00', 'Teach people with visual impairments to use guide dogs.', 'New', NULL, 22, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2021.00', 'Scuba dive in aquariums to perform exhibit maintenance.', 'New', NULL, 6, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-2021.00', 'Train volunteers and facility staff.', 'New', NULL, 9, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3012.00', 'Provide race or game information to patrons.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3012.00', 'Serve drinks to patrons.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3021.00', 'Download digital keys to unlock digital movie files.', 'New', NULL, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3021.00', 'Ingest digital content, such as films, advertisements, or trailers, into servers or projectors.', 'New', NULL, 8, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3092.00', 'Create patterns for costumes based on designer''s drawings.', 'New', NULL, 12, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3092.00', 'Schedule costume fittings for actors.', 'New', NULL, 7, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-3093.00', 'Maintain or repair athletic equipment.', 'New', NULL, 5, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5091.00', 'Clean supplies such as makeup brushes.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Assist hair stylists with chemical services, such as neutralizing perms and applying hair color.', 'New', NULL, 7, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Launder and fold the towels that are used for drying customers'' hair.', 'New', NULL, 11, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Refill and stock work stations with supplies, such as shampoos and conditioners.', 'New', NULL, 7, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Rinse out hair color or permanent solutions from customers'' hair.', 'New', NULL, 10, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-5093.00', 'Sweep hair from the salon floor.', 'New', NULL, 7, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-6012.00', 'Assist guests with special needs by providing equipment such as wheelchairs.', 'New', NULL, 5, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-6012.00', 'Book airline or train tickets, reserve rental cars, or arrange shuttle service for guests.', 'New', NULL, 22, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('39-9041.00', 'Advise student organizations.', 'New', NULL, 5, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-9091.00', 'Contact customers to ensure their satisfaction with products or services.', 'New', NULL, 5, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('41-9091.00', 'Train new recruits or other employees.', 'New', NULL, 7, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4121.00', 'Hire library staff such as student assistants.', 'New', NULL, 26, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-4171.00', 'Enter and update databases of contact information, such as names, addresses, and phone numbers.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5041.00', 'Dig dirt away from meters to take readings.', 'New', NULL, 10, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5041.00', 'Install new or replace broken meters.', 'New', NULL, 14, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-5051.00', 'Stock lobby with retail merchandise.', 'New', NULL, 7, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-6011.00', 'Keep track of employees'' time.', 'New', NULL, 5, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9081.00', 'Check the facts of stories using the internet.', 'New', NULL, 8, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9081.00', 'Design page layouts using text, photographs, graphics, and other elements.', 'New', NULL, 11, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9111.00', 'Present results of statistical analyses to stakeholders.', 'New', NULL, 10, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('43-9111.00', 'Write code for statistical applications.', 'New', NULL, 7, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-4011.00', 'Create field maps using geographic information systems technology.', 'New', NULL, 10, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('45-4023.00', 'Move logs using heavy equipment such as log loaders.', 'New', NULL, 7, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2011.00', 'Conduct pressure tests on vessels, such as boilers.', 'New', NULL, 7, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2041.00', 'Cut and install vinyl composition tile or vinyl base.', 'New', NULL, 13, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2141.00', 'Clean tools and equipment, such as brushes and rollers.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2141.00', 'Hang wallpaper.', 'New', NULL, 7, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2171.00', 'Unload rebar from trucks.', 'New', NULL, 5, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2171.00', 'Use forklifts or cranes to move construction material, such as rebar.', 'New', NULL, 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2221.00', 'Assemble or inspect hoisting equipment or rigging, such as cables, pulleys, or hooks, to move heavy equipment or materials.', 'Revision', 11554, 5, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-2221.00', 'Lift steel beams, girders, or columns using cranes or forklifts, or by signaling hoisting equipment operators to lift or position structural steel members.', 'Revision', 20795, 10, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-3012.00', 'Cut or weld metal.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-3013.00', 'Operate heavy equipment, such as backhoes.', 'New', NULL, 7, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-4011.01', 'Evaluate the energy performance of buildings using modeling software.', 'New', NULL, 4, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-4071.00', 'Pump, clean, and repair septic tanks, sewer lines, or related structures such as manholes, culverts, and catch basins.', 'Revision', 11610, 5, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5013.00', 'Maintain and perform safety inspections on rigs, equipment, and other tools.', 'Revision', 20451, 7, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5043.00', 'Check roof or ribs for hazardous conditions.', 'New', NULL, 10, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5043.00', 'Clean equipment, such as dust collectors.', 'New', NULL, 7, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5071.00', 'Clean trucks used in the fields.', 'New', NULL, 5, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('47-5071.00', 'Lay gas and oil pipelines.', 'New', NULL, 5, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-2095.00', 'Calibrate instruments, such as transmitters.', 'New', NULL, 6, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3051.00', 'Explain repair procedures to customers.', 'New', NULL, 6, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3051.00', 'Repair or replace engine mechanical equipment, such as power tilts, water pumps, bilge pumps, or power take-offs.', 'Revision', 13770, 5, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3052.00', 'Diagnose electrical problems.', 'New', NULL, 9, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3091.00', 'Estimate costs of repairing bicycles and write service tickets.', 'New', NULL, 6, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-3091.00', 'Make adjustments to bicycles to improve customer fit and riding position.', 'New', NULL, 7, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9045.00', 'Reline furnaces using ramming material.', 'New', NULL, 8, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9052.00', 'Set up service for customers, installing, connecting, testing, or adjusting equipment, such as digital subscriber line modems.', 'Revision', 11850, 8, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9061.00', 'Adjust or repair cameras, photographic mechanisms, or equipment such as range and view finders, shutters, light meters, or lens systems, using hand tools.', 'Revision', 8437, 15, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9062.00', 'Inspect, test, or troubleshoot malfunctioning medical or related equipment, following manufacturers'' specifications and using test and analysis instruments.', 'Revision', 3061, 9, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('49-9062.00', 'Install medical equipment.', 'New', NULL, 6, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-3021.00', 'Clean and sanitize meat cases and cutting equipment.', 'New', NULL, 15, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-3022.00', 'Clean meat cutting equipment.', 'New', NULL, 11, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4031.00', 'Use equipment designed to join sheet metal, such as spot welders.', 'New', NULL, 6, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4034.00', 'Clean work area.', 'New', NULL, 14, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4034.00', 'Program computer numerical control machines.', 'New', NULL, 5, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-4111.00', 'Troubleshoot malfunctions in manufacturing equipment.', 'New', NULL, 6, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-5111.00', 'Correct color in photographs or digital images.', 'New', NULL, 7, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6042.00', 'Inspect finished products to ensure that shoes have been completed according to specifications.', 'New', NULL, 6, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6051.00', 'Fit garments on clients, altering as needed.', 'New', NULL, 8, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-6061.00', 'Weigh ingredients, such as dye, to be mixed together for use in textile processing.', 'Revision', 14135, 5, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9011.00', 'Load products into tanks for shipment.', 'New', NULL, 5, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9023.00', 'Clean work areas.', 'New', NULL, 9, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9081.00', 'Meet with dentists or patients to discuss dental appliances.', 'New', NULL, 6, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9081.00', 'Order parts or materials needed to make dental appliances.', 'New', NULL, 6, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9081.00', 'Scan dental models to create digital files.', 'New', NULL, 10, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9081.00', 'Stain porcelain on dental appliances to match the color of patients'' teeth.', 'New', NULL, 7, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9082.00', 'Order parts or supplies for orthotic or prosthetic devices.', 'New', NULL, 8, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9083.00', 'Tint lenses according to customer specifications.', 'New', NULL, 6, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9151.00', 'Adjust digital images using software.', 'New', NULL, 10, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9162.00', 'Order tooling for jobs.', 'New', NULL, 8, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Apply glazes to pottery pieces, using tools such as spray guns.', 'Revision', 21211, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Decorate pottery using tools such as brushes.', 'New', NULL, 8, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Load and unload pottery from kilns.', 'New', NULL, 10, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('51-9195.05', 'Mix chemicals according to recipes to create glazes.', 'Revision', 21211, 6, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2021.00', 'Monitor, direct, or sequence the movement of aircraft within an assigned air space or on the ground at airports to minimize delays and maximize safety.', 'Revision', 12729, 5, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Inspect airfield conditions to ensure safety and compliance with federal regulatory requirements.', 'Revision', 23939, 22, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Issue notices to advise flight crews of airfield status.', 'New', NULL, 6, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-2022.00', 'Train operations staff on topics such as driving on airfields and security identification display area (SIDA) procedures.', 'Revision', 10618, 7, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7021.00', 'Inspect crane site conditions to determine ground stability.', 'New', NULL, 6, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7031.00', 'Perform maintenance on dredge equipment, such as changing engine oil.', 'New', NULL, 6, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7062.00', 'Check freight, stock, or other materials for damage.', 'New', NULL, 6, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO emerging_tasks (onetsoc_code, task, category, original_task_id, writein_total, date_updated, domain_source) VALUES ('53-7062.00', 'Take inventory of freight, stock, or other materials used on site.', 'New', NULL, 5, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');

