CREATE TABLE task_ratings (
  onetsoc_code CHARACTER(10) NOT NULL,
  task_id DECIMAL(8,0) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (task_id) REFERENCES task_statements(task_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (scale_id, category) REFERENCES task_categories(scale_id, category));

INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 1, 4.34, 79, 2.48, 1.36, 12.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 2, 9.16, 79, 3.86, 3.86, 20.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 3, 11.04, 79, 3.44, 5.82, 19.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 4, 16.19, 79, 4.37, 9.24, 26.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 5, 46.67, 79, 6.03, 35.07, 58.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 6, 7.33, 79, 3.40, 2.83, 17.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'FT', 7, 5.26, 79, 4.30, 0.99, 23.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'IM', NULL, 4.54, 78, 0.08, 4.38, 4.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'RT', NULL, 94.19, 87, 3.35, 82.75, 98.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 1, 12.96, 83, 3.77, 7.12, 22.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 2, 16.77, 83, 4.67, 9.38, 28.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 3, 15.16, 83, 4.46, 8.22, 26.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 4, 15.18, 83, 4.41, 8.30, 26.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 5, 23.95, 83, 5.84, 14.27, 37.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 6, 15.36, 83, 5.37, 7.39, 29.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'FT', 7, 0.63, 83, 0.64, 0.08, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'IM', NULL, 4.48, 82, 0.08, 4.31, 4.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'RT', NULL, 94.26, 87, 4.36, 76.81, 98.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 1, 0.00, 87, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 2, 19.04, 87, 5.69, 10.15, 32.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 3, 12.61, 87, 3.81, 6.76, 22.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 4, 18.96, 87, 4.97, 10.96, 30.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 5, 35.11, 87, 5.96, 24.34, 47.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 6, 10.56, 87, 3.79, 5.05, 20.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'FT', 7, 3.73, 87, 2.03, 1.24, 10.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'IM', NULL, 4.40, 86, 0.10, 4.21, 4.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'RT', NULL, 100.00, 87, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 1, 3.17, 84, 2.97, 0.48, 18.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 2, 9.27, 84, 3.97, 3.84, 20.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 3, 10.18, 84, 3.85, 4.68, 20.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 4, 23.83, 84, 6.25, 13.63, 38.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 5, 38.47, 84, 8.10, 24.04, 55.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 6, 8.70, 84, 3.65, 3.68, 19.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'FT', 7, 6.38, 84, 4.33, 1.58, 22.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'IM', NULL, 4.39, 84, 0.07, 4.24, 4.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'RT', NULL, 95.84, 87, 2.42, 87.35, 98.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 1, 24.24, 77, 5.84, 14.52, 37.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 2, 38.58, 77, 6.88, 26.05, 52.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 3, 18.43, 77, 5.57, 9.75, 32.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 4, 10.23, 77, 4.16, 4.42, 21.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 5, 7.87, 77, 3.45, 3.20, 18.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 6, 0.00, 77, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'FT', 7, 0.65, 77, 0.66, 0.09, 4.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'IM', NULL, 4.17, 76, 0.12, 3.93, 4.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'RT', NULL, 90.47, 87, 3.71, 80.13, 95.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 1, 1.59, 85, 1.49, 0.24, 9.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 2, 11.14, 85, 3.73, 5.60, 20.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 3, 27.41, 85, 6.06, 17.09, 40.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 4, 15.58, 85, 4.26, 8.84, 25.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 5, 25.27, 85, 6.81, 14.17, 40.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 6, 14.21, 85, 5.13, 6.69, 27.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'FT', 7, 4.81, 85, 3.46, 1.11, 18.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'IM', NULL, 4.15, 86, 0.14, 3.88, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'RT', NULL, 98.79, 87, 1.22, 91.48, 99.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 1, 4.23, 85, 2.20, 1.47, 11.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 2, 28.68, 85, 7.08, 16.81, 44.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 3, 31.18, 85, 5.50, 21.39, 43.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 4, 15.91, 85, 5.32, 7.90, 29.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 5, 17.31, 85, 5.19, 9.24, 30.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 6, 2.08, 85, 1.58, 0.45, 9.02, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'FT', 7, 0.60, 85, 0.61, 0.08, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'IM', NULL, 4.12, 85, 0.09, 3.94, 4.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'RT', NULL, 97.56, 87, 2.29, 85.54, 99.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 1, 14.66, 68, 7.65, 4.83, 36.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 2, 21.73, 68, 6.02, 12.05, 36.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 3, 28.95, 68, 6.30, 18.11, 42.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 4, 15.88, 68, 5.97, 7.19, 31.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 5, 8.27, 68, 3.94, 3.10, 20.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 6, 5.56, 68, 5.04, 0.86, 28.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'FT', 7, 4.94, 68, 4.07, 0.91, 22.67, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'IM', NULL, 4.02, 68, 0.13, 3.76, 4.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'RT', NULL, 78.78, 86, 5.68, 65.39, 87.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 1, 0.80, 76, 0.49, 0.24, 2.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 2, 36.06, 76, 5.74, 25.57, 48.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 3, 23.82, 76, 6.70, 13.03, 39.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 4, 19.72, 76, 5.88, 10.48, 33.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 5, 14.05, 76, 4.35, 7.39, 25.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 6, 5.55, 76, 3.99, 1.27, 21.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'FT', 7, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'IM', NULL, 3.96, 76, 0.12, 3.73, 4.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'RT', NULL, 84.86, 86, 5.50, 70.54, 92.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 1, 5.93, 65, 3.04, 2.08, 15.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 2, 31.14, 65, 7.78, 17.97, 48.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 3, 42.95, 65, 9.25, 26.15, 61.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 4, 12.69, 65, 4.83, 5.73, 25.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 5, 4.28, 65, 2.74, 1.16, 14.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 6, 3.02, 65, 2.30, 0.64, 12.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'FT', 7, 0.00, 65, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'IM', NULL, 3.96, 65, 0.11, 3.73, 4.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'RT', NULL, 72.72, 87, 5.75, 59.96, 82.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 1, 3.98, 72, 3.31, 0.73, 18.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 2, 23.93, 72, 6.98, 12.78, 40.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 3, 34.72, 72, 7.61, 21.40, 50.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 4, 19.51, 72, 6.82, 9.25, 36.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 5, 14.50, 72, 5.45, 6.59, 28.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 6, 2.68, 72, 1.90, 0.64, 10.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'FT', 7, 0.68, 72, 0.69, 0.09, 4.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'IM', NULL, 3.95, 72, 0.10, 3.75, 4.16, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'RT', NULL, 87.10, 87, 4.27, 76.02, 93.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 1, 7.89, 65, 3.36, 3.29, 17.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 2, 30.58, 65, 7.03, 18.52, 46.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 3, 26.86, 65, 8.67, 13.20, 47.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 4, 10.74, 65, 4.08, 4.89, 21.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 5, 23.18, 65, 6.02, 13.31, 37.21, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 6, 0.00, 65, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'FT', 7, 0.76, 65, 0.77, 0.10, 5.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'IM', NULL, 3.87, 66, 0.09, 3.69, 4.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'RT', NULL, 78.35, 87, 6.55, 62.68, 88.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 1, 1.86, 86, 1.86, 0.25, 12.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 2, 10.47, 86, 3.72, 5.04, 20.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 3, 33.75, 86, 8.45, 19.38, 51.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 4, 23.93, 86, 5.31, 14.98, 35.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 5, 26.31, 86, 5.58, 16.77, 38.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 6, 3.08, 86, 1.79, 0.95, 9.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'FT', 7, 0.60, 86, 0.61, 0.08, 4.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'IM', NULL, 3.82, 86, 0.13, 3.57, 4.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'RT', NULL, 98.87, 87, 1.12, 92.25, 99.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 1, 16.38, 72, 5.13, 8.49, 29.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 2, 33.48, 72, 9.29, 17.96, 53.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 3, 23.60, 72, 5.85, 13.92, 37.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 4, 16.26, 72, 5.47, 8.02, 30.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 5, 8.51, 72, 4.25, 3.04, 21.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 6, 1.76, 72, 1.78, 0.23, 12.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'FT', 7, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'IM', NULL, 3.73, 71, 0.14, 3.45, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'RT', NULL, 85.82, 87, 4.54, 74.24, 92.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 1, 5.51, 72, 3.61, 1.44, 18.88, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 2, 28.39, 72, 5.71, 18.46, 40.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 3, 16.70, 72, 5.29, 8.59, 29.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 4, 28.19, 72, 6.62, 16.98, 42.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 5, 10.86, 72, 4.81, 4.32, 24.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 6, 9.64, 72, 5.59, 2.88, 27.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'FT', 7, 0.70, 72, 0.71, 0.09, 5.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'IM', NULL, 3.69, 72, 0.14, 3.42, 3.96, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'RT', NULL, 83.82, 87, 5.83, 68.78, 92.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 1, 10.60, 66, 4.98, 3.98, 25.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 2, 38.78, 66, 6.22, 27.30, 51.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 3, 28.91, 66, 8.21, 15.47, 47.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 4, 17.34, 66, 5.89, 8.46, 32.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 5, 1.43, 66, 1.43, 0.19, 9.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 6, 2.94, 66, 2.12, 0.68, 11.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'FT', 7, 0.00, 66, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'IM', NULL, 3.65, 66, 0.14, 3.36, 3.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'RT', NULL, 81.80, 86, 4.81, 70.28, 89.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 1, 8.52, 60, 3.68, 3.49, 19.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 2, 34.04, 60, 8.57, 19.38, 52.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 3, 34.66, 60, 9.24, 19.00, 54.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 4, 11.39, 60, 5.18, 4.40, 26.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 5, 4.74, 60, 3.24, 1.17, 17.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 6, 5.84, 60, 4.02, 1.41, 21.13, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'FT', 7, 0.81, 60, 0.82, 0.10, 5.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'IM', NULL, 3.64, 60, 0.15, 3.33, 3.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'RT', NULL, 73.15, 87, 6.14, 59.40, 83.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 1, 27.40, 63, 6.81, 15.99, 42.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 2, 24.79, 63, 7.31, 13.08, 41.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 3, 20.12, 63, 5.94, 10.74, 34.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 4, 6.56, 63, 3.15, 2.45, 16.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 5, 17.05, 63, 6.26, 7.82, 33.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 6, 1.61, 63, 1.61, 0.21, 11.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'FT', 7, 2.48, 63, 1.84, 0.56, 10.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'IM', NULL, 3.62, 63, 0.15, 3.32, 3.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'RT', NULL, 70.20, 87, 7.33, 54.00, 82.53, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 1, 22.51, 63, 6.55, 12.06, 38.10, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 2, 37.62, 63, 6.93, 25.04, 52.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 3, 30.50, 63, 7.66, 17.57, 47.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 4, 3.80, 63, 2.18, 1.19, 11.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 5, 4.58, 63, 4.25, 0.68, 25.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 6, 0.20, 63, 0.21, 0.03, 1.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'FT', 7, 0.79, 63, 0.80, 0.10, 5.80, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'IM', NULL, 3.33, 63, 0.15, 3.03, 3.63, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'RT', NULL, 75.11, 87, 5.23, 63.36, 84.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 1, 2.27, 58, 1.40, 0.66, 7.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 2, 3.09, 58, 3.06, 0.41, 19.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 3, 11.19, 58, 4.22, 5.11, 22.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 4, 18.37, 58, 6.65, 8.48, 35.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 5, 35.74, 58, 8.38, 21.12, 53.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 6, 8.07, 58, 4.27, 2.70, 21.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'FT', 7, 21.27, 58, 7.71, 9.71, 40.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'IM', NULL, 4.25, 58, 0.16, 3.93, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'RT', NULL, 59.37, 87, 9.15, 40.74, 75.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 1, 20.38, 23, 8.92, 7.56, 44.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 2, 64.37, 23, 12.74, 36.35, 85.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 3, 11.89, 23, 8.41, 2.49, 41.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 4, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 5, 3.36, 23, 3.44, 0.38, 23.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 6, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'FT', 7, 0.00, 23, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'IM', NULL, 3.93, 23, 0.24, 3.42, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'RT', NULL, 37.30, 87, 8.18, 22.88, 54.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 1, 21.34, 31, 8.38, 8.91, 42.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 2, 31.81, 31, 9.49, 16.03, 53.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 3, 37.97, 31, 10.34, 19.98, 60.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 4, 6.29, 31, 4.18, 1.55, 22.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 5, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 6, 2.60, 31, 2.64, 0.32, 18.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'FT', 7, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'IM', NULL, 3.92, 31, 0.22, 3.47, 4.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'RT', NULL, 46.48, 87, 7.71, 31.94, 61.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 1, 28.11, 35, 8.35, 14.45, 47.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 2, 31.45, 35, 10.05, 15.10, 54.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 3, 14.68, 35, 6.02, 6.08, 31.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 4, 4.17, 35, 3.63, 0.69, 21.56, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 5, 12.68, 35, 6.42, 4.27, 32.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 6, 7.45, 35, 4.71, 1.97, 24.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'FT', 7, 1.47, 35, 1.48, 0.18, 10.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'IM', NULL, 3.86, 35, 0.23, 3.38, 4.34, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'RT', NULL, 40.27, 87, 6.13, 28.88, 52.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 1, 23.63, 32, 9.18, 9.89, 46.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 2, 36.01, 32, 7.20, 22.94, 51.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 3, 29.19, 32, 7.21, 16.83, 45.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 4, 7.58, 32, 5.08, 1.83, 26.49, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 5, 0.87, 32, 0.91, 0.10, 6.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 6, 2.71, 32, 2.77, 0.33, 19.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'FT', 7, 0.00, 32, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'IM', NULL, 3.75, 32, 0.18, 3.38, 4.12, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'RT', NULL, 44.53, 87, 8.59, 28.67, 61.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 1, 6.54, 48, 3.62, 2.08, 18.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 2, 15.30, 48, 6.14, 6.51, 31.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 3, 32.80, 48, 7.31, 20.04, 48.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 4, 12.45, 48, 5.41, 4.98, 27.85, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 5, 29.57, 48, 6.53, 18.27, 44.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 6, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'FT', 7, 3.33, 48, 2.53, 0.71, 14.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'IM', NULL, 3.74, 48, 0.13, 3.47, 4.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'RT', NULL, 52.49, 87, 7.17, 38.42, 66.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 1, 46.77, 36, 11.64, 25.38, 69.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 2, 25.58, 36, 7.92, 12.87, 44.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 3, 4.05, 36, 3.64, 0.62, 22.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 4, 10.86, 36, 7.99, 2.23, 39.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 5, 11.35, 36, 5.09, 4.39, 26.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 6, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'FT', 7, 1.40, 36, 1.42, 0.17, 10.29, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'IM', NULL, 3.63, 36, 0.29, 3.04, 4.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'RT', NULL, 43.12, 86, 6.58, 30.79, 56.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 1, 2.04, 42, 2.06, 0.26, 14.31, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 2, 45.99, 42, 8.14, 30.52, 62.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 3, 34.81, 42, 7.80, 21.06, 51.67, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 4, 13.50, 42, 6.12, 5.14, 31.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 5, 2.48, 42, 2.19, 0.40, 13.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 6, 1.18, 42, 1.19, 0.15, 8.64, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'FT', 7, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'IM', NULL, 3.56, 42, 0.15, 3.26, 3.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'RT', NULL, 56.76, 87, 7.25, 42.19, 70.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 1, 19.24, 36, 7.48, 8.23, 38.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 2, 29.55, 36, 7.29, 17.08, 46.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 3, 41.61, 36, 8.63, 25.74, 59.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 4, 6.94, 36, 5.09, 1.48, 26.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 5, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 6, 2.67, 36, 2.69, 0.33, 18.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'FT', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'IM', NULL, 3.37, 36, 0.19, 2.97, 3.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'RT', NULL, 45.98, 86, 7.93, 31.09, 61.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 1, 15.88, 50, 6.83, 6.33, 34.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 2, 46.33, 50, 6.82, 33.22, 59.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 3, 30.26, 50, 7.50, 17.53, 46.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 4, 5.54, 50, 3.94, 1.27, 21.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 5, 2.00, 50, 2.03, 0.25, 14.06, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'FT', 7, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'IM', NULL, 3.33, 50, 0.22, 2.88, 3.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'RT', NULL, 60.60, 86, 7.15, 45.89, 73.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 1, 24.80, 50, 7.83, 12.42, 43.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 2, 36.86, 50, 8.41, 22.02, 54.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 3, 29.12, 50, 7.29, 16.80, 45.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 4, 6.02, 50, 3.57, 1.77, 18.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 5, 1.05, 50, 1.06, 0.14, 7.62, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 6, 2.15, 50, 2.17, 0.28, 14.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'FT', 7, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'IM', NULL, 3.11, 50, 0.18, 2.74, 3.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'RT', NULL, 56.16, 87, 7.18, 41.78, 69.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 1, 50.29, 18, 14.65, 22.72, 77.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 2, 33.59, 18, 14.53, 11.35, 66.65, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 3, 11.63, 18, 8.43, 2.28, 42.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 4, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 5, 4.48, 18, 4.49, 0.51, 30.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 6, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'FT', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'IM', NULL, 2.81, 18, 0.19, 2.41, 3.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'RT', NULL, 26.95, 87, 4.74, 18.61, 37.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 1, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 2, 26.92, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 3, 38.46, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 4, 23.08, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 5, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 6, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'IM', NULL, 4.38, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'RT', NULL, 96.30, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 2, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 3, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 4, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 5, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 6, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'IM', NULL, 4.37, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 2, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 3, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 4, 33.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 5, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'IM', NULL, 4.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 2, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 3, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 5, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 6, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'FT', 7, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'IM', NULL, 4.22, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 2, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 3, 48.15, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'IM', NULL, 4.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 3, 51.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 4, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 5, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'IM', NULL, 3.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 1, 3.85, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 2, 46.15, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 3, 30.77, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 4, 11.54, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 5, 7.69, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 6, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'FT', 7, 0.00, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'IM', NULL, 3.88, 26, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'RT', NULL, 96.30, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 1, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 2, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 3, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 4, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'IM', NULL, 3.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 2, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 3, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 6, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'IM', NULL, 3.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 1, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 2, 25.93, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 3, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 4, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 5, 14.81, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 6, 7.41, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'IM', NULL, 3.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 1, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 2, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 3, 26.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'IM', NULL, 3.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'RT', NULL, 85.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 3, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'IM', NULL, 3.52, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'RT', NULL, 92.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 1, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 2, 29.63, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 3, 40.74, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'IM', NULL, 3.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 1, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 2, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 3, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 4, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 5, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'IM', NULL, 3.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'RT', NULL, 92.59, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 1, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 2, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 3, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 4, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'IM', NULL, 3.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'RT', NULL, 88.89, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 1, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 2, 51.85, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 3, 18.52, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 4, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 5, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'IM', NULL, 3.33, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 1, 11.11, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 2, 37.04, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 3, 44.44, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 4, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 5, 3.70, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 6, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'FT', 7, 0.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'IM', NULL, 3.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'RT', NULL, 100.00, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 1, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 2, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 3, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 4, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 5, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'IM', NULL, 3.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'RT', NULL, 85.19, 27, NULL, NULL, NULL, NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 1, 0.00, 147, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 2, 3.19, 147, 1.31, 1.41, 7.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 3, 20.90, 147, 5.81, 11.66, 34.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 4, 21.28, 147, 5.50, 12.37, 34.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 5, 36.99, 147, 5.51, 26.89, 48.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 6, 8.87, 147, 3.01, 4.46, 16.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'FT', 7, 8.78, 147, 3.80, 3.63, 19.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'IM', NULL, 4.09, 151, 0.09, 3.91, 4.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'RT', NULL, 95.28, 157, 2.50, 87.07, 98.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 1, 0.70, 134, 0.69, 0.10, 4.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 2, 2.17, 134, 1.31, 0.65, 7.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 3, 6.27, 134, 2.63, 2.69, 13.95, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 4, 10.30, 134, 4.05, 4.60, 21.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 5, 42.15, 134, 7.14, 28.99, 56.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 6, 25.54, 134, 5.14, 16.73, 36.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'FT', 7, 12.87, 134, 4.90, 5.86, 25.96, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'IM', NULL, 4.04, 137, 0.14, 3.77, 4.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 933, 'RT', NULL, 84.65, 157, 3.05, 77.61, 89.77, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 1, 0.00, 137, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 2, 1.74, 137, 1.57, 0.29, 9.86, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 3, 5.87, 137, 3.09, 2.03, 15.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 4, 8.23, 137, 3.22, 3.71, 17.24, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 5, 41.08, 137, 7.21, 27.90, 55.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 6, 26.16, 137, 5.80, 16.37, 39.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'FT', 7, 16.92, 137, 4.55, 9.69, 27.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'IM', NULL, 4.00, 140, 0.10, 3.79, 4.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'RT', NULL, 88.88, 156, 3.81, 78.87, 94.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 1, 2.20, 148, 2.13, 0.32, 13.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 2, 0.40, 148, 0.23, 0.13, 1.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 3, 20.64, 148, 4.34, 13.35, 30.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 4, 17.01, 148, 4.35, 10.03, 27.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 5, 40.80, 148, 5.46, 30.60, 51.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 6, 12.46, 148, 4.12, 6.33, 23.09, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'FT', 7, 6.48, 148, 2.54, 2.94, 13.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'IM', NULL, 3.93, 150, 0.12, 3.68, 4.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'RT', NULL, 96.78, 158, 2.08, 88.94, 99.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 1, 0.24, 119, 0.24, 0.03, 1.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 2, 14.42, 119, 3.92, 8.24, 24.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 3, 18.18, 119, 4.63, 10.72, 29.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 4, 18.39, 119, 5.22, 10.16, 30.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 5, 43.92, 119, 6.15, 32.32, 56.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 6, 4.84, 119, 2.44, 1.75, 12.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'FT', 7, 0.00, 119, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'IM', NULL, 3.89, 120, 0.13, 3.64, 4.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'RT', NULL, 77.15, 157, 5.95, 63.40, 86.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 1, 4.64, 126, 2.54, 1.53, 13.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 2, 20.77, 126, 6.31, 10.93, 35.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 3, 12.05, 126, 3.02, 7.23, 19.41, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 4, 29.63, 126, 6.27, 18.85, 43.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 5, 24.66, 126, 5.96, 14.78, 38.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 6, 7.58, 126, 2.97, 3.43, 15.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'FT', 7, 0.68, 126, 0.51, 0.15, 2.95, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'IM', NULL, 3.84, 129, 0.11, 3.63, 4.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'RT', NULL, 80.80, 157, 4.06, 71.51, 87.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 1, 7.99, 141, 4.94, 2.25, 24.69, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 2, 16.11, 141, 4.28, 9.31, 26.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 3, 33.56, 141, 5.60, 23.51, 45.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 4, 13.00, 141, 3.27, 7.77, 20.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 5, 21.96, 141, 5.00, 13.65, 33.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 6, 4.77, 141, 2.17, 1.91, 11.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'FT', 7, 2.61, 141, 1.82, 0.65, 9.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'IM', NULL, 3.75, 142, 0.13, 3.49, 4.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'RT', NULL, 92.91, 157, 3.09, 83.86, 97.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 1, 6.35, 147, 2.79, 2.62, 14.61, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 2, 30.67, 147, 4.79, 22.08, 40.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 3, 28.71, 147, 4.88, 20.09, 39.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 4, 16.67, 147, 4.71, 9.29, 28.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 5, 15.42, 147, 3.45, 9.76, 23.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 6, 0.14, 147, 0.14, 0.02, 1.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'FT', 7, 2.03, 147, 1.68, 0.39, 9.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'IM', NULL, 3.73, 151, 0.09, 3.56, 3.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'RT', NULL, 93.60, 158, 2.97, 84.59, 97.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 1, 12.23, 108, 4.04, 6.20, 22.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 2, 19.49, 108, 5.28, 11.05, 32.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 3, 26.41, 108, 6.73, 15.30, 41.63, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 4, 16.31, 108, 3.83, 10.05, 25.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 5, 21.53, 108, 4.14, 14.44, 30.85, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 6, 3.84, 108, 2.82, 0.87, 15.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'FT', 7, 0.18, 108, 0.18, 0.02, 1.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'IM', NULL, 3.51, 109, 0.12, 3.26, 3.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'RT', NULL, 73.46, 158, 5.68, 60.90, 83.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 1, 7.77, 82, 4.10, 2.63, 20.82, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 2, 19.67, 82, 5.29, 11.17, 32.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 3, 21.59, 82, 7.14, 10.64, 38.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 4, 20.15, 82, 6.40, 10.26, 35.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 5, 22.51, 82, 6.85, 11.74, 38.82, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 6, 8.07, 82, 4.15, 2.80, 21.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'FT', 7, 0.22, 82, 0.23, 0.03, 1.66, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'IM', NULL, 3.93, 84, 0.13, 3.68, 4.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'RT', NULL, 48.48, 158, 5.97, 36.97, 60.14, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 1, 1.99, 92, 1.45, 0.46, 8.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 2, 0.92, 92, 0.65, 0.23, 3.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 3, 18.15, 92, 5.88, 9.18, 32.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 4, 28.97, 92, 8.30, 15.47, 47.62, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 5, 32.54, 92, 7.28, 19.97, 48.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 6, 15.52, 92, 5.49, 7.41, 29.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'FT', 7, 1.90, 92, 1.07, 0.62, 5.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'IM', NULL, 3.83, 96, 0.15, 3.53, 4.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'RT', NULL, 53.53, 158, 6.14, 41.44, 65.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 1, 8.49, 86, 4.07, 3.17, 20.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 2, 10.14, 86, 3.99, 4.51, 21.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 3, 16.55, 86, 5.24, 8.53, 29.66, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 4, 12.11, 86, 4.79, 5.33, 25.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 5, 17.64, 86, 5.53, 9.13, 31.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 6, 8.76, 86, 4.54, 3.01, 22.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'FT', 7, 26.32, 86, 9.54, 11.84, 48.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'IM', NULL, 3.82, 88, 0.17, 3.49, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 944, 'RT', NULL, 58.83, 158, 6.75, 45.17, 71.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 1, 16.65, 68, 7.37, 6.47, 36.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 2, 21.77, 68, 7.57, 10.29, 40.32, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 3, 31.87, 68, 7.82, 18.56, 48.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 4, 11.33, 68, 5.41, 4.18, 27.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 5, 10.40, 68, 4.46, 4.28, 23.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 6, 7.97, 68, 4.18, 2.71, 21.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'IM', NULL, 3.34, 70, 0.18, 2.98, 3.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 945, 'RT', NULL, 45.75, 158, 6.91, 32.74, 59.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 1, 42.80, 73, 8.61, 27.08, 60.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 2, 37.30, 73, 7.74, 23.52, 53.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 3, 8.47, 73, 3.63, 3.51, 19.05, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 4, 7.72, 73, 4.09, 2.60, 20.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 5, 3.70, 73, 3.35, 0.59, 20.04, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 6, 0.00, 73, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'FT', 7, 0.00, 73, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'IM', NULL, 3.28, 74, 0.15, 2.97, 3.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 948, 'RT', NULL, 39.91, 158, 5.16, 30.28, 50.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 1, 12.78, 88, 4.61, 6.05, 25.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 2, 34.20, 88, 8.33, 19.94, 52.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 3, 20.93, 88, 5.58, 11.92, 34.10, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 4, 9.99, 88, 4.88, 3.64, 24.61, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 5, 19.51, 88, 5.35, 10.97, 32.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 6, 1.30, 88, 1.27, 0.18, 8.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'FT', 7, 1.30, 88, 1.27, 0.18, 8.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'IM', NULL, 3.25, 92, 0.16, 2.94, 3.57, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'RT', NULL, 52.57, 157, 6.48, 39.88, 64.94, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 1, 3.74, 63, 1.83, 1.38, 9.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 2, 21.13, 63, 6.49, 10.96, 36.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 3, 29.95, 63, 9.44, 14.82, 51.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 4, 26.98, 63, 8.35, 13.67, 46.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 5, 17.30, 63, 7.16, 7.14, 36.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 6, 0.57, 63, 0.57, 0.07, 4.17, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'FT', 7, 0.34, 63, 0.34, 0.05, 2.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'IM', NULL, 3.24, 65, 0.16, 2.93, 3.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 947, 'RT', NULL, 42.57, 158, 6.96, 29.70, 56.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 1, 17.24, 39, 7.91, 6.35, 39.03, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 2, 25.05, 39, 10.37, 9.85, 50.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 3, 29.27, 39, 11.21, 12.15, 55.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 4, 10.79, 39, 6.42, 3.04, 31.80, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 5, 17.65, 39, 9.99, 5.06, 46.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'IM', NULL, 2.97, 41, 0.17, 2.62, 3.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', 949, 'RT', NULL, 23.58, 158, 5.35, 14.66, 35.68, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 1, 1.02, 69, 1.02, 0.14, 7.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 2, 8.65, 69, 3.23, 4.02, 17.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 3, 23.65, 69, 5.21, 14.84, 35.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 4, 25.65, 69, 5.47, 16.29, 37.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 5, 25.51, 69, 4.68, 17.33, 35.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 6, 8.50, 69, 3.67, 3.50, 19.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'FT', 7, 7.01, 69, 3.28, 2.69, 17.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'IM', NULL, 4.13, 66, 0.12, 3.89, 4.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'RT', NULL, 96.37, 73, 2.29, 87.79, 98.99, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 1, 2.15, 64, 2.09, 0.30, 13.78, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 2, 9.79, 64, 3.49, 4.69, 19.31, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 3, 27.42, 64, 5.51, 17.84, 39.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 4, 21.09, 64, 5.50, 12.13, 34.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 5, 24.49, 64, 5.14, 15.69, 36.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 6, 9.57, 64, 3.47, 4.53, 19.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'FT', 7, 5.49, 64, 3.18, 1.68, 16.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'IM', NULL, 4.07, 60, 0.13, 3.80, 4.34, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'RT', NULL, 87.26, 72, 3.50, 78.52, 92.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 1, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 2, 17.06, 68, 4.24, 10.16, 27.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 3, 11.79, 68, 4.00, 5.84, 22.36, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 4, 21.68, 68, 5.23, 13.02, 33.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 5, 24.29, 68, 4.82, 15.98, 35.13, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 6, 20.26, 68, 5.23, 11.74, 32.66, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'FT', 7, 4.92, 68, 2.83, 1.52, 14.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'IM', NULL, 3.90, 69, 0.11, 3.67, 4.12, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'RT', NULL, 97.19, 72, 1.74, 90.69, 99.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 1, 3.55, 57, 3.40, 0.50, 21.18, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 2, 25.30, 57, 5.91, 15.33, 38.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 3, 27.69, 57, 5.74, 17.74, 40.48, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 4, 23.90, 57, 5.93, 14.06, 37.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 5, 14.70, 57, 4.99, 7.21, 27.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 6, 4.85, 57, 2.91, 1.42, 15.28, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'FT', 7, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'IM', NULL, 3.87, 54, 0.13, 3.60, 4.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'RT', NULL, 80.19, 71, 5.99, 65.62, 89.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 1, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 2, 6.17, 55, 3.22, 2.11, 16.72, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 3, 21.57, 55, 5.92, 11.99, 35.68, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 4, 25.90, 55, 6.21, 15.45, 40.08, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 5, 26.81, 55, 6.09, 16.43, 40.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 6, 17.74, 55, 5.25, 9.49, 30.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'FT', 7, 1.81, 55, 1.80, 0.24, 12.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'IM', NULL, 3.84, 53, 0.14, 3.57, 4.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'RT', NULL, 78.64, 71, 4.50, 68.33, 86.26, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 1, 1.78, 56, 1.78, 0.24, 12.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 2, 18.36, 56, 5.87, 9.31, 33.01, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 3, 20.34, 56, 4.90, 12.23, 31.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 4, 18.71, 56, 5.06, 10.56, 30.96, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 5, 28.41, 56, 6.14, 17.81, 42.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 6, 7.70, 56, 3.94, 2.67, 20.20, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'FT', 7, 4.69, 56, 3.29, 1.12, 17.67, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'IM', NULL, 3.81, 53, 0.13, 3.56, 4.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'RT', NULL, 78.17, 71, 4.91, 66.87, 86.40, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 1, 3.64, 58, 2.58, 0.86, 14.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 2, 11.74, 58, 4.35, 5.43, 23.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 3, 17.45, 58, 4.95, 9.61, 29.60, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 4, 25.23, 58, 5.86, 15.33, 38.60, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 5, 27.78, 58, 5.24, 18.57, 39.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 6, 12.14, 58, 4.26, 5.85, 23.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'FT', 7, 2.02, 58, 2.01, 0.27, 13.57, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'IM', NULL, 3.81, 59, 0.12, 3.57, 4.05, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'RT', NULL, 83.59, 72, 4.07, 73.81, 90.21, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 1, 9.16, 58, 4.05, 3.66, 21.09, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 2, 36.44, 58, 6.04, 25.38, 49.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 3, 36.59, 58, 6.98, 24.01, 51.32, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 4, 14.28, 58, 5.14, 6.71, 27.84, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 5, 2.36, 58, 2.33, 0.32, 15.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 6, 1.17, 58, 1.16, 0.16, 8.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'FT', 7, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'IM', NULL, 3.67, 55, 0.12, 3.42, 3.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'RT', NULL, 81.73, 71, 4.85, 70.08, 89.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 1, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 2, 17.66, 56, 5.12, 9.58, 30.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 3, 22.85, 56, 6.51, 12.39, 38.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 4, 22.46, 56, 5.95, 12.74, 36.48, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 5, 27.16, 56, 6.45, 16.25, 41.74, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 6, 8.42, 56, 3.87, 3.26, 20.08, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'FT', 7, 1.45, 56, 1.44, 0.19, 10.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'IM', NULL, 3.61, 57, 0.14, 3.33, 3.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'RT', NULL, 79.02, 74, 4.50, 68.66, 86.62, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 1, 3.19, 56, 2.25, 0.76, 12.43, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 2, 16.15, 56, 4.92, 8.51, 28.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 3, 46.17, 56, 7.06, 32.67, 60.25, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 4, 14.89, 56, 4.38, 8.05, 25.91, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 5, 15.39, 56, 4.82, 7.97, 27.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 6, 3.01, 56, 2.37, 0.61, 13.65, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'FT', 7, 1.19, 56, 1.20, 0.16, 8.45, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'IM', NULL, 3.59, 54, 0.11, 3.37, 3.80, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'RT', NULL, 77.04, 71, 6.40, 62.00, 87.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 1, 4.41, 57, 3.10, 1.04, 16.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 2, 18.73, 57, 4.77, 10.96, 30.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 3, 19.86, 57, 5.25, 11.34, 32.44, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 4, 28.59, 57, 5.51, 18.91, 40.73, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 5, 19.96, 57, 5.22, 11.47, 32.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 6, 6.07, 57, 3.17, 2.08, 16.46, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'FT', 7, 2.37, 57, 2.29, 0.33, 14.95, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'IM', NULL, 3.55, 56, 0.13, 3.29, 3.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'RT', NULL, 78.24, 73, 5.42, 65.60, 87.15, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 1, 2.23, 51, 2.23, 0.29, 15.05, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 2, 34.26, 51, 6.79, 22.15, 48.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 3, 26.21, 51, 6.27, 15.63, 40.52, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 4, 14.93, 51, 5.51, 6.84, 29.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 5, 20.34, 51, 7.10, 9.57, 38.11, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 6, 2.02, 51, 1.52, 0.44, 8.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'FT', 7, 0.00, 51, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'IM', NULL, 3.54, 51, 0.13, 3.28, 3.79, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'RT', NULL, 69.28, 72, 6.27, 55.62, 80.23, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 1, 4.04, 63, 2.39, 1.21, 12.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 2, 9.46, 63, 3.87, 4.06, 20.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 3, 39.21, 63, 6.59, 27.07, 52.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 4, 20.90, 63, 5.26, 12.27, 33.30, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 5, 23.71, 63, 5.53, 14.43, 36.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 6, 2.68, 63, 1.91, 0.63, 10.63, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'FT', 7, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'IM', NULL, 3.25, 57, 0.13, 2.99, 3.51, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'RT', NULL, 86.55, 72, 4.49, 74.88, 93.28, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 1, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 2, 21.53, 30, 8.13, 9.30, 42.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 3, 19.07, 30, 7.28, 8.24, 38.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 4, 20.48, 30, 7.09, 9.56, 38.56, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 5, 18.13, 30, 9.20, 5.87, 44.03, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 6, 14.08, 30, 6.67, 5.03, 33.62, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'FT', 7, 6.71, 30, 4.66, 1.54, 24.81, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'IM', NULL, 3.89, 27, 0.20, 3.48, 4.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'RT', NULL, 41.07, 72, 6.29, 29.33, 53.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 1, 5.28, 47, 3.73, 1.23, 19.98, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 2, 36.15, 47, 8.30, 21.55, 53.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 3, 23.84, 47, 6.60, 13.08, 39.42, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 4, 13.04, 47, 5.65, 5.22, 29.00, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 5, 14.46, 47, 5.40, 6.56, 28.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 6, 5.80, 47, 3.92, 1.43, 20.68, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'FT', 7, 1.43, 47, 1.43, 0.19, 10.10, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'IM', NULL, 3.81, 44, 0.16, 3.50, 4.13, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'RT', NULL, 63.17, 72, 6.64, 49.26, 75.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 1, 4.34, 38, 3.01, 1.03, 16.49, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 2, 15.25, 38, 5.47, 7.10, 29.77, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 3, 36.91, 38, 9.01, 21.07, 56.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 4, 10.45, 38, 4.73, 4.02, 24.54, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 5, 20.62, 38, 6.80, 10.06, 37.61, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 6, 12.43, 38, 5.64, 4.74, 28.86, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'FT', 7, 0.00, 38, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'IM', NULL, 3.68, 38, 0.17, 3.33, 4.02, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'RT', NULL, 58.64, 69, 5.67, 47.07, 69.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 1, 2.36, 45, 2.35, 0.31, 15.88, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 2, 23.50, 45, 6.12, 13.40, 37.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 3, 18.69, 45, 5.71, 9.73, 32.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 4, 22.59, 45, 7.47, 10.97, 40.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 5, 16.24, 45, 5.05, 8.40, 29.06, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 6, 12.29, 45, 4.72, 5.48, 25.29, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'FT', 7, 4.33, 45, 3.13, 0.98, 17.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'IM', NULL, 3.62, 45, 0.16, 3.30, 3.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'RT', NULL, 61.21, 72, 6.54, 47.67, 73.21, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 1, 5.03, 46, 3.56, 1.17, 19.17, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 2, 26.30, 46, 6.55, 15.29, 41.35, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 3, 17.91, 46, 5.83, 8.94, 32.64, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 4, 27.42, 46, 6.35, 16.57, 41.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 5, 19.24, 46, 6.61, 9.19, 35.94, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 6, 4.10, 46, 2.94, 0.94, 16.16, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'FT', 7, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'IM', NULL, 3.61, 45, 0.14, 3.34, 3.89, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'RT', NULL, 62.26, 72, 5.72, 50.39, 72.82, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 1, 3.68, 46, 2.68, 0.83, 14.92, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 2, 26.13, 46, 6.20, 15.63, 40.32, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 3, 21.52, 46, 6.79, 10.87, 38.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 4, 22.45, 46, 5.77, 12.93, 36.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 5, 9.94, 46, 4.52, 3.84, 23.39, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 6, 16.28, 46, 6.11, 7.31, 32.41, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'FT', 7, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'IM', NULL, 3.50, 45, 0.12, 3.25, 3.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'RT', NULL, 63.96, 72, 6.30, 50.72, 75.37, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 1, 18.91, 45, 6.08, 9.49, 34.16, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 2, 62.00, 45, 7.03, 47.21, 74.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 3, 6.75, 45, 3.93, 2.02, 20.33, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 4, 10.87, 45, 4.51, 4.56, 23.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 5, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 6, 1.47, 45, 1.46, 0.20, 10.24, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'IM', NULL, 3.43, 47, 0.16, 3.11, 3.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'RT', NULL, 65.01, 74, 6.56, 51.11, 76.75, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 1, 13.66, 30, 6.84, 4.60, 34.14, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 2, 23.42, 30, 8.34, 10.57, 44.18, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 3, 32.29, 30, 8.01, 18.41, 50.22, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 4, 14.19, 30, 6.52, 5.24, 33.07, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 5, 14.11, 30, 6.12, 5.52, 31.59, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'FT', 7, 2.33, 30, 2.33, 0.29, 16.19, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'IM', NULL, 3.35, 29, 0.17, 2.99, 3.71, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'RT', NULL, 40.08, 71, 6.70, 27.72, 53.85, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 1, 0.64, 112, 0.64, 0.09, 4.59, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 2, 16.09, 112, 6.60, 6.79, 33.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 3, 20.94, 112, 5.01, 12.70, 32.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 4, 12.55, 112, 3.78, 6.76, 22.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 5, 29.28, 112, 4.06, 21.92, 37.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 6, 14.28, 112, 3.90, 8.13, 23.86, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'FT', 7, 6.23, 112, 3.68, 1.87, 18.81, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'IM', NULL, 4.30, 113, 0.12, 4.07, 4.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 951, 'RT', NULL, 98.32, 117, 1.13, 93.82, 99.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 1, 0.73, 113, 0.57, 0.16, 3.39, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 2, 10.56, 113, 3.96, 4.90, 21.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 3, 18.24, 113, 5.31, 9.92, 31.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 4, 8.28, 113, 2.97, 3.99, 16.39, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 5, 27.22, 113, 7.52, 14.99, 44.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 6, 25.05, 113, 6.03, 15.03, 38.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'FT', 7, 9.92, 113, 4.07, 4.27, 21.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'IM', NULL, 4.24, 114, 0.06, 4.11, 4.36, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'RT', NULL, 98.22, 117, 1.19, 93.46, 99.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 1, 1.26, 94, 0.94, 0.29, 5.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 2, 31.99, 94, 6.24, 21.02, 45.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 3, 21.05, 94, 7.61, 9.70, 39.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 4, 19.58, 94, 5.23, 11.18, 32.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 5, 16.90, 94, 4.71, 9.46, 28.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 6, 8.85, 94, 5.94, 2.20, 29.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'FT', 7, 0.37, 94, 0.37, 0.05, 2.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'IM', NULL, 3.99, 95, 0.13, 3.73, 4.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 952, 'RT', NULL, 81.95, 116, 4.22, 72.07, 88.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 1, 8.02, 92, 4.64, 2.44, 23.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 2, 19.12, 92, 6.71, 9.08, 35.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 3, 31.31, 92, 6.99, 19.30, 46.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 4, 22.41, 92, 6.34, 12.27, 37.35, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 5, 18.04, 92, 7.61, 7.33, 37.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 6, 0.69, 92, 0.50, 0.16, 2.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'FT', 7, 0.41, 92, 0.42, 0.06, 3.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'IM', NULL, 3.87, 93, 0.15, 3.57, 4.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 950, 'RT', NULL, 71.63, 117, 5.04, 60.70, 80.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 1, 4.22, 102, 2.05, 1.58, 10.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 2, 18.64, 102, 6.60, 8.81, 35.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 3, 32.85, 102, 5.94, 22.29, 45.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 4, 27.54, 102, 11.00, 11.30, 53.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 5, 9.74, 102, 4.18, 4.03, 21.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 6, 6.61, 102, 5.42, 1.23, 28.76, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'FT', 7, 0.39, 102, 0.36, 0.06, 2.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'IM', NULL, 3.70, 103, 0.16, 3.38, 4.02, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 957, 'RT', NULL, 84.10, 116, 5.92, 68.76, 92.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 1, 22.78, 80, 5.31, 13.92, 34.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 2, 19.76, 80, 6.30, 10.04, 35.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 3, 11.61, 80, 4.33, 5.36, 23.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 4, 10.29, 80, 5.27, 3.55, 26.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 5, 22.09, 80, 6.15, 12.22, 36.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 6, 6.93, 80, 3.63, 2.37, 18.58, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'FT', 7, 6.54, 80, 5.46, 1.17, 29.27, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'IM', NULL, 3.66, 81, 0.12, 3.42, 3.90, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 954, 'RT', NULL, 75.29, 117, 5.24, 63.55, 84.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 1, 14.04, 87, 6.06, 5.67, 30.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 2, 11.23, 87, 4.40, 5.00, 23.33, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 3, 35.29, 87, 7.55, 22.04, 51.26, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 4, 14.44, 87, 5.02, 7.00, 27.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 5, 22.44, 87, 5.39, 13.51, 34.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 6, 2.15, 87, 1.41, 0.58, 7.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'FT', 7, 0.42, 87, 0.42, 0.06, 3.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'IM', NULL, 3.65, 89, 0.16, 3.34, 3.96, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 956, 'RT', NULL, 74.34, 113, 6.91, 58.57, 85.58, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 1, 10.97, 102, 5.41, 3.95, 26.99, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 2, 29.43, 102, 6.65, 18.11, 44.04, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 3, 22.78, 102, 4.73, 14.75, 33.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 4, 17.63, 102, 4.75, 10.06, 29.06, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 5, 12.99, 102, 4.53, 6.32, 24.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 6, 5.85, 102, 4.83, 1.08, 26.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'FT', 7, 0.35, 102, 0.35, 0.05, 2.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'IM', NULL, 3.56, 104, 0.11, 3.33, 3.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 958, 'RT', NULL, 87.23, 116, 4.50, 75.42, 93.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 1, 10.31, 78, 4.88, 3.87, 24.74, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 2, 50.93, 78, 8.16, 35.13, 66.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 3, 24.10, 78, 9.51, 10.13, 47.22, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 4, 11.28, 78, 4.90, 4.58, 25.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 5, 3.38, 78, 2.96, 0.57, 17.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 6, 0.00, 78, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'FT', 7, 0.00, 78, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'IM', NULL, 3.53, 79, 0.18, 3.17, 3.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 955, 'RT', NULL, 72.90, 115, 4.25, 63.71, 80.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 1, 8.37, 113, 3.62, 3.46, 18.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 2, 34.79, 113, 10.99, 16.97, 58.21, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 3, 29.25, 113, 6.14, 18.68, 42.65, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 4, 22.58, 113, 6.76, 11.93, 38.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 5, 1.45, 113, 0.76, 0.50, 4.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 6, 3.26, 113, 1.86, 1.04, 9.77, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'FT', 7, 0.31, 113, 0.31, 0.04, 2.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'IM', NULL, 3.41, 114, 0.14, 3.12, 3.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 961, 'RT', NULL, 97.54, 116, 2.07, 87.82, 99.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 1, 11.59, 95, 4.18, 5.51, 22.75, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 2, 45.16, 95, 6.61, 32.65, 58.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 3, 20.43, 95, 7.54, 9.28, 39.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 4, 15.00, 95, 4.41, 8.15, 25.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 5, 6.37, 95, 3.68, 1.96, 18.78, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 6, 0.38, 95, 0.34, 0.06, 2.25, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'FT', 7, 1.07, 95, 0.82, 0.23, 4.84, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'IM', NULL, 3.40, 96, 0.10, 3.21, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 963, 'RT', NULL, 88.47, 116, 3.59, 79.25, 93.91, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 1, 39.40, 71, 11.35, 20.12, 62.67, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 2, 33.39, 71, 9.93, 17.07, 54.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 3, 17.41, 71, 6.34, 8.04, 33.70, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 4, 9.80, 71, 6.40, 2.50, 31.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 5, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 6, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'FT', 7, 0.00, 71, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'IM', NULL, 3.14, 73, 0.12, 2.90, 3.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 960, 'RT', NULL, 67.35, 115, 5.24, 56.26, 76.79, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 1, 18.07, 70, 7.65, 7.29, 38.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 2, 25.68, 70, 6.83, 14.47, 41.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 3, 30.98, 70, 6.23, 20.07, 44.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 4, 12.27, 70, 5.69, 4.65, 28.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 5, 11.02, 70, 5.93, 3.57, 29.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 6, 1.50, 70, 1.53, 0.19, 10.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'FT', 7, 0.48, 70, 0.49, 0.06, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'IM', NULL, 3.41, 72, 0.37, 2.67, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 964, 'RT', NULL, 63.56, 116, 5.45, 52.25, 73.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 1, 18.07, 70, 7.65, 7.29, 38.20, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 2, 25.68, 70, 6.83, 14.47, 41.37, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 3, 30.98, 70, 6.23, 20.07, 44.52, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 4, 12.27, 70, 5.69, 4.65, 28.64, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 5, 11.02, 70, 5.93, 3.57, 29.29, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 6, 1.50, 70, 1.53, 0.19, 10.73, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'FT', 7, 0.48, 70, 0.49, 0.06, 3.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'IM', NULL, 3.41, 72, 0.37, 2.67, 4.16, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'RT', NULL, 63.56, 116, 5.45, 52.25, 73.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 1, 25.29, 71, 6.08, 15.12, 39.15, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 2, 43.41, 71, 6.37, 31.38, 56.28, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 3, 18.04, 71, 6.29, 8.61, 33.97, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 4, 10.43, 71, 5.62, 3.38, 27.89, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 5, 1.90, 71, 1.62, 0.34, 9.92, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 6, 0.46, 71, 0.47, 0.06, 3.47, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'FT', 7, 0.47, 71, 0.48, 0.06, 3.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'IM', NULL, 3.17, 72, 0.12, 2.93, 3.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 965, 'RT', NULL, 63.31, 116, 4.79, 53.42, 72.19, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 1, 14.48, 68, 5.38, 6.64, 28.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 2, 36.20, 68, 10.12, 19.14, 57.63, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 3, 38.96, 68, 10.41, 21.04, 60.46, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 4, 4.73, 68, 2.52, 1.60, 13.18, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 5, 5.19, 68, 2.14, 2.24, 11.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 6, 0.44, 68, 0.45, 0.06, 3.31, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'IM', NULL, 3.12, 68, 0.18, 2.76, 3.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'RT', NULL, 48.28, 116, 6.05, 36.62, 60.13, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 1, 15.93, 67, 8.29, 5.21, 39.48, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 2, 29.01, 67, 6.11, 18.44, 42.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 3, 40.44, 67, 8.72, 24.79, 58.32, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 4, 7.91, 67, 3.78, 2.95, 19.49, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 5, 4.28, 67, 2.17, 1.52, 11.42, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 6, 1.97, 67, 1.59, 0.39, 9.38, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'FT', 7, 0.47, 67, 0.48, 0.06, 3.50, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'IM', NULL, 3.06, 67, 0.22, 2.62, 3.51, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 962, 'RT', NULL, 66.15, 113, 4.67, 56.39, 74.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 1, 31.97, 88, 6.75, 20.22, 46.56, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 2, 34.68, 88, 8.46, 20.17, 52.72, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 3, 21.11, 88, 6.06, 11.49, 35.55, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 4, 11.21, 88, 4.73, 4.68, 24.53, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 5, 0.62, 88, 0.63, 0.08, 4.54, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 6, 0.00, 88, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'FT', 7, 0.40, 88, 0.41, 0.05, 2.98, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'IM', NULL, 2.70, 89, 0.15, 2.40, 3.01, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 959, 'RT', NULL, 74.62, 115, 4.41, 64.96, 82.34, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 1, 46.04, 48, 10.32, 27.01, 66.30, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 2, 37.45, 48, 8.50, 22.40, 55.40, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 3, 1.98, 48, 1.52, 0.42, 8.87, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 4, 13.92, 48, 6.82, 4.89, 33.71, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 5, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 6, 0.61, 48, 0.61, 0.08, 4.44, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'FT', 7, 0.00, 48, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'IM', NULL, 2.68, 50, 0.27, 2.12, 3.23, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'RT', NULL, 36.66, 115, 6.87, 24.36, 50.98, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 1, 44.79, 63, 12.41, 22.92, 68.88, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 2, 29.33, 63, 9.05, 14.78, 49.83, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 3, 14.54, 63, 5.32, 6.74, 28.60, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 4, 9.47, 63, 6.65, 2.17, 33.00, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 5, 1.40, 63, 1.07, 0.30, 6.24, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 6, 0.47, 63, 0.47, 0.06, 3.45, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'FT', 7, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'IM', NULL, 2.59, 65, 0.25, 2.09, 3.08, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'RT', NULL, 46.94, 116, 7.23, 33.24, 61.12, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 2, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 3, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 4, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 5, 34.78, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 6, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'FT', 7, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 3, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 1, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 2, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 4, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 5, 21.74, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 1, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 2, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 3, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 4, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 6, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'IM', NULL, 3.95, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 5, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 2, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 4, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 5, 35.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 6, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'IM', NULL, 3.70, 20, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 14, 'RT', NULL, 86.96, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 4, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 5, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'IM', NULL, 3.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 4, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 1, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 2, 47.83, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 3, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 4, 13.04, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 6, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'IM', NULL, 3.59, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 9, 'RT', NULL, 100.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 2, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 3, 31.82, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'FT', 7, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'IM', NULL, 3.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 2, 'RT', NULL, 95.65, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 1, 13.64, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 2, 54.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 3, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 4, 4.55, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 5, 9.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 11, 'RT', NULL, 100.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 3, 42.86, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 5, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'IM', NULL, 3.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 6, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 1, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 2, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 3, 23.81, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 5, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 6, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'IM', NULL, 3.38, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 15, 'RT', NULL, 91.30, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 2, 31.58, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 3, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 4, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 5, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 6, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'IM', NULL, 3.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 8, 'RT', NULL, 82.61, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 2, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 3, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 5, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'IM', NULL, 3.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 7, 'RT', NULL, 69.57, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 1, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 2, 47.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 3, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 4, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 5, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 6, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'IM', NULL, 3.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 10, 'RT', NULL, 95.45, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 2, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 3, 40.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 4, 33.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 5, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'IM', NULL, 4.07, 15, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 13, 'RT', NULL, 65.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 1, 27.27, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 2, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 4, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 5, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 6, 9.09, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'IM', NULL, 3.55, 11, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 17, 'RT', NULL, 50.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 1, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 2, 44.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 3, 33.33, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 4, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 5, 11.11, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 6, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'FT', 7, 0.00, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'IM', NULL, 3.44, 9, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 12, 'RT', NULL, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 1, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 2, 50.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 3, 25.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 4, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 5, 12.50, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 6, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'FT', 7, 0.00, 8, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'IM', NULL, 3.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', 16, 'RT', NULL, 36.36, 22, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 1, 8.10, 105, 3.40, 3.45, 17.90, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 2, 19.64, 105, 4.55, 12.13, 30.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 3, 16.00, 105, 5.33, 7.99, 29.49, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 4, 15.94, 105, 4.78, 8.55, 27.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 5, 35.45, 105, 8.05, 21.47, 52.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 6, 3.54, 105, 1.99, 1.14, 10.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'FT', 7, 1.31, 105, 1.32, 0.18, 9.11, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'IM', NULL, 3.71, 103, 0.17, 3.37, 4.05, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 21, 'RT', NULL, 77.98, 133, 4.39, 68.10, 85.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 1, 15.34, 123, 8.10, 5.01, 38.39, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 2, 24.95, 123, 6.39, 14.48, 39.50, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 3, 21.90, 123, 5.02, 13.56, 33.40, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 4, 8.62, 123, 2.68, 4.59, 15.60, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 5, 25.11, 123, 5.04, 16.48, 36.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 6, 1.74, 123, 1.07, 0.51, 5.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'FT', 7, 2.33, 123, 1.66, 0.56, 9.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'IM', NULL, 3.70, 122, 0.08, 3.54, 3.86, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 20, 'RT', NULL, 92.79, 133, 2.44, 86.20, 96.36, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 1, 6.06, 95, 2.52, 2.60, 13.46, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 2, 10.34, 95, 3.06, 5.65, 18.16, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 3, 22.25, 95, 5.60, 13.07, 35.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 4, 26.12, 95, 9.07, 12.20, 47.34, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 5, 32.91, 95, 5.71, 22.70, 45.04, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 6, 0.74, 95, 0.75, 0.10, 5.33, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'FT', 7, 1.59, 95, 1.61, 0.21, 11.02, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'IM', NULL, 3.38, 91, 0.11, 3.17, 3.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 23, 'RT', NULL, 71.93, 133, 5.48, 59.97, 81.43, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 1, 11.83, 126, 3.74, 6.19, 21.42, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 2, 33.82, 126, 7.21, 21.27, 49.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 3, 20.77, 126, 6.31, 10.93, 35.88, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 4, 13.24, 126, 3.21, 8.06, 20.98, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 5, 17.17, 126, 3.96, 10.68, 26.45, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 6, 3.15, 126, 1.43, 1.27, 7.59, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'FT', 7, 0.03, 126, 0.03, 0.00, 0.19, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'IM', NULL, 3.33, 122, 0.09, 3.15, 3.51, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 22, 'RT', NULL, 96.32, 134, 1.38, 92.37, 98.26, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 1, 26.98, 100, 6.28, 16.41, 41.03, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 2, 48.59, 100, 9.24, 31.21, 66.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 3, 21.23, 100, 4.93, 13.05, 32.61, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 4, 0.45, 100, 0.45, 0.06, 3.25, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 5, 2.74, 100, 1.70, 0.79, 9.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 6, 0.00, 100, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'FT', 7, 0.00, 100, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'IM', NULL, 3.19, 96, 0.11, 2.98, 3.41, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 30, 'RT', NULL, 74.75, 134, 5.74, 61.88, 84.38, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 1, 5.22, 98, 2.24, 2.19, 11.92, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 2, 21.83, 98, 5.53, 12.80, 34.69, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 3, 16.67, 98, 3.76, 10.46, 25.51, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 4, 12.28, 98, 3.73, 6.57, 21.78, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 5, 35.15, 98, 5.59, 24.98, 46.87, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 6, 2.06, 98, 1.21, 0.63, 6.49, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'FT', 7, 6.80, 98, 2.70, 3.04, 14.52, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'IM', NULL, 4.06, 99, 0.11, 3.85, 4.27, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 24, 'RT', NULL, 66.15, 133, 6.95, 51.40, 78.31, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 1, 50.82, 77, 7.22, 36.77, 64.74, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 2, 36.24, 77, 7.55, 22.87, 52.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 3, 5.24, 77, 2.96, 1.66, 15.37, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 4, 0.85, 77, 0.85, 0.12, 5.95, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 5, 4.80, 77, 2.98, 1.36, 15.62, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 6, 0.00, 77, 0.00, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'FT', 7, 2.04, 77, 2.06, 0.27, 13.97, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'IM', NULL, 3.95, 74, 0.14, 3.67, 4.22, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 26, 'RT', NULL, 56.26, 133, 6.87, 42.55, 69.08, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 1, 4.44, 93, 2.44, 1.46, 12.73, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 2, 8.95, 93, 3.52, 3.99, 18.83, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 3, 9.29, 93, 3.53, 4.26, 19.06, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 4, 6.61, 93, 2.64, 2.94, 14.19, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 5, 47.35, 93, 7.44, 33.21, 61.93, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 6, 14.02, 93, 6.05, 5.68, 30.63, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'FT', 7, 9.34, 93, 4.59, 3.40, 23.20, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'IM', NULL, 3.92, 94, 0.12, 3.68, 4.15, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', 19, 'RT', NULL, 63.80, 133, 6.62, 50.00, 75.65, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 1, 0.00, 75, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 2, 4.62, 75, 2.91, 1.28, 15.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 3, 28.19, 75, 8.25, 14.83, 46.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 4, 9.83, 75, 4.02, 4.23, 21.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 5, 44.98, 75, 8.82, 28.66, 62.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 6, 9.35, 75, 4.21, 3.69, 21.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'FT', 7, 3.04, 75, 2.06, 0.78, 11.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'IM', NULL, 4.11, 74, 0.13, 3.85, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 968, 'RT', NULL, 99.97, 76, 0.03, 99.80, 100.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 1, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 2, 5.66, 74, 3.39, 1.67, 17.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 3, 30.46, 74, 8.39, 16.59, 49.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 4, 36.39, 74, 8.54, 21.52, 54.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 5, 25.21, 74, 5.82, 15.42, 38.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 6, 2.27, 74, 1.70, 0.51, 9.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'IM', NULL, 4.10, 73, 0.11, 3.89, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 975, 'RT', NULL, 94.97, 76, 4.65, 73.08, 99.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 1, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 2, 6.14, 74, 4.29, 1.46, 22.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 3, 33.54, 74, 7.86, 19.99, 50.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 4, 26.09, 74, 7.50, 13.98, 43.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 5, 32.93, 74, 7.61, 19.81, 49.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 6, 1.29, 74, 0.80, 0.37, 4.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'FT', 7, 0.00, 74, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'IM', NULL, 4.08, 74, 0.14, 3.80, 4.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 978, 'RT', NULL, 99.97, 75, 0.03, 99.78, 100.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 1, 0.00, 69, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 2, 0.48, 69, 0.36, 0.10, 2.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 3, 10.22, 69, 5.56, 3.28, 27.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 4, 32.97, 69, 10.98, 15.43, 57.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 5, 42.13, 69, 13.57, 19.33, 68.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 6, 12.84, 69, 6.04, 4.77, 30.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'FT', 7, 1.37, 69, 1.39, 0.18, 9.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'IM', NULL, 4.04, 69, 0.12, 3.81, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 969, 'RT', NULL, 92.97, 76, 4.44, 77.38, 98.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 1, 0.00, 70, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 2, 7.60, 70, 4.31, 2.36, 21.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 3, 7.26, 70, 4.82, 1.84, 24.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 4, 22.95, 70, 7.89, 10.90, 42.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 5, 37.16, 70, 9.88, 20.27, 57.90, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 6, 13.37, 70, 6.95, 4.45, 33.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'FT', 7, 11.67, 70, 7.66, 2.91, 36.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'IM', NULL, 3.99, 70, 0.11, 3.76, 4.21, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'RT', NULL, 91.34, 76, 5.14, 74.28, 97.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 1, 10.05, 68, 7.54, 2.07, 37.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 2, 20.15, 68, 6.92, 9.66, 37.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 3, 29.74, 68, 9.53, 14.55, 51.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 4, 17.57, 68, 6.64, 7.86, 34.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 5, 17.82, 68, 8.90, 6.06, 42.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 6, 4.67, 68, 3.57, 0.98, 19.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'IM', NULL, 3.94, 68, 0.19, 3.57, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 971, 'RT', NULL, 81.61, 76, 11.32, 49.68, 95.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 1, 26.07, 73, 10.00, 11.14, 49.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 2, 32.64, 73, 8.01, 18.98, 50.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 3, 6.07, 73, 3.17, 2.09, 16.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 4, 17.23, 73, 7.65, 6.67, 37.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 5, 15.84, 73, 7.13, 6.09, 35.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 6, 0.86, 73, 0.73, 0.16, 4.54, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'FT', 7, 1.30, 73, 1.31, 0.17, 9.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'IM', NULL, 3.88, 73, 0.15, 3.59, 4.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 977, 'RT', NULL, 98.01, 76, 1.61, 90.54, 99.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 1, 0.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 2, 12.03, 76, 5.78, 4.40, 28.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 3, 24.84, 76, 7.69, 12.70, 42.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 4, 34.60, 76, 8.13, 20.54, 51.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 5, 23.49, 76, 6.26, 13.29, 38.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 6, 4.73, 76, 3.81, 0.91, 21.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'FT', 7, 0.32, 76, 0.32, 0.04, 2.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'IM', NULL, 3.88, 76, 0.21, 3.46, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 970, 'RT', NULL, 100.00, 76, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 1, 0.33, 72, 0.33, 0.04, 2.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 2, 5.64, 72, 3.63, 1.51, 18.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 3, 49.62, 72, 8.54, 33.27, 66.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 4, 26.17, 72, 7.54, 14.00, 43.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 5, 13.71, 72, 4.28, 7.16, 24.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 6, 4.18, 72, 2.49, 1.25, 13.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'FT', 7, 0.36, 72, 0.36, 0.05, 2.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'IM', NULL, 3.85, 72, 0.14, 3.57, 4.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 967, 'RT', NULL, 85.98, 76, 6.77, 66.71, 94.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 1, 0.65, 72, 0.45, 0.16, 2.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 2, 17.79, 72, 8.58, 6.30, 41.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 3, 38.33, 72, 8.09, 23.91, 55.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 4, 30.41, 72, 8.53, 16.36, 49.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 5, 11.16, 72, 3.95, 5.37, 21.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 6, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'FT', 7, 1.66, 72, 1.41, 0.30, 8.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'IM', NULL, 3.70, 72, 0.17, 3.37, 4.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 976, 'RT', NULL, 93.86, 76, 3.68, 81.05, 98.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 1, 7.33, 75, 4.00, 2.39, 20.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 2, 29.73, 75, 7.70, 16.87, 46.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 3, 27.04, 75, 8.13, 14.02, 45.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 4, 13.87, 75, 6.12, 5.48, 30.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 5, 12.71, 75, 6.12, 4.62, 30.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 6, 9.31, 75, 6.80, 2.02, 33.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'FT', 7, 0.00, 75, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'IM', NULL, 3.70, 75, 0.25, 3.20, 4.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 973, 'RT', NULL, 97.24, 76, 2.81, 81.41, 99.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 1, 3.15, 66, 2.81, 0.51, 16.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 2, 8.11, 66, 3.60, 3.26, 18.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 3, 48.13, 66, 8.19, 32.51, 64.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 4, 31.09, 66, 9.93, 15.16, 53.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 5, 6.51, 66, 3.41, 2.22, 17.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 6, 3.01, 66, 2.04, 0.77, 11.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'FT', 7, 0.00, 66, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'IM', NULL, 3.68, 66, 0.15, 3.37, 3.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 972, 'RT', NULL, 87.19, 76, 6.33, 68.78, 95.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 1, 1.77, 74, 1.63, 0.28, 10.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 2, 10.01, 74, 6.93, 2.34, 34.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 3, 24.34, 74, 8.50, 11.37, 44.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 4, 26.60, 74, 7.01, 15.05, 42.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 5, 35.79, 74, 8.85, 20.55, 54.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 6, 0.63, 74, 0.60, 0.09, 4.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'FT', 7, 0.86, 74, 0.65, 0.19, 3.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'IM', NULL, 3.63, 74, 0.21, 3.22, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 980, 'RT', NULL, 95.71, 76, 3.63, 79.32, 99.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 1, 0.82, 58, 0.82, 0.11, 5.87, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 2, 20.07, 58, 7.01, 9.47, 37.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 3, 61.75, 58, 9.10, 42.73, 77.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 4, 9.28, 58, 3.44, 4.32, 18.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 5, 7.62, 58, 3.86, 2.67, 19.85, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 6, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'FT', 7, 0.45, 58, 0.46, 0.06, 3.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'IM', NULL, 3.59, 60, 0.16, 3.28, 3.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 979, 'RT', NULL, 70.83, 76, 10.37, 47.19, 86.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 1, 16.44, 68, 8.99, 5.06, 42.06, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 2, 15.54, 68, 5.30, 7.59, 29.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 3, 32.15, 68, 9.53, 16.54, 53.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 4, 17.90, 68, 6.90, 7.87, 35.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 5, 17.96, 68, 7.69, 7.18, 38.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 6, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'FT', 7, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'IM', NULL, 3.53, 68, 0.23, 3.07, 4.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 974, 'RT', NULL, 84.33, 76, 11.07, 50.37, 96.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 1, 14.32, 67, 7.65, 4.59, 36.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 2, 31.00, 67, 10.64, 14.27, 54.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 3, 28.72, 67, 8.39, 15.09, 47.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 4, 21.33, 67, 9.06, 8.45, 44.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 5, 4.59, 67, 3.12, 1.15, 16.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 6, 0.03, 67, 0.03, 0.00, 0.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'FT', 7, 0.00, 67, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'IM', NULL, 3.39, 67, 0.22, 2.95, 3.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 981, 'RT', NULL, 88.84, 76, 7.10, 65.67, 97.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 1, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 2, 10.59, 60, 7.07, 2.59, 34.54, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 3, 4.90, 60, 2.53, 1.71, 13.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 4, 15.14, 60, 7.00, 5.66, 34.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 5, 46.91, 60, 10.24, 27.96, 66.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 6, 9.81, 60, 7.04, 2.17, 34.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'FT', 7, 12.66, 60, 5.75, 4.86, 29.11, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'IM', NULL, 4.19, 60, 0.20, 3.78, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', 966, 'RT', NULL, 65.58, 76, 13.98, 35.69, 86.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 1, 0.00, 53, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 2, 4.46, 53, 3.63, 0.84, 20.50, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 3, 8.14, 53, 4.13, 2.84, 21.14, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 4, 19.13, 53, 4.14, 12.14, 28.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 5, 23.53, 53, 3.75, 16.85, 31.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 6, 22.21, 53, 7.64, 10.52, 40.95, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'FT', 7, 22.53, 53, 8.78, 9.58, 44.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'IM', NULL, 4.30, 52, 0.19, 3.92, 4.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21311, 'RT', NULL, 83.85, 61, 9.14, 57.39, 95.24, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 1, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 2, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 3, 22.29, 37, 6.23, 12.15, 37.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 4, 21.96, 37, 8.38, 9.45, 43.15, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 5, 38.99, 37, 14.96, 15.15, 69.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 6, 10.40, 37, 5.92, 3.11, 29.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'FT', 7, 6.35, 37, 4.28, 1.55, 22.57, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'IM', NULL, 4.20, 38, 0.15, 3.90, 4.51, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21319, 'RT', NULL, 72.26, 60, 5.23, 60.73, 81.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 1, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 2, 6.51, 56, 4.04, 1.81, 20.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 3, 10.01, 56, 3.24, 5.13, 18.60, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 4, 9.22, 56, 6.50, 2.10, 32.51, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 5, 59.89, 56, 7.15, 45.12, 73.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 6, 7.52, 56, 3.75, 2.68, 19.35, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'FT', 7, 6.87, 56, 4.74, 1.64, 24.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'IM', NULL, 4.13, 55, 0.10, 3.92, 4.34, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21312, 'RT', NULL, 79.80, 61, 10.41, 52.07, 93.49, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 1, 45.92, 54, 8.19, 30.48, 62.20, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 2, 44.88, 54, 6.78, 31.97, 58.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 3, 8.07, 54, 5.08, 2.17, 25.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 4, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 5, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 6, 1.13, 54, 1.24, 0.12, 9.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'FT', 7, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'IM', NULL, 3.78, 50, 0.21, 3.34, 4.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21313, 'RT', NULL, 91.26, 60, 4.96, 75.04, 97.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 1, 14.75, 39, 3.86, 8.50, 24.37, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 2, 29.85, 39, 7.06, 17.69, 45.72, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 3, 30.36, 39, 15.63, 8.89, 66.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 4, 17.12, 39, 4.55, 9.74, 28.32, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 5, 0.58, 39, 0.62, 0.07, 4.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'FT', 7, 7.34, 39, 4.95, 1.78, 25.70, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'IM', NULL, 3.61, 37, 0.15, 3.31, 3.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21315, 'RT', NULL, 70.10, 59, 9.17, 49.42, 84.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 1, 19.85, 46, 7.51, 8.74, 39.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 2, 39.45, 46, 10.09, 21.76, 60.40, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 3, 25.41, 46, 6.53, 14.55, 40.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 4, 5.35, 46, 4.11, 1.09, 22.47, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 5, 9.94, 46, 5.37, 3.20, 26.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 6, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'FT', 7, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'IM', NULL, 3.47, 43, 0.35, 2.76, 4.18, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21316, 'RT', NULL, 79.15, 61, 5.44, 66.25, 88.02, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 1, 9.75, 31, 5.44, 2.97, 27.63, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 2, 27.72, 31, 10.41, 11.72, 52.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 3, 30.47, 31, 16.22, 8.41, 67.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 4, 4.88, 31, 4.19, 0.80, 24.50, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 5, 22.95, 31, 9.47, 9.07, 47.08, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 6, 0.39, 31, 0.43, 0.04, 3.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'FT', 7, 3.83, 31, 3.68, 0.52, 23.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'IM', NULL, 4.38, 29, 0.19, 3.99, 4.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21327, 'RT', NULL, 52.24, 61, 9.24, 34.28, 69.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 1, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 2, 41.15, 15, 21.17, 9.68, 82.01, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 3, 32.87, 15, 12.31, 12.89, 61.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 4, 1.78, 15, 1.50, 0.28, 10.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 5, 24.21, 15, 10.88, 8.22, 53.27, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 6, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'FT', 7, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'IM', NULL, 4.24, 13, 0.32, 3.54, 4.94, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21322, 'RT', NULL, 34.46, 61, 9.03, 19.11, 53.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 1, 5.88, 27, 5.34, 0.85, 31.22, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 2, 1.37, 27, 1.26, 0.20, 8.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 3, 11.00, 27, 7.17, 2.67, 35.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 4, 31.50, 27, 11.24, 13.61, 57.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 5, 33.11, 27, 5.61, 22.73, 45.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 6, 5.88, 27, 5.34, 0.85, 31.22, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'FT', 7, 11.26, 27, 7.04, 2.90, 35.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'IM', NULL, 4.14, 25, 0.23, 3.68, 4.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21321, 'RT', NULL, 43.38, 61, 9.76, 25.71, 62.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 1, 24.88, 39, 17.47, 4.75, 68.73, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 2, 1.41, 39, 1.49, 0.16, 11.08, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 3, 11.85, 39, 5.74, 4.23, 29.03, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 4, 10.18, 39, 5.70, 3.11, 28.57, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 5, 34.36, 39, 10.51, 16.93, 57.35, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 6, 17.33, 39, 5.82, 8.43, 32.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'IM', NULL, 4.09, 38, 0.28, 3.52, 4.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21318, 'RT', NULL, 47.62, 61, 9.67, 29.51, 66.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 1, 4.90, 25, 4.42, 0.73, 26.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 2, 32.46, 25, 16.10, 9.55, 68.63, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 3, 38.29, 25, 10.58, 19.76, 60.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 4, 9.81, 25, 5.42, 2.98, 27.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 5, 5.14, 25, 4.31, 0.87, 25.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'FT', 7, 9.40, 25, 7.45, 1.68, 38.70, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'IM', NULL, 4.04, 25, 0.25, 3.53, 4.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21320, 'RT', NULL, 51.99, 61, 8.48, 35.44, 68.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 1, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 2, 6.16, 39, 4.95, 1.15, 27.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 3, 9.62, 39, 6.90, 2.09, 34.66, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 4, 26.55, 39, 10.02, 11.32, 50.57, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 5, 44.46, 39, 13.63, 20.75, 70.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 6, 6.62, 39, 5.47, 1.17, 29.83, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'FT', 7, 6.59, 39, 5.44, 1.16, 29.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'IM', NULL, 3.98, 38, 0.20, 3.57, 4.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21317, 'RT', NULL, 44.60, 61, 11.91, 23.48, 67.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 1, 7.66, 30, 5.31, 1.76, 27.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 2, 36.83, 30, 12.79, 15.92, 64.22, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 3, 18.32, 30, 6.01, 8.99, 33.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 4, 16.53, 30, 5.92, 7.60, 32.26, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 5, 12.85, 30, 4.62, 5.96, 25.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'FT', 7, 7.82, 30, 5.00, 2.01, 25.93, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'IM', NULL, 3.82, 29, 0.24, 3.34, 4.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21323, 'RT', NULL, 64.14, 60, 8.38, 46.31, 78.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 1, 0.00, 42, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 2, 19.97, 42, 10.20, 6.43, 47.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 3, 24.97, 42, 6.90, 13.65, 41.19, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 4, 20.89, 42, 6.91, 10.19, 38.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 5, 18.23, 42, 5.00, 10.17, 30.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 6, 15.25, 42, 7.02, 5.67, 35.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'FT', 7, 0.69, 42, 0.71, 0.09, 5.26, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'IM', NULL, 3.76, 41, 0.17, 3.41, 4.10, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21325, 'RT', NULL, 49.85, 61, 17.82, 19.29, 80.53, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 1, 5.88, 33, 5.37, 0.86, 31.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 2, 24.13, 33, 8.36, 11.15, 44.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 3, 33.41, 33, 5.78, 22.81, 46.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 4, 22.95, 33, 12.24, 6.78, 54.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 5, 13.62, 33, 7.27, 4.29, 35.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 6, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'FT', 7, 0.00, 33, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'IM', NULL, 3.65, 32, 0.11, 3.42, 3.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21314, 'RT', NULL, 43.32, 61, 7.92, 28.62, 59.30, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 1, 8.49, 15, 6.03, 1.72, 32.90, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 2, 24.96, 15, 15.48, 5.35, 66.20, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 3, 4.61, 15, 3.60, 0.83, 21.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 4, 38.69, 15, 23.40, 7.07, 83.96, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 5, 2.85, 15, 2.36, 0.47, 15.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 6, 20.40, 15, 16.39, 2.86, 69.07, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'FT', 7, 0.00, 15, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'IM', NULL, 3.65, 13, 0.13, 3.37, 3.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21328, 'RT', NULL, 14.19, 61, 6.16, 5.67, 31.28, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 1, 5.92, 31, 4.74, 1.09, 26.37, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 2, 17.27, 31, 11.67, 3.78, 52.55, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 3, 18.47, 31, 4.92, 10.42, 30.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 4, 18.66, 31, 6.34, 8.91, 34.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 5, 27.01, 31, 10.36, 11.23, 51.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 6, 12.68, 31, 5.65, 4.87, 29.18, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'FT', 7, 0.00, 31, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'IM', NULL, 3.61, 31, 0.23, 3.15, 4.08, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21326, 'RT', NULL, 45.61, 61, 12.01, 24.15, 68.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 1, 12.49, 18, 11.88, 1.42, 58.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 2, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 3, 44.21, 18, 17.86, 14.67, 78.51, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 4, 32.63, 18, 14.54, 10.72, 66.15, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 5, 10.66, 18, 7.21, 2.36, 37.10, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 6, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'FT', 7, 0.00, 18, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'IM', NULL, 3.50, 18, 0.29, 2.89, 4.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21324, 'RT', NULL, 24.42, 61, 9.63, 10.21, 47.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 1, 65.02, 10, 13.74, 32.16, 87.94, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 2, 3.79, 10, 3.86, 0.36, 30.17, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 3, 0.00, 10, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 4, 2.83, 10, 3.37, 0.18, 31.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 5, 28.37, 10, 15.22, 6.78, 68.30, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 6, 0.00, 10, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'FT', 7, 0.00, 10, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'IM', NULL, 3.19, 10, 0.40, 2.27, 4.10, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21330, 'RT', NULL, 18.26, 61, 4.22, 11.26, 28.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 1, 21.68, 14, 10.67, 6.65, 51.83, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 2, 52.30, 14, 13.41, 25.56, 77.79, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 3, 14.24, 14, 12.33, 1.84, 59.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 4, 11.78, 14, 6.69, 3.21, 34.94, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 5, 0.00, 14, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 6, 0.00, 14, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'FT', 7, 0.00, 14, 0.00, NULL, NULL, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'IM', NULL, 3.18, 11, 0.50, 2.06, 4.30, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21331, 'RT', NULL, 21.65, 61, 9.97, 7.85, 47.25, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 1, 24.18, 17, 15.00, 5.33, 64.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 2, 1.04, 17, 1.07, 0.11, 8.74, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 3, 41.56, 17, 19.17, 11.78, 79.12, 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 4, 30.60, 17, 16.51, 7.82, 69.62, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 5, 2.61, 17, 2.67, 0.29, 19.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 6, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'FT', 7, 0.00, 17, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'IM', NULL, 3.18, 16, 0.35, 2.44, 3.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.00', 21329, 'RT', NULL, 25.66, 61, 5.28, 16.55, 37.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 2, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 3, 33.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 5, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'IM', NULL, 4.52, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 3, 16.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 4, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 5, 48.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'FT', 7, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'IM', NULL, 4.48, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 3, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 5, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 6, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'IM', NULL, 4.44, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 1, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 2, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 3, 20.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 4, 12.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 5, 40.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 6, 8.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'FT', 7, 4.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'IM', NULL, 4.40, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 2, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 3, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 4, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 5, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 6, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'FT', 7, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'IM', NULL, 4.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 1, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 2, 70.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 3, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 5, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'IM', NULL, 4.25, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 1, 8.70, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 2, 30.43, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 3, 39.13, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 4, 17.39, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 5, 4.35, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 6, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'FT', 7, 0.00, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'IM', NULL, 4.22, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'RT', NULL, 92.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 2, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 3, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 4, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 5, 55.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'FT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'IM', NULL, 4.20, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'RT', NULL, 80.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 1, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 2, 59.09, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 3, 22.73, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 4, 18.18, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 5, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 6, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'FT', 7, 0.00, 22, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'IM', NULL, 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'RT', NULL, 88.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 2, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 3, 25.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 4, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 5, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'IM', NULL, 4.09, 23, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 1, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 2, 37.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 3, 41.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 4, 16.67, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 5, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'FT', 7, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'IM', NULL, 4.08, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'RT', NULL, 96.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 1, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 2, 52.63, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 3, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 5, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'IM', NULL, 4.06, 18, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'RT', NULL, 76.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 1, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 2, 32.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 3, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 4, 24.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 5, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 6, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'FT', 7, 0.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'IM', NULL, 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'RT', NULL, 100.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 1, 8.33, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 2, 50.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 3, 20.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 4, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 5, 12.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 6, 0.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'FT', 7, 4.17, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'IM', NULL, 4.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'RT', NULL, 100.00, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 2, 30.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 5, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'IM', NULL, 3.90, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'RT', NULL, 80.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 1, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 2, 65.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 3, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 4, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 5, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 6, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'IM', NULL, 3.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'RT', NULL, 87.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 1, 36.36, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 2, 45.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'IM', NULL, 4.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'RT', NULL, 45.83, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 2, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 3, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 5, 60.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 6, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'FT', 7, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'IM', NULL, 4.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'RT', NULL, 62.50, 24, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 1, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 2, 71.43, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 3, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 4, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 5, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'IM', NULL, 4.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'RT', NULL, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 1, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 2, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 3, 57.14, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 4, 14.29, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 5, 28.57, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 6, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'FT', 7, 0.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'IM', NULL, 4.00, 7, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'RT', NULL, 28.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 1, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 3, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 4, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 6, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'IM', NULL, 3.75, 12, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'RT', NULL, 48.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 1, 45.45, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 2, 36.36, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 3, 18.18, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 4, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 5, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 6, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'FT', 7, 0.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'IM', NULL, 3.00, 11, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'RT', NULL, 44.00, 25, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 1, 0.00, 75, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 2, 1.62, 75, 1.54, 0.24, 10.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 3, 3.38, 75, 1.94, 1.06, 10.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 4, 8.10, 75, 3.63, 3.23, 18.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 5, 29.18, 75, 5.51, 19.51, 41.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 6, 8.46, 75, 3.57, 3.56, 18.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'FT', 7, 49.26, 75, 7.15, 35.44, 63.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'IM', NULL, 4.81, 73, 0.07, 4.67, 4.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15678, 'RT', NULL, 91.17, 81, 5.19, 74.09, 97.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 1, 3.42, 73, 2.19, 0.93, 11.75, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 2, 10.52, 73, 4.94, 3.96, 25.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 3, 7.01, 73, 3.19, 2.76, 16.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 4, 8.35, 73, 5.22, 2.28, 26.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 5, 35.78, 73, 6.67, 23.80, 49.84, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 6, 11.35, 73, 3.90, 5.58, 21.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'FT', 7, 23.57, 73, 7.61, 11.73, 41.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'IM', NULL, 4.61, 72, 0.12, 4.36, 4.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15679, 'RT', NULL, 86.10, 81, 5.59, 70.98, 94.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 1, 2.47, 78, 2.25, 0.39, 13.99, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 2, 4.38, 78, 2.58, 1.32, 13.51, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 3, 11.04, 78, 3.16, 6.13, 19.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 4, 5.79, 78, 3.52, 1.68, 18.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 5, 44.13, 78, 5.03, 34.47, 54.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 6, 17.04, 78, 4.79, 9.47, 28.74, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'FT', 7, 15.16, 78, 5.33, 7.26, 28.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'IM', NULL, 4.56, 79, 0.07, 4.42, 4.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15669, 'RT', NULL, 98.06, 81, 1.52, 91.17, 99.60, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 1, 1.90, 64, 1.95, 0.24, 13.59, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 2, 5.60, 64, 3.31, 1.67, 17.18, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 3, 12.14, 64, 3.82, 6.33, 22.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 4, 9.63, 64, 4.35, 3.77, 22.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 5, 27.40, 64, 6.76, 16.06, 42.67, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 6, 18.91, 64, 5.90, 9.76, 33.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'FT', 7, 24.43, 64, 9.13, 10.74, 46.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'IM', NULL, 4.48, 64, 0.17, 4.13, 4.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15676, 'RT', NULL, 74.46, 81, 8.55, 54.38, 87.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 1, 4.58, 72, 2.40, 1.58, 12.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 2, 17.73, 72, 5.62, 9.08, 31.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 3, 18.29, 72, 4.47, 10.98, 28.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 4, 13.59, 72, 5.02, 6.28, 26.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 5, 20.87, 72, 4.19, 13.71, 30.44, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 6, 6.00, 72, 3.29, 1.96, 16.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'FT', 7, 18.95, 72, 5.68, 10.05, 32.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'IM', NULL, 4.47, 73, 0.11, 4.25, 4.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15675, 'RT', NULL, 91.91, 81, 4.11, 79.11, 97.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 1, 1.64, 74, 1.56, 0.24, 10.30, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 2, 5.26, 74, 3.21, 1.52, 16.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 3, 7.69, 74, 3.37, 3.13, 17.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 4, 13.75, 74, 3.72, 7.87, 22.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 5, 35.65, 74, 6.14, 24.53, 48.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 6, 15.71, 74, 4.64, 8.48, 27.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'FT', 7, 20.29, 74, 7.39, 9.29, 38.77, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'IM', NULL, 4.38, 74, 0.12, 4.15, 4.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15667, 'RT', NULL, 89.62, 81, 4.06, 78.38, 95.37, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 1, 1.18, 76, 0.92, 0.25, 5.45, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 2, 11.21, 76, 4.70, 4.70, 24.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 3, 39.32, 76, 6.76, 26.92, 53.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 4, 24.12, 76, 6.00, 14.20, 37.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 5, 6.71, 76, 3.56, 2.26, 18.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 6, 10.29, 76, 4.78, 3.93, 24.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'FT', 7, 7.16, 76, 3.34, 2.75, 17.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'IM', NULL, 4.23, 76, 0.10, 4.02, 4.43, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15668, 'RT', NULL, 92.21, 81, 3.29, 82.64, 96.72, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 1, 9.80, 68, 3.76, 4.44, 20.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 2, 19.65, 68, 4.99, 11.52, 31.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 3, 14.80, 68, 5.17, 7.11, 28.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 4, 9.19, 68, 3.38, 4.32, 18.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 5, 21.15, 68, 4.79, 13.14, 32.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 6, 15.17, 68, 3.97, 8.81, 24.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'FT', 7, 10.23, 68, 3.67, 4.88, 20.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'IM', NULL, 4.22, 69, 0.12, 3.98, 4.47, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15664, 'RT', NULL, 88.32, 80, 3.21, 80.29, 93.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 1, 14.31, 63, 4.20, 7.76, 24.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 2, 31.40, 63, 6.86, 19.49, 46.39, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 3, 19.66, 63, 5.54, 10.82, 33.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 4, 19.64, 63, 5.65, 10.67, 33.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 5, 4.24, 63, 3.10, 0.95, 16.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 6, 4.82, 63, 3.22, 1.23, 17.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'FT', 7, 5.94, 63, 3.47, 1.79, 17.93, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'IM', NULL, 4.22, 64, 0.19, 3.83, 4.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15671, 'RT', NULL, 79.83, 81, 6.83, 62.97, 90.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 1, 1.18, 76, 0.92, 0.25, 5.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 2, 20.97, 76, 5.36, 12.23, 33.57, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 3, 12.74, 76, 5.28, 5.36, 27.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 4, 14.83, 76, 4.58, 7.80, 26.40, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 5, 27.70, 76, 5.89, 17.57, 40.78, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 6, 12.66, 76, 4.34, 6.22, 24.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'FT', 7, 9.91, 76, 3.80, 4.50, 20.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'IM', NULL, 4.05, 76, 0.11, 3.84, 4.26, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15665, 'RT', NULL, 93.22, 80, 3.12, 83.71, 97.35, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 1, 32.47, 69, 7.39, 19.71, 48.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 2, 43.69, 69, 6.88, 30.76, 57.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 3, 15.56, 69, 5.00, 7.94, 28.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 4, 3.07, 69, 2.26, 0.69, 12.61, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 5, 5.22, 69, 2.88, 1.69, 14.97, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 6, 0.00, 69, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'FT', 7, 0.00, 69, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'IM', NULL, 3.99, 69, 0.14, 3.71, 4.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15660, 'RT', NULL, 86.46, 81, 3.69, 77.34, 92.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 1, 9.30, 65, 4.97, 3.07, 24.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 2, 26.51, 65, 6.16, 16.10, 40.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 3, 15.03, 65, 6.20, 6.28, 31.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 4, 13.04, 65, 6.09, 4.88, 30.46, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 5, 23.59, 65, 5.78, 13.99, 36.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 6, 4.43, 65, 2.89, 1.17, 15.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'FT', 7, 8.11, 65, 3.43, 3.40, 18.14, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'IM', NULL, 3.79, 65, 0.13, 3.53, 4.05, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15674, 'RT', NULL, 85.23, 81, 3.96, 75.51, 91.52, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 1, 51.89, 61, 9.45, 33.58, 69.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 2, 29.66, 61, 6.23, 18.84, 43.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 3, 9.95, 61, 3.57, 4.74, 19.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 4, 8.51, 61, 3.53, 3.61, 18.73, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 5, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 6, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'FT', 7, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'IM', NULL, 3.76, 60, 0.11, 3.53, 3.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15662, 'RT', NULL, 77.60, 81, 6.41, 62.45, 87.83, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 1, 16.89, 54, 5.63, 8.34, 31.23, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 2, 24.08, 54, 7.37, 12.38, 41.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 3, 39.54, 54, 5.07, 29.94, 50.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 4, 4.81, 54, 4.91, 0.58, 30.28, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 5, 13.31, 54, 3.87, 7.27, 23.11, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 6, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'FT', 7, 1.37, 54, 0.97, 0.33, 5.55, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'IM', NULL, 3.72, 54, 0.13, 3.46, 3.98, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15670, 'RT', NULL, 70.97, 81, 6.58, 56.43, 82.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 1, 14.83, 53, 6.41, 5.92, 32.54, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 2, 40.56, 53, 9.04, 24.33, 59.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 3, 28.46, 53, 4.76, 19.93, 38.87, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 4, 8.94, 53, 4.21, 3.36, 21.69, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 5, 0.65, 53, 0.63, 0.09, 4.42, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 6, 3.28, 53, 2.96, 0.52, 18.12, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'FT', 7, 3.28, 53, 2.97, 0.51, 18.20, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'IM', NULL, 3.57, 54, 0.21, 3.15, 4.00, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15673, 'RT', NULL, 72.35, 81, 6.43, 58.00, 83.22, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 1, 14.11, 40, 5.07, 6.58, 27.70, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 2, 27.00, 40, 5.35, 17.60, 39.04, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 3, 17.16, 40, 6.20, 7.89, 33.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 4, 8.65, 40, 4.78, 2.71, 24.36, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 5, 22.51, 40, 5.98, 12.67, 36.76, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 6, 3.38, 40, 2.89, 0.58, 17.33, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'FT', 7, 7.20, 40, 4.83, 1.76, 25.09, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'IM', NULL, 3.79, 41, 0.18, 3.43, 4.15, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15677, 'RT', NULL, 55.15, 79, 7.52, 40.17, 69.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 1, 6.25, 45, 4.31, 1.49, 22.68, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 2, 53.43, 45, 11.88, 30.48, 75.01, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 3, 12.63, 45, 4.60, 5.88, 25.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 4, 13.55, 45, 6.36, 4.99, 31.90, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 5, 6.94, 45, 4.24, 1.95, 21.89, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 6, 3.91, 45, 3.72, 0.55, 23.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'FT', 7, 3.28, 45, 2.51, 0.69, 14.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'IM', NULL, 3.70, 45, 0.19, 3.32, 4.07, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15661, 'RT', NULL, 61.18, 79, 5.14, 50.61, 70.79, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 1, 17.94, 45, 6.93, 7.81, 36.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 2, 39.44, 45, 7.61, 25.52, 55.32, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 3, 20.09, 45, 5.77, 10.86, 34.17, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 4, 5.33, 45, 4.21, 1.04, 23.25, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 5, 12.48, 45, 5.83, 4.64, 29.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 6, 0.61, 45, 0.62, 0.08, 4.58, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'FT', 7, 4.10, 45, 3.74, 0.63, 22.50, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'IM', NULL, 3.58, 46, 0.17, 3.24, 3.92, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15666, 'RT', NULL, 58.50, 80, 5.71, 46.88, 69.24, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 1, 19.13, 44, 9.12, 6.72, 43.71, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 2, 25.72, 44, 8.16, 12.77, 45.03, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 3, 17.55, 44, 6.43, 8.00, 34.27, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 4, 13.60, 44, 7.94, 3.87, 38.08, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 5, 11.29, 44, 4.73, 4.68, 24.82, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'FT', 7, 12.71, 44, 6.30, 4.42, 31.41, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'IM', NULL, 3.54, 43, 0.20, 3.15, 3.94, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15672, 'RT', NULL, 55.71, 81, 5.19, 45.28, 65.66, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 1, 11.03, 41, 4.78, 4.43, 24.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 2, 28.15, 41, 9.74, 12.89, 50.91, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 3, 19.42, 41, 3.85, 12.79, 28.38, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 4, 6.13, 41, 4.41, 1.37, 23.48, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 5, 31.97, 41, 10.64, 14.89, 55.81, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 6, 3.30, 41, 3.23, 0.44, 20.86, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'FT', 7, 0.00, 41, 0.00, NULL, NULL, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'IM', NULL, 3.47, 41, 0.24, 3.00, 3.95, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', 15663, 'RT', NULL, 60.96, 81, 7.30, 45.89, 74.19, 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 1, 3.55, 100, 1.64, 1.40, 8.70, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 2, 6.85, 100, 3.00, 2.81, 15.76, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 3, 11.62, 100, 5.50, 4.34, 27.57, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 4, 15.75, 100, 3.93, 9.41, 25.17, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 5, 38.96, 100, 4.90, 29.77, 49.00, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 6, 15.59, 100, 5.60, 7.35, 30.05, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'FT', 7, 7.68, 100, 2.52, 3.94, 14.42, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'IM', NULL, 4.01, 101, 0.11, 3.80, 4.22, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 39, 'RT', NULL, 88.43, 115, 3.57, 79.30, 93.85, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 1, 1.97, 106, 1.99, 0.26, 13.36, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 2, 2.06, 106, 2.00, 0.29, 13.11, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 3, 11.22, 106, 4.09, 5.30, 22.20, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 4, 4.14, 106, 3.21, 0.86, 17.68, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 5, 38.34, 106, 7.00, 25.69, 52.79, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 6, 29.06, 106, 7.21, 16.99, 45.04, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'FT', 7, 13.22, 106, 3.46, 7.73, 21.69, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'IM', NULL, 4.00, 108, 0.10, 3.81, 4.20, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 32, 'RT', NULL, 94.20, 115, 2.56, 86.52, 97.62, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 1, 0.00, 108, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 2, 6.83, 108, 3.47, 2.43, 17.77, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 3, 12.84, 108, 4.05, 6.71, 23.18, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 4, 15.40, 108, 3.90, 9.14, 24.80, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 5, 42.72, 108, 5.17, 32.91, 53.13, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 6, 14.98, 108, 5.05, 7.43, 27.89, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'FT', 7, 7.23, 108, 2.98, 3.13, 15.81, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'IM', NULL, 3.99, 109, 0.11, 3.77, 4.21, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 34, 'RT', NULL, 96.31, 115, 2.02, 89.44, 98.77, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 1, 0.00, 111, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 2, 8.39, 111, 3.75, 3.37, 19.41, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 3, 10.04, 111, 4.17, 4.28, 21.81, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 4, 21.02, 111, 5.39, 12.27, 33.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 5, 38.65, 111, 6.78, 26.33, 52.60, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 6, 19.35, 111, 5.92, 10.16, 33.72, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'FT', 7, 2.54, 111, 1.48, 0.79, 7.88, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'IM', NULL, 3.85, 111, 0.07, 3.71, 3.99, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 35, 'RT', NULL, 97.39, 115, 1.83, 89.93, 99.36, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 1, 7.94, 102, 3.82, 2.97, 19.54, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 2, 25.94, 102, 8.32, 12.92, 45.28, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 3, 17.63, 102, 5.01, 9.74, 29.79, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 4, 16.31, 102, 7.26, 6.36, 35.89, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 5, 23.20, 102, 6.27, 13.06, 37.79, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 6, 5.94, 102, 2.55, 2.49, 13.49, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'FT', 7, 3.04, 102, 2.22, 0.70, 12.26, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'IM', NULL, 3.85, 104, 0.10, 3.65, 4.05, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 36, 'RT', NULL, 90.21, 115, 3.59, 80.46, 95.38, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 1, 0.09, 104, 0.09, 0.01, 0.65, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 2, 13.27, 104, 4.50, 6.58, 24.94, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 3, 18.66, 104, 6.32, 9.13, 34.37, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 4, 9.88, 104, 3.30, 4.99, 18.60, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 5, 47.58, 104, 6.81, 34.56, 60.93, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 6, 6.87, 104, 3.37, 2.53, 17.32, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'FT', 7, 3.66, 104, 2.21, 1.09, 11.62, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'IM', NULL, 3.80, 103, 0.11, 3.59, 4.01, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 40, 'RT', NULL, 89.85, 115, 3.60, 80.18, 95.09, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 1, 2.05, 104, 2.08, 0.27, 14.07, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 2, 5.70, 104, 2.86, 2.06, 14.81, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 3, 13.92, 104, 4.68, 6.94, 25.96, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 4, 16.84, 104, 4.59, 9.56, 27.95, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 5, 47.99, 104, 7.33, 34.02, 62.29, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 6, 6.84, 104, 3.44, 2.46, 17.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'FT', 7, 6.66, 104, 4.22, 1.82, 21.50, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'IM', NULL, 3.72, 107, 0.13, 3.46, 3.98, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 38, 'RT', NULL, 90.11, 115, 3.17, 81.82, 94.86, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 1, 7.88, 86, 2.81, 3.81, 15.58, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 2, 21.29, 86, 6.13, 11.56, 35.89, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 3, 25.37, 86, 5.20, 16.45, 36.99, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 4, 16.10, 86, 5.19, 8.21, 29.17, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 5, 22.44, 86, 5.94, 12.80, 36.33, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 6, 6.91, 86, 3.92, 2.17, 19.93, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'FT', 7, 0.00, 86, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'IM', NULL, 3.57, 89, 0.12, 3.33, 3.82, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 41, 'RT', NULL, 78.31, 114, 3.82, 69.81, 84.93, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 1, 7.72, 93, 3.00, 3.50, 16.17, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 2, 18.76, 93, 3.82, 12.32, 27.52, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 3, 11.85, 93, 4.60, 5.30, 24.38, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 4, 11.05, 93, 4.96, 4.36, 25.28, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 5, 45.15, 93, 6.08, 33.57, 57.29, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 6, 5.47, 93, 2.58, 2.10, 13.49, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'FT', 7, 0.00, 93, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'IM', NULL, 3.56, 95, 0.13, 3.31, 3.81, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 33, 'RT', NULL, 84.43, 115, 3.59, 75.93, 90.31, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 1, 4.42, 89, 2.38, 1.48, 12.42, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 2, 24.87, 89, 4.74, 16.67, 35.40, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 3, 22.51, 89, 6.24, 12.48, 37.17, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 4, 15.67, 89, 4.83, 8.25, 27.75, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 5, 20.11, 89, 4.40, 12.74, 30.26, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 6, 8.41, 89, 3.28, 3.79, 17.63, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'FT', 7, 4.02, 89, 2.59, 1.09, 13.72, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'IM', NULL, 3.47, 89, 0.11, 3.25, 3.69, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 44, 'RT', NULL, 78.12, 114, 4.64, 67.60, 85.94, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 1, 11.51, 100, 5.05, 4.63, 25.82, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 2, 25.49, 100, 5.84, 15.67, 38.64, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 3, 21.79, 100, 4.94, 13.56, 33.11, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 4, 19.10, 100, 4.95, 11.12, 30.82, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 5, 18.84, 100, 4.84, 11.02, 30.33, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 6, 1.21, 100, 1.16, 0.18, 7.79, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'FT', 7, 2.05, 100, 1.99, 0.29, 13.01, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'IM', NULL, 3.44, 98, 0.11, 3.23, 3.66, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 43, 'RT', NULL, 87.56, 114, 3.65, 78.37, 93.19, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 1, 2.43, 94, 1.59, 0.65, 8.64, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 2, 16.89, 94, 4.79, 9.35, 28.58, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 3, 32.08, 94, 5.22, 22.70, 43.18, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 4, 12.51, 94, 4.18, 6.28, 23.37, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 5, 29.00, 94, 4.98, 20.17, 39.77, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 6, 1.04, 94, 1.06, 0.14, 7.48, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'FT', 7, 6.05, 94, 3.23, 2.04, 16.59, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'IM', NULL, 3.28, 96, 0.12, 3.05, 3.52, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 37, 'RT', NULL, 81.42, 115, 3.77, 72.80, 87.77, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 1, 11.88, 44, 5.60, 4.39, 28.38, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 2, 16.49, 44, 5.51, 8.10, 30.67, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 3, 47.54, 44, 9.28, 29.98, 65.74, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 4, 19.26, 44, 7.74, 8.03, 39.43, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 5, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'FT', 7, 4.83, 44, 4.49, 0.70, 26.68, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'IM', NULL, 3.53, 44, 0.15, 3.22, 3.83, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', 45, 'RT', NULL, 37.41, 114, 4.89, 28.33, 47.48, 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 1, 12.55, 48, 5.33, 5.12, 27.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 2, 28.04, 48, 7.76, 15.23, 45.79, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 3, 10.92, 48, 5.49, 3.79, 27.63, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 4, 8.38, 48, 5.48, 2.13, 27.76, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 5, 25.40, 48, 7.45, 13.38, 42.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 6, 5.38, 48, 4.16, 1.09, 22.72, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'FT', 7, 9.34, 48, 5.91, 2.47, 29.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'IM', NULL, 4.61, 47, 0.15, 4.31, 4.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'RT', NULL, 72.97, 59, 7.14, 56.68, 84.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 1, 3.91, 58, 3.53, 0.62, 21.08, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 2, 20.03, 58, 6.40, 10.12, 35.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 3, 44.50, 58, 7.08, 31.11, 58.74, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 4, 15.93, 58, 4.71, 8.57, 27.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 5, 13.00, 58, 5.90, 5.00, 29.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 6, 2.63, 58, 1.95, 0.58, 11.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'FT', 7, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'IM', NULL, 4.35, 57, 0.09, 4.16, 4.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'RT', NULL, 98.75, 59, 1.28, 90.86, 99.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 1, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 2, 6.16, 56, 4.33, 1.44, 22.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 3, 15.33, 56, 5.29, 7.41, 29.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 4, 13.02, 56, 5.22, 5.61, 27.40, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 5, 41.56, 56, 8.63, 25.87, 59.17, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 6, 11.23, 56, 5.78, 3.81, 28.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'FT', 7, 12.69, 56, 4.19, 6.38, 23.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'IM', NULL, 4.33, 56, 0.11, 4.11, 4.55, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'RT', NULL, 93.61, 59, 3.79, 80.45, 98.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 1, 6.99, 58, 4.03, 2.12, 20.66, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 2, 13.87, 58, 4.87, 6.65, 26.69, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 3, 16.67, 58, 8.10, 5.86, 39.13, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 4, 18.08, 58, 4.46, 10.78, 28.74, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 5, 22.99, 58, 4.98, 14.54, 34.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 6, 19.62, 58, 5.70, 10.59, 33.48, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'FT', 7, 1.77, 58, 1.79, 0.23, 12.42, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'IM', NULL, 4.24, 57, 0.11, 4.03, 4.46, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'RT', NULL, 98.78, 59, 1.25, 91.06, 99.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 1, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 2, 7.39, 54, 4.75, 1.94, 24.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 3, 23.84, 54, 7.05, 12.56, 40.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 4, 22.44, 54, 6.81, 11.66, 38.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 5, 17.98, 54, 6.32, 8.49, 34.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 6, 15.53, 54, 6.60, 6.28, 33.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'FT', 7, 12.82, 54, 4.26, 6.40, 24.02, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'IM', NULL, 4.23, 54, 0.08, 4.06, 4.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'RT', NULL, 90.71, 59, 4.12, 78.59, 96.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 1, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 2, 3.10, 55, 2.11, 0.78, 11.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 3, 25.52, 55, 8.62, 12.13, 45.97, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 4, 20.94, 55, 5.76, 11.65, 34.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 5, 26.55, 55, 7.53, 14.29, 43.93, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 6, 16.44, 55, 5.11, 8.53, 29.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'FT', 7, 7.45, 55, 4.98, 1.85, 25.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'IM', NULL, 4.22, 55, 0.11, 4.00, 4.43, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'RT', NULL, 89.94, 59, 6.77, 66.64, 97.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 1, 0.00, 51, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 2, 0.30, 51, 0.31, 0.04, 2.40, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 3, 11.76, 51, 7.99, 2.76, 38.49, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 4, 9.29, 51, 3.68, 4.08, 19.77, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 5, 38.35, 51, 7.91, 24.11, 54.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 6, 19.10, 51, 8.09, 7.62, 40.34, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'FT', 7, 21.20, 51, 4.80, 13.13, 32.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'IM', NULL, 4.20, 51, 0.12, 3.96, 4.43, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'RT', NULL, 83.25, 59, 8.62, 59.04, 94.48, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 1, 6.52, 50, 3.49, 2.16, 18.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 2, 15.91, 50, 6.96, 6.24, 34.98, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 3, 4.52, 50, 3.39, 0.97, 18.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 4, 17.81, 50, 4.65, 10.27, 29.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 5, 30.57, 50, 8.49, 16.47, 49.58, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 6, 18.41, 50, 6.60, 8.54, 35.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'FT', 7, 6.26, 50, 3.24, 2.15, 16.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'IM', NULL, 4.17, 49, 0.13, 3.90, 4.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'RT', NULL, 84.07, 59, 7.42, 63.50, 94.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 1, 0.00, 54, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 2, 18.34, 54, 7.29, 7.80, 37.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 3, 23.78, 54, 7.20, 12.33, 40.90, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 4, 16.12, 54, 5.47, 7.87, 30.19, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 5, 32.09, 54, 6.80, 20.17, 46.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 6, 0.30, 54, 0.31, 0.04, 2.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'FT', 7, 9.37, 54, 3.37, 4.45, 18.66, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'IM', NULL, 4.11, 54, 0.13, 3.85, 4.37, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'RT', NULL, 91.04, 59, 4.47, 77.25, 96.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 1, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 2, 8.70, 57, 4.45, 3.01, 22.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 3, 18.99, 57, 7.85, 7.78, 39.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 4, 32.43, 57, 7.89, 18.92, 49.68, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 5, 25.48, 57, 5.55, 16.00, 38.04, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 6, 5.39, 57, 3.04, 1.69, 15.84, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'FT', 7, 9.01, 57, 4.98, 2.85, 25.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'IM', NULL, 4.10, 57, 0.10, 3.90, 4.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'RT', NULL, 97.22, 59, 2.08, 88.25, 99.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 1, 15.91, 53, 5.66, 7.49, 30.65, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 2, 22.30, 53, 7.86, 10.35, 41.64, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 3, 32.25, 53, 8.02, 18.56, 49.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 4, 28.04, 53, 8.10, 14.83, 46.58, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 5, 1.50, 53, 1.02, 0.38, 5.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 6, 0.00, 53, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'FT', 7, 0.00, 53, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'IM', NULL, 4.08, 52, 0.14, 3.80, 4.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'RT', NULL, 89.51, 59, 6.47, 68.23, 97.14, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 1, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 2, 15.06, 59, 5.96, 6.53, 31.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 3, 21.78, 59, 7.07, 10.82, 39.00, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 4, 29.06, 59, 7.97, 15.89, 47.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 5, 21.97, 59, 8.02, 9.94, 41.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 6, 7.19, 59, 4.52, 1.96, 23.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'FT', 7, 4.93, 59, 3.02, 1.41, 15.85, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'IM', NULL, 4.04, 59, 0.12, 3.81, 4.27, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'RT', NULL, 100.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 1, 16.12, 47, 11.31, 3.45, 50.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 2, 7.59, 47, 5.68, 1.58, 29.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 3, 13.93, 47, 6.94, 4.80, 34.18, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 4, 20.40, 47, 7.02, 9.69, 37.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 5, 23.33, 47, 5.79, 13.69, 36.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 6, 13.38, 47, 7.43, 4.07, 35.96, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'FT', 7, 5.26, 47, 3.21, 1.49, 16.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'IM', NULL, 4.02, 47, 0.13, 3.75, 4.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'RT', NULL, 73.90, 59, 7.97, 55.31, 86.62, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 1, 3.77, 55, 3.03, 0.73, 17.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 2, 2.06, 55, 0.97, 0.79, 5.24, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 3, 37.45, 55, 8.79, 22.01, 55.95, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 4, 32.61, 55, 6.43, 21.20, 46.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 5, 18.25, 55, 5.45, 9.69, 31.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 6, 5.86, 55, 3.19, 1.91, 16.58, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'FT', 7, 0.00, 55, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'IM', NULL, 3.93, 55, 0.10, 3.74, 4.13, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'RT', NULL, 95.63, 59, 2.91, 84.46, 98.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 1, 0.26, 57, 0.27, 0.03, 2.03, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 2, 14.99, 57, 7.39, 5.23, 36.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 3, 31.64, 57, 6.30, 20.53, 45.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 4, 28.47, 57, 10.91, 11.98, 53.79, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 5, 19.07, 57, 7.98, 7.72, 39.89, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 6, 3.09, 57, 2.13, 0.76, 11.68, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'FT', 7, 2.49, 57, 1.75, 0.60, 9.77, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'IM', NULL, 3.92, 57, 0.12, 3.68, 4.16, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'RT', NULL, 96.91, 59, 2.07, 88.68, 99.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 1, 9.74, 43, 5.55, 2.93, 27.83, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 2, 26.62, 43, 6.39, 15.79, 41.24, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 3, 33.04, 43, 9.77, 16.83, 54.60, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 4, 24.57, 43, 8.29, 11.67, 44.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 5, 2.46, 43, 2.46, 0.32, 16.62, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 6, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'FT', 7, 3.57, 43, 2.71, 0.75, 15.39, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'IM', NULL, 3.85, 42, 0.21, 3.42, 4.28, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'RT', NULL, 74.32, 59, 7.43, 57.03, 86.32, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 1, 6.92, 49, 3.40, 2.50, 17.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 2, 27.42, 49, 6.86, 15.89, 43.04, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 3, 38.11, 49, 7.42, 24.66, 53.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 4, 11.40, 49, 5.12, 4.44, 26.27, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 5, 10.36, 49, 3.90, 4.73, 21.18, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 6, 2.00, 49, 1.76, 0.33, 11.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'FT', 7, 3.79, 49, 2.79, 0.84, 15.49, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'IM', NULL, 3.84, 49, 0.18, 3.48, 4.20, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'RT', NULL, 81.51, 59, 7.58, 61.69, 92.35, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 1, 5.04, 54, 3.48, 1.22, 18.60, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 2, 24.38, 54, 5.93, 14.47, 38.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 3, 35.66, 54, 7.82, 21.87, 52.33, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 4, 17.42, 54, 8.69, 5.91, 41.48, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 5, 8.49, 54, 4.83, 2.59, 24.40, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 6, 7.51, 54, 3.44, 2.92, 17.97, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'FT', 7, 1.50, 54, 1.53, 0.19, 10.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'IM', NULL, 3.78, 54, 0.17, 3.45, 4.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'RT', NULL, 89.61, 59, 7.41, 63.67, 97.70, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 1, 1.86, 50, 1.91, 0.23, 13.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 2, 18.81, 50, 4.68, 11.13, 30.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 3, 34.20, 50, 9.46, 18.25, 54.75, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 4, 19.21, 50, 9.34, 6.63, 44.35, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 5, 13.34, 50, 4.78, 6.28, 26.11, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'FT', 7, 12.58, 50, 7.96, 3.25, 38.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'IM', NULL, 3.78, 50, 0.17, 3.43, 4.12, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'RT', NULL, 81.94, 59, 8.50, 58.96, 93.48, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 1, 8.28, 52, 4.66, 2.57, 23.63, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 2, 31.41, 52, 7.90, 18.00, 48.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 3, 23.81, 52, 7.80, 11.64, 42.56, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 4, 25.02, 52, 6.95, 13.69, 41.25, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 5, 9.25, 52, 3.39, 4.33, 18.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 6, 0.30, 52, 0.31, 0.04, 2.36, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'FT', 7, 1.93, 52, 1.96, 0.25, 13.59, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'IM', NULL, 3.63, 53, 0.12, 3.39, 3.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'RT', NULL, 90.49, 59, 4.50, 76.96, 96.44, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 1, 12.59, 50, 4.08, 6.40, 23.28, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 2, 47.05, 50, 8.07, 31.67, 63.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 3, 19.34, 50, 5.27, 10.85, 32.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 4, 15.63, 50, 6.09, 6.82, 31.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 5, 1.86, 50, 1.64, 0.31, 10.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'FT', 7, 3.53, 50, 2.60, 0.78, 14.54, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'IM', NULL, 3.61, 50, 0.12, 3.36, 3.86, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'RT', NULL, 87.49, 59, 7.45, 64.16, 96.47, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 1, 32.70, 45, 9.44, 16.98, 53.57, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 2, 28.56, 45, 7.94, 15.43, 46.68, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 3, 19.19, 45, 5.47, 10.44, 32.60, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 4, 11.94, 45, 6.20, 3.96, 30.80, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 5, 3.48, 45, 2.39, 0.85, 13.16, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 6, 2.34, 45, 2.36, 0.30, 16.07, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'FT', 7, 1.80, 45, 1.85, 0.22, 13.14, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'IM', NULL, 3.56, 45, 0.16, 3.25, 3.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'RT', NULL, 74.48, 59, 7.87, 56.03, 86.99, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 1, 32.98, 41, 11.31, 14.88, 58.06, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 2, 45.84, 41, 7.69, 31.16, 61.29, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 3, 14.83, 41, 7.38, 5.07, 36.21, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 4, 4.05, 41, 2.41, 1.19, 12.88, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 5, 0.00, 41, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 6, 0.00, 41, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'FT', 7, 2.30, 41, 2.32, 0.29, 16.01, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'IM', NULL, 3.52, 40, 0.10, 3.32, 3.71, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'RT', NULL, 76.00, 59, 5.32, 63.85, 85.03, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 1, 19.51, 44, 11.85, 5.02, 52.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 2, 38.71, 44, 9.71, 21.67, 59.05, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 3, 15.46, 44, 7.50, 5.44, 36.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 4, 20.64, 44, 6.70, 10.23, 37.23, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 5, 5.69, 44, 4.81, 0.98, 26.91, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'IM', NULL, 3.27, 44, 0.32, 2.63, 3.92, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'RT', NULL, 82.95, 59, 5.57, 68.87, 91.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 1, 11.66, 49, 6.23, 3.77, 30.81, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 2, 37.86, 49, 7.48, 24.33, 53.58, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 3, 34.46, 49, 8.23, 20.17, 52.26, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 4, 7.91, 49, 3.68, 3.02, 19.16, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 5, 6.14, 49, 3.29, 2.03, 17.09, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 6, 0.00, 49, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'FT', 7, 1.97, 49, 2.00, 0.25, 13.87, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'IM', NULL, 3.27, 49, 0.13, 3.01, 3.52, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'RT', NULL, 88.63, 59, 4.29, 76.87, 94.82, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 1, 13.53, 39, 7.53, 4.08, 36.53, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 2, 60.47, 39, 8.24, 43.23, 75.45, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 3, 17.73, 39, 9.55, 5.42, 44.78, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 4, 8.26, 39, 4.57, 2.59, 23.38, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 5, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 6, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'FT', 7, 0.00, 39, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'IM', NULL, 3.24, 39, 0.18, 2.88, 3.61, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'RT', NULL, 70.72, 59, 7.87, 53.03, 83.79, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 1, 38.09, 38, 10.02, 20.63, 59.28, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 2, 49.61, 38, 10.08, 30.30, 69.03, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 3, 5.39, 38, 5.46, 0.65, 33.31, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 4, 4.91, 38, 3.28, 1.23, 17.66, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 5, 0.00, 38, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 6, 0.00, 38, 0.00, NULL, NULL, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'FT', 7, 2.01, 38, 2.04, 0.25, 14.30, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'IM', NULL, 3.36, 38, 0.15, 3.05, 3.67, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'RT', NULL, 66.96, 59, 8.94, 47.44, 81.98, 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 2, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 3, 1.38, 46, 1.42, 0.17, 10.21, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 4, 3.61, 46, 3.56, 0.47, 22.74, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 5, 46.31, 46, 7.16, 32.57, 60.63, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 6, 25.10, 46, 6.01, 14.96, 38.96, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'FT', 7, 23.60, 46, 5.53, 14.27, 36.43, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'IM', NULL, 4.36, 47, 0.09, 4.18, 4.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'RT', NULL, 90.22, 51, 5.99, 70.25, 97.30, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 2, 3.46, 47, 3.16, 0.53, 19.44, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 3, 8.48, 47, 4.47, 2.83, 22.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 4, 10.87, 47, 4.39, 4.67, 23.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 5, 44.01, 47, 5.69, 33.06, 55.58, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 6, 23.48, 47, 5.49, 14.23, 36.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'FT', 7, 9.70, 47, 6.28, 2.47, 31.28, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'IM', NULL, 4.34, 49, 0.08, 4.19, 4.50, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'RT', NULL, 98.67, 50, 1.36, 90.20, 99.83, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 1, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 2, 0.00, 47, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 3, 10.52, 47, 3.50, 5.27, 19.90, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 4, 14.68, 47, 6.09, 6.08, 31.40, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 5, 54.06, 47, 6.44, 41.12, 66.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 6, 19.34, 47, 4.54, 11.77, 30.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'FT', 7, 1.39, 47, 1.43, 0.17, 10.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'IM', NULL, 4.09, 48, 0.12, 3.84, 4.33, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'RT', NULL, 94.36, 51, 3.26, 83.04, 98.28, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 1, 2.25, 49, 2.23, 0.30, 15.05, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 2, 6.59, 49, 3.60, 2.13, 18.63, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 3, 19.99, 49, 7.79, 8.58, 39.95, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 4, 23.35, 49, 5.54, 14.06, 36.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 5, 35.25, 49, 8.35, 20.69, 53.19, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 6, 7.92, 49, 6.12, 1.57, 31.72, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'FT', 7, 4.64, 49, 3.06, 1.20, 16.37, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'IM', NULL, 4.01, 50, 0.17, 3.67, 4.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'RT', NULL, 98.70, 51, 1.33, 90.40, 99.84, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 1, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 2, 13.16, 45, 5.38, 5.54, 28.13, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 3, 2.84, 45, 2.08, 0.64, 11.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 4, 35.30, 45, 7.04, 22.67, 50.39, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 5, 34.40, 45, 7.47, 21.20, 50.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 6, 14.29, 45, 4.57, 7.29, 26.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'FT', 7, 0.00, 45, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'IM', NULL, 4.00, 46, 0.08, 3.84, 4.16, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'RT', NULL, 90.70, 51, 4.37, 77.51, 96.50, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 1, 3.60, 45, 3.28, 0.55, 20.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 2, 6.59, 45, 4.00, 1.87, 20.70, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 3, 9.93, 45, 5.47, 3.11, 27.45, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 4, 33.40, 45, 4.95, 24.26, 43.99, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 5, 30.35, 45, 7.31, 17.84, 46.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 6, 12.53, 45, 4.86, 5.54, 25.93, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'FT', 7, 3.60, 45, 3.13, 0.60, 18.72, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'IM', NULL, 3.95, 46, 0.11, 3.72, 4.17, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'RT', NULL, 90.54, 51, 4.75, 75.84, 96.69, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 1, 8.26, 45, 4.32, 2.78, 22.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 2, 18.27, 45, 6.20, 8.82, 34.05, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 3, 4.07, 45, 2.92, 0.93, 16.08, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 4, 26.57, 45, 6.53, 15.56, 41.52, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 5, 35.52, 45, 8.17, 21.17, 53.06, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 6, 1.93, 45, 1.89, 0.26, 12.84, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'FT', 7, 5.38, 45, 3.78, 1.26, 20.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'IM', NULL, 3.93, 46, 0.15, 3.63, 4.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'RT', NULL, 83.92, 52, 6.65, 66.00, 93.34, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 1, 28.13, 40, 8.13, 14.79, 46.88, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 2, 14.27, 40, 5.97, 5.84, 30.88, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 3, 24.27, 40, 5.08, 15.48, 35.92, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 4, 15.89, 40, 5.31, 7.80, 29.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 5, 17.45, 40, 10.92, 4.36, 49.49, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 6, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'FT', 7, 0.00, 40, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'IM', NULL, 3.91, 40, 0.16, 3.58, 4.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'RT', NULL, 80.04, 51, 5.17, 67.66, 88.49, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 1, 6.39, 44, 3.58, 2.00, 18.57, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 2, 7.68, 44, 4.34, 2.36, 22.23, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 3, 14.74, 44, 5.99, 6.20, 31.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 4, 26.59, 44, 7.81, 13.91, 44.80, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 5, 30.98, 44, 6.54, 19.49, 45.41, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 6, 9.83, 44, 3.73, 4.46, 20.30, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'FT', 7, 3.79, 44, 3.26, 0.65, 19.27, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'IM', NULL, 3.89, 45, 0.10, 3.69, 4.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'RT', NULL, 84.50, 52, 5.49, 70.16, 92.67, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 1, 3.75, 44, 3.70, 0.49, 23.52, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 2, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 3, 4.22, 44, 3.19, 0.89, 17.77, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 4, 16.77, 44, 7.11, 6.72, 36.01, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 5, 57.70, 44, 8.22, 40.88, 72.91, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 6, 10.76, 44, 4.65, 4.34, 24.25, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'FT', 7, 6.80, 44, 3.46, 2.37, 17.98, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'IM', NULL, 3.85, 45, 0.14, 3.57, 4.12, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'RT', NULL, 86.79, 51, 6.11, 69.26, 95.04, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 1, 0.00, 37, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 2, 12.64, 37, 5.26, 5.22, 27.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 3, 13.62, 37, 6.68, 4.75, 33.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 4, 4.79, 37, 3.53, 1.04, 19.46, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 5, 34.28, 37, 7.77, 20.58, 51.21, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 6, 16.48, 37, 6.45, 7.09, 33.80, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'FT', 7, 18.19, 37, 8.52, 6.50, 41.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'IM', NULL, 3.77, 38, 0.21, 3.36, 4.19, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'RT', NULL, 71.19, 51, 5.70, 58.56, 81.20, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 1, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 2, 21.47, 43, 5.93, 11.85, 35.75, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 3, 25.63, 43, 7.55, 13.42, 43.40, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 4, 33.03, 43, 6.64, 21.20, 47.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 5, 10.77, 43, 4.12, 4.84, 22.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 6, 9.09, 43, 6.46, 2.03, 32.61, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'FT', 7, 0.00, 43, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'IM', NULL, 3.77, 43, 0.15, 3.46, 4.09, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'RT', NULL, 86.33, 51, 5.57, 70.98, 94.23, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 1, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 2, 26.16, 46, 5.16, 17.13, 37.77, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 3, 24.22, 46, 6.07, 14.11, 38.35, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 4, 18.88, 46, 5.39, 10.28, 32.11, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 5, 25.79, 46, 5.29, 16.61, 37.75, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 6, 0.00, 46, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'FT', 7, 4.95, 46, 3.35, 1.23, 17.92, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'IM', NULL, 3.67, 47, 0.14, 3.38, 3.96, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'RT', NULL, 92.69, 51, 3.67, 81.04, 97.41, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 1, 9.74, 30, 5.36, 3.01, 27.29, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 2, 46.57, 30, 8.70, 29.89, 64.06, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 3, 28.62, 30, 7.71, 15.64, 46.45, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 4, 9.93, 30, 6.09, 2.66, 30.76, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 5, 5.14, 30, 3.44, 1.26, 18.65, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 6, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'FT', 7, 0.00, 30, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'IM', NULL, 4.29, 31, 0.10, 4.08, 4.51, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'RT', NULL, 55.79, 52, 6.70, 42.24, 68.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 1, 43.71, 16, 12.83, 20.35, 70.24, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 2, 32.01, 16, 9.40, 15.79, 54.16, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 3, 9.41, 16, 6.72, 1.90, 35.79, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 4, 14.88, 16, 9.30, 3.52, 45.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 5, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 6, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'FT', 7, 0.00, 16, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'IM', NULL, 4.16, 17, 0.23, 3.67, 4.66, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'RT', NULL, 31.92, 50, 5.99, 21.22, 44.94, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 1, 33.28, 25, 10.32, 16.05, 56.55, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 2, 33.93, 25, 8.00, 19.73, 51.74, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 3, 30.33, 25, 9.73, 14.40, 52.97, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 4, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 5, 2.47, 25, 2.51, 0.29, 17.86, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 6, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'FT', 7, 0.00, 25, 0.00, NULL, NULL, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'IM', NULL, 3.92, 26, 0.21, 3.49, 4.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'RT', NULL, 50.34, 52, 6.74, 37.10, 63.53, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 1, 13.35, 33, 7.77, 3.77, 37.70, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 2, 20.56, 33, 5.64, 11.35, 34.35, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 3, 26.92, 33, 9.80, 11.78, 50.39, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 4, 9.64, 33, 4.95, 3.24, 25.36, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 5, 17.42, 33, 8.27, 6.14, 40.48, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 6, 7.13, 33, 5.51, 1.39, 29.51, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'FT', 7, 4.99, 33, 4.19, 0.86, 24.13, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'IM', NULL, 3.46, 34, 0.22, 3.02, 3.90, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'RT', NULL, 65.57, 51, 7.40, 49.64, 78.62, 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 1, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 2, 2.44, 61, 2.31, 0.36, 14.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 3, 1.09, 61, 1.08, 0.15, 7.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 4, 1.27, 61, 1.27, 0.17, 8.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 5, 53.16, 61, 6.82, 39.63, 66.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 6, 23.76, 61, 5.97, 13.88, 37.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'FT', 7, 18.28, 61, 5.30, 9.90, 31.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'IM', NULL, 4.41, 61, 0.09, 4.23, 4.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'RT', NULL, 97.80, 63, 1.54, 91.39, 99.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 1, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 2, 2.74, 61, 1.84, 0.70, 10.09, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 3, 3.71, 61, 2.60, 0.89, 14.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 4, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 5, 32.90, 61, 6.32, 21.66, 46.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 6, 33.57, 61, 7.62, 20.32, 50.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'FT', 7, 27.09, 61, 6.02, 16.81, 40.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'IM', NULL, 4.32, 60, 0.13, 4.06, 4.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'RT', NULL, 94.47, 65, 3.27, 83.03, 98.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 2, 2.39, 63, 2.26, 0.35, 14.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 3, 9.97, 63, 4.65, 3.79, 23.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 4, 16.90, 63, 5.62, 8.38, 31.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 5, 53.32, 63, 7.77, 37.97, 68.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 6, 11.60, 63, 4.38, 5.29, 23.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'FT', 7, 5.81, 63, 3.16, 1.91, 16.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'IM', NULL, 4.30, 63, 0.10, 4.10, 4.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'RT', NULL, 98.84, 64, 1.13, 92.25, 99.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 1, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 2, 1.29, 59, 1.33, 0.16, 9.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 3, 9.39, 59, 4.02, 3.87, 21.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 4, 13.81, 59, 4.00, 7.56, 23.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 5, 65.65, 59, 6.95, 50.77, 77.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 6, 7.39, 59, 3.94, 2.46, 20.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'FT', 7, 2.46, 59, 2.33, 0.36, 14.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'IM', NULL, 4.29, 58, 0.09, 4.11, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'RT', NULL, 96.17, 62, 2.71, 85.21, 99.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 2, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 3, 6.76, 63, 3.67, 2.22, 18.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 4, 6.76, 63, 3.10, 2.64, 16.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 5, 55.14, 63, 6.95, 41.21, 68.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 6, 29.55, 63, 6.23, 18.74, 43.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'FT', 7, 1.79, 63, 1.53, 0.32, 9.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'IM', NULL, 4.25, 63, 0.11, 4.03, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'RT', NULL, 100.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 1, 0.00, 63, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 2, 2.39, 63, 2.26, 0.35, 14.52, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 3, 4.38, 63, 3.13, 1.02, 16.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 4, 9.12, 63, 5.06, 2.87, 25.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 5, 20.44, 63, 5.60, 11.44, 33.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 6, 35.10, 63, 7.23, 22.28, 50.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'FT', 7, 28.57, 63, 7.30, 16.37, 44.99, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'IM', NULL, 4.22, 62, 0.12, 3.97, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'RT', NULL, 94.54, 65, 3.61, 81.08, 98.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 1, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 2, 3.13, 58, 2.28, 0.71, 12.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 3, 16.66, 58, 4.96, 8.91, 29.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 4, 15.76, 58, 4.90, 8.21, 28.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 5, 29.89, 58, 6.46, 18.69, 44.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 6, 15.27, 58, 4.91, 7.78, 27.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'FT', 7, 19.28, 58, 6.56, 9.31, 35.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'IM', NULL, 4.22, 58, 0.12, 3.97, 4.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'RT', NULL, 89.02, 63, 5.25, 73.48, 95.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 1, 0.00, 64, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 2, 10.93, 64, 3.76, 5.37, 20.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 3, 37.19, 64, 8.07, 22.90, 54.14, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 4, 19.96, 64, 5.30, 11.39, 32.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 5, 22.41, 64, 6.68, 11.82, 38.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 6, 7.36, 64, 4.41, 2.13, 22.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'FT', 7, 2.15, 64, 1.48, 0.54, 8.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'IM', NULL, 4.04, 63, 0.13, 3.78, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'RT', NULL, 100.00, 64, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 1, 7.65, 62, 3.67, 2.85, 18.96, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 2, 38.95, 62, 6.27, 27.35, 51.94, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 3, 32.89, 62, 6.60, 21.23, 47.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 4, 10.23, 62, 3.98, 4.57, 21.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 5, 9.20, 62, 4.24, 3.54, 21.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 6, 1.08, 62, 1.05, 0.15, 7.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'FT', 7, 0.00, 62, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'IM', NULL, 4.00, 61, 0.15, 3.71, 4.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'RT', NULL, 95.82, 64, 2.63, 86.07, 98.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 1, 3.87, 56, 2.92, 0.83, 16.23, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 2, 4.63, 56, 2.46, 1.57, 12.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 3, 29.24, 56, 8.74, 15.05, 49.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 4, 11.15, 56, 4.70, 4.62, 24.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 5, 42.27, 56, 8.46, 26.76, 59.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 6, 8.84, 56, 3.94, 3.52, 20.53, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'FT', 7, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'IM', NULL, 3.98, 56, 0.14, 3.70, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'RT', NULL, 88.99, 63, 4.26, 77.20, 95.08, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 1, 5.56, 53, 3.72, 1.40, 19.61, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 2, 8.55, 53, 3.98, 3.26, 20.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 3, 19.35, 53, 6.41, 9.52, 35.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 4, 8.12, 53, 4.43, 2.61, 22.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 5, 21.06, 53, 6.07, 11.37, 35.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 6, 20.86, 53, 5.87, 11.44, 34.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'FT', 7, 16.50, 53, 4.91, 8.81, 28.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'IM', NULL, 3.93, 52, 0.18, 3.57, 4.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'RT', NULL, 82.35, 64, 6.23, 66.45, 91.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 1, 5.69, 49, 2.92, 1.98, 15.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 2, 21.65, 49, 6.25, 11.64, 36.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 3, 32.50, 49, 6.23, 21.39, 46.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 4, 16.88, 49, 5.88, 8.04, 32.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 5, 17.53, 49, 5.62, 8.87, 31.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 6, 4.41, 49, 3.06, 1.06, 16.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'FT', 7, 1.34, 49, 1.34, 0.17, 9.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'IM', NULL, 3.72, 49, 0.13, 3.47, 3.98, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'RT', NULL, 77.55, 63, 7.80, 58.51, 89.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 1, 18.87, 50, 5.22, 10.50, 31.57, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 2, 15.12, 50, 5.91, 6.59, 31.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 3, 24.16, 50, 6.79, 13.14, 40.16, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 4, 26.46, 50, 7.85, 13.79, 44.74, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 5, 11.95, 50, 6.39, 3.85, 31.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 6, 0.00, 50, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'FT', 7, 3.44, 50, 2.51, 0.77, 14.02, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'IM', NULL, 3.56, 50, 0.10, 3.36, 3.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'RT', NULL, 78.88, 65, 7.01, 61.71, 89.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 1, 4.43, 50, 3.33, 0.95, 18.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 2, 22.48, 50, 4.57, 14.62, 32.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 3, 41.66, 50, 7.01, 28.57, 56.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 4, 14.18, 50, 5.11, 6.63, 27.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 5, 10.55, 50, 5.06, 3.86, 25.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 6, 5.36, 50, 3.56, 1.36, 18.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'FT', 7, 1.34, 50, 1.35, 0.18, 9.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'IM', NULL, 3.56, 50, 0.12, 3.32, 3.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'RT', NULL, 78.28, 63, 7.82, 58.97, 90.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 1, 0.29, 59, 0.31, 0.03, 2.52, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 2, 6.35, 59, 3.61, 1.98, 18.58, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 3, 28.29, 59, 7.02, 16.48, 44.10, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 4, 12.82, 59, 4.11, 6.58, 23.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 5, 34.41, 59, 7.08, 21.88, 49.56, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 6, 7.20, 59, 5.62, 1.42, 29.44, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'FT', 7, 10.64, 59, 3.38, 5.52, 19.51, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'IM', NULL, 4.63, 60, 0.07, 4.50, 4.77, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 21162, 'RT', NULL, 99.72, 61, 0.31, 97.50, 99.97, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 1, 6.01, 61, 3.70, 1.69, 19.17, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 2, 5.86, 61, 4.62, 1.15, 24.93, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 3, 20.20, 61, 7.32, 9.26, 38.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 4, 4.25, 61, 3.56, 0.77, 20.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 5, 43.04, 61, 9.27, 26.18, 61.68, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 6, 14.07, 61, 5.79, 5.91, 29.91, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'FT', 7, 6.58, 61, 3.51, 2.19, 18.10, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'IM', NULL, 4.52, 61, 0.11, 4.30, 4.75, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'RT', NULL, 100.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 1, 3.78, 59, 3.73, 0.50, 23.40, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 2, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 3, 8.68, 59, 7.14, 1.54, 36.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 4, 15.64, 59, 5.11, 7.88, 28.69, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 5, 57.74, 59, 7.79, 41.90, 72.13, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 6, 13.82, 59, 8.08, 3.96, 38.39, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'FT', 7, 0.33, 59, 0.36, 0.04, 2.87, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'IM', NULL, 4.14, 58, 0.13, 3.88, 4.40, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'RT', NULL, 93.71, 61, 3.61, 81.42, 98.06, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 1, 0.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 2, 3.38, 61, 3.62, 0.38, 24.27, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 3, 8.13, 61, 6.85, 1.40, 35.66, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 4, 10.69, 61, 4.56, 4.40, 23.73, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 5, 48.15, 61, 10.14, 29.18, 67.67, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 6, 19.92, 61, 9.22, 7.26, 44.14, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'FT', 7, 9.73, 61, 3.54, 4.59, 19.44, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'IM', NULL, 4.13, 61, 0.15, 3.84, 4.42, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'RT', NULL, 100.00, 61, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 1, 6.71, 59, 3.52, 2.28, 18.15, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 2, 3.44, 59, 3.68, 0.38, 24.72, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 3, 4.37, 59, 4.40, 0.55, 27.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 4, 7.61, 59, 6.11, 1.43, 31.91, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 5, 29.27, 59, 5.92, 18.93, 42.32, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 6, 29.76, 59, 6.69, 18.26, 44.56, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'FT', 7, 18.83, 59, 5.76, 9.84, 33.03, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'IM', NULL, 4.12, 59, 0.11, 3.89, 4.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'RT', NULL, 96.25, 62, 3.52, 78.53, 99.45, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 1, 0.00, 58, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 2, 12.57, 58, 7.34, 3.64, 35.38, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 3, 19.97, 58, 7.03, 9.37, 37.59, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 4, 26.40, 58, 6.15, 15.99, 40.33, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 5, 30.33, 58, 10.03, 14.41, 52.96, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 6, 10.41, 58, 3.20, 5.53, 18.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'FT', 7, 0.32, 58, 0.35, 0.04, 2.81, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'IM', NULL, 3.87, 58, 0.13, 3.61, 4.14, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'RT', NULL, 95.93, 62, 3.59, 78.98, 99.33, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 1, 0.00, 57, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 2, 13.56, 57, 5.13, 6.13, 27.37, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 3, 5.72, 57, 4.67, 1.06, 25.58, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 4, 23.54, 57, 7.45, 11.85, 41.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 5, 40.17, 57, 8.47, 24.89, 57.62, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 6, 13.27, 57, 8.14, 3.57, 38.70, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'FT', 7, 3.75, 57, 3.68, 0.50, 23.07, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'IM', NULL, 3.82, 57, 0.13, 3.56, 4.09, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'RT', NULL, 92.99, 62, 3.31, 82.76, 97.34, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 1, 11.71, 56, 4.17, 5.58, 22.94, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 2, 33.25, 56, 9.30, 17.71, 53.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 3, 22.44, 56, 6.27, 12.32, 37.34, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 4, 11.43, 56, 3.72, 5.82, 21.21, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 5, 20.81, 56, 11.44, 6.14, 51.38, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 6, 0.36, 56, 0.39, 0.04, 3.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'FT', 7, 0.00, 56, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'IM', NULL, 3.79, 57, 0.21, 3.37, 4.22, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'RT', NULL, 91.38, 61, 6.87, 64.92, 98.38, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 1, 4.27, 58, 3.87, 0.67, 22.90, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 2, 16.01, 58, 9.75, 4.27, 44.89, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 3, 21.27, 58, 8.19, 9.21, 41.84, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 4, 17.33, 58, 4.65, 9.87, 28.65, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 5, 36.62, 58, 7.11, 23.83, 51.62, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 6, 3.79, 58, 2.82, 0.83, 15.66, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'FT', 7, 0.70, 58, 0.55, 0.14, 3.34, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'IM', NULL, 3.60, 58, 0.16, 3.29, 3.92, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'RT', NULL, 87.68, 62, 7.15, 65.46, 96.39, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 1, 0.38, 41, 0.42, 0.04, 3.40, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 2, 19.50, 41, 6.75, 9.21, 36.63, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 3, 24.52, 41, 8.45, 11.43, 44.98, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 4, 21.31, 41, 8.49, 8.87, 42.96, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 5, 29.74, 41, 8.55, 15.62, 49.19, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 6, 4.13, 41, 3.39, 0.76, 19.58, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'FT', 7, 0.42, 41, 0.46, 0.05, 3.70, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'IM', NULL, 3.58, 40, 0.16, 3.26, 3.89, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'RT', NULL, 75.19, 61, 5.00, 63.94, 83.81, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 1, 3.57, 59, 3.57, 0.46, 22.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 2, 12.65, 59, 7.22, 3.77, 34.87, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 3, 40.56, 59, 6.48, 28.49, 53.89, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 4, 14.15, 59, 8.93, 3.64, 41.81, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 5, 28.76, 59, 5.60, 18.93, 41.10, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 6, 0.00, 59, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'FT', 7, 0.32, 59, 0.34, 0.04, 2.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'IM', NULL, 3.54, 59, 0.21, 3.13, 3.95, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'RT', NULL, 99.70, 60, 0.33, 97.36, 99.97, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 1, 5.40, 53, 5.10, 0.76, 29.72, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 2, 15.29, 53, 5.55, 7.10, 29.90, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 3, 28.84, 53, 7.60, 16.17, 46.01, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 4, 12.57, 53, 6.58, 4.14, 32.35, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 5, 31.03, 53, 6.37, 19.84, 44.98, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 6, 6.53, 53, 4.23, 1.71, 21.94, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'FT', 7, 0.34, 53, 0.37, 0.04, 2.94, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'IM', NULL, 3.40, 52, 0.18, 3.04, 3.75, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'RT', NULL, 91.95, 61, 3.07, 83.28, 96.32, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 1, 15.97, 48, 6.04, 7.14, 31.96, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 2, 26.86, 48, 9.10, 12.64, 48.24, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 3, 0.35, 48, 0.38, 0.04, 2.99, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 4, 1.48, 48, 1.09, 0.33, 6.33, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 5, 39.50, 48, 8.34, 24.44, 56.85, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 6, 6.73, 48, 4.37, 1.75, 22.63, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'FT', 7, 9.11, 48, 5.47, 2.59, 27.46, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'IM', NULL, 3.29, 47, 0.25, 2.79, 3.79, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'RT', NULL, 80.67, 61, 6.16, 65.43, 90.19, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 1, 11.27, 44, 5.04, 4.39, 25.99, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 2, 60.63, 44, 8.54, 42.82, 76.01, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 3, 19.69, 44, 6.50, 9.67, 35.96, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 4, 5.61, 44, 4.33, 1.13, 23.58, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 5, 2.80, 44, 1.57, 0.89, 8.45, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'FT', 7, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'IM', NULL, 4.11, 44, 0.23, 3.65, 4.58, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'RT', NULL, 64.05, 61, 7.76, 47.59, 77.75, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 1, 5.97, 50, 5.98, 0.74, 35.02, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 2, 3.74, 50, 3.42, 0.57, 20.78, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 3, 14.39, 50, 9.14, 3.65, 42.73, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 4, 9.00, 50, 4.89, 2.89, 24.71, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 5, 48.26, 50, 10.23, 29.06, 68.00, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 6, 14.00, 50, 6.01, 5.64, 30.75, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'FT', 7, 4.64, 50, 3.55, 0.96, 19.62, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'IM', NULL, 3.93, 49, 0.21, 3.50, 4.36, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'RT', NULL, 65.80, 62, 11.74, 40.39, 84.53, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 1, 0.84, 50, 0.71, 0.15, 4.50, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 2, 0.42, 50, 0.47, 0.05, 3.83, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 3, 0.47, 50, 0.52, 0.05, 4.21, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 4, 16.25, 50, 4.41, 9.18, 27.13, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 5, 44.08, 50, 12.41, 22.27, 68.44, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 6, 20.05, 50, 5.59, 11.07, 33.57, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'FT', 7, 17.89, 50, 9.01, 5.97, 42.76, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'IM', NULL, 3.79, 50, 0.15, 3.49, 4.10, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'RT', NULL, 66.66, 61, 7.53, 50.38, 79.74, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 1, 22.80, 40, 7.50, 11.09, 41.14, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 2, 23.19, 40, 15.13, 5.14, 62.72, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 3, 16.19, 40, 4.79, 8.64, 28.31, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 4, 0.48, 40, 0.56, 0.05, 4.80, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 5, 4.86, 40, 3.36, 1.16, 18.16, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 6, 19.45, 40, 8.60, 7.37, 42.28, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'FT', 7, 13.02, 40, 3.58, 7.32, 22.09, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'IM', NULL, 3.76, 40, 0.13, 3.50, 4.03, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'RT', NULL, 66.87, 60, 11.02, 42.73, 84.52, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 1, 13.12, 36, 9.16, 2.87, 43.56, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 2, 15.26, 36, 5.89, 6.66, 31.24, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 3, 17.20, 36, 11.83, 3.70, 52.86, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 4, 44.25, 36, 14.69, 19.16, 72.66, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 5, 10.18, 36, 7.11, 2.28, 35.45, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 6, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'FT', 7, 0.00, 36, 0.00, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'IM', NULL, 3.70, 35, 0.19, 3.32, 4.08, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'RT', NULL, 51.09, 61, 7.54, 36.35, 65.64, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 1, 5.18, 40, 4.49, 0.85, 25.80, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 2, 34.02, 40, 9.44, 18.05, 54.70, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 3, 23.14, 40, 11.91, 7.21, 53.85, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 4, 2.77, 40, 1.58, 0.86, 8.56, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 5, 8.94, 40, 5.47, 2.46, 27.66, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 6, 4.66, 40, 4.36, 0.67, 26.22, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'FT', 7, 21.29, 40, 14.19, 4.65, 59.99, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'IM', NULL, 3.56, 41, 0.34, 2.87, 4.25, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'RT', NULL, 55.20, 62, 9.08, 37.15, 71.98, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 1, 0.00, 84, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 2, 3.36, 84, 2.05, 0.98, 10.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 3, 8.26, 84, 3.37, 3.58, 17.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 4, 7.07, 84, 2.77, 3.18, 14.97, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 5, 62.05, 84, 5.93, 49.77, 72.95, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 6, 10.60, 84, 3.96, 4.91, 21.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'FT', 7, 8.68, 84, 2.96, 4.32, 16.64, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'IM', NULL, 4.48, 82, 0.06, 4.36, 4.60, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'RT', NULL, 97.71, 86, 1.61, 91.06, 99.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 1, 29.75, 68, 5.92, 19.40, 42.71, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 2, 25.06, 68, 5.41, 15.84, 37.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 3, 14.31, 68, 4.73, 7.18, 26.50, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 4, 6.53, 68, 3.03, 2.53, 15.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 5, 21.15, 68, 5.18, 12.61, 33.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 6, 0.00, 68, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'FT', 7, 3.20, 68, 2.19, 0.80, 11.92, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'IM', NULL, 4.23, 68, 0.12, 3.98, 4.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'RT', NULL, 77.46, 86, 4.66, 66.90, 85.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 1, 2.43, 85, 1.77, 0.56, 9.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 2, 4.49, 85, 2.48, 1.47, 12.93, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 3, 10.60, 85, 3.72, 5.15, 20.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 4, 12.28, 85, 3.57, 6.76, 21.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 5, 56.41, 85, 5.34, 45.65, 66.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 6, 5.91, 85, 2.42, 2.58, 13.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'FT', 7, 7.88, 85, 3.59, 3.10, 18.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'IM', NULL, 4.16, 85, 0.08, 4.01, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'RT', NULL, 98.54, 86, 1.44, 90.21, 99.80, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 1, 28.81, 78, 5.33, 19.43, 40.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 2, 25.15, 78, 5.18, 16.27, 36.75, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 3, 12.89, 78, 4.17, 6.60, 23.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 4, 15.70, 78, 4.56, 8.57, 27.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 5, 13.61, 78, 3.78, 7.66, 23.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 6, 2.15, 78, 1.51, 0.52, 8.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'FT', 7, 1.69, 78, 1.61, 0.25, 10.55, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'IM', NULL, 4.14, 77, 0.12, 3.91, 4.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'RT', NULL, 89.23, 86, 3.53, 79.95, 94.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 1, 2.19, 86, 1.66, 0.48, 9.45, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 2, 15.30, 86, 4.43, 8.38, 26.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 3, 11.90, 86, 3.39, 6.64, 20.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 4, 18.65, 86, 3.91, 12.07, 27.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 5, 40.10, 86, 5.02, 30.64, 50.36, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 6, 8.85, 86, 2.93, 4.50, 16.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'FT', 7, 3.01, 86, 2.89, 0.43, 18.12, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'IM', NULL, 4.14, 86, 0.10, 3.95, 4.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'RT', NULL, 100.00, 86, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 1, 0.00, 83, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 2, 9.89, 83, 3.69, 4.59, 20.01, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 3, 20.61, 83, 4.75, 12.71, 31.63, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 4, 14.91, 83, 3.85, 8.74, 24.28, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 5, 43.43, 83, 5.29, 33.35, 54.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 6, 6.90, 83, 2.91, 2.93, 15.42, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'FT', 7, 4.25, 83, 3.10, 0.97, 16.78, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'IM', NULL, 4.13, 81, 0.10, 3.94, 4.33, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'RT', NULL, 96.79, 85, 2.26, 87.67, 99.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 1, 0.89, 81, 0.88, 0.12, 6.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 2, 10.40, 81, 3.76, 4.94, 20.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 3, 12.20, 81, 3.27, 7.04, 20.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 4, 13.16, 81, 3.82, 7.23, 22.75, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 5, 57.08, 81, 5.52, 45.94, 67.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 6, 3.07, 81, 1.77, 0.96, 9.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'FT', 7, 3.19, 81, 3.05, 0.46, 19.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'IM', NULL, 4.13, 81, 0.09, 3.95, 4.31, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'RT', NULL, 94.39, 86, 3.21, 83.43, 98.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 1, 0.88, 68, 0.87, 0.12, 6.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 2, 13.43, 68, 4.47, 6.71, 25.06, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 3, 11.97, 68, 4.28, 5.69, 23.43, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 4, 13.54, 68, 4.18, 7.13, 24.21, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 5, 54.94, 68, 6.22, 42.48, 66.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 6, 2.00, 68, 1.92, 0.29, 12.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'FT', 7, 3.24, 68, 2.18, 0.83, 11.83, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'IM', NULL, 4.09, 68, 0.09, 3.91, 4.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'RT', NULL, 80.30, 85, 4.41, 70.06, 87.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 1, 1.87, 73, 1.86, 0.25, 12.56, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 2, 13.98, 73, 4.24, 7.45, 24.70, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 3, 9.22, 73, 3.60, 4.13, 19.32, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 4, 14.24, 73, 4.04, 7.91, 24.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 5, 46.63, 73, 5.51, 35.98, 57.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 6, 8.66, 73, 2.92, 4.35, 16.51, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'FT', 7, 5.40, 73, 3.70, 1.33, 19.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'IM', NULL, 4.07, 73, 0.11, 3.84, 4.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'RT', NULL, 86.02, 85, 5.11, 72.53, 93.48, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 1, 6.20, 82, 2.74, 2.52, 14.44, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 2, 30.70, 82, 5.33, 21.20, 42.18, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 3, 16.82, 82, 4.01, 10.26, 26.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 4, 18.00, 82, 5.01, 10.05, 30.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 5, 25.84, 82, 4.28, 18.27, 35.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 6, 2.44, 82, 1.75, 0.57, 9.79, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'FT', 7, 0.00, 82, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'IM', NULL, 3.88, 81, 0.09, 3.70, 4.07, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'RT', NULL, 94.36, 86, 2.56, 86.52, 97.76, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 1, 18.22, 82, 4.39, 11.03, 28.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 2, 27.99, 82, 5.05, 19.10, 39.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 3, 15.14, 82, 4.90, 7.71, 27.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 4, 14.17, 82, 4.26, 7.60, 24.89, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 5, 19.47, 82, 4.69, 11.77, 30.47, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 6, 1.77, 82, 1.25, 0.43, 7.02, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'FT', 7, 3.23, 82, 2.13, 0.85, 11.46, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'IM', NULL, 3.81, 81, 0.09, 3.63, 4.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'RT', NULL, 95.22, 86, 2.24, 88.23, 98.15, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 1, 7.52, 82, 3.18, 3.17, 16.82, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 2, 23.32, 82, 4.84, 15.08, 34.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 3, 23.36, 82, 5.62, 14.03, 36.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 4, 18.98, 82, 4.41, 11.69, 29.30, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 5, 21.48, 82, 4.48, 13.89, 31.69, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 6, 2.63, 82, 1.85, 0.64, 10.20, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'FT', 7, 2.70, 82, 1.86, 0.68, 10.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'IM', NULL, 3.81, 82, 0.11, 3.58, 4.03, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'RT', NULL, 95.53, 86, 2.10, 88.91, 98.27, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 1, 30.97, 79, 5.74, 20.82, 43.35, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 2, 29.62, 79, 5.03, 20.66, 40.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 3, 21.20, 79, 4.59, 13.47, 31.73, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 4, 8.11, 79, 3.09, 3.72, 16.77, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 5, 8.45, 79, 2.96, 4.13, 16.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 6, 0.00, 79, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'FT', 7, 1.66, 79, 1.66, 0.22, 11.37, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'IM', NULL, 3.79, 78, 0.13, 3.54, 4.04, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'RT', NULL, 91.62, 85, 4.58, 76.94, 97.29, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 1, 16.99, 60, 5.73, 8.32, 31.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 2, 28.61, 60, 6.21, 17.91, 42.40, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 3, 21.20, 60, 5.44, 12.30, 34.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 4, 16.82, 60, 5.66, 8.26, 31.24, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 5, 14.88, 60, 4.42, 8.01, 26.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 6, 1.50, 60, 1.48, 0.20, 10.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'FT', 7, 0.00, 60, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'IM', NULL, 3.62, 60, 0.15, 3.32, 3.91, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'RT', NULL, 68.82, 86, 5.49, 57.03, 78.59, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 1, 13.61, 72, 4.57, 6.76, 25.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 2, 28.19, 72, 5.22, 19.01, 39.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 3, 25.46, 72, 5.27, 16.42, 37.26, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 4, 18.16, 72, 4.69, 10.58, 29.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 5, 14.58, 72, 4.63, 7.52, 26.39, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 6, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'FT', 7, 0.00, 72, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'IM', NULL, 3.61, 72, 0.12, 3.38, 3.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'RT', NULL, 81.54, 86, 5.71, 67.49, 90.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 1, 15.53, 79, 4.49, 8.51, 26.65, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 2, 29.37, 79, 5.56, 19.61, 41.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 3, 24.13, 79, 4.84, 15.82, 35.00, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 4, 10.66, 79, 3.40, 5.54, 19.53, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 5, 14.05, 79, 3.94, 7.86, 23.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 6, 2.79, 79, 1.92, 0.70, 10.49, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'FT', 7, 3.47, 79, 2.27, 0.92, 12.17, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'IM', NULL, 3.60, 78, 0.10, 3.40, 3.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'RT', NULL, 91.04, 86, 3.91, 79.67, 96.34, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 1, 8.34, 44, 4.20, 2.92, 21.62, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 2, 30.61, 44, 7.02, 18.46, 46.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 3, 5.09, 44, 2.98, 1.52, 15.67, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 4, 9.66, 44, 4.86, 3.37, 24.72, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 5, 43.42, 44, 7.09, 30.02, 57.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 6, 0.00, 44, 0.00, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'FT', 7, 2.88, 44, 2.60, 0.45, 16.22, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'IM', NULL, 4.06, 44, 0.16, 3.75, 4.38, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'RT', NULL, 52.37, 86, 6.25, 40.05, 64.41, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 1, 14.01, 35, 6.52, 5.15, 32.84, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 2, 25.46, 35, 8.84, 11.71, 46.81, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 3, 11.44, 35, 5.56, 4.07, 28.25, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 4, 2.12, 35, 2.12, 0.27, 14.66, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 5, 34.87, 35, 7.92, 20.86, 52.10, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 6, 2.12, 35, 2.13, 0.27, 14.86, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'FT', 7, 9.96, 35, 6.90, 2.26, 34.58, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'IM', NULL, 3.67, 35, 0.19, 3.30, 4.05, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'RT', NULL, 40.10, 85, 5.66, 29.53, 51.68, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 1, 77.39, 9, 14.72, 32.98, 95.97, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 2, 8.12, 9, 8.00, 0.74, 51.16, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 3, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 4, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 5, 14.49, 9, 13.25, 1.42, 66.60, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 6, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'FT', 7, 0.00, 9, 0.00, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'IM', NULL, 3.44, 9, 0.44, 2.43, 4.45, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'RT', NULL, 10.49, 85, 3.33, 5.46, 19.19, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 2, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 3, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 4, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 5, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 6, 17.65, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'IM', NULL, 4.47, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 1, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 2, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 3, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 4, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 5, 25.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'FT', 7, 0.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'IM', NULL, 4.35, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 1, 28.57, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 2, 33.33, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 3, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 4, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 5, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 6, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'IM', NULL, 4.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 1, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 2, 31.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 3, 37.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 4, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 5, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 6, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'IM', NULL, 4.19, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'RT', NULL, 76.19, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 2, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 3, 9.52, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 4, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 5, 47.62, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 6, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'FT', 7, 4.76, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'IM', NULL, 4.14, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 1, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 2, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 3, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 4, 38.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 5, 19.05, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 6, 14.29, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'FT', 7, 0.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'IM', NULL, 4.10, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'RT', NULL, 100.00, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 1, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 2, 42.11, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 3, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 4, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 5, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'IM', NULL, 4.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 1, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 2, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 3, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 4, 5.56, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 5, 27.78, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 6, 33.33, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'FT', 7, 11.11, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'IM', NULL, 4.00, 18, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'RT', NULL, 85.71, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 3, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 5, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 6, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'IM', NULL, 3.95, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 1, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 2, 33.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 3, 26.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 4, 13.33, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 5, 20.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 6, 6.67, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'FT', 7, 0.00, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'IM', NULL, 3.80, 15, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'RT', NULL, 71.43, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 1, 10.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 2, 15.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 3, 40.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 4, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 5, 20.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 6, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'FT', 7, 5.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'IM', NULL, 3.80, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'RT', NULL, 95.24, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 1, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 2, 52.63, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 3, 21.05, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 4, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 5, 26.32, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 6, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'FT', 7, 0.00, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'IM', NULL, 3.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 1, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 2, 15.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 3, 5.26, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 4, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 5, 36.84, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 6, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'FT', 7, 10.53, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'IM', NULL, 3.79, 19, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'RT', NULL, 90.48, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 1, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 2, 25.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 3, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 4, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 5, 50.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 6, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'FT', 7, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'IM', NULL, 3.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 1, 6.25, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 2, 25.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 3, 37.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 4, 12.50, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 5, 18.75, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 6, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'FT', 7, 0.00, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'IM', NULL, 3.56, 16, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'RT', NULL, 80.00, 20, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 1, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 2, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 3, 35.29, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 4, 23.53, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 6, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'FT', 7, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'IM', NULL, 3.47, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 1, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 2, 35.29, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 3, 41.18, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 4, 11.76, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 5, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 6, 5.88, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'FT', 7, 0.00, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'IM', NULL, 3.41, 17, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'RT', NULL, 80.95, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 1, 41.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 2, 33.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 3, 16.67, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 4, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 5, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 6, 8.33, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'FT', 7, 0.00, 12, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'IM', NULL, 2.86, 14, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'RT', NULL, 66.67, 21, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 2, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 3, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 4, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 5, 47.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 6, 21.74, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'FT', 7, 21.74, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'IM', NULL, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21340, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 1, 18.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 2, 9.09, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 3, 22.73, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 4, 22.73, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 5, 27.27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'IM', NULL, 4.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21341, 'RT', NULL, 95.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 2, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 3, 27.27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 4, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 5, 45.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 6, 13.64, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'FT', 7, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'IM', NULL, 4.30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21342, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 2, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 3, 3.10, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 4, 7.15, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 5, 54.25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 6, 18.99, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'FT', 7, 16.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'IM', NULL, 4.29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21343, 'RT', NULL, 97.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 1, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 2, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 3, 33.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 4, 10.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 6, 16.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'IM', NULL, 4.13, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21344, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 1, 10.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 2, 13.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 3, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 4, 26.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'IM', NULL, 4.07, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21345, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 2, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 3, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 4, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 5, 46.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 6, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'FT', 7, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'IM', NULL, 4.07, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21346, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 1, 23.81, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 2, 23.81, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 3, 28.57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 4, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 5, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 6, 4.76, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'IM', NULL, 4.05, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21347, 'RT', NULL, 91.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 2, 3.40, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 3, 9.41, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 4, 4.13, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 5, 51.87, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 6, 22.26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'FT', 7, 8.93, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'IM', NULL, 4.05, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21348, 'RT', NULL, 90.75, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 1, 3.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 2, 27.59, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 3, 34.48, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 4, 31.03, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 5, 3.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'IM', NULL, 4.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21349, 'RT', NULL, 96.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 2, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 3, 38.10, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 4, 14.29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 5, 28.57, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 6, 9.52, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'IM', NULL, 4.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21350, 'RT', NULL, 91.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 1, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 2, 16.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 3, 23.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 4, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 5, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 6, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'IM', NULL, 3.93, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21351, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 1, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 2, 35.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 3, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 4, 10.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 5, 5.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'IM', NULL, 3.90, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21352, 'RT', NULL, 95.65, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 1, 13.04, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 2, 21.74, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 3, 30.43, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 4, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 5, 26.09, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 6, 4.35, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'IM', NULL, 3.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21353, 'RT', NULL, 76.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 1, 7.47, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 2, 19.88, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 3, 14.22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 4, 27.14, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 5, 11.11, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 6, 9.52, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'FT', 7, 10.65, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'IM', NULL, 3.83, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21354, 'RT', NULL, 79.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 2, 31.82, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 3, 36.36, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 4, 18.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 5, 13.64, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'IM', NULL, 3.77, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21355, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 2, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 3, 25.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 4, 37.50, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 5, 37.50, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'IM', NULL, 3.76, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21356, 'RT', NULL, 70.83, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 1, 3.26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 2, 11.52, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 3, 43.59, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 4, 19.17, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 5, 19.98, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 6, 2.46, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'IM', NULL, 3.74, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21357, 'RT', NULL, 80.50, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 2, 18.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 3, 13.64, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 4, 18.18, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 5, 31.82, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 6, 13.64, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'FT', 7, 4.55, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'IM', NULL, 3.71, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21358, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 1, 6.67, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 2, 20.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 3, 40.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 4, 30.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 5, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 6, 3.33, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'IM', NULL, 3.70, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21359, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 1, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 2, 10.34, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 3, 17.24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 4, 41.38, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 5, 27.59, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 6, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'FT', 7, 3.45, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'IM', NULL, 3.70, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21360, 'RT', NULL, 100.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 1, 5.88, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 2, 11.76, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 3, 23.53, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 4, 17.65, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 5, 35.29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 6, 5.88, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'FT', 7, 0.00, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'IM', NULL, 3.68, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21361, 'RT', NULL, 79.17, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.00', 21362, 'FT', 1, 7.38, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO task_ratings (onetsoc_code, task_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domai