CREATE TABLE skills (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.a', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.b', 'LV', 4.88, 8, 0.23, 4.43, 5.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.c', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.d', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.d', 'LV', 4.88, 8, 0.13, 4.63, 5.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.e', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.f', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.1.f', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.a', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.a', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.b', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.A.2.d', 'LV', 5.50, 8, 0.19, 5.13, 5.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.a', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.b', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.b', 'LV', 5.12, 8, 0.23, 4.68, 5.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.c', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.c', 'LV', 5.00, 8, 0.00, 5.00, 5.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.d', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.f', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.1.f', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.2.i', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.2.i', 'LV', 5.00, 8, 0.19, 4.63, 5.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.c', 'LV', 0.62, 8, 0.63, 0.00, 1.85, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.e', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.g', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.g', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.h', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.h', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.m', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.3.m', 'LV', 1.00, 8, 0.38, 0.26, 1.74, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.e', 'IM', 4.50, 8, 0.19, 4.13, 4.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.e', 'LV', 5.75, 8, 0.16, 5.43, 6.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.g', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.g', 'LV', 5.38, 8, 0.18, 5.02, 5.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.h', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.4.h', 'LV', 5.12, 8, 0.13, 4.88, 5.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.a', 'LV', 4.75, 8, 0.31, 4.14, 5.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.b', 'LV', 5.50, 8, 0.19, 5.13, 5.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.c', 'LV', 4.75, 8, 0.25, 4.26, 5.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.d', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.B.5.d', 'LV', 5.38, 8, 0.18, 5.02, 5.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.c', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.c', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.f', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.1.f', 'LV', 1.88, 8, 0.23, 1.43, 2.32, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.A.2.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.c', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.2.i', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.2.i', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.a', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.a', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.c', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.e', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.g', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.g', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.h', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.h', 'LV', 1.00, 8, 0.00, 1.00, 1.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.m', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.3.m', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.g', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.g', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.h', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.4.h', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.b', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.c', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.c', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.d', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.B.5.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.e', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.e', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.f', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.1.f', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.A.2.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.1.f', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.2.i', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.2.i', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.a', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.a', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.e', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.g', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.g', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.h', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.h', 'LV', 1.75, 8, 0.16, 1.43, 2.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.k', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.k', 'LV', 1.38, 8, 0.18, 1.02, 1.73, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.m', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.3.m', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.g', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.g', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.h', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.4.h', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.b', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.B.5.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.1.f', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.A.2.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.c', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.f', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.2.i', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.2.i', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.a', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.a', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.c', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.e', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.g', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.g', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.m', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.3.m', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.g', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.4.h', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.b', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.c', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.c', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.B.5.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.e', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.f', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.1.f', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.A.2.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.c', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.e', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.f', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.2.i', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.b', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.e', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.g', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.m', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.3.m', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.h', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.4.h', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.c', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.c', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.B.5.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.1.f', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.A.2.d', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.c', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.c', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.e', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.f', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.1.f', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.2.i', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.a', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.a', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.b', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.e', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.g', 'LV', 1.75, 8, 0.41, 0.94, 2.56, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.h', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.h', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.m', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.3.m', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.h', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.b', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.B.5.d', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.e', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.e', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.f', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.1.f', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.b', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.b', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.A.2.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.2.i', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.2.i', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.a', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.a', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.b', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.b', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.c', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.e', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.e', 'LV', 0.62, 8, 0.32, 0.00, 1.26, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.g', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.g', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.h', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.h', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.k', 'LV', 1.25, 8, 0.25, 0.76, 1.74, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.m', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.3.m', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.g', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.h', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.4.h', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.b', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.c', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3012.00', '2.B.5.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.f', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.1.f', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.A.2.d', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.d', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.d', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.f', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.1.f', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.2.i', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.2.i', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.a', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.b', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.b', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.c', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.c', 'LV', 2.00, 8, 0.50, 1.02, 2.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.e', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.e', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.g', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.g', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.h', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.h', 'LV', 1.62, 8, 0.42, 0.80, 2.45, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.j', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.j', 'LV', 0.62, 8, 0.32, 0.00, 1.26, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.k', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.k', 'LV', 2.50, 8, 0.46, 1.59, 3.41, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.l', 'IM', 1.50, 8, 0.27, 1.00, 2.02, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.l', 'LV', 0.75, 8, 0.41, 0.00, 1.56, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.m', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.3.m', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.g', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.h', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.b', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.b', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.B.5.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.a', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.a', 'LV', 4.38, 8, 0.26, 3.86, 4.89, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.b', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.b', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.d', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.d', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.f', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.1.f', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.b', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.c', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.d', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.A.2.d', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.b', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.b', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.e', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.f', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.1.f', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.2.i', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.a', 'IM', 1.75, 8, 0.37, 1.03, 2.47, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.a', 'LV', 1.12, 8, 0.52, 0.11, 2.14, 'Y', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.b', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.b', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.c', 'IM', 1.25, 8, 0.25, 1.00, 1.74, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.c', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.e', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.e', 'LV', 1.62, 8, 0.60, 0.46, 2.79, 'Y', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.g', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.g', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.k', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.k', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.m', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.3.m', 'LV', 1.50, 8, 0.42, 0.67, 2.33, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.e', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.e', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.g', 'IM', 3.00, 8, 0.33, 2.36, 3.64, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.g', 'LV', 3.25, 8, 0.53, 2.22, 4.28, 'Y', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.h', 'IM', 3.00, 8, 0.38, 2.26, 3.74, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.4.h', 'LV', 3.25, 8, 0.56, 2.15, 4.35, 'Y', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.b', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.b', 'LV', 3.62, 8, 0.38, 2.89, 4.36, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.c', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.c', 'LV', 2.12, 8, 0.40, 1.34, 2.91, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.d', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.00', '2.B.5.d', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.b', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.c', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.e', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.f', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.1.f', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.a', 'LV', 4.75, 8, 0.25, 4.26, 5.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.b', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.c', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.A.2.d', 'LV', 4.50, 8, 0.27, 3.98, 5.02, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.b', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.c', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.e', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.f', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.1.f', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.2.i', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.2.i', 'LV', 4.38, 8, 0.26, 3.86, 4.89, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.a', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.a', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.b', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.e', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.g', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.g', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.m', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.3.m', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.e', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.e', 'LV', 4.62, 8, 0.26, 4.11, 5.14, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.g', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.h', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.4.h', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.a', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.b', 'LV', 5.00, 8, 0.19, 4.63, 5.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.c', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.B.5.d', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.a', 'IM', 4.00, 8, 0.27, 3.48, 4.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.b', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.c', 'IM', 3.62, 8, 0.32, 2.99, 4.26, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.c', 'LV', 3.88, 8, 0.30, 3.30, 4.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.d', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.d', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.e', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.e', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.f', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.1.f', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.a', 'IM', 4.00, 8, 0.33, 3.36, 4.64, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.a', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.b', 'IM', 3.75, 8, 0.31, 3.14, 4.36, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.b', 'LV', 3.88, 8, 0.30, 3.30, 4.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.c', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.c', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.d', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.A.2.d', 'LV', 4.00, 8, 0.33, 3.36, 4.64, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.a', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.a', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.b', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.c', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.f', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.1.f', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.2.i', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.2.i', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.a', 'IM', 2.00, 8, 0.42, 1.17, 2.83, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.a', 'LV', 1.62, 8, 0.68, 0.29, 2.96, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.b', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.b', 'LV', 1.38, 8, 0.53, 0.33, 2.42, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.e', 'IM', 1.75, 8, 0.37, 1.03, 2.47, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.e', 'LV', 1.12, 8, 0.61, 0.00, 2.32, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.g', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.g', 'LV', 1.50, 8, 0.46, 0.59, 2.41, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.m', 'IM', 1.50, 8, 0.38, 1.00, 2.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.3.m', 'LV', 0.75, 8, 0.53, 0.00, 1.78, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.e', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.e', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.g', 'IM', 3.38, 8, 0.38, 2.64, 4.11, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.g', 'LV', 3.75, 8, 0.45, 2.86, 4.64, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.h', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.4.h', 'LV', 3.75, 8, 0.37, 3.03, 4.47, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.b', 'IM', 2.75, 8, 0.41, 1.94, 3.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.b', 'LV', 3.00, 8, 0.65, 1.72, 4.28, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.c', 'IM', 2.25, 8, 0.41, 1.44, 3.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.c', 'LV', 2.12, 8, 0.58, 0.99, 3.26, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.d', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.03', '2.B.5.d', 'LV', 3.38, 8, 0.32, 2.74, 4.01, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.e', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.1.f', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.A.2.d', 'LV', 4.88, 8, 0.13, 4.63, 5.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.c', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.1.f', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.2.i', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.a', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.a', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.b', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.c', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.c', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.e', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.g', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.h', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.h', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.j', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.j', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.k', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.k', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.l', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.l', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.m', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.3.m', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.e', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.e', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.g', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.g', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.h', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.4.h', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.B.5.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.c', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.c', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.f', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.1.f', 'LV', 2.25, 8, 0.25, 1.76, 2.74, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.c', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.A.2.d', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.f', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.2.i', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.a', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.a', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.b', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.b', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.c', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.c', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.e', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.e', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.g', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.h', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.h', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.j', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.j', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.k', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.k', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.l', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.l', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.m', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.3.m', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.e', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.e', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.g', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.h', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.4.h', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.b', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.b', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.c', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.B.5.d', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.b', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.b', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.d', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.e', 'LV', 3.75, 8, 0.31, 3.14, 4.36, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.f', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.1.f', 'LV', 2.50, 8, 0.57, 1.39, 3.61, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.a', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.b', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.c', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.d', 'IM', 3.88, 8, 0.12, 3.63, 4.12, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.A.2.d', 'LV', 4.38, 8, 0.38, 3.64, 5.11, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.b', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.c', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.d', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.e', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.f', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.1.f', 'LV', 3.00, 8, 0.42, 2.17, 3.83, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.2.i', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.2.i', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.a', 'IM', 2.00, 8, 0.33, 1.36, 2.64, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.a', 'LV', 2.38, 8, 0.73, 0.94, 3.81, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.b', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.b', 'LV', 1.88, 8, 0.58, 0.74, 3.01, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.c', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.c', 'LV', 2.62, 8, 0.32, 1.99, 3.26, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.e', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.e', 'LV', 1.25, 8, 0.45, 0.36, 2.14, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.g', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.g', 'LV', 3.50, 8, 0.42, 2.67, 4.33, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.h', 'IM', 2.88, 8, 0.30, 2.30, 3.45, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.h', 'LV', 2.88, 8, 0.52, 1.86, 3.89, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.j', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.j', 'LV', 2.75, 8, 0.56, 1.65, 3.85, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.k', 'IM', 2.88, 8, 0.12, 2.63, 3.12, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.k', 'LV', 3.12, 8, 0.40, 2.34, 3.91, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.l', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.l', 'LV', 3.00, 8, 0.50, 2.02, 3.98, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.m', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.3.m', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.e', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.g', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.h', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.4.h', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.b', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.b', 'LV', 3.75, 8, 0.37, 3.03, 4.47, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.c', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.c', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.B.5.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.a', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.a', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.b', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.c', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.d', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.d', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.e', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.e', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.f', 'IM', 3.00, 8, 0.33, 2.36, 3.64, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.1.f', 'LV', 3.50, 8, 0.38, 2.76, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.a', 'LV', 3.88, 8, 0.30, 3.30, 4.45, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.b', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.d', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.A.2.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.a', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.b', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.c', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.1.f', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.2.i', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.2.i', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.a', 'IM', 2.12, 8, 0.35, 1.44, 2.81, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.a', 'LV', 2.00, 8, 0.63, 0.77, 3.23, 'Y', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.b', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.b', 'LV', 1.50, 8, 0.53, 0.45, 2.55, 'Y', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.c', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.c', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.e', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.e', 'LV', 1.62, 8, 0.50, 0.65, 2.60, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.g', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.g', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.h', 'IM', 3.12, 8, 0.30, 2.55, 3.70, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.h', 'LV', 3.38, 8, 0.32, 2.74, 4.01, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.j', 'IM', 1.50, 8, 0.38, 1.00, 2.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.j', 'LV', 0.75, 8, 0.53, 0.00, 1.78, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.k', 'IM', 2.25, 8, 0.31, 1.64, 2.86, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.k', 'LV', 2.00, 8, 0.42, 1.17, 2.83, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.l', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.l', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.m', 'IM', 2.62, 8, 0.26, 2.11, 3.14, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.3.m', 'LV', 3.12, 8, 0.35, 2.44, 3.81, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.e', 'LV', 3.88, 8, 0.35, 3.19, 4.56, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.g', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.g', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.h', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.4.h', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.a', 'LV', 3.75, 8, 0.31, 3.14, 4.36, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.b', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.b', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.c', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.c', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.d', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.B.5.d', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.f', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.1.f', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.b', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.A.2.d', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.c', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.d', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.d', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.e', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.f', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.1.f', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.2.i', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.a', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.a', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.c', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.c', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.e', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.g', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.g', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.h', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.h', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.j', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.j', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.k', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.k', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.l', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.l', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.m', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.3.m', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.e', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.4.h', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.B.5.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.a', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.c', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.e', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.e', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.f', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.1.f', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.d', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.A.2.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.a', 'LV', 3.62, 8, 0.26, 3.11, 4.14, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.b', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.e', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.f', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.1.f', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.2.i', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.a', 'IM', 2.12, 8, 0.40, 1.34, 2.91, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.a', 'LV', 2.00, 8, 0.65, 0.72, 3.28, 'Y', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.b', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.b', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.c', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.c', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.d', 'IM', 1.25, 8, 0.25, 1.00, 1.74, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.d', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.e', 'IM', 2.12, 8, 0.35, 1.44, 2.81, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.e', 'LV', 1.38, 8, 0.42, 0.55, 2.20, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.g', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.g', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.h', 'IM', 3.25, 8, 0.37, 2.53, 3.97, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.h', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.j', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.j', 'LV', 2.62, 8, 0.32, 1.99, 3.26, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.k', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.k', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.l', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.l', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.m', 'IM', 3.25, 8, 0.31, 2.64, 3.86, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.3.m', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.g', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.g', 'LV', 3.38, 8, 0.38, 2.64, 4.11, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.h', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.4.h', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.b', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.b', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.c', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.B.5.d', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.e', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.e', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.f', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.1.f', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.A.2.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.f', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.1.f', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.2.i', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.2.i', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.a', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.a', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.e', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.g', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.g', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.k', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.k', 'LV', 0.88, 8, 0.35, 0.19, 1.56, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.m', 'IM', 2.12, 8, 0.35, 1.44, 2.81, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.3.m', 'LV', 1.88, 8, 0.55, 0.80, 2.95, 'Y', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.g', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.h', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.4.h', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.B.5.d', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.a', 'IM', 3.87, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.a', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.b', 'IM', 3.84, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.b', 'LV', 3.96, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.c', 'IM', 3.62, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.c', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.d', 'IM', 3.92, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.d', 'LV', 3.96, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.e', 'IM', 3.08, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.e', 'LV', 3.17, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.f', 'IM', 1.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.1.f', 'LV', 0.46, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.a', 'IM', 3.92, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.a', 'LV', 4.08, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.b', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.b', 'LV', 3.66, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.c', 'IM', 3.08, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.c', 'LV', 3.38, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.d', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.A.2.d', 'LV', 4.13, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.a', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.a', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.b', 'IM', 3.84, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.b', 'LV', 4.00, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.c', 'IM', 3.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.c', 'LV', 3.58, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.d', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.d', 'LV', 3.58, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.e', 'IM', 3.12, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.e', 'LV', 3.25, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.f', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.1.f', 'LV', 3.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.2.i', 'IM', 3.71, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.2.i', 'LV', 3.50, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.a', 'IM', 2.83, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.a', 'LV', 2.96, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.b', 'IM', 1.62, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.b', 'LV', 0.79, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.c', 'IM', 1.13, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.c', 'LV', 0.17, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.d', 'IM', 1.00, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.d', 'LV', 0.00, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.e', 'IM', 1.46, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.e', 'LV', 0.58, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.g', 'IM', 2.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.g', 'LV', 2.29, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.h', 'IM', 2.04, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.h', 'LV', 1.83, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.j', 'IM', 1.00, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.j', 'LV', 0.00, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.k', 'IM', 1.79, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.k', 'LV', 1.00, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.l', 'IM', 1.04, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.l', 'LV', 0.08, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.m', 'IM', 2.29, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.3.m', 'LV', 1.96, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.e', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.e', 'LV', 3.63, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.g', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.g', 'LV', 3.46, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.h', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.4.h', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.a', 'IM', 3.54, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.a', 'LV', 3.88, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.b', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.b', 'LV', 3.33, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.c', 'IM', 3.00, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.c', 'LV', 3.17, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.d', 'IM', 3.58, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.00', '2.B.5.d', 'LV', 3.79, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.e', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.e', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.f', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.1.f', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.a', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.f', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.1.f', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.2.i', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.2.i', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.a', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.a', 'LV', 2.38, 8, 0.26, 1.86, 2.89, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.b', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.b', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.e', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.g', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.g', 'LV', 1.88, 8, 0.23, 1.43, 2.32, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.k', 'IM', 1.62, 8, 0.26, 1.11, 2.14, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.k', 'LV', 0.88, 8, 0.40, 0.09, 1.66, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.m', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.3.m', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.e', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.g', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.h', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.b', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.04', '2.B.5.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.f', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.1.f', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.A.2.d', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.1.f', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.2.i', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.2.i', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.a', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.a', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.e', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.g', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.g', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.m', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.3.m', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.g', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.h', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.c', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.c', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.B.5.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.e', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.1.f', 'LV', 1.00, 8, 0.33, 0.36, 1.64, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.e', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.f', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.1.f', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.2.i', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.2.i', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.a', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.a', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.b', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.e', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.g', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.h', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.h', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.m', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.3.m', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.e', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.g', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.h', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.4.h', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.c', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.c', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.B.5.d', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.d', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.f', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.1.f', 'LV', 0.88, 8, 0.13, 0.63, 1.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.b', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.c', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.c', 'LV', 5.25, 8, 0.16, 4.93, 5.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.A.2.d', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.e', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.e', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.f', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.1.f', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.2.i', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.a', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.a', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.e', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.g', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.g', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.k', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.k', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.m', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.3.m', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.g', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.g', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.h', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.4.h', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.B.5.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.a', 'IM', 3.46, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.a', 'LV', 3.75, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.b', 'IM', 3.58, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.b', 'LV', 3.67, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.c', 'IM', 3.17, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.c', 'LV', 3.59, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.d', 'IM', 3.87, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.d', 'LV', 3.75, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.e', 'IM', 2.71, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.e', 'LV', 2.83, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.f', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.1.f', 'LV', 2.88, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.a', 'IM', 3.88, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.a', 'LV', 3.87, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.b', 'IM', 3.29, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.b', 'LV', 3.42, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.c', 'IM', 3.04, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.c', 'LV', 3.13, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.d', 'IM', 3.79, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.A.2.d', 'LV', 3.71, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.a', 'IM', 3.33, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.a', 'LV', 3.38, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.b', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.b', 'LV', 3.63, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.c', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.c', 'LV', 3.37, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.d', 'IM', 3.25, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.d', 'LV', 3.37, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.e', 'IM', 3.21, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.e', 'LV', 3.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.f', 'IM', 2.87, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.1.f', 'LV', 2.91, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.2.i', 'IM', 3.42, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.2.i', 'LV', 3.25, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.a', 'IM', 2.37, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.a', 'LV', 2.42, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.b', 'IM', 1.75, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.b', 'LV', 1.04, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.c', 'IM', 2.21, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.c', 'LV', 1.96, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.d', 'IM', 1.08, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.d', 'LV', 0.08, NULL, NULL, NULL, NULL, 'N', 'Y', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.e', 'IM', 1.63, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.e', 'LV', 0.71, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.g', 'IM', 3.13, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.g', 'LV', 3.00, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.h', 'IM', 2.87, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.h', 'LV', 2.75, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.j', 'IM', 2.13, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.j', 'LV', 2.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.k', 'IM', 2.38, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.k', 'LV', 2.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.l', 'IM', 2.08, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.l', 'LV', 1.88, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.m', 'IM', 2.96, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.3.m', 'LV', 2.87, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.e', 'IM', 3.75, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.e', 'LV', 3.59, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.g', 'IM', 3.08, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.g', 'LV', 3.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.h', 'IM', 3.16, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.4.h', 'LV', 3.25, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.a', 'IM', 3.63, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.a', 'LV', 3.58, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.b', 'IM', 2.88, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.b', 'LV', 3.21, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.c', 'IM', 2.83, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.c', 'LV', 3.25, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.d', 'IM', 3.50, NULL, NULL, NULL, NULL, 'N', NULL, TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.00', '2.B.5.d', 'LV', 3.50, NULL, NULL, NULL, NULL, 'N', 'N', TO_DATE('2020-11-01', 'yyyy-mm-dd'), 'Analyst - Transition');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.f', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.1.f', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.A.2.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.b', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.d', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.1.f', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.2.i', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.a', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.a', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.e', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.g', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.g', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.h', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.h', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.k', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.k', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.m', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.3.m', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.e', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.g', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.4.h', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.a', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.b', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.B.5.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.c', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.f', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.1.f', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.c', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.f', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.1.f', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.2.i', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.2.i', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.a', 'IM', 1.88, 8, 0.30, 1.30, 2.45, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.a', 'LV', 1.00, 8, 0.38, 0.26, 1.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.e', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.g', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.h', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.h', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.k', 'LV', 0.88, 8, 0.13, 0.63, 1.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.m', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.3.m', 'LV', 1.75, 8, 0.16, 1.43, 2.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.g', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.4.h', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.b', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.b', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.B.5.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.a', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.a', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.b', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.b', 'LV', 4.50, 8, 0.19, 4.13, 4.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.c', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.c', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.d', 'IM', 4.38, 8, 0.18, 4.02, 4.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.d', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.f', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.1.f', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.a', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.a', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.c', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.c', 'LV', 4.62, 8, 0.26, 4.11, 5.14, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.A.2.d', 'LV', 4.75, 8, 0.25, 4.26, 5.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.a', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.c', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.e', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.f', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.1.f', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.2.i', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.2.i', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.a', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.a', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.c', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.e', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.g', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.k', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.k', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.m', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.3.m', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.e', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.e', 'LV', 4.38, 8, 0.26, 3.86, 4.89, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.g', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.g', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.h', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.4.h', 'LV', 4.25, 8, 0.31, 3.64, 4.86, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.b', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.B.5.d', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.a', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.b', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.c', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.f', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.1.f', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.A.2.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.e', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.f', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.1.f', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.2.i', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.2.i', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.a', 'IM', 1.62, 8, 0.32, 1.00, 2.26, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.a', 'LV', 0.88, 8, 0.48, 0.00, 1.81, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.e', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.e', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.g', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.g', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.m', 'IM', 1.38, 8, 0.26, 1.00, 1.89, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.3.m', 'LV', 0.50, 8, 0.38, 0.00, 1.24, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.e', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.h', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.4.h', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.b', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.b', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.B.5.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.a', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.c', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.e', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.f', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.1.f', 'LV', 2.75, 8, 0.31, 2.14, 3.36, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.A.2.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.f', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.2.i', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.2.i', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.a', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.a', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.b', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.e', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.g', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.g', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.h', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.h', 'LV', 1.12, 8, 0.44, 0.26, 1.99, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.j', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.j', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.k', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.k', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.m', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.3.m', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.e', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.g', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.h', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.4.h', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.b', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.B.5.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.a', 'LV', 4.25, 8, 0.25, 3.76, 4.74, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.c', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.e', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.e', 'LV', 3.12, 8, 0.23, 2.68, 3.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.f', 'IM', 3.12, 8, 0.48, 2.19, 4.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.1.f', 'LV', 3.00, 8, 0.68, 1.66, 4.34, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.a', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.b', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.A.2.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.a', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.a', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.b', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.c', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.d', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.d', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.e', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.f', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.1.f', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.2.i', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.2.i', 'LV', 3.88, 8, 0.40, 3.09, 4.66, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.a', 'IM', 2.38, 8, 0.46, 1.47, 3.28, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.a', 'LV', 2.25, 8, 0.73, 0.83, 3.67, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.b', 'IM', 2.12, 8, 0.40, 1.34, 2.91, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.b', 'LV', 1.62, 8, 0.63, 0.40, 2.85, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.c', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.c', 'LV', 2.12, 8, 0.40, 1.34, 2.91, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.d', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.d', 'LV', 0.38, 8, 0.38, 0.00, 1.11, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.e', 'IM', 2.00, 8, 0.33, 1.36, 2.64, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.e', 'LV', 1.38, 8, 0.46, 0.47, 2.28, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.g', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.g', 'LV', 3.00, 8, 0.27, 2.48, 3.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.h', 'IM', 2.25, 8, 0.37, 1.53, 2.97, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.h', 'LV', 1.75, 8, 0.56, 0.65, 2.85, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.j', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.j', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.k', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.k', 'LV', 1.62, 8, 0.42, 0.80, 2.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.l', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.l', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.m', 'IM', 3.12, 8, 0.35, 2.44, 3.81, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.3.m', 'LV', 3.00, 8, 0.42, 2.17, 3.83, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.e', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.e', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.g', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.h', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.4.h', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.a', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.b', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.b', 'LV', 1.88, 8, 0.52, 0.86, 2.89, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.c', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.c', 'LV', 1.88, 8, 0.52, 0.86, 2.89, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.B.5.d', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.b', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.1.f', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.A.2.d', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.f', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.1.f', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.2.i', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.2.i', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.a', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.a', 'LV', 2.38, 8, 0.38, 1.64, 3.11, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.b', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.b', 'LV', 0.38, 8, 0.18, 0.02, 0.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.c', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.c', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.e', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.g', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.g', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.h', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.h', 'LV', 1.75, 8, 0.31, 1.14, 2.36, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.j', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.j', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.k', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.l', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.l', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.m', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.3.m', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.g', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.g', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.h', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.4.h', 'LV', 2.50, 8, 0.27, 1.98, 3.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.b', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.b', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.B.5.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.f', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.1.f', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.A.2.d', 'LV', 4.12, 8, 0.23, 3.68, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.c', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.d', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.d', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.e', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.f', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.1.f', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.2.i', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.2.i', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.a', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.a', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.b', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.b', 'LV', 0.38, 8, 0.18, 0.02, 0.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.e', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.g', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.g', 'LV', 1.62, 8, 0.38, 0.89, 2.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.k', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.k', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.m', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.3.m', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.g', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.h', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.4.h', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.b', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.b', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.c', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.c', 'LV', 2.25, 8, 0.31, 1.64, 2.86, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.B.5.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.b', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.e', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.f', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.1.f', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.A.2.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.f', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.1.f', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.2.i', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.a', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.a', 'LV', 1.00, 8, 0.27, 0.48, 1.52, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.b', 'LV', 1.00, 8, 0.19, 0.63, 1.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.c', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.c', 'LV', 0.75, 8, 0.37, 0.03, 1.47, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.e', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.g', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.g', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.h', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.h', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.j', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.j', 'LV', 0.75, 8, 0.37, 0.03, 1.47, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.k', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.l', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.l', 'LV', 0.75, 8, 0.37, 0.03, 1.47, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.m', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.3.m', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.g', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.h', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.4.h', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.b', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.b', 'LV', 3.50, 8, 0.38, 2.76, 4.24, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.c', 'LV', 3.62, 8, 0.38, 2.89, 4.36, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.B.5.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.e', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.f', 'IM', 2.50, 8, 0.27, 1.98, 3.02, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.1.f', 'LV', 2.50, 8, 0.38, 1.76, 3.24, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.a', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.f', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.1.f', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.2.i', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.2.i', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.b', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.e', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.e', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.g', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.g', 'LV', 1.88, 8, 0.23, 1.43, 2.32, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.h', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.h', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.k', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.k', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.m', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.3.m', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.e', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.g', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.h', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.B.5.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.a', 'LV', 5.00, 8, 0.00, 5.00, 5.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.b', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.c', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.c', 'LV', 5.00, 8, 0.00, 5.00, 5.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.e', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.f', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.1.f', 'LV', 4.88, 8, 0.13, 4.63, 5.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.a', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.b', 'LV', 4.75, 8, 0.16, 4.43, 5.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.c', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.d', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.1.f', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.2.i', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.2.i', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.b', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.b', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.c', 'LV', 0.25, 8, 0.25, 0.00, 0.74, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.e', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.g', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.g', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.h', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.h', 'LV', 1.50, 8, 0.19, 1.13, 1.87, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.k', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.m', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.3.m', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.e', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.g', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.b', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.B.5.d', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.e', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.1.f', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.c', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.A.2.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.d', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.d', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.e', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.1.f', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.2.i', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.2.i', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.a', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.a', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.c', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.e', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.g', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.k', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.k', 'LV', 0.38, 8, 0.18, 0.02, 0.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.m', 'IM', 1.75, 8, 0.25, 1.26, 2.24, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.3.m', 'LV', 1.12, 8, 0.35, 0.44, 1.81, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.e', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.e', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.g', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.g', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.h', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.4.h', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.b', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.b', 'LV', 2.25, 8, 0.37, 1.53, 2.97, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.c', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.B.5.d', 'LV', 3.50, 8, 0.27, 2.98, 4.02, 'N', 'N', TO_DATE('2021-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.f', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.1.f', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.A.2.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.a', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.b', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.d', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.e', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.1.f', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.2.i', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.2.i', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.a', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.a', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.b', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.e', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.e', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.g', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.g', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.h', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.h', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.k', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.k', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.m', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.3.m', 'LV', 2.88, 8, 0.30, 2.30, 3.45, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.g', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.h', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.b', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.b', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.c', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.c', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.d', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.B.5.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.b', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.e', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.e', 'LV', 2.50, 8, 0.19, 2.13, 2.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.f', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.1.f', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.b', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.b', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.A.2.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.a', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.b', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.d', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.f', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.1.f', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.2.i', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.2.i', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.a', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.a', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.e', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.g', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.g', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.h', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.h', 'LV', 1.25, 8, 0.37, 0.53, 1.97, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.k', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.k', 'LV', 1.50, 8, 0.19, 1.13, 1.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.m', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.3.m', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.g', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.g', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.h', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.4.h', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.b', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.b', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.c', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.B.5.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.e', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.e', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.f', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.1.f', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.b', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.b', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.c', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.c', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.A.2.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.a', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.a', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.b', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.e', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.1.f', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.2.i', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.2.i', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.a', 'IM', 2.12, 8, 0.30, 1.55, 2.70, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.a', 'LV', 1.88, 8, 0.44, 1.01, 2.74, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.b', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.b', 'LV', 0.25, 8, 0.16, 0.00, 0.57, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.c', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.e', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.g', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.h', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.h', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.k', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.k', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.m', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.3.m', 'LV', 2.00, 8, 0.00, 2.00, 2.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.e', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.g', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.g', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.h', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.4.h', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.a', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.a', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.b', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.b', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.c', 'IM', 2.88, 8, 0.23, 2.43, 3.32, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.c', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.B.5.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.b', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.c', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.e', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.e', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.f', 'IM', 2.25, 8, 0.25, 1.76, 2.74, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.1.f', 'LV', 2.00, 8, 0.38, 1.26, 2.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.A.2.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.a', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.f', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.1.f', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.2.i', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.2.i', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.a', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.a', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.b', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.e', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.g', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.g', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.h', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.h', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.k', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.k', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.m', 'IM', 2.00, 8, 0.00, 2.00, 2.00, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.3.m', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.e', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.e', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.g', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.g', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.h', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.4.h', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.b', 'IM', 2.62, 8, 0.32, 1.99, 3.26, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.b', 'LV', 3.12, 8, 0.52, 2.11, 4.14, 'Y', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.c', 'IM', 2.38, 8, 0.26, 1.86, 2.89, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.c', 'LV', 2.38, 8, 0.42, 1.55, 3.20, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.B.5.d', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.b', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.c', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.d', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.d', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.e', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.f', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.1.f', 'LV', 1.62, 8, 0.18, 1.27, 1.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.a', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.b', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.c', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.A.2.d', 'LV', 4.38, 8, 0.18, 4.02, 4.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.b', 'LV', 4.88, 8, 0.13, 4.63, 5.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.d', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.f', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.1.f', 'LV', 5.00, 8, 0.19, 4.63, 5.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.2.i', 'IM', 4.25, 8, 0.16, 3.93, 4.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.2.i', 'LV', 5.25, 8, 0.16, 4.93, 5.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.a', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.a', 'LV', 3.25, 8, 0.31, 2.64, 3.86, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.b', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.e', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.e', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.g', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.g', 'LV', 1.88, 8, 0.13, 1.63, 2.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.h', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.h', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.k', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.k', 'LV', 1.00, 8, 0.19, 0.63, 1.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.m', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.3.m', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.e', 'IM', 4.12, 8, 0.13, 3.88, 4.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.e', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.g', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.g', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.h', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.4.h', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.b', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.b', 'LV', 2.75, 8, 0.25, 2.26, 3.24, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.c', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.c', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.B.5.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.b', 'IM', 3.75, 8, 0.31, 3.14, 4.36, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.d', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.e', 'IM', 2.38, 8, 0.18, 2.02, 2.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.e', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.f', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.1.f', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.b', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.b', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.c', 'LV', 3.00, 8, 0.19, 2.63, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.d', 'IM', 3.62, 8, 0.26, 3.11, 4.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.A.2.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.a', 'IM', 3.75, 8, 0.25, 3.26, 4.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.a', 'LV', 3.62, 8, 0.32, 2.99, 4.26, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.b', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.d', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.e', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.f', 'IM', 4.00, 8, 0.33, 3.36, 4.64, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.1.f', 'LV', 4.00, 8, 0.27, 3.48, 4.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.2.i', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.2.i', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.a', 'IM', 1.38, 8, 0.26, 1.00, 1.89, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.a', 'LV', 0.62, 8, 0.42, 0.00, 1.45, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.b', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.b', 'LV', 0.75, 8, 0.25, 0.26, 1.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.e', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.g', 'IM', 2.12, 8, 0.23, 1.68, 2.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.g', 'LV', 2.12, 8, 0.35, 1.44, 2.81, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.h', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.h', 'LV', 1.88, 8, 0.30, 1.30, 2.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.k', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.k', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.m', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.3.m', 'LV', 2.00, 8, 0.42, 1.17, 2.83, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.e', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.g', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.g', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.h', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.4.h', 'LV', 2.62, 8, 0.18, 2.27, 2.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.b', 'IM', 2.50, 8, 0.33, 1.86, 3.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.b', 'LV', 2.75, 8, 0.56, 1.65, 3.85, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.c', 'IM', 2.38, 8, 0.32, 1.74, 3.01, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.c', 'LV', 2.75, 8, 0.53, 1.72, 3.78, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9171.00', '2.B.5.d', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.c', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.e', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.e', 'LV', 2.38, 8, 0.18, 2.02, 2.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.f', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.1.f', 'LV', 1.25, 8, 0.31, 0.64, 1.86, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.b', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.b', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.c', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.d', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.A.2.d', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.b', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.c', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.d', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.e', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.e', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.f', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.1.f', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.2.i', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.2.i', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.a', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.a', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.b', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.b', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.c', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.c', 'LV', 1.12, 8, 0.23, 0.68, 1.57, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.e', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.e', 'LV', 0.38, 8, 0.18, 0.02, 0.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.g', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.g', 'LV', 1.50, 8, 0.33, 0.86, 2.14, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.h', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.h', 'LV', 0.62, 8, 0.18, 0.27, 0.98, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.j', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.j', 'LV', 0.50, 8, 0.19, 0.13, 0.87, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.k', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.k', 'LV', 1.12, 8, 0.30, 0.55, 1.70, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.l', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.l', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.m', 'IM', 2.25, 8, 0.16, 1.93, 2.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.3.m', 'LV', 2.12, 8, 0.13, 1.88, 2.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.e', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.e', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.g', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.g', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.4.h', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.a', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.b', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.b', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.c', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.c', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.d', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.01', '2.B.5.d', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2022-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.a', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.b', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.e', 'IM', 2.75, 8, 0.16, 2.43, 3.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.e', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.f', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.1.f', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.b', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.c', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.c', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.d', 'IM', 4.00, 8, 0.19, 3.63, 4.37, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.A.2.d', 'LV', 4.12, 8, 0.35, 3.44, 4.81, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.a', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.b', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.c', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.d', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.d', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.e', 'LV', 3.25, 8, 0.25, 2.76, 3.74, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.f', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.1.f', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.2.i', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.2.i', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.a', 'IM', 1.62, 8, 0.32, 1.00, 2.26, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.a', 'LV', 0.88, 8, 0.52, 0.00, 1.89, 'Y', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.b', 'IM', 1.88, 8, 0.23, 1.43, 2.32, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.b', 'LV', 1.38, 8, 0.32, 0.74, 2.01, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.c', 'IM', 1.38, 8, 0.26, 1.00, 1.89, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.c', 'LV', 0.50, 8, 0.33, 0.00, 1.14, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.e', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.e', 'LV', 0.75, 8, 0.31, 0.14, 1.36, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.g', 'IM', 2.62, 8, 0.32, 1.99, 3.26, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.g', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.h', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.h', 'LV', 1.62, 8, 0.32, 0.99, 2.26, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.k', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.k', 'LV', 1.62, 8, 0.26, 1.11, 2.14, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.m', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.3.m', 'LV', 2.12, 8, 0.23, 1.68, 2.57, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.e', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.g', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.g', 'LV', 2.88, 8, 0.23, 2.43, 3.32, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.h', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.4.h', 'LV', 3.12, 8, 0.30, 2.55, 3.70, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.a', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.b', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.b', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.c', 'IM', 3.00, 8, 0.27, 2.48, 3.52, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.c', 'LV', 3.50, 8, 0.33, 2.86, 4.14, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9179.02', '2.B.5.d', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.c', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.c', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.e', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.e', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.f', 'IM', 2.50, 8, 0.19, 2.13, 2.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.1.f', 'LV', 2.00, 8, 0.19, 1.63, 2.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.b', 'IM', 3.38, 8, 0.26, 2.86, 3.89, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.c', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.A.2.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.a', 'IM', 3.25, 8, 0.25, 2.76, 3.74, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.a', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.b', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.c', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.e', 'IM', 3.12, 8, 0.23, 2.68, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.e', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.f', 'IM', 2.88, 8, 0.13, 2.63, 3.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.1.f', 'LV', 3.00, 8, 0.00, 3.00, 3.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.2.i', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.2.i', 'LV', 3.38, 8, 0.18, 3.02, 3.73, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.a', 'IM', 3.00, 8, 0.19, 2.63, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.c', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.c', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.e', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.g', 'IM', 1.62, 8, 0.18, 1.27, 1.98, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.g', 'LV', 0.88, 8, 0.30, 0.30, 1.45, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.h', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.h', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.k', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.k', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.m', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.3.m', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.e', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.e', 'LV', 4.00, 8, 0.19, 3.63, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.g', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.g', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.h', 'IM', 3.50, 8, 0.27, 2.98, 4.02, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.4.h', 'LV', 3.75, 8, 0.25, 3.26, 4.24, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.b', 'IM', 2.00, 8, 0.19, 1.63, 2.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.b', 'LV', 2.00, 8, 0.33, 1.36, 2.64, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.c', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.c', 'LV', 1.75, 8, 0.25, 1.26, 2.24, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.d', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.B.5.d', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.a', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.b', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.b', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.c', 'IM', 3.88, 8, 0.23, 3.43, 4.32, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.c', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.d', 'LV', 4.12, 8, 0.13, 3.88, 4.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.e', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.e', 'LV', 2.25, 8, 0.16, 1.93, 2.57, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.f', 'IM', 1.38, 8, 0.18, 1.02, 1.73, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.1.f', 'LV', 0.50, 8, 0.27, 0.00, 1.02, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.a', 'LV', 4.25, 8, 0.16, 3.93, 4.57, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.b', 'LV', 3.88, 8, 0.23, 3.43, 4.32, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.c', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.d', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.A.2.d', 'LV', 4.62, 8, 0.18, 4.27, 4.98, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.a', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.a', 'LV', 3.62, 8, 0.18, 3.27, 3.98, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.c', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.c', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.d', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.d', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.e', 'IM', 3.38, 8, 0.18, 3.02, 3.73, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.e', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.f', 'IM', 3.00, 8, 0.00, 3.00, 3.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.1.f', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.2.i', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.2.i', 'LV', 3.50, 8, 0.19, 3.13, 3.87, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.a', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.a', 'LV', 1.38, 8, 0.38, 0.64, 2.11, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.b', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.b', 'LV', 0.75, 8, 0.16, 0.43, 1.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.c', 'IM', 1.12, 8, 0.13, 1.00, 1.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.c', 'LV', 0.12, 8, 0.13, 0.00, 0.37, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.d', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.d', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.e', 'IM', 1.75, 8, 0.16, 1.43, 2.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.e', 'LV', 0.88, 8, 0.23, 0.43, 1.32, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.g', 'IM', 2.00, 8, 0.27, 1.48, 2.52, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.g', 'LV', 1.50, 8, 0.38, 0.76, 2.24, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.h', 'IM', 1.50, 8, 0.19, 1.13, 1.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.h', 'LV', 0.62, 8, 0.26, 0.11, 1.14, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.j', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.j', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.k', 'IM', 1.25, 8, 0.16, 1.00, 1.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.k', 'LV', 0.38, 8, 0.26, 0.00, 0.89, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.l', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.l', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.m', 'IM', 2.12, 8, 0.13, 1.88, 2.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.3.m', 'LV', 1.88, 8, 0.23, 1.43, 2.32, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.e', 'IM', 3.50, 8, 0.19, 3.13, 3.87, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.e', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.g', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.g', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.h', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.4.h', 'LV', 3.38, 8, 0.26, 2.86, 3.89, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.a', 'IM', 3.12, 8, 0.13, 2.88, 3.37, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.a', 'LV', 3.12, 8, 0.13, 2.88, 3.37, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.b', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.b', 'LV', 1.50, 8, 0.27, 0.98, 2.02, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.c', 'IM', 1.88, 8, 0.13, 1.63, 2.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.c', 'LV', 1.38, 8, 0.26, 0.86, 1.89, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.d', 'IM', 2.62, 8, 0.18, 2.27, 2.98, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.02', '2.B.5.d', 'LV', 2.88, 8, 0.13, 2.63, 3.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.a', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.b', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.b', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.c', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.c', 'LV', 3.88, 8, 0.13, 3.63, 4.12, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.d', 'IM', 4.00, 8, 0.00, 4.00, 4.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.e', 'IM', 2.75, 8, 0.25, 2.26, 3.24, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.e', 'LV', 2.75, 8, 0.16, 2.43, 3.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.f', 'IM', 1.00, 8, 0.00, 1.00, 1.00, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.1.f', 'LV', 0.00, 8, 0.00, 0.00, 0.00, 'N', 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.a', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.a', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.b', 'IM', 3.75, 8, 0.16, 3.43, 4.07, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.b', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.c', 'IM', 3.25, 8, 0.16, 2.93, 3.57, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.c', 'LV', 3.25, 8, 0.16, 2.93, 3.57, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.d', 'IM', 3.88, 8, 0.13, 3.63, 4.12, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.A.2.d', 'LV', 4.00, 8, 0.00, 4.00, 4.00, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.B.1.a', 'IM', 3.62, 8, 0.18, 3.27, 3.98, 'N', NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.08', '2.B.1.a', 'LV', 3.75, 8, 0.16, 3.43, 4.07, 'N', 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO skills (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-91