CREATE TABLE dwa_reference (
  element_id CHARACTER VARYING(20) NOT NULL,
  iwa_id CHARACTER VARYING(20) NOT NULL,
  dwa_id CHARACTER VARYING(20) NOT NULL,
  dwa_title CHARACTER VARYING(150) NOT NULL,
  PRIMARY KEY (dwa_id),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (iwa_id) REFERENCES iwa_reference(iwa_id));

INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I01', '4.A.1.a.1.I01.D01', 'Review art or design materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I01', '4.A.1.a.1.I01.D02', 'Study details of musical compositions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I01', '4.A.1.a.1.I01.D03', 'Review production information to determine costume or makeup requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I01', '4.A.1.a.1.I01.D04', 'Study scripts to determine project requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I01', '4.A.1.a.1.I01.D05', 'Review audio or video recordings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D01', 'Read materials to determine needed actions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D02', 'Read maps to determine routes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D03', 'Review customer information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D04', 'Read work orders or other instructions to determine product specifications or materials requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D05', 'Read technical information needed to perform maintenance or repairs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D06', 'Study blueprints or other instructions to determine equipment setup requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D07', 'Read documents to gather technical information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D08', 'Review technical documents to plan work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D09', 'Review blueprints or specifications to determine work requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D10', 'Review work orders or schedules to determine operations or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D11', 'Review blueprints or other instructions to determine operational methods or sequences.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D12', 'Evaluate reports or designs to determine work needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D13', 'Read work orders or descriptions of problems to determine repairs or modifications needed.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D14', 'Interpret blueprints, specifications, or diagrams to inform installation, development or operation activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D15', 'Review details of technical drawings or specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I02', '4.A.1.a.1.I02.D16', 'Read work orders to determine material or setup requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D01', 'Collect evidence for legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D02', 'Examine crime scenes to obtain evidence.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D03', 'Investigate crimes committed within organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D04', 'Investigate legal issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D05', 'Examine records or other types of data to investigate criminal activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D06', 'Conduct hearings to investigate legal issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I03', '4.A.1.a.1.I03.D07', 'Investigate illegal or suspicious activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D01', 'Obtain property information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D02', 'Use databases to locate investigation details or other information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D03', 'Search information sources to find specific data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D04', 'Gather financial records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D05', 'Retrieve information from electronic sources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D06', 'Gather information in order to provide services to clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D07', 'Search files, databases or reference materials to obtain needed information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I04', '4.A.1.a.1.I04.D08', 'Collect archival data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I05', '4.A.1.a.1.I05.D01', 'Evaluate information related to legal matters in public or personal records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I05', '4.A.1.a.1.I05.D02', 'Research relevant legal materials to aid decision making.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I06', '4.A.1.a.1.I06.D01', 'Gather organizational performance information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I06', '4.A.1.a.1.I06.D02', 'Gather information about work conditions or locations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I06', '4.A.1.a.1.I06.D03', 'Gather physical survey data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I06', '4.A.1.a.1.I06.D04', 'Collect data about project sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I07', '4.A.1.a.1.I07.D01', 'Obtain information about goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I08', '4.A.1.a.1.I08.D01', 'Research hydrologic features or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I08', '4.A.1.a.1.I08.D02', 'Research geological features or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I08', '4.A.1.a.1.I08.D03', 'Conduct climatological research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I09', '4.A.1.a.1.I09.D01', 'Conduct surveys in organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I09', '4.A.1.a.1.I09.D02', 'Research industrial processes or operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I09', '4.A.1.a.1.I09.D03', 'Conduct scientific research of organizational behavior or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D01', 'Research impacts of environmental conservation initiatives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D02', 'Research issues related to the environment or sustainable business practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D03', 'Investigate the environmental impact of projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D04', 'Monitor environmental impacts of production or development activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D05', 'Research environmental impact of industrial or development activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D06', 'Identify environmental concerns.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I10', '4.A.1.a.1.I10.D07', 'Evaluate environmental impact of operational or development activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I11', '4.A.1.a.1.I11.D01', 'Gather information for news stories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I12', '4.A.1.a.1.I12.D01', 'Gather medical information from patient histories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I12', '4.A.1.a.1.I12.D02', 'Collect medical information from patients, family members, or other medical professionals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I12', '4.A.1.a.1.I12.D03', 'Collect information from people through observation, interviews, or surveys.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I12', '4.A.1.a.1.I12.D04', 'Collect information about clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I13', '4.A.1.a.1.I13.D01', 'Research livestock management methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I13', '4.A.1.a.1.I13.D02', 'Research crop management methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I13', '4.A.1.a.1.I13.D03', 'Research sustainable agricultural processes or practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I14', '4.A.1.a.1.I14.D01', 'Conduct market research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I14', '4.A.1.a.1.I14.D02', 'Gather customer or product information to determine customer needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I14', '4.A.1.a.1.I14.D03', 'Obtain personal or financial information about customers or applicants.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I14', '4.A.1.a.1.I14.D04', 'Conduct opinion surveys or needs assessments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I14', '4.A.1.a.1.I14.D05', 'Collect data about customer needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I15', '4.A.1.a.1.I15.D01', 'Observe individuals'' activities to gather information or compile evidence.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I15', '4.A.1.a.1.I15.D02', 'Investigate personal characteristics or activities of individuals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D01', 'Research genetic characteristics or expression.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D02', 'Research diseases or parasites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D03', 'Conduct research of processes in natural or industrial ecosystems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D04', 'Research microbiological or chemical processes or structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D05', 'Classify organisms based on their characteristics or behavior.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I16', '4.A.1.a.1.I16.D06', 'Examine characteristics or behavior of living organisms.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I17', '4.A.1.a.1.I17.D01', 'Obtain documentation to authorize activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I17', '4.A.1.a.1.I17.D02', 'Obtain copyrights or other legal permissions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I17', '4.A.1.a.1.I17.D03', 'Obtain written authorization to perform activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I18', '4.A.1.a.1.I18.D01', 'Conduct anthropological or archaeological research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I18', '4.A.1.a.1.I18.D02', 'Conduct historical research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I18', '4.A.1.a.1.I18.D03', 'Conduct research on social issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I19', '4.A.1.a.1.I19.D01', 'Conduct research to increase knowledge about medical issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I19', '4.A.1.a.1.I19.D02', 'Collect information about community health needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D01', 'Research engineering aspects of biological or chemical processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D02', 'Research engineering applications of emerging technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D03', 'Research design or application of green technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D04', 'Conduct research to gain information about products or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D05', 'Research advanced engineering designs or applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D06', 'Research energy production, use, or conservation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D07', 'Research human performance or health factors related to engineering or design activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D08', 'Research new technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D09', 'Research product safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I20', '4.A.1.a.1.I20.D10', 'Research methods to improve food products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I21', '4.A.1.a.1.I21.D01', 'Investigate accidents to determine causes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I21', '4.A.1.a.1.I21.D02', 'Examine debris to obtain information about causes of fires.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I21', '4.A.1.a.1.I21.D03', 'Investigate transportation incidents, violations, or complaints.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I21', '4.A.1.a.1.I21.D04', 'Investigate industrial or transportation accidents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I22', '4.A.1.a.1.I22.D01', 'Investigate system, equipment, or product failures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I22', '4.A.1.a.1.I22.D02', 'Investigate work related complaints to determine corrective actions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I22', '4.A.1.a.1.I22.D03', 'Investigate safety of work environment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D01', 'Interview employees, customers, or others to collect information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D02', 'Interview others for news or entertainment purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D03', 'Interview clients to gather financial information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D04', 'Interview people to obtain information about actions or status of individuals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D05', 'Interview people to gather information about criminal activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D06', 'Interview patients to gather medical information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D07', 'Interview claimants to get information related to legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D08', 'Interview clients to gather information about their backgrounds, needs, or progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.1', '4.A.1.a.1.I23', '4.A.1.a.1.I23.D09', 'Interview witnesses, suspects, or claimants.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D01', 'Monitor broadcasting operations to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D02', 'Monitor medical equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D03', 'Monitor engine operation or functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D04', 'Monitor lubrication of equipment or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D05', 'Monitor equipment operation to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D06', 'Observe equipment in operation to detect potential problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D07', 'Watch operating equipment to detect malfunctions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D08', 'Monitor green energy equipment, systems, or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D09', 'Assess equipment functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D10', 'Monitor equipment operation to ensure that products are not flawed.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D11', 'Monitor instruments to ensure proper production conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D12', 'Monitor video displays of medical equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D13', 'Monitor equipment gauges or displays to ensure proper operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I01', '4.A.1.a.2.I01.D14', 'Monitor equipment fluid levels.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D01', 'Monitor industrial energy consumption or management.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D02', 'Monitor facilities or operational systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D03', 'Monitor operational quality or safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D04', 'Monitor extraction operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D05', 'Monitor organizational procedures to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D06', 'Monitor construction operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D07', 'Monitor vehicle movement or location.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D08', 'Monitor recreational facility operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D09', 'Inspect operational processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D10', 'Track goods or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D11', 'Monitor food services operations to ensure procedures are followed.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D12', 'Monitor loading processes to ensure they are performed properly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D13', 'Monitor biofuel production operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D14', 'Inspect cargo to ensure it is properly loaded or secured.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D15', 'Monitor the productivity or efficiency of industrial operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D16', 'Monitor operational procedures in technical environments to ensure conformance to standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D17', 'Inspect operations of green energy facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D18', 'Monitor conditions at energy-producing landfills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D19', 'Monitor the handling of hazardous materials or medical wastes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I02', '4.A.1.a.2.I02.D20', 'Monitor organizational processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D01', 'Monitor financial information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D02', 'Monitor financial activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D03', 'Monitor sales activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D04', 'Monitor flow of cash or other resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D05', 'Monitor financial indicators.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I03', '4.A.1.a.2.I03.D06', 'Monitor business indicators.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I04', '4.A.1.a.2.I04.D01', 'Monitor traffic signals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I04', '4.A.1.a.2.I04.D02', 'Time vehicle speed or traffic-control equipment operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D01', 'Monitor patient progress or responses to treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D02', 'Monitor clients to evaluate treatment progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D03', 'Monitor patients following surgeries or other treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D04', 'Monitor animal behavior or condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D05', 'Monitor health or behavior of people or animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D06', 'Monitor patients to detect health problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D07', 'Monitor patient conditions during treatments, procedures, or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I05', '4.A.1.a.2.I05.D08', 'Monitor nutrition related activities of individuals or groups.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D01', 'Monitor performance of organizational members or partners.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D02', 'Monitor patron activities to identify problems or potential problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D03', 'Monitor student performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D04', 'Supervise school or student activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D05', 'Enforce rules or policies governing student behavior.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D06', 'Monitor activities of individuals to ensure safety or compliance with rules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I06', '4.A.1.a.2.I06.D07', 'Monitor student behavior, social development, or health.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D01', 'Monitor environment to ensure safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D02', 'Monitor access or flow of people to prevent problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D03', 'Monitor building premises to ensure occupant or visitor safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D04', 'Locate suspicious objects or vehicles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D05', 'Patrol properties to maintain safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D06', 'Monitor work areas to provide security.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D07', 'Maintain surveillance of individuals or establishments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D08', 'Monitor alarm systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D09', 'Monitor work areas or procedures to ensure compliance with safety procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D10', 'Locate fires or fire danger areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D11', 'Monitor surroundings to detect potential hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D12', 'Patrol natural areas to ensure safety or enforce regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I07', '4.A.1.a.2.I07.D13', 'Monitor work environment to ensure safety or adherence to specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I08', '4.A.1.a.2.I08.D01', 'Monitor market conditions or trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I08', '4.A.1.a.2.I08.D02', 'Monitor current trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I08', '4.A.1.a.2.I08.D03', 'Monitor external affairs or events affecting business operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D01', 'Inspect landscaping to determine treatment needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D02', 'Monitor environmental conditions to detect hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D03', 'Measure environmental characteristics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D04', 'Monitor activities affecting environmental quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D05', 'Assess characteristics of fires.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I09', '4.A.1.a.2.I09.D06', 'Inspect condition of natural environments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I10', '4.A.1.a.2.I10.D01', 'Monitor the security of digital information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I10', '4.A.1.a.2.I10.D02', 'Monitor the performance of computer networks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I10', '4.A.1.a.2.I10.D03', 'Monitor computer system performance to ensure proper operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D01', 'Identify actions needed to bring properties or facilities into compliance with regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D02', 'Inspect products or operations to ensure that standards are met.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D03', 'Monitor operations to ensure compliance with safety or security policies or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D04', 'Monitor organizational compliance with regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D05', 'Verify that medical activities or operations meet standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D06', 'Monitor processes for compliance with standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D07', 'Evaluate personnel practices to ensure adherence to regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D08', 'Monitor operational activities to ensure compliance with regulations or standard operating procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D09', 'Evaluate construction projects to determine compliance with external standards or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D10', 'Determine operational compliance with regulations or standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.a.2', '4.A.1.a.2.I11', '4.A.1.a.2.I11.D11', 'Monitor medical facility activities to ensure adherence to standards or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D01', 'Apply identification labels or tags.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D02', 'Mark agricultural or forestry products for identification.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D03', 'Mark materials or objects for identification.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D04', 'Mark products, workpieces, or equipment with identifying information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D05', 'Label production materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I01', '4.A.1.b.1.I01.D06', 'Attach identification information to products, items or containers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D01', 'Identify opportunities for green initiatives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D02', 'Identify potential customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D03', 'Identify investment opportunities or strategies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D04', 'Identify strategic business investment opportunities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D05', 'Identify new applications for existing technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D06', 'Identify opportunities to improve operational efficiency.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.1', '4.A.1.b.1.I02', '4.A.1.b.1.I02.D07', 'Identify sustainable business practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D01', 'Test patient heart or lung functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D02', 'Administer screening tests to determine abilities or treatment needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D03', 'Test patient hearing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D04', 'Test patient vision.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D05', 'Conduct diagnostic tests to determine patient health.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D06', 'Administer drug screening tests.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D07', 'Test patient nervous system functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I01', '4.A.1.b.2.I01.D08', 'Test biological specimens to gather information about patient conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I02', '4.A.1.b.2.I02.D01', 'Test green technologies or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I02', '4.A.1.b.2.I02.D02', 'Test green technology installations to verify performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D01', 'Test materials, solutions, or samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D02', 'Test products for functionality or quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D03', 'Analyze test results.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D04', 'Test characteristics of materials or structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D05', 'Test chemical or physical characteristics of materials or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D06', 'Test fluids to identify contamination or other problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I03', '4.A.1.b.2.I03.D07', 'Test quality of materials or finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D01', 'Inspect motor vehicles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D02', 'Inspect mechanical components of vehicles to identify problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D03', 'Inspect vehicles to determine overall condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D04', 'Inspect locomotives or other railroad equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D05', 'Inspect aircraft or aircraft components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I04', '4.A.1.b.2.I04.D06', 'Inspect structural components of vehicles to identify problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D01', 'Inspect work sites to determine condition or necessary repairs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D02', 'Inspect work sites to identify potential environmental or safety hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D03', 'Inspect facilities, equipment or supplies to ensure conformance to standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D04', 'Inspect cargo areas for cleanliness or condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D05', 'Inspect work environments to ensure safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D06', 'Monitor cargo area conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D07', 'Inspect facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D08', 'Inspect facilities or equipment to ensure specifications are met.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D09', 'Inspect areas for compliance with sanitation standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D10', 'Inspect facilities to ensure compliance with fire regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D11', 'Inspect facilities to ensure compliance with safety, quality, or service standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D12', 'Inspect facilities or sites to determine if they meet specifications or standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D13', 'Inspect facilities to ensure compliance with security or safety regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D14', 'Inspect facilities for cleanliness.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D15', 'Inspect condition or functioning of facilities or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I05', '4.A.1.b.2.I05.D16', 'Inspect buildings or grounds to determine condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D01', 'Verify alignment of structures or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D02', 'Inspect timing devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D03', 'Inspect finishes of workpieces or finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D04', 'Count finished products or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D05', 'Inspect metal, plastic, or composite products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D06', 'Inspect work to ensure standards are met.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D07', 'Inspect textile products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D08', 'Inspect finished products to locate flaws.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D09', 'Evaluate projects to determine compliance with technical specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D10', 'Inspect medical or dental assistive devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D11', 'Inspect items for damage or defects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D12', 'Check quality of foods or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D13', 'Inspect food products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D14', 'Inspect sets or exhibits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D15', 'Inspect completed work to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D16', 'Inspected printed materials or other images to verify quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D17', 'Inspect completed work to ensure proper installation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I06', '4.A.1.b.2.I06.D18', 'Inspect installed components or assemblies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D01', 'Inspect equipment or tools to be used in construction or excavation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D02', 'Inspect safety equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D03', 'Inspect systems to determine if they are operating properly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D04', 'Inspect equipment or facilities to determine condition or maintenance needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D05', 'Inspect telecommunications equipment to identify problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D06', 'Inspect equipment to locate or identify electrical problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D07', 'Inspect material-moving equipment to detect problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D08', 'Inspect electrical or electronic systems for defects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D09', 'Conduct validation tests of equipment or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D10', 'Inspect gas systems or components to identify leaks or other potential hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D11', 'Inspect equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D12', 'Inspect plumbing systems or fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D13', 'Locate equipment or materials in need of repair or replacement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D14', 'Inspect equipment to ensure safety or proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D15', 'Inspect production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D16', 'Inspect industrial or commercial equipment to ensure proper operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D17', 'Inspect sustainable energy production facilities or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D18', 'Inspect equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D19', 'Inspect communications or broadcasting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D20', 'Inspect mechanical equipment to locate damage, defects, or wear.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I07', '4.A.1.b.2.I07.D21', 'Examine medical instruments or equipment to ensure proper operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I08', '4.A.1.b.2.I08.D01', 'Test computer hardware performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I08', '4.A.1.b.2.I08.D02', 'Test computer system operations to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I08', '4.A.1.b.2.I08.D03', 'Test software performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I09', '4.A.1.b.2.I09.D01', 'Check physical condition of people or animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I09', '4.A.1.b.2.I09.D02', 'Examine animals to detect illness, injury or other problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I09', '4.A.1.b.2.I09.D03', 'Examine patients to assess general physical condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I09', '4.A.1.b.2.I09.D04', 'Examine mouth, teeth, gums, or related facial structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I09', '4.A.1.b.2.I09.D05', 'Measure the physical or physiological attributes of patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D01', 'Compare physical characteristics of materials or products to specifications or standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D02', 'Inspect lumber or raw woodstock.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D03', 'Inspect shipments to ensure correct order fulfillment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D04', 'Inspect garments for defects, damage, or stains.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D05', 'Inspect cargo to identify potential hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D06', 'Evaluate characteristics of archival or historical objects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D07', 'Examine condition of property or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D08', 'Inspect materials or equipment to determine need for repair or replacement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I10', '4.A.1.b.2.I10.D09', 'Examine physical characteristics of gemstones or precious metals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I11', '4.A.1.b.2.I11.D01', 'Test air quality at work sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I11', '4.A.1.b.2.I11.D02', 'Test facilities for environmental hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D01', 'Test communications equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D02', 'Test performance of electrical, electronic, mechanical, or integrated systems or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D03', 'Test electrical equipment or systems to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D04', 'Test performance of aircraft equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D05', 'Test mechanical equipment to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D06', 'Measure equipment outputs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D07', 'Test mechanical systems to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D08', 'Conduct test runs of production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.2', '4.A.1.b.2.I12', '4.A.1.b.2.I12.D09', 'Test electrical circuits or components for proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D01', 'Measure materials to mark reference points, cutting lines, or other indicators.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D02', 'Calculate dimensions of workpieces, products, or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D03', 'Measure physical or chemical properties of materials or objects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D04', 'Measure product or material dimensions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D05', 'Measure radiation levels.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D06', 'Measure distances or dimensions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D07', 'Measure physical characteristics of forestry or agricultural products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D08', 'Calculate weights, volumes or other characteristics of materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D09', 'Measure ingredients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D10', 'Measure ingredients or substances to be used in production processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D11', 'Weigh finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D12', 'Measure dimensions of completed products or workpieces to verify conformance to specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D13', 'Weigh parcels to determine shipping costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D14', 'Weigh materials to ensure compliance with specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D15', 'Measure stock or liquid levels in sustainable fuel production systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D16', 'Measure materials or objects for installation or assembly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I01', '4.A.1.b.3.I01.D17', 'Measure the level or depth of water or other liquids.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D01', 'Estimate time or monetary resources needed to complete projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D02', 'Estimate construction project costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D03', 'Estimate maintenance service requirements or costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D04', 'Estimate operational costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D05', 'Estimate green project costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D06', 'Estimate costs for projects or productions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I02', '4.A.1.b.3.I02.D07', 'Estimate costs for labor or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I03', '4.A.1.b.3.I03.D01', 'Calculate financial data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I03', '4.A.1.b.3.I03.D02', 'Compute gaming wins and losses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I03', '4.A.1.b.3.I03.D03', 'Calculate tax information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I03', '4.A.1.b.3.I03.D04', 'Compute debt repayment schedules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I04', '4.A.1.b.3.I04.D01', 'Survey land or properties.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I04', '4.A.1.b.3.I04.D02', 'Measure work site dimensions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I04', '4.A.1.b.3.I04.D03', 'Calculate geographic positions from survey data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I04', '4.A.1.b.3.I04.D04', 'Survey land or bodies of water to measure or determine features.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I04', '4.A.1.b.3.I04.D05', 'Assess locations for potential green technology installations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.1.b.3', '4.A.1.b.3.I05', '4.A.1.b.3.I05.D01', 'Measure clients to ensure proper product fit.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I01', '4.A.2.a.1.I01.D01', 'Evaluate potential problems in home or work environments of clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I01', '4.A.2.a.1.I01.D02', 'Assess patient work, living, or social environments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I01', '4.A.2.a.1.I01.D03', 'Evaluate characteristics of individuals to determine needs or eligibility.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I01', '4.A.2.a.1.I01.D04', 'Assess individual or community needs for educational or social services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D01', 'Evaluate program effectiveness.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D02', 'Evaluate the effectiveness of counseling or educational programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D03', 'Measure effectiveness of business strategies or practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D04', 'Evaluate effectiveness of personnel policies or practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D05', 'Evaluate effectiveness of educational programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D06', 'Evaluate training programs, instructors, or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I02', '4.A.2.a.1.I02.D07', 'Evaluate civic projects or public policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I03', '4.A.2.a.1.I03.D01', 'Assess educational needs of students.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I03', '4.A.2.a.1.I03.D02', 'Administer tests to assess educational needs or progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I03', '4.A.2.a.1.I03.D03', 'Prepare tests.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I03', '4.A.2.a.1.I03.D04', 'Evaluate student work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D01', 'Evaluate performance of educational staff.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D02', 'Evaluate current or prospective maintenance employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D03', 'Evaluate skills of athletes or performers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D04', 'Evaluate employee performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D05', 'Evaluate capabilities or training needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I04', '4.A.2.a.1.I04.D06', 'Evaluate performance of applicants, trainees, or employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I05', '4.A.2.a.1.I05.D01', 'Evaluate log quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I05', '4.A.2.a.1.I05.D02', 'Evaluate quality of plants or crops.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I05', '4.A.2.a.1.I05.D03', 'Evaluate quality of materials or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I05', '4.A.2.a.1.I05.D04', 'Evaluate quality of food ingredients or prepared foods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I06', '4.A.2.a.1.I06.D01', 'Assess physical conditions of patients to aid in diagnosis or treatment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I06', '4.A.2.a.1.I06.D02', 'Evaluate patient functioning, capabilities, or health.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I06', '4.A.2.a.1.I06.D03', 'Evaluate patient outcomes to determine effectiveness of treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I06', '4.A.2.a.1.I06.D04', 'Evaluate treatment options to guide medical decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I06', '4.A.2.a.1.I06.D05', 'Assess skin or hair conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D01', 'Assess the cost effectiveness of products, projects, or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D02', 'Evaluate new technologies or methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D03', 'Evaluate potential of products, technologies, or resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D04', 'Evaluate the characteristics of green technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D05', 'Assess product or process usefulness.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D06', 'Assess database performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D07', 'Evaluate characteristics of equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D08', 'Evaluate utility of software or hardware technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I07', '4.A.2.a.1.I07.D09', 'Evaluate characteristics of products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I08', '4.A.2.a.1.I08.D01', 'Evaluate scholarly materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I09', '4.A.2.a.1.I09.D01', 'Evaluate condition of properties.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I09', '4.A.2.a.1.I09.D02', 'Assess financial status of clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I09', '4.A.2.a.1.I09.D03', 'Appraise property values.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I10', '4.A.2.a.1.I10.D01', 'Evaluate project designs to determine adequacy or feasibility.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.1', '4.A.2.a.1.I10', '4.A.2.a.1.I10.D02', 'Analyze data to determine project feasibility.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D01', 'Verify accuracy of records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D02', 'Verify information or specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D03', 'Verify customer credit information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D04', 'Review accuracy of sales or other transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D05', 'Verify accuracy of financial information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D06', 'Evaluate data quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D07', 'Verify accuracy of data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D08', 'Check data for recording errors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D09', 'Verify accuracy of financial or transactional data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D10', 'Verify mathematical calculations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I01', '4.A.2.a.2.I01.D11', 'Check quality of diagnostic images.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D01', 'Sort mail.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D02', 'Sort materials or objects for processing or transport.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D03', 'Sort recyclable materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D04', 'Sort forestry or agricultural materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D05', 'Sort materials or products for processing, storing, shipping, or grading.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I02', '4.A.2.a.2.I02.D06', 'Sort materials or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D01', 'Compile operational data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D02', 'Compile technical information or documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D03', 'Compile data or documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D04', 'Compile specialized bibliographies or lists of materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D05', 'Compile environmental or climatological data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I03', '4.A.2.a.2.I03.D06', 'Compile geographic or related data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I04', '4.A.2.a.2.I04.D01', 'Reconcile records of sales or other financial transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I04', '4.A.2.a.2.I04.D02', 'Balance receipts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I04', '4.A.2.a.2.I04.D03', 'Prepare cash for deposit or disbursement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I05', '4.A.2.a.2.I05.D01', 'Examine personal documentation to ensure that it is valid.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I05', '4.A.2.a.2.I05.D02', 'Verify employee information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I05', '4.A.2.a.2.I05.D03', 'Verify application data to determine program eligibility.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I05', '4.A.2.a.2.I05.D04', 'Verify accuracy of patient information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.2', '4.A.2.a.2.I05', '4.A.2.a.2.I05.D05', 'Verify patron or staff credentials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D01', 'Examine marketing materials to ensure compliance with policies or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D02', 'Examine documents to verify adherence to requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D03', 'Examine product information to ensure compliance with regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D04', 'Review documents or materials for compliance with policies or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D05', 'Review license or permit applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D06', 'Verify shipping documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D07', 'Review environmental permits, plans, or reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D08', 'Proofread documents, records, or other files to ensure accuracy.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I01', '4.A.2.a.3.I01.D09', 'Review plans or proposals for environmental conservation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I02', '4.A.2.a.3.I02.D01', 'Assess compliance with environmental laws.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I02', '4.A.2.a.3.I02.D02', 'Evaluate green operations or programs for compliance with standards or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I02', '4.A.2.a.3.I02.D03', 'Conduct environmental audits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I02', '4.A.2.a.3.I02.D04', 'Evaluate plans or specifications to determine technological or environmental implications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I03', '4.A.2.a.3.I03.D01', 'Conduct financial or regulatory audits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I03', '4.A.2.a.3.I03.D02', 'Examine financial records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I03', '4.A.2.a.3.I03.D03', 'Examine financial records or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I03', '4.A.2.a.3.I03.D04', 'Review customer insurance information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I03', '4.A.2.a.3.I03.D05', 'Examine financial records to ensure compliance with policies or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I04', '4.A.2.a.3.I04.D01', 'Protect patients or staff members using safety equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.3', '4.A.2.a.3.I04', '4.A.2.a.3.I04.D02', 'Follow protocols or regulations for healthcare activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D01', 'Locate natural resources using geospatial or other environmental data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D02', 'Determine geographic coordinates.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D03', 'Analyze geological samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D04', 'Analyze environmental data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D05', 'Analyze geological or geographical data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D06', 'Analyze Geographic Information Systems (GIS) data for use in green applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I01', '4.A.2.a.4.I01.D07', 'Analyze physical, survey, or geographic data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D01', 'Estimate demand for products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D02', 'Analyze industry trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D03', 'Forecast economic, political, or social trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D04', 'Analyze market conditions or trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D05', 'Analyze website or related online data to track trends or usage.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D06', 'Analyze market or customer related data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D07', 'Analyze consumer trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I02', '4.A.2.a.4.I02.D08', 'Analyze market research data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I03', '4.A.2.a.4.I03.D01', 'Assess risks to business operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I03', '4.A.2.a.4.I03.D02', 'Analyze risks related to investments in green technology.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I03', '4.A.2.a.4.I03.D03', 'Analyze risks to minimize losses or damages.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I04', '4.A.2.a.4.I04.D01', 'Apply mathematical principles or statistical approaches to solve problems in scientific or applied fields.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I04', '4.A.2.a.4.I04.D02', 'Analyze data to identify trends or relationships among variables.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D01', 'Evaluate technical data to determine effect on designs or plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D02', 'Analyze design requirements for computer or electronics systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D03', 'Evaluate designs or specifications to ensure quality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D04', 'Analyze green technology design requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D05', 'Analyze project data to determine specifications or requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D06', 'Analyze design or requirements information for mechanical equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D07', 'Evaluate environmental or sustainability projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I05', '4.A.2.a.4.I05.D08', 'Analyze costs and benefits of proposed designs or projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D01', 'Analyze health-related data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D02', 'Analyze patient data to determine patient needs or treatment goals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D03', 'Analyze test data or images to inform diagnosis or treatment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D04', 'Analyze medical data to determine cause of death.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D05', 'Calculate numerical data for medical activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I06', '4.A.2.a.4.I06.D06', 'Analyze quantitative data to determine effectiveness of treatments or therapies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D01', 'Calculate data to inform organizational operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D02', 'Analyze operational or research data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D03', 'Analyze operational data to evaluate operations, processes or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D04', 'Evaluate energy production data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D05', 'Interpret research or operational data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D06', 'Model operational processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D07', 'Analyze logistics processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D08', 'Analyze forecasting data to improve business decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D09', 'Analyze data to assess operational or project effectiveness.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D10', 'Analyze jobs using observation, survey, or interview techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D11', 'Analyze data to inform personnel decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D12', 'Analyze data to inform operational decisions or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D13', 'Evaluate logistics methods to reduce environmental impact.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D14', 'Analyze data to identify or resolve operational problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D15', 'Analyze shipping information to make routing decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D16', 'Analyze traffic data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I07', '4.A.2.a.4.I07.D17', 'Analyze energy usage data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I08', '4.A.2.a.4.I08.D01', 'Identify implications for cases from legal precedents or other legal information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I09', '4.A.2.a.4.I09.D01', 'Appraise environmental impact of regulations or policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I09', '4.A.2.a.4.I09.D02', 'Analyze environmental regulations to ensure organizational compliance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I09', '4.A.2.a.4.I09.D03', 'Analyze impact of legal or regulatory changes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I09', '4.A.2.a.4.I09.D04', 'Evaluate applicable laws and regulations to determine impact on organizational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D01', 'Analyze laboratory specimens to detect abnormalities or other problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D02', 'Analyze forensic evidence to solve crimes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D03', 'Analyze crime scene evidence.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D04', 'Analyze laboratory findings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D05', 'Analyze biological samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I10', '4.A.2.a.4.I10.D06', 'Analyze chemical compounds or substances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D01', 'Analyze budgetary or accounting data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D02', 'Analyze financial information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D03', 'Apply mathematical models of financial or business conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D04', 'Analyze business or financial data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D05', 'Analyze financial records to improve budgeting or planning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D06', 'Analyze financial records or reports to determine state of operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I11', '4.A.2.a.4.I11.D07', 'Analyze financial records to improve efficiency.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I12', '4.A.2.a.4.I12.D01', 'Conduct quantitative failure analyses of operational data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I12', '4.A.2.a.4.I12.D02', 'Analyze security of systems, network, or data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I12', '4.A.2.a.4.I12.D03', 'Interpret design or operational test results.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I12', '4.A.2.a.4.I12.D04', 'Analyze test or validation data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.a.4', '4.A.2.a.4.I12', '4.A.2.a.4.I12.D05', 'Analyze test or performance data to assess equipment operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D01', 'Estimate costs of products, services, or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D02', 'Determine the value of goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D03', 'Estimate costs or terms of sales.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D04', 'Determine prices for menu items.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D05', 'Calculate shipping costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D06', 'Estimate costs of goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I01', '4.A.2.b.1.I01.D07', 'Calculate costs of goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I02', '4.A.2.b.1.I02.D01', 'Determine causes of operational problems or failures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I02', '4.A.2.b.1.I02.D02', 'Troubleshoot equipment or systems operation problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I02', '4.A.2.b.1.I02.D03', 'Diagnose equipment malfunctions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I03', '4.A.2.b.1.I03.D01', 'Authorize construction activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I03', '4.A.2.b.1.I03.D02', 'Authorize financial actions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I03', '4.A.2.b.1.I03.D03', 'Authorize payments to settle legal disputes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I03', '4.A.2.b.1.I03.D04', 'Approve expenditures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D01', 'Determine metal or plastic production methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D02', 'Determine appropriate locations for operations or installations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D03', 'Determine operational methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D04', 'Determine operational procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D05', 'Determine methods to minimize environmental impact of activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D06', 'Determine food production methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D07', 'Determine forestry techniques or methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D08', 'Determine construction project layouts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D09', 'Determine production equipment settings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D10', 'Determine appropriate methods for data analysis.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D11', 'Determine protocols for medical procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D12', 'Choose optimal transportation routes or speeds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I04', '4.A.2.b.1.I04.D13', 'Determine technical requirements of productions or projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I05', '4.A.2.b.1.I05.D01', 'Make decisions in legal cases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I05', '4.A.2.b.1.I05.D02', 'Rule on admissibility of legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I06', '4.A.2.b.1.I06.D01', 'Diagnose dental conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I06', '4.A.2.b.1.I06.D02', 'Diagnose medical conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I06', '4.A.2.b.1.I06.D03', 'Diagnose neural or psychological disorders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I07', '4.A.2.b.1.I07.D01', 'Edit written materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I07', '4.A.2.b.1.I07.D02', 'Edit documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D01', 'Estimate technical or resource requirements for development or production projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D02', 'Identify information technology project resource requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D03', 'Estimate labor requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D04', 'Calculate specific material, equipment, or labor requirements for production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D05', 'Determine resource needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D06', 'Estimate labor or resource requirements for forestry, fishing, or agricultural operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D07', 'Estimate supplies, ingredients, or staff requirements for food preparation activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D08', 'Estimate cost or material requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D09', 'Estimate material requirements for production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D10', 'Estimate time requirements for development or production projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D11', 'Determine types of equipment, tools, or materials needed for jobs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D12', 'Estimate materials requirements for projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D13', 'Calculate requirements for equipment installation or repair projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I08', '4.A.2.b.1.I08.D14', 'Estimate construction project labor requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D01', 'Implement organizational process or policy changes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D02', 'Implement transportation changes to reduce environmental impact.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D03', 'Apply new technologies to improve work processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D04', 'Implement advertising or marketing initiatives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D05', 'Implement financial decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I09', '4.A.2.b.1.I09.D06', 'Implement design or process improvements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D01', 'Select tools, equipment, or technologies for use in operations or projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D02', 'Select project materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D03', 'Select materials or props.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D04', 'Select equipment, materials, or supplies for cleaning or maintenance activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D05', 'Select production input materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D06', 'Select production equipment according to product specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D07', 'Select construction materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D08', 'Select medical equipment for addressing patient needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D09', 'Select construction equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D10', 'Select educational materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I10', '4.A.2.b.1.I10.D11', 'Select resources needed to accomplish tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I11', '4.A.2.b.1.I11.D01', 'Edit audio or video recordings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.1', '4.A.2.b.1.I11', '4.A.2.b.1.I11.D02', 'Mix sound inputs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D01', 'Develop treatment plans for patients or clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D02', 'Develop medical treatment plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D03', 'Develop exercise or conditioning programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D04', 'Develop patient therapy programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D05', 'Modify treatment plans to accommodate client needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D06', 'Develop treatment plans that use non-medical therapies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I01', '4.A.2.b.2.I01.D07', 'Establish treatment goals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D01', 'Develop software or computer applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D02', 'Develop computer or information systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D03', 'Design computer modeling or simulation programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D04', 'Develop computer or online applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D05', 'Design integrated computer systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D06', 'Develop software or applications for scientific or technical use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D07', 'Modify software programs to improve performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D08', 'Design websites or web applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D09', 'Design video game features or details.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D10', 'Design software applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D11', 'Design healthcare-related software applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I02', '4.A.2.b.2.I02.D12', 'Apply information technology to solve business or other applied problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I03', '4.A.2.b.2.I03.D01', 'Develop business or market strategies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I03', '4.A.2.b.2.I03.D02', 'Develop marketing plans or strategies for environmental initiatives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I03', '4.A.2.b.2.I03.D03', 'Develop marketing plans or strategies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I03', '4.A.2.b.2.I03.D04', 'Develop promotional strategies for religious organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I03', '4.A.2.b.2.I03.D05', 'Develop promotional strategies or plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I04', '4.A.2.b.2.I04.D01', 'Create new recipes or food presentations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I04', '4.A.2.b.2.I04.D02', 'Plan menu options.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I05', '4.A.2.b.2.I05.D01', 'Develop healthcare quality and safety procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I05', '4.A.2.b.2.I05.D02', 'Develop safety standards, policies, or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I05', '4.A.2.b.2.I05.D03', 'Establish rules or policies governing student behavior.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I05', '4.A.2.b.2.I05.D04', 'Develop fire safety or prevention programs or plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I06', '4.A.2.b.2.I06.D01', 'Develop database parameters or specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I06', '4.A.2.b.2.I06.D02', 'Develop technical or scientific databases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I06', '4.A.2.b.2.I06.D03', 'Develop library or archival databases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I06', '4.A.2.b.2.I06.D04', 'Create databases to store electronic data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D01', 'Determine design criteria or specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D02', 'Develop specifications for new products or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D03', 'Develop specifications or procedures for website development or maintenance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D04', 'Develop technical specifications for systems or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D05', 'Develop specifications for computer network operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D06', 'Determine operational criteria or specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I07', '4.A.2.b.2.I07.D07', 'Develop performance metrics or standards related to information technology.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I08', '4.A.2.b.2.I08.D01', 'Plan natural resources conservation or restoration programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I08', '4.A.2.b.2.I08.D02', 'Develop environmental remediation or protection plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I08', '4.A.2.b.2.I08.D03', 'Develop environmental sustainability plans or projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I08', '4.A.2.b.2.I08.D04', 'Develop plans to manage natural or renewable resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I09', '4.A.2.b.2.I09.D01', 'Develop financial plans for clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I09', '4.A.2.b.2.I09.D02', 'Develop financial or business plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I10', '4.A.2.b.2.I10.D01', 'Develop health assessment methods or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I10', '4.A.2.b.2.I10.D02', 'Develop tools to diagnose or assess needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I11', '4.A.2.b.2.I11.D01', 'Plan facility layouts or designs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I11', '4.A.2.b.2.I11.D02', 'Incorporate green features into the design of structures or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I11', '4.A.2.b.2.I11.D03', 'Design civil structures or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I11', '4.A.2.b.2.I11.D04', 'Design structures or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I12', '4.A.2.b.2.I12.D01', 'Develop promotional materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I12', '4.A.2.b.2.I12.D02', 'Create marketing materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I12', '4.A.2.b.2.I12.D03', 'Develop content for sales presentations or other materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I13', '4.A.2.b.2.I13.D01', 'Design templates or patterns.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I13', '4.A.2.b.2.I13.D02', 'Design materials for industrial or commercial applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I13', '4.A.2.b.2.I13.D03', 'Design micro- or nano-scale materials, devices, or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I13', '4.A.2.b.2.I13.D04', 'Design medical devices or appliances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D01', 'Design industrial processing systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D02', 'Develop equipment or component configurations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D03', 'Design industrial equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D04', 'Design energy production or management equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D05', 'Design tools, fixtures, or other devices for production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I14', '4.A.2.b.2.I14.D06', 'Design control systems for mechanical or other equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D01', 'Establish work standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D02', 'Design psychological or educational treatment procedures or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D03', 'Develop instructional objectives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D04', 'Plan experiential learning activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D05', 'Establish operational policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D06', 'Plan educational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D07', 'Develop strategies or programs for students with special needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D08', 'Develop educational programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D09', 'Develop educational or training programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D10', 'Develop educational goals, standards, policies, or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I15', '4.A.2.b.2.I15.D11', 'Develop educational policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D01', 'Design water conservation systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D02', 'Apply knowledge or research findings to address environmental problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D03', 'Protect wildlife or natural areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D04', 'Design environmental control systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D05', 'Design energy-efficient vehicles or vehicle components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D06', 'Design alternative energy systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D07', 'Design systems to reduce harmful emissions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I16', '4.A.2.b.2.I16.D08', 'Design energy-efficient equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I17', '4.A.2.b.2.I17.D01', 'Plan programs to address community mental wellness needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I17', '4.A.2.b.2.I17.D02', 'Plan programs to address community health issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I17', '4.A.2.b.2.I17.D03', 'Design public or employee health programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D01', 'Prepare drawings or diagrams of products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D02', 'Prepare production storyboards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D03', 'Create graphical representations of civil structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D04', 'Create images of data, locations, or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D05', 'Create electrical schematics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D06', 'Create graphical representations of energy production systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D07', 'Create construction or installation diagrams.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D08', 'Create schematic drawings for electronics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D09', 'Design layout of art or product exhibits, displays, or promotional materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D10', 'Create diagrams or blueprints for workpieces or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D11', 'Prepare maps.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D12', 'Design layouts for print publications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D13', 'Develop diagrams or flow charts of system operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D14', 'Prepare graphics or other visual representations of information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D15', 'Draw detailed or technical illustrations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D16', 'Create graphical representations of structures or landscapes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D17', 'Create computer-generated graphics or animation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D18', 'Create graphical representations of mechanical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D19', 'Create maps.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D20', 'Create images or other visual displays.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I18', '4.A.2.b.2.I18.D21', 'Create graphical representations of industrial production systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I19', '4.A.2.b.2.I19.D01', 'Develop emergency procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I19', '4.A.2.b.2.I19.D02', 'Maintain contingency plans for disaster recovery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I19', '4.A.2.b.2.I19.D03', 'Develop contingency plans to deal with organizational emergencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I19', '4.A.2.b.2.I19.D04', 'Develop emergency response plans or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I20', '4.A.2.b.2.I20.D01', 'Develop operating strategies, plans, or procedures for green or sustainable operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I20', '4.A.2.b.2.I20.D02', 'Develop sustainable business strategies or practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I20', '4.A.2.b.2.I20.D03', 'Develop sustainable organizational policies or practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I20', '4.A.2.b.2.I20.D04', 'Develop sustainable industrial or development methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I20', '4.A.2.b.2.I20.D05', 'Develop operational methods or processes that use green materials or emphasize sustainability.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I21', '4.A.2.b.2.I21.D01', 'Create models of engineering designs or methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I21', '4.A.2.b.2.I21.D02', 'Develop models of information or communications systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I21', '4.A.2.b.2.I21.D03', 'Create physical models or prototypes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I22', '4.A.2.b.2.I22.D01', 'Analyze information obtained from news sources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I22', '4.A.2.b.2.I22.D02', 'Determine presentation subjects or content.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D01', 'Devise research or testing protocols.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D02', 'Develop biological research methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D03', 'Develop methods of social or economic research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D04', 'Design research studies to obtain scientific information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D05', 'Plan biological research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D06', 'Plan environmental research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D07', 'Develop environmental research methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I23', '4.A.2.b.2.I23.D08', 'Plan social sciences research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I24', '4.A.2.b.2.I24.D01', 'Design electromechanical equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I24', '4.A.2.b.2.I24.D02', 'Design electrical equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I24', '4.A.2.b.2.I24.D03', 'Design electronic or computer equipment or instrumentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I25', '4.A.2.b.2.I25.D01', 'Create musical compositions, arrangements or scores.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I25', '4.A.2.b.2.I25.D02', 'Design costumes or cosmetic effects for characters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I25', '4.A.2.b.2.I25.D03', 'Choreograph dances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I25', '4.A.2.b.2.I25.D04', 'Design jewelry or decorative objects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I25', '4.A.2.b.2.I25.D05', 'Develop artistic or design concepts for decoration, exhibition, or commercial purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I26', '4.A.2.b.2.I26.D01', 'Develop theories or models of physical phenomena.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I26', '4.A.2.b.2.I26.D02', 'Develop mathematical models of environmental conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I26', '4.A.2.b.2.I26.D03', 'Develop scientific or mathematical models.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I26', '4.A.2.b.2.I26.D04', 'Develop theories or models of social phenomena.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I27', '4.A.2.b.2.I27.D01', 'Develop program goals or plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I27', '4.A.2.b.2.I27.D02', 'Develop organizational goals or objectives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.2', '4.A.2.b.2.I27', '4.A.2.b.2.I27.D03', 'Develop plans for programs or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D01', 'Review professional literature to maintain professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D02', 'Maintain professional social services knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D03', 'Stay informed about current developments in field of specialization.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D04', 'Attend events to develop professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D05', 'Maintain current knowledge related to work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D06', 'Update knowledge of legal or regulatory environments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D07', 'Update knowledge about emerging industry or technology trends.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D08', 'Maintain knowledge of current developments in area of expertise.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D09', 'Attend conferences or workshops to maintain professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D10', 'Research topics in area of expertise.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D11', 'Update job related knowledge or skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D12', 'Maintain medical or professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D13', 'Conduct research to inform art, designs, or other work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D14', 'Attend training to learn new skills or update knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D15', 'Maintain knowledge of laws or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D16', 'Maintain professional knowledge or certifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D17', 'Maintain knowledge of business operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D18', 'Attend training sessions or professional meetings to develop or maintain professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D19', 'Attend educational events to update medical knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D20', 'Update technical knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D21', 'Update professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D22', 'Study product information to acquire professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.3', '4.A.2.b.3.I01', '4.A.2.b.3.I01.D23', 'Review laws or regulations to maintain professional knowledge.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D01', 'Develop organizational policies or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D02', 'Develop operating strategies, plans, or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D03', 'Establish organizational guidelines or policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D04', 'Develop organizational methods or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D05', 'Establish business management methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I01', '4.A.2.b.4.I01.D06', 'Determine pricing or monetary policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I02', '4.A.2.b.4.I02.D01', 'Draft legislation or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D01', 'Develop procedures for data management.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D02', 'Establish nursing policies or standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D03', 'Develop information communication procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D04', 'Develop business or financial information systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D05', 'Develop policies or procedures for archives, museums or libraries.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D06', 'Develop financial analysis methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D07', 'Establish standards for medical care.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D08', 'Develop guidelines for system implementation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D09', 'Develop computer or information security policies or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D10', 'Develop data analysis or data management procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D11', 'Develop technical processes to improve the efficiency of biofuel production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D12', 'Develop new or advanced products or production methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D13', 'Develop procedures to evaluate organizational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D14', 'Develop technical methods or processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D15', 'Develop testing routines or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D16', 'Develop procedures for data entry or processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D17', 'Establish standards for products, processes, or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.4', '4.A.2.b.4.I03', '4.A.2.b.4.I03.D18', 'Develop agricultural methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I01', '4.A.2.b.5.I01.D01', 'Arrange facility schedules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I01', '4.A.2.b.5.I01.D02', 'Schedule dining reservations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I01', '4.A.2.b.5.I01.D03', 'Schedule medical facility use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I01', '4.A.2.b.5.I01.D04', 'Schedule activities or facility use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D01', 'Schedule product or material transportation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D02', 'Arrange maintenance activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D03', 'Schedule instructional activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D04', 'Schedule equipment maintenance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D05', 'Schedule agricultural or forestry work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D06', 'Schedule repair, installation or maintenance activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I02', '4.A.2.b.5.I02.D07', 'Schedule operational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I03', '4.A.2.b.5.I03.D01', 'Schedule appointments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I03', '4.A.2.b.5.I03.D02', 'Schedule patient procedures or appointments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.5', '4.A.2.b.5.I03', '4.A.2.b.5.I03.D03', 'Schedule appointments with prospective customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I01', '4.A.2.b.6.I01.D01', 'Plan special events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I01', '4.A.2.b.6.I01.D02', 'Plan conferences, programs, or special events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I01', '4.A.2.b.6.I01.D04', 'Plan implementation or promotion of recycling programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I01', '4.A.2.b.6.I01.D05', 'Plan community programs or activities for the general public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D01', 'Plan layout of construction, installation, or repairs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D02', 'Plan work procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D03', 'Plan work operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D04', 'Plan flight operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D05', 'Adjust routes or speeds as necessary.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D06', 'Plan trapping or hunting activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D07', 'Prepare detailed work plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D08', 'Develop detailed project plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.2.b.6', '4.A.2.b.6.I02', '4.A.2.b.6.I02.D09', 'Plan production or operational procedures or sequences.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D01', 'Prepare compounds or solutions to be used for repairs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D02', 'Mix ingredients to create specific finishes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D03', 'Mix ingredients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D04', 'Mix substances or compounds needed for work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D05', 'Prepare chemicals for work application.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D06', 'Prepare materials or solutions for animal or plant use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D07', 'Prepare medications or medical solutions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I01', '4.A.3.a.1.I01.D08', 'Mix substances to create chemical solutions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I02', '4.A.3.a.1.I02.D01', 'Operate firefighting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I02', '4.A.3.a.1.I02.D02', 'Protect property from fire or water damage.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I02', '4.A.3.a.1.I02.D03', 'Perform forest firefighting activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D01', 'Clean vessels or marine equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D02', 'Clean food preparation areas, facilities, or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D03', 'Clean furniture or fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D04', 'Clean equipment or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D05', 'Clean work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D06', 'Clean facilities or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D07', 'Clean patient rooms or patient treatment rooms.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D08', 'Sterilize food cooking or processing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D09', 'Clean facilities or work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D10', 'Maintain clean work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D11', 'Clean building walls or flooring.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D12', 'Clean facilities or sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D13', 'Clean work sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D14', 'Clean machinery or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D15', 'Clean tools or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D16', 'Clean equipment, parts, or tools to repair or maintain them in good working order.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D17', 'Decontaminate equipment or sites to remove hazardous or toxic substances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D18', 'Perform housekeeping duties.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D19', 'Clean equipment or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D20', 'Clean surfaces in preparation for work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D21', 'Clean production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D23', 'Clean food service areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D24', 'Remove snow.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I03', '4.A.3.a.1.I03.D25', 'Clean vehicles or vehicle components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I04', '4.A.3.a.1.I04.D01', 'Protect structures or surfaces near work areas to avoid damage.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I04', '4.A.3.a.1.I04.D02', 'Apply protective coverings to objects or surfaces near work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D01', 'Dispose of biomedical waste in accordance with standards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D02', 'Dispose of hazardous materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D03', 'Remove debris from work sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D04', 'Remove trash.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D05', 'Remove worn, damaged or outdated materials from work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D06', 'Remove debris or vegetation from work sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D07', 'Dispose of trash or waste materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D08', 'Remove excess materials from finished construction projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I05', '4.A.3.a.1.I05.D09', 'Remove debris or damaged materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D01', 'Load shipments, belongings, or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D02', 'Load materials into equipment for processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D03', 'Load or unload materials used in construction or extraction.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D04', 'Place materials into molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D05', 'Load materials into construction equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D06', 'Load materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D07', 'Load agricultural or forestry products for shipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D08', 'Stack finished items for further processing or shipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D09', 'Secure cargo.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D10', 'Load materials into production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D11', 'Unload materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I06', '4.A.3.a.1.I06.D12', 'Load items into ovens or furnaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D01', 'Dig holes or trenches.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D02', 'Prepare surfaces for finishing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D03', 'Pour materials into or on designated areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D04', 'Shovel materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D05', 'Spread sand, dirt or other loose materials onto surfaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D06', 'Apply adhesives to construction materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D07', 'Assist skilled construction or extraction personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D08', 'Compact materials to create level bases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D09', 'Spread concrete or other aggregate mixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I07', '4.A.3.a.1.I07.D10', 'Finish concrete surfaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D01', 'Operate garment treatment equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D02', 'Clean fabrics or apparel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D03', 'Clean tableware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D04', 'Apply water or solutions to fabrics or apparel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D05', 'Clean workpieces or finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D06', 'Clean objects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I08', '4.A.3.a.1.I08.D07', 'Clean materials to prepare them for production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I09', '4.A.3.a.1.I09.D01', 'Sterilize medical equipment or instruments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I09', '4.A.3.a.1.I09.D02', 'Clean medical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I09', '4.A.3.a.1.I09.D03', 'Clean medical equipment or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D01', 'Transport biological or other medical materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D02', 'Move equipment, supplies or food to required locations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D03', 'Transport animals, crops, or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D04', 'Move materials, equipment, or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D05', 'Deliver items.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D06', 'Move large objects using heavy equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D07', 'Handle caskets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D08', 'Move furniture.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D09', 'Handle luggage or other possessions for patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D10', 'Move construction or extraction materials to locations where they are needed.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I10', '4.A.3.a.1.I10.D11', 'Move products, materials, or equipment between work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D01', 'Use weapons or physical force to maintain security.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D02', 'Block physical access to restricted areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D03', 'Provide security escorts for officials, jury members, or other individuals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D04', 'Detain suspects or witnesses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D05', 'Maintain public order or security.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D06', 'Guard facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D07', 'Maintain security.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D08', 'Apprehend criminal suspects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D09', 'Confiscate prohibited or dangerous items.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D10', 'Enforce rules or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D11', 'Search individuals for illegal or dangerous items.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D12', 'Prevent unauthorized individuals from entering restricted areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I11', '4.A.3.a.1.I11.D13', 'Maintain safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D01', 'Guide patrons on tours.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D02', 'Provide escort or transportation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D03', 'Usher patrons to seats or exits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D04', 'Accompany patients or clients on outings to provide assistance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D05', 'Escort prisoners to courtrooms, prisons, or other facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I12', '4.A.3.a.1.I12.D06', 'Accompany individuals or groups to activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I13', '4.A.3.a.1.I13.D01', 'Transport clients to appointments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I13', '4.A.3.a.1.I13.D02', 'Move patients to or from treatment areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I14', '4.A.3.a.1.I14.D01', 'Climb ladders or vehicles to perform duties.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I14', '4.A.3.a.1.I14.D02', 'Climb equipment or structures to access work areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I15', '4.A.3.a.1.I15.D01', 'Arrange tables or dining areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I15', '4.A.3.a.1.I15.D02', 'Serve food or beverages.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I15', '4.A.3.a.1.I15.D03', 'Collect dirty dishes or other tableware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I16', '4.A.3.a.1.I16.D01', 'Participate in athletic events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I16', '4.A.3.a.1.I16.D02', 'Participate in physical training to maintain fitness.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I16', '4.A.3.a.1.I16.D03', 'Practice athletic or artistic skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D01', 'Harvest agricultural products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D02', 'Perform manual agricultural, aquacultural, or horticultural tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D03', 'Cultivate lawns, turf, or gardens.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D04', 'Prepare land for agricultural use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D05', 'Plant greenery to improve landscape appearance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D06', 'Plant crops, trees, or other plants.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D07', 'Cultivate land.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.1', '4.A.3.a.1.I17', '4.A.3.a.1.I17.D08', 'Irrigate lawns, trees, or plants.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D01', 'Install carpet or flooring.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D02', 'Install insulation in equipment or structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D03', 'Install masonry materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D04', 'Assemble structural components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D05', 'Install fencing or other barriers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D06', 'Install metal structural components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D07', 'Install structural foundations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D08', 'Assemble temporary equipment or structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D09', 'Build agricultural structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D10', 'Install safety or support equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D11', 'Install trim or paneling.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D12', 'Assemble metal structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D13', 'Install building fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D14', 'Install doors or windows.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D15', 'Install roofing materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D16', 'Construct exhibits or parts of exhibits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D17', 'Install wooden structural components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D18', 'Install equipment to protect or support trees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D19', 'Install hardware or other interior fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I01', '4.A.3.a.2.I01.D20', 'Install green structural components, equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I02', '4.A.3.a.2.I02.D01', 'Collect samples for analysis or testing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I02', '4.A.3.a.2.I02.D02', 'Collect samples of raw materials or finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I02', '4.A.3.a.2.I02.D03', 'Collect samples of materials or products for testing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D01', 'Cut cooked or raw foods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D02', 'Prepare foods for cooking or serving.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D03', 'Prepare meat products for sale or consumption.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D04', 'Add garnishes to food.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D05', 'Assist chefs or caterers with food or drink preparation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D06', 'Prepare hot or cold beverages.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D07', 'Cook foods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D08', 'Arrange food for serving.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D09', 'Prepare breads or doughs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D10', 'Cut meat products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I03', '4.A.3.a.2.I03.D11', 'Prepare foods or meals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D01', 'Install parts, assemblies, or attachments in transportation or material handling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D02', 'Assemble equipment or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D03', 'Reassemble equipment after repair.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D04', 'Assemble precision electronics or optical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D05', 'Assemble machine tools, parts, or fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D06', 'Assemble electromechanical or hydraulic systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D07', 'Install vehicle parts or accessories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D08', 'Install machine or equipment replacement parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D09', 'Bolt objects into place.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D10', 'Assemble products or production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D11', 'Assemble electrical or electronic equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D12', 'Assemble mechanical components or machine parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D13', 'Install gauges or controls.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I04', '4.A.3.a.2.I04.D14', 'Assemble electrical components, subsystems, or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I05', '4.A.3.a.2.I05.D01', 'Sew clothing or other articles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I05', '4.A.3.a.2.I05.D02', 'Sew materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I05', '4.A.3.a.2.I05.D03', 'Repair textiles or apparel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I05', '4.A.3.a.2.I05.D04', 'Operate sewing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D01', 'Feed materials or products into or through equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D02', 'Mount attachments or tools onto production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D03', 'Mount materials or workpieces onto production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D04', 'Maneuver workpieces in equipment during production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D05', 'Adjust fabrics or other materials during garment production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I06', '4.A.3.a.2.I06.D06', 'Position raw materials on processing or production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D01', 'Reshape metal workpieces to established specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D02', 'Shape clay or dough to create products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D03', 'Shape glass or similar materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D04', 'Reshape small metal components for precision assembly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D05', 'Shape metal workpieces with hammers or other small hand tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I07', '4.A.3.a.2.I07.D06', 'Shape surfaces or edges of wood workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I08', '4.A.3.a.2.I08.D01', 'Arrange artwork, products, or props.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I08', '4.A.3.a.2.I08.D02', 'Set up merchandise displays.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I08', '4.A.3.a.2.I08.D03', 'Prepare materials for preservation, storage, or display.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I08', '4.A.3.a.2.I08.D04', 'Decorate indoor or outdoor spaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I08', '4.A.3.a.2.I08.D05', 'Arrange items for use or display.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D01', 'Adjust tuning or functioning of musical instruments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D02', 'Adjust equipment controls to regulate gas flow.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D03', 'Adjust equipment controls to regulate flow of production materials or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D04', 'Calibrate scientific or technical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D05', 'Adjust equipment to ensure optimal performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D06', 'Calibrate equipment to specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D07', 'Adjust temperature controls of ovens or other heating equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D08', 'Set equipment controls to meet cutting specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D09', 'Adjust settings or positions of medical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D10', 'Adjust office equipment to ensure proper operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D11', 'Adjust the tension of nuts or bolts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D12', 'Adjust equipment controls to regulate coolant flow.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D13', 'Adjust equipment controls to regulate flow of water, cleaning solutions, or other liquids.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D14', 'Adjust flow of electricity to tools or production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D15', 'Adjust vehicle components according to specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I09', '4.A.3.a.2.I09.D16', 'Control power supply connections.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I10', '4.A.3.a.2.I10.D01', 'Train animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I11', '4.A.3.a.2.I11.D01', 'Prepare medical supplies or equipment for use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I11', '4.A.3.a.2.I11.D02', 'Prepare medical instruments or equipment for use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I11', '4.A.3.a.2.I11.D03', 'Prepare patient treatment areas for use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D01', 'Cut openings in existing structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D02', 'Trim excess material from workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D03', 'Cut materials according to specifications or needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D04', 'Cut industrial materials in preparation for fabrication or processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D05', 'Cut tile, stone, or other masonry materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D06', 'Cut metal components for installation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D07', 'Cut wood components for installation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D08', 'Cut fabrics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D09', 'Trim excess material from installations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D10', 'Cut glass.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I12', '4.A.3.a.2.I12.D11', 'Cut carpet, vinyl or other flexible materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D01', 'Prepare explosives for detonation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D02', 'Immerse objects or workpieces in cleaning or coating solutions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D03', 'Prepare excavation or extraction sites for commissioning or decommissioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D04', 'Prepare hazardous waste for processing or disposal.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D05', 'Heat material or workpieces to prepare for or complete production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D06', 'Melt metal, plastic, or other materials to prepare for production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D07', 'Prepare fabrics or materials for processing or production.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D08', 'Prepare biological feedstock for physical, chemical, or biological processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D09', 'Prepare materials for processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D10', 'Skim impurities from molten metal.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I13', '4.A.3.a.2.I13.D11', 'Ignite fuel to activate heating equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I14', '4.A.3.a.2.I14.D01', 'Cut trees or logs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I14', '4.A.3.a.2.I14.D02', 'Trim trees or other vegetation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D01', 'Grind parts to required dimensions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D02', 'Remove dents from equipment, materials, tools or structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D03', 'Smooth surfaces of objects or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D04', 'Polish materials, workpieces, or finished products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D05', 'Smooth metal surfaces or edges.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I15', '4.A.3.a.2.I15.D06', 'Smooth surfaces with abrasive materials or tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I16', '4.A.3.a.2.I16.D01', 'Install energy-efficient heating, ventilation, or air conditioning (HVAC) equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I16', '4.A.3.a.2.I16.D02', 'Install solar energy systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I16', '4.A.3.a.2.I16.D03', 'Install heating, ventilation, or air conditioning (HVAC) equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I17', '4.A.3.a.2.I17.D01', 'Cast molds of patient anatomies to create medical or dental devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I17', '4.A.3.a.2.I17.D02', 'Make patient-assistive devices or device models.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I17', '4.A.3.a.2.I17.D03', 'Fabricate medical devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I17', '4.A.3.a.2.I17.D04', 'Construct customized assistive medical or dental devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I18', '4.A.3.a.2.I18.D01', 'Direct vehicle traffic.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D01', 'Remove parts or components from vehicles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D02', 'Disassemble equipment for maintenance or repair.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D03', 'Disassemble equipment to inspect for deficiencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D04', 'Remove accessories, tools, or other parts from equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D05', 'Dismantle equipment or temporary structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D06', 'Remove parts or components from equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I19', '4.A.3.a.2.I19.D07', 'Dismantle heavy equipment or machinery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D01', 'Install electrical components, equipment, or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D02', 'Install drilling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D03', 'Install audio or communications equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D04', 'Install production equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D05', 'Install instrumentation or electronic equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D06', 'Install metering equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I20', '4.A.3.a.2.I20.D07', 'Install home appliances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I21', '4.A.3.a.2.I21.D01', 'Treat nails by shaping, decorating, or augmenting.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I21', '4.A.3.a.2.I21.D02', 'Apply cleansing or conditioning agents to client hair, scalp, or skin.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I21', '4.A.3.a.2.I21.D03', 'Apply solutions to hair for therapeutic or cosmetic purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I21', '4.A.3.a.2.I21.D04', 'Apply makeup to alter or enhance appearance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D01', 'Adjust position of molds during processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D02', 'Position safety or support equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D03', 'Position animal trapping or capture equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D04', 'Position construction forms or molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D05', 'Position construction or extraction equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D06', 'Position equipment using hand tools, power tools, or heavy equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D07', 'Position patterns on equipment, materials, or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D08', 'Level machines or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D09', 'Position containers to receive materials or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I22', '4.A.3.a.2.I22.D10', 'Position material handling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I23', '4.A.3.a.2.I23.D01', 'Secure watercraft to docks, wharves or other vessels.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I24', '4.A.3.a.2.I24.D01', 'Adjust prostheses or other assistive devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I24', '4.A.3.a.2.I24.D02', 'Adjust dental devices or appliances to ensure fit.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I25', '4.A.3.a.2.I25.D01', 'Engrave designs, text, or other markings onto materials, workpieces, or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I26', '4.A.3.a.2.I26.D01', 'Embalm corpses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I27', '4.A.3.a.2.I27.D01', 'Fabricate devices or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I27', '4.A.3.a.2.I27.D02', 'Fabricate parts or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I27', '4.A.3.a.2.I27.D03', 'Fabricate products or components using machine tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I28', '4.A.3.a.2.I28.D01', 'Attach decorative or functional accessories to products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I28', '4.A.3.a.2.I28.D02', 'Construct distinctive physical objects for artistic, functional, or commercial purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I29', '4.A.3.a.2.I29.D01', 'Slaughter animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I29', '4.A.3.a.2.I29.D02', 'Remove skin or other body parts from animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I29', '4.A.3.a.2.I29.D03', 'Process animal carcasses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I30', '4.A.3.a.2.I30.D01', 'Drill holes in earth or rock.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I30', '4.A.3.a.2.I30.D02', 'Drill holes in construction materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I30', '4.A.3.a.2.I30.D03', 'Drill holes in parts, equipment, or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I31', '4.A.3.a.2.I31.D01', 'Groom wigs or hairpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I31', '4.A.3.a.2.I31.D02', 'Trim client hair.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I32', '4.A.3.a.2.I32.D01', 'Set up classroom materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I32', '4.A.3.a.2.I32.D02', 'Arrange childcare or educational settings to ensure physical safety of children.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I32', '4.A.3.a.2.I32.D03', 'Display student work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D01', 'Treat facilities to eliminate pests.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D02', 'Paint surfaces or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D03', 'Apply paint to surfaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D04', 'Refinish wood or metal surfaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D05', 'Apply chemical solutions to plants to protect against disease or insects or to enhance growth.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D06', 'Apply protective or decorative finishes to workpieces or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D07', 'Treat greenery or surfaces with protective substances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D08', 'Apply solutions to production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I33', '4.A.3.a.2.I33.D09', 'Apply sealants or other protective coatings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D01', 'Connect hoses to equipment or machinery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D02', 'Rewire electrical or electronic systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D03', 'Connect hoses to equipment or piping.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D04', 'Lay cables to connect equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D05', 'Thread wire or cable through ducts or conduits.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D06', 'Run wiring to connect equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D07', 'Connect electrical components or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D08', 'Connect supply lines to production equipment or tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I34', '4.A.3.a.2.I34.D09', 'Connect cables or electrical lines.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I35', '4.A.3.a.2.I35.D01', 'Solder parts or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I35', '4.A.3.a.2.I35.D02', 'Weld metal components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I35', '4.A.3.a.2.I35.D03', 'Solder parts or connections between parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I35', '4.A.3.a.2.I35.D04', 'Braze metal parts or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I35', '4.A.3.a.2.I35.D05', 'Operate welding equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D01', 'Build models, patterns, or templates.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D02', 'Assemble garments or textile products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D03', 'Build production molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D04', 'Assemble wood products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D05', 'Build construction forms or molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D06', 'Assemble tires.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D07', 'Construct patterns, templates, or other work aids.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I36', '4.A.3.a.2.I36.D08', 'Assemble metal or plastic parts or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D01', 'Stock products or parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D02', 'Stock medical or patient care supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D03', 'Store records or related materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D04', 'Store supplies or goods in kitchens or storage areas.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D05', 'Stock serving stations or dining areas with food or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D06', 'Stock supplies or merchandise.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I37', '4.A.3.a.2.I37.D07', 'Store items.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I38', '4.A.3.a.2.I38.D01', 'Collect biological specimens from patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I38', '4.A.3.a.2.I38.D02', 'Collect biological specimens.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I38', '4.A.3.a.2.I38.D03', 'Collect geographical or geological field data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I38', '4.A.3.a.2.I38.D04', 'Collect geological samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I38', '4.A.3.a.2.I38.D05', 'Collect environmental data or samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I39', '4.A.3.a.2.I39.D01', 'Apply mortar.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I39', '4.A.3.a.2.I39.D02', 'Seal gaps or cracks to prevent leakage or moisture intrusion.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I39', '4.A.3.a.2.I39.D03', 'Fill cracks, imperfections, or holes in products or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I39', '4.A.3.a.2.I39.D04', 'Apply material to fill gaps in surfaces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I40', '4.A.3.a.2.I40.D01', 'Apply parting agents or other solutions to molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I40', '4.A.3.a.2.I40.D02', 'Remove workpieces from molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I40', '4.A.3.a.2.I40.D03', 'Remove products or workpieces from production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D01', 'Align equipment or machinery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D02', 'Lay out parts to prepare for assembly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D03', 'Position structural components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D04', 'Align parts or workpieces to ensure proper assembly.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D05', 'Mark reference points on construction materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D06', 'Lay out work according to specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D07', 'Align masonry materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I41', '4.A.3.a.2.I41.D08', 'Draw guide lines or markings on materials or workpieces using patterns or other references.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D01', 'Package agricultural products for shipment or further processing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D02', 'Package products for storage or shipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D03', 'Package food or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D04', 'Package materials for transport.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D05', 'Package materials or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I42', '4.A.3.a.2.I42.D06', 'Package objects for shipping.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I43', '4.A.3.a.2.I43.D01', 'Install green plumbing or water handling systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I43', '4.A.3.a.2.I43.D02', 'Install piping for installation or maintenance activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I43', '4.A.3.a.2.I43.D03', 'Install plumbing or piping.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I44', '4.A.3.a.2.I44.D01', 'Locate animals for fishing or hunting purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I44', '4.A.3.a.2.I44.D02', 'Capture or kill animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I45', '4.A.3.a.2.I45.D01', 'Apply decorative masonry finishes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I45', '4.A.3.a.2.I45.D02', 'Apply finishes to artwork, crafts, or displays.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I45', '4.A.3.a.2.I45.D03', 'Apply decorative or textured finishes or coverings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I45', '4.A.3.a.2.I45.D04', 'Apply decorative coloring to photographs or printed materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D01', 'Install equipment attachments or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D02', 'Set up material handling gear or equipment, such as rigging, packaging, or temporary structures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D03', 'Attach rigging to objects so they can be moved.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D04', 'Prepare film for distribution or use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D05', 'Set equipment guides, stops, spacers, or other fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D06', 'Set up still or video cameras or related equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D07', 'Prepare hoses or water supplies to fight fires.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D08', 'Install mechanical components in production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D09', 'Attach equipment extensions or accessories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I46', '4.A.3.a.2.I46.D10', 'Set up laboratory or field equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I47', '4.A.3.a.2.I47.D01', 'Cultivate micro-organisms for study, testing, or medical preparations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I47', '4.A.3.a.2.I47.D02', 'Prepare biological specimens for laboratory analysis.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I47', '4.A.3.a.2.I47.D03', 'Prepare biological samples for testing or analysis.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.2', '4.A.3.a.2.I47', '4.A.3.a.2.I47.D04', 'Prepare compounds or solutions for products or testing.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I01', '4.A.3.a.3.I01.D01', 'Operate office equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I02', '4.A.3.a.3.I02.D01', 'Operate pumping systems or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I02', '4.A.3.a.3.I02.D02', 'Operate pumps or compressors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I02', '4.A.3.a.3.I02.D03', 'Control pumps or pumping equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D01', 'Operate drilling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D02', 'Operate heavy-duty construction or installation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D03', 'Operate mining equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D04', 'Operate excavation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D05', 'Break up rock, asphalt, or concrete.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D06', 'Operate road-surfacing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D07', 'Operate equipment or vehicles to clear construction sites or move materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I03', '4.A.3.a.3.I03.D08', 'Operate detonation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I04', '4.A.3.a.3.I04.D01', 'Process x-rays or other medical images.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I04', '4.A.3.a.3.I04.D02', 'Create advanced digital images of patients using computer imaging systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I04', '4.A.3.a.3.I04.D03', 'Operate diagnostic or therapeutic medical instruments or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I04', '4.A.3.a.3.I04.D04', 'Operate diagnostic imaging equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I04', '4.A.3.a.3.I04.D05', 'Operate medical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D01', 'Operate control consoles for sound, lighting or video.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D02', 'Operate surveillance equipment to detect suspicious or illegal activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D03', 'Operate audiovisual equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D04', 'Operate still or video cameras or related equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D05', 'Operate audio-visual equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I05', '4.A.3.a.3.I05.D06', 'Operate audio recording equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D01', 'Operate chemical processing or water treatment systems or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D02', 'Operate painting or coating equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D03', 'Operate recycling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D04', 'Operate packing or other material processing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D05', 'Smooth garments with irons, presses, or steamers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D06', 'Operate cooking, baking, or other food preparation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D07', 'Operate heating or drying equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D08', 'Operate mixing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D09', 'Operate conveyors or other industrial material moving equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D10', 'Operate photographic developing or print production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D11', 'Operate equipment to print images or bind printed images together.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D12', 'Operate metal or plastic forming equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I06', '4.A.3.a.3.I06.D13', 'Operate industrial equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D01', 'Operate energy production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D02', 'Operate natural gas generation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D03', 'Operate biomass or biofuel production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D04', 'Operate green energy production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D05', 'Operate energy distribution equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I07', '4.A.3.a.3.I07.D06', 'Operate natural gas distribution equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I08', '4.A.3.a.3.I08.D01', 'Operate forklifts or other loaders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I08', '4.A.3.a.3.I08.D02', 'Lift materials or workpieces using cranes or other lifting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I08', '4.A.3.a.3.I08.D03', 'Operate cranes, hoists, or other moving or lifting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I09', '4.A.3.a.3.I09.D01', 'Operate laboratory or field equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I09', '4.A.3.a.3.I09.D02', 'Operate precision equipment to control microscopic or nanoscopic processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I09', '4.A.3.a.3.I09.D03', 'Operate laboratory equipment to analyze medical samples.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I10', '4.A.3.a.3.I10.D01', 'Operate communications equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I10', '4.A.3.a.3.I10.D02', 'Operate communications, transmissions, or broadcasting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I11', '4.A.3.a.3.I11.D01', 'Operate irrigation systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I11', '4.A.3.a.3.I11.D02', 'Operate forestry equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I11', '4.A.3.a.3.I11.D03', 'Operate grounds maintenance equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I11', '4.A.3.a.3.I11.D04', 'Operate farming equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I12', '4.A.3.a.3.I12.D01', 'Operate grinding equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I12', '4.A.3.a.3.I12.D02', 'Operate cutting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I12', '4.A.3.a.3.I12.D03', 'Operate woodworking equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.3', '4.A.3.a.3.I12', '4.A.3.a.3.I12.D04', 'Operate textile cutting or production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D01', 'Operate ships or other watercraft.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D02', 'Navigate water vessels.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D03', 'Drive vehicles to transport individuals or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D04', 'Follow safety procedures for vehicle operation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D05', 'Travel to work sites to perform installation, repair or maintenance work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D06', 'Operate vehicles or material-moving equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D07', 'Operate transportation equipment to demonstrate function or malfunction.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D08', 'Control equipment that regulates vehicle traffic.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D09', 'Drive vehicles to transport patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D10', 'Drive trucks or truck-mounted equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D11', 'Pilot aircraft.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D12', 'Drive trucks or other vehicles to or at work sites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D13', 'Operate locomotives or other rail vehicles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.a.4', '4.A.3.a.4.I01', '4.A.3.a.4.I01.D14', 'Drive passenger vehicles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I01', '4.A.3.b.1.I01.D01', 'Enter commands, instructions, or specifications into equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I01', '4.A.3.b.1.I01.D02', 'Program equipment to perform production tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I01', '4.A.3.b.1.I01.D03', 'Write computer programming code.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I01', '4.A.3.b.1.I01.D04', 'Program robotic equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I02', '4.A.3.b.1.I02.D01', 'Implement security measures for computer or information systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I02', '4.A.3.b.1.I02.D02', 'Create electronic data backup to prevent loss of information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I03', '4.A.3.b.1.I03.D01', 'Install computer software.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I03', '4.A.3.b.1.I03.D02', 'Install computer hardware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I03', '4.A.3.b.1.I03.D03', 'Install programs onto computer or computer-controlled equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I03', '4.A.3.b.1.I03.D04', 'Configure computer networks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I04', '4.A.3.b.1.I04.D01', 'Resolve computer network problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I04', '4.A.3.b.1.I04.D02', 'Troubleshoot issues with computer applications or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I04', '4.A.3.b.1.I04.D03', 'Resolve computer software problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I05', '4.A.3.b.1.I05.D01', 'Operate computers or computerized equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I05', '4.A.3.b.1.I05.D02', 'Operate computer systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D01', 'Load digital images onto computers or websites.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D02', 'Operate digital imaging equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D03', 'Enter patient or treatment data into computers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D04', 'Update website content.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D05', 'Update computer database information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D06', 'Enter information into databases or software programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D07', 'Prepare data for analysis.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D08', 'Code data or other information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D09', 'Download data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D10', 'Enter codes or other information into computers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D11', 'Convert data among multiple digital or analog formats.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.1', '4.A.3.b.1.I06', '4.A.3.b.1.I06.D12', 'Format digital documents, data, or images.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D01', 'Maintain facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D02', 'Perform basic equipment maintenance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D03', 'Maintain plumbing structures or fixtures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D04', 'Repair structural components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D05', 'Repair pipes to stop leaking.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I01', '4.A.3.b.4.I01.D06', 'Service heating, ventilation or air-conditioning (HVAC) systems or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D01', 'Maintain mechanical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D02', 'Maintain production or processing equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D03', 'Maintain equipment or systems to ensure proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D04', 'Maintain office equipment in proper operating condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D05', 'Maintain sustainable energy production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D06', 'Maintain forestry, hunting, or agricultural equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D07', 'Lubricate equipment to allow proper functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D08', 'Maintain drilling equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D09', 'Clear equipment jams.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D10', 'Maintain extraction or excavation equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D11', 'Maintain green energy production plant equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D12', 'Apply lubricants or coolants to workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D13', 'Perform manual service or maintenance tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D14', 'Maintain construction tools or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D15', 'Maintain fire fighting tools or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D16', 'Maintain work equipment or machinery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D17', 'Lubricate production equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D18', 'Maintain electromechanical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I02', '4.A.3.b.4.I02.D19', 'Sharpen cutting or grinding tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I03', '4.A.3.b.4.I03.D01', 'Repair electrical circuits or wiring.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I03', '4.A.3.b.4.I03.D02', 'Repair electrical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I03', '4.A.3.b.4.I03.D03', 'Repair electronic equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I03', '4.A.3.b.4.I03.D04', 'Repair electrical components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D01', 'Maintain computer hardware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D02', 'Maintain computer networks to enhance performance and user access.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D03', 'Maintain recording or broadcasting equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D04', 'Maintain electronic equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D05', 'Maintain laboratory or technical equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D06', 'Maintain computer equipment or software.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I04', '4.A.3.b.4.I04.D07', 'Maintain test equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I05', '4.A.3.b.4.I05.D01', 'Repair furniture or upholstery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I05', '4.A.3.b.4.I05.D02', 'Repair templates, patterns, or molds.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I05', '4.A.3.b.4.I05.D03', 'Repair precision devices or workpieces.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I05', '4.A.3.b.4.I05.D04', 'Repair parts or assemblies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I06', '4.A.3.b.4.I06.D01', 'Replace worn equipment components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I06', '4.A.3.b.4.I06.D02', 'Repair green energy equipment or systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I06', '4.A.3.b.4.I06.D03', 'Replace worn, damaged, or defective mechanical parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I06', '4.A.3.b.4.I06.D04', 'Repair production equipment or tools.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I06', '4.A.3.b.4.I06.D05', 'Repair worn, damaged, or defective mechanical parts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I07', '4.A.3.b.4.I07.D01', 'Repair defective engines or engine components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I07', '4.A.3.b.4.I07.D02', 'Replace vehicle glass.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I07', '4.A.3.b.4.I07.D03', 'Repair tires.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I07', '4.A.3.b.4.I07.D04', 'Repair non-engine automotive or vehicle components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I07', '4.A.3.b.4.I07.D05', 'Rebuild parts or components.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D01', 'Service green vehicles to make repairs or maintain good working order.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D02', 'Maintain vehicles in good working condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D03', 'Maintain watercraft engines or machinery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D04', 'Maintain locomotives or other rail equipment in good working condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D05', 'Service vehicles to maintain functionality.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I08', '4.A.3.b.4.I08.D06', 'Maintain material moving equipment in good working condition.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I09', '4.A.3.b.4.I09.D01', 'Maintain medical equipment or instruments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I09', '4.A.3.b.4.I09.D02', 'Maintain medical laboratory equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I09', '4.A.3.b.4.I09.D03', 'Repair medical or dental assistive devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.4', '4.A.3.b.4.I09', '4.A.3.b.4.I09.D04', 'Repair medical facility equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I01', '4.A.3.b.6.I01.D01', 'Prepare financial documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I01', '4.A.3.b.6.I01.D02', 'Prepare financial documents, reports, or budgets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D01', 'Prepare written decisions for legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D02', 'Prepare documentation of legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D03', 'Record information about legal matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D04', 'Record information about suspects or criminals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D05', 'Record information from legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D06', 'Prepare investigation or incident reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D07', 'Document information related to legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I02', '4.A.3.b.6.I02.D08', 'Record information about suspicious objects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D01', 'Present research results to others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D02', 'Prepare research or technical reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D03', 'Prepare research reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D04', 'Prepare scientific or technical reports or presentations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D05', 'Prepare analytical reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D06', 'Write reports or evaluations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D07', 'Prepare research or technical reports on environmental issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D08', 'Prepare technical or operational reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D09', 'Prepare technical reports for internal use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I03', '4.A.3.b.6.I03.D10', 'Present medical research reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I04', '4.A.3.b.6.I04.D01', 'Record information about environmental conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I05', '4.A.3.b.6.I05.D01', 'Record images needed to address work issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I05', '4.A.3.b.6.I05.D02', 'Record crime or accident scene evidence with video or still cameras.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I05', '4.A.3.b.6.I05.D03', 'Document events or evidence, using photographic or audiovisual equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I06', '4.A.3.b.6.I06.D01', 'Prepare official health documents or records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I06', '4.A.3.b.6.I06.D02', 'Document client health or progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I06', '4.A.3.b.6.I06.D03', 'Prepare medical reports or documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I06', '4.A.3.b.6.I06.D04', 'Prepare reports summarizing patient diagnostic or care activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I07', '4.A.3.b.6.I07.D01', 'Develop proposals for current or prospective customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I07', '4.A.3.b.6.I07.D02', 'Write grant proposals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I07', '4.A.3.b.6.I07.D03', 'Prepare proposal documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I07', '4.A.3.b.6.I07.D04', 'Prepare proposals or grant applications to obtain project funding.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I07', '4.A.3.b.6.I07.D05', 'Prepare proposal documents or grant applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D01', 'Record details of deliveries or shipments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D02', 'Document operational procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D03', 'Record operational or production data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D04', 'Maintain operational records for green energy processes or other environmentally-sustainable activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D05', 'Maintain operational records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D06', 'Maintain client information or service records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D07', 'Maintain inventory records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D08', 'Record agricultural or forestry inventory data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D09', 'Maintain records, documents, or other files.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D10', 'Maintain personnel records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D11', 'Document operational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D12', 'Maintain student records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D13', 'Record information about parts, materials or repair procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D14', 'Maintain data in information systems or databases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D15', 'Maintain records of customer accounts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D16', 'Transcribe spoken or written information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D17', 'Document work hours or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D18', 'Record research or operational data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D19', 'Record operational details of travel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D20', 'Record shipping information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D21', 'Maintain operational records or records systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D22', 'Record service or repair activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D23', 'Maintain social services program records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D24', 'Maintain repair or maintenance records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D25', 'Maintain call records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D26', 'Record personnel information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D27', 'Record operational or environmental data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D28', 'Maintain logs of production activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D29', 'Record information from meetings or other formal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D30', 'Document organizational or operational procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I08', '4.A.3.b.6.I08.D31', 'Record production information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D01', 'Prepare procedural documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D02', 'Document technical design details.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D03', 'Document network-related activities or tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D04', 'Document technical specifications or requirements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D05', 'Document design or development procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D06', 'Document test results.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I09', '4.A.3.b.6.I09.D07', 'Document design or operational test results.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I10', '4.A.3.b.6.I10.D01', 'Record sales or transactions data.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I10', '4.A.3.b.6.I10.D02', 'Maintain records of sales or other business transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I10', '4.A.3.b.6.I10.D03', 'Maintain financial or account records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I11', '4.A.3.b.6.I11.D01', 'Maintain client records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I11', '4.A.3.b.6.I11.D02', 'Maintain medical facility records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I11', '4.A.3.b.6.I11.D03', 'Record vital statistics or other health information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I11', '4.A.3.b.6.I11.D04', 'Record patient medical histories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I11', '4.A.3.b.6.I11.D05', 'Maintain medical records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D01', 'Document lesson plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D02', 'Organize informational materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D03', 'Create technology-based learning materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D04', 'Modify teaching methods or materials to accommodate student needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D05', 'Write informational material.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D06', 'Prepare healthcare training materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D07', 'Prepare informational or reference materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D08', 'Prepare instruction manuals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D09', 'Develop instructional materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I12', '4.A.3.b.6.I12.D10', 'Develop training materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D01', 'Prepare sales or other contracts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D02', 'Prepare contracts or other transaction documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D03', 'Prepare documentation for permits or licenses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D04', 'Prepare forms or applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D05', 'Prepare documentation for contracts, transactions, or regulatory compliance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I13', '4.A.3.b.6.I13.D06', 'Prepare contracts, disclosures, or applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D01', 'Prepare legal or investigatory documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D02', 'Prepare reports related to compliance matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D03', 'Maintain the order of legal documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D04', 'Maintain regulatory or compliance documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D05', 'Prepare regulatory or compliance documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D06', 'Prepare information or documentation related to legal or regulatory matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D07', 'Complete documentation required by programs or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D08', 'Document legal or regulatory information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I14', '4.A.3.b.6.I14.D09', 'Prepare legal documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D01', 'Prepare operational reports or records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D02', 'Prepare reports detailing student activities or performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D03', 'Prepare accident or incident reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D04', 'Prepare operational reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D05', 'Write operational reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I15', '4.A.3.b.6.I15.D06', 'Prepare operational progress or status reports.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I16', '4.A.3.b.6.I16.D01', 'Write articles, books or other original materials in area of expertise.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I16', '4.A.3.b.6.I16.D02', 'Write material for artistic or entertainment purposes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.3.b.6', '4.A.3.b.6.I16', '4.A.3.b.6.I16.D03', 'Write advertising or promotional material.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D01', 'Present work to clients for approval.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D02', 'Explain use of products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D03', 'Discuss goods or services information with customers or patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D04', 'Explain engineering drawings, specifications, or other technical information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D05', 'Explain technical product or service information to customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I01', '4.A.4.a.1.I01.D06', 'Provide information about landscaping services or costs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D01', 'Inform others about laws or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D02', 'Inform the public about policies, services or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D03', 'Communicate organizational policies and procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D04', 'Explain regulations, policies, or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D05', 'Communicate organizational information to customers or other stakeholders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I02', '4.A.4.a.1.I02.D06', 'Communicate with clients about products, procedures, and policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I03', '4.A.4.a.1.I03.D01', 'Translate information for others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I03', '4.A.4.a.1.I03.D02', 'Interpret cultural or religious information for others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I04', '4.A.4.a.1.I04.D01', 'Educate clients on financial planning topics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I04', '4.A.4.a.1.I04.D02', 'Interpret financial information for others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I04', '4.A.4.a.1.I04.D03', 'Explain financial information to customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I05', '4.A.4.a.1.I05.D01', 'Communicate detailed medical information to patients or family members.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I05', '4.A.4.a.1.I05.D02', 'Confer with family members to discuss client treatment plans or progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I05', '4.A.4.a.1.I05.D03', 'Confer with clients to discuss treatment plans or progress.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I05', '4.A.4.a.1.I05.D04', 'Explain technical medical information to patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.1', '4.A.4.a.1.I05', '4.A.4.a.1.I05.D05', 'Explain medical procedures or test results to patients or family members.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I01', '4.A.4.a.2.I01.D01', 'Communicate with the public on environmental issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I01', '4.A.4.a.2.I01.D02', 'Communicate green energy production information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I01', '4.A.4.a.2.I01.D03', 'Communicate results of environmental research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I02', '4.A.4.a.2.I02.D01', 'Collaborate on research activities with scientists or technical specialists.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I02', '4.A.4.a.2.I02.D02', 'Assist other educational professionals with projects or research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I02', '4.A.4.a.2.I02.D03', 'Assist engineers or scientists with research.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D01', 'Communicate with other workers to coordinate activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D02', 'Provide information to coworkers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D03', 'Confer with coworkers to coordinate maintenance or cleaning activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D04', 'Meet with coworkers to communicate work orders or plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D05', 'Discuss problems or issues with supervisors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D06', 'Communicate with others to coordinate vehicle movement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D07', 'Discuss performance, complaints, or violations with supervisors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D08', 'Communicate with other construction or extraction personnel to discuss project details.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D09', 'Liaise between departments or other groups to improve function or communication.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D10', 'Report information to managers or other personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D11', 'Relay information between personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D12', 'Communicate with coworkers to coordinate installations or repairs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D13', 'Confer with managers to make operational decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D14', 'Confer with organizational members to accomplish work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D15', 'Confer with coworkers to coordinate work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D16', 'Communicate with others to coordinate material handling or movement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D17', 'Communicate dining or order details to kitchen personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D18', 'Confer with others to conduct or arrange operational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D19', 'Receive information or instructions for performing work assignments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D20', 'Exchange information with colleagues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I03', '4.A.4.a.2.I03.D21', 'Communicate safety or hazard information to others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D01', 'Confer with others to resolve production problems or equipment malfunctions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D02', 'Confer with other personnel to resolve design or operational problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D03', 'Collaborate with others to resolve information technology issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D04', 'Communicate with management or other staff to resolve problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D05', 'Collaborate with technical specialists to resolve design or development problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I04', '4.A.4.a.2.I04.D06', 'Confer with coworkers to resolve equipment problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D01', 'Inform medical professionals regarding patient conditions and care.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D02', 'Confer with other professionals to plan patient care.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D03', 'Collaborate with other professionals to assess client needs or plan treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D04', 'Communicate test or assessment results to medical professionals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D05', 'Collaborate with healthcare professionals to plan or provide treatment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I05', '4.A.4.a.2.I05.D06', 'Communicate patient status to other health practitioners.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I06', '4.A.4.a.2.I06.D01', 'Collaborate with others in marketing activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I06', '4.A.4.a.2.I06.D02', 'Collaborate with others to develop or implement marketing strategies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I06', '4.A.4.a.2.I06.D03', 'Confer with personnel to coordinate business operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I06', '4.A.4.a.2.I06.D04', 'Share sales-related or market information with colleagues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I06', '4.A.4.a.2.I06.D05', 'Discuss business strategies, practices, or policies with managers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I07', '4.A.4.a.2.I07.D01', 'Collaborate with other professionals to develop education or assistance programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I07', '4.A.4.a.2.I07.D02', 'Collaborate with other agencies and institutions to coordinate educational matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I07', '4.A.4.a.2.I07.D03', 'Collaborate with other teaching professionals to develop educational programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D01', 'Communicate situation details to appropriate personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D02', 'Notify others of equipment repair or maintenance needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D03', 'Request emergency personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D04', 'Notify others of equipment problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D05', 'Report vehicle or equipment malfunctions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D06', 'Relay information about incidents or emergencies to personnel using phones or two-way radios.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D07', 'Notify others of emergencies, problems, or hazards.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D08', 'Report maintenance or equipment problems to appropriate personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I08', '4.A.4.a.2.I08.D09', 'Warn individuals about rule violations or safety concerns.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D01', 'Collaborate with others to determine production details.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D02', 'Discuss production content and progress with others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D03', 'Confer with technical personnel to prepare designs or operational plans.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D04', 'Collaborate with others to develop or refine designs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D05', 'Collaborate with others to determine technical details of productions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D06', 'Discuss design or technical features of products or services with technical personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D07', 'Collaborate with others to determine design specifications or details.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D08', 'Consult with others regarding safe or healthy equipment or facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I09', '4.A.4.a.2.I09.D09', 'Communicate project information to others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I10', '4.A.4.a.2.I10.D01', 'Signal others to coordinate vehicle movement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I10', '4.A.4.a.2.I10.D02', 'Signal others to coordinate work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I10', '4.A.4.a.2.I10.D03', 'Signal equipment operators to indicate proper equipment positioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D01', 'Communicate with government agencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D02', 'Communicate technical information to suppliers, contractors, or regulatory agencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D03', 'Collaborate with outside groups to develop programs or projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D04', 'Coordinate with external parties to exchange information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D05', 'Collaborate with law enforcement or security agencies to share information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D06', 'Coordinate operational activities with external stakeholders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D07', 'Coordinate activities with suppliers, contractors, clients, or other departments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D08', 'Confer with others about financial matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D09', 'Represent the organization in external relations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I11', '4.A.4.a.2.I11.D10', 'Collaborate with law enforcement or security agencies to respond to incidents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I12', '4.A.4.a.2.I12.D01', 'Meet with individuals involved in legal processes to provide information and clarify issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I12', '4.A.4.a.2.I12.D02', 'Confer with court staff to clarify information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D01', 'Discuss service options or needs with clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D02', 'Confer with clients to exchange information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D03', 'Confer with clients to determine needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D04', 'Confer with customers or users to assess problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D05', 'Confer with customers or designers to determine order specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.2', '4.A.4.a.2.I13', '4.A.4.a.2.I13.D06', 'Discuss designs or plans with clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I01', '4.A.4.a.3.I01.D01', 'Testify at legal or legislative proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I01', '4.A.4.a.3.I01.D02', 'Represent the interests of clients in legal proceedings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D01', 'Communicate health and wellness information to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D02', 'Present sustainable products or services information to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D03', 'Present information to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D04', 'Provide educational information to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D05', 'Provide technical information or assistance to public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D06', 'Explain project details to the general public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D07', 'Report news to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D08', 'Provide information to the general public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D09', 'Present social services program information to the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I02', '4.A.4.a.3.I02.D10', 'Inform viewers, listeners, or audiences.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D01', 'Present food or beverage information or menus to customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D02', 'Present business-related information to audiences.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D03', 'Provide attraction or event information to patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D04', 'Discuss account status or activity with customers or patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D05', 'Provide customer service to clients or users.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D06', 'Inform individuals or organizations of status or findings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D07', 'Provide notifications to customers or patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D08', 'Provide customers with general information or assistance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D09', 'Provide basic information to guests, visitors, or clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D10', 'Provide patrons with directions to locales or attractions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D11', 'Answer telephones to direct calls or provide information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.3', '4.A.4.a.3.I03', '4.A.4.a.3.I03.D12', 'Provide transportation information to passengers or customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.4', '4.A.4.a.4.I01', '4.A.4.a.4.I01.D01', 'Develop collaborative relationships between departments or with external organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.4', '4.A.4.a.4.I01', '4.A.4.a.4.I01.D02', 'Develop business relationships.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.4', '4.A.4.a.4.I01', '4.A.4.a.4.I01.D03', 'Develop working relationships with others to facilitate program activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.4', '4.A.4.a.4.I01', '4.A.4.a.4.I01.D04', 'Establish interpersonal business relationships to facilitate work activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.4', '4.A.4.a.4.I01', '4.A.4.a.4.I01.D05', 'Develop professional relationships or networks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D01', 'Refer customers to appropriate personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D02', 'Refer patients to other healthcare practitioners or health resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D03', 'Help clients get needed services or resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D04', 'Arrange physical or mental health services for clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D05', 'Refer individuals to educational or work programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I01', '4.A.4.a.5.I01.D06', 'Refer clients to community or social service programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I02', '4.A.4.a.5.I02.D01', 'Treat patients using psychological therapies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I02', '4.A.4.a.5.I02.D02', 'Implement therapeutic programs to improve patient functioning.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I02', '4.A.4.a.5.I02.D03', 'Administer therapy treatments to patients using hands or physical treatment aids.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I02', '4.A.4.a.5.I02.D04', 'Administer therapeutic massages.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I02', '4.A.4.a.5.I02.D05', 'Treat patients using physical therapy techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D01', 'Give medications or immunizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D02', 'Administer basic health care or medical treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D03', 'Administer anesthetics or sedatives to control pain.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D04', 'Care for women during pregnancy and childbirth.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D05', 'Provide basic health care services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D06', 'Administer non-intravenous medications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D07', 'Immunize patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D08', 'Administer intravenous medications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D09', 'Administer blood or other fluids intravenously.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D10', 'Administer medical substances for imaging or other procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I03', '4.A.4.a.5.I03.D11', 'Apply bandages, dressings, or splints.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I04', '4.A.4.a.5.I04.D01', 'Care for plants or animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I04', '4.A.4.a.5.I04.D02', 'Care for animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I04', '4.A.4.a.5.I04.D03', 'Perform animal breeding procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I04', '4.A.4.a.5.I04.D04', 'Provide care for animals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I05', '4.A.4.a.5.I05.D01', 'Rescue people from hazardous situations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I05', '4.A.4.a.5.I05.D02', 'Respond to emergencies to provide assistance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I05', '4.A.4.a.5.I05.D03', 'Respond to transportation emergencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I05', '4.A.4.a.5.I05.D04', 'Assist others during emergencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I06', '4.A.4.a.5.I06.D01', 'Fit eyeglasses, contact lenses, or other vision aids.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I06', '4.A.4.a.5.I06.D02', 'Fit patients for assistive devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I07', '4.A.4.a.5.I07.D01', 'Provide first aid or rescue assistance in emergencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I07', '4.A.4.a.5.I07.D02', 'Administer first aid.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I07', '4.A.4.a.5.I07.D03', 'Treat medical emergencies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I07', '4.A.4.a.5.I07.D04', 'Implement advanced life support techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I08', '4.A.4.a.5.I08.D01', 'Assist individuals with paperwork.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D01', 'Feed patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D02', 'Assist patients with hygiene or daily living activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D03', 'Assist clients in handling details of daily life.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D04', 'Develop daily schedules for children or families.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D05', 'Assist students with special educational needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D06', 'Assist disabled or incapacitated individuals.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D07', 'Assist individuals with special needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D08', 'Provide for basic needs of children.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I09', '4.A.4.a.5.I09.D09', 'Assist patients with daily activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D01', 'Assist motorists or pedestrians.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D02', 'Greet customers, patrons, or visitors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D03', 'Assist customers to ensure comfort or safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D04', 'Assist patrons with entering or exiting vehicles or other forms of transportation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D05', 'Make travel, accommodations, or entertainment arrangements for others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D06', 'Assist passengers during vehicle boarding.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D07', 'Help patrons use library or archival resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D08', 'Assist customers with seating arrangements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I10', '4.A.4.a.5.I10.D09', 'Arrange services or reservations for patrons.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D01', 'Assist practitioners to perform medical procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D02', 'Hold patients to ensure proper positioning or safety.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D03', 'Adjust positions of patients on beds or tables.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D04', 'Position patients for treatment or examination.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D05', 'Assist healthcare practitioners during examinations or treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D06', 'Assist healthcare practitioners during surgery.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D07', 'Prepare patients physically for medical procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I11', '4.A.4.a.5.I11.D08', 'Maintain sterile operative fields.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D01', 'Care for patients with mental illnesses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D02', 'Treat acute illnesses, infections, or injuries.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D03', 'Operate on patients to treat conditions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D04', 'Treat dental problems or diseases.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D05', 'Treat animal injuries or illnesses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D06', 'Administer cancer treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D07', 'Treat chronic diseases or disorders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.5', '4.A.4.a.5.I12', '4.A.4.a.5.I12.D08', 'Treat patients using alternative medical procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I01', '4.A.4.a.6.I01.D01', 'Advocate for individual or community needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D01', 'Merchandise healthcare products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D02', 'Sell agricultural products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D03', 'Customize financial products or services to meet customer needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D04', 'Contract real estate to clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D05', 'Sell products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I02', '4.A.4.a.6.I02.D06', 'Customize energy products or services to meet customer needs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D01', 'Perform marketing activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D02', 'Demonstrate products to consumers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D03', 'Promote environmental sustainability or conservation initiatives.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D04', 'Market products, services, or events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D05', 'Contact current or potential customers to promote products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D06', 'Promote educational institutions or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D07', 'Deliver promotional presentations to current or prospective customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D08', 'Promote agricultural or hunting activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D09', 'Distribute promotional literature or samples to customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D10', 'Promote products, activities, or organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D11', 'Model cosmetics, clothing, or accessories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.6', '4.A.4.a.6.I03', '4.A.4.a.6.I03.D12', 'Promote products, services, or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I01', '4.A.4.a.7.I01.D01', 'Resolve interpersonal conflicts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I01', '4.A.4.a.7.I01.D02', 'Arbitrate disputes between parties to resolve legal conflicts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I01', '4.A.4.a.7.I01.D03', 'Mediate disputes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D01', 'Negotiate sales or lease agreements for products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D02', 'Arrange collective bargaining agreements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D03', 'Negotiate labor disputes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D04', 'Negotiate contracts for transportation, distribution, or logistics services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D05', 'Negotiate purchases or contracts.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D06', 'Negotiate financial arrangements.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D07', 'Negotiate prices or other sales terms.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D08', 'Negotiate contracts for environmental remediation, green energy, or renewable resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D09', 'Negotiate agreements to resolve disputes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D10', 'Negotiate contracts with clients or service providers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D11', 'Negotiate project specifications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I02', '4.A.4.a.7.I02.D12', 'Negotiate for services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I03', '4.A.4.a.7.I03.D01', 'Resolve employee or contractor problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I03', '4.A.4.a.7.I03.D02', 'Resolve operational performance problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I03', '4.A.4.a.7.I03.D03', 'Resolve personnel problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.7', '4.A.4.a.7.I03', '4.A.4.a.7.I03.D04', 'Resolve issues affecting transportation operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D01', 'Audition for roles.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D02', 'Perform for recordings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D03', 'Perform music for the public.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D04', 'Collaborate with others to prepare or perform artistic productions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D05', 'Entertain public with comedic or dramatic performances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I01', '4.A.4.a.8.I01.D06', 'Perform dances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I02', '4.A.4.a.8.I02.D01', 'Operate gaming equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I02', '4.A.4.a.8.I02.D02', 'Conduct amusement or gaming activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D01', 'Respond to customer problems or complaints.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D02', 'Respond to customer inquiries.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D03', 'Answer customer questions about goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D04', 'Communicate with customers to resolve complaints or ensure satisfaction.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D05', 'Resolve customer complaints or problems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.a.8', '4.A.4.a.8.I03', '4.A.4.a.8.I03.D06', 'Correspond with customers to answer questions or resolve complaints.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I01', '4.A.4.b.3.I01.D01', 'Teach basic living or other adaptive skills to patients or caregivers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I01', '4.A.4.b.3.I01.D02', 'Teach life skills or strategies to clients or their families.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I01', '4.A.4.b.3.I01.D03', 'Teach daily living skills or behaviors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I01', '4.A.4.b.3.I01.D04', 'Teach life skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D01', 'Teach vocational courses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D02', 'Teach classes in area of specialization.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D03', 'Teach social science courses at the college level.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D04', 'Lead classes or community events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D05', 'Guide class discussions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D06', 'Apply multiple teaching methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D07', 'Teach online courses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D08', 'Instruct college students in social sciences or humanities disciplines.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D09', 'Instruct college students in physical or life sciences.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D10', 'Tutor students who need extra assistance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D11', 'Teach humanities courses at the college level.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D12', 'Teach physical science or mathematics courses at the college level.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I02', '4.A.4.b.3.I02.D13', 'Read to students.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I03', '4.A.4.b.3.I03.D01', 'Educate the public about fire safety or prevention.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I03', '4.A.4.b.3.I03.D02', 'Teach safety standards or environmental compliance methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I03', '4.A.4.b.3.I03.D03', 'Provide safety training.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D01', 'Train personnel to enhance job skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D02', 'Train personnel on proper operational procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D03', 'Train others in operational procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D04', 'Train personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D05', 'Train sales personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D06', 'Instruct staff in work policies or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D07', 'Train others on performance techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D08', 'Train staff members.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D09', 'Train workers in farming, forestry, or hunting techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D10', 'Train food preparation or food service personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D11', 'Train employees on environmental awareness, conservation, or safety topics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D12', 'Train personnel in organizational or compliance procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D13', 'Train construction or extraction personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D14', 'Train employees in proper work procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D15', 'Train personnel in technical or scientific procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D16', 'Conduct employee training programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D17', 'Train personnel on managerial topics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D18', 'Train others on work processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D19', 'Train transportation or material moving personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D20', 'Train service staff.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I04', '4.A.4.b.3.I04.D21', 'Train staff members in social services skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D01', 'Instruct workers to use equipment or perform technical procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D02', 'Instruct patients in the use of assistive equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D03', 'Teach others to use computer equipment or hardware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D04', 'Train others in computer interface or software use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D05', 'Teach others to use technology or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D06', 'Demonstrate activity techniques or equipment use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I05', '4.A.4.b.3.I05.D07', 'Train customers in the use of products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D01', 'Teach exercise or fitness techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D02', 'Engage patients in exercises or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D03', 'Teach physical education.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D04', 'Teach medical procedures or medical equipment use to patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D05', 'Train patients, family members, or caregivers in techniques for managing disabilities or illnesses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D06', 'Conduct health or safety training programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D07', 'Teach health or hygiene practices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D08', 'Train medical providers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D09', 'Teach health management classes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D10', 'Teach medical procedures to healthcare personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.3', '4.A.4.b.3.I06', '4.A.4.b.3.I06.D11', 'Train caregivers or other non-medical personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D01', 'Supervise maintenance workers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D02', 'Supervise engineering or other technical personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D03', 'Supervise trainees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D04', 'Supervise service workers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D05', 'Supervise production or support personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D06', 'Direct activities of subordinates.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D07', 'Supervise information technology personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D08', 'Supervise clerical or administrative personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D09', 'Supervise activities of other legal personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D10', 'Supervise scientific or technical personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D11', 'Supervise medical support personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D12', 'Supervise workers providing client or patient services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D13', 'Supervise employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D14', 'Supervise patient care personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D15', 'Supervise technical medical personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D16', 'Supervise sales or support personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D17', 'Supervise laboratory work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D18', 'Supervise student research or internship work.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I01', '4.A.4.b.4.I01.D19', 'Supervise workers performing environmentally sustainable activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I02', '4.A.4.b.4.I02.D01', 'Serve on institutional or departmental committees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I03', '4.A.4.b.4.I03.D01', 'Manage content of broadcasts or presentations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I03', '4.A.4.b.4.I03.D02', 'Direct productions or performances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I03', '4.A.4.b.4.I03.D03', 'Coordinate musical rehearsals or performances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I03', '4.A.4.b.4.I03.D04', 'Coordinate athletic or sporting events or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I03', '4.A.4.b.4.I03.D05', 'Coordinate artistic activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I04', '4.A.4.b.4.I04.D01', 'Coordinate forestry or agricultural activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I04', '4.A.4.b.4.I04.D02', 'Manage agricultural or forestry operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I04', '4.A.4.b.4.I04.D03', 'Direct activities of agricultural, forestry, or fishery employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I05', '4.A.4.b.4.I05.D01', 'Supervise inmate activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I05', '4.A.4.b.4.I05.D02', 'Count prison inmates or personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D01', 'Direct surveying activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D02', 'Direct technical activities or operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D03', 'Coordinate design activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D04', 'Coordinate software or hardware installation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D05', 'Direct scientific activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D06', 'Direct natural resources management or conservation programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D07', 'Manage information technology projects or system activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D08', 'Manage scientific or technical project resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D09', 'Direct medical science or healthcare programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D10', 'Direct design or development activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I06', '4.A.4.b.4.I06.D11', 'Coordinate cross-disciplinary research programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I07', '4.A.4.b.4.I07.D01', 'Coordinate training activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I07', '4.A.4.b.4.I07.D02', 'Coordinate personnel recruitment activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I07', '4.A.4.b.4.I07.D03', 'Direct employee training programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I07', '4.A.4.b.4.I07.D04', 'Manage human resources activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I08', '4.A.4.b.4.I08.D01', 'Direct quality control activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I08', '4.A.4.b.4.I08.D02', 'Coordinate flight control or management activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I08', '4.A.4.b.4.I08.D03', 'Manage control system activities in organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D01', 'Manage budgets for personal services operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D02', 'Direct financial operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D03', 'Direct fundraising or financing activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D04', 'Prepare operational budgets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D05', 'Manage organizational or project budgets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D06', 'Manage financial activities of the organization.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D07', 'Manage budgets for appropriate resource allocation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D08', 'Manage organizational or program finances.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D09', 'Prepare operational budgets for green energy or other green operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I09', '4.A.4.b.4.I09.D10', 'Prepare project budgets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D01', 'Direct natural resources extraction projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D02', 'Direct construction or extraction personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D03', 'Direct construction activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D04', 'Direct installation activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D05', 'Coordinate construction project activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D06', 'Coordinate construction or installation activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I10', '4.A.4.b.4.I10.D07', 'Manage construction activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D01', 'Organize recreational activities or events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D02', 'Coordinate student extracurricular activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D03', 'Coordinate special events or programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D04', 'Host events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D05', 'Organize special events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I11', '4.A.4.b.4.I11.D06', 'Manage outreach activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D01', 'Direct operational or production activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D02', 'Direct environmental development activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D03', 'Direct sales, marketing, or customer service activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D04', 'Direct equipment maintenance or repair activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D05', 'Coordinate sales campaigns.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D06', 'Direct funeral or mortuary activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D07', 'Manage environmental sustainability projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D08', 'Oversee business processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D09', 'Coordinate logistics or other business operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D10', 'Direct green energy production operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D11', 'Manage guest services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D12', 'Manage operations, research, or logistics projects.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D13', 'Coordinate activities of food service staff.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D14', 'Direct operations of correctional facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D15', 'Coordinate timing of food production activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D16', 'Coordinate shipping activities with external parties.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D17', 'Direct administrative or support services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D18', 'Manage operations of artistic or entertainment departments or organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D19', 'Coordinate activities of production personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D20', 'Coordinate logistics for productions or events.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D21', 'Direct maintenance or repair activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D22', 'Manage food service operations or parts of operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D23', 'Direct healthcare delivery programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D24', 'Direct industrial production activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D25', 'Direct maintenance and repair activities in green energy production facilities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D26', 'Direct energy production or management activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D27', 'Direct facility maintenance or repair activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D28', 'Manage clerical or administrative activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D29', 'Arrange delivery of goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D30', 'Direct passenger or freight transport activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D31', 'Direct material handling or moving activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D32', 'Coordinate project activities with other personnel or departments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D33', 'Direct department activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D34', 'Coordinate reporting or editing activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D35', 'Manage preparation of special meals or diets.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D36', 'Coordinate resource procurement activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D37', 'Coordinate operational activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D38', 'Manage healthcare operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I12', '4.A.4.b.4.I12.D39', 'Direct organizational operations, projects, or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D01', 'Plan employee work schedules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D02', 'Prepare staff schedules or work assignments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D03', 'Prepare activity or work schedules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D04', 'Prepare employee work schedules.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D05', 'Assign class work to students.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I13', '4.A.4.b.4.I13.D06', 'Assign duties or work schedules to employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I14', '4.A.4.b.4.I14.D01', 'Coordinate regulatory documentation activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I14', '4.A.4.b.4.I14.D02', 'Coordinate safety or regulatory compliance activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I14', '4.A.4.b.4.I14.D03', 'Manage documentation to ensure organization or accuracy.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I15', '4.A.4.b.4.I15.D01', 'Direct emergency management activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I15', '4.A.4.b.4.I15.D02', 'Manage organizational security activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I15', '4.A.4.b.4.I15.D03', 'Direct fire fighting or prevention activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I15', '4.A.4.b.4.I15.D04', 'Coordinate enforcement of laws or regulations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I15', '4.A.4.b.4.I15.D05', 'Direct security operations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I16', '4.A.4.b.4.I16.D01', 'Direct criminal investigations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I16', '4.A.4.b.4.I16.D02', 'Direct law enforcement activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I16', '4.A.4.b.4.I16.D03', 'Coordinate legal schedules or activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.4', '4.A.4.b.4.I16', '4.A.4.b.4.I16.D04', 'Direct courtroom activities or procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I01', '4.A.4.b.5.I01.D01', 'Coach others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D01', 'Encourage patients during therapeutic activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D02', 'Visit individuals in their homes to provide support or information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D03', 'Encourage students.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D04', 'Interact with patients to build rapport or provide emotional support.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D05', 'Support the professional development of others.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.5', '4.A.4.b.5.I02', '4.A.4.b.5.I02.D06', 'Encourage patients or clients to develop life skills.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I01', '4.A.4.b.6.I01.D01', 'Provide health and wellness advice to patients, program participants, or caregivers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I01', '4.A.4.b.6.I01.D02', 'Advise patients on preventive care techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I01', '4.A.4.b.6.I01.D03', 'Provide medical or cosmetic advice for clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I01', '4.A.4.b.6.I01.D04', 'Advise patients on effects of health conditions or treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I01', '4.A.4.b.6.I01.D05', 'Advise patients on healthcare system processes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I02', '4.A.4.b.6.I02.D01', 'Recommend types of assistive devices.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I02', '4.A.4.b.6.I02.D02', 'Advise customers on technical or procedural issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I02', '4.A.4.b.6.I02.D03', 'Advise customers on the use of products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I02', '4.A.4.b.6.I02.D04', 'Recommend products or services to customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I03', '4.A.4.b.6.I03.D01', 'Advise others about environmental management or conservation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I03', '4.A.4.b.6.I03.D02', 'Advise others regarding green practices or environmental concerns.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I03', '4.A.4.b.6.I03.D03', 'Advise others on green energy or related technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I03', '4.A.4.b.6.I03.D04', 'Advise others about land management or conservation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D01', 'Provide technical guidance to other personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D02', 'Provide technical support for software maintenance or use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D03', 'Provide recommendations to others about computer hardware.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D04', 'Advise others on the development or use of new technologies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D05', 'Provide technical support for computer network issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I04', '4.A.4.b.6.I04.D06', 'Recommend changes to improve computer or information systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D01', 'Advise others on farming or forestry operations, regulations, or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D02', 'Advise others on logistics topics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D03', 'Recommend personnel decisions or human resources activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D04', 'Recommend packing or shipping methods.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D05', 'Advise others on analytical techniques.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D06', 'Advise others on issues related to repairs, installation, or equipment design.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D07', 'Recommend organizational process or policy changes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D08', 'Advise others on human resources topics.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D09', 'Recommend technical design or process changes to improve efficiency, quality, or performance.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D10', 'Advise others on business or operational matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D11', 'Advise others on ways to improve processes or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I05', '4.A.4.b.6.I05.D12', 'Recommend changes or corrective procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I06', '4.A.4.b.6.I06.D01', 'Advise medical personnel regarding healthcare issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I06', '4.A.4.b.6.I06.D02', 'Advise communities or institutions regarding health or safety issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I06', '4.A.4.b.6.I06.D03', 'Advise clients or community groups on health issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I06', '4.A.4.b.6.I06.D04', 'Advise athletes, coaches, or trainers on exercise regimens, nutrition, or equipment use.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I06', '4.A.4.b.6.I06.D05', 'Advise others on healthcare matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D01', 'Advise others on social or educational issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D02', 'Advise students on academic or career matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D03', 'Discuss child development and behavior with parents or guardians.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D04', 'Counsel clients regarding educational or vocational issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D05', 'Advise educators on curricula, instructional methods, or policies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D06', 'Advise others on career or personal development.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D07', 'Advise others on educational matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I07', '4.A.4.b.6.I07.D08', 'Discuss student progress with parents or guardians.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I08', '4.A.4.b.6.I08.D01', 'Provide legal advice to clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I08', '4.A.4.b.6.I08.D02', 'Advise others on matters of public policy.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I08', '4.A.4.b.6.I08.D03', 'Recommend legal actions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I08', '4.A.4.b.6.I08.D04', 'Advise others on legal or regulatory compliance matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I09', '4.A.4.b.6.I09.D01', 'Advise others on management of emergencies or hazardous situations or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I09', '4.A.4.b.6.I09.D02', 'Recommend improvements to increase safety or reduce risks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I09', '4.A.4.b.6.I09.D03', 'Advise others on health and safety issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D01', 'Intervene in crisis situations to assist clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D02', 'Counsel clients or patients with substance abuse issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D03', 'Provide counsel, comfort, or encouragement to individuals or families.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D04', 'Counsel clients regarding interpersonal issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D05', 'Counsel family members of clients or patients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D06', 'Counsel clients on mental health or personal achievement.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I10', '4.A.4.b.6.I10.D07', 'Counsel clients or patients regarding personal issues.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I11', '4.A.4.b.6.I11.D01', 'Advise real estate clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I11', '4.A.4.b.6.I11.D02', 'Recommend investments to clients.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.b.6', '4.A.4.b.6.I11', '4.A.4.b.6.I11.D03', 'Advise others on financial matters.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D01', 'Classify materials according to standard systems.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D02', 'File documents or records.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D03', 'Process healthcare paperwork.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D04', 'Prepare business correspondence.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D05', 'Perform student enrollment or registration activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D06', 'Perform clerical work in medical settings.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D07', 'Type documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D08', 'Process library materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D09', 'Prepare administrative documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I01', '4.A.4.c.1.I01.D10', 'Perform administrative or clerical tasks.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I02', '4.A.4.c.1.I02.D01', 'Administer oaths to court participants.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I02', '4.A.4.c.1.I02.D02', 'Serve court ordered documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D01', 'Operate cash registers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D02', 'Submit financial applications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D03', 'Process medical billing information.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D04', 'Execute sales or other financial transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D05', 'Issue money, credit, or vouchers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D06', 'Process customer bills or payments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D07', 'Pay charges, fees, or taxes.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D08', 'Arrange insurance coverage.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D09', 'Take customer orders.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D10', 'Take product orders from customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D11', 'Process sales or other transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D12', 'Disburse funds from clients accounts to creditors.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I03', '4.A.4.c.1.I03.D13', 'Conduct gaming transactions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I04', '4.A.4.c.1.I04.D01', 'Issue permits or other legal documents.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I04', '4.A.4.c.1.I04.D02', 'Issue documentation or identification to customers or employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I04', '4.A.4.c.1.I04.D03', 'Issue warnings or citations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I04', '4.A.4.c.1.I04.D04', 'Issue certificates or licenses.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I05', '4.A.4.c.1.I05.D01', 'Receive shipments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I05', '4.A.4.c.1.I05.D02', 'Prepare outgoing mail.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I05', '4.A.4.c.1.I05.D03', 'Send information, materials or documentation.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I05', '4.A.4.c.1.I05.D04', 'Route mail to correct destinations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.1', '4.A.4.c.1.I06', '4.A.4.c.1.I06.D01', 'Process forensic or legal evidence in accordance with procedures.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D01', 'Audition or interview potential performers or staff members.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D02', 'Conduct eligibility or selection interviews.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D03', 'Hire personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D04', 'Participate in staffing decisions.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D05', 'Recruit personnel.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D06', 'Select staff, team members, or performers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D07', 'Hire farming, fishing or forestry workers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I01', '4.A.4.c.2.I01.D08', 'Administer personnel recruitment or hiring activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I02', '4.A.4.c.2.I02.D01', 'Perform human resources activities.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I02', '4.A.4.c.2.I02.D02', 'Administer compensation or benefits programs.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.2', '4.A.4.c.2.I02', '4.A.4.c.2.I02.D03', 'Administer standardized physical or psychological tests.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D01', 'Maintain food, beverage, or equipment inventories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D02', 'Maintain inventory of medical supplies or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D03', 'Manage inventories of products or organizational resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D04', 'Maintain supply or equipment inventories.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D05', 'Maintain inventories of materials, equipment, or products.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I01', '4.A.4.c.3.I01.D06', 'Maintain the inventory of equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I02', '4.A.4.c.3.I02.D01', 'Order medical diagnostic or clinical tests.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D01', 'Distribute instructional or library materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D02', 'Allocate physical resources within organizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D03', 'Distribute materials to employees or customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D04', 'Assign resources or facilities to patrons or employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D05', 'Distribute resources to patrons or employees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D06', 'Provide educational materials to community members.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D07', 'Distribute incoming mail.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I03', '4.A.4.c.3.I03.D08', 'Distribute supplies to workers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I04', '4.A.4.c.3.I04.D01', 'Collect deposits, payments or fees.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I04', '4.A.4.c.3.I04.D02', 'Collect fares or payment from customers.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I04', '4.A.4.c.3.I04.D03', 'Collect payments for goods or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D01', 'Order materials, supplies, or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D02', 'Order instructional or library materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D03', 'Purchase materials, equipment, or other resources.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D04', 'Purchase stocks of merchandise or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D05', 'Order construction or extraction materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D06', 'Purchase products or services.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D07', 'Order medical supplies or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I05', '4.A.4.c.3.I05.D08', 'Acquire supplies or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I06', '4.A.4.c.3.I06.D01', 'Prescribe treatments or therapies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I06', '4.A.4.c.3.I06.D02', 'Control prescription refills or authorizations.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I06', '4.A.4.c.3.I06.D03', 'Prescribe medications.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I06', '4.A.4.c.3.I06.D04', 'Prescribe assistive medical devices or related treatments.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I07', '4.A.4.c.3.I07.D01', 'Monitor availability of equipment or supplies.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I07', '4.A.4.c.3.I07.D02', 'Inventory materials or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I07', '4.A.4.c.3.I07.D03', 'Inventory medical supplies or equipment.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I07', '4.A.4.c.3.I07.D04', 'Monitor inventories of products or materials.');
INSERT INTO dwa_reference (element_id, iwa_id, dwa_id, dwa_title) VALUES ('4.A.4.c.3', '4.A.4.c.3.I07', '4.A.4.c.3.I07.D05', 'Monitor resources.');

