CREATE TABLE education_training_experience (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  category DECIMAL(3,0),
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id),
  FOREIGN KEY (element_id, scale_id, category) REFERENCES ete_categories(element_id, scale_id, category));
GO

INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 4, 6.05, 27, 4.43, 1.28, 24.19, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 5, 4.23, 27, 4.27, 0.50, 27.80, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 6, 21.61, 27, 9.79, 7.76, 47.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 7, 13.66, 27, 8.42, 3.52, 40.70, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 8, 25.83, 27, 11.34, 9.35, 54.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 9, 19.23, 27, 16.21, 2.71, 67.05, 'Y', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 11, 9.39, 27, 6.68, 2.02, 34.26, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 5, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 6, 5.55, 27, 5.48, 0.68, 33.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 7, 12.75, 27, 8.16, 3.13, 39.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 8, 9.17, 27, 5.63, 2.46, 28.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 9, 28.17, 27, 11.44, 10.93, 55.63, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 10, 12.63, 27, 7.39, 3.52, 36.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.1', 'RW', 11, 31.74, 27, 9.93, 15.34, 54.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 1, 26.49, 27, 13.04, 8.34, 58.81, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 2, 3.24, 27, 3.28, 0.39, 22.32, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 3, 13.64, 27, 7.30, 4.23, 36.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 4, 0.43, 27, 0.45, 0.05, 3.55, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 5, 5.55, 27, 5.48, 0.68, 33.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 6, 19.36, 27, 9.34, 6.56, 45.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 7, 7.83, 27, 4.83, 2.10, 25.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 8, 13.85, 27, 8.54, 3.56, 41.17, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.2', 'PT', 9, 9.61, 27, 8.11, 1.54, 41.99, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 1, 36.53, 27, 11.81, 16.81, 62.12, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 2, 9.55, 27, 6.47, 2.22, 32.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 3, 12.50, 27, 8.23, 2.96, 40.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 4, 2.89, 27, 2.95, 0.34, 20.49, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 5, 14.38, 27, 7.08, 4.89, 35.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 6, 12.08, 27, 6.06, 4.08, 30.74, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 7, 7.83, 27, 4.83, 2.10, 25.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 8, 4.23, 27, 4.27, 0.50, 27.80, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 5, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 6, 42.31, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 7, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 8, 30.77, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 10, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 5, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 6, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 7, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 8, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 9, 26.92, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 10, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.1', 'RW', 11, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 1, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 2, 26.92, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 3, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 4, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 5, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 8, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 1, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 2, 19.23, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 3, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 4, 11.54, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 5, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 7, 7.69, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 8, 15.38, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1011.03', '3.A.3', 'OJ', 9, 3.85, 26, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 1, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 2, 15.20, 55, 5.68, 6.90, 30.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 3, 9.00, 55, 7.37, 1.60, 37.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 4, 19.18, 55, 6.91, 8.85, 36.70, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 5, 8.59, 55, 4.24, 3.09, 21.71, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 6, 29.29, 55, 9.64, 14.01, 51.29, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 7, 14.58, 55, 7.77, 4.66, 37.35, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 8, 0.80, 55, 0.81, 0.10, 5.89, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 9, 3.37, 55, 3.20, 0.48, 20.02, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 10, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 11, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '2.D.1', 'RL', 12, 0.00, 55, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 1, 1.08, 54, 1.10, 0.14, 7.86, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 2, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 3, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 4, 0.00, 54, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 5, 5.09, 54, 4.58, 0.80, 26.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 6, 11.27, 54, 5.06, 4.40, 25.96, 'N', '2015-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 7, 22.06, 54, 8.78, 9.23, 44.07, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 8, 24.36, 54, 9.00, 10.78, 46.18, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 9, 8.65, 54, 4.52, 2.92, 22.95, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 10, 13.04, 54, 6.68, 4.39, 32.85, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.1', 'RW', 11, 14.44, 54, 7.77, 4.57, 37.32, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 1, 6.82, 54, 3.77, 2.18, 19.41, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 2, 27.29, 54, 9.39, 12.69, 49.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 3, 12.03, 54, 7.51, 3.19, 36.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 4, 15.58, 54, 6.95, 6.01, 34.74, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 5, 16.76, 54, 7.80, 6.16, 38.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 6, 11.53, 54, 5.41, 4.31, 27.40, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 7, 4.83, 54, 2.73, 1.52, 14.30, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 8, 4.84, 54, 4.14, 0.83, 23.57, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.2', 'PT', 9, 0.31, 54, 0.32, 0.04, 2.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 1, 3.68, 54, 2.99, 0.70, 17.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 2, 24.78, 54, 7.86, 12.39, 43.42, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 3, 8.56, 54, 3.74, 3.47, 19.61, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 4, 18.25, 54, 6.91, 8.11, 36.11, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 5, 30.95, 54, 8.09, 17.34, 48.93, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 6, 6.28, 54, 4.98, 1.21, 26.78, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 7, 2.68, 54, 2.18, 0.51, 12.86, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 8, 4.50, 54, 4.12, 0.68, 24.39, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-1021.00', '3.A.3', 'OJ', 9, 0.31, 54, 0.32, 0.04, 2.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 1, 6.16, 27, 5.88, 0.80, 34.72, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 2, 9.82, 27, 5.94, 2.67, 30.19, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 4, 7.67, 27, 5.32, 1.74, 28.00, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 5, 8.04, 27, 5.48, 1.87, 28.62, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 6, 60.02, 27, 9.98, 38.97, 77.92, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 7, 2.42, 27, 2.41, 0.31, 16.76, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 8, 5.87, 27, 4.19, 1.30, 22.88, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '2.D.4.a', 'IM', NULL, 1.98, 23, 0.22, 1.52, 2.43, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 5, 14.20, 27, 7.64, 4.36, 37.53, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 6, 13.73, 27, 6.83, 4.64, 34.24, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 7, 21.74, 27, 8.15, 9.41, 42.64, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 8, 26.52, 27, 8.50, 12.83, 46.94, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 9, 16.49, 27, 7.77, 5.83, 38.65, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 10, 2.42, 27, 2.41, 0.31, 16.76, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.1', 'RW', 11, 4.90, 27, 4.75, 0.63, 29.48, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 1, 22.39, 27, 7.70, 10.40, 41.76, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 2, 25.12, 27, 8.60, 11.59, 46.20, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 3, 21.26, 27, 8.52, 8.66, 43.47, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 4, 10.12, 27, 6.92, 2.30, 34.97, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 5, 7.34, 27, 5.12, 1.66, 27.11, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 6, 6.45, 27, 4.56, 1.44, 24.58, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 7, 2.42, 27, 2.41, 0.31, 16.76, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.2', 'PT', 9, 4.90, 27, 4.75, 0.63, 29.48, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 1, 10.58, 27, 5.91, 3.17, 29.93, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 2, 38.54, 27, 9.42, 21.69, 58.68, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 3, 21.64, 27, 8.31, 9.16, 43.05, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 4, 7.65, 27, 5.31, 1.74, 27.96, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 5, 11.03, 27, 6.16, 3.30, 31.07, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 6, 5.66, 27, 3.96, 1.29, 21.63, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 8, 4.90, 27, 4.75, 0.63, 29.48, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2011.00', '3.A.4.a', 'IM', NULL, 2.11, 23, 0.25, 1.58, 2.64, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 2, 3.53, 37, 3.56, 0.44, 23.40, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 4, 2.80, 37, 2.07, 0.61, 11.88, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 5, 3.03, 37, 2.06, 0.75, 11.48, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 6, 55.76, 37, 16.96, 23.82, 83.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 8, 24.36, 37, 9.60, 10.06, 48.09, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 9, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 10, 10.52, 37, 9.00, 1.66, 44.97, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 11, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '2.D.1', 'RL', 12, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 2, 1.43, 37, 1.46, 0.17, 10.69, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 4, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 5, 9.04, 37, 6.85, 1.80, 35.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 6, 7.23, 37, 4.34, 2.05, 22.44, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 7, 12.08, 37, 6.27, 3.99, 31.28, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 8, 18.80, 37, 8.06, 7.35, 40.33, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 9, 14.98, 37, 8.92, 4.08, 42.18, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 10, 33.99, 37, 10.86, 16.17, 57.87, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.1', 'RW', 11, 2.47, 37, 1.70, 0.60, 9.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 1, 33.95, 37, 9.41, 17.99, 54.63, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 2, 14.98, 37, 6.52, 5.87, 33.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 3, 32.96, 37, 10.19, 16.18, 55.60, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 4, 11.25, 37, 6.80, 3.09, 33.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 5, 5.71, 37, 3.27, 1.73, 17.20, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 6, 1.15, 37, 1.18, 0.14, 8.77, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 7, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 8, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.2', 'PT', 9, 0.00, 37, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 1, 2.40, 36, 2.44, 0.29, 16.94, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 2, 8.91, 36, 4.53, 3.06, 23.29, 'N', '2015-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 3, 52.82, 36, 11.25, 30.93, 73.68, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 4, 15.63, 36, 7.81, 5.27, 38.14, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 5, 9.71, 36, 4.34, 3.79, 22.71, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 6, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 7, 10.53, 36, 9.01, 1.66, 45.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 8, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2021.00', '3.A.3', 'OJ', 9, 0.00, 36, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 6, 65.22, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 7, 8.70, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 8, 8.70, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 6, 13.04, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 7, 13.04, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 8, 26.09, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 9, 34.78, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 10, 8.70, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 3, 26.09, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 4, 17.39, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 5, 17.39, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 6, 8.70, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 3, 26.09, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 5, 30.43, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 6, 8.70, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-2022.00', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 1, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 2, 33.56, 45, 14.35, 12.13, 64.88, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 3, 13.16, 45, 6.14, 4.88, 30.92, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 4, 13.18, 45, 6.47, 4.63, 32.19, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 5, 11.84, 45, 5.36, 4.56, 27.43, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 6, 24.28, 45, 8.72, 10.98, 45.46, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 7, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 8, 3.87, 45, 2.34, 1.12, 12.54, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 9, 0.06, 45, 0.06, 0.01, 0.48, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 10, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 11, 0.06, 45, 0.06, 0.01, 0.48, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '2.D.1', 'RL', 12, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 1, 3.21, 45, 3.01, 0.47, 18.96, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 2, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 3, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 4, 2.52, 45, 2.55, 0.32, 17.28, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 5, 1.67, 45, 1.70, 0.21, 12.04, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 6, 26.78, 45, 15.10, 7.19, 63.31, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 7, 31.24, 45, 9.52, 15.69, 52.60, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 8, 21.73, 45, 9.08, 8.65, 44.88, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 9, 6.92, 45, 3.86, 2.17, 19.92, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 10, 5.02, 45, 3.25, 1.32, 17.25, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.1', 'RW', 11, 0.89, 45, 0.86, 0.13, 6.05, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 1, 13.82, 45, 6.62, 4.97, 32.95, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 2, 14.50, 45, 7.18, 5.01, 35.26, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 3, 34.62, 45, 14.45, 12.76, 65.71, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 4, 13.03, 45, 7.36, 3.89, 35.67, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 5, 17.86, 45, 7.33, 7.36, 37.32, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 6, 3.39, 45, 2.43, 0.78, 13.53, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 7, 1.38, 45, 1.39, 0.18, 9.90, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 8, 1.41, 45, 1.44, 0.18, 10.35, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.2', 'PT', 9, 0.00, 45, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 1, 1.13, 44, 1.11, 0.15, 7.82, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 2, 15.92, 44, 5.95, 7.17, 31.71, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 3, 48.28, 44, 12.61, 25.21, 72.11, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 4, 15.80, 44, 6.03, 7.00, 31.87, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 5, 11.87, 44, 5.02, 4.86, 26.19, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 6, 6.88, 44, 3.57, 2.34, 18.54, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 7, 0.12, 44, 0.13, 0.02, 0.98, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 8, 0.00, 44, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3012.00', '3.A.3', 'OJ', 9, 0.00, 44, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 2, 1.26, 26, 1.30, 0.15, 9.96, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 3, 5.77, 26, 5.78, 0.68, 35.39, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 4, 25.96, 26, 15.16, 6.46, 64.01, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 5, 2.16, 26, 1.66, 0.44, 10.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 6, 47.68, 26, 17.06, 18.23, 78.84, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 7, 2.80, 26, 2.88, 0.33, 20.26, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 8, 14.36, 26, 10.19, 2.96, 48.01, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 11, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '2.D.1', 'RL', 12, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 4, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 5, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 6, 1.08, 26, 1.12, 0.13, 8.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 7, 11.15, 26, 6.76, 2.99, 33.85, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 8, 23.94, 26, 12.49, 7.12, 56.38, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 9, 40.02, 26, 16.33, 14.12, 73.03, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 10, 10.55, 26, 8.88, 1.67, 45.04, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.1', 'RW', 11, 13.25, 26, 8.72, 3.11, 42.13, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 1, 16.82, 26, 10.76, 3.98, 49.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 2, 31.64, 26, 17.98, 7.71, 71.94, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 3, 5.33, 26, 3.44, 1.37, 18.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 4, 6.90, 26, 4.54, 1.70, 24.09, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 5, 23.00, 26, 14.30, 5.36, 61.19, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 6, 9.72, 26, 9.20, 1.23, 48.25, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 8, 6.58, 26, 6.22, 0.87, 36.17, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 1, 0.76, 26, 0.80, 0.09, 6.30, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 2, 15.17, 26, 8.72, 4.24, 41.94, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 3, 24.43, 26, 11.18, 8.50, 52.94, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 4, 23.48, 26, 11.97, 7.22, 54.75, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 5, 32.63, 26, 15.78, 9.95, 67.98, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 6, 3.53, 26, 3.00, 0.59, 18.34, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 7, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3021.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 5, 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 6, 56.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 7, 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 8, 32.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 10, 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '2.D.4.a', 'IM', NULL, 3.52, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 6, 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 7, 12.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 8, 20.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 9, 24.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 10, 16.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.1', 'RW', 11, 24.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 1, 28.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 2, 16.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 4, 20.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 5, 12.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 6, 8.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 7, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 8, 8.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.2', 'PT', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 1, 28.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 2, 4.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 4, 20.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 5, 16.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 6, 8.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 7, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 8, 16.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.3', 'OJ', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.01', '3.A.4.a', 'IM', NULL, 1.71, 24, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 1, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 2, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 5, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 6, 32.66, 25, 13.05, 12.47, 62.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 7, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 8, 63.33, 25, 12.76, 35.72, 84.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 9, 2.01, 25, 2.03, 0.24, 14.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 10, 2.01, 25, 2.03, 0.24, 14.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 11, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '2.D.1', 'RL', 12, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 1, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 2, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 5, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 6, 1.51, 25, 1.59, 0.17, 12.18, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 7, 1.51, 25, 1.57, 0.18, 11.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 8, 24.86, 25, 9.96, 9.91, 49.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 9, 16.35, 25, 4.87, 8.57, 28.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 10, 28.36, 25, 12.13, 10.35, 57.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.1', 'RW', 11, 27.40, 25, 8.46, 13.57, 47.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 1, 27.75, 25, 10.27, 11.77, 52.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 2, 14.84, 25, 5.00, 7.15, 28.28, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 3, 13.11, 25, 9.77, 2.51, 46.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 4, 9.18, 25, 6.84, 1.82, 35.48, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 5, 14.96, 25, 9.59, 3.58, 45.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 6, 10.58, 25, 5.66, 3.33, 28.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 7, 6.07, 25, 4.62, 1.20, 25.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 8, 0.00, 25, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.2', 'PT', 9, 3.52, 25, 2.59, 0.75, 14.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 1, 16.19, 24, 8.95, 4.70, 43.05, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 2, 13.53, 24, 6.51, 4.72, 33.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 4, 9.47, 24, 4.77, 3.20, 24.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 5, 28.63, 24, 10.72, 11.93, 54.30, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 6, 20.10, 24, 10.27, 6.28, 48.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 7, 8.51, 24, 5.84, 1.93, 30.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 8, 1.54, 24, 1.57, 0.18, 11.78, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3031.03', '3.A.3', 'OJ', 9, 2.04, 24, 2.06, 0.24, 14.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 1, 0.62, 38, 0.63, 0.08, 4.71, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 2, 6.66, 38, 5.59, 1.14, 30.64, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 3, 2.55, 38, 2.51, 0.34, 16.87, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 4, 30.32, 38, 10.51, 13.70, 54.40, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 5, 15.11, 38, 9.53, 3.80, 44.50, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 6, 42.38, 38, 9.49, 25.08, 61.77, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 7, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 8, 2.37, 38, 1.94, 0.44, 11.70, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 9, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 10, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 11, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '2.D.1', 'RL', 12, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 1, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 2, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 3, 0.00, 37, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 4, 1.84, 37, 1.87, 0.23, 13.30, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 5, 8.38, 37, 5.04, 2.36, 25.70, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 6, 1.21, 37, 0.89, 0.27, 5.26, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 7, 30.79, 37, 10.37, 14.22, 54.41, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 8, 28.89, 37, 10.39, 12.71, 53.12, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 9, 12.95, 37, 6.47, 4.44, 32.27, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 10, 7.72, 37, 4.62, 2.20, 23.74, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.1', 'RW', 11, 8.23, 37, 4.34, 2.72, 22.34, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 1, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 2, 25.23, 38, 9.81, 10.53, 49.18, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 3, 15.00, 38, 7.00, 5.48, 34.93, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 4, 22.23, 38, 8.89, 9.16, 44.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 5, 6.96, 38, 3.86, 2.19, 20.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 6, 16.73, 38, 9.76, 4.63, 45.39, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 7, 9.74, 38, 5.00, 3.30, 25.46, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 8, 1.84, 38, 1.42, 0.38, 8.43, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.2', 'PT', 9, 2.27, 38, 2.31, 0.28, 16.06, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 1, 0.98, 38, 1.01, 0.12, 7.51, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 2, 12.38, 38, 6.64, 3.92, 32.83, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 3, 22.01, 38, 9.17, 8.73, 45.44, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 4, 13.61, 38, 6.58, 4.83, 32.86, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 5, 14.20, 38, 7.02, 4.89, 34.74, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 6, 28.41, 38, 9.73, 13.08, 51.13, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 7, 5.65, 38, 4.83, 0.95, 27.26, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 8, 2.76, 38, 2.02, 0.61, 11.56, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.00', '3.A.3', 'OJ', 9, 0.00, 38, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 4, 10.81, 17, 9.41, 1.51, 48.96, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 5, 1.12, 17, 1.17, 0.12, 9.61, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 6, 73.33, 17, 13.32, 39.36, 92.09, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 7, 3.75, 17, 3.84, 0.41, 27.06, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 8, 10.99, 17, 9.38, 1.59, 48.53, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 10, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 11, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '2.D.1', 'RL', 12, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 4, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 5, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 6, 1.12, 17, 1.18, 0.12, 9.75, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 7, 26.46, 17, 13.73, 7.46, 61.63, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 8, 48.42, 17, 16.75, 18.47, 79.56, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 9, 10.78, 17, 10.26, 1.24, 53.68, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 10, 13.21, 17, 11.38, 1.82, 55.52, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.1', 'RW', 11, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 2, 28.79, 17, 16.19, 7.04, 68.33, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 4, 28.07, 17, 16.50, 6.46, 68.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 5, 3.55, 17, 2.32, 0.87, 13.38, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 6, 25.37, 17, 13.20, 7.20, 59.85, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 7, 11.90, 17, 10.32, 1.65, 52.13, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 8, 2.32, 17, 1.77, 0.45, 11.03, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.2', 'PT', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 2, 12.09, 17, 11.33, 1.41, 56.87, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 3, 15.57, 17, 13.98, 1.90, 63.71, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 4, 40.00, 17, 16.91, 13.02, 74.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 5, 11.93, 17, 9.45, 1.97, 47.68, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 6, 6.18, 17, 4.41, 1.30, 24.81, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 7, 13.03, 17, 10.39, 2.10, 51.16, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 8, 1.20, 17, 1.26, 0.13, 10.32, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.01', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 2, 11.15, 20, 7.24, 2.65, 36.68, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 3, 18.91, 20, 9.32, 6.14, 45.40, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 4, 47.61, 20, 14.85, 20.72, 75.97, 'N', '2011-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 5, 2.72, 20, 2.87, 0.29, 21.31, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 6, 14.61, 20, 12.34, 2.11, 57.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 7, 4.99, 20, 4.89, 0.60, 31.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 4, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 5, 11.46, 21, 5.96, 3.67, 30.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 6, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 7, 14.67, 21, 8.25, 4.17, 40.45, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 8, 19.57, 21, 8.72, 7.12, 43.58, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 9, 12.48, 21, 8.10, 2.94, 40.12, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.1', 'RW', 11, 41.82, 21, 12.78, 19.38, 68.26, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 1, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 3, 9.56, 21, 5.58, 2.68, 28.87, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 4, 7.19, 21, 5.42, 1.41, 29.63, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 5, 23.73, 21, 9.63, 9.30, 48.57, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 6, 18.48, 21, 10.76, 4.86, 50.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 7, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 8, 30.16, 21, 10.17, 13.62, 54.17, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.2', 'PT', 9, 5.66, 21, 4.41, 1.06, 25.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 1, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 3, 6.81, 21, 5.36, 1.24, 29.85, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 4, 2.61, 21, 2.78, 0.27, 20.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 5, 30.54, 21, 6.65, 18.62, 45.81, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 6, 16.33, 21, 6.98, 6.30, 36.17, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 7, 15.02, 21, 8.81, 4.02, 42.74, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 8, 20.43, 21, 10.26, 6.44, 48.93, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.02', '3.A.3', 'OJ', 9, 5.66, 21, 4.41, 1.06, 25.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 2, 14.00, 23, 7.66, 4.17, 37.86, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 4, 19.13, 23, 9.71, 6.05, 46.51, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 5, 14.83, 23, 7.27, 5.01, 36.49, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 6, 45.44, 23, 12.11, 23.22, 69.65, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 7, 6.60, 23, 6.52, 0.78, 38.76, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 8, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 1, 12.69, 23, 6.82, 3.90, 34.27, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 2, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 4, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 5, 4.46, 23, 4.21, 0.60, 26.63, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 6, 17.76, 23, 8.82, 5.82, 43.03, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 7, 34.62, 23, 11.59, 15.48, 60.49, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 8, 27.59, 23, 10.62, 11.24, 53.42, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 10, 2.87, 23, 2.90, 0.34, 20.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.1', 'RW', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 2, 12.70, 23, 7.15, 3.68, 35.65, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 3, 11.06, 23, 7.51, 2.49, 37.70, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 4, 27.19, 23, 10.56, 11.00, 53.02, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 5, 37.32, 23, 11.59, 17.56, 62.45, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 6, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 7, 6.73, 23, 4.23, 1.76, 22.57, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 8, 5.00, 23, 4.94, 0.60, 31.29, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.2', 'PT', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 2, 9.83, 23, 6.63, 2.26, 33.95, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 3, 18.29, 23, 8.52, 6.43, 42.19, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 4, 16.13, 23, 9.24, 4.46, 44.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 5, 26.25, 23, 9.76, 11.11, 50.32, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 6, 11.17, 23, 7.39, 2.61, 37.09, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 7, 13.33, 23, 7.52, 3.84, 37.23, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 8, 5.00, 23, 4.94, 0.60, 31.29, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.03', '3.A.3', 'OJ', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 2, 6.83, 21, 6.81, 0.78, 40.64, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 3, 13.23, 21, 10.23, 2.32, 49.45, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 4, 1.75, 21, 1.37, 0.34, 8.53, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 5, 16.70, 21, 10.25, 4.14, 48.23, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 6, 61.49, 21, 15.22, 29.46, 85.92, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 7, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 8, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 11, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.1', 'RL', 12, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '2.D.4.a', 'IM', NULL, 2.78, 21, 0.41, 1.92, 3.64, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 4, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 5, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 6, 9.56, 21, 7.14, 1.85, 37.19, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 7, 5.24, 21, 3.94, 1.04, 22.46, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 8, 18.23, 21, 13.43, 3.30, 59.34, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 9, 12.43, 21, 9.51, 2.24, 46.78, 'N', '2020-08-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 10, 13.65, 21, 12.63, 1.66, 59.66, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.1', 'RW', 11, 40.89, 21, 17.10, 13.66, 75.16, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 1, 1.76, 21, 1.37, 0.34, 8.55, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 2, 16.55, 21, 13.42, 2.55, 60.10, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 4, 28.49, 21, 15.11, 7.82, 65.17, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 5, 16.39, 21, 12.66, 2.77, 57.39, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 6, 0.90, 21, 0.95, 0.10, 7.73, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 7, 6.83, 21, 6.81, 0.78, 40.64, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 8, 28.21, 21, 15.65, 7.27, 66.32, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.2', 'PT', 9, 0.88, 21, 0.93, 0.10, 7.57, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 1, 13.65, 21, 12.63, 1.66, 59.66, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 2, 16.55, 21, 13.42, 2.55, 60.10, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 4, 17.18, 21, 12.67, 3.13, 57.08, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 5, 23.72, 21, 13.21, 6.35, 58.78, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 6, 4.35, 21, 3.75, 0.69, 22.99, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 7, 6.83, 21, 6.81, 0.78, 40.64, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 8, 0.97, 21, 1.03, 0.11, 8.34, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.3', 'OJ', 9, 16.74, 21, 14.27, 2.32, 62.97, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.04', '3.A.4.a', 'IM', NULL, 2.57, 21, 0.44, 1.66, 3.48, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 2, 13.59, 29, 6.18, 5.08, 31.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 3, 28.95, 29, 8.57, 14.79, 48.91, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 4, 14.08, 29, 6.11, 5.51, 31.55, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 5, 21.28, 29, 8.17, 9.05, 42.35, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 6, 14.85, 29, 6.43, 5.80, 33.07, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 7, 7.24, 29, 5.15, 1.60, 27.27, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 1, 3.03, 29, 3.02, 0.38, 20.36, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 4, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 5, 2.97, 29, 2.95, 0.37, 20.01, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 6, 10.24, 29, 5.92, 2.96, 29.92, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 7, 7.99, 29, 5.53, 1.83, 28.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 8, 29.66, 29, 9.44, 14.30, 51.59, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 9, 23.20, 29, 9.31, 9.39, 46.84, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 10, 8.28, 29, 4.76, 2.44, 24.58, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.1', 'RW', 11, 14.63, 29, 6.71, 5.40, 33.98, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 1, 4.48, 29, 4.21, 0.62, 26.00, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 2, 8.70, 29, 4.97, 2.57, 25.56, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 3, 10.27, 29, 5.98, 2.94, 30.18, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 4, 11.68, 29, 5.83, 3.99, 29.63, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 5, 10.61, 29, 6.06, 3.11, 30.51, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 6, 16.04, 29, 7.14, 6.06, 36.14, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 7, 26.46, 29, 8.47, 12.85, 46.74, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 8, 11.76, 29, 5.61, 4.22, 28.73, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 1, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 3, 11.46, 29, 6.43, 3.41, 32.17, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 4, 18.56, 29, 7.37, 7.74, 38.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 5, 14.50, 29, 6.63, 5.37, 33.65, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 6, 18.02, 29, 9.48, 5.58, 45.00, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 7, 15.03, 29, 7.23, 5.26, 36.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 8, 18.56, 29, 7.00, 8.11, 37.04, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3051.06', '3.A.3', 'OJ', 9, 3.87, 29, 3.81, 0.49, 24.76, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 6, 75.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '2.D.4.a', 'IM', NULL, 2.90, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 7, 23.81, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 8, 42.86, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 9, 19.05, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 10, 9.52, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.1', 'RW', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 1, 14.29, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 3, 4.76, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 4, 28.57, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 6, 14.29, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 8, 19.05, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 3, 9.52, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 4, 28.57, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 6, 9.52, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 8, 9.52, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3061.00', '3.A.4.a', 'IM', NULL, 1.76, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 6, 66.67, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 8, 19.05, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 6, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 7, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 8, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 9, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 10, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.1', 'RW', 11, 33.33, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 1, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 2, 19.05, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 8, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 2, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 4, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 6, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3071.04', '3.A.3', 'OJ', 9, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 6, 80.95, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 8, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '2.D.4.a', 'IM', NULL, 3.38, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 6, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 8, 57.14, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 9, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 10, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.1', 'RW', 11, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 1, 28.57, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 3, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 4, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 5, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 6, 9.52, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 2, 23.81, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 3, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 5, 19.05, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 6, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 7, 14.29, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3111.00', '3.A.4.a', 'IM', NULL, 1.43, 21, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 6, 73.91, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 7, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 8, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 9, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '2.D.4.a', 'IM', NULL, 3.42, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 7, 12.50, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 8, 54.17, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 9, 12.50, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 10, 16.67, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.1', 'RW', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 1, 33.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 3, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 1, 33.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 2, 16.67, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 3, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 5, 20.83, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 8, 4.17, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3121.00', '3.A.4.a', 'IM', NULL, 1.71, 24, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 1, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 2, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 4, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 5, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 6, 51.85, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 7, 14.81, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 8, 18.52, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 9, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 10, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 11, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.1', 'RL', 12, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '2.D.4.a', 'IM', NULL, 3.33, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 1, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 2, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 3, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 4, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 5, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 6, 0.00, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 7, 29.63, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 8, 25.93, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 9, 25.93, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 10, 11.11, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.1', 'RW', 11, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 1, 11.11, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 2, 18.52, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 3, 22.22, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 4, 7.41, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 5, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 6, 14.81, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 7, 11.11, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 8, 7.41, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.2', 'PT', 9, 3.70, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 1, 11.54, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 2, 23.08, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 3, 7.69, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 4, 15.38, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 5, 15.38, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 6, 19.23, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 7, 3.85, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 8, 0.00, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.3', 'OJ', 9, 3.85, 26, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-3131.00', '3.A.4.a', 'IM', NULL, 1.85, 27, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 6, 90.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '2.D.4.a', 'IM', NULL, 3.10, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 6, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 7, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 8, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 9, 35.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 10, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 2, 30.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 7, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.2', 'PT', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 7, 30.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9021.00', '3.A.4.a', 'IM', NULL, 1.95, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 2, 25.65, 27, 12.91, 7.91, 58.10, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 3, 6.18, 27, 5.98, 0.78, 35.44, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 4, 19.70, 27, 10.00, 6.27, 47.36, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 5, 31.95, 27, 19.05, 7.19, 73.98, 'Y', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 6, 10.33, 27, 4.76, 3.85, 24.88, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 7, 5.97, 27, 5.82, 0.75, 34.88, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 8, 0.22, 27, 0.17, 0.05, 1.08, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 4, 6.14, 26, 6.24, 0.70, 37.80, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 5, 27.37, 26, 13.90, 8.20, 61.40, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 6, 17.40, 26, 9.73, 4.97, 45.92, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 7, 36.38, 26, 18.99, 9.54, 75.61, 'Y', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 8, 12.59, 26, 7.77, 3.25, 38.14, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.1', 'RW', 11, 0.11, 26, 0.12, 0.01, 0.98, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 1, 9.82, 26, 6.48, 2.35, 32.97, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 2, 20.06, 26, 9.64, 6.78, 46.41, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 3, 14.26, 26, 8.58, 3.77, 41.37, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 4, 6.25, 26, 6.24, 0.74, 37.44, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 5, 8.22, 26, 6.50, 1.50, 34.53, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 6, 8.31, 26, 6.75, 1.44, 35.99, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 7, 29.79, 26, 19.71, 5.74, 74.71, 'Y', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 8, 3.28, 26, 3.39, 0.38, 23.37, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 1, 18.86, 27, 9.74, 5.91, 46.24, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 2, 22.77, 27, 10.25, 8.17, 49.41, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 3, 17.63, 27, 8.58, 5.97, 41.90, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 4, 0.22, 27, 0.17, 0.05, 1.08, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 5, 5.90, 27, 5.82, 0.72, 35.09, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 6, 6.09, 27, 6.07, 0.73, 36.52, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 7, 25.97, 27, 19.82, 4.04, 74.49, 'Y', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 8, 2.57, 27, 2.66, 0.29, 19.04, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9031.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 1, 0.00, 25, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 2, 9.13, 25, 8.66, 1.15, 46.41, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 3, 0.00, 25, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 4, 0.00, 25, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 5, 0.00, 25, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 6, 6.59, 25, 6.31, 0.84, 36.92, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 7, 0.31, 25, 0.32, 0.04, 2.54, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 8, 37.06, 25, 13.42, 15.22, 65.87, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 9, 43.56, 25, 13.63, 19.73, 70.80, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 10, 3.22, 25, 3.25, 0.39, 22.23, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 11, 0.14, 25, 0.14, 0.02, 1.13, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.1', 'RL', 12, 0.00, 25, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '2.D.4.a', 'IM', NULL, 4.11, 25, 0.30, 3.49, 4.73, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 4, 6.46, 24, 6.32, 0.79, 37.50, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 5, 0.14, 24, 0.14, 0.02, 1.14, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 6, 11.72, 24, 8.94, 2.17, 44.24, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 7, 38.37, 24, 13.66, 15.86, 67.28, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 8, 33.82, 24, 13.11, 13.20, 63.20, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 9, 4.62, 24, 4.48, 0.59, 28.41, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 10, 4.74, 24, 4.34, 0.68, 26.65, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.1', 'RW', 11, 0.14, 24, 0.14, 0.02, 1.14, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 1, 12.37, 24, 9.13, 2.41, 44.62, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 2, 31.31, 24, 12.65, 11.89, 60.62, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 3, 0.24, 24, 0.25, 0.03, 2.00, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 4, 5.39, 24, 4.00, 1.12, 22.38, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 5, 18.41, 24, 11.52, 4.42, 52.44, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 6, 19.29, 24, 11.51, 4.92, 52.44, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 7, 8.36, 24, 7.79, 1.10, 42.77, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 8, 4.49, 24, 4.47, 0.54, 28.95, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.2', 'PT', 9, 0.14, 24, 0.14, 0.02, 1.14, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 1, 9.14, 24, 8.65, 1.15, 46.43, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 2, 29.16, 24, 12.55, 10.48, 59.13, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 4, 14.91, 24, 9.34, 3.68, 44.54, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 5, 0.58, 24, 0.39, 0.14, 2.31, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 6, 30.00, 24, 13.24, 10.42, 61.22, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 7, 0.38, 24, 0.30, 0.08, 1.91, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 8, 4.49, 24, 4.47, 0.54, 28.95, 'N', '2018-08-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.3', 'OJ', 9, 11.34, 24, 8.34, 2.25, 41.58, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9032.00', '3.A.4.a', 'IM', NULL, 2.96, 24, 0.31, 2.31, 3.61, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 1, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 2, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 3, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 4, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 5, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 6, 7.62, 40, 5.12, 1.86, 26.44, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 7, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 8, 47.94, 40, 10.10, 28.88, 67.61, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 9, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 10, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 11, 37.24, 40, 10.07, 19.89, 58.65, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.1', 'RL', 12, 7.20, 40, 5.45, 1.47, 28.80, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '2.D.4.a', 'IM', NULL, 2.36, 40, 0.30, 1.75, 2.96, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 1, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 2, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 3, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 4, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 5, 0.39, 40, 0.40, 0.05, 3.01, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 6, 5.60, 40, 4.41, 1.08, 24.30, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 7, 8.55, 40, 5.41, 2.26, 27.48, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 8, 33.56, 40, 11.00, 15.70, 57.80, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 9, 18.42, 40, 6.64, 8.45, 35.56, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 10, 7.96, 40, 4.96, 2.16, 25.36, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.1', 'RW', 11, 25.52, 40, 9.14, 11.46, 47.55, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 1, 32.56, 40, 7.64, 19.28, 49.39, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 2, 1.56, 40, 1.03, 0.41, 5.77, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 3, 13.24, 40, 7.33, 4.03, 35.67, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 4, 12.90, 40, 6.82, 4.15, 33.59, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 5, 14.35, 40, 6.79, 5.20, 33.87, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 6, 15.25, 40, 6.49, 6.12, 33.20, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 7, 9.57, 40, 6.66, 2.18, 33.40, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 8, 0.57, 40, 0.59, 0.07, 4.48, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.2', 'PT', 9, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 1, 16.34, 40, 6.35, 7.09, 33.33, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 2, 11.45, 40, 6.01, 3.76, 30.00, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 3, 9.33, 40, 5.93, 2.43, 29.82, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 4, 25.65, 40, 7.71, 13.22, 43.87, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 5, 12.00, 40, 6.48, 3.79, 32.05, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 6, 10.47, 40, 5.14, 3.71, 26.18, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 7, 9.97, 40, 6.70, 2.39, 33.40, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 8, 4.78, 40, 4.71, 0.62, 28.93, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.3', 'OJ', 9, 0.00, 40, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9033.00', '3.A.4.a', 'IM', NULL, 1.53, 40, 0.20, 1.12, 1.94, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 2, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 4, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 5, 1.15, 23, 1.22, 0.12, 9.80, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 6, 45.52, 23, 9.47, 27.46, 64.85, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 7, 1.15, 23, 1.22, 0.12, 9.80, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 8, 27.04, 23, 6.93, 15.17, 43.44, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 9, 11.85, 23, 11.45, 1.37, 56.60, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 10, 12.15, 23, 8.07, 2.80, 39.87, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 11, 1.15, 23, 1.22, 0.12, 9.80, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '2.D.4.a', 'IM', NULL, 3.10, 23, 0.48, 2.09, 4.10, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 1, 5.05, 23, 5.31, 0.53, 34.53, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 2, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 4, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 5, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 6, 5.23, 23, 5.12, 0.64, 32.02, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 7, 1.15, 23, 1.24, 0.12, 10.00, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 8, 6.20, 23, 5.55, 0.90, 32.38, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 9, 31.23, 23, 10.05, 14.67, 54.52, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 10, 15.05, 23, 9.14, 3.87, 43.85, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.1', 'RW', 11, 36.10, 23, 12.78, 15.19, 64.05, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 1, 6.53, 23, 5.68, 1.00, 32.52, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 2, 18.35, 23, 7.90, 7.00, 40.15, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 3, 5.23, 23, 5.12, 0.64, 32.02, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 4, 9.03, 23, 7.02, 1.66, 36.87, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 5, 16.26, 23, 12.01, 3.02, 54.73, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 6, 5.94, 23, 5.22, 0.90, 30.45, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 7, 20.15, 23, 7.65, 8.60, 40.36, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 8, 5.23, 23, 5.12, 0.64, 32.02, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.2', 'PT', 9, 13.29, 23, 7.79, 3.64, 38.38, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 2, 17.20, 23, 8.03, 6.06, 40.08, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 3, 7.35, 23, 5.86, 1.31, 32.11, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 4, 8.36, 23, 5.80, 1.86, 30.51, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 5, 23.03, 23, 13.48, 5.82, 59.17, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 6, 5.05, 23, 5.31, 0.53, 34.53, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 7, 13.95, 23, 7.63, 4.16, 37.72, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 8, 12.91, 23, 8.04, 3.25, 39.52, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.3', 'OJ', 9, 12.15, 23, 8.07, 2.80, 39.87, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.00', '3.A.4.a', 'IM', NULL, 2.13, 23, 0.47, 1.14, 3.11, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 2, 1.33, 33, 1.40, 0.15, 10.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 3, 4.77, 33, 4.68, 0.61, 28.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 5, 5.82, 33, 4.80, 1.03, 26.91, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 6, 55.44, 33, 15.95, 25.03, 82.25, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 7, 1.24, 33, 1.32, 0.14, 10.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 8, 28.62, 33, 14.40, 8.71, 62.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 11, 1.33, 33, 1.42, 0.15, 10.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '2.D.1', 'RL', 12, 1.43, 33, 1.23, 0.25, 7.93, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 1, 1.33, 33, 1.40, 0.15, 10.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 2, 1.57, 33, 1.67, 0.18, 12.55, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 3, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 5, 7.16, 33, 5.28, 1.51, 27.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 6, 4.77, 33, 4.43, 0.68, 26.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 7, 54.02, 33, 15.90, 24.18, 81.24, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 8, 5.29, 33, 3.87, 1.15, 21.20, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 9, 2.00, 33, 1.81, 0.31, 11.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 10, 4.50, 33, 3.50, 0.89, 19.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.1', 'RW', 11, 19.35, 33, 13.31, 4.06, 57.67, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 1, 17.45, 33, 7.58, 6.75, 38.16, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 2, 13.28, 33, 6.97, 4.27, 34.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 3, 26.16, 33, 12.98, 8.27, 58.19, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 4, 15.25, 33, 9.89, 3.65, 46.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 5, 18.00, 33, 9.80, 5.37, 45.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 6, 7.96, 33, 4.35, 2.51, 22.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 7, 0.38, 33, 0.40, 0.04, 3.25, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 8, 1.54, 33, 1.61, 0.18, 12.02, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.2', 'PT', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 1, 1.10, 33, 1.17, 0.12, 9.07, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 2, 13.99, 33, 5.95, 5.60, 30.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 3, 28.79, 33, 9.39, 13.72, 50.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 4, 32.90, 33, 9.68, 16.71, 54.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 5, 3.44, 33, 2.30, 0.87, 12.71, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 6, 4.89, 33, 2.96, 1.38, 15.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 7, 14.90, 33, 12.96, 2.14, 58.40, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 8, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9041.01', '3.A.3', 'OJ', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 1, 15.37, 29, 9.18, 4.10, 43.53, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 2, 55.19, 29, 12.77, 29.96, 78.01, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 3, 4.83, 29, 3.01, 1.31, 16.28, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 4, 18.35, 29, 11.14, 4.67, 50.76, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 5, 0.71, 29, 0.45, 0.20, 2.56, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 6, 1.91, 29, 1.73, 0.29, 11.40, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 7, 3.63, 29, 3.65, 0.44, 24.16, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 1, 18.35, 29, 9.13, 6.06, 43.92, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 3, 3.48, 29, 3.50, 0.43, 23.33, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 4, 12.51, 29, 8.32, 2.92, 40.43, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 5, 1.82, 29, 1.87, 0.22, 13.63, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 6, 29.38, 29, 9.44, 14.07, 51.38, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 7, 29.52, 29, 11.00, 12.42, 55.31, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 8, 4.93, 29, 3.10, 1.32, 16.76, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.1', 'RW', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 1, 1.86, 28, 1.69, 0.28, 11.28, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 2, 21.30, 28, 9.65, 7.67, 46.87, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 3, 6.34, 28, 3.61, 1.91, 19.06, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 4, 21.00, 28, 9.82, 7.31, 47.26, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 5, 22.72, 28, 9.79, 8.56, 48.01, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 6, 16.19, 28, 9.63, 4.31, 45.33, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 7, 8.10, 28, 7.79, 1.02, 43.04, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 8, 2.48, 28, 2.53, 0.30, 17.87, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.2', 'PT', 9, 0.00, 28, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 1, 1.22, 29, 1.05, 0.20, 6.91, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 2, 17.26, 29, 9.00, 5.42, 43.15, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 3, 12.04, 29, 5.56, 4.46, 28.65, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 4, 16.07, 29, 9.51, 4.32, 44.80, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 5, 19.17, 29, 10.14, 5.85, 47.53, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 6, 23.70, 29, 11.07, 8.15, 52.11, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 7, 8.12, 29, 7.61, 1.08, 41.66, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9051.00', '3.A.3', 'OJ', 9, 2.42, 29, 2.47, 0.29, 17.43, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 1, 7.99, 30, 5.65, 1.77, 29.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 2, 34.91, 30, 10.95, 16.68, 58.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 3, 9.81, 30, 5.05, 3.28, 25.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 4, 7.02, 30, 4.38, 1.87, 22.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 5, 8.46, 30, 6.88, 1.48, 36.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 6, 31.81, 30, 10.34, 14.97, 55.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 7, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 8, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 9, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 10, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 11, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '2.D.1', 'RL', 12, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 1, 6.32, 30, 6.51, 0.71, 38.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 2, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 3, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 4, 1.65, 30, 1.67, 0.21, 12.01, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 5, 3.71, 30, 3.27, 0.59, 20.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 6, 12.82, 30, 5.72, 4.91, 29.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 7, 26.33, 30, 8.10, 13.21, 45.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 8, 26.62, 30, 8.15, 13.39, 45.99, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 9, 14.69, 30, 6.69, 5.47, 33.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 10, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.1', 'RW', 11, 5.71, 30, 3.67, 1.48, 19.65, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 1, 15.64, 30, 9.53, 4.06, 44.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 2, 29.68, 30, 8.34, 15.72, 48.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 3, 20.44, 30, 7.86, 8.72, 40.85, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 4, 11.38, 30, 6.98, 3.03, 34.57, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 5, 11.73, 30, 6.90, 3.29, 34.18, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 6, 3.64, 30, 2.43, 0.91, 13.51, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 7, 3.71, 30, 3.27, 0.59, 20.03, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 8, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.2', 'PT', 9, 1.64, 30, 1.65, 0.21, 11.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 1, 10.96, 30, 7.06, 2.73, 35.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 2, 22.07, 30, 9.21, 8.65, 45.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 3, 25.52, 30, 7.70, 13.01, 43.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 4, 21.35, 30, 8.77, 8.53, 44.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 5, 7.11, 30, 4.55, 1.84, 23.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 6, 0.00, 30, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 7, 2.14, 30, 2.12, 0.27, 14.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 8, 8.46, 30, 6.10, 1.81, 31.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9071.00', '3.A.3', 'OJ', 9, 2.40, 30, 1.86, 0.48, 11.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 1, 18.32, 15, 16.41, 2.09, 70.22, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 2, 1.15, 15, 0.88, 0.22, 5.81, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 3, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 4, 5.89, 15, 4.39, 1.13, 25.49, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 5, 3.05, 15, 2.69, 0.44, 18.15, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 6, 71.60, 15, 16.67, 30.28, 93.60, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 7, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 8, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 9, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 10, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 11, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '2.D.1', 'RL', 12, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 1, 18.32, 15, 16.41, 2.09, 70.22, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 2, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 3, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 4, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 5, 0.57, 15, 0.61, 0.06, 5.33, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 6, 19.08, 15, 12.49, 4.00, 57.20, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 7, 43.13, 15, 19.09, 12.50, 80.10, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 8, 18.89, 15, 16.40, 2.29, 69.80, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 9, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 10, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.1', 'RW', 11, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 1, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 2, 18.32, 15, 16.41, 2.09, 70.22, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 3, 35.85, 15, 17.93, 9.50, 74.85, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 4, 24.88, 15, 16.16, 4.93, 67.91, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 5, 1.31, 15, 1.37, 0.14, 11.47, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 6, 1.32, 15, 1.02, 0.25, 6.70, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 7, 18.32, 15, 16.41, 2.09, 70.22, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 8, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.2', 'PT', 9, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 1, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 2, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 3, 41.06, 15, 18.60, 11.81, 78.37, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 4, 3.62, 15, 2.82, 0.66, 17.50, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 5, 17.93, 15, 14.83, 2.46, 65.47, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 6, 19.07, 15, 16.40, 2.36, 69.71, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 7, 18.32, 15, 16.41, 2.09, 70.22, 'Y', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 8, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9081.00', '3.A.3', 'OJ', 9, 0.00, 15, 0.00, NULL, NULL, 'N', '2017-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 5, 19.23, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 6, 65.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 7, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 8, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 10, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 5, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 6, 23.08, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 7, 34.62, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 8, 34.62, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 9, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 10, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.1', 'RW', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 1, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 2, 34.62, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 3, 19.23, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 4, 19.23, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 5, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 6, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 8, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 1, 15.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 2, 15.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 3, 23.08, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 4, 23.08, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 5, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 7, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 8, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9111.00', '3.A.3', 'OJ', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 4, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 5, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 6, 42.28, 26, 10.96, 22.51, 64.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 7, 7.69, 26, 4.18, 2.42, 21.86, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 8, 17.09, 26, 7.84, 6.19, 39.17, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 10, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 11, 26.21, 26, 12.28, 8.77, 56.77, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '2.D.1', 'RL', 12, 6.72, 26, 6.56, 0.83, 38.36, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 2, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 3, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 4, 6.74, 26, 4.08, 1.87, 21.58, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 5, 5.53, 26, 4.21, 1.10, 23.50, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 6, 2.16, 26, 2.17, 0.27, 15.44, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 7, 14.44, 26, 7.70, 4.46, 37.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 8, 38.97, 26, 9.75, 21.54, 59.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 9, 6.76, 26, 3.36, 2.36, 17.84, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 10, 5.53, 26, 5.62, 0.63, 34.93, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.1', 'RW', 11, 19.86, 26, 10.45, 6.03, 48.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 1, 23.04, 26, 11.75, 7.10, 53.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 2, 5.84, 26, 3.51, 1.64, 18.73, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 3, 32.21, 26, 9.81, 15.84, 54.52, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 4, 11.07, 26, 8.41, 2.09, 41.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 5, 17.61, 26, 8.86, 5.73, 42.90, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 6, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 7, 5.64, 26, 4.55, 1.02, 25.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 8, 4.59, 26, 4.97, 0.46, 33.20, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.2', 'PT', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 1, 8.88, 26, 7.65, 1.37, 40.60, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 2, 2.16, 26, 2.21, 0.26, 15.96, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 3, 33.18, 26, 9.90, 16.53, 55.46, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 4, 22.05, 26, 10.25, 7.64, 49.14, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 5, 22.57, 26, 8.58, 9.59, 44.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 6, 3.09, 26, 3.13, 0.37, 21.53, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 7, 8.08, 26, 3.78, 2.99, 20.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 2, 7.51, 33, 6.87, 1.07, 37.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 3, 7.84, 33, 7.16, 1.12, 39.04, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 4, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 5, 9.39, 33, 6.11, 2.34, 30.94, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 6, 55.54, 33, 10.97, 33.56, 75.54, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 7, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 8, 12.22, 33, 7.63, 3.17, 37.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 9, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 10, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '2.D.1', 'RL', 12, 7.50, 33, 8.26, 0.71, 47.79, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 1, 7.47, 34, 7.14, 0.98, 39.73, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 2, 7.14, 34, 6.84, 0.93, 38.55, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 3, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 4, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 5, 0.70, 34, 0.49, 0.17, 2.88, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 6, 22.03, 34, 12.57, 5.99, 55.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 7, 10.09, 34, 4.65, 3.80, 24.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 8, 11.73, 34, 7.51, 2.95, 36.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 9, 21.67, 34, 11.25, 6.70, 51.60, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 10, 16.97, 34, 11.02, 4.00, 50.07, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.1', 'RW', 11, 2.20, 34, 2.17, 0.29, 14.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 1, 14.62, 34, 10.00, 3.25, 46.65, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 2, 43.81, 34, 12.30, 22.00, 68.30, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 3, 16.66, 34, 4.30, 9.63, 27.28, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 4, 22.47, 34, 14.68, 4.96, 61.67, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 5, 2.09, 34, 1.39, 0.53, 7.84, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 6, 0.34, 34, 0.35, 0.04, 2.71, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 7, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 8, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.2', 'PT', 9, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 1, 2.20, 34, 2.17, 0.29, 14.92, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 2, 23.27, 34, 8.43, 10.39, 44.22, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 3, 30.20, 34, 12.10, 11.86, 58.16, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 4, 18.59, 34, 8.21, 7.03, 40.78, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 5, 12.64, 34, 7.37, 3.59, 36.02, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 6, 13.10, 34, 7.73, 3.65, 37.50, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 7, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 8, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.01', '3.A.3', 'OJ', 9, 0.00, 34, 0.00, NULL, NULL, 'N', '2011-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 6, 50.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 8, 50.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '2.D.4.a', 'IM', NULL, 3.82, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 1, 18.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 6, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 7, 18.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 8, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 9, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.1', 'RW', 11, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 1, 40.91, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 2, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 7, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.2', 'PT', 9, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 1, 18.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 6, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 8, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.3', 'OJ', 9, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9121.02', '3.A.4.a', 'IM', NULL, 1.82, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 1, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 2, 62.10, 29, 8.54, 43.79, 77.51, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 3, 6.69, 29, 6.52, 0.84, 37.87, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 4, 11.07, 29, 6.06, 3.41, 30.51, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 5, 6.69, 29, 6.02, 0.99, 34.04, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 6, 13.44, 29, 6.78, 4.50, 33.86, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 1, 27.12, 29, 9.85, 11.82, 50.81, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 2, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 3, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 4, 6.69, 29, 6.00, 0.99, 33.94, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 5, 10.82, 29, 6.18, 3.17, 31.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 6, 12.22, 29, 6.53, 3.85, 32.65, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 7, 7.10, 29, 4.29, 1.98, 22.44, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 8, 18.87, 29, 8.56, 6.89, 42.24, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 9, 3.81, 29, 3.79, 0.47, 24.83, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 10, 10.43, 29, 7.08, 2.41, 35.47, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.1', 'RW', 11, 2.94, 29, 2.14, 0.65, 12.34, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 1, 6.69, 29, 6.52, 0.84, 37.87, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 2, 19.04, 29, 7.21, 8.28, 38.01, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 3, 13.34, 29, 7.27, 4.08, 35.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 4, 26.46, 29, 7.75, 13.73, 44.85, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 5, 13.39, 29, 6.48, 4.69, 32.69, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 6, 4.75, 29, 4.71, 0.59, 29.58, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 7, 6.69, 29, 6.52, 0.84, 37.87, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 8, 9.63, 29, 6.72, 2.15, 34.12, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.2', 'PT', 9, 0.00, 29, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 1, 6.86, 28, 6.69, 0.85, 38.67, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 2, 11.41, 28, 6.71, 3.20, 33.45, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 3, 27.11, 28, 8.62, 13.19, 47.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 4, 18.68, 28, 7.97, 7.26, 40.27, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 5, 17.83, 28, 7.30, 7.24, 37.61, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 6, 1.41, 28, 1.44, 0.17, 10.77, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 7, 1.41, 28, 1.44, 0.17, 10.67, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 8, 15.30, 28, 9.28, 3.99, 43.99, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9131.00', '3.A.3', 'OJ', 9, 0.00, 28, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 6, 55.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 10, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '2.D.4.a', 'IM', NULL, 3.55, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 7, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 8, 35.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 10, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 1, 10.53, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 2, 21.05, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 3, 0.00, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 4, 21.05, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 5, 15.79, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 6, 15.79, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 7, 10.53, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 8, 5.26, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.2', 'PT', 9, 0.00, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 4, 30.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9141.00', '3.A.4.a', 'IM', NULL, 2.05, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 2, 7.24, 27, 7.09, 0.88, 40.61, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 4, 2.19, 27, 2.20, 0.27, 15.69, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 5, 8.15, 27, 6.23, 1.58, 32.91, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 6, 50.36, 27, 11.88, 27.65, 72.93, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 8, 23.93, 27, 9.40, 9.82, 47.63, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 9, 8.12, 27, 6.34, 1.52, 33.64, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 10, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.1', 'RL', 12, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '2.D.4.a', 'IM', NULL, 2.73, 23, 0.30, 2.10, 3.37, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 5, 12.31, 27, 7.47, 3.27, 36.81, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 6, 17.39, 27, 8.04, 6.25, 39.96, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 7, 18.42, 27, 6.64, 8.34, 35.90, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 8, 26.13, 27, 10.47, 10.39, 51.91, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 9, 18.02, 27, 9.76, 5.35, 46.10, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 10, 5.91, 27, 5.76, 0.74, 34.57, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.1', 'RW', 11, 1.82, 27, 1.75, 0.25, 12.14, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 1, 16.12, 27, 8.27, 5.18, 40.31, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 2, 19.72, 27, 8.20, 7.81, 41.59, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 3, 39.94, 27, 12.60, 18.43, 66.18, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 4, 10.49, 27, 6.94, 2.50, 34.87, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 5, 11.25, 27, 7.80, 2.49, 38.68, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 6, 2.48, 27, 2.32, 0.35, 15.43, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.2', 'PT', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 1, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 2, 10.25, 27, 5.87, 2.99, 29.77, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 3, 33.44, 27, 9.72, 16.99, 55.22, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 4, 13.20, 27, 5.36, 5.50, 28.45, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 5, 33.58, 27, 10.91, 15.61, 58.02, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 6, 9.53, 27, 4.62, 3.38, 24.06, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 7, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.3', 'OJ', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9151.00', '3.A.4.a', 'IM', NULL, 2.02, 23, 0.23, 1.55, 2.49, 'N', '2018-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 4, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 5, 16.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 6, 52.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 7, 4.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 8, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '2.D.4.a', 'IM', NULL, 2.92, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 3, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 6, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 7, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 8, 32.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 9, 12.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 10, 12.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.1', 'RW', 11, 4.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 1, 28.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 2, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 4, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 5, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 6, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 7, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 8, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.2', 'PT', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 1, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 2, 16.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 3, 20.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 4, 4.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 5, 24.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 6, 4.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 7, 4.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 8, 8.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.3', 'OJ', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9161.00', '3.A.4.a', 'IM', NULL, 2.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 2, 7.99, 18, 7.61, 0.97, 43.56, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 5, 57.28, 18, 15.01, 26.88, 83.02, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 6, 12.49, 18, 11.53, 1.52, 56.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 7, 9.49, 18, 9.09, 1.11, 49.43, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 10, 12.75, 18, 11.52, 1.62, 56.48, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 11, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '2.D.1', 'RL', 12, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 1, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 2, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 3, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 5, 8.28, 18, 7.62, 1.08, 42.83, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 6, 54.60, 18, 13.64, 27.37, 79.34, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 7, 24.63, 18, 15.80, 5.15, 66.31, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 10, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.1', 'RW', 11, 12.49, 18, 12.49, 1.26, 61.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 1, 20.84, 18, 14.48, 3.97, 62.66, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 2, 16.49, 18, 12.87, 2.68, 58.64, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 3, 12.49, 18, 11.53, 1.52, 56.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 5, 10.72, 18, 8.03, 2.00, 41.35, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 6, 38.67, 18, 14.32, 14.99, 69.27, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 7, 0.80, 18, 0.59, 0.17, 3.70, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.2', 'PT', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 1, 11.35, 18, 11.52, 1.13, 58.92, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 2, 2.15, 18, 1.91, 0.32, 12.97, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 3, 20.48, 18, 12.92, 4.61, 57.86, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 4, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 5, 29.82, 18, 16.62, 7.37, 69.41, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 6, 33.81, 18, 13.90, 12.11, 65.44, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 7, 2.40, 18, 1.93, 0.43, 12.29, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 8, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9171.00', '3.A.3', 'OJ', 9, 0.00, 18, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 6, 70.83, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 6, 25.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 7, 33.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 9, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 2, 37.50, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 3, 29.17, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 6, 8.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 2, 12.50, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 3, 33.33, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 4, 20.83, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.01', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 2, 6.23, 21, 4.04, 1.54, 21.97, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 3, 33.66, 21, 21.03, 6.64, 78.35, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 4, 13.83, 21, 14.62, 1.23, 67.45, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 5, 25.29, 21, 16.61, 5.13, 67.93, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 6, 20.55, 21, 16.78, 2.94, 68.83, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 7, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 8, 0.44, 21, 0.45, 0.05, 3.73, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 11, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '2.D.1', 'RL', 12, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 1, 0.05, 21, 0.05, 0.01, 0.45, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 2, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 3, 13.04, 21, 14.48, 1.03, 68.29, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 4, 0.72, 21, 0.75, 0.08, 6.18, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 5, 2.93, 21, 2.99, 0.34, 21.25, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 6, 5.98, 21, 4.36, 1.25, 24.26, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 7, 41.46, 21, 22.74, 9.12, 83.33, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 8, 30.13, 21, 16.56, 7.71, 69.00, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 9, 0.47, 21, 0.50, 0.05, 4.17, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 10, 5.21, 21, 5.25, 0.60, 33.54, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.1', 'RW', 11, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 1, 18.72, 21, 16.02, 2.50, 67.44, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 2, 23.97, 21, 16.38, 4.61, 67.27, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 3, 40.59, 21, 22.77, 8.70, 83.05, 'Y', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 4, 8.58, 21, 7.31, 1.33, 39.58, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 5, 6.96, 21, 5.16, 1.40, 28.30, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 6, 1.18, 21, 0.93, 0.22, 5.93, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 7, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 8, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.2', 'PT', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 1, 4.48, 21, 4.14, 0.62, 26.08, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 2, 23.62, 21, 16.42, 4.43, 67.38, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 3, 59.53, 21, 15.79, 27.26, 85.24, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 4, 1.11, 21, 0.89, 0.21, 5.73, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 5, 10.36, 21, 7.79, 1.97, 39.95, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 6, 0.90, 21, 0.70, 0.18, 4.42, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 7, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 8, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9179.02', '3.A.3', 'OJ', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2012-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 1, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 2, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 3, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 4, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 5, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 6, 75.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 7, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 8, 14.29, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 9, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 10, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 11, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.1', 'RL', 12, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '2.D.4.a', 'IM', NULL, 2.89, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 1, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 2, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 3, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 4, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 5, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 6, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 7, 32.14, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 8, 32.14, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 9, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 10, 14.29, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.1', 'RW', 11, 7.14, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 1, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 2, 17.86, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 3, 14.29, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 4, 21.43, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 5, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 6, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 7, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 8, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.2', 'PT', 9, 0.00, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 1, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 2, 7.14, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 3, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 4, 21.43, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 5, 14.29, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 6, 17.86, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 7, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 8, 10.71, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.3', 'OJ', 9, 3.57, 28, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.01', '3.A.4.a', 'IM', NULL, 1.74, 27, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 2, 8.93, 24, 5.63, 2.29, 29.09, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 3, 6.72, 24, 6.49, 0.84, 38.04, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 4, 1.27, 24, 1.31, 0.15, 10.11, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 5, 5.33, 24, 4.32, 0.95, 24.87, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 6, 63.38, 24, 11.98, 37.30, 83.43, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 8, 14.21, 24, 7.50, 4.43, 37.16, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 10, 0.17, 24, 0.17, 0.02, 1.43, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '2.D.4.a', 'IM', NULL, 3.27, 24, 0.34, 2.57, 3.98, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 1, 13.44, 24, 9.02, 3.02, 43.59, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 4, 1.27, 24, 1.31, 0.15, 10.11, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 5, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 6, 9.81, 24, 6.60, 2.27, 33.70, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 7, 42.56, 24, 14.25, 18.16, 71.22, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 8, 18.38, 24, 8.01, 6.94, 40.47, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 9, 4.58, 24, 4.52, 0.56, 29.01, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 10, 5.02, 24, 3.83, 1.00, 21.75, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.1', 'RW', 11, 4.94, 24, 3.79, 0.97, 21.64, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 1, 4.41, 24, 3.59, 0.79, 21.17, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 2, 5.08, 24, 4.26, 0.86, 24.93, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 3, 14.06, 24, 12.69, 1.83, 58.97, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 4, 12.05, 24, 7.66, 2.98, 37.94, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 5, 13.74, 24, 7.18, 4.35, 35.80, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 6, 30.86, 24, 10.38, 14.03, 54.98, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 7, 18.53, 24, 9.88, 5.55, 46.82, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.2', 'PT', 9, 1.27, 24, 1.33, 0.14, 10.40, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 2, 8.85, 24, 5.85, 2.12, 30.35, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 3, 27.04, 24, 14.01, 7.86, 61.69, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 4, 20.96, 24, 9.48, 7.50, 46.43, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 5, 13.87, 24, 6.74, 4.77, 34.09, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 6, 22.56, 24, 9.46, 8.68, 47.17, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.3', 'OJ', 9, 6.72, 24, 6.61, 0.81, 38.97, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.02', '3.A.4.a', 'IM', NULL, 2.35, 23, 0.27, 1.78, 2.92, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 6, 54.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '2.D.4.a', 'IM', NULL, 3.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 6, 27.27, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 7, 22.73, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 8, 31.82, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 10, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 2, 28.57, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 5, 14.29, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 6, 14.29, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 7, 4.76, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 2, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 3, 31.82, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 4, 22.73, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 8, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.08', '3.A.4.a', 'IM', NULL, 1.43, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 2, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 3, 10.08, 23, 5.93, 2.81, 30.35, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 4, 6.50, 23, 4.80, 1.33, 26.32, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 5, 9.44, 23, 5.51, 2.66, 28.42, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 6, 52.77, 23, 13.60, 26.48, 77.61, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 7, 3.36, 23, 3.37, 0.40, 23.02, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 8, 17.85, 23, 12.46, 3.60, 55.87, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 10, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 11, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '2.D.1', 'RL', 12, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 2, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 3, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 4, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 5, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 6, 15.42, 23, 12.38, 2.48, 56.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 7, 6.00, 23, 4.41, 1.25, 24.42, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 8, 49.51, 23, 13.69, 23.96, 75.33, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 9, 1.92, 23, 1.95, 0.23, 14.40, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 10, 13.64, 23, 12.48, 1.73, 58.69, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.1', 'RW', 11, 13.50, 23, 6.63, 4.59, 33.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 1, 15.56, 23, 12.49, 2.50, 56.97, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 2, 18.69, 23, 12.62, 3.94, 56.27, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 3, 16.14, 23, 7.22, 5.99, 36.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 4, 10.41, 23, 5.77, 3.12, 29.53, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 5, 17.71, 23, 12.43, 3.54, 55.79, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 6, 15.99, 23, 7.58, 5.57, 38.03, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 7, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 8, 5.50, 23, 4.03, 1.15, 22.52, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.2', 'PT', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 1, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 2, 5.04, 23, 3.69, 1.06, 20.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 3, 20.98, 23, 12.56, 5.23, 56.09, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 4, 33.82, 23, 12.71, 13.60, 62.39, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 5, 27.08, 23, 12.69, 8.93, 58.47, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 6, 7.57, 23, 4.60, 2.05, 24.23, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 7, 1.92, 23, 2.00, 0.22, 14.99, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 8, 3.58, 23, 3.53, 0.44, 23.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.09', '3.A.3', 'OJ', 9, 0.00, 23, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 1, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 2, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 3, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 4, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 5, 18.27, 16, 12.34, 3.70, 56.53, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 6, 66.85, 16, 15.07, 32.12, 89.58, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 7, 2.61, 16, 2.72, 0.27, 20.85, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 8, 12.28, 16, 11.49, 1.42, 57.61, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 10, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 11, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '2.D.1', 'RL', 12, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 1, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 2, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 3, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 4, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 5, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 6, 24.41, 16, 12.38, 7.17, 57.43, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 7, 14.96, 16, 13.34, 1.85, 62.17, 'N', '2016-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 8, 33.56, 16, 11.39, 14.54, 60.01, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 9, 20.15, 16, 11.97, 4.92, 55.20, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 10, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.1', 'RW', 11, 6.92, 16, 5.32, 1.26, 30.17, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 1, 11.34, 16, 7.01, 2.81, 36.11, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 2, 6.14, 16, 5.74, 0.78, 35.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 3, 27.85, 16, 13.29, 8.61, 61.26, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 4, 16.02, 16, 8.41, 4.79, 41.97, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 5, 8.75, 16, 6.84, 1.52, 37.30, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 6, 6.14, 16, 5.74, 0.78, 35.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 7, 2.67, 16, 2.73, 0.29, 20.41, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 8, 21.09, 16, 13.44, 4.57, 59.90, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.2', 'PT', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 1, 6.14, 16, 5.74, 0.78, 35.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 2, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 3, 22.58, 16, 12.73, 5.81, 57.95, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 4, 22.24, 16, 12.05, 6.08, 55.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 5, 16.53, 16, 8.87, 4.79, 43.80, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 6, 17.56, 16, 8.09, 6.07, 41.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 7, 14.96, 16, 13.34, 1.85, 62.17, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 8, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.10', '3.A.3', 'OJ', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 1, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 2, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 3, 8.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 4, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 5, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 6, 68.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 7, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 8, 12.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 9, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 10, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 11, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '2.D.1', 'RL', 12, 0.00, 25, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 5, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 6, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 7, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 8, 29.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 9, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 10, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 2, 29.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 3, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 6, 12.50, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 8, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 2, 20.83, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 4, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 5, 41.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 8, 16.67, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('11-9199.11', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2013-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 1, 1.34, 22, 1.34, 0.16, 10.06, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 2, 37.97, 22, 14.52, 14.52, 68.82, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 3, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 4, 2.56, 22, 1.47, 0.77, 8.20, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 5, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 6, 41.33, 22, 13.34, 18.33, 68.86, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 8, 16.80, 22, 11.45, 3.55, 52.59, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 1, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 2, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 3, 10.30, 22, 9.29, 1.40, 48.17, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 4, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 5, 17.63, 22, 11.02, 4.23, 50.91, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 6, 36.61, 22, 15.46, 12.63, 69.77, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 7, 11.52, 22, 9.57, 1.81, 47.84, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 8, 14.25, 22, 9.63, 3.12, 46.13, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 9, 9.69, 22, 9.26, 1.17, 49.21, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.1', 'RW', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 1, 32.29, 22, 13.79, 11.38, 63.89, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 2, 33.10, 22, 13.62, 12.10, 63.99, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 3, 10.30, 22, 9.51, 1.33, 49.39, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 4, 3.90, 22, 2.66, 0.92, 15.08, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 5, 14.43, 22, 7.58, 4.49, 37.66, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 6, 6.00, 22, 5.57, 0.81, 33.26, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.2', 'PT', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 1, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 2, 31.07, 22, 15.17, 9.37, 66.29, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 3, 34.44, 22, 13.61, 13.04, 64.79, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 4, 18.12, 22, 10.54, 4.81, 49.21, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 5, 2.43, 22, 1.93, 0.46, 11.89, 'N', '2020-08-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 6, 13.94, 22, 7.52, 4.21, 37.36, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1011.00', '3.A.3', 'OJ', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2020-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 1, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 2, 7.60, 20, 6.74, 1.09, 38.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 3, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 4, 7.28, 20, 6.46, 1.05, 36.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 5, 8.29, 20, 7.39, 1.17, 40.89, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 6, 76.83, 20, 11.60, 45.88, 92.84, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 8, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 10, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 11, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '2.D.1', 'RL', 12, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 1, 11.27, 20, 8.66, 2.03, 43.78, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 2, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 3, 10.11, 20, 8.72, 1.49, 45.58, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 4, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 5, 7.60, 20, 6.76, 1.09, 38.11, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 6, 13.89, 20, 9.66, 2.89, 46.67, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 7, 13.91, 20, 8.22, 3.70, 40.46, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 8, 7.97, 20, 6.60, 1.30, 36.32, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 9, 1.48, 20, 1.53, 0.17, 11.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 10, 15.67, 20, 13.72, 2.07, 61.99, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.1', 'RW', 11, 18.09, 20, 10.36, 4.86, 48.83, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 1, 5.18, 20, 5.37, 0.55, 34.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 2, 18.69, 20, 13.56, 3.43, 59.82, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 3, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 4, 21.12, 20, 11.19, 6.16, 52.21, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 5, 22.07, 20, 17.28, 3.34, 69.87, 'Y', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 6, 9.92, 20, 6.93, 2.13, 35.81, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 7, 10.11, 20, 9.47, 1.25, 49.89, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 8, 6.29, 20, 6.43, 0.68, 39.75, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.2', 'PT', 9, 6.62, 20, 6.75, 0.72, 41.07, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 1, 5.18, 20, 5.37, 0.55, 34.95, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 2, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 3, 18.32, 20, 13.62, 3.23, 60.11, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 4, 29.99, 20, 13.57, 9.97, 62.36, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 5, 3.78, 20, 2.87, 0.75, 17.03, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 6, 29.83, 20, 17.02, 7.19, 69.98, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 7, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 8, 12.90, 20, 9.11, 2.64, 44.71, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1021.00', '3.A.3', 'OJ', 9, 0.00, 20, 0.00, NULL, NULL, 'N', '2013-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 1, 13.92, 29, 9.05, 3.33, 43.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 2, 20.30, 29, 13.21, 4.56, 57.56, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 3, 10.30, 29, 9.75, 1.31, 49.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 4, 8.21, 29, 5.99, 1.73, 31.31, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 5, 11.43, 29, 8.46, 2.28, 41.69, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 6, 34.65, 29, 16.27, 10.85, 69.78, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 7, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 8, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 9, 1.19, 29, 1.25, 0.14, 9.52, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 10, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 11, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '2.D.1', 'RL', 12, 0.00, 29, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 1, 15.45, 27, 11.41, 2.95, 52.37, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 2, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 3, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 4, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 5, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 6, 22.47, 27, 14.12, 5.19, 60.53, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 7, 48.58, 27, 17.76, 17.97, 80.30, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 8, 12.79, 27, 9.14, 2.65, 44.16, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 10, 0.70, 27, 0.52, 0.16, 3.13, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.1', 'RW', 11, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 1, 28.19, 27, 18.73, 5.54, 72.44, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 2, 6.02, 27, 4.43, 1.26, 24.25, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 3, 21.74, 27, 14.09, 4.82, 60.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 4, 12.84, 27, 10.74, 2.01, 51.43, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 5, 3.63, 27, 2.33, 0.95, 12.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 6, 17.11, 27, 12.06, 3.47, 54.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 7, 10.48, 27, 8.91, 1.64, 45.17, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 8, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.2', 'PT', 9, 0.00, 27, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 1, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 2, 5.52, 26, 4.93, 0.83, 29.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 3, 17.27, 26, 11.98, 3.58, 54.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 4, 42.07, 26, 19.86, 11.94, 79.56, 'Y', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 5, 21.78, 26, 13.59, 5.11, 59.00, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 6, 12.96, 26, 10.14, 2.28, 48.67, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 7, 0.41, 26, 0.43, 0.05, 3.55, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 8, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1022.00', '3.A.3', 'OJ', 9, 0.00, 26, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 6, 78.26, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 7, 8.70, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '2.D.4.a', 'IM', NULL, 3.50, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 1, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 7, 27.27, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 8, 45.45, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 9, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 1, 27.27, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 2, 22.73, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 2, 27.27, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 3, 18.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 4, 18.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 6, 9.09, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 7, 4.55, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1023.00', '3.A.4.a', 'IM', NULL, 1.67, 21, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 1, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 2, 23.88, 16, 11.58, 7.47, 54.96, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 3, 28.84, 16, 12.17, 10.27, 58.94, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 4, 30.60, 16, 16.29, 7.92, 69.34, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 5, 15.21, 16, 11.85, 2.47, 55.97, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 6, 1.47, 16, 1.61, 0.14, 13.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 7, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 8, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 10, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 11, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '2.D.1', 'RL', 12, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 1, 15.94, 16, 14.70, 1.80, 66.28, 'Y', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 2, 0.74, 16, 0.81, 0.07, 7.23, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 3, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 4, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 5, 0.74, 16, 0.80, 0.07, 7.04, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 6, 15.39, 16, 11.38, 2.75, 53.95, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 7, 36.05, 16, 18.33, 9.38, 75.43, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 8, 30.41, 16, 23.70, 3.86, 82.62, 'Y', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 9, 0.74, 16, 0.90, 0.05, 9.36, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 10, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.1', 'RW', 11, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 1, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 2, 66.46, 16, 17.10, 27.86, 91.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 3, 1.47, 16, 1.61, 0.14, 13.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 4, 28.39, 16, 16.62, 6.49, 69.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 5, 1.47, 16, 1.22, 0.25, 8.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 6, 2.21, 16, 1.89, 0.35, 12.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 7, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 8, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.2', 'PT', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 1, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 2, 50.52, 16, 12.95, 25.28, 75.50, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 3, 17.41, 16, 11.90, 3.49, 55.14, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 4, 28.39, 16, 16.62, 6.49, 69.37, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 5, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 6, 3.68, 16, 3.08, 0.59, 19.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 7, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 8, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1032.00', '3.A.3', 'OJ', 9, 0.00, 16, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 5, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 6, 85.71, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 7, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 8, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '2.D.1', 'RL', 12, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 1, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 7, 33.33, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 8, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 9, 9.52, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 10, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.1', 'RW', 11, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 1, 14.29, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 2, 14.29, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 3, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 4, 4.76, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 6, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 7, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.2', 'PT', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 3, 23.81, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 5, 38.10, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 7, 19.05, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 8, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.01', '3.A.3', 'OJ', 9, 0.00, 21, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 1, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 2, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 3, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 4, 14.07, 33, 9.40, 3.25, 44.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 5, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 6, 65.76, 33, 10.94, 41.65, 83.79, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 7, 4.44, 33, 3.49, 0.86, 19.89, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 8, 11.87, 33, 5.77, 4.20, 29.30, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 9, 1.09, 33, 1.11, 0.14, 8.19, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 10, 2.77, 33, 2.70, 0.37, 18.05, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 11, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '2.D.1', 'RL', 12, 0.00, 33, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 1, 6.78, 32, 7.01, 0.75, 41.12, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 2, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 3, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 4, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 5, 7.92, 32, 7.08, 1.18, 38.36, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 6, 8.44, 32, 4.80, 2.53, 24.65, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 7, 43.94, 32, 14.91, 18.57, 72.92, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 8, 20.26, 32, 7.58, 8.89, 39.81, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 9, 3.59, 32, 3.76, 0.41, 25.38, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 10, 7.06, 32, 4.21, 2.01, 21.97, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.1', 'RW', 11, 2.01, 32, 2.04, 0.25, 14.44, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 1, 17.27, 32, 7.08, 7.07, 36.45, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 2, 15.37, 32, 9.34, 4.03, 43.99, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 3, 21.73, 32, 8.95, 8.66, 44.83, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 4, 7.16, 32, 4.00, 2.21, 20.84, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 5, 10.64, 32, 5.05, 3.87, 26.04, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 6, 16.09, 32, 7.74, 5.62, 38.19, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 7, 2.49, 32, 2.51, 0.31, 17.32, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 8, 9.24, 32, 5.18, 2.81, 26.42, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.2', 'PT', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 1, 5.61, 32, 4.37, 1.09, 24.23, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 2, 20.21, 32, 14.03, 4.12, 59.90, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 3, 12.20, 32, 8.07, 2.90, 39.24, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 4, 25.96, 32, 10.48, 10.35, 51.59, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 5, 14.23, 32, 5.69, 6.03, 30.03, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 6, 8.56, 32, 5.49, 2.20, 28.10, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 7, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 8, 13.22, 32, 5.79, 5.16, 29.91, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.03', '3.A.3', 'OJ', 9, 0.00, 32, 0.00, NULL, NULL, 'N', '2015-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 2, 9.44, 17, 9.28, 1.03, 51.00, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 3, 16.22, 17, 8.53, 4.87, 42.29, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 4, 10.32, 17, 7.78, 1.90, 40.59, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 5, 24.68, 17, 4.51, 16.38, 35.41, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 6, 39.34, 17, 13.19, 16.73, 67.68, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 7, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 8, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 10, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 11, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '2.D.1', 'RL', 12, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 1, 11.13, 17, 9.73, 1.53, 50.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 4, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 5, 38.50, 17, 8.40, 22.79, 57.04, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 6, 0.94, 17, 1.03, 0.09, 8.92, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 7, 16.08, 17, 10.34, 3.64, 49.30, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 8, 21.67, 17, 15.47, 3.85, 65.65, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 9, 10.32, 17, 7.78, 1.90, 40.59, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 10, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.1', 'RW', 11, 1.38, 17, 1.22, 0.21, 8.54, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 1, 9.00, 17, 9.21, 0.90, 51.75, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 2, 3.59, 17, 3.12, 0.55, 20.13, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 3, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 4, 32.30, 17, 5.85, 21.30, 45.67, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 5, 43.33, 17, 9.13, 25.80, 62.70, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 6, 1.46, 17, 1.34, 0.21, 9.62, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 7, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 8, 10.32, 17, 7.78, 1.90, 40.59, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.2', 'PT', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 1, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 2, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 3, 13.03, 17, 10.12, 2.21, 49.89, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 4, 21.17, 17, 9.16, 7.74, 46.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 5, 44.35, 17, 9.08, 26.76, 63.48, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 6, 11.13, 17, 9.73, 1.53, 50.22, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 7, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 8, 10.32, 17, 7.78, 1.90, 40.59, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.04', '3.A.3', 'OJ', 9, 0.00, 17, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 1, 0.00, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 2, 16.67, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 3, 16.67, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 4, 5.56, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 5, 16.67, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 6, 22.22, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 7, 5.56, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 8, 0.00, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 9, 0.00, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 10, 0.00, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 11, 5.56, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.1', 'RL', 12, 11.11, 18, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '2.D.4.a', 'IM', NULL, 4.25, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 1, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 6, 40.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 7, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 1, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 3, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 4, 40.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.06', '3.A.4.a', 'IM', NULL, 2.90, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 6, 80.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.1', 'RL', 12, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '2.D.4.a', 'IM', NULL, 2.35, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 7, 55.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 1, 15.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 2, 40.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 4, 30.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.07', '3.A.4.a', 'IM', NULL, 1.58, 19, NULL, NULL, NULL, NULL, '2019-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 2, 45.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 1, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 6, 30.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 7, 35.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.1', 'RW', 11, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 1, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 2, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 4, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.2', 'PT', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 2, 10.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1041.08', '3.A.3', 'OJ', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 2, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 5, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 6, 63.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 8, 18.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 1, 18.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 6, 22.73, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 8, 13.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 9, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 10, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.1', 'RW', 11, 18.18, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 1, 31.82, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 2, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 7, 13.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 8, 13.64, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.2', 'PT', 9, 4.55, 22, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 1, 4.76, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 2, 4.76, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 4, 9.52, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 5, 23.81, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 6, 19.05, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 7, 19.05, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 8, 14.29, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1051.00', '3.A.3', 'OJ', 9, 4.76, 21, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 1, 0.00, 41, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 2, 13.52, 41, 7.11, 4.37, 34.84, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 3, 1.31, 41, 1.35, 0.16, 9.88, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 4, 4.82, 41, 3.20, 1.22, 17.17, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 5, 7.16, 41, 4.27, 2.06, 22.03, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 6, 46.59, 41, 14.83, 20.73, 74.42, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 7, 1.69, 41, 1.74, 0.21, 12.51, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 8, 24.91, 41, 19.40, 3.92, 72.96, 'Y', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 9, 0.00, 41, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 10, 0.00, 41, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 11, 0.00, 41, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.1', 'RL', 12, 0.00, 41, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '2.D.4.a', 'IM', NULL, 1.93, 40, 0.11, 1.71, 2.15, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 1, 1.62, 40, 1.67, 0.20, 12.13, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 2, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 3, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 4, 2.68, 40, 2.69, 0.34, 18.13, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 5, 1.96, 40, 1.81, 0.30, 11.81, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 6, 30.02, 40, 11.31, 12.61, 56.03, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 7, 7.77, 40, 3.89, 2.73, 20.18, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 8, 50.88, 40, 15.58, 22.69, 78.51, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 9, 4.60, 40, 3.26, 1.06, 17.80, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 10, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.1', 'RW', 11, 0.49, 40, 0.51, 0.06, 3.98, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 1, 32.29, 40, 18.17, 8.16, 71.92, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 2, 8.32, 40, 4.51, 2.67, 23.06, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 3, 13.99, 40, 7.56, 4.36, 36.71, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 4, 8.00, 40, 4.37, 2.55, 22.42, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 5, 7.60, 40, 4.10, 2.47, 21.13, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 6, 20.10, 40, 9.28, 7.25, 44.74, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 7, 9.71, 40, 9.18, 1.27, 47.23, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 8, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.2', 'PT', 9, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 1, 1.36, 40, 1.41, 0.17, 10.35, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 2, 13.78, 40, 6.43, 5.08, 32.34, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 3, 11.89, 40, 7.12, 3.30, 34.78, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 4, 0.73, 40, 0.59, 0.14, 3.67, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 5, 50.13, 40, 15.60, 22.15, 78.02, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 6, 8.63, 40, 4.62, 2.81, 23.59, 'N', '2019-08-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 7, 12.98, 40, 9.55, 2.62, 45.21, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 8, 0.49, 40, 0.51, 0.06, 3.98, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.3', 'OJ', 9, 0.00, 40, 0.00, NULL, NULL, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1071.00', '3.A.4.a', 'IM', NULL, 1.91, 39, 0.32, 1.26, 2.55, 'N', '2019-08-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 1, 48.00, 13, 21.88, 12.03, 86.17, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 2, 42.83, 13, 22.34, 9.30, 84.55, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 4, 8.90, 13, 9.13, 0.83, 53.18, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 5, 0.14, 13, 0.16, 0.01, 1.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 6, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '2.D.1', 'RL', 12, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 1, 18.06, 13, 16.64, 1.87, 71.86, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 2, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 3, 1.38, 13, 1.27, 0.18, 9.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 4, 3.83, 13, 4.04, 0.36, 30.31, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 5, 24.37, 13, 20.45, 2.79, 78.32, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 6, 33.54, 13, 21.23, 5.96, 80.08, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 7, 18.68, 13, 16.73, 2.04, 71.67, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 8, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 10, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.1', 'RW', 11, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 1, 46.65, 13, 22.21, 11.12, 85.94, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 2, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 3, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 4, 1.10, 13, 1.19, 0.10, 10.78, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 6, 18.70, 13, 16.72, 2.05, 71.63, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 7, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.2', 'PT', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 1, 21.89, 13, 17.05, 3.09, 71.10, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 2, 1.38, 13, 1.27, 0.18, 9.68, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 3, 24.63, 13, 20.38, 2.90, 78.13, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 4, 0.14, 13, 0.15, 0.01, 1.47, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 5, 33.41, 13, 21.18, 5.93, 79.97, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 6, 0.14, 13, 0.16, 0.01, 1.72, 'N', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 7, 18.42, 13, 16.70, 1.97, 71.78, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 8, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1074.00', '3.A.3', 'OJ', 9, 0.00, 13, 0.00, NULL, NULL, 'Y', '2008-06-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 6, 30.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 7, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 8, 25.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 10, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 7, 35.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 8, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 9, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 10, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.1', 'RW', 11, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 3, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 3, 25.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 5, 30.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1075.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2015-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 3, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 4, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 6, 75.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 11, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '2.D.1', 'RL', 12, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 1, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 6, 20.83, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 7, 25.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 8, 33.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 9, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 1, 16.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 2, 25.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 3, 16.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 4, 12.50, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 5, 16.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 7, 8.33, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 1, 4.17, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 2, 16.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 3, 37.50, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 4, 12.50, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 5, 12.50, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 6, 16.67, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 7, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.00', '3.A.3', 'OJ', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 5, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 6, 75.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 10, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '2.D.4.a', 'IM', NULL, 2.30, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 7, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 8, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 9, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 10, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.1', 'RW', 11, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 1, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 2, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 3, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 6, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 8, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 1, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 3, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 4, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 5, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 6, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.01', '3.A.4.a', 'IM', NULL, 1.60, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 4, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 5, 22.73, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 6, 63.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 8, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 9, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '2.D.4.a', 'IM', NULL, 2.36, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 1, 0.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 2, 0.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 3, 0.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 4, 0.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 5, 4.76, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 6, 9.52, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 7, 28.57, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 8, 38.10, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 9, 9.52, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 10, 0.00, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.1', 'RW', 11, 9.52, 21, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 2, 36.36, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 3, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 6, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 8, 4.55, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 1, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 2, 13.64, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 3, 22.73, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 4, 27.27, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 5, 18.18, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 6, 9.09, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1081.02', '3.A.4.a', 'IM', NULL, 2.00, 22, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 5, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 6, 38.46, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 8, 46.15, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 9, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 10, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 11, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '2.D.1', 'RL', 12, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 1, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 2, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 3, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 4, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 5, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 6, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 7, 23.08, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 8, 42.31, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 9, 7.69, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 10, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.1', 'RW', 11, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 1, 15.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 2, 7.69, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 3, 23.08, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 4, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 5, 15.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 6, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 7, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 8, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.2', 'PT', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 1, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 2, 3.85, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 3, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 4, 15.38, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 5, 26.92, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 6, 7.69, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 7, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 8, 11.54, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1111.00', '3.A.3', 'OJ', 9, 0.00, 26, NULL, NULL, NULL, NULL, '2016-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 2, 7.85, 24, 6.88, 1.18, 37.87, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 3, 6.64, 24, 6.58, 0.78, 39.00, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 4, 37.22, 24, 19.34, 9.67, 76.66, 'Y', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 5, 7.49, 24, 6.80, 1.05, 38.17, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 6, 40.80, 24, 15.16, 15.83, 71.63, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 7, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 8, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 10, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 11, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '2.D.1', 'RL', 12, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 1, 1.22, 24, 1.28, 0.14, 10.02, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 2, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 3, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 4, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 5, 4.57, 24, 4.67, 0.52, 30.46, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 6, 51.71, 24, 16.98, 20.78, 81.38, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 7, 13.86, 24, 6.38, 5.06, 32.70, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 8, 16.49, 24, 11.23, 3.52, 51.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 9, 5.43, 24, 3.46, 1.40, 18.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 10, 4.57, 24, 4.67, 0.52, 30.46, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.1', 'RW', 11, 2.15, 24, 2.21, 0.25, 16.19, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 1, 35.17, 24, 20.39, 7.86, 77.53, 'Y', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 2, 13.42, 24, 7.93, 3.64, 38.89, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 3, 9.72, 24, 6.03, 2.53, 30.85, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 4, 4.32, 24, 4.03, 0.60, 25.32, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 5, 9.81, 24, 5.24, 3.09, 27.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 6, 8.79, 24, 6.98, 1.57, 36.86, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 7, 11.07, 24, 10.60, 1.32, 53.57, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 8, 7.70, 24, 5.45, 1.68, 28.98, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.2', 'PT', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 1, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 2, 3.63, 24, 2.78, 0.72, 16.29, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 3, 16.69, 24, 8.91, 5.05, 42.99, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 4, 9.28, 24, 5.90, 2.34, 30.38, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 5, 21.03, 24, 10.15, 7.00, 48.51, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 6, 37.33, 24, 19.63, 9.50, 77.17, 'Y', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 7, 11.07, 24, 10.60, 1.32, 53.57, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 8, 0.98, 24, 1.03, 0.11, 8.21, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1121.00', '3.A.3', 'OJ', 9, 0.00, 24, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 1, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 2, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 4, 9.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 5, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 6, 78.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 7, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 8, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 9, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 10, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 11, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '2.D.1', 'RL', 12, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 1, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 2, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 3, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 4, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 5, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 6, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 7, 34.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 8, 21.88, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 10, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.1', 'RW', 11, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 1, 40.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 2, 28.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 3, 15.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 4, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 5, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 6, 3.12, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 7, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.2', 'PT', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 1, 21.88, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 2, 34.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 3, 12.50, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 4, 9.38, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 5, 15.62, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 6, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 7, 6.25, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 8, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1131.00', '3.A.3', 'OJ', 9, 0.00, 32, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 6, 69.57, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '2.D.4.a', 'IM', NULL, 3.26, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 1, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 2, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 3, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 4, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 5, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 6, 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 7, 33.33, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 8, 37.50, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 9, 20.83, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 10, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.1', 'RW', 11, 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 1, 41.67, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 2, 8.33, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 3, 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 4, 12.50, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 5, 29.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 6, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 7, 4.17, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 8, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.2', 'PT', 9, 0.00, 24, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 1, 17.39, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 2, 8.70, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 5, 30.43, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1141.00', '3.A.4.a', 'IM', NULL, 1.83, 23, NULL, NULL, NULL, NULL, '2017-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 1, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 2, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 3, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 4, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 5, 5.56, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 6, 58.33, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 7, 11.11, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 8, 16.67, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 9, 2.78, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 10, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 11, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '2.D.1', 'RL', 12, 0.00, 36, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 1, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 2, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 3, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 4, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 5, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 6, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 7, 37.14, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 8, 37.14, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 9, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 10, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.1', 'RW', 11, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 1, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 2, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 3, 22.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 4, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 5, 20.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 6, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 7, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 8, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.2', 'PT', 9, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 1, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 2, 14.29, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 3, 25.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 4, 22.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 5, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 6, 11.43, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 7, 2.86, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 8, 5.71, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1151.00', '3.A.3', 'OJ', 9, 0.00, 35, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 6, 56.52, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 8, 39.13, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '2.D.4.a', 'IM', NULL, 2.13, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 1, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 6, 17.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 7, 26.09, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 8, 34.78, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 1, 47.83, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 2, 17.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 3, 17.39, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 2, 13.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 3, 21.74, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 4, 13.04, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 5, 21.74, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 6, 8.70, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 8, 4.35, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.00', '3.A.4.a', 'IM', NULL, 1.91, 23, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 2, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 6, 78.26, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 6, 39.13, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 7, 30.43, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 8, 17.39, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 9, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 1, 26.09, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 3, 21.74, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 4, 17.39, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 7, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 2, 13.04, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 3, 26.09, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 5, 26.09, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1161.01', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2014-07-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 4, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 5, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 6, 68.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 7, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 10, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 11, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.1', 'RL', 12, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '2.D.4.a', 'IM', NULL, 3.73, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 1, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 2, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 3, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 4, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 5, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 6, 18.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 7, 22.73, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 8, 36.36, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 9, 18.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 10, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.1', 'RW', 11, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 1, 27.27, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 2, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 3, 13.64, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 4, 13.64, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 5, 13.64, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 6, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 7, 18.18, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 8, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.2', 'PT', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 1, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 2, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 3, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 4, 22.73, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 5, 40.91, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 6, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 7, 9.09, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 8, 4.55, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.3', 'OJ', 9, 0.00, 22, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.04', '3.A.4.a', 'IM', NULL, 2.05, 21, NULL, NULL, NULL, NULL, '2018-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 1, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 4, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 6, 52.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 8, 39.13, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '2.D.4.a', 'IM', NULL, 3.22, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 6, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 7, 52.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 8, 17.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 9, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 10, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.1', 'RW', 11, 8.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 1, 30.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 2, 30.43, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 4, 8.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 5, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 6, 13.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 7, 8.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.2', 'PT', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 1, 13.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 2, 21.74, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 3, 8.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 4, 21.74, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 5, 13.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 6, 17.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 7, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.3', 'OJ', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.05', '3.A.4.a', 'IM', NULL, 2.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 1, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 2, 32.67, 22, 13.20, 12.23, 62.82, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 3, 12.12, 22, 7.17, 3.29, 35.87, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 4, 8.71, 22, 6.12, 1.89, 32.12, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 5, 5.22, 22, 3.80, 1.10, 21.39, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 6, 41.29, 22, 11.31, 21.04, 64.98, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 7, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 8, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 9, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 10, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 11, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '2.D.1', 'RL', 12, 0.00, 22, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 1, 16.67, 21, 8.55, 5.25, 41.95, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 2, 2.68, 21, 2.74, 0.31, 19.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 3, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 4, 7.00, 21, 5.14, 1.43, 28.08, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 5, 11.45, 21, 6.91, 3.02, 34.91, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 6, 16.85, 21, 8.46, 5.44, 41.66, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 7, 26.10, 21, 14.37, 6.95, 62.55, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 8, 8.24, 21, 5.69, 1.83, 30.15, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 9, 5.51, 21, 5.47, 0.65, 34.30, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 10, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.1', 'RW', 11, 5.49, 21, 4.00, 1.15, 22.47, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 1, 16.61, 21, 8.54, 5.22, 41.88, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 2, 17.39, 21, 8.70, 5.61, 42.68, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 3, 18.88, 21, 8.64, 6.70, 43.03, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 4, 26.49, 21, 14.14, 7.35, 62.10, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 5, 12.38, 21, 7.26, 3.38, 36.34, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 6, 2.68, 21, 2.74, 0.31, 19.76, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 7, 5.56, 21, 5.19, 0.74, 31.63, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 8, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.2', 'PT', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 1, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 2, 25.63, 21, 9.53, 10.82, 49.45, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 3, 19.02, 21, 9.34, 6.22, 45.42, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 4, 40.29, 21, 12.97, 17.97, 67.51, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 5, 7.43, 21, 5.44, 1.52, 29.48, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 6, 7.63, 21, 5.64, 1.53, 30.49, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 7, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 8, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-1199.06', '3.A.3', 'OJ', 9, 0.00, 21, 0.00, NULL, NULL, 'N', '2014-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 1, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 2, 10.06, 35, 8.38, 1.68, 42.35, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 3, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 4, 3.28, 35, 2.67, 0.61, 15.77, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 5, 10.63, 35, 6.20, 3.06, 30.93, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 6, 63.99, 35, 13.21, 35.66, 85.07, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 7, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 8, 9.37, 35, 6.15, 2.32, 31.05, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 9, 2.67, 35, 2.77, 0.31, 19.33, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 10, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 11, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '2.D.1', 'RL', 12, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 1, 2.20, 35, 1.83, 0.40, 11.26, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 2, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 3, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 4, 2.34, 35, 2.38, 0.29, 16.57, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 5, 8.12, 35, 6.08, 1.66, 31.64, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 6, 19.76, 35, 6.22, 9.99, 35.35, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 7, 42.37, 35, 13.96, 18.69, 70.15, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 8, 12.63, 35, 6.30, 4.34, 31.55, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 9, 3.32, 35, 2.94, 0.53, 18.14, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 10, 7.47, 35, 6.16, 1.30, 33.08, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.1', 'RW', 11, 1.79, 35, 1.68, 0.26, 11.24, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 1, 16.43, 35, 7.42, 6.15, 37.09, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 2, 17.67, 35, 9.24, 5.57, 43.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 3, 11.16, 35, 6.01, 3.53, 30.12, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 4, 6.26, 35, 4.29, 1.49, 22.78, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 5, 19.65, 35, 7.41, 8.61, 38.82, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 6, 7.56, 35, 6.00, 1.41, 31.88, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 7, 18.61, 35, 7.58, 7.63, 38.75, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 8, 2.67, 35, 2.77, 0.31, 19.33, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.2', 'PT', 9, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 1, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 2, 0.34, 35, 0.36, 0.04, 2.99, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 3, 19.20, 35, 11.95, 4.74, 53.19, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 4, 3.87, 35, 2.32, 1.12, 12.52, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 5, 52.91, 35, 7.45, 37.95, 67.36, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 6, 5.15, 35, 3.44, 1.28, 18.52, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 7, 15.57, 35, 7.09, 5.81, 35.56, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 8, 2.96, 35, 2.81, 0.41, 18.28, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2031.00', '3.A.3', 'OJ', 9, 0.00, 35, 0.00, NULL, NULL, 'N', '2016-07-01', 'Incumbent');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 1, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 5, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 6, 95.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 8, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.1', 'RL', 12, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '2.D.4.a', 'IM', NULL, 2.05, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 1, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 2, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 3, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 4, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 6, 30.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 7, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 8, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 10, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.1', 'RW', 11, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 1, 30.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 2, 20.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 3, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 4, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
GO
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 5, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 6, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 7, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.2', 'PT', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 1, 10.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 2, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 3, 35.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 4, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 5, 15.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 6, 25.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 7, 5.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 8, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.3', 'OJ', 9, 0.00, 20, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2041.00', '3.A.4.a', 'IM', NULL, 1.79, 19, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 1, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 3, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 5, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 6, 52.17, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 7, 34.78, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 8, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 10, 4.35, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.1', 'RL', 12, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '2.D.4.a', 'IM', NULL, 4.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 1, 17.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 2, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 3, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 4, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 5, 8.70, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 6, 13.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 7, 39.13, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 8, 21.74, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 9, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 10, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.1', 'RW', 11, 0.00, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 1, 17.39, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, element_id, scale_id, category, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, date_updated, domain_source) VALUES ('13-2052.00', '3.A.2', 'PT', 2, 13.04, 23, NULL, NULL, NULL, NULL, '2020-08-01', 'Occupational Expert');
INSERT INTO education_training_experience (onetsoc_code, el