CREATE TABLE knowledge (
  onetsoc_code CHARACTER(10) NOT NULL,
  element_id CHARACTER VARYING(20) NOT NULL,
  scale_id CHARACTER VARYING(3) NOT NULL,
  data_value DECIMAL(5,2) NOT NULL,
  n DECIMAL(4,0),
  standard_error DECIMAL(5,2),
  lower_ci_bound DECIMAL(5,2),
  upper_ci_bound DECIMAL(5,2),
  recommend_suppress CHARACTER(1),
  not_relevant CHARACTER(1),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code),
  FOREIGN KEY (element_id) REFERENCES content_model_reference(element_id),
  FOREIGN KEY (scale_id) REFERENCES scales_reference(scale_id));

INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'IM', 4.75, 27, 0.09, 4.56, 4.94, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.a', 'LV', 6.23, 27, 0.17, 5.88, 6.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'IM', 2.66, 27, 0.22, 2.21, 3.11, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.b', 'LV', 3.50, 27, 0.41, 2.66, 4.34, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'IM', 3.70, 27, 0.28, 3.11, 4.28, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.c', 'LV', 4.36, 27, 0.34, 3.67, 5.06, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'IM', 3.23, 27, 0.49, 2.21, 4.25, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.d', 'LV', 3.90, 27, 0.61, 2.65, 5.16, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'IM', 4.09, 27, 0.33, 3.40, 4.78, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.e', 'LV', 5.55, 27, 0.44, 4.65, 6.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'IM', 4.10, 27, 0.29, 3.51, 4.69, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.1.f', 'LV', 5.02, 27, 0.37, 4.26, 5.77, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'IM', 2.63, 27, 0.44, 1.73, 3.53, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.a', 'LV', 2.92, 27, 0.68, 1.54, 4.31, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'IM', 1.14, 27, 0.08, 1.00, 1.31, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.2.b', 'LV', 0.29, 27, 0.19, 0.00, 0.68, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'IM', 2.23, 26, 0.29, 1.62, 2.83, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.a', 'LV', 2.54, 26, 0.62, 1.25, 3.82, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'IM', 1.75, 26, 0.18, 1.37, 2.13, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.b', 'LV', 1.59, 26, 0.36, 0.85, 2.33, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'IM', 2.05, 26, 0.25, 1.54, 2.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.c', 'LV', 2.04, 26, 0.40, 1.22, 2.86, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'IM', 2.11, 26, 0.30, 1.48, 2.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.d', 'LV', 2.00, 26, 0.44, 1.11, 2.90, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'IM', 1.67, 27, 0.23, 1.20, 2.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.3.e', 'LV', 1.05, 27, 0.35, 0.33, 1.76, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'IM', 3.40, 27, 0.22, 2.95, 3.85, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.a', 'LV', 4.23, 27, 0.30, 3.60, 4.85, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'IM', 1.23, 27, 0.14, 1.00, 1.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.b', 'LV', 0.41, 27, 0.25, 0.00, 0.91, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'IM', 1.43, 27, 0.15, 1.12, 1.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.c', 'LV', 0.95, 27, 0.30, 0.33, 1.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'IM', 1.34, 27, 0.19, 1.00, 1.74, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.d', 'LV', 0.56, 27, 0.30, 0.00, 1.16, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'IM', 3.10, 27, 0.22, 2.64, 3.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.e', 'LV', 3.94, 27, 0.31, 3.31, 4.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'IM', 2.61, 27, 0.32, 1.96, 3.26, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.f', 'LV', 2.99, 27, 0.59, 1.78, 4.21, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'IM', 1.59, 27, 0.21, 1.17, 2.01, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.4.g', 'LV', 1.29, 27, 0.41, 0.44, 2.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'IM', 1.35, 27, 0.14, 1.07, 1.63, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.a', 'LV', 0.73, 27, 0.27, 0.17, 1.30, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'IM', 2.00, 27, 0.18, 1.63, 2.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.5.b', 'LV', 2.50, 27, 0.41, 1.66, 3.34, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'IM', 3.24, 27, 0.40, 2.41, 4.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.6', 'LV', 4.45, 27, 0.59, 3.23, 5.66, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'IM', 4.07, 27, 0.22, 3.62, 4.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.a', 'LV', 4.56, 27, 0.40, 3.74, 5.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'IM', 1.56, 27, 0.32, 1.00, 2.23, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.b', 'LV', 0.78, 27, 0.42, 0.00, 1.65, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'IM', 1.43, 27, 0.24, 1.00, 1.93, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.c', 'LV', 0.87, 27, 0.55, 0.00, 2.00, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'IM', 1.48, 27, 0.24, 1.00, 1.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.d', 'LV', 1.09, 27, 0.62, 0.00, 2.36, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'IM', 1.70, 27, 0.16, 1.37, 2.03, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.7.e', 'LV', 1.82, 27, 0.36, 1.08, 2.56, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'IM', 3.30, 27, 0.32, 2.64, 3.97, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.a', 'LV', 3.61, 27, 0.50, 2.59, 4.63, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'IM', 3.92, 27, 0.26, 3.38, 4.47, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.8.b', 'LV', 4.00, 27, 0.35, 3.27, 4.72, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'IM', 1.76, 27, 0.21, 1.32, 2.19, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.a', 'LV', 1.59, 27, 0.39, 0.79, 2.39, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'IM', 2.70, 27, 0.19, 2.32, 3.08, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.9.b', 'LV', 3.35, 27, 0.35, 2.63, 4.06, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'IM', 2.21, 27, 0.49, 1.21, 3.21, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.00', '2.C.10', 'LV', 1.91, 27, 0.67, 0.54, 3.28, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.a', 'IM', 3.85, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.a', 'LV', 4.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.b', 'IM', 2.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.b', 'LV', 3.64, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.c', 'IM', 2.96, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.c', 'LV', 3.60, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.d', 'IM', 3.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.d', 'LV', 4.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.e', 'IM', 3.62, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.e', 'LV', 4.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.f', 'IM', 2.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.1.f', 'LV', 4.08, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.a', 'IM', 2.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.a', 'LV', 2.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.b', 'IM', 1.64, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.2.b', 'LV', 1.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.a', 'IM', 2.65, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.a', 'LV', 3.68, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.b', 'IM', 3.35, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.b', 'LV', 4.20, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.c', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.c', 'LV', 4.80, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.d', 'IM', 3.69, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.d', 'LV', 4.32, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.e', 'IM', 2.64, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.3.e', 'LV', 2.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.a', 'IM', 3.12, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.a', 'LV', 4.15, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.b', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.b', 'LV', 2.96, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.c', 'IM', 2.36, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.c', 'LV', 3.04, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.d', 'IM', 2.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.d', 'LV', 3.08, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.e', 'IM', 2.88, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.e', 'LV', 3.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.f', 'IM', 2.38, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.f', 'LV', 3.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.g', 'IM', 2.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.4.g', 'LV', 3.81, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.a', 'IM', 1.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.a', 'LV', 0.54, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.b', 'IM', 1.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.5.b', 'LV', 0.54, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.6', 'IM', 3.48, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.6', 'LV', 5.19, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.a', 'IM', 3.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.a', 'LV', 4.48, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.b', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.b', 'LV', 0.88, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.c', 'IM', 1.38, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.c', 'LV', 0.96, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.d', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.d', 'LV', 1.88, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.e', 'IM', 1.85, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.7.e', 'LV', 2.42, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.a', 'IM', 2.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.a', 'LV', 3.38, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.b', 'IM', 2.88, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.8.b', 'LV', 3.08, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.a', 'IM', 1.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.a', 'LV', 0.81, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.b', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.9.b', 'LV', 2.92, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.10', 'IM', 2.42, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1011.03', '2.C.10', 'LV', 2.48, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'IM', 4.35, 55, 0.13, 4.09, 4.60, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.a', 'LV', 5.21, 54, 0.20, 4.81, 5.61, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'IM', 3.51, 55, 0.18, 3.14, 3.88, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.b', 'LV', 3.70, 54, 0.37, 2.96, 4.44, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'IM', 3.47, 55, 0.34, 2.79, 4.14, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.c', 'LV', 3.84, 54, 0.50, 2.84, 4.83, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'IM', 3.47, 55, 0.29, 2.89, 4.04, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.d', 'LV', 4.05, 54, 0.40, 3.24, 4.86, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'IM', 3.95, 55, 0.14, 3.67, 4.23, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.e', 'LV', 5.06, 54, 0.22, 4.62, 5.51, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'IM', 3.76, 55, 0.18, 3.39, 4.13, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.1.f', 'LV', 4.43, 54, 0.21, 4.02, 4.84, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'IM', 3.39, 55, 0.24, 2.89, 3.88, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.a', 'LV', 4.34, 54, 0.46, 3.42, 5.26, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'IM', 1.34, 55, 0.15, 1.04, 1.64, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.2.b', 'LV', 0.49, 53, 0.21, 0.05, 0.92, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'IM', 3.33, 55, 0.19, 2.94, 3.72, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.a', 'LV', 4.00, 54, 0.25, 3.50, 4.51, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'IM', 2.42, 55, 0.25, 1.92, 2.92, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.b', 'LV', 2.31, 54, 0.38, 1.55, 3.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'IM', 2.38, 55, 0.26, 1.86, 2.90, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.c', 'LV', 2.66, 54, 0.44, 1.77, 3.55, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'IM', 2.51, 55, 0.29, 1.93, 3.09, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.d', 'LV', 2.62, 54, 0.47, 1.68, 3.56, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'IM', 2.71, 55, 0.28, 2.15, 3.28, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.3.e', 'LV', 2.91, 54, 0.45, 2.01, 3.81, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'IM', 3.56, 55, 0.19, 3.18, 3.94, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.a', 'LV', 4.16, 54, 0.21, 3.74, 4.59, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'IM', 1.81, 55, 0.19, 1.44, 2.18, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.b', 'LV', 1.41, 54, 0.35, 0.70, 2.12, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'IM', 1.95, 55, 0.23, 1.49, 2.41, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.c', 'LV', 1.74, 54, 0.42, 0.91, 2.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'IM', 1.50, 55, 0.17, 1.15, 1.84, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.d', 'LV', 0.90, 54, 0.34, 0.21, 1.59, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'IM', 2.72, 55, 0.25, 2.23, 3.22, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.e', 'LV', 2.78, 54, 0.39, 2.00, 3.56, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'IM', 1.81, 55, 0.19, 1.43, 2.19, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.f', 'LV', 1.30, 54, 0.28, 0.73, 1.87, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'IM', 1.76, 55, 0.19, 1.37, 2.15, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.4.g', 'LV', 1.68, 54, 0.45, 0.78, 2.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'IM', 1.55, 55, 0.16, 1.24, 1.86, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.a', 'LV', 0.86, 54, 0.24, 0.37, 1.34, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'IM', 1.77, 55, 0.21, 1.36, 2.19, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.5.b', 'LV', 1.48, 54, 0.41, 0.66, 2.30, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'IM', 2.97, 55, 0.24, 2.50, 3.44, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.6', 'LV', 3.87, 54, 0.33, 3.21, 4.52, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'IM', 3.71, 55, 0.18, 3.35, 4.08, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.a', 'LV', 3.68, 54, 0.20, 3.29, 4.07, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'IM', 1.62, 54, 0.22, 1.18, 2.06, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.b', 'LV', 1.13, 53, 0.38, 0.38, 1.89, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'IM', 1.16, 54, 0.07, 1.02, 1.30, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.c', 'LV', 0.47, 53, 0.28, 0.00, 1.03, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'IM', 1.21, 54, 0.11, 1.00, 1.42, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.d', 'LV', 0.43, 53, 0.26, 0.00, 0.96, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'IM', 1.51, 54, 0.23, 1.04, 1.97, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.7.e', 'LV', 0.87, 53, 0.40, 0.07, 1.66, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'IM', 3.10, 55, 0.31, 2.48, 3.71, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.a', 'LV', 3.12, 54, 0.46, 2.21, 4.04, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'IM', 2.95, 55, 0.26, 2.44, 3.47, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.8.b', 'LV', 3.12, 54, 0.34, 2.44, 3.80, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'IM', 2.50, 55, 0.32, 1.86, 3.14, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.a', 'LV', 2.33, 54, 0.54, 1.25, 3.41, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'IM', 2.59, 55, 0.24, 2.10, 3.07, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.9.b', 'LV', 2.68, 54, 0.35, 1.98, 3.38, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'IM', 2.20, 55, 0.24, 1.72, 2.68, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-1021.00', '2.C.10', 'LV', 2.31, 54, 0.42, 1.46, 3.16, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'IM', 4.12, 27, 0.16, 3.79, 4.46, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.a', 'LV', 4.41, 27, 0.14, 4.11, 4.70, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'IM', 3.25, 27, 0.22, 2.79, 3.71, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.b', 'LV', 4.34, 27, 0.29, 3.76, 4.93, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'IM', 3.04, 27, 0.19, 2.64, 3.43, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.c', 'LV', 2.94, 27, 0.28, 2.36, 3.51, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'IM', 4.68, 27, 0.13, 4.42, 4.93, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.d', 'LV', 5.58, 27, 0.25, 5.07, 6.10, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'IM', 4.16, 27, 0.18, 3.78, 4.53, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.e', 'LV', 5.39, 27, 0.29, 4.79, 5.99, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'IM', 2.60, 26, 0.22, 2.15, 3.06, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.1.f', 'LV', 3.08, 27, 0.34, 2.37, 3.79, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'IM', 2.58, 27, 0.21, 2.14, 3.02, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.a', 'LV', 2.68, 27, 0.35, 1.96, 3.40, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'IM', 1.04, 26, 0.04, 1.00, 1.13, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.2.b', 'LV', 0.08, 26, 0.08, 0.00, 0.26, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'IM', 3.31, 27, 0.25, 2.80, 3.82, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.a', 'LV', 4.17, 27, 0.37, 3.42, 4.92, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'IM', 1.91, 27, 0.23, 1.44, 2.39, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.b', 'LV', 1.57, 27, 0.36, 0.82, 2.31, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'IM', 2.79, 27, 0.30, 2.16, 3.41, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.c', 'LV', 2.92, 27, 0.45, 2.00, 3.84, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'IM', 1.44, 27, 0.19, 1.05, 1.83, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.d', 'LV', 0.64, 27, 0.29, 0.05, 1.23, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'IM', 1.41, 27, 0.18, 1.03, 1.78, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.3.e', 'LV', 0.67, 27, 0.29, 0.07, 1.27, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'IM', 3.16, 26, 0.22, 2.70, 3.61, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.a', 'LV', 3.55, 27, 0.26, 3.02, 4.09, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'IM', 1.34, 27, 0.18, 1.00, 1.72, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.b', 'LV', 0.49, 27, 0.27, 0.00, 1.06, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'IM', 1.22, 27, 0.15, 1.00, 1.52, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.c', 'LV', 0.37, 27, 0.24, 0.00, 0.87, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'IM', 1.23, 27, 0.13, 1.00, 1.50, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.d', 'LV', 0.45, 27, 0.25, 0.00, 0.97, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'IM', 2.87, 27, 0.31, 2.23, 3.51, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.e', 'LV', 2.74, 27, 0.42, 1.89, 3.59, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'IM', 2.50, 27, 0.26, 1.98, 3.03, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.f', 'LV', 2.77, 27, 0.38, 1.98, 3.56, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'IM', 1.99, 26, 0.21, 1.56, 2.42, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.4.g', 'LV', 2.07, 26, 0.40, 1.24, 2.89, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'IM', 1.42, 27, 0.17, 1.08, 1.76, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.a', 'LV', 0.48, 27, 0.17, 0.12, 0.84, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'IM', 1.75, 27, 0.23, 1.28, 2.23, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.5.b', 'LV', 1.42, 27, 0.40, 0.60, 2.25, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'IM', 2.94, 27, 0.26, 2.41, 3.47, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.6', 'LV', 3.85, 27, 0.45, 2.93, 4.77, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'IM', 4.41, 27, 0.15, 4.10, 4.71, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.a', 'LV', 4.85, 27, 0.22, 4.39, 5.31, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'IM', 1.58, 27, 0.19, 1.19, 1.96, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.b', 'LV', 1.04, 27, 0.34, 0.33, 1.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'IM', 2.35, 27, 0.28, 1.79, 2.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.c', 'LV', 2.30, 27, 0.47, 1.32, 3.27, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'IM', 1.67, 27, 0.21, 1.24, 2.10, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.d', 'LV', 1.13, 27, 0.34, 0.43, 1.82, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'IM', 1.89, 27, 0.21, 1.46, 2.32, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.7.e', 'LV', 2.11, 27, 0.44, 1.21, 3.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'IM', 2.47, 27, 0.22, 2.03, 2.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.a', 'LV', 2.19, 27, 0.31, 1.55, 2.83, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'IM', 2.23, 27, 0.23, 1.75, 2.70, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.8.b', 'LV', 2.09, 27, 0.33, 1.41, 2.76, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'IM', 2.40, 27, 0.25, 1.88, 2.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.a', 'LV', 1.91, 27, 0.39, 1.11, 2.71, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'IM', 4.35, 27, 0.18, 3.99, 4.72, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.9.b', 'LV', 5.21, 27, 0.31, 4.57, 5.85, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'IM', 1.95, 27, 0.24, 1.46, 2.45, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2011.00', '2.C.10', 'LV', 1.59, 27, 0.36, 0.85, 2.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'IM', 4.04, 37, 0.12, 3.79, 4.29, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.a', 'LV', 4.61, 37, 0.16, 4.28, 4.93, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'IM', 3.01, 37, 0.16, 2.68, 3.34, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.b', 'LV', 4.10, 37, 0.37, 3.35, 4.85, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'IM', 3.10, 37, 0.29, 2.51, 3.68, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.c', 'LV', 3.55, 37, 0.52, 2.50, 4.60, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'IM', 4.85, 37, 0.11, 4.63, 5.00, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.d', 'LV', 6.05, 37, 0.24, 5.58, 6.53, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'IM', 3.85, 37, 0.28, 3.28, 4.42, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.e', 'LV', 4.85, 36, 0.40, 4.04, 5.66, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'IM', 2.71, 37, 0.25, 2.20, 3.22, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.1.f', 'LV', 3.55, 37, 0.34, 2.87, 4.23, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'IM', 2.46, 37, 0.23, 1.99, 2.94, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.a', 'LV', 2.92, 37, 0.52, 1.87, 3.97, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'IM', 1.12, 36, 0.06, 1.00, 1.25, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.2.b', 'LV', 0.28, 37, 0.14, 0.00, 0.58, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'IM', 3.51, 37, 0.31, 2.88, 4.14, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.a', 'LV', 4.05, 37, 0.47, 3.09, 5.01, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'IM', 2.77, 37, 0.43, 1.91, 3.64, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.b', 'LV', 2.47, 37, 0.55, 1.35, 3.59, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'IM', 3.15, 37, 0.40, 2.34, 3.96, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.c', 'LV', 3.55, 37, 0.58, 2.37, 4.73, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'IM', 1.19, 36, 0.10, 1.00, 1.38, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.d', 'LV', 0.42, 37, 0.21, 0.00, 0.84, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'IM', 1.33, 37, 0.13, 1.06, 1.60, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.3.e', 'LV', 0.54, 37, 0.21, 0.11, 0.97, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'IM', 3.51, 37, 0.13, 3.25, 3.78, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.a', 'LV', 4.40, 37, 0.11, 4.17, 4.62, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'IM', 1.18, 37, 0.08, 1.02, 1.34, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.b', 'LV', 0.37, 37, 0.16, 0.04, 0.70, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'IM', 1.21, 37, 0.08, 1.04, 1.38, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.c', 'LV', 0.43, 37, 0.17, 0.08, 0.78, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'IM', 1.10, 37, 0.05, 1.00, 1.21, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.d', 'LV', 0.20, 37, 0.10, 0.00, 0.41, 'Y', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'IM', 2.45, 37, 0.22, 2.01, 2.89, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.e', 'LV', 2.86, 37, 0.47, 1.90, 3.81, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'IM', 2.03, 35, 0.18, 1.66, 2.39, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.f', 'LV', 2.44, 37, 0.54, 1.34, 3.54, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'IM', 2.20, 37, 0.19, 1.81, 2.59, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.4.g', 'LV', 2.55, 37, 0.36, 1.81, 3.28, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'IM', 1.26, 37, 0.10, 1.07, 1.46, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.a', 'LV', 0.44, 37, 0.16, 0.12, 0.75, 'N', 'Y', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'IM', 1.63, 37, 0.15, 1.32, 1.93, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.5.b', 'LV', 1.10, 37, 0.23, 0.64, 1.57, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'IM', 3.03, 37, 0.23, 2.56, 3.49, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.6', 'LV', 4.15, 37, 0.55, 3.04, 5.26, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'IM', 4.48, 37, 0.10, 4.28, 4.68, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.a', 'LV', 5.04, 37, 0.24, 4.56, 5.52, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'IM', 1.64, 37, 0.20, 1.24, 2.04, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.b', 'LV', 1.36, 37, 0.45, 0.46, 2.27, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'IM', 1.70, 37, 0.24, 1.22, 2.19, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.c', 'LV', 1.32, 37, 0.51, 0.29, 2.34, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'IM', 1.68, 37, 0.30, 1.07, 2.30, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.d', 'LV', 1.09, 37, 0.28, 0.52, 1.66, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'IM', 1.64, 37, 0.24, 1.16, 2.11, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.7.e', 'LV', 1.12, 36, 0.41, 0.29, 1.95, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'IM', 2.50, 37, 0.42, 1.64, 3.35, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.a', 'LV', 2.26, 37, 0.58, 1.09, 3.44, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'IM', 2.86, 37, 0.33, 2.20, 3.52, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.8.b', 'LV', 2.93, 37, 0.45, 2.02, 3.84, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'IM', 2.86, 37, 0.37, 2.10, 3.62, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.a', 'LV', 2.56, 37, 0.45, 1.63, 3.48, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'IM', 3.80, 37, 0.21, 3.38, 4.23, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.9.b', 'LV', 4.21, 37, 0.39, 3.42, 5.00, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'IM', 1.68, 37, 0.12, 1.44, 1.92, 'N', NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2021.00', '2.C.10', 'LV', 1.53, 37, 0.27, 0.98, 2.08, 'N', 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'IM', 4.00, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.a', 'LV', 5.26, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.b', 'LV', 4.30, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'IM', 2.91, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.c', 'LV', 3.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'IM', 4.70, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.d', 'LV', 6.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'IM', 4.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.e', 'LV', 5.39, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.1.f', 'LV', 3.91, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.a', 'LV', 3.09, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'IM', 1.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.2.b', 'LV', 0.09, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.a', 'LV', 3.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'IM', 2.13, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.b', 'LV', 2.00, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'IM', 1.83, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.c', 'LV', 1.43, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.d', 'LV', 1.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.3.e', 'LV', 1.39, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'IM', 3.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.a', 'LV', 4.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'IM', 1.52, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.b', 'LV', 0.91, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.c', 'LV', 0.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.d', 'LV', 0.61, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'IM', 2.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.e', 'LV', 2.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'IM', 1.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.f', 'LV', 1.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'IM', 2.26, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.4.g', 'LV', 2.39, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'IM', 1.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.a', 'LV', 0.09, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.5.b', 'LV', 1.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'IM', 3.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.6', 'LV', 4.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'IM', 4.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.a', 'LV', 4.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'IM', 1.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.b', 'LV', 1.35, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.c', 'LV', 0.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'IM', 1.22, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.d', 'LV', 0.52, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.7.e', 'LV', 1.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'IM', 1.87, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.a', 'LV', 1.48, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'IM', 2.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.8.b', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.a', 'LV', 1.96, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'IM', 3.17, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.9.b', 'LV', 3.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'IM', 2.22, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2022.00', '2.C.10', 'LV', 2.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.a', 'IM', 3.85, 30, 0.19, 3.45, 4.24, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.a', 'LV', 4.48, 30, 0.16, 4.15, 4.82, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.b', 'IM', 3.10, 30, 0.24, 2.60, 3.60, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.b', 'LV', 4.24, 30, 0.44, 3.34, 5.14, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.c', 'IM', 2.92, 30, 0.20, 2.51, 3.33, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.c', 'LV', 2.94, 30, 0.33, 2.28, 3.61, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.d', 'IM', 4.44, 30, 0.14, 4.16, 4.71, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.d', 'LV', 5.47, 30, 0.24, 4.97, 5.96, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.e', 'IM', 4.36, 30, 0.15, 4.06, 4.66, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.e', 'LV', 5.86, 30, 0.23, 5.39, 6.33, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.f', 'IM', 2.92, 30, 0.21, 2.50, 3.34, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.1.f', 'LV', 3.74, 30, 0.30, 3.12, 4.35, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.a', 'IM', 1.45, 30, 0.14, 1.16, 1.74, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.a', 'LV', 0.77, 30, 0.25, 0.26, 1.28, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.b', 'IM', 1.04, 29, 0.04, 1.00, 1.13, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.2.b', 'LV', 0.12, 30, 0.09, 0.00, 0.29, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.a', 'IM', 2.34, 30, 0.22, 1.90, 2.79, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.a', 'LV', 2.88, 30, 0.34, 2.18, 3.58, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.b', 'IM', 1.31, 30, 0.12, 1.05, 1.56, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.b', 'LV', 0.51, 30, 0.21, 0.09, 0.93, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.c', 'IM', 1.25, 30, 0.12, 1.01, 1.50, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.c', 'LV', 0.41, 30, 0.20, 0.00, 0.82, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.d', 'IM', 1.18, 30, 0.11, 1.00, 1.40, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.d', 'LV', 0.22, 30, 0.12, 0.00, 0.45, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.e', 'IM', 1.05, 30, 0.03, 1.00, 1.10, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.3.e', 'LV', 0.08, 30, 0.05, 0.00, 0.19, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.a', 'IM', 2.81, 30, 0.17, 2.46, 3.16, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.a', 'LV', 3.90, 30, 0.16, 3.59, 4.22, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.b', 'IM', 1.13, 30, 0.10, 1.00, 1.34, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.b', 'LV', 0.26, 30, 0.21, 0.00, 0.68, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.c', 'IM', 1.22, 30, 0.12, 1.00, 1.47, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.c', 'LV', 0.55, 30, 0.33, 0.00, 1.22, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.d', 'IM', 1.13, 30, 0.09, 1.00, 1.31, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.d', 'LV', 0.15, 30, 0.09, 0.00, 0.34, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.e', 'IM', 3.02, 30, 0.24, 2.53, 3.51, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.e', 'LV', 3.27, 30, 0.35, 2.55, 3.98, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.f', 'IM', 2.60, 30, 0.28, 2.04, 3.17, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.f', 'LV', 3.25, 30, 0.43, 2.36, 4.14, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.g', 'IM', 1.62, 30, 0.23, 1.14, 2.10, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.4.g', 'LV', 1.22, 30, 0.41, 0.38, 2.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.a', 'IM', 1.63, 30, 0.27, 1.09, 2.18, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.a', 'LV', 0.86, 30, 0.37, 0.10, 1.62, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.b', 'IM', 1.83, 30, 0.24, 1.35, 2.32, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.5.b', 'LV', 1.54, 30, 0.43, 0.66, 2.41, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.6', 'IM', 2.88, 30, 0.23, 2.40, 3.36, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.6', 'LV', 4.02, 30, 0.28, 3.44, 4.60, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.a', 'IM', 4.36, 30, 0.15, 4.04, 4.67, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.a', 'LV', 4.91, 30, 0.15, 4.61, 5.21, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.b', 'IM', 1.43, 30, 0.13, 1.16, 1.70, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.b', 'LV', 0.60, 30, 0.21, 0.17, 1.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.c', 'IM', 2.39, 30, 0.26, 1.86, 2.91, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.c', 'LV', 2.27, 30, 0.52, 1.21, 3.33, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.d', 'IM', 1.79, 30, 0.14, 1.50, 2.08, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.d', 'LV', 1.49, 30, 0.26, 0.95, 2.03, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.e', 'IM', 1.86, 30, 0.12, 1.61, 2.10, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.7.e', 'LV', 2.13, 30, 0.32, 1.48, 2.79, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.a', 'IM', 2.12, 30, 0.39, 1.33, 2.92, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.a', 'LV', 1.69, 30, 0.47, 0.72, 2.66, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.b', 'IM', 2.62, 29, 0.13, 2.35, 2.89, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.8.b', 'LV', 2.74, 30, 0.24, 2.26, 3.23, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.a', 'IM', 1.79, 30, 0.19, 1.40, 2.17, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.a', 'LV', 1.11, 30, 0.37, 0.36, 1.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.b', 'IM', 3.99, 30, 0.29, 3.40, 4.58, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.9.b', 'LV', 4.84, 30, 0.51, 3.79, 5.88, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.10', 'IM', 1.53, 30, 0.13, 1.27, 1.79, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-2031.00', '2.C.10', 'LV', 1.01, 29, 0.24, 0.52, 1.51, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.a', 'IM', 4.24, 43, 0.19, 3.85, 4.63, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.a', 'LV', 4.56, 43, 0.14, 4.27, 4.85, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.b', 'IM', 3.90, 43, 0.27, 3.36, 4.44, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.b', 'LV', 5.18, 43, 0.26, 4.65, 5.71, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.c', 'IM', 2.92, 42, 0.18, 2.56, 3.28, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.c', 'LV', 3.14, 42, 0.33, 2.47, 3.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.d', 'IM', 1.95, 41, 0.22, 1.50, 2.40, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.d', 'LV', 2.00, 41, 0.44, 1.10, 2.90, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.e', 'IM', 4.44, 44, 0.18, 4.08, 4.79, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.e', 'LV', 5.17, 44, 0.16, 4.85, 5.49, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.f', 'IM', 3.35, 44, 0.14, 3.07, 3.62, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.1.f', 'LV', 4.12, 44, 0.20, 3.72, 4.53, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.a', 'IM', 2.89, 44, 0.45, 1.98, 3.81, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.a', 'LV', 3.02, 44, 0.53, 1.94, 4.09, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.b', 'IM', 1.27, 43, 0.12, 1.04, 1.51, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.2.b', 'LV', 0.61, 43, 0.22, 0.17, 1.04, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.a', 'IM', 3.35, 45, 0.20, 2.95, 3.75, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.a', 'LV', 4.15, 45, 0.26, 3.62, 4.68, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.b', 'IM', 2.06, 43, 0.27, 1.51, 2.62, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.b', 'LV', 1.62, 43, 0.40, 0.81, 2.42, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.c', 'IM', 2.10, 43, 0.21, 1.68, 2.51, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.c', 'LV', 2.01, 43, 0.35, 1.30, 2.71, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.d', 'IM', 2.29, 43, 0.20, 1.88, 2.69, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.d', 'LV', 2.17, 43, 0.32, 1.52, 2.82, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.e', 'IM', 2.33, 43, 0.19, 1.95, 2.71, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.3.e', 'LV', 2.25, 43, 0.36, 1.51, 2.99, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.a', 'IM', 3.26, 45, 0.13, 2.99, 3.52, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.a', 'LV', 3.54, 45, 0.16, 3.21, 3.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.b', 'IM', 1.60, 45, 0.16, 1.27, 1.93, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.b', 'LV', 1.14, 45, 0.32, 0.50, 1.78, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.c', 'IM', 1.52, 44, 0.17, 1.18, 1.86, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.c', 'LV', 1.33, 44, 0.43, 0.47, 2.19, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.d', 'IM', 1.37, 44, 0.21, 1.00, 1.79, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.d', 'LV', 0.74, 44, 0.41, 0.00, 1.57, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.e', 'IM', 2.07, 44, 0.29, 1.49, 2.64, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.e', 'LV', 1.99, 45, 0.50, 0.99, 3.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.f', 'IM', 1.76, 44, 0.24, 1.28, 2.25, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.f', 'LV', 1.45, 44, 0.46, 0.52, 2.38, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.g', 'IM', 1.51, 44, 0.16, 1.18, 1.84, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.4.g', 'LV', 1.10, 44, 0.33, 0.43, 1.77, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.a', 'IM', 1.78, 44, 0.29, 1.20, 2.36, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.a', 'LV', 1.08, 44, 0.42, 0.24, 1.92, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.b', 'IM', 1.74, 44, 0.23, 1.28, 2.20, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.5.b', 'LV', 1.39, 44, 0.41, 0.55, 2.22, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.6', 'IM', 2.84, 44, 0.41, 2.01, 3.66, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.6', 'LV', 3.05, 44, 0.67, 1.70, 4.40, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.a', 'IM', 4.03, 45, 0.06, 3.90, 4.16, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.a', 'LV', 3.86, 44, 0.22, 3.43, 4.30, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.b', 'IM', 1.37, 44, 0.11, 1.15, 1.59, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.b', 'LV', 0.75, 44, 0.22, 0.30, 1.20, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.c', 'IM', 1.13, 44, 0.06, 1.01, 1.25, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.c', 'LV', 0.21, 44, 0.10, 0.01, 0.42, 'N', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.d', 'IM', 1.42, 44, 0.12, 1.17, 1.66, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.d', 'LV', 0.77, 44, 0.22, 0.33, 1.21, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.e', 'IM', 1.49, 44, 0.16, 1.16, 1.81, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.7.e', 'LV', 1.31, 44, 0.38, 0.55, 2.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.a', 'IM', 3.29, 45, 0.17, 2.96, 3.63, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.a', 'LV', 3.29, 45, 0.22, 2.84, 3.73, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.b', 'IM', 2.88, 45, 0.42, 2.05, 3.72, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.8.b', 'LV', 2.66, 45, 0.57, 1.51, 3.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.a', 'IM', 2.63, 44, 0.16, 2.31, 2.96, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.a', 'LV', 2.19, 44, 0.42, 1.33, 3.04, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.b', 'IM', 2.40, 44, 0.31, 1.77, 3.02, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.9.b', 'LV', 2.20, 44, 0.51, 1.17, 3.22, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.10', 'IM', 1.94, 44, 0.25, 1.44, 2.44, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3011.00', '2.C.10', 'LV', 1.41, 44, 0.35, 0.71, 2.12, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'IM', 3.70, 26, 0.25, 3.19, 4.20, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.a', 'LV', 4.31, 26, 0.25, 3.81, 4.82, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'IM', 2.48, 26, 0.16, 2.16, 2.81, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.b', 'LV', 3.69, 26, 0.26, 3.15, 4.24, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'IM', 2.15, 26, 0.18, 1.77, 2.52, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.c', 'LV', 2.16, 26, 0.37, 1.40, 2.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'IM', 1.92, 26, 0.31, 1.28, 2.55, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.d', 'LV', 1.77, 26, 0.68, 0.38, 3.17, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'IM', 4.05, 25, 0.16, 3.71, 4.39, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.e', 'LV', 4.72, 26, 0.31, 4.09, 5.36, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'IM', 3.42, 26, 0.16, 3.08, 3.76, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.1.f', 'LV', 4.09, 26, 0.24, 3.60, 4.58, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'IM', 1.78, 26, 0.31, 1.15, 2.41, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.a', 'LV', 1.42, 26, 0.59, 0.21, 2.63, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'IM', 1.00, 26, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.2.b', 'LV', 0.00, 26, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'IM', 4.77, 26, 0.14, 4.48, 5.00, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.a', 'LV', 6.13, 26, 0.18, 5.75, 6.51, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'IM', 3.50, 26, 0.49, 2.48, 4.51, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.b', 'LV', 3.99, 26, 0.92, 2.10, 5.88, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'IM', 2.61, 26, 0.43, 1.74, 3.49, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.c', 'LV', 3.00, 26, 0.80, 1.35, 4.66, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'IM', 1.24, 25, 0.13, 1.00, 1.51, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.d', 'LV', 0.65, 26, 0.35, 0.00, 1.37, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'IM', 1.38, 24, 0.23, 1.00, 1.86, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.3.e', 'LV', 0.62, 25, 0.36, 0.00, 1.36, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'IM', 3.16, 24, 0.29, 2.56, 3.75, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.a', 'LV', 4.67, 24, 0.36, 3.93, 5.41, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'IM', 1.61, 25, 0.35, 1.00, 2.33, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.b', 'LV', 1.20, 25, 0.62, 0.00, 2.48, 'Y', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'IM', 1.23, 25, 0.12, 1.00, 1.48, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.c', 'LV', 0.58, 25, 0.29, 0.00, 1.18, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'IM', 1.01, 26, 0.01, 1.00, 1.02, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.d', 'LV', 0.01, 26, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'IM', 2.22, 26, 0.40, 1.40, 3.04, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.e', 'LV', 2.27, 26, 0.57, 1.10, 3.44, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'IM', 1.90, 26, 0.29, 1.30, 2.49, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.f', 'LV', 1.69, 26, 0.57, 0.52, 2.86, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'IM', 2.24, 26, 0.51, 1.20, 3.28, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.4.g', 'LV', 2.49, 26, 0.93, 0.57, 4.41, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'IM', 1.02, 26, 0.02, 1.00, 1.05, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.a', 'LV', 0.02, 26, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'IM', 1.44, 26, 0.30, 1.00, 2.06, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.5.b', 'LV', 0.78, 26, 0.46, 0.00, 1.72, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'IM', 3.05, 24, 0.30, 2.44, 3.67, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.6', 'LV', 3.95, 26, 0.34, 3.26, 4.65, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'IM', 3.48, 26, 0.45, 2.56, 4.40, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.a', 'LV', 3.63, 26, 0.59, 2.42, 4.84, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'IM', 1.28, 25, 0.12, 1.03, 1.53, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.b', 'LV', 0.74, 26, 0.35, 0.01, 1.46, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'IM', 1.42, 26, 0.30, 1.00, 2.05, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.c', 'LV', 0.74, 26, 0.52, 0.00, 1.80, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'IM', 1.03, 26, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.d', 'LV', 0.06, 26, 0.06, 0.00, 0.17, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'IM', 1.23, 26, 0.15, 1.00, 1.54, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.7.e', 'LV', 0.69, 26, 0.45, 0.00, 1.61, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'IM', 1.94, 26, 0.29, 1.34, 2.54, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.a', 'LV', 1.52, 26, 0.50, 0.49, 2.55, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'IM', 2.12, 26, 0.37, 1.37, 2.88, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.8.b', 'LV', 2.03, 26, 0.62, 0.75, 3.31, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'IM', 2.63, 26, 0.41, 1.79, 3.48, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.a', 'LV', 2.81, 26, 0.61, 1.56, 4.06, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'IM', 2.16, 26, 0.26, 1.62, 2.70, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.9.b', 'LV', 2.50, 26, 0.56, 1.34, 3.67, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'IM', 1.18, 26, 0.09, 1.00, 1.36, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3021.00', '2.C.10', 'LV', 0.41, 26, 0.22, 0.00, 0.87, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'IM', 4.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.a', 'LV', 5.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'IM', 2.48, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.b', 'LV', 3.48, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'IM', 4.60, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.c', 'LV', 6.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'IM', 1.96, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.d', 'LV', 2.44, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.e', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.1.f', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'IM', 1.76, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.a', 'LV', 1.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.2.b', 'LV', 0.16, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'IM', 2.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.a', 'LV', 3.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.b', 'LV', 0.96, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'IM', 1.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.c', 'LV', 0.60, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.d', 'LV', 0.04, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'IM', 1.08, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.3.e', 'LV', 0.12, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'IM', 3.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.a', 'LV', 5.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.b', 'LV', 0.08, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.c', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'IM', 1.00, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.d', 'LV', 0.00, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'IM', 1.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.e', 'LV', 2.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'IM', 1.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.f', 'LV', 1.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.4.g', 'LV', 1.00, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'IM', 1.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.a', 'LV', 0.21, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.5.b', 'LV', 0.48, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'IM', 2.56, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.6', 'LV', 3.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.a', 'LV', 4.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.b', 'LV', 0.88, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'IM', 1.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.c', 'LV', 0.04, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.d', 'LV', 0.48, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.7.e', 'LV', 1.00, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.a', 'LV', 1.32, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.8.b', 'LV', 3.04, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'IM', 1.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.a', 'LV', 0.60, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'IM', 2.00, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.9.b', 'LV', 2.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'IM', 1.28, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.01', '2.C.10', 'LV', 0.80, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.a', 'IM', 3.93, 31, 0.25, 3.42, 4.43, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.a', 'LV', 4.62, 31, 0.37, 3.87, 5.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.b', 'IM', 2.92, 31, 0.32, 2.26, 3.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.b', 'LV', 3.16, 31, 0.63, 1.88, 4.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.c', 'IM', 3.96, 31, 0.34, 3.27, 4.64, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.c', 'LV', 4.48, 31, 0.68, 3.09, 5.86, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.d', 'IM', 3.15, 31, 0.56, 2.01, 4.30, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.d', 'LV', 3.64, 31, 0.94, 1.73, 5.56, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.e', 'IM', 3.60, 31, 0.66, 2.25, 4.96, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.e', 'LV', 4.10, 30, 1.12, 1.82, 6.39, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.f', 'IM', 2.84, 31, 0.52, 1.77, 3.90, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.1.f', 'LV', 3.09, 31, 0.87, 1.32, 4.87, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.a', 'IM', 1.75, 31, 0.29, 1.17, 2.34, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.a', 'LV', 1.20, 30, 0.45, 0.28, 2.11, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.b', 'IM', 1.00, 31, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.2.b', 'LV', 0.00, 31, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.a', 'IM', 2.77, 31, 0.24, 2.29, 3.25, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.a', 'LV', 3.34, 31, 0.38, 2.56, 4.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.b', 'IM', 1.23, 31, 0.10, 1.02, 1.44, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.b', 'LV', 0.64, 31, 0.31, 0.01, 1.27, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.c', 'IM', 1.28, 31, 0.13, 1.00, 1.55, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.c', 'LV', 0.80, 31, 0.44, 0.00, 1.70, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.d', 'IM', 1.37, 31, 0.17, 1.03, 1.71, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.d', 'LV', 0.86, 31, 0.39, 0.06, 1.66, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.e', 'IM', 1.30, 31, 0.15, 1.00, 1.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.3.e', 'LV', 0.59, 31, 0.27, 0.03, 1.15, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.a', 'IM', 3.62, 31, 0.21, 3.19, 4.05, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.a', 'LV', 4.25, 31, 0.35, 3.53, 4.97, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.b', 'IM', 1.00, 31, 0.00, 1.00, 1.01, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.b', 'LV', 0.01, 31, 0.01, 0.00, 0.02, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.c', 'IM', 1.02, 31, 0.02, 1.00, 1.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.c', 'LV', 0.05, 31, 0.04, 0.00, 0.14, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.d', 'IM', 1.02, 30, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.d', 'LV', 0.04, 30, 0.04, 0.00, 0.12, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.e', 'IM', 2.79, 30, 0.34, 2.10, 3.48, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.e', 'LV', 2.96, 30, 0.47, 2.00, 3.93, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.f', 'IM', 1.96, 30, 0.33, 1.27, 2.64, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.f', 'LV', 1.81, 30, 0.58, 0.63, 3.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.g', 'IM', 1.18, 30, 0.10, 1.00, 1.40, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.4.g', 'LV', 0.39, 30, 0.21, 0.00, 0.82, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.a', 'IM', 1.02, 31, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.a', 'LV', 0.02, 31, 0.02, 0.00, 0.06, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.b', 'IM', 1.37, 31, 0.18, 1.01, 1.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.5.b', 'LV', 0.69, 30, 0.36, 0.00, 1.44, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.6', 'IM', 2.53, 31, 0.33, 1.86, 3.20, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.6', 'LV', 3.17, 31, 0.53, 2.09, 4.25, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.a', 'IM', 3.31, 31, 0.38, 2.53, 4.10, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.a', 'LV', 4.23, 31, 0.45, 3.31, 5.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.b', 'IM', 1.19, 30, 0.10, 1.00, 1.39, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.b', 'LV', 0.28, 30, 0.16, 0.00, 0.61, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.c', 'IM', 1.21, 30, 0.20, 1.00, 1.62, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.c', 'LV', 0.34, 30, 0.34, 0.00, 1.04, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.d', 'IM', 1.03, 30, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.d', 'LV', 0.07, 30, 0.05, 0.00, 0.17, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.e', 'IM', 1.14, 30, 0.08, 1.00, 1.30, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.7.e', 'LV', 0.36, 30, 0.23, 0.00, 0.82, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.a', 'IM', 1.96, 31, 0.31, 1.34, 2.59, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.a', 'LV', 1.79, 31, 0.57, 0.62, 2.95, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.b', 'IM', 3.09, 31, 0.27, 2.53, 3.65, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.8.b', 'LV', 3.16, 31, 0.36, 2.42, 3.91, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.a', 'IM', 1.93, 31, 0.26, 1.40, 2.46, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.a', 'LV', 1.07, 31, 0.28, 0.50, 1.64, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.b', 'IM', 2.54, 31, 0.33, 1.87, 3.22, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.9.b', 'LV', 2.59, 31, 0.59, 1.39, 3.80, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.10', 'IM', 1.44, 31, 0.20, 1.04, 1.84, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3031.02', '2.C.10', 'LV', 0.84, 31, 0.37, 0.10, 1.59, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'IM', 4.50, 37, 0.11, 4.28, 4.71, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.a', 'LV', 5.34, 38, 0.17, 5.00, 5.68, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'IM', 3.06, 38, 0.25, 2.54, 3.57, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.b', 'LV', 3.63, 38, 0.49, 2.65, 4.62, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'IM', 2.77, 38, 0.25, 2.25, 3.28, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.c', 'LV', 2.48, 38, 0.39, 1.70, 3.26, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'IM', 2.37, 38, 0.24, 1.88, 2.86, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.d', 'LV', 2.43, 38, 0.41, 1.60, 3.25, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'IM', 4.07, 38, 0.15, 3.76, 4.38, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.e', 'LV', 4.84, 37, 0.27, 4.30, 5.38, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'IM', 3.90, 38, 0.18, 3.54, 4.26, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.1.f', 'LV', 4.59, 38, 0.26, 4.06, 5.12, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'IM', 4.80, 37, 0.08, 4.64, 4.97, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.a', 'LV', 5.62, 38, 0.15, 5.32, 5.91, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'IM', 1.31, 37, 0.16, 1.00, 1.63, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.2.b', 'LV', 0.59, 37, 0.30, 0.00, 1.20, 'Y', 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'IM', 3.25, 38, 0.20, 2.86, 3.65, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.a', 'LV', 3.99, 38, 0.26, 3.45, 4.52, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'IM', 3.49, 38, 0.17, 3.15, 3.83, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.b', 'LV', 4.13, 38, 0.22, 3.70, 4.57, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'IM', 2.58, 38, 0.22, 2.13, 3.03, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.c', 'LV', 2.99, 38, 0.41, 2.17, 3.82, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'IM', 1.69, 37, 0.16, 1.37, 2.02, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.d', 'LV', 1.52, 37, 0.35, 0.81, 2.24, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'IM', 3.41, 38, 0.17, 3.07, 3.74, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.3.e', 'LV', 4.22, 38, 0.27, 3.66, 4.77, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'IM', 3.56, 38, 0.16, 3.24, 3.88, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.a', 'LV', 4.40, 38, 0.16, 4.08, 4.72, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'IM', 2.09, 38, 0.21, 1.66, 2.52, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.b', 'LV', 2.18, 38, 0.35, 1.47, 2.89, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'IM', 2.01, 38, 0.17, 1.67, 2.34, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.c', 'LV', 2.28, 38, 0.34, 1.59, 2.97, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'IM', 1.27, 37, 0.11, 1.05, 1.49, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.d', 'LV', 0.54, 37, 0.25, 0.04, 1.04, 'N', 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'IM', 3.00, 38, 0.25, 2.49, 3.51, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.e', 'LV', 3.40, 38, 0.42, 2.55, 4.24, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'IM', 1.95, 38, 0.18, 1.59, 2.32, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.f', 'LV', 1.79, 38, 0.31, 1.17, 2.42, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'IM', 1.52, 37, 0.11, 1.30, 1.74, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.4.g', 'LV', 1.31, 37, 0.28, 0.75, 1.87, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'IM', 1.39, 37, 0.10, 1.19, 1.60, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.a', 'LV', 0.87, 37, 0.24, 0.39, 1.35, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'IM', 1.55, 38, 0.13, 1.30, 1.81, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.5.b', 'LV', 1.31, 38, 0.28, 0.75, 1.86, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'IM', 3.29, 38, 0.11, 3.06, 3.51, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.6', 'LV', 4.61, 38, 0.20, 4.20, 5.02, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'IM', 3.55, 38, 0.22, 3.10, 3.99, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.a', 'LV', 3.63, 38, 0.27, 3.09, 4.17, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'IM', 1.30, 37, 0.11, 1.09, 1.52, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.b', 'LV', 0.49, 37, 0.16, 0.15, 0.82, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'IM', 1.05, 36, 0.05, 1.00, 1.15, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.c', 'LV', 0.10, 36, 0.10, 0.00, 0.30, 'Y', 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'IM', 1.13, 36, 0.08, 1.00, 1.29, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.d', 'LV', 0.19, 36, 0.11, 0.00, 0.42, 'Y', 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'IM', 1.54, 36, 0.19, 1.15, 1.92, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.7.e', 'LV', 1.09, 35, 0.29, 0.50, 1.69, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'IM', 2.94, 38, 0.29, 2.34, 3.53, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.a', 'LV', 2.94, 38, 0.38, 2.17, 3.72, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'IM', 2.52, 37, 0.22, 2.06, 2.97, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.8.b', 'LV', 2.72, 37, 0.31, 2.10, 3.34, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'IM', 1.81, 37, 0.15, 1.51, 2.11, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.a', 'LV', 1.50, 37, 0.29, 0.91, 2.09, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'IM', 2.35, 36, 0.31, 1.72, 2.97, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.9.b', 'LV', 2.05, 36, 0.42, 1.20, 2.90, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'IM', 2.44, 36, 0.15, 2.12, 2.75, 'N', NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.00', '2.C.10', 'LV', 2.64, 36, 0.29, 2.04, 3.24, 'N', 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.a', 'IM', 3.85, 17, 0.26, 3.30, 4.40, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.a', 'LV', 4.51, 17, 0.17, 4.16, 4.87, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.b', 'IM', 3.77, 17, 0.26, 3.21, 4.32, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.b', 'LV', 4.78, 17, 0.45, 3.82, 5.74, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.c', 'IM', 2.18, 17, 0.28, 1.58, 2.78, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.c', 'LV', 1.95, 16, 0.56, 0.74, 3.15, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.d', 'IM', 1.96, 17, 0.37, 1.18, 2.74, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.d', 'LV', 1.46, 17, 0.53, 0.34, 2.58, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.e', 'IM', 3.54, 17, 0.51, 2.46, 4.62, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.e', 'LV', 4.10, 17, 0.88, 2.22, 5.97, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.f', 'IM', 3.48, 17, 0.28, 2.90, 4.07, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.1.f', 'LV', 4.24, 17, 0.30, 3.60, 4.88, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.a', 'IM', 3.35, 17, 0.44, 2.42, 4.27, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.a', 'LV', 3.80, 17, 0.68, 2.35, 5.24, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.b', 'IM', 1.80, 17, 0.43, 1.00, 2.71, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.2.b', 'LV', 1.27, 17, 0.67, 0.00, 2.68, 'Y', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.a', 'IM', 3.05, 17, 0.24, 2.55, 3.56, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.a', 'LV', 4.09, 17, 0.23, 3.59, 4.59, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.b', 'IM', 2.48, 17, 0.40, 1.64, 3.33, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.b', 'LV', 3.09, 17, 0.66, 1.70, 4.49, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.c', 'IM', 1.96, 17, 0.36, 1.19, 2.73, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.c', 'LV', 1.96, 17, 0.68, 0.52, 3.40, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.d', 'IM', 1.56, 17, 0.27, 1.00, 2.13, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.d', 'LV', 1.48, 17, 0.68, 0.05, 2.92, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.e', 'IM', 2.06, 17, 0.11, 1.83, 2.29, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.3.e', 'LV', 2.77, 17, 0.41, 1.91, 3.64, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.a', 'IM', 3.56, 17, 0.17, 3.21, 3.92, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.a', 'LV', 4.31, 17, 0.16, 3.97, 4.66, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.b', 'IM', 2.15, 17, 0.26, 1.59, 2.71, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.b', 'LV', 2.80, 17, 0.60, 1.53, 4.08, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.c', 'IM', 3.76, 17, 0.42, 2.87, 4.65, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.c', 'LV', 4.63, 17, 0.41, 3.76, 5.51, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.d', 'IM', 3.11, 17, 0.36, 2.35, 3.88, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.d', 'LV', 3.80, 17, 0.53, 2.68, 4.91, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.e', 'IM', 2.44, 17, 0.17, 2.07, 2.80, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.e', 'LV', 2.82, 17, 0.23, 2.33, 3.31, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.f', 'IM', 1.70, 17, 0.27, 1.12, 2.28, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.f', 'LV', 0.97, 17, 0.40, 0.12, 1.82, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.g', 'IM', 1.51, 17, 0.31, 1.00, 2.18, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.4.g', 'LV', 1.19, 17, 0.64, 0.00, 2.54, 'Y', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.a', 'IM', 1.88, 17, 0.37, 1.09, 2.67, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.a', 'LV', 1.16, 17, 0.49, 0.12, 2.20, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.b', 'IM', 1.63, 17, 0.22, 1.16, 2.10, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.5.b', 'LV', 1.17, 17, 0.44, 0.23, 2.10, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.6', 'IM', 3.20, 17, 0.25, 2.68, 3.72, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.6', 'LV', 5.68, 17, 0.20, 5.26, 6.10, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.a', 'IM', 3.72, 17, 0.29, 3.10, 4.34, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.a', 'LV', 4.13, 17, 0.36, 3.37, 4.89, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.b', 'IM', 1.43, 17, 0.22, 1.00, 1.90, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.b', 'LV', 0.76, 17, 0.51, 0.00, 1.85, 'Y', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.c', 'IM', 1.00, 17, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.c', 'LV', 0.00, 17, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.d', 'IM', 1.03, 17, 0.02, 1.00, 1.08, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.d', 'LV', 0.09, 17, 0.06, 0.00, 0.21, 'Y', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.e', 'IM', 1.15, 17, 0.11, 1.00, 1.40, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.7.e', 'LV', 0.45, 17, 0.34, 0.00, 1.18, 'Y', 'Y', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.a', 'IM', 2.44, 17, 0.38, 1.63, 3.25, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.a', 'LV', 2.55, 17, 0.62, 1.23, 3.87, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.b', 'IM', 2.92, 17, 0.32, 2.24, 3.59, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.8.b', 'LV', 3.58, 17, 0.33, 2.88, 4.28, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.a', 'IM', 1.40, 17, 0.16, 1.05, 1.74, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.a', 'LV', 0.61, 17, 0.29, 0.00, 1.23, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.b', 'IM', 2.24, 17, 0.21, 1.80, 2.68, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.9.b', 'LV', 2.80, 17, 0.27, 2.24, 3.36, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.10', 'IM', 1.81, 17, 0.31, 1.16, 2.46, 'N', NULL, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.01', '2.C.10', 'LV', 1.72, 17, 0.53, 0.59, 2.85, 'N', 'N', TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.a', 'IM', 4.21, 21, 0.12, 3.96, 4.45, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.a', 'LV', 4.63, 21, 0.15, 4.32, 4.94, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.b', 'IM', 3.45, 21, 0.13, 3.17, 3.73, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.b', 'LV', 4.59, 21, 0.18, 4.22, 4.95, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.c', 'IM', 3.07, 21, 0.16, 2.73, 3.40, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.c', 'LV', 3.04, 21, 0.34, 2.33, 3.75, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.d', 'IM', 1.79, 21, 0.18, 1.41, 2.16, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.d', 'LV', 1.35, 21, 0.32, 0.69, 2.01, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.e', 'IM', 2.93, 20, 0.34, 2.21, 3.64, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.e', 'LV', 3.10, 20, 0.57, 1.91, 4.30, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.f', 'IM', 3.69, 19, 0.16, 3.35, 4.03, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.1.f', 'LV', 4.36, 20, 0.17, 3.99, 4.72, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.a', 'IM', 4.00, 20, 0.29, 3.38, 4.61, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.a', 'LV', 4.64, 20, 0.41, 3.77, 5.50, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.b', 'IM', 1.14, 20, 0.11, 1.00, 1.37, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.2.b', 'LV', 0.17, 20, 0.13, 0.00, 0.45, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.a', 'IM', 3.36, 21, 0.12, 3.11, 3.62, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.a', 'LV', 4.20, 21, 0.23, 3.72, 4.69, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.b', 'IM', 3.81, 21, 0.19, 3.40, 4.21, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.b', 'LV', 4.83, 21, 0.36, 4.07, 5.59, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.c', 'IM', 3.50, 21, 0.25, 2.99, 4.02, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.c', 'LV', 3.95, 21, 0.44, 3.02, 4.88, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.d', 'IM', 3.25, 21, 0.19, 2.84, 3.65, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.d', 'LV', 4.53, 21, 0.39, 3.71, 5.35, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.e', 'IM', 4.40, 21, 0.10, 4.19, 4.62, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.3.e', 'LV', 5.89, 21, 0.23, 5.40, 6.37, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.a', 'IM', 3.89, 21, 0.18, 3.52, 4.26, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.a', 'LV', 4.63, 21, 0.20, 4.22, 5.05, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.b', 'IM', 3.54, 21, 0.09, 3.35, 3.73, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.b', 'LV', 4.68, 21, 0.16, 4.34, 5.02, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.c', 'IM', 3.46, 21, 0.14, 3.16, 3.76, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.c', 'LV', 4.56, 21, 0.13, 4.29, 4.83, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.d', 'IM', 2.21, 21, 0.16, 1.87, 2.54, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.d', 'LV', 2.81, 21, 0.27, 2.24, 3.38, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.e', 'IM', 2.94, 21, 0.20, 2.53, 3.35, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.e', 'LV', 3.56, 21, 0.38, 2.78, 4.35, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.f', 'IM', 2.12, 21, 0.18, 1.75, 2.48, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.f', 'LV', 2.21, 21, 0.29, 1.60, 2.81, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.g', 'IM', 2.01, 21, 0.20, 1.60, 2.42, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.4.g', 'LV', 2.45, 21, 0.49, 1.42, 3.48, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.a', 'IM', 1.86, 19, 0.17, 1.51, 2.22, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.a', 'LV', 1.65, 20, 0.31, 1.01, 2.29, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.b', 'IM', 2.27, 20, 0.23, 1.80, 2.74, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.5.b', 'LV', 2.76, 20, 0.29, 2.14, 3.37, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.6', 'IM', 3.55, 20, 0.20, 3.14, 3.96, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.6', 'LV', 5.36, 20, 0.24, 4.86, 5.85, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.a', 'IM', 3.75, 20, 0.28, 3.16, 4.33, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.a', 'LV', 3.84, 20, 0.25, 3.32, 4.35, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.b', 'IM', 1.77, 21, 0.16, 1.44, 2.11, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.b', 'LV', 1.34, 21, 0.21, 0.90, 1.78, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.c', 'IM', 1.15, 21, 0.08, 1.00, 1.32, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.c', 'LV', 0.24, 21, 0.13, 0.00, 0.52, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.d', 'IM', 1.64, 21, 0.15, 1.33, 1.95, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.d', 'LV', 0.73, 21, 0.15, 0.42, 1.03, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.e', 'IM', 2.02, 21, 0.12, 1.77, 2.27, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.7.e', 'LV', 2.79, 21, 0.45, 1.86, 3.72, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.a', 'IM', 3.90, 21, 0.14, 3.61, 4.18, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.a', 'LV', 4.64, 21, 0.13, 4.37, 4.91, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.b', 'IM', 3.36, 21, 0.24, 2.86, 3.86, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.8.b', 'LV', 3.54, 21, 0.29, 2.94, 4.15, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.a', 'IM', 2.80, 21, 0.27, 2.24, 3.36, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.a', 'LV', 2.92, 21, 0.26, 2.37, 3.47, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.b', 'IM', 2.41, 21, 0.14, 2.11, 2.71, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.9.b', 'LV', 2.52, 21, 0.31, 1.88, 3.16, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.10', 'IM', 2.63, 20, 0.16, 2.30, 2.96, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.02', '2.C.10', 'LV', 2.31, 20, 0.27, 1.75, 2.88, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.a', 'IM', 4.08, 23, 0.15, 3.78, 4.38, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.a', 'LV', 4.96, 22, 0.25, 4.43, 5.49, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.b', 'IM', 3.26, 23, 0.16, 2.93, 3.59, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.b', 'LV', 4.28, 23, 0.22, 3.82, 4.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.c', 'IM', 3.01, 23, 0.22, 2.56, 3.45, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.c', 'LV', 2.98, 23, 0.26, 2.44, 3.53, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.d', 'IM', 2.44, 23, 0.23, 1.96, 2.93, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.d', 'LV', 2.81, 23, 0.37, 2.04, 3.58, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.e', 'IM', 3.04, 23, 0.20, 2.63, 3.46, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.e', 'LV', 4.03, 23, 0.30, 3.40, 4.67, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.f', 'IM', 3.32, 23, 0.26, 2.77, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.1.f', 'LV', 3.99, 23, 0.38, 3.21, 4.76, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.a', 'IM', 4.73, 23, 0.11, 4.50, 4.96, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.a', 'LV', 5.60, 23, 0.21, 5.17, 6.03, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.b', 'IM', 2.71, 23, 0.29, 2.09, 3.32, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.2.b', 'LV', 3.30, 23, 0.50, 2.27, 4.33, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.a', 'IM', 3.33, 23, 0.22, 2.87, 3.78, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.a', 'LV', 3.96, 23, 0.30, 3.35, 4.58, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.b', 'IM', 3.68, 23, 0.17, 3.32, 4.04, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.b', 'LV', 4.79, 23, 0.27, 4.23, 5.35, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.c', 'IM', 3.19, 23, 0.23, 2.72, 3.67, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.c', 'LV', 4.04, 23, 0.28, 3.46, 4.62, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.d', 'IM', 2.82, 23, 0.22, 2.37, 3.27, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.d', 'LV', 3.91, 23, 0.47, 2.95, 4.88, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.e', 'IM', 4.04, 22, 0.14, 3.74, 4.34, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.3.e', 'LV', 5.41, 22, 0.21, 4.97, 5.85, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.a', 'IM', 3.49, 23, 0.18, 3.11, 3.87, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.a', 'LV', 4.46, 23, 0.16, 4.13, 4.80, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.b', 'IM', 3.28, 23, 0.25, 2.76, 3.80, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.b', 'LV', 3.63, 23, 0.38, 2.84, 4.43, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.c', 'IM', 3.68, 23, 0.16, 3.35, 4.01, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.c', 'LV', 4.68, 23, 0.12, 4.43, 4.94, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.d', 'IM', 2.98, 23, 0.33, 2.29, 3.67, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.d', 'LV', 3.27, 23, 0.46, 2.31, 4.22, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.e', 'IM', 2.65, 23, 0.23, 2.18, 3.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.e', 'LV', 3.19, 23, 0.35, 2.47, 3.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.f', 'IM', 1.80, 23, 0.18, 1.42, 2.18, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.f', 'LV', 1.67, 23, 0.34, 0.98, 2.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.g', 'IM', 2.09, 23, 0.20, 1.68, 2.50, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.4.g', 'LV', 2.18, 23, 0.37, 1.42, 2.94, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.a', 'IM', 1.35, 23, 0.12, 1.12, 1.59, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.a', 'LV', 0.64, 23, 0.21, 0.20, 1.09, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.b', 'IM', 1.40, 23, 0.13, 1.13, 1.67, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.5.b', 'LV', 1.08, 23, 0.35, 0.35, 1.80, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.6', 'IM', 3.23, 23, 0.19, 2.82, 3.63, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.6', 'LV', 4.47, 23, 0.33, 3.78, 5.15, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.a', 'IM', 3.23, 23, 0.18, 2.85, 3.61, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.a', 'LV', 3.56, 23, 0.20, 3.15, 3.97, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.b', 'IM', 1.26, 23, 0.11, 1.03, 1.49, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.b', 'LV', 0.46, 23, 0.21, 0.02, 0.90, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.c', 'IM', 1.03, 23, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.c', 'LV', 0.03, 23, 0.03, 0.00, 0.09, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.d', 'IM', 1.25, 23, 0.09, 1.06, 1.44, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.d', 'LV', 0.44, 23, 0.16, 0.11, 0.77, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.e', 'IM', 1.33, 23, 0.13, 1.07, 1.60, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.7.e', 'LV', 0.75, 23, 0.27, 0.19, 1.31, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.a', 'IM', 3.13, 23, 0.28, 2.55, 3.72, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.a', 'LV', 3.65, 23, 0.45, 2.72, 4.58, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.b', 'IM', 2.50, 23, 0.25, 1.99, 3.01, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.8.b', 'LV', 2.77, 23, 0.41, 1.92, 3.61, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.a', 'IM', 1.81, 23, 0.22, 1.35, 2.27, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.a', 'LV', 1.44, 23, 0.39, 0.63, 2.25, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.b', 'IM', 1.98, 23, 0.18, 1.60, 2.35, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.9.b', 'LV', 1.89, 23, 0.31, 1.25, 2.53, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.10', 'IM', 2.66, 23, 0.21, 2.23, 3.09, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.03', '2.C.10', 'LV', 3.26, 23, 0.32, 2.60, 3.92, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.a', 'IM', 4.05, 21, 0.22, 3.59, 4.51, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.a', 'LV', 4.97, 20, 0.24, 4.48, 5.46, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.b', 'IM', 3.61, 21, 0.19, 3.22, 4.01, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.b', 'LV', 4.24, 20, 0.42, 3.36, 5.13, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.c', 'IM', 3.14, 21, 0.27, 2.57, 3.71, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.c', 'LV', 3.78, 19, 0.52, 2.69, 4.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.d', 'IM', 1.49, 21, 0.29, 1.00, 2.10, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.d', 'LV', 1.04, 21, 0.56, 0.00, 2.22, 'Y', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.e', 'IM', 2.87, 20, 0.44, 1.95, 3.78, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.e', 'LV', 3.35, 20, 0.69, 1.91, 4.80, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.f', 'IM', 3.87, 20, 0.24, 3.37, 4.36, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.1.f', 'LV', 4.45, 20, 0.18, 4.07, 4.82, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.a', 'IM', 4.06, 20, 0.27, 3.51, 4.62, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.a', 'LV', 4.98, 20, 0.37, 4.19, 5.76, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.b', 'IM', 1.04, 19, 0.03, 1.00, 1.11, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.2.b', 'LV', 0.07, 19, 0.06, 0.00, 0.19, 'Y', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.a', 'IM', 3.47, 21, 0.37, 2.69, 4.25, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.a', 'LV', 4.07, 21, 0.22, 3.62, 4.53, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.b', 'IM', 4.08, 21, 0.21, 3.64, 4.51, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.b', 'LV', 4.80, 21, 0.12, 4.55, 5.05, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.c', 'IM', 3.21, 21, 0.36, 2.46, 3.96, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.c', 'LV', 3.39, 21, 0.52, 2.30, 4.48, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.d', 'IM', 3.09, 21, 0.22, 2.64, 3.54, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.d', 'LV', 4.13, 21, 0.41, 3.28, 4.99, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.e', 'IM', 4.30, 21, 0.16, 3.98, 4.63, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.3.e', 'LV', 5.52, 21, 0.38, 4.73, 6.31, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.a', 'IM', 3.53, 21, 0.28, 2.96, 4.10, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.a', 'LV', 4.39, 21, 0.29, 3.79, 4.98, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.b', 'IM', 3.20, 21, 0.30, 2.58, 3.82, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.b', 'LV', 3.99, 21, 0.48, 2.98, 4.99, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.c', 'IM', 3.35, 21, 0.22, 2.90, 3.81, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.c', 'LV', 4.57, 21, 0.17, 4.21, 4.93, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.d', 'IM', 1.69, 20, 0.28, 1.10, 2.28, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.d', 'LV', 1.63, 20, 0.62, 0.32, 2.93, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.e', 'IM', 2.85, 20, 0.14, 2.57, 3.14, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.e', 'LV', 3.91, 20, 0.29, 3.30, 4.51, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.f', 'IM', 1.72, 20, 0.27, 1.14, 2.29, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.f', 'LV', 1.41, 20, 0.48, 0.40, 2.41, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.g', 'IM', 1.63, 20, 0.25, 1.10, 2.15, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.4.g', 'LV', 1.37, 20, 0.53, 0.27, 2.47, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.a', 'IM', 1.63, 21, 0.30, 1.00, 2.26, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.a', 'LV', 0.98, 21, 0.46, 0.03, 1.93, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.b', 'IM', 2.28, 21, 0.21, 1.85, 2.71, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.5.b', 'LV', 2.85, 21, 0.37, 2.07, 3.62, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.6', 'IM', 3.58, 21, 0.25, 3.05, 4.11, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.6', 'LV', 5.08, 21, 0.36, 4.33, 5.83, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.a', 'IM', 3.34, 21, 0.31, 2.69, 3.99, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.a', 'LV', 3.93, 21, 0.43, 3.02, 4.83, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.b', 'IM', 1.26, 20, 0.14, 1.00, 1.56, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.b', 'LV', 0.61, 20, 0.41, 0.00, 1.47, 'Y', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.c', 'IM', 1.03, 20, 0.03, 1.00, 1.08, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.c', 'LV', 0.05, 20, 0.04, 0.00, 0.13, 'Y', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.d', 'IM', 1.35, 20, 0.17, 1.00, 1.70, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.d', 'LV', 0.97, 20, 0.49, 0.00, 2.01, 'Y', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.e', 'IM', 1.74, 20, 0.31, 1.10, 2.39, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.7.e', 'LV', 1.53, 20, 0.62, 0.24, 2.82, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.a', 'IM', 3.70, 21, 0.32, 3.03, 4.38, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.a', 'LV', 4.25, 21, 0.36, 3.50, 5.01, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.b', 'IM', 2.65, 21, 0.37, 1.88, 3.41, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.8.b', 'LV', 2.75, 21, 0.51, 1.68, 3.82, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.a', 'IM', 2.38, 21, 0.28, 1.78, 2.97, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.a', 'LV', 2.14, 21, 0.46, 1.17, 3.11, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.b', 'IM', 2.63, 21, 0.34, 1.94, 3.33, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.9.b', 'LV', 2.45, 21, 0.39, 1.65, 3.26, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.10', 'IM', 2.81, 20, 0.23, 2.32, 3.30, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.04', '2.C.10', 'LV', 2.96, 20, 0.28, 2.39, 3.54, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.a', 'IM', 3.92, 29, 0.15, 3.62, 4.23, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.a', 'LV', 4.30, 29, 0.30, 3.69, 4.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.b', 'IM', 3.20, 29, 0.19, 2.82, 3.58, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.b', 'LV', 3.77, 29, 0.32, 3.11, 4.43, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.c', 'IM', 2.76, 29, 0.17, 2.42, 3.10, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.c', 'LV', 2.68, 29, 0.30, 2.05, 3.30, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.d', 'IM', 1.63, 29, 0.16, 1.30, 1.97, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.d', 'LV', 1.24, 29, 0.30, 0.63, 1.85, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.e', 'IM', 2.73, 29, 0.26, 2.19, 3.27, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.e', 'LV', 3.04, 29, 0.49, 2.05, 4.04, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.f', 'IM', 3.58, 29, 0.17, 3.23, 3.94, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.1.f', 'LV', 4.12, 29, 0.24, 3.62, 4.62, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.a', 'IM', 3.11, 29, 0.21, 2.68, 3.55, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.a', 'LV', 4.32, 28, 0.43, 3.43, 5.21, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.b', 'IM', 1.03, 29, 0.03, 1.00, 1.08, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.2.b', 'LV', 0.03, 29, 0.03, 0.00, 0.08, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.a', 'IM', 3.60, 29, 0.19, 3.21, 3.99, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.a', 'LV', 4.35, 28, 0.18, 3.98, 4.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.b', 'IM', 3.62, 29, 0.16, 3.30, 3.95, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.b', 'LV', 4.55, 28, 0.22, 4.10, 5.01, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.c', 'IM', 3.20, 29, 0.22, 2.75, 3.65, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.c', 'LV', 3.87, 29, 0.31, 3.23, 4.50, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.d', 'IM', 2.98, 29, 0.18, 2.61, 3.35, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.d', 'LV', 4.22, 29, 0.25, 3.70, 4.73, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.e', 'IM', 4.07, 28, 0.16, 3.73, 4.41, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.3.e', 'LV', 5.48, 28, 0.21, 5.06, 5.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.a', 'IM', 3.41, 28, 0.16, 3.09, 3.73, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.a', 'LV', 4.20, 28, 0.19, 3.82, 4.59, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.b', 'IM', 3.13, 29, 0.15, 2.82, 3.44, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.b', 'LV', 4.11, 29, 0.20, 3.71, 4.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.c', 'IM', 2.50, 29, 0.15, 2.19, 2.82, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.c', 'LV', 3.36, 29, 0.26, 2.82, 3.90, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.d', 'IM', 1.72, 28, 0.19, 1.32, 2.11, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.d', 'LV', 1.18, 28, 0.33, 0.49, 1.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.e', 'IM', 3.02, 28, 0.26, 2.49, 3.54, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.e', 'LV', 3.63, 28, 0.31, 2.99, 4.26, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.f', 'IM', 2.16, 28, 0.25, 1.66, 2.67, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.f', 'LV', 1.84, 28, 0.37, 1.08, 2.59, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.g', 'IM', 2.62, 28, 0.20, 2.21, 3.04, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.4.g', 'LV', 3.14, 28, 0.36, 2.41, 3.87, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.a', 'IM', 1.80, 28, 0.20, 1.40, 2.21, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.a', 'LV', 1.21, 28, 0.28, 0.64, 1.79, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.b', 'IM', 1.86, 28, 0.18, 1.50, 2.22, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.5.b', 'LV', 1.80, 29, 0.34, 1.11, 2.50, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.6', 'IM', 3.52, 28, 0.22, 3.07, 3.97, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.6', 'LV', 4.59, 29, 0.22, 4.14, 5.04, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.a', 'IM', 3.82, 29, 0.17, 3.47, 4.18, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.a', 'LV', 3.96, 29, 0.17, 3.62, 4.31, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.b', 'IM', 1.15, 29, 0.07, 1.01, 1.29, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.b', 'LV', 0.20, 29, 0.09, 0.02, 0.39, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.c', 'IM', 1.03, 29, 0.03, 1.00, 1.08, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.c', 'LV', 0.03, 29, 0.03, 0.00, 0.08, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.d', 'IM', 1.57, 29, 0.15, 1.25, 1.88, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.d', 'LV', 1.06, 29, 0.27, 0.51, 1.62, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.e', 'IM', 1.49, 29, 0.15, 1.19, 1.79, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.7.e', 'LV', 1.30, 29, 0.37, 0.54, 2.07, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.a', 'IM', 4.06, 29, 0.19, 3.67, 4.45, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.a', 'LV', 4.55, 29, 0.26, 4.02, 5.09, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.b', 'IM', 3.27, 28, 0.22, 2.81, 3.72, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.8.b', 'LV', 3.72, 29, 0.30, 3.11, 4.33, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.a', 'IM', 2.71, 29, 0.24, 2.21, 3.20, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.a', 'LV', 2.75, 29, 0.32, 2.08, 3.41, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.b', 'IM', 2.39, 28, 0.17, 2.04, 2.74, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.9.b', 'LV', 2.56, 29, 0.21, 2.14, 2.98, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.10', 'IM', 1.79, 28, 0.20, 1.38, 2.21, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3051.06', '2.C.10', 'LV', 1.61, 28, 0.37, 0.85, 2.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'IM', 4.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.a', 'LV', 4.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.b', 'LV', 4.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.c', 'LV', 3.95, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'IM', 2.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.d', 'LV', 3.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.e', 'LV', 4.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'IM', 3.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.1.f', 'LV', 3.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.a', 'LV', 3.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'IM', 1.86, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.2.b', 'LV', 1.29, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.a', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.b', 'LV', 2.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'IM', 2.29, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.c', 'LV', 2.29, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.d', 'LV', 1.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'IM', 2.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.3.e', 'LV', 2.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'IM', 3.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.a', 'LV', 4.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'IM', 1.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.b', 'LV', 1.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'IM', 1.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.c', 'LV', 1.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'IM', 1.76, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.d', 'LV', 1.48, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'IM', 2.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.e', 'LV', 2.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'IM', 1.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.f', 'LV', 1.19, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.4.g', 'LV', 2.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.a', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'IM', 1.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.5.b', 'LV', 0.76, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'IM', 3.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.6', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'IM', 4.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.a', 'LV', 4.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'IM', 1.67, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.b', 'LV', 1.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.c', 'LV', 0.38, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.d', 'LV', 0.57, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'IM', 1.38, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.7.e', 'LV', 0.90, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'IM', 2.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.a', 'LV', 2.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'IM', 3.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.8.b', 'LV', 3.33, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'IM', 2.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.a', 'LV', 2.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'IM', 2.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.9.b', 'LV', 2.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'IM', 2.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3061.00', '2.C.10', 'LV', 2.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.a', 'IM', 4.27, 34, 0.15, 3.97, 4.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.a', 'LV', 4.90, 34, 0.27, 4.34, 5.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.b', 'IM', 3.43, 35, 0.27, 2.87, 3.99, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.b', 'LV', 3.97, 35, 0.50, 2.96, 4.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.c', 'IM', 3.04, 35, 0.30, 2.42, 3.66, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.c', 'LV', 3.10, 35, 0.49, 2.10, 4.09, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.d', 'IM', 2.83, 35, 0.27, 2.28, 3.39, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.d', 'LV', 3.44, 35, 0.42, 2.59, 4.29, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.e', 'IM', 4.19, 33, 0.14, 3.91, 4.47, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.e', 'LV', 5.31, 33, 0.23, 4.83, 5.78, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.f', 'IM', 3.67, 34, 0.24, 3.19, 4.16, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.1.f', 'LV', 4.26, 33, 0.31, 3.63, 4.88, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.a', 'IM', 2.84, 35, 0.31, 2.21, 3.46, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.a', 'LV', 3.50, 35, 0.55, 2.39, 4.61, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.b', 'IM', 1.91, 35, 0.29, 1.31, 2.51, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.2.b', 'LV', 1.71, 35, 0.52, 0.65, 2.77, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.a', 'IM', 3.36, 34, 0.25, 2.86, 3.86, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.a', 'LV', 3.85, 35, 0.33, 3.18, 4.53, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.b', 'IM', 2.44, 34, 0.34, 1.74, 3.13, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.b', 'LV', 2.39, 34, 0.54, 1.29, 3.50, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.c', 'IM', 1.87, 33, 0.35, 1.15, 2.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.c', 'LV', 1.57, 34, 0.54, 0.48, 2.67, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.d', 'IM', 1.80, 34, 0.33, 1.12, 2.47, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.d', 'LV', 1.45, 34, 0.54, 0.35, 2.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.e', 'IM', 2.23, 34, 0.27, 1.68, 2.78, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.3.e', 'LV', 1.92, 34, 0.39, 1.13, 2.72, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.a', 'IM', 3.58, 35, 0.25, 3.08, 4.08, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.a', 'LV', 3.80, 35, 0.33, 3.14, 4.47, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.b', 'IM', 1.47, 34, 0.21, 1.05, 1.90, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.b', 'LV', 0.95, 35, 0.33, 0.29, 1.62, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.c', 'IM', 1.84, 35, 0.30, 1.24, 2.44, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.c', 'LV', 1.32, 35, 0.40, 0.50, 2.14, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.d', 'IM', 1.65, 35, 0.25, 1.13, 2.16, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.d', 'LV', 0.94, 35, 0.31, 0.30, 1.58, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.e', 'IM', 2.72, 35, 0.27, 2.16, 3.27, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.e', 'LV', 2.95, 35, 0.42, 2.09, 3.82, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.f', 'IM', 2.02, 34, 0.29, 1.44, 2.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.f', 'LV', 1.61, 34, 0.39, 0.81, 2.41, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.g', 'IM', 3.04, 35, 0.35, 2.34, 3.74, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.4.g', 'LV', 2.73, 35, 0.41, 1.91, 3.56, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.a', 'IM', 1.31, 34, 0.10, 1.11, 1.51, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.a', 'LV', 0.47, 34, 0.14, 0.18, 0.77, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.b', 'IM', 2.15, 34, 0.27, 1.61, 2.69, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.5.b', 'LV', 1.87, 34, 0.38, 1.09, 2.64, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.6', 'IM', 3.09, 34, 0.26, 2.56, 3.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.6', 'LV', 3.78, 34, 0.42, 2.92, 4.63, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.a', 'IM', 3.56, 35, 0.28, 2.98, 4.13, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.a', 'LV', 3.26, 34, 0.41, 2.41, 4.10, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.b', 'IM', 1.56, 34, 0.18, 1.19, 1.93, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.b', 'LV', 0.80, 34, 0.27, 0.25, 1.34, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.c', 'IM', 1.04, 34, 0.03, 1.00, 1.10, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.c', 'LV', 0.09, 34, 0.05, 0.00, 0.20, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.d', 'IM', 1.33, 34, 0.13, 1.07, 1.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.d', 'LV', 0.73, 34, 0.24, 0.24, 1.21, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.e', 'IM', 1.58, 34, 0.23, 1.10, 2.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.7.e', 'LV', 1.32, 34, 0.39, 0.53, 2.12, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.a', 'IM', 3.86, 34, 0.27, 3.30, 4.41, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.a', 'LV', 3.80, 34, 0.37, 3.06, 4.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.b', 'IM', 3.00, 35, 0.22, 2.55, 3.44, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.8.b', 'LV', 3.04, 34, 0.27, 2.48, 3.60, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.a', 'IM', 2.71, 35, 0.26, 2.18, 3.23, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.a', 'LV', 1.75, 35, 0.34, 1.06, 2.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.b', 'IM', 2.54, 35, 0.31, 1.90, 3.17, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.9.b', 'LV', 2.15, 35, 0.46, 1.21, 3.09, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.10', 'IM', 4.57, 35, 0.12, 4.33, 4.80, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.01', '2.C.10', 'LV', 4.47, 35, 0.26, 3.95, 4.99, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.a', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.a', 'LV', 4.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.b', 'IM', 3.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.b', 'LV', 5.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.c', 'IM', 3.43, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.c', 'LV', 4.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.d', 'IM', 3.13, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.d', 'LV', 4.00, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.e', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.e', 'LV', 5.35, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.f', 'IM', 3.61, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.1.f', 'LV', 4.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.a', 'LV', 4.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.b', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.2.b', 'LV', 2.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.a', 'IM', 3.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.a', 'LV', 4.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.b', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.b', 'LV', 3.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.c', 'IM', 2.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.c', 'LV', 2.74, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.d', 'IM', 2.52, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.d', 'LV', 2.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.e', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.3.e', 'LV', 3.30, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.a', 'IM', 3.70, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.a', 'LV', 4.83, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.b', 'IM', 1.74, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.b', 'LV', 1.43, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.c', 'IM', 2.00, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.c', 'LV', 2.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.d', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.d', 'LV', 1.26, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.e', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.e', 'LV', 3.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.f', 'IM', 2.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.f', 'LV', 2.70, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.g', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.4.g', 'LV', 3.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.a', 'IM', 1.70, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.a', 'LV', 1.52, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.b', 'IM', 2.00, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.5.b', 'LV', 2.52, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.6', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.6', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.a', 'LV', 4.57, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.b', 'IM', 2.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.b', 'LV', 2.22, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.c', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.c', 'LV', 0.87, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.d', 'IM', 1.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.d', 'LV', 1.57, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.e', 'IM', 1.96, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.7.e', 'LV', 2.00, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.a', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.a', 'LV', 4.42, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.b', 'IM', 3.04, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.8.b', 'LV', 3.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.a', 'IM', 2.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.a', 'LV', 3.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.b', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.9.b', 'LV', 2.61, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.10', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.02', '2.C.10', 'LV', 4.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.a', 'IM', 4.07, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.a', 'LV', 4.90, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.b', 'IM', 2.41, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.b', 'LV', 3.60, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.c', 'IM', 3.24, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.c', 'LV', 3.67, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.d', 'IM', 2.40, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.d', 'LV', 2.93, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.e', 'IM', 3.67, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.e', 'LV', 5.00, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.f', 'IM', 3.37, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.1.f', 'LV', 4.33, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.2.a', 'IM', 3.37, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.2.a', 'LV', 4.37, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.2.b', 'IM', 1.83, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.2.b', 'LV', 1.67, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.a', 'IM', 2.66, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.a', 'LV', 3.45, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.b', 'IM', 2.21, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.b', 'LV', 2.90, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.c', 'IM', 2.04, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.c', 'LV', 2.55, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.d', 'IM', 1.79, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.d', 'LV', 1.93, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.e', 'IM', 2.17, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.3.e', 'LV', 2.50, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.a', 'IM', 3.50, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.a', 'LV', 4.43, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.b', 'IM', 1.55, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.b', 'LV', 1.20, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.c', 'IM', 1.67, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.c', 'LV', 1.60, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.d', 'IM', 1.24, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.d', 'LV', 0.69, 29, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.e', 'IM', 2.64, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.e', 'LV', 3.69, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.f', 'IM', 2.00, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.f', 'LV', 2.14, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.g', 'IM', 2.97, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.4.g', 'LV', 3.55, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.5.a', 'IM', 1.33, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.5.a', 'LV', 0.80, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.5.b', 'IM', 1.90, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.5.b', 'LV', 2.23, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.6', 'IM', 3.10, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.6', 'LV', 4.50, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.a', 'IM', 3.97, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.a', 'LV', 4.17, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.b', 'IM', 2.00, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.b', 'LV', 2.20, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.c', 'IM', 1.13, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.c', 'LV', 0.33, 30, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.d', 'IM', 1.53, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.d', 'LV', 1.23, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.e', 'IM', 1.63, 30, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.7.e', 'LV', 1.47, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.8.a', 'IM', 3.14, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.8.a', 'LV', 3.72, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.8.b', 'IM', 3.28, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.8.b', 'LV', 3.62, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.9.a', 'IM', 2.25, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.9.a', 'LV', 2.14, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.9.b', 'IM', 2.69, 29, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.9.b', 'LV', 2.93, 29, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.10', 'IM', 4.39, 28, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3071.03', '2.C.10', 'LV', 4.63, 30, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'IM', 4.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.a', 'LV', 5.00, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.b', 'LV', 3.52, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'IM', 3.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.c', 'LV', 3.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'IM', 1.81, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.d', 'LV', 2.24, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.e', 'LV', 4.71, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'IM', 4.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.1.f', 'LV', 5.86, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.a', 'LV', 0.62, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.2.b', 'LV', 0.19, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.a', 'LV', 3.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.b', 'LV', 0.14, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'IM', 1.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.c', 'LV', 0.81, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.d', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.3.e', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'IM', 3.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.a', 'LV', 5.05, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.b', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'IM', 1.05, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.d', 'LV', 0.10, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'IM', 2.52, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.e', 'LV', 3.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'IM', 2.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.f', 'LV', 2.76, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.4.g', 'LV', 0.62, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'IM', 1.57, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.a', 'LV', 1.10, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'IM', 1.71, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.5.b', 'LV', 1.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'IM', 2.43, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.6', 'LV', 3.38, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'IM', 3.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.a', 'LV', 4.14, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.b', 'LV', 0.67, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'IM', 1.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.c', 'LV', 0.00, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'IM', 1.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.d', 'LV', 0.52, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.7.e', 'LV', 0.95, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'IM', 2.00, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.a', 'LV', 1.81, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.8.b', 'LV', 3.57, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'IM', 1.33, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.a', 'LV', 0.43, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'IM', 2.48, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.9.b', 'LV', 2.62, 21, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'IM', 1.14, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3111.00', '2.C.10', 'LV', 0.38, 21, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'IM', 4.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.a', 'LV', 5.00, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'IM', 2.96, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.b', 'LV', 4.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'IM', 2.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.c', 'LV', 2.65, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'IM', 2.38, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.d', 'LV', 2.67, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.e', 'LV', 5.26, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'IM', 4.92, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.1.f', 'LV', 6.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'IM', 2.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.a', 'LV', 2.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'IM', 1.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.2.b', 'LV', 0.67, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'IM', 2.70, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.a', 'LV', 3.13, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'IM', 1.39, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.b', 'LV', 0.83, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'IM', 1.35, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.c', 'LV', 0.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.d', 'LV', 0.32, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'IM', 1.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.3.e', 'LV', 0.38, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'IM', 2.96, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.a', 'LV', 3.71, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'IM', 1.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.b', 'LV', 0.17, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'IM', 1.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.c', 'LV', 0.42, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'IM', 1.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.d', 'LV', 0.57, 23, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'IM', 3.26, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.e', 'LV', 4.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'IM', 2.78, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.f', 'LV', 3.78, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'IM', 1.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.4.g', 'LV', 1.30, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'IM', 1.54, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.a', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'IM', 2.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.5.b', 'LV', 3.71, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'IM', 3.96, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.6', 'LV', 5.96, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'IM', 4.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.a', 'LV', 4.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'IM', 1.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.b', 'LV', 1.08, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'IM', 1.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.c', 'LV', 0.29, 24, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'IM', 1.71, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.d', 'LV', 1.46, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'IM', 2.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.7.e', 'LV', 2.67, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'IM', 2.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.a', 'LV', 3.00, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'IM', 4.08, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.8.b', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'IM', 1.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.a', 'LV', 1.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'IM', 2.83, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.9.b', 'LV', 3.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'IM', 1.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3121.00', '2.C.10', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.a', 'LV', 4.48, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'IM', 3.04, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.b', 'LV', 4.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'IM', 2.19, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.c', 'LV', 2.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'IM', 2.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.d', 'LV', 3.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'IM', 4.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.e', 'LV', 5.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.1.f', 'LV', 4.70, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'IM', 2.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.a', 'LV', 2.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'IM', 1.26, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.2.b', 'LV', 0.41, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'IM', 3.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.a', 'LV', 4.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'IM', 1.70, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.b', 'LV', 1.31, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'IM', 2.35, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.c', 'LV', 2.54, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'IM', 1.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.d', 'LV', 0.74, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'IM', 1.41, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.3.e', 'LV', 0.89, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'IM', 2.62, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.a', 'LV', 3.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'IM', 1.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.b', 'LV', 0.41, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'IM', 1.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.c', 'LV', 0.41, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'IM', 1.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.d', 'LV', 0.41, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'IM', 3.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.e', 'LV', 3.74, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'IM', 2.96, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.f', 'LV', 3.89, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'IM', 1.52, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.4.g', 'LV', 1.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'IM', 1.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.a', 'LV', 0.44, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'IM', 1.93, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.5.b', 'LV', 2.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'IM', 4.85, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.6', 'LV', 6.59, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'IM', 4.33, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.a', 'LV', 5.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'IM', 1.52, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.b', 'LV', 1.15, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'IM', 1.26, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.c', 'LV', 0.44, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'IM', 1.22, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.d', 'LV', 0.59, 27, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'IM', 1.85, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.7.e', 'LV', 2.04, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'IM', 2.30, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.a', 'LV', 2.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'IM', 2.44, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.8.b', 'LV', 2.37, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'IM', 1.96, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.a', 'LV', 1.48, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'IM', 3.37, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.9.b', 'LV', 3.85, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'IM', 1.56, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-3131.00', '2.C.10', 'LV', 1.07, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.a', 'IM', 4.39, 24, 0.16, 4.06, 4.72, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.a', 'LV', 4.44, 24, 0.16, 4.10, 4.77, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.b', 'IM', 2.84, 24, 0.36, 2.10, 3.58, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.b', 'LV', 3.72, 24, 0.71, 2.25, 5.19, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.c', 'IM', 3.32, 23, 0.23, 2.85, 3.80, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.c', 'LV', 3.31, 23, 0.44, 2.40, 4.21, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.d', 'IM', 3.92, 24, 0.22, 3.46, 4.38, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.d', 'LV', 4.52, 24, 0.25, 4.01, 5.03, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.e', 'IM', 3.82, 24, 0.35, 3.08, 4.55, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.e', 'LV', 4.66, 24, 0.36, 3.92, 5.41, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.f', 'IM', 4.10, 24, 0.27, 3.54, 4.67, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.1.f', 'LV', 3.99, 24, 0.17, 3.64, 4.34, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.a', 'IM', 4.17, 24, 0.40, 3.35, 4.99, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.a', 'LV', 5.10, 23, 0.42, 4.23, 5.97, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.b', 'IM', 2.16, 24, 0.43, 1.26, 3.06, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.2.b', 'LV', 1.96, 24, 0.73, 0.46, 3.47, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.a', 'IM', 1.82, 24, 0.16, 1.50, 2.15, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.a', 'LV', 2.66, 24, 0.55, 1.53, 3.79, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.b', 'IM', 2.69, 24, 0.48, 1.69, 3.68, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.b', 'LV', 2.77, 24, 0.73, 1.25, 4.29, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.c', 'IM', 2.98, 24, 0.27, 2.41, 3.54, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.c', 'LV', 3.65, 24, 0.34, 2.96, 4.35, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.d', 'IM', 2.46, 24, 0.33, 1.78, 3.14, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.d', 'LV', 2.58, 24, 0.53, 1.48, 3.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.e', 'IM', 3.08, 24, 0.42, 2.21, 3.94, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.3.e', 'LV', 3.73, 24, 0.75, 2.19, 5.27, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.a', 'IM', 3.43, 24, 0.19, 3.03, 3.83, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.a', 'LV', 4.07, 24, 0.26, 3.53, 4.61, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.b', 'IM', 1.85, 24, 0.23, 1.38, 2.32, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.b', 'LV', 2.31, 24, 0.64, 0.99, 3.63, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.c', 'IM', 3.35, 24, 0.31, 2.71, 3.98, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.c', 'LV', 3.83, 24, 0.37, 3.06, 4.60, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.d', 'IM', 3.92, 23, 0.39, 3.12, 4.73, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.d', 'LV', 4.53, 23, 0.64, 3.19, 5.86, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.e', 'IM', 2.89, 23, 0.17, 2.54, 3.24, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.e', 'LV', 3.57, 22, 0.37, 2.79, 4.34, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.f', 'IM', 1.89, 23, 0.35, 1.17, 2.60, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.f', 'LV', 1.27, 22, 0.49, 0.25, 2.28, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.g', 'IM', 2.41, 23, 0.20, 2.00, 2.82, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.4.g', 'LV', 3.18, 23, 0.48, 2.19, 4.16, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.a', 'IM', 1.26, 24, 0.12, 1.02, 1.51, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.a', 'LV', 0.54, 24, 0.24, 0.04, 1.03, 'N', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.b', 'IM', 1.39, 24, 0.16, 1.06, 1.72, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.5.b', 'LV', 0.80, 24, 0.33, 0.13, 1.48, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.6', 'IM', 3.16, 24, 0.24, 2.65, 3.66, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.6', 'LV', 4.11, 24, 0.43, 3.22, 5.01, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.a', 'IM', 3.11, 24, 0.26, 2.56, 3.65, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.a', 'LV', 3.25, 24, 0.19, 2.85, 3.66, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.b', 'IM', 2.24, 23, 0.38, 1.45, 3.03, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.b', 'LV', 2.01, 23, 0.59, 0.80, 3.23, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.c', 'IM', 1.11, 23, 0.09, 1.00, 1.30, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.c', 'LV', 0.13, 23, 0.10, 0.00, 0.33, 'Y', 'Y', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.d', 'IM', 1.68, 23, 0.18, 1.32, 2.05, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.d', 'LV', 1.63, 23, 0.50, 0.60, 2.67, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.e', 'IM', 2.48, 23, 0.41, 1.63, 3.33, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.7.e', 'LV', 2.31, 23, 0.55, 1.17, 3.45, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.a', 'IM', 2.91, 24, 0.38, 2.13, 3.70, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.a', 'LV', 2.87, 24, 0.29, 2.27, 3.48, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.b', 'IM', 2.88, 24, 0.32, 2.23, 3.54, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.8.b', 'LV', 3.13, 24, 0.39, 2.33, 3.94, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.a', 'IM', 1.35, 24, 0.13, 1.08, 1.61, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.a', 'LV', 0.46, 24, 0.17, 0.10, 0.82, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.b', 'IM', 2.14, 24, 0.17, 1.80, 2.49, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.9.b', 'LV', 2.65, 24, 0.19, 2.26, 3.05, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.10', 'IM', 3.23, 24, 0.29, 2.62, 3.83, 'N', NULL, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.01', '2.C.10', 'LV', 3.21, 24, 0.29, 2.61, 3.82, 'N', 'N', TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.a', 'IM', 4.19, 24, 0.16, 3.86, 4.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.a', 'LV', 4.91, 24, 0.28, 4.33, 5.50, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.b', 'IM', 2.75, 24, 0.25, 2.24, 3.26, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.b', 'LV', 3.50, 24, 0.64, 2.18, 4.82, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.c', 'IM', 3.77, 24, 0.28, 3.19, 4.35, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.c', 'LV', 4.58, 23, 0.47, 3.61, 5.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.d', 'IM', 3.19, 24, 0.49, 2.17, 4.20, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.d', 'LV', 3.60, 24, 0.68, 2.20, 5.00, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.e', 'IM', 2.50, 24, 0.40, 1.66, 3.34, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.e', 'LV', 2.82, 24, 0.81, 1.14, 4.49, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.f', 'IM', 2.96, 24, 0.33, 2.27, 3.65, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.1.f', 'LV', 3.35, 24, 0.50, 2.32, 4.38, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.2.a', 'IM', 3.87, 24, 0.09, 3.70, 4.05, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.2.a', 'LV', 4.80, 23, 0.29, 4.20, 5.39, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.2.b', 'IM', 4.54, 24, 0.18, 4.17, 4.92, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.2.b', 'LV', 4.93, 24, 0.33, 4.26, 5.60, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.a', 'IM', 2.80, 24, 0.27, 2.24, 3.35, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.a', 'LV', 3.61, 24, 0.32, 2.96, 4.26, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.b', 'IM', 3.11, 24, 0.30, 2.49, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.b', 'LV', 3.74, 24, 0.49, 2.72, 4.77, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.c', 'IM', 2.52, 24, 0.24, 2.03, 3.02, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.c', 'LV', 3.10, 24, 0.23, 2.63, 3.57, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.d', 'IM', 2.91, 24, 0.41, 2.05, 3.76, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.d', 'LV', 3.60, 24, 0.78, 1.99, 5.21, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.e', 'IM', 3.48, 24, 0.50, 2.44, 4.53, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.3.e', 'LV', 3.92, 24, 0.84, 2.17, 5.67, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.a', 'IM', 4.02, 24, 0.27, 3.47, 4.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.a', 'LV', 4.78, 24, 0.31, 4.13, 5.43, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.b', 'IM', 2.38, 24, 0.22, 1.91, 2.84, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.b', 'LV', 3.57, 24, 0.29, 2.98, 4.17, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.c', 'IM', 3.10, 24, 0.25, 2.59, 3.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.c', 'LV', 4.25, 24, 0.15, 3.94, 4.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.d', 'IM', 3.43, 23, 0.31, 2.79, 4.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.d', 'LV', 4.24, 23, 0.40, 3.42, 5.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.e', 'IM', 2.04, 23, 0.25, 1.51, 2.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.e', 'LV', 2.70, 23, 0.65, 1.35, 4.05, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.f', 'IM', 1.55, 23, 0.31, 1.00, 2.19, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.f', 'LV', 1.11, 23, 0.54, 0.00, 2.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.g', 'IM', 2.39, 23, 0.22, 1.94, 2.85, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.4.g', 'LV', 2.70, 23, 0.43, 1.81, 3.60, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.5.a', 'IM', 2.02, 24, 0.42, 1.15, 2.88, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.5.a', 'LV', 1.92, 24, 0.68, 0.50, 3.34, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.5.b', 'IM', 1.54, 23, 0.21, 1.11, 1.97, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.5.b', 'LV', 1.25, 23, 0.50, 0.20, 2.30, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.6', 'IM', 3.59, 24, 0.22, 3.14, 4.05, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.6', 'LV', 4.39, 23, 0.52, 3.31, 5.46, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.a', 'IM', 3.41, 24, 0.28, 2.83, 3.99, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.a', 'LV', 3.50, 24, 0.44, 2.59, 4.42, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.b', 'IM', 1.22, 24, 0.13, 1.00, 1.50, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.b', 'LV', 0.38, 24, 0.23, 0.00, 0.86, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.c', 'IM', 1.02, 24, 0.01, 1.00, 1.04, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.c', 'LV', 0.03, 24, 0.02, 0.00, 0.07, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.d', 'IM', 1.09, 24, 0.08, 1.00, 1.25, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.d', 'LV', 0.13, 24, 0.09, 0.00, 0.31, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.e', 'IM', 1.48, 24, 0.32, 1.00, 2.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.7.e', 'LV', 0.53, 24, 0.32, 0.00, 1.20, 'Y', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.8.a', 'IM', 3.06, 24, 0.41, 2.21, 3.92, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.8.a', 'LV', 3.68, 24, 0.36, 2.93, 4.42, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.8.b', 'IM', 2.87, 24, 0.21, 2.43, 3.30, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.8.b', 'LV', 3.82, 24, 0.46, 2.87, 4.76, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.9.a', 'IM', 2.01, 24, 0.27, 1.46, 2.57, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.9.a', 'LV', 1.57, 24, 0.53, 0.48, 2.67, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.9.b', 'IM', 1.93, 24, 0.21, 1.50, 2.35, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.9.b', 'LV', 2.33, 24, 0.56, 1.17, 3.49, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.10', 'IM', 3.07, 24, 0.30, 2.46, 3.69, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.02', '2.C.10', 'LV', 3.61, 24, 0.46, 2.66, 4.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.a', 'IM', 3.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.a', 'LV', 4.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.b', 'IM', 2.53, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.b', 'LV', 3.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.c', 'IM', 2.79, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.c', 'LV', 3.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.d', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.d', 'LV', 3.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.e', 'IM', 3.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.e', 'LV', 4.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.f', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.1.f', 'LV', 3.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.a', 'LV', 4.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.b', 'IM', 3.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.2.b', 'LV', 4.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.a', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.a', 'LV', 3.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.b', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.b', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.c', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.c', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.d', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.d', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.e', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.3.e', 'LV', 4.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.a', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.a', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.b', 'IM', 2.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.b', 'LV', 3.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.c', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.c', 'LV', 3.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.d', 'IM', 4.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.d', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.e', 'IM', 2.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.e', 'LV', 2.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.f', 'IM', 2.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.f', 'LV', 2.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.g', 'IM', 2.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.4.g', 'LV', 2.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.a', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.a', 'LV', 1.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.b', 'IM', 1.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.5.b', 'LV', 1.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.6', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.6', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.a', 'IM', 3.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.a', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.b', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.b', 'LV', 1.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.c', 'IM', 1.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.c', 'LV', 0.50, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.d', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.d', 'LV', 1.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.e', 'IM', 1.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.7.e', 'LV', 1.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.a', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.a', 'LV', 2.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.b', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.8.b', 'LV', 3.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.a', 'IM', 2.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.a', 'LV', 1.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.b', 'IM', 2.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.9.b', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.10', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9013.03', '2.C.10', 'LV', 3.11, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'IM', 4.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.a', 'LV', 4.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'IM', 2.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.b', 'LV', 3.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'IM', 3.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.c', 'LV', 3.45, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'IM', 2.80, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.d', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.e', 'LV', 4.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.1.f', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.a', 'LV', 4.00, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'IM', 1.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.2.b', 'LV', 0.30, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'IM', 3.21, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.a', 'LV', 3.95, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'IM', 4.21, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.b', 'LV', 4.89, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'IM', 3.58, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.c', 'LV', 4.53, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'IM', 4.89, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.d', 'LV', 6.00, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'IM', 3.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.3.e', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.a', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'IM', 2.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.b', 'LV', 2.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'IM', 2.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.c', 'LV', 2.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.d', 'LV', 1.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'IM', 2.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.e', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'IM', 1.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.f', 'LV', 1.50, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'IM', 2.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.4.g', 'LV', 1.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.a', 'LV', 0.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'IM', 1.45, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.5.b', 'LV', 1.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.6', 'LV', 3.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'IM', 4.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.a', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.b', 'LV', 1.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'IM', 1.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.c', 'LV', 0.20, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.d', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'IM', 1.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.7.e', 'LV', 0.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.a', 'LV', 4.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'IM', 3.00, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.8.b', 'LV', 3.60, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'IM', 2.35, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.a', 'LV', 1.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'IM', 2.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.9.b', 'LV', 2.70, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'IM', 2.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9021.00', '2.C.10', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'IM', 4.09, 26, 0.19, 3.70, 4.47, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.a', 'LV', 4.25, 26, 0.31, 3.61, 4.90, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'IM', 3.48, 26, 0.22, 3.02, 3.93, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.b', 'LV', 4.58, 26, 0.37, 3.82, 5.35, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'IM', 3.14, 26, 0.25, 2.62, 3.65, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.c', 'LV', 3.42, 26, 0.49, 2.41, 4.43, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'IM', 3.50, 26, 0.28, 2.94, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.d', 'LV', 3.42, 26, 0.44, 2.51, 4.32, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'IM', 4.48, 26, 0.21, 4.05, 4.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.e', 'LV', 5.88, 26, 0.34, 5.19, 6.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'IM', 3.53, 26, 0.26, 3.00, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.1.f', 'LV', 4.09, 26, 0.41, 3.24, 4.93, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'IM', 2.70, 26, 0.26, 2.17, 3.23, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.a', 'LV', 2.67, 25, 0.44, 1.77, 3.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'IM', 2.86, 25, 0.24, 2.37, 3.35, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.2.b', 'LV', 2.97, 25, 0.42, 2.10, 3.85, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'IM', 3.01, 27, 0.22, 2.56, 3.46, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.a', 'LV', 3.70, 27, 0.30, 3.10, 4.31, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'IM', 2.35, 27, 0.26, 1.83, 2.88, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.b', 'LV', 2.06, 27, 0.37, 1.30, 2.82, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'IM', 2.19, 27, 0.26, 1.65, 2.72, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.c', 'LV', 2.04, 26, 0.39, 1.25, 2.84, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'IM', 1.90, 27, 0.31, 1.26, 2.54, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.d', 'LV', 1.66, 27, 0.44, 0.76, 2.56, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'IM', 1.81, 24, 0.37, 1.05, 2.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.3.e', 'LV', 1.45, 26, 0.50, 0.42, 2.48, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'IM', 3.25, 27, 0.23, 2.78, 3.71, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.a', 'LV', 3.34, 27, 0.28, 2.76, 3.91, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'IM', 1.72, 27, 0.20, 1.31, 2.14, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.b', 'LV', 1.12, 27, 0.32, 0.47, 1.78, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'IM', 1.71, 27, 0.14, 1.43, 1.99, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.c', 'LV', 1.62, 26, 0.32, 0.96, 2.28, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'IM', 1.99, 25, 0.19, 1.59, 2.39, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.d', 'LV', 1.54, 26, 0.37, 0.78, 2.31, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'IM', 3.55, 26, 0.21, 3.11, 3.98, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.e', 'LV', 3.44, 26, 0.21, 3.02, 3.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'IM', 2.76, 27, 0.20, 2.34, 3.18, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.f', 'LV', 2.79, 27, 0.30, 2.16, 3.41, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'IM', 2.57, 25, 0.20, 2.16, 2.97, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.4.g', 'LV', 2.87, 26, 0.24, 2.36, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'IM', 2.49, 27, 0.26, 1.95, 3.04, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.a', 'LV', 2.65, 27, 0.23, 2.17, 3.14, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'IM', 2.35, 27, 0.22, 1.89, 2.81, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.5.b', 'LV', 2.83, 27, 0.31, 2.19, 3.46, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'IM', 4.28, 26, 0.18, 3.90, 4.66, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.6', 'LV', 4.24, 26, 0.41, 3.40, 5.09, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'IM', 3.89, 27, 0.29, 3.30, 4.49, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.a', 'LV', 3.84, 27, 0.32, 3.18, 4.50, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'IM', 2.06, 27, 0.27, 1.50, 2.63, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.b', 'LV', 1.81, 27, 0.61, 0.55, 3.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'IM', 2.18, 27, 0.18, 1.82, 2.54, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.c', 'LV', 2.26, 27, 0.30, 1.65, 2.87, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'IM', 1.97, 27, 0.16, 1.64, 2.30, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.d', 'LV', 2.08, 27, 0.30, 1.47, 2.69, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'IM', 2.20, 27, 0.18, 1.83, 2.58, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.7.e', 'LV', 2.88, 27, 0.31, 2.24, 3.52, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'IM', 3.55, 27, 0.30, 2.92, 4.17, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.a', 'LV', 3.42, 27, 0.35, 2.71, 4.13, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'IM', 2.33, 27, 0.19, 1.95, 2.72, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.8.b', 'LV', 2.34, 27, 0.31, 1.70, 2.99, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'IM', 1.84, 27, 0.22, 1.40, 2.29, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.a', 'LV', 0.81, 27, 0.24, 0.31, 1.31, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'IM', 2.77, 26, 0.24, 2.27, 3.26, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.9.b', 'LV', 2.53, 26, 0.35, 1.81, 3.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'IM', 2.38, 27, 0.26, 1.84, 2.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9031.00', '2.C.10', 'LV', 2.06, 27, 0.43, 1.17, 2.95, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'IM', 4.52, 26, 0.19, 4.13, 4.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.a', 'LV', 4.81, 26, 0.21, 4.38, 5.24, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'IM', 2.80, 26, 0.29, 2.20, 3.39, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.b', 'LV', 3.61, 26, 0.58, 2.43, 4.80, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'IM', 2.74, 26, 0.36, 2.00, 3.48, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.c', 'LV', 2.23, 26, 0.50, 1.20, 3.25, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'IM', 2.46, 26, 0.40, 1.64, 3.27, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.d', 'LV', 2.50, 26, 0.57, 1.32, 3.68, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'IM', 4.19, 25, 0.29, 3.59, 4.79, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.e', 'LV', 5.59, 26, 0.19, 5.21, 5.98, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'IM', 4.22, 25, 0.15, 3.90, 4.54, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.1.f', 'LV', 4.91, 26, 0.12, 4.67, 5.16, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'IM', 1.72, 26, 0.22, 1.27, 2.17, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.a', 'LV', 1.73, 26, 0.49, 0.73, 2.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'IM', 1.18, 25, 0.15, 1.00, 1.48, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.2.b', 'LV', 0.43, 26, 0.28, 0.00, 1.01, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'IM', 2.95, 26, 0.29, 2.36, 3.54, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.a', 'LV', 3.42, 26, 0.48, 2.43, 4.42, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'IM', 1.78, 26, 0.20, 1.37, 2.18, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.b', 'LV', 1.86, 26, 0.47, 0.89, 2.83, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'IM', 2.14, 26, 0.30, 1.52, 2.76, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.c', 'LV', 2.27, 26, 0.54, 1.17, 3.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'IM', 2.18, 26, 0.31, 1.56, 2.81, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.d', 'LV', 1.87, 26, 0.47, 0.90, 2.84, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'IM', 1.79, 26, 0.23, 1.32, 2.27, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.3.e', 'LV', 1.26, 26, 0.39, 0.45, 2.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'IM', 3.44, 26, 0.23, 2.97, 3.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.a', 'LV', 3.95, 26, 0.28, 3.37, 4.53, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'IM', 1.41, 25, 0.19, 1.02, 1.81, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.b', 'LV', 0.83, 25, 0.38, 0.04, 1.62, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'IM', 1.47, 26, 0.18, 1.09, 1.85, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.c', 'LV', 0.92, 26, 0.37, 0.15, 1.69, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'IM', 1.59, 25, 0.23, 1.12, 2.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.d', 'LV', 1.10, 26, 0.39, 0.29, 1.91, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'IM', 3.53, 26, 0.27, 2.98, 4.08, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.e', 'LV', 4.71, 26, 0.31, 4.07, 5.34, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'IM', 2.80, 26, 0.22, 2.34, 3.26, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.f', 'LV', 3.57, 26, 0.24, 3.07, 4.06, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'IM', 2.13, 26, 0.24, 1.63, 2.62, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.4.g', 'LV', 2.71, 26, 0.55, 1.57, 3.85, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'IM', 1.90, 25, 0.21, 1.46, 2.34, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.a', 'LV', 1.65, 25, 0.36, 0.92, 2.39, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'IM', 2.82, 25, 0.36, 2.07, 3.57, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.5.b', 'LV', 3.68, 25, 0.65, 2.34, 5.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'IM', 4.29, 25, 0.27, 3.74, 4.84, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.6', 'LV', 5.85, 25, 0.39, 5.04, 6.67, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'IM', 4.50, 25, 0.20, 4.09, 4.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.a', 'LV', 5.02, 25, 0.38, 4.24, 5.79, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'IM', 1.99, 26, 0.36, 1.25, 2.74, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.b', 'LV', 1.40, 26, 0.42, 0.53, 2.27, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'IM', 2.20, 26, 0.36, 1.45, 2.94, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.c', 'LV', 1.96, 26, 0.55, 0.84, 3.08, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'IM', 2.38, 26, 0.22, 1.93, 2.83, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.d', 'LV', 3.24, 26, 0.42, 2.38, 4.10, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'IM', 2.94, 26, 0.38, 2.15, 3.73, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.7.e', 'LV', 3.67, 26, 0.57, 2.50, 4.83, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'IM', 3.45, 25, 0.43, 2.58, 4.33, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.a', 'LV', 3.10, 26, 0.50, 2.07, 4.14, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'IM', 3.87, 25, 0.20, 3.45, 4.29, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.8.b', 'LV', 3.41, 26, 0.21, 2.98, 3.84, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'IM', 2.18, 26, 0.32, 1.52, 2.84, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.a', 'LV', 1.66, 26, 0.41, 0.81, 2.52, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'IM', 2.78, 26, 0.32, 2.13, 3.44, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.9.b', 'LV', 2.58, 26, 0.38, 1.80, 3.35, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'IM', 2.21, 26, 0.32, 1.54, 2.87, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9032.00', '2.C.10', 'LV', 1.95, 26, 0.44, 1.04, 2.85, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'IM', 4.16, 40, 0.24, 3.69, 4.64, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.a', 'LV', 4.31, 40, 0.45, 3.41, 5.21, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'IM', 3.27, 39, 0.19, 2.88, 3.66, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.b', 'LV', 4.41, 40, 0.30, 3.79, 5.02, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'IM', 2.68, 40, 0.17, 2.34, 3.03, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.c', 'LV', 2.79, 40, 0.28, 2.22, 3.36, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'IM', 2.85, 38, 0.22, 2.40, 3.30, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.d', 'LV', 3.26, 39, 0.37, 2.52, 4.01, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'IM', 4.06, 38, 0.22, 3.62, 4.50, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.e', 'LV', 5.16, 40, 0.28, 4.59, 5.72, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'IM', 3.39, 40, 0.19, 2.99, 3.78, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.1.f', 'LV', 4.35, 40, 0.29, 3.76, 4.94, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'IM', 1.88, 40, 0.30, 1.28, 2.48, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.a', 'LV', 1.60, 39, 0.40, 0.78, 2.41, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'IM', 1.19, 40, 0.15, 1.00, 1.49, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.2.b', 'LV', 0.28, 40, 0.21, 0.00, 0.71, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'IM', 3.22, 40, 0.24, 2.73, 3.71, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.a', 'LV', 4.13, 40, 0.32, 3.48, 4.79, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'IM', 1.87, 40, 0.28, 1.31, 2.43, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.b', 'LV', 1.34, 40, 0.41, 0.52, 2.17, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'IM', 1.86, 39, 0.23, 1.41, 2.32, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.c', 'LV', 1.44, 39, 0.38, 0.68, 2.20, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'IM', 1.21, 40, 0.07, 1.06, 1.36, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.d', 'LV', 0.47, 39, 0.20, 0.07, 0.88, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'IM', 1.18, 40, 0.14, 1.00, 1.47, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.3.e', 'LV', 0.32, 40, 0.24, 0.00, 0.81, 'Y', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'IM', 3.08, 39, 0.21, 2.66, 3.50, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.a', 'LV', 3.97, 39, 0.30, 3.37, 4.58, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'IM', 1.42, 40, 0.16, 1.09, 1.75, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.b', 'LV', 0.82, 40, 0.33, 0.16, 1.48, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'IM', 1.18, 40, 0.08, 1.02, 1.35, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.c', 'LV', 0.50, 40, 0.25, 0.00, 1.01, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'IM', 1.50, 40, 0.21, 1.07, 1.93, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.d', 'LV', 0.80, 40, 0.33, 0.13, 1.46, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'IM', 3.06, 40, 0.23, 2.59, 3.54, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.e', 'LV', 3.70, 40, 0.34, 3.01, 4.38, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'IM', 2.43, 40, 0.24, 1.94, 2.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.f', 'LV', 2.77, 40, 0.43, 1.90, 3.63, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'IM', 1.63, 40, 0.14, 1.34, 1.92, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.4.g', 'LV', 1.76, 40, 0.39, 0.97, 2.54, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'IM', 1.40, 37, 0.13, 1.14, 1.66, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.a', 'LV', 0.77, 38, 0.28, 0.21, 1.33, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'IM', 2.87, 36, 0.29, 2.28, 3.45, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.5.b', 'LV', 3.46, 37, 0.39, 2.66, 4.26, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'IM', 4.13, 38, 0.21, 3.71, 4.55, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.6', 'LV', 5.53, 38, 0.33, 4.86, 6.19, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'IM', 4.33, 38, 0.15, 4.03, 4.64, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.a', 'LV', 5.22, 38, 0.23, 4.75, 5.69, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'IM', 1.61, 40, 0.15, 1.30, 1.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.b', 'LV', 1.07, 40, 0.25, 0.58, 1.57, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'IM', 1.58, 40, 0.16, 1.25, 1.91, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.c', 'LV', 0.96, 40, 0.21, 0.54, 1.37, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'IM', 1.63, 40, 0.20, 1.22, 2.03, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.d', 'LV', 1.29, 40, 0.37, 0.54, 2.03, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'IM', 2.44, 40, 0.26, 1.91, 2.97, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.7.e', 'LV', 3.08, 40, 0.51, 2.06, 4.10, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'IM', 2.47, 39, 0.15, 2.16, 2.78, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.a', 'LV', 2.48, 39, 0.23, 2.02, 2.95, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'IM', 2.83, 39, 0.24, 2.34, 3.32, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.8.b', 'LV', 2.89, 39, 0.25, 2.38, 3.39, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'IM', 1.96, 37, 0.21, 1.53, 2.39, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.a', 'LV', 1.59, 39, 0.35, 0.88, 2.30, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'IM', 3.20, 38, 0.18, 2.84, 3.56, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.9.b', 'LV', 3.26, 39, 0.31, 2.64, 3.88, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'IM', 1.74, 40, 0.19, 1.35, 2.13, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9033.00', '2.C.10', 'LV', 1.62, 40, 0.36, 0.89, 2.35, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.a', 'IM', 4.05, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.a', 'LV', 4.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.b', 'IM', 3.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.b', 'LV', 4.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.c', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.c', 'LV', 2.82, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.d', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.d', 'LV', 3.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.e', 'IM', 4.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.e', 'LV', 5.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.f', 'IM', 3.19, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.1.f', 'LV', 3.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.2.a', 'IM', 2.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.2.a', 'LV', 2.45, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.2.b', 'IM', 1.05, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.2.b', 'LV', 0.23, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.a', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.a', 'LV', 4.95, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.b', 'IM', 2.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.b', 'LV', 1.86, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.c', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.c', 'LV', 3.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.d', 'LV', 0.64, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.e', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.3.e', 'LV', 1.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.a', 'IM', 2.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.a', 'LV', 3.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.b', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.b', 'LV', 0.50, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.c', 'IM', 1.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.c', 'LV', 0.32, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.d', 'IM', 1.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.d', 'LV', 0.14, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.e', 'IM', 2.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.e', 'LV', 2.77, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.f', 'IM', 2.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.f', 'LV', 2.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.g', 'IM', 1.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.4.g', 'LV', 1.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.5.a', 'IM', 1.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.5.a', 'LV', 0.23, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.5.b', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.5.b', 'LV', 1.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.6', 'IM', 4.77, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.6', 'LV', 6.27, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.a', 'IM', 4.14, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.a', 'LV', 5.27, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.b', 'IM', 1.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.b', 'LV', 1.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.c', 'IM', 1.50, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.c', 'LV', 1.00, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.d', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.d', 'LV', 0.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.e', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.7.e', 'LV', 1.68, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.8.a', 'IM', 1.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.8.a', 'LV', 1.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.8.b', 'IM', 1.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.8.b', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.9.a', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.9.a', 'LV', 3.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.9.b', 'IM', 4.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.9.b', 'LV', 4.73, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.10', 'IM', 1.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.01', '2.C.10', 'LV', 0.82, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.a', 'IM', 3.88, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.a', 'LV', 4.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.b', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.b', 'LV', 4.12, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.c', 'IM', 2.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.c', 'LV', 2.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.d', 'IM', 3.46, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.d', 'LV', 4.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.e', 'IM', 4.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.e', 'LV', 4.75, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.f', 'IM', 3.12, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.1.f', 'LV', 3.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.2.a', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.2.a', 'LV', 1.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.2.b', 'IM', 1.75, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.2.b', 'LV', 1.29, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.a', 'IM', 2.71, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.a', 'LV', 3.25, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.b', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.b', 'LV', 1.17, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.c', 'IM', 1.58, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.c', 'LV', 0.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.d', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.d', 'LV', 0.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.e', 'IM', 1.57, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.3.e', 'LV', 1.26, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.a', 'IM', 2.43, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.a', 'LV', 3.04, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.b', 'IM', 1.74, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.b', 'LV', 1.09, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.c', 'IM', 1.65, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.c', 'LV', 1.43, 23, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.d', 'IM', 2.71, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.d', 'LV', 2.83, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.e', 'IM', 3.62, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.e', 'LV', 4.25, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.f', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.f', 'LV', 2.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.g', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.4.g', 'LV', 0.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.5.a', 'IM', 2.74, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.5.a', 'LV', 2.50, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.5.b', 'IM', 2.71, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.5.b', 'LV', 2.88, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.6', 'IM', 3.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.6', 'LV', 4.92, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.a', 'IM', 3.92, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.a', 'LV', 4.21, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.b', 'IM', 1.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.b', 'LV', 0.75, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.c', 'IM', 1.50, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.c', 'LV', 1.04, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.d', 'IM', 1.33, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.d', 'LV', 0.58, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.e', 'IM', 1.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.7.e', 'LV', 1.79, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.8.a', 'IM', 2.67, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.8.a', 'LV', 2.62, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.8.b', 'IM', 2.29, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.8.b', 'LV', 2.25, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.9.a', 'IM', 2.00, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.9.a', 'LV', 1.25, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.9.b', 'IM', 3.17, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.9.b', 'LV', 3.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.10', 'IM', 1.79, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9039.02', '2.C.10', 'LV', 1.33, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'IM', 3.89, 23, 0.14, 3.61, 4.17, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.a', 'LV', 4.46, 23, 0.16, 4.13, 4.79, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'IM', 3.16, 23, 0.20, 2.75, 3.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.b', 'LV', 4.22, 23, 0.19, 3.81, 4.62, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'IM', 2.85, 23, 0.19, 2.46, 3.24, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.c', 'LV', 2.92, 23, 0.19, 2.53, 3.32, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'IM', 2.82, 22, 0.45, 1.88, 3.75, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.d', 'LV', 3.08, 23, 0.70, 1.63, 4.52, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'IM', 3.82, 22, 0.36, 3.07, 4.57, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.e', 'LV', 5.21, 22, 0.34, 4.51, 5.92, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'IM', 2.77, 23, 0.16, 2.43, 3.12, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.1.f', 'LV', 3.78, 23, 0.23, 3.30, 4.26, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'IM', 3.21, 22, 0.29, 2.61, 3.80, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.a', 'LV', 4.13, 23, 0.40, 3.30, 4.95, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'IM', 1.03, 22, 0.03, 1.00, 1.10, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.2.b', 'LV', 0.08, 23, 0.06, 0.00, 0.21, 'Y', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'IM', 3.38, 23, 0.24, 2.89, 3.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.a', 'LV', 4.48, 23, 0.35, 3.76, 5.20, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'IM', 4.29, 23, 0.39, 3.48, 5.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.b', 'LV', 5.35, 23, 0.69, 3.92, 6.79, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'IM', 4.32, 23, 0.34, 3.62, 5.00, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.c', 'LV', 5.45, 23, 0.56, 4.29, 6.60, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'IM', 3.02, 23, 0.75, 1.46, 4.58, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.d', 'LV', 3.59, 23, 1.20, 1.09, 6.08, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'IM', 3.66, 23, 0.41, 2.81, 4.51, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.3.e', 'LV', 3.93, 23, 0.61, 2.68, 5.19, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'IM', 3.92, 23, 0.14, 3.64, 4.21, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.a', 'LV', 4.91, 23, 0.21, 4.48, 5.35, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'IM', 3.18, 23, 0.26, 2.64, 3.72, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.b', 'LV', 3.89, 23, 0.46, 2.94, 4.83, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'IM', 2.39, 23, 0.24, 1.90, 2.88, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.c', 'LV', 2.92, 23, 0.28, 2.34, 3.50, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'IM', 1.58, 23, 0.14, 1.30, 1.87, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.d', 'LV', 1.46, 23, 0.33, 0.77, 2.15, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'IM', 1.86, 23, 0.18, 1.50, 2.22, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.e', 'LV', 1.93, 23, 0.39, 1.12, 2.75, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'IM', 1.66, 23, 0.15, 1.35, 1.97, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.f', 'LV', 1.45, 23, 0.33, 0.76, 2.14, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'IM', 2.27, 23, 0.30, 1.65, 2.89, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.4.g', 'LV', 3.08, 23, 0.73, 1.56, 4.59, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'IM', 1.52, 22, 0.21, 1.09, 1.95, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.a', 'LV', 1.06, 22, 0.41, 0.21, 1.91, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'IM', 1.30, 23, 0.17, 1.00, 1.65, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.5.b', 'LV', 0.56, 23, 0.31, 0.00, 1.19, 'Y', 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'IM', 2.40, 23, 0.12, 2.16, 2.65, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.6', 'LV', 3.54, 23, 0.23, 3.06, 4.02, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'IM', 3.87, 23, 0.14, 3.57, 4.17, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.a', 'LV', 4.33, 23, 0.18, 3.95, 4.71, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'IM', 1.68, 23, 0.12, 1.43, 1.94, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.b', 'LV', 1.17, 23, 0.28, 0.58, 1.76, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'IM', 1.85, 23, 0.56, 1.00, 3.02, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.c', 'LV', 1.82, 23, 1.21, 0.00, 4.33, 'Y', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'IM', 1.57, 23, 0.13, 1.30, 1.84, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.d', 'LV', 1.13, 23, 0.23, 0.65, 1.61, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'IM', 1.61, 23, 0.11, 1.37, 1.84, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.7.e', 'LV', 1.39, 23, 0.26, 0.84, 1.93, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'IM', 3.06, 23, 0.21, 2.63, 3.49, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.a', 'LV', 3.43, 23, 0.31, 2.79, 4.06, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'IM', 2.94, 22, 0.16, 2.61, 3.27, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.8.b', 'LV', 3.36, 23, 0.23, 2.89, 3.84, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'IM', 2.39, 23, 0.24, 1.89, 2.88, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.a', 'LV', 2.28, 23, 0.35, 1.57, 3.00, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'IM', 2.36, 22, 0.13, 2.08, 2.64, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.9.b', 'LV', 2.45, 23, 0.20, 2.03, 2.87, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'IM', 2.53, 22, 0.19, 2.14, 2.93, 'N', NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.00', '2.C.10', 'LV', 2.59, 22, 0.26, 2.06, 3.12, 'N', 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.a', 'IM', 3.07, 32, 0.37, 2.31, 3.83, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.a', 'LV', 3.61, 33, 0.58, 2.42, 4.79, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.b', 'IM', 2.47, 33, 0.13, 2.20, 2.74, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.b', 'LV', 3.82, 33, 0.27, 3.27, 4.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.c', 'IM', 2.30, 33, 0.30, 1.70, 2.91, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.c', 'LV', 2.09, 33, 0.34, 1.39, 2.78, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.d', 'IM', 2.29, 33, 0.55, 1.16, 3.42, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.d', 'LV', 1.93, 33, 0.76, 0.39, 3.47, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.e', 'IM', 2.94, 33, 0.34, 2.25, 3.63, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.e', 'LV', 3.11, 33, 0.59, 1.90, 4.32, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.f', 'IM', 2.27, 33, 0.17, 1.92, 2.63, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.1.f', 'LV', 2.46, 33, 0.41, 1.63, 3.29, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.a', 'IM', 3.39, 32, 0.43, 2.51, 4.26, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.a', 'LV', 3.90, 31, 0.72, 2.42, 5.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.b', 'IM', 1.39, 32, 0.16, 1.07, 1.70, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.2.b', 'LV', 0.90, 32, 0.34, 0.21, 1.58, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.a', 'IM', 3.25, 33, 0.21, 2.82, 3.68, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.a', 'LV', 4.42, 33, 0.09, 4.24, 4.60, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.b', 'IM', 3.94, 32, 0.28, 3.37, 4.50, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.b', 'LV', 4.72, 32, 0.28, 4.15, 5.28, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.c', 'IM', 2.56, 33, 0.31, 1.94, 3.19, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.c', 'LV', 2.51, 33, 0.46, 1.57, 3.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.d', 'IM', 2.62, 33, 0.46, 1.67, 3.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.d', 'LV', 3.05, 33, 0.72, 1.58, 4.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.e', 'IM', 3.21, 33, 0.52, 2.16, 4.27, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.3.e', 'LV', 3.86, 33, 0.74, 2.36, 5.36, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.a', 'IM', 3.57, 32, 0.20, 3.16, 3.98, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.a', 'LV', 4.91, 33, 0.13, 4.65, 5.16, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.b', 'IM', 2.85, 32, 0.19, 2.47, 3.23, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.b', 'LV', 3.71, 33, 0.27, 3.16, 4.27, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.c', 'IM', 4.03, 32, 0.19, 3.65, 4.41, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.c', 'LV', 4.89, 33, 0.17, 4.55, 5.23, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.d', 'IM', 2.68, 33, 0.59, 1.47, 3.89, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.d', 'LV', 2.70, 33, 0.88, 0.90, 4.50, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.e', 'IM', 1.63, 33, 0.21, 1.21, 2.05, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.e', 'LV', 1.29, 33, 0.46, 0.36, 2.21, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.f', 'IM', 1.26, 33, 0.11, 1.03, 1.49, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.f', 'LV', 0.48, 33, 0.22, 0.04, 0.92, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.g', 'IM', 1.99, 32, 0.40, 1.18, 2.81, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.4.g', 'LV', 2.06, 33, 0.69, 0.65, 3.47, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.a', 'IM', 1.21, 33, 0.10, 1.01, 1.41, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.a', 'LV', 0.51, 33, 0.23, 0.05, 0.97, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.b', 'IM', 1.22, 33, 0.10, 1.02, 1.43, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.5.b', 'LV', 0.55, 33, 0.25, 0.05, 1.05, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.6', 'IM', 2.52, 33, 0.14, 2.23, 2.81, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.6', 'LV', 3.21, 33, 0.26, 2.69, 3.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.a', 'IM', 4.07, 33, 0.34, 3.38, 4.75, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.a', 'LV', 3.98, 33, 0.23, 3.51, 4.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.b', 'IM', 1.15, 32, 0.07, 1.00, 1.30, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.b', 'LV', 0.31, 32, 0.17, 0.00, 0.64, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.c', 'IM', 1.02, 32, 0.02, 1.00, 1.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.c', 'LV', 0.04, 32, 0.04, 0.00, 0.12, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.d', 'IM', 1.05, 32, 0.03, 1.00, 1.11, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.d', 'LV', 0.09, 32, 0.06, 0.00, 0.20, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.e', 'IM', 1.12, 32, 0.06, 1.00, 1.25, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.7.e', 'LV', 0.22, 32, 0.13, 0.00, 0.48, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.a', 'IM', 2.77, 32, 0.34, 2.08, 3.46, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.a', 'LV', 2.86, 32, 0.48, 1.88, 3.84, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.b', 'IM', 2.20, 33, 0.36, 1.47, 2.93, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.8.b', 'LV', 2.13, 33, 0.60, 0.92, 3.35, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.a', 'IM', 1.68, 33, 0.14, 1.40, 1.97, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.a', 'LV', 1.29, 33, 0.23, 0.82, 1.76, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.b', 'IM', 2.28, 33, 0.25, 1.76, 2.79, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.9.b', 'LV', 2.25, 33, 0.26, 1.72, 2.78, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.10', 'IM', 2.14, 33, 0.22, 1.69, 2.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9041.01', '2.C.10', 'LV', 2.31, 33, 0.28, 1.74, 2.88, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'IM', 4.38, 30, 0.21, 3.95, 4.82, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.a', 'LV', 3.96, 29, 0.38, 3.18, 4.74, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'IM', 3.27, 30, 0.29, 2.67, 3.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.b', 'LV', 3.52, 29, 0.65, 2.19, 4.84, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'IM', 3.08, 30, 0.42, 2.22, 3.93, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.c', 'LV', 3.07, 30, 0.76, 1.52, 4.61, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'IM', 3.33, 30, 0.33, 2.65, 4.01, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.d', 'LV', 3.63, 30, 0.50, 2.61, 4.66, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'IM', 4.62, 30, 0.17, 4.27, 4.98, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.e', 'LV', 4.79, 30, 0.18, 4.41, 5.17, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'IM', 3.84, 30, 0.29, 3.24, 4.44, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.1.f', 'LV', 3.52, 30, 0.47, 2.56, 4.49, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'IM', 3.70, 29, 0.36, 2.97, 4.43, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.a', 'LV', 3.86, 30, 0.33, 3.19, 4.53, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'IM', 3.70, 30, 0.31, 3.07, 4.33, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.2.b', 'LV', 3.82, 30, 0.44, 2.92, 4.72, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'IM', 2.58, 30, 0.26, 2.06, 3.11, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.a', 'LV', 3.10, 30, 0.37, 2.35, 3.86, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'IM', 1.67, 29, 0.30, 1.07, 2.28, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.b', 'LV', 1.27, 29, 0.43, 0.38, 2.15, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'IM', 1.59, 30, 0.17, 1.25, 1.94, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.c', 'LV', 1.36, 30, 0.46, 0.42, 2.30, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'IM', 1.76, 30, 0.30, 1.16, 2.37, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.d', 'LV', 1.53, 30, 0.54, 0.42, 2.64, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'IM', 2.20, 30, 0.43, 1.32, 3.08, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.3.e', 'LV', 2.07, 30, 0.61, 0.83, 3.31, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'IM', 3.57, 30, 0.22, 3.11, 4.02, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.a', 'LV', 3.39, 30, 0.27, 2.85, 3.93, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'IM', 1.35, 30, 0.17, 1.00, 1.70, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.b', 'LV', 0.87, 30, 0.49, 0.00, 1.86, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'IM', 2.15, 29, 0.33, 1.47, 2.83, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.c', 'LV', 1.95, 30, 0.49, 0.95, 2.95, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'IM', 1.58, 28, 0.20, 1.18, 1.99, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.d', 'LV', 1.29, 27, 0.47, 0.32, 2.25, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'IM', 2.93, 28, 0.53, 1.85, 4.02, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.e', 'LV', 2.85, 28, 0.73, 1.35, 4.35, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'IM', 1.94, 28, 0.35, 1.22, 2.66, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.f', 'LV', 1.51, 28, 0.55, 0.38, 2.64, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'IM', 1.93, 28, 0.29, 1.34, 2.52, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.4.g', 'LV', 1.21, 28, 0.35, 0.49, 1.93, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'IM', 1.57, 30, 0.15, 1.25, 1.88, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.a', 'LV', 1.29, 30, 0.42, 0.43, 2.16, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'IM', 2.37, 30, 0.53, 1.30, 3.45, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.5.b', 'LV', 2.27, 30, 0.66, 0.92, 3.63, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'IM', 3.70, 30, 0.35, 2.99, 4.42, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.6', 'LV', 4.36, 30, 0.39, 3.57, 5.15, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'IM', 3.97, 30, 0.32, 3.31, 4.62, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.a', 'LV', 3.39, 30, 0.27, 2.84, 3.94, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'IM', 2.31, 29, 0.23, 1.84, 2.79, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.b', 'LV', 1.68, 29, 0.42, 0.82, 2.54, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'IM', 1.34, 29, 0.23, 1.00, 1.82, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.c', 'LV', 0.43, 29, 0.26, 0.00, 0.97, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'IM', 1.64, 29, 0.24, 1.14, 2.15, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.d', 'LV', 1.06, 29, 0.47, 0.10, 2.02, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'IM', 1.73, 29, 0.28, 1.16, 2.29, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.7.e', 'LV', 1.54, 29, 0.50, 0.51, 2.56, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'IM', 3.36, 29, 0.35, 2.64, 4.09, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.a', 'LV', 3.26, 30, 0.40, 2.44, 4.07, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'IM', 2.56, 30, 0.23, 2.09, 3.03, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.8.b', 'LV', 2.41, 30, 0.31, 1.78, 3.05, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'IM', 2.26, 30, 0.27, 1.71, 2.81, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.a', 'LV', 1.26, 30, 0.38, 0.47, 2.04, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'IM', 2.70, 30, 0.36, 1.97, 3.44, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.9.b', 'LV', 2.11, 30, 0.32, 1.45, 2.76, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'IM', 2.65, 29, 0.41, 1.81, 3.49, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9051.00', '2.C.10', 'LV', 1.69, 28, 0.38, 0.90, 2.47, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.a', 'IM', 4.04, 18, 0.20, 3.61, 4.47, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.a', 'LV', 4.13, 18, 0.26, 3.58, 4.67, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.b', 'IM', 3.55, 18, 0.34, 2.83, 4.27, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.b', 'LV', 4.45, 18, 0.63, 3.12, 5.79, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.c', 'IM', 3.05, 18, 0.30, 2.42, 3.69, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.c', 'LV', 2.84, 18, 0.34, 2.12, 3.56, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.d', 'IM', 2.91, 18, 0.28, 2.33, 3.50, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.d', 'LV', 2.79, 18, 0.36, 2.03, 3.56, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.e', 'IM', 4.74, 18, 0.16, 4.41, 5.00, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.e', 'LV', 5.70, 18, 0.38, 4.89, 6.51, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.f', 'IM', 3.15, 18, 0.40, 2.32, 3.99, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.1.f', 'LV', 3.97, 18, 0.29, 3.36, 4.58, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.2.a', 'IM', 2.11, 18, 0.38, 1.30, 2.92, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.2.a', 'LV', 1.81, 18, 0.56, 0.63, 2.99, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.2.b', 'IM', 1.00, 17, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.2.b', 'LV', 0.00, 17, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.a', 'IM', 3.52, 18, 0.31, 2.87, 4.16, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.a', 'LV', 3.88, 18, 0.31, 3.23, 4.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.b', 'IM', 1.56, 17, 0.17, 1.19, 1.93, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.b', 'LV', 1.06, 17, 0.39, 0.23, 1.89, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.c', 'IM', 1.51, 18, 0.16, 1.18, 1.85, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.c', 'LV', 1.20, 18, 0.42, 0.32, 2.07, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.d', 'IM', 1.57, 17, 0.25, 1.05, 2.09, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.d', 'LV', 1.33, 17, 0.52, 0.23, 2.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.e', 'IM', 1.65, 18, 0.22, 1.19, 2.11, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.3.e', 'LV', 1.43, 18, 0.48, 0.43, 2.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.a', 'IM', 2.74, 17, 0.28, 2.14, 3.34, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.a', 'LV', 3.04, 18, 0.24, 2.53, 3.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.b', 'IM', 1.31, 17, 0.14, 1.01, 1.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.b', 'LV', 0.53, 17, 0.24, 0.01, 1.05, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.c', 'IM', 2.80, 18, 0.28, 2.21, 3.39, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.c', 'LV', 3.49, 18, 0.49, 2.45, 4.53, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.d', 'IM', 2.45, 18, 0.29, 1.83, 3.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.d', 'LV', 2.66, 18, 0.42, 1.77, 3.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.e', 'IM', 3.36, 18, 0.24, 2.86, 3.86, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.e', 'LV', 4.61, 18, 0.18, 4.23, 4.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.f', 'IM', 2.82, 18, 0.29, 2.20, 3.43, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.f', 'LV', 2.92, 18, 0.55, 1.75, 4.08, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.g', 'IM', 1.76, 17, 0.21, 1.33, 2.20, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.4.g', 'LV', 2.48, 17, 0.65, 1.10, 3.85, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.5.a', 'IM', 2.53, 17, 0.35, 1.78, 3.28, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.5.a', 'LV', 2.29, 17, 0.48, 1.27, 3.31, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.5.b', 'IM', 2.75, 17, 0.46, 1.77, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.5.b', 'LV', 2.88, 17, 0.67, 1.46, 4.30, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.6', 'IM', 3.26, 17, 0.34, 2.54, 3.97, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.6', 'LV', 4.33, 17, 0.51, 3.24, 5.41, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.a', 'IM', 3.93, 17, 0.19, 3.52, 4.34, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.a', 'LV', 4.20, 17, 0.29, 3.60, 4.81, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.b', 'IM', 1.44, 18, 0.18, 1.06, 1.82, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.b', 'LV', 0.82, 18, 0.36, 0.06, 1.58, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.c', 'IM', 1.14, 18, 0.13, 1.00, 1.40, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.c', 'LV', 0.27, 18, 0.25, 0.00, 0.80, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.d', 'IM', 1.91, 18, 0.29, 1.31, 2.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.d', 'LV', 1.74, 18, 0.56, 0.56, 2.92, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.e', 'IM', 2.98, 18, 0.26, 2.44, 3.53, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.7.e', 'LV', 4.13, 18, 0.18, 3.75, 4.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.8.a', 'IM', 2.82, 18, 0.39, 1.99, 3.65, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.8.a', 'LV', 2.71, 18, 0.39, 1.89, 3.53, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.8.b', 'IM', 2.94, 18, 0.29, 2.32, 3.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.8.b', 'LV', 3.64, 18, 0.23, 3.15, 4.13, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.9.a', 'IM', 1.77, 18, 0.15, 1.45, 2.09, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.9.a', 'LV', 1.47, 18, 0.33, 0.78, 2.16, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.9.b', 'IM', 2.44, 18, 0.14, 2.14, 2.75, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.9.b', 'LV', 2.89, 18, 0.08, 2.72, 3.06, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.10', 'IM', 2.32, 18, 0.30, 1.69, 2.95, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9061.00', '2.C.10', 'LV', 2.18, 18, 0.42, 1.31, 3.06, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'IM', 4.05, 30, 0.12, 3.81, 4.29, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.a', 'LV', 5.02, 29, 0.21, 4.59, 5.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'IM', 3.31, 30, 0.14, 3.03, 3.59, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.b', 'LV', 4.05, 28, 0.30, 3.44, 4.66, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'IM', 3.19, 30, 0.20, 2.78, 3.59, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.c', 'LV', 3.55, 30, 0.38, 2.77, 4.33, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'IM', 3.19, 30, 0.29, 2.59, 3.79, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.d', 'LV', 3.54, 29, 0.41, 2.71, 4.38, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'IM', 4.61, 30, 0.12, 4.36, 4.86, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.e', 'LV', 5.46, 30, 0.18, 5.09, 5.82, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'IM', 3.16, 30, 0.20, 2.74, 3.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.1.f', 'LV', 3.78, 30, 0.32, 3.13, 4.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'IM', 2.54, 29, 0.16, 2.22, 2.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.a', 'LV', 2.90, 29, 0.32, 2.25, 3.55, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'IM', 1.74, 30, 0.16, 1.40, 2.07, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.2.b', 'LV', 1.26, 30, 0.26, 0.73, 1.79, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'IM', 3.54, 29, 0.17, 3.20, 3.89, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.a', 'LV', 4.35, 29, 0.23, 3.88, 4.82, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'IM', 1.93, 30, 0.22, 1.48, 2.39, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.b', 'LV', 1.85, 30, 0.41, 1.03, 2.68, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'IM', 1.92, 30, 0.20, 1.50, 2.33, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.c', 'LV', 2.11, 30, 0.38, 1.34, 2.89, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'IM', 1.53, 30, 0.14, 1.24, 1.82, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.d', 'LV', 1.14, 30, 0.30, 0.54, 1.75, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'IM', 2.18, 29, 0.21, 1.75, 2.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.3.e', 'LV', 2.33, 29, 0.38, 1.54, 3.11, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'IM', 3.84, 29, 0.14, 3.55, 4.14, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.a', 'LV', 3.99, 28, 0.23, 3.52, 4.45, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'IM', 1.35, 29, 0.16, 1.02, 1.68, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.b', 'LV', 0.79, 29, 0.34, 0.09, 1.49, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'IM', 1.35, 29, 0.13, 1.09, 1.61, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.c', 'LV', 0.88, 29, 0.31, 0.24, 1.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'IM', 1.17, 30, 0.10, 1.00, 1.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.d', 'LV', 0.42, 30, 0.24, 0.00, 0.91, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'IM', 2.95, 30, 0.25, 2.44, 3.45, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.e', 'LV', 3.72, 30, 0.39, 2.92, 4.52, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'IM', 2.29, 30, 0.17, 1.95, 2.63, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.f', 'LV', 2.10, 30, 0.28, 1.52, 2.67, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'IM', 1.61, 30, 0.19, 1.22, 1.99, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.4.g', 'LV', 1.32, 30, 0.37, 0.57, 2.08, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'IM', 1.35, 29, 0.11, 1.12, 1.58, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.a', 'LV', 0.64, 29, 0.20, 0.23, 1.05, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'IM', 1.80, 29, 0.19, 1.41, 2.20, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.5.b', 'LV', 1.79, 29, 0.41, 0.96, 2.63, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'IM', 3.14, 30, 0.14, 2.86, 3.42, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.6', 'LV', 4.25, 30, 0.27, 3.69, 4.80, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'IM', 3.56, 30, 0.15, 3.26, 3.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.a', 'LV', 3.86, 30, 0.16, 3.53, 4.18, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'IM', 1.96, 30, 0.15, 1.67, 2.26, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.b', 'LV', 1.54, 30, 0.25, 1.02, 2.06, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'IM', 1.21, 30, 0.10, 1.01, 1.41, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.c', 'LV', 0.44, 30, 0.20, 0.03, 0.86, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'IM', 1.46, 30, 0.16, 1.12, 1.80, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.d', 'LV', 0.93, 30, 0.33, 0.26, 1.60, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'IM', 1.53, 30, 0.13, 1.27, 1.79, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.7.e', 'LV', 1.36, 30, 0.30, 0.74, 1.98, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'IM', 3.20, 29, 0.26, 2.68, 3.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.a', 'LV', 3.14, 29, 0.32, 2.49, 3.79, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'IM', 3.29, 29, 0.17, 2.94, 3.65, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.8.b', 'LV', 3.19, 29, 0.25, 2.68, 3.70, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'IM', 2.21, 29, 0.15, 1.90, 2.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.a', 'LV', 1.91, 29, 0.24, 1.43, 2.40, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'IM', 2.39, 29, 0.14, 2.10, 2.67, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.9.b', 'LV', 2.65, 29, 0.25, 2.14, 3.17, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'IM', 1.70, 30, 0.18, 1.32, 2.08, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9071.00', '2.C.10', 'LV', 1.15, 30, 0.34, 0.45, 1.84, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'IM', 4.70, 15, 0.17, 4.32, 5.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.a', 'LV', 4.72, 15, 0.19, 4.31, 5.13, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'IM', 4.12, 15, 0.19, 3.70, 4.54, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.b', 'LV', 4.95, 15, 0.47, 3.95, 5.95, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'IM', 3.99, 15, 0.47, 2.99, 4.99, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.c', 'LV', 3.40, 15, 0.59, 2.13, 4.68, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'IM', 4.25, 15, 0.36, 3.49, 5.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.d', 'LV', 4.83, 15, 0.54, 3.67, 6.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'IM', 4.55, 15, 0.19, 4.13, 4.97, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.e', 'LV', 5.00, 15, 0.39, 4.18, 5.83, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'IM', 4.64, 15, 0.18, 4.26, 5.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.1.f', 'LV', 4.89, 15, 0.27, 4.31, 5.47, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'IM', 2.47, 15, 0.48, 1.44, 3.50, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.a', 'LV', 2.25, 15, 0.78, 0.57, 3.92, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'IM', 2.59, 15, 0.67, 1.15, 4.03, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.2.b', 'LV', 2.29, 15, 0.97, 0.20, 4.39, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'IM', 4.10, 14, 0.27, 3.51, 4.69, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.a', 'LV', 4.79, 15, 0.47, 3.77, 5.80, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'IM', 2.39, 15, 0.23, 1.90, 2.89, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.b', 'LV', 2.17, 14, 0.30, 1.53, 2.81, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'IM', 1.84, 15, 0.38, 1.03, 2.66, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.c', 'LV', 1.49, 15, 0.68, 0.04, 2.94, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'IM', 1.37, 15, 0.33, 1.00, 2.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.d', 'LV', 0.18, 15, 0.16, 0.00, 0.54, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'IM', 2.35, 15, 0.34, 1.63, 3.07, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.3.e', 'LV', 1.63, 15, 0.31, 0.96, 2.30, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'IM', 4.33, 15, 0.35, 3.57, 5.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.a', 'LV', 3.91, 15, 0.34, 3.19, 4.63, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'IM', 1.27, 15, 0.17, 1.00, 1.64, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.b', 'LV', 0.71, 15, 0.50, 0.00, 1.78, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'IM', 1.99, 15, 0.33, 1.29, 2.69, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.c', 'LV', 1.99, 15, 0.61, 0.68, 3.31, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'IM', 1.55, 15, 0.49, 1.00, 2.61, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.d', 'LV', 0.55, 15, 0.49, 0.00, 1.61, 'Y', 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'IM', 3.35, 15, 0.65, 1.95, 4.76, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.e', 'LV', 3.74, 15, 0.99, 1.62, 5.87, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'IM', 2.89, 14, 0.58, 1.63, 4.14, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.f', 'LV', 2.63, 14, 0.78, 0.94, 4.31, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'IM', 2.37, 15, 0.43, 1.45, 3.29, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.4.g', 'LV', 2.10, 15, 0.73, 0.53, 3.66, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'IM', 1.67, 15, 0.18, 1.29, 2.05, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.a', 'LV', 1.25, 15, 0.44, 0.30, 2.20, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'IM', 2.43, 15, 0.61, 1.12, 3.75, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.5.b', 'LV', 2.03, 15, 0.79, 0.33, 3.72, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'IM', 3.68, 15, 0.33, 2.97, 4.38, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.6', 'LV', 4.64, 15, 0.45, 3.68, 5.60, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'IM', 4.72, 15, 0.17, 4.35, 5.00, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.a', 'LV', 4.28, 15, 0.62, 2.96, 5.61, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'IM', 2.45, 15, 0.49, 1.39, 3.51, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.b', 'LV', 1.40, 15, 0.58, 0.17, 2.64, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'IM', 1.37, 15, 0.23, 1.00, 1.87, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.c', 'LV', 1.02, 15, 0.63, 0.00, 2.37, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'IM', 1.52, 15, 0.30, 1.00, 2.17, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.d', 'LV', 0.37, 15, 0.19, 0.00, 0.78, 'Y', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'IM', 2.15, 15, 0.42, 1.24, 3.05, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.7.e', 'LV', 2.55, 15, 0.76, 0.91, 4.19, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'IM', 3.96, 15, 0.25, 3.42, 4.50, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.a', 'LV', 3.56, 15, 0.34, 2.83, 4.29, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'IM', 2.86, 15, 0.29, 2.23, 3.48, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.8.b', 'LV', 2.83, 14, 0.54, 1.65, 4.00, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'IM', 2.94, 15, 0.46, 1.95, 3.93, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.a', 'LV', 2.52, 14, 0.87, 0.64, 4.39, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'IM', 3.63, 15, 0.31, 2.96, 4.29, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.9.b', 'LV', 3.45, 15, 0.52, 2.34, 4.56, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'IM', 2.66, 15, 0.51, 1.55, 3.76, 'N', NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9081.00', '2.C.10', 'LV', 2.00, 14, 0.61, 0.69, 3.31, 'N', 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'IM', 4.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.a', 'LV', 4.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.b', 'LV', 5.15, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'IM', 3.08, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.c', 'LV', 3.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'IM', 1.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.d', 'LV', 1.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'IM', 3.92, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.e', 'LV', 4.65, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'IM', 3.73, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.1.f', 'LV', 4.46, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'IM', 2.81, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.a', 'LV', 3.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'IM', 1.12, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.2.b', 'LV', 0.12, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'IM', 3.69, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.a', 'LV', 4.44, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'IM', 1.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.b', 'LV', 1.31, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'IM', 1.69, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.c', 'LV', 1.50, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'IM', 1.31, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.d', 'LV', 0.62, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'IM', 1.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.3.e', 'LV', 0.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'IM', 3.08, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.a', 'LV', 3.81, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'IM', 1.19, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.b', 'LV', 0.54, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'IM', 1.54, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.c', 'LV', 0.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'IM', 2.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.d', 'LV', 2.50, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'IM', 2.58, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.e', 'LV', 2.73, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'IM', 2.00, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.f', 'LV', 1.92, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'IM', 1.15, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.4.g', 'LV', 0.35, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.a', 'LV', 3.20, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'IM', 1.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.5.b', 'LV', 1.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'IM', 3.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.6', 'LV', 4.48, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'IM', 4.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.a', 'LV', 4.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'IM', 1.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.b', 'LV', 0.81, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'IM', 1.08, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.c', 'LV', 0.19, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'IM', 1.23, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.d', 'LV', 0.38, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'IM', 1.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.7.e', 'LV', 1.15, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'IM', 3.04, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.a', 'LV', 3.35, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'IM', 3.50, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.8.b', 'LV', 3.96, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'IM', 2.04, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.a', 'LV', 1.12, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'IM', 2.46, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.9.b', 'LV', 2.42, 26, NULL, NULL, NULL, NULL, 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'IM', 1.19, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9111.00', '2.C.10', 'LV', 0.46, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'IM', 3.89, 26, 0.17, 3.55, 4.24, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.a', 'LV', 4.24, 26, 0.18, 3.88, 4.61, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'IM', 2.95, 26, 0.28, 2.38, 3.52, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.b', 'LV', 3.62, 26, 0.33, 2.93, 4.31, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'IM', 2.22, 26, 0.21, 1.78, 2.67, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.c', 'LV', 2.09, 26, 0.35, 1.37, 2.81, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'IM', 2.27, 26, 0.26, 1.74, 2.80, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.d', 'LV', 2.37, 26, 0.40, 1.54, 3.19, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'IM', 3.60, 26, 0.23, 3.13, 4.06, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.e', 'LV', 4.61, 26, 0.32, 3.95, 5.26, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'IM', 2.99, 26, 0.28, 2.41, 3.56, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.1.f', 'LV', 3.40, 26, 0.30, 2.78, 4.03, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'IM', 2.44, 26, 0.29, 1.84, 3.03, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.a', 'LV', 2.56, 26, 0.42, 1.70, 3.41, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'IM', 1.17, 25, 0.09, 1.00, 1.36, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.2.b', 'LV', 0.47, 25, 0.27, 0.00, 1.03, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'IM', 3.02, 26, 0.22, 2.56, 3.48, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.a', 'LV', 3.88, 26, 0.27, 3.32, 4.44, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'IM', 2.82, 26, 0.29, 2.22, 3.43, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.b', 'LV', 3.07, 26, 0.41, 2.23, 3.91, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'IM', 2.23, 26, 0.24, 1.74, 2.73, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.c', 'LV', 2.56, 26, 0.42, 1.69, 3.43, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'IM', 1.81, 26, 0.20, 1.41, 2.22, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.d', 'LV', 1.79, 26, 0.44, 0.89, 2.70, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'IM', 2.07, 26, 0.18, 1.69, 2.45, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.3.e', 'LV', 2.50, 26, 0.31, 1.87, 3.13, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'IM', 3.51, 26, 0.22, 3.05, 3.96, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.a', 'LV', 4.38, 26, 0.26, 3.85, 4.91, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'IM', 2.23, 26, 0.26, 1.70, 2.75, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.b', 'LV', 2.33, 26, 0.42, 1.47, 3.20, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'IM', 3.07, 25, 0.36, 2.32, 3.82, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.c', 'LV', 4.20, 26, 0.44, 3.30, 5.10, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'IM', 3.33, 26, 0.26, 2.80, 3.87, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.d', 'LV', 4.15, 26, 0.42, 3.28, 5.01, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'IM', 2.49, 26, 0.25, 1.96, 3.01, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.e', 'LV', 2.91, 25, 0.43, 2.03, 3.80, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'IM', 1.99, 26, 0.18, 1.63, 2.35, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.f', 'LV', 1.71, 26, 0.32, 1.06, 2.37, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'IM', 2.85, 26, 0.41, 2.00, 3.70, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.4.g', 'LV', 3.55, 26, 0.57, 2.37, 4.73, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'IM', 1.55, 26, 0.26, 1.00, 2.09, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.a', 'LV', 0.83, 26, 0.29, 0.23, 1.43, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'IM', 1.30, 26, 0.10, 1.10, 1.50, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.5.b', 'LV', 0.76, 26, 0.25, 0.24, 1.28, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'IM', 2.62, 26, 0.28, 2.05, 3.19, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.6', 'LV', 3.81, 26, 0.41, 2.95, 4.66, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'IM', 3.87, 26, 0.24, 3.37, 4.37, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.a', 'LV', 4.57, 26, 0.35, 3.84, 5.30, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'IM', 1.18, 26, 0.09, 1.00, 1.36, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.b', 'LV', 0.31, 26, 0.11, 0.08, 0.54, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'IM', 1.07, 26, 0.04, 1.00, 1.15, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.c', 'LV', 0.13, 26, 0.08, 0.00, 0.30, 'Y', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'IM', 2.03, 26, 0.39, 1.24, 2.83, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.d', 'LV', 1.71, 26, 0.63, 0.42, 3.01, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'IM', 1.30, 26, 0.11, 1.07, 1.54, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.7.e', 'LV', 0.70, 26, 0.25, 0.19, 1.21, 'N', 'Y', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'IM', 2.55, 26, 0.23, 2.08, 3.02, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.a', 'LV', 2.75, 26, 0.32, 2.09, 3.41, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'IM', 3.27, 26, 0.23, 2.80, 3.75, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.8.b', 'LV', 3.74, 26, 0.24, 3.24, 4.24, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'IM', 1.91, 26, 0.19, 1.51, 2.30, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.a', 'LV', 1.24, 26, 0.32, 0.58, 1.91, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'IM', 2.69, 26, 0.23, 2.21, 3.16, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.9.b', 'LV', 2.90, 26, 0.36, 2.17, 3.63, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'IM', 2.16, 26, 0.30, 1.53, 2.78, 'N', NULL, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.00', '2.C.10', 'LV', 1.84, 26, 0.41, 0.99, 2.68, 'N', 'N', TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.a', 'IM', 3.86, 34, 0.38, 3.08, 4.63, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.a', 'LV', 4.17, 34, 0.47, 3.21, 5.13, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.b', 'IM', 2.96, 34, 0.27, 2.40, 3.51, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.b', 'LV', 3.70, 34, 0.57, 2.55, 4.86, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.c', 'IM', 1.93, 34, 0.13, 1.67, 2.18, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.c', 'LV', 1.71, 34, 0.19, 1.32, 2.09, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.d', 'IM', 1.46, 34, 0.19, 1.08, 1.84, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.d', 'LV', 0.95, 34, 0.36, 0.21, 1.69, 'N', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.e', 'IM', 2.83, 34, 0.28, 2.26, 3.41, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.e', 'LV', 3.26, 34, 0.54, 2.15, 4.37, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.f', 'IM', 2.37, 34, 0.24, 1.88, 2.87, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.1.f', 'LV', 2.97, 34, 0.55, 1.86, 4.09, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.a', 'IM', 1.80, 34, 0.39, 1.01, 2.59, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.a', 'LV', 1.15, 33, 0.52, 0.09, 2.20, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.b', 'IM', 1.00, 34, 0.00, NULL, NULL, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.2.b', 'LV', 0.00, 34, 0.00, NULL, NULL, 'N', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.a', 'IM', 2.35, 34, 0.22, 1.89, 2.80, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.a', 'LV', 3.30, 34, 0.27, 2.75, 3.84, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.b', 'IM', 1.37, 34, 0.12, 1.13, 1.61, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.b', 'LV', 0.74, 34, 0.30, 0.12, 1.36, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.c', 'IM', 1.15, 34, 0.09, 1.00, 1.34, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.c', 'LV', 0.39, 34, 0.27, 0.00, 0.94, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.d', 'IM', 1.01, 33, 0.01, 1.00, 1.02, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.d', 'LV', 0.02, 33, 0.02, 0.00, 0.05, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.e', 'IM', 1.19, 34, 0.09, 1.02, 1.36, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.3.e', 'LV', 0.38, 34, 0.17, 0.02, 0.73, 'N', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.a', 'IM', 2.99, 34, 0.30, 2.37, 3.61, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.a', 'LV', 3.53, 34, 0.48, 2.55, 4.50, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.b', 'IM', 1.26, 34, 0.18, 1.00, 1.63, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.b', 'LV', 0.58, 34, 0.44, 0.00, 1.49, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.c', 'IM', 2.07, 34, 0.50, 1.06, 3.08, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.c', 'LV', 1.97, 34, 0.97, 0.01, 3.94, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.d', 'IM', 2.80, 34, 0.38, 2.02, 3.58, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.d', 'LV', 3.32, 34, 0.74, 1.81, 4.83, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.e', 'IM', 2.24, 34, 0.25, 1.73, 2.76, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.e', 'LV', 2.79, 34, 0.43, 1.92, 3.66, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.f', 'IM', 1.70, 34, 0.21, 1.28, 2.12, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.f', 'LV', 1.81, 34, 0.50, 0.78, 2.83, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.g', 'IM', 1.39, 34, 0.15, 1.08, 1.70, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.4.g', 'LV', 0.84, 34, 0.33, 0.16, 1.52, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.a', 'IM', 3.93, 34, 0.35, 3.22, 4.63, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.a', 'LV', 3.82, 34, 0.54, 2.73, 4.91, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.b', 'IM', 2.13, 34, 0.30, 1.52, 2.73, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.5.b', 'LV', 2.36, 34, 0.41, 1.53, 3.18, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.6', 'IM', 2.62, 34, 0.28, 2.06, 3.18, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.6', 'LV', 3.05, 34, 0.39, 2.25, 3.85, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.a', 'IM', 3.90, 34, 0.28, 3.33, 4.47, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.a', 'LV', 4.41, 34, 0.21, 3.98, 4.84, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.b', 'IM', 1.79, 34, 0.20, 1.38, 2.20, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.b', 'LV', 1.55, 34, 0.36, 0.82, 2.27, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.c', 'IM', 1.01, 34, 0.00, 1.00, 1.01, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.c', 'LV', 0.01, 34, 0.01, 0.00, 0.03, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.d', 'IM', 1.03, 34, 0.03, 1.00, 1.09, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.d', 'LV', 0.08, 34, 0.06, 0.00, 0.21, 'Y', 'Y', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.e', 'IM', 1.35, 34, 0.21, 1.00, 1.77, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.7.e', 'LV', 1.01, 34, 0.72, 0.00, 2.48, 'Y', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.a', 'IM', 2.28, 34, 0.26, 1.76, 2.81, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.a', 'LV', 1.97, 34, 0.29, 1.38, 2.55, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.b', 'IM', 2.78, 34, 0.25, 2.28, 3.28, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.8.b', 'LV', 3.03, 34, 0.42, 2.18, 3.88, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.a', 'IM', 1.74, 34, 0.16, 1.41, 2.07, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.a', 'LV', 1.05, 34, 0.25, 0.53, 1.57, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.b', 'IM', 1.84, 33, 0.24, 1.35, 2.34, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.9.b', 'LV', 1.76, 34, 0.40, 0.95, 2.56, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.10', 'IM', 1.47, 32, 0.15, 1.15, 1.78, 'N', NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.01', '2.C.10', 'LV', 1.07, 33, 0.28, 0.49, 1.65, 'N', 'N', TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.a', 'IM', 2.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.a', 'LV', 4.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.b', 'IM', 1.95, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.b', 'LV', 2.32, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.c', 'IM', 2.73, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.c', 'LV', 3.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.d', 'IM', 2.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.d', 'LV', 3.77, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.e', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.e', 'LV', 4.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.f', 'IM', 2.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.1.f', 'LV', 3.05, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.a', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.a', 'LV', 1.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.b', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.2.b', 'LV', 0.77, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.a', 'IM', 3.55, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.a', 'LV', 4.91, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.b', 'IM', 4.62, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.b', 'LV', 6.23, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.c', 'IM', 3.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.c', 'LV', 5.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.d', 'IM', 3.27, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.d', 'LV', 4.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.e', 'IM', 2.10, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.3.e', 'LV', 2.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.a', 'IM', 4.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.a', 'LV', 5.45, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.b', 'IM', 3.86, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.b', 'LV', 4.86, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.c', 'IM', 3.18, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.c', 'LV', 4.64, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.d', 'IM', 2.95, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.d', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.e', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.e', 'LV', 1.45, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.f', 'IM', 1.68, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.f', 'LV', 1.73, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.g', 'IM', 3.36, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.4.g', 'LV', 5.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.a', 'IM', 1.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.a', 'LV', 0.50, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.b', 'IM', 1.24, 21, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.5.b', 'LV', 0.68, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.6', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.6', 'LV', 4.36, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.a', 'IM', 3.41, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.a', 'LV', 4.45, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.b', 'IM', 1.45, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.b', 'LV', 1.09, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.c', 'IM', 1.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.c', 'LV', 0.23, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.d', 'IM', 1.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.d', 'LV', 2.14, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.e', 'IM', 1.32, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.7.e', 'LV', 0.86, 22, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.a', 'IM', 2.82, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.a', 'LV', 3.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.b', 'IM', 3.23, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.8.b', 'LV', 3.77, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.a', 'IM', 2.09, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.a', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.b', 'IM', 2.59, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.9.b', 'LV', 2.55, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.10', 'IM', 2.00, 22, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9121.02', '2.C.10', 'LV', 2.18, 22, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'IM', 4.42, 29, 0.19, 4.03, 4.81, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.a', 'LV', 4.59, 29, 0.23, 4.11, 5.06, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'IM', 3.58, 29, 0.19, 3.19, 3.97, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.b', 'LV', 4.53, 29, 0.25, 4.03, 5.03, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'IM', 3.00, 29, 0.25, 2.49, 3.51, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.c', 'LV', 2.84, 29, 0.42, 1.99, 3.69, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'IM', 2.72, 29, 0.30, 2.12, 3.33, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.d', 'LV', 3.04, 29, 0.43, 2.16, 3.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'IM', 3.96, 29, 0.21, 3.54, 4.38, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.e', 'LV', 4.79, 29, 0.37, 4.03, 5.55, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'IM', 3.59, 29, 0.21, 3.16, 4.03, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.1.f', 'LV', 3.87, 29, 0.34, 3.17, 4.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'IM', 4.03, 28, 0.29, 3.42, 4.63, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.a', 'LV', 4.59, 29, 0.43, 3.70, 5.47, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'IM', 1.06, 29, 0.04, 1.00, 1.15, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.2.b', 'LV', 0.19, 29, 0.13, 0.00, 0.46, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'IM', 3.57, 29, 0.17, 3.22, 3.93, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.a', 'LV', 4.45, 29, 0.17, 4.11, 4.79, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'IM', 2.27, 29, 0.18, 1.90, 2.64, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.b', 'LV', 2.21, 29, 0.34, 1.51, 2.92, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'IM', 1.79, 29, 0.18, 1.43, 2.15, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.c', 'LV', 1.72, 29, 0.39, 0.93, 2.51, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'IM', 1.65, 29, 0.23, 1.18, 2.12, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.d', 'LV', 1.18, 29, 0.40, 0.36, 2.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'IM', 2.56, 29, 0.24, 2.06, 3.07, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.3.e', 'LV', 2.76, 29, 0.32, 2.10, 3.43, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'IM', 3.59, 29, 0.16, 3.26, 3.92, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.a', 'LV', 4.11, 29, 0.22, 3.67, 4.55, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'IM', 1.39, 28, 0.11, 1.17, 1.62, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.b', 'LV', 0.76, 29, 0.23, 0.29, 1.22, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'IM', 1.42, 29, 0.16, 1.09, 1.74, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.c', 'LV', 0.66, 29, 0.24, 0.16, 1.16, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'IM', 1.25, 29, 0.10, 1.06, 1.45, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.d', 'LV', 0.44, 29, 0.17, 0.09, 0.80, 'N', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'IM', 3.07, 29, 0.24, 2.58, 3.56, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.e', 'LV', 3.41, 29, 0.23, 2.93, 3.88, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'IM', 1.90, 29, 0.14, 1.62, 2.18, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.f', 'LV', 1.54, 29, 0.22, 1.09, 2.00, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'IM', 2.20, 29, 0.17, 1.85, 2.54, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.4.g', 'LV', 2.41, 29, 0.37, 1.66, 3.17, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'IM', 1.49, 29, 0.13, 1.22, 1.76, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.a', 'LV', 0.98, 29, 0.29, 0.38, 1.57, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'IM', 1.98, 29, 0.15, 1.67, 2.30, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.5.b', 'LV', 2.02, 29, 0.35, 1.30, 2.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'IM', 3.68, 29, 0.24, 3.19, 4.17, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.6', 'LV', 4.71, 29, 0.40, 3.89, 5.52, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'IM', 4.08, 29, 0.14, 3.79, 4.37, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.a', 'LV', 3.97, 29, 0.25, 3.45, 4.49, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'IM', 1.44, 29, 0.13, 1.17, 1.70, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.b', 'LV', 0.72, 29, 0.24, 0.23, 1.20, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'IM', 1.10, 29, 0.07, 1.00, 1.26, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.c', 'LV', 0.15, 29, 0.11, 0.00, 0.39, 'Y', 'Y', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'IM', 1.47, 29, 0.15, 1.17, 1.78, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.d', 'LV', 0.82, 29, 0.27, 0.26, 1.37, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'IM', 1.59, 29, 0.14, 1.30, 1.89, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.7.e', 'LV', 1.31, 29, 0.29, 0.71, 1.91, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'IM', 4.20, 29, 0.18, 3.83, 4.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.a', 'LV', 4.33, 28, 0.20, 3.92, 4.74, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'IM', 3.25, 29, 0.16, 2.94, 3.57, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.8.b', 'LV', 3.13, 29, 0.28, 2.55, 3.71, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'IM', 2.34, 29, 0.26, 1.81, 2.88, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.a', 'LV', 1.82, 29, 0.39, 1.01, 2.63, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'IM', 2.78, 29, 0.23, 2.32, 3.25, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.9.b', 'LV', 2.86, 29, 0.24, 2.36, 3.36, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'IM', 3.54, 29, 0.23, 3.06, 4.02, 'N', NULL, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9131.00', '2.C.10', 'LV', 3.65, 29, 0.19, 3.27, 4.04, 'N', 'N', TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'IM', 4.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.a', 'LV', 5.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'IM', 3.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.b', 'LV', 4.80, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.c', 'LV', 4.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'IM', 3.20, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.d', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'IM', 4.63, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.e', 'LV', 5.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'IM', 3.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.1.f', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'IM', 1.84, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.a', 'LV', 1.42, 19, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'IM', 1.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.2.b', 'LV', 0.05, 19, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'IM', 3.50, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.a', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'IM', 2.30, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.b', 'LV', 2.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.c', 'LV', 1.85, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'IM', 3.05, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.d', 'LV', 3.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'IM', 2.58, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.3.e', 'LV', 2.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'IM', 3.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.a', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'IM', 1.60, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.b', 'LV', 1.30, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.c', 'LV', 1.90, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.d', 'LV', 1.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'IM', 2.90, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.e', 'LV', 3.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'IM', 1.74, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.f', 'LV', 1.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'IM', 1.95, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.4.g', 'LV', 1.95, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'IM', 1.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.a', 'LV', 0.50, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'IM', 1.40, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.5.b', 'LV', 1.15, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'IM', 3.10, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.6', 'LV', 4.05, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'IM', 4.05, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.a', 'LV', 4.10, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'IM', 1.65, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.b', 'LV', 1.25, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'IM', 1.15, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.c', 'LV', 0.25, 20, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'IM', 1.25, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.d', 'LV', 0.65, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'IM', 1.55, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.7.e', 'LV', 1.40, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'IM', 3.70, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.a', 'LV', 4.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'IM', 3.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.8.b', 'LV', 4.20, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'IM', 2.84, 19, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.a', 'LV', 2.55, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'IM', 2.85, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.9.b', 'LV', 2.75, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'IM', 1.75, 20, NULL, NULL, NULL, NULL, NULL, TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9141.00', '2.C.10', 'LV', 1.35, 20, NULL, NULL, NULL, NULL, 'N', TO_DATE('2020-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'IM', 4.37, 26, 0.11, 4.14, 4.60, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.a', 'LV', 4.60, 27, 0.21, 4.16, 5.04, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'IM', 3.46, 25, 0.20, 3.05, 3.88, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.b', 'LV', 4.49, 27, 0.35, 3.77, 5.21, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'IM', 2.80, 25, 0.26, 2.27, 3.34, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.c', 'LV', 3.04, 27, 0.45, 2.12, 3.96, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'IM', 2.31, 26, 0.24, 1.82, 2.80, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.d', 'LV', 2.95, 27, 0.49, 1.94, 3.97, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'IM', 4.61, 26, 0.11, 4.38, 4.85, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.e', 'LV', 5.94, 27, 0.24, 5.45, 6.43, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'IM', 3.73, 26, 0.13, 3.47, 3.99, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.1.f', 'LV', 4.36, 27, 0.15, 4.04, 4.68, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'IM', 2.09, 26, 0.29, 1.50, 2.68, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.a', 'LV', 1.97, 26, 0.53, 0.88, 3.06, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'IM', 1.26, 26, 0.14, 1.00, 1.56, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.2.b', 'LV', 0.63, 27, 0.29, 0.03, 1.24, 'N', 'Y', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'IM', 3.29, 26, 0.24, 2.81, 3.78, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.a', 'LV', 3.62, 27, 0.28, 3.04, 4.19, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'IM', 1.51, 26, 0.18, 1.14, 1.89, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.b', 'LV', 1.14, 27, 0.38, 0.36, 1.92, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'IM', 1.56, 26, 0.18, 1.19, 1.93, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.c', 'LV', 1.08, 27, 0.35, 0.36, 1.79, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'IM', 1.67, 25, 0.26, 1.14, 2.21, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.d', 'LV', 1.21, 27, 0.41, 0.37, 2.05, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'IM', 1.57, 26, 0.19, 1.17, 1.97, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.3.e', 'LV', 1.27, 27, 0.39, 0.47, 2.07, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'IM', 3.33, 26, 0.25, 2.82, 3.83, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.a', 'LV', 4.06, 27, 0.26, 3.52, 4.61, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'IM', 1.42, 25, 0.15, 1.10, 1.74, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.b', 'LV', 0.86, 27, 0.35, 0.15, 1.58, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'IM', 1.55, 26, 0.19, 1.15, 1.95, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.c', 'LV', 1.31, 26, 0.47, 0.35, 2.27, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'IM', 1.45, 26, 0.19, 1.06, 1.84, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.d', 'LV', 0.90, 27, 0.35, 0.18, 1.62, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'IM', 4.06, 26, 0.36, 3.32, 4.80, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.e', 'LV', 4.76, 27, 0.40, 3.95, 5.58, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'IM', 3.42, 26, 0.31, 2.78, 4.07, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.f', 'LV', 4.16, 27, 0.38, 3.38, 4.93, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'IM', 1.92, 26, 0.29, 1.33, 2.51, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.4.g', 'LV', 1.64, 27, 0.46, 0.69, 2.58, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'IM', 1.95, 26, 0.26, 1.41, 2.50, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.a', 'LV', 1.50, 27, 0.35, 0.77, 2.22, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'IM', 3.70, 26, 0.44, 2.79, 4.62, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.5.b', 'LV', 4.48, 27, 0.60, 3.25, 5.71, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'IM', 3.92, 26, 0.16, 3.58, 4.25, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.6', 'LV', 5.25, 27, 0.32, 4.60, 5.91, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'IM', 4.29, 26, 0.14, 3.99, 4.58, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.a', 'LV', 4.52, 27, 0.23, 4.05, 4.99, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'IM', 1.87, 26, 0.28, 1.29, 2.45, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.b', 'LV', 1.33, 27, 0.36, 0.60, 2.06, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'IM', 1.60, 26, 0.28, 1.02, 2.17, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.c', 'LV', 0.79, 27, 0.32, 0.13, 1.46, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'IM', 1.43, 26, 0.19, 1.05, 1.81, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.d', 'LV', 0.88, 27, 0.39, 0.09, 1.67, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'IM', 2.36, 27, 0.23, 1.89, 2.84, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.7.e', 'LV', 3.00, 26, 0.54, 1.88, 4.11, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'IM', 3.47, 27, 0.28, 2.89, 4.05, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.a', 'LV', 3.55, 27, 0.42, 2.69, 4.41, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'IM', 3.16, 27, 0.34, 2.47, 3.86, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.8.b', 'LV', 2.92, 27, 0.40, 2.10, 3.74, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'IM', 2.51, 27, 0.24, 2.01, 3.02, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.a', 'LV', 1.50, 27, 0.26, 0.96, 2.04, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'IM', 2.98, 27, 0.21, 2.55, 3.41, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.9.b', 'LV', 2.89, 27, 0.16, 2.56, 3.23, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'IM', 1.98, 27, 0.26, 1.45, 2.51, 'N', NULL, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9151.00', '2.C.10', 'LV', 1.65, 27, 0.33, 0.96, 2.33, 'N', 'N', TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'IM', 4.38, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.a', 'LV', 5.12, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'IM', 3.12, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.b', 'LV', 4.04, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'IM', 2.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.c', 'LV', 3.16, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'IM', 2.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.d', 'LV', 3.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.e', 'LV', 5.68, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'IM', 3.44, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.1.f', 'LV', 4.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'IM', 1.96, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.a', 'LV', 1.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'IM', 1.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.2.b', 'LV', 0.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'IM', 3.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.a', 'LV', 4.12, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'IM', 2.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.b', 'LV', 2.16, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'IM', 1.52, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.c', 'LV', 1.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'IM', 2.24, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.d', 'LV', 2.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'IM', 1.88, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.3.e', 'LV', 1.52, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'IM', 2.48, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.a', 'LV', 3.44, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'IM', 1.83, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.b', 'LV', 1.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'IM', 2.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.c', 'LV', 2.56, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'IM', 1.80, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.d', 'LV', 1.84, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'IM', 2.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.e', 'LV', 3.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'IM', 2.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.f', 'LV', 3.32, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'IM', 3.16, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.4.g', 'LV', 4.12, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'IM', 1.92, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.a', 'LV', 1.92, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'IM', 2.21, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.5.b', 'LV', 2.52, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'IM', 3.72, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.6', 'LV', 5.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'IM', 3.96, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.a', 'LV', 4.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'IM', 1.76, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.b', 'LV', 1.24, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.c', 'LV', 0.48, 25, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'IM', 2.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.d', 'LV', 2.76, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'IM', 2.04, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.7.e', 'LV', 2.36, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'IM', 4.42, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.a', 'LV', 5.28, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'IM', 4.04, 24, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.8.b', 'LV', 4.12, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'IM', 3.40, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.a', 'LV', 3.48, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'IM', 3.84, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.9.b', 'LV', 3.72, 25, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'IM', 3.22, 23, NULL, NULL, NULL, NULL, NULL, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9161.00', '2.C.10', 'LV', 3.42, 24, NULL, NULL, NULL, NULL, 'N', TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'IM', 3.67, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.a', 'LV', 4.50, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'IM', 3.00, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.b', 'LV', 4.57, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'IM', 1.63, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.c', 'LV', 1.11, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'IM', 1.85, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.d', 'LV', 2.43, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'IM', 2.27, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.e', 'LV', 3.00, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'IM', 2.60, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.1.f', 'LV', 3.67, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'IM', 2.96, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.a', 'LV', 3.41, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'IM', 1.20, 25, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.2.b', 'LV', 0.58, 26, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'IM', 3.00, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.a', 'LV', 3.89, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'IM', 2.65, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.b', 'LV', 3.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'IM', 2.56, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.c', 'LV', 2.89, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'IM', 1.15, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.d', 'LV', 0.57, 28, NULL, NULL, NULL, NULL, 'Y', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'IM', 1.78, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.3.e', 'LV', 1.86, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'IM', 2.89, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.a', 'LV', 3.96, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'IM', 1.96, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.b', 'LV', 2.14, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'IM', 2.88, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.c', 'LV', 3.93, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'IM', 3.26, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.d', 'LV', 4.22, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'IM', 1.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.e', 'LV', 2.00, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'IM', 1.48, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.f', 'LV', 1.11, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'IM', 1.81, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.4.g', 'LV', 2.18, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'IM', 3.19, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.a', 'LV', 3.18, 28, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'IM', 1.69, 26, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.5.b', 'LV', 1.19, 27, NULL, NULL, NULL, NULL, 'N', TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.C.6', 'IM', 3.15, 27, NULL, NULL, NULL, NULL, NULL, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO knowledge (onetsoc_code, element_id, scale_id, data_value, n, standard_error, lower_ci_bound, upper_ci_bound, recommend_suppress, not_relevant, date_updated, domain_source) VALUES ('11-9199.01', '2.