CREATE TABLE unspsc_reference (
  commodity_code DECIMAL(8,0) NOT NULL,
  commodity_title CHARACTER VARYING(150) NOT NULL,
  class_code DECIMAL(8,0) NOT NULL,
  class_title CHARACTER VARYING(150) NOT NULL,
  family_code DECIMAL(8,0) NOT NULL,
  family_title CHARACTER VARYING(150) NOT NULL,
  segment_code DECIMAL(8,0) NOT NULL,
  segment_title CHARACTER VARYING(150) NOT NULL,
  PRIMARY KEY (commodity_code));

INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10111302, 'Pet grooming products', 10111300, 'Domestic pet treatments and accessories and equipment', 10110000, 'Domestic pet products', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10111306, 'Domestic pet training kits', 10111300, 'Domestic pet treatments and accessories and equipment', 10110000, 'Domestic pet products', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10131601, 'Cages or its accessories', 10131600, 'Animal containment', 10130000, 'Animal containment and habitats', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10131602, 'Kennels', 10131600, 'Animal containment', 10130000, 'Animal containment and habitats', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10131605, 'Animal transport cage', 10131600, 'Animal containment', 10130000, 'Animal containment and habitats', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10131702, 'Aquariums', 10131700, 'Animal habitats', 10130000, 'Animal containment and habitats', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141501, 'Saddles', 10141500, 'Saddlery', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141502, 'Whips', 10141500, 'Saddlery', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141601, 'Bridles', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141604, 'Reins', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141606, 'Leashes or leads', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141607, 'Animal collars', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141608, 'Harnesses or its accessories', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141609, 'Restraints', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141610, 'Muzzles', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10141612, 'Dog catching pole', 10141600, 'Harness goods', 10140000, 'Saddlery and harness goods', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10191701, 'Animal control traps', 10191700, 'Pest control devices', 10190000, 'Pest control products', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10191703, 'Flying insect control traps', 10191700, 'Pest control devices', 10190000, 'Pest control products', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (10191705, 'Lariats', 10191700, 'Pest control devices', 10190000, 'Pest control products', 10000000, 'Live Plant and Animal Material and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (11111610, 'Pumice stone', 11111600, 'Stone', 11110000, 'Earth and stone', 11000000, 'Mineral and Textile and Inedible Plant and Animal Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (11162110, 'Netting', 11162100, 'Specialty fabrics or cloth', 11160000, 'Fabrics and leather materials', 11000000, 'Mineral and Textile and Inedible Plant and Animal Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131604, 'Flares', 12131600, 'Pyrotechnics', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131701, 'Blasting caps', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131702, 'Detonators', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131703, 'Explosives fuses', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131704, 'Explosive initiators', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131707, 'Lighters', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12131708, 'Detonator box', 12131700, 'Igniters', 12130000, 'Explosive materials', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (12162503, 'Flotation aids', 12162500, 'Emulsion breakers', 12160000, 'Additives', 12000000, 'Chemicals including Bio Chemicals and Gas Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (14111513, 'Ledger paper', 14111500, 'Printing and writing paper', 14110000, 'Paper products', 14000000, 'Paper Materials and Products');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (14111802, 'Receipts or receipt books', 14111800, 'Business use papers', 14110000, 'Paper products', 14000000, 'Paper Materials and Products');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (15131601, 'Nuclear fuel rod', 15131600, 'Fission fuel assemblies', 15130000, 'Fuel for nuclear reactors', 15000000, 'Fuels and Fuel Additives and Lubricants and Anti corrosive Materials');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101501, 'Continuous mining equipment', 20101500, 'Cutting equipment', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101502, 'Longwall shears', 20101500, 'Cutting equipment', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101504, 'Rock cutters', 20101500, 'Cutting equipment', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101601, 'Screens', 20101600, 'Screens and feeding equipment', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101619, 'Weigh belt feeder', 20101600, 'Screens and feeding equipment', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101701, 'Rock crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101702, 'Roll crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101703, 'Cone crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101704, 'Gyratory crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101705, 'Impact crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101706, 'Jaw crushers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101710, 'Pulverizing machinery', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101711, 'Rock breakers', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101713, 'Cyclone or vortex grinders', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101716, 'Crusher hammer', 20101700, 'Crushers and breakers and grinders', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101801, 'Cable bolters', 20101800, 'Mechanized ground support systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101802, 'Scissor bolters', 20101800, 'Mechanized ground support systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101803, 'Boom bolters', 20101800, 'Mechanized ground support systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101804, 'Shotcrete spraying equipment', 20101800, 'Mechanized ground support systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20101902, 'Repetitive impact systems', 20101900, 'Secondary rock breaking systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102007, 'Core drills', 20102000, 'Exploration and development systems', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102101, 'Pneumatic rock drills', 20102100, 'Rock drills', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102102, 'Hydraulic rock drills', 20102100, 'Rock drills', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102103, 'Hand held rock drills', 20102100, 'Rock drills', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102201, 'Ammonium nitrate and fuel oil ANFO loading machinery', 20102200, 'Explosive loading machinery', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102203, 'Explosive loading machinery spare parts or accessories', 20102200, 'Explosive loading machinery', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20102304, 'Bulk material carriers', 20102300, 'Underground mining service vehicles', 20100000, 'Mining and quarrying machinery and equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111601, 'Boring or sinking machinery', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111603, 'Hammer drills', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111607, 'Tunneling machinery', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111608, 'Striking hammers', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111609, 'Sinker drills', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111611, 'Rotary drills', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111614, 'Industrial drill bits', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111616, 'Derricks', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111618, 'Downhole fishing poles', 20111600, 'Drilling and operation machinery', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111702, 'Packers or tubing anchors', 20111700, 'Drilling and operation accessories', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111703, 'Drilling casings', 20111700, 'Drilling and operation accessories', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20111704, 'Drilling screens', 20111700, 'Drilling and operation accessories', 20110000, 'Well drilling and operation equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121104, 'Cement bulk material equipment', 20121100, 'Cementing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121109, 'Cement pumping units', 20121100, 'Cementing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121110, 'Cement retainers', 20121100, 'Cementing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121115, 'Oilfield cementing tools', 20121100, 'Cementing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121316, 'Sand control screens', 20121300, 'Sand control equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121404, 'Completion bull plugs', 20121400, 'Completion tools and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121413, 'Completion hydraulic pumps', 20121400, 'Completion tools and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121449, 'Plunger lift equipment', 20121400, 'Completion tools and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121501, 'Blowout preventers', 20121500, 'Conventional drilling tools', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121502, 'Blowout preventer controls', 20121500, 'Conventional drilling tools', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121504, 'Drill collars', 20121500, 'Conventional drilling tools', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121505, 'Coring equipment', 20121500, 'Conventional drilling tools', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121508, 'Drill pipe', 20121500, 'Conventional drilling tools', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121906, 'Nuclear tools', 20121900, 'Well measurement and logging equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121910, 'Telemetry systems', 20121900, 'Well measurement and logging equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20121913, 'Well logging downhole test equipment', 20121900, 'Well measurement and logging equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122101, 'Capsule guns', 20122100, 'Perforating equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122102, 'Casing guns', 20122100, 'Perforating equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122114, 'Through tubing perforation guns', 20122100, 'Perforating equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122204, 'Choke manifolds', 20122200, 'Well testing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122212, 'Oil samplers', 20122200, 'Well testing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122213, 'Well testing separators', 20122200, 'Well testing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122216, 'Well testing downhole tools', 20122200, 'Well testing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122308, 'Slickline chemical cutters', 20122300, 'Slickline equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122321, 'Slickline jet cutters', 20122300, 'Slickline equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122335, 'Slickline severing tools', 20122300, 'Slickline equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122349, 'Wireline grabs', 20122300, 'Slickline equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122403, 'Hipot testers', 20122400, 'Production systems equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122409, 'Oilfield production spoolers', 20122400, 'Production systems equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122501, 'Blaster tools', 20122500, 'Coiled tubing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122503, 'Coiled tubing units', 20122500, 'Coiled tubing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122506, 'Coiled tubing injector heads', 20122500, 'Coiled tubing equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122605, 'Seismic geophones', 20122600, 'Seismic equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122615, 'Seismic receivers', 20122600, 'Seismic equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122709, 'Oil country thread protectors', 20122700, 'Oil country tubular goods', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122801, 'Mud agitators', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122802, 'Mud tanks', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122807, 'Drawworks', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122809, 'Drill swivels', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122811, 'Drill rig elevators', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122820, 'Land drilling rigs', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122821, 'Mud cleaning equipment', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122822, 'Mud manifolds', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122823, 'Mud mixers', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122824, 'Pipe handling equipment', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122829, 'Drill rig rotary tables', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122833, 'Makeup tongs', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122838, 'Shale shakers', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122839, 'Mud degassers', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122840, 'Crown blocks', 20122800, 'Drilling and workover rigs and equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122902, 'Surface data logging sensors', 20122900, 'Surface data logging equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20122903, 'Surface data logging units', 20122900, 'Surface data logging equipment', 20120000, 'Oil and gas drilling and exploration equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141002, 'Wellhead beam pumps', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141003, 'Wellhead flow lines', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141005, 'Wellhead production chokes', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141011, 'Tubing head adapter', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141014, 'Casing head spool', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141015, 'Wellhead tees or crosses', 20141000, 'Wellhead equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141301, 'Downhole jet pumps', 20141300, 'Downhole jet pumps and anchors', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20141501, 'Electric downhole pumps', 20141500, 'Downhole pumps', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142101, 'Oil well heater treaters', 20142100, 'Heater treaters', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142501, 'Oil field water oil centrifuges', 20142500, 'Produced water treating equipment', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142702, 'Rod pumps', 20142700, 'Pumping units', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142703, 'Mechanical rod pumps', 20142700, 'Pumping units', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142801, 'Oil water separators', 20142800, 'Production separators', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142901, 'Oil storage tanks', 20142900, 'Storage vessels and tanks', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (20142903, 'Steel holding tank', 20142900, 'Storage vessels and tanks', 20140000, 'Oil and gas operating and production equipment', 20000000, 'Mining and Well Drilling Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101501, 'Ploughs', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101502, 'Harrows', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101503, 'Cultivators', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101504, 'Weeders', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101505, 'Hoeing machines', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101506, 'Graders or land levelers', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101507, 'Agricultural rollers', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101508, 'Rollers for lawn or sports grounds', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101511, 'Irrigation trickles', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101512, 'Irrigation overheads', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101513, 'Disks', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101514, 'Subsoilers', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101516, 'Dibblers', 21101500, 'Agricultural machinery for soil preparation', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101601, 'Planters', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101602, 'Transplanters', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101604, 'Seed drills', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101605, 'Seed treating equipment', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101606, 'Hole diggers', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101607, 'Seeder attachment', 21101600, 'Agricultural machinery for planting and seeding', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101701, 'Mowers', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101702, 'Haymaking machinery', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101703, 'Harvesters', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101704, 'Combine harvesters', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101705, 'Threshing machines', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101706, 'Crop dividers', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101707, 'Harvester parts or accessories', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101708, 'Mower parts or accessories', 21101700, 'Agricultural machinery for harvesting', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101801, 'Sprayers', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101802, 'Dusters', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101803, 'Water sprinklers', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101804, 'Fertilizer spreaders or distributors', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101805, 'Fog or mist generators', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101806, 'Composter', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101807, 'Pollination equipment or supplies', 21101800, 'Dispersing and spraying appliances for agriculture', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101901, 'Milking machines', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101902, 'Animal husbandry equipment', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101903, 'Incubators or brooders for poultry', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101904, 'Feed mixers', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101905, 'Livestock identification equipment', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101906, 'Egg inspection or collecting equipment', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101907, 'Animal watering machines', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101908, 'Milk cooling tanks', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101909, 'Animal shearing or clipping equipment', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101910, 'Wool comb', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21101912, 'Livestock restraint chute', 21101900, 'Poultry and livestock equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102001, 'Cleaning machines for seed or grain or dried leguminous vegetables', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102002, 'Sorting machines for seed or grain or dried leguminous vegetables', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102003, 'Grading machines for seed or grain or dried leguminous vegetables', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102004, 'Rice cleaning or hulling equipment', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102005, 'Grinding mills', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102006, 'Hammer mills', 21102000, 'Agricultural machinery for cleaning and sorting and grading', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102201, 'Decorticators', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102202, 'Lumbering equipment', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102203, 'Reforestation equipment', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102204, 'Forestry saws', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102205, 'Forestry skidders', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102206, 'Forestry increment borers', 21102200, 'Forestry machinery and equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102301, 'Greenhouse irrigation equipment', 21102300, 'Greenhouse equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102302, 'Greenhouse pots', 21102300, 'Greenhouse equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102303, 'Greenhouse ventilation equipment', 21102300, 'Greenhouse equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21102306, 'Hydroponic fertilizer injector', 21102300, 'Greenhouse equipment', 21100000, 'Agricultural and forestry and landscape machinery and equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111501, 'Commercial fish hooks', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111502, 'Commercial fishing reels', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111503, 'Commercial fishing line tackle', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111504, 'Commercial fishing nets', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111506, 'Commercial fishing floats', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111507, 'Commercial sinkers or weights', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111508, 'Fishing net haulers', 21111500, 'Commercial fishing equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111601, 'Marine hatchery equipment', 21111600, 'Aquaculture equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (21111602, 'Pisciculture supplies', 21111600, 'Aquaculture equipment', 21110000, 'Fishing and aquaculture equipment', 21000000, 'Farming and Fishing and Forestry and Wildlife Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101501, 'Front end loaders', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101502, 'Graders', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101504, 'Pile drivers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101505, 'Rollers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101507, 'Tampers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101508, 'Trenching machines', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101509, 'Backhoes', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101511, 'Compactors', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101513, 'Draglines', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101514, 'Dredgers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101516, 'Ditchers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101518, 'Elevating scrapers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101521, 'Pulled scrapers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101522, 'Track bulldozers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101523, 'Wheel bulldozers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101524, 'Mobile excavators', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101525, 'Wheel excavators', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101526, 'Track excavators', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101527, 'Integrated tool carriers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101528, 'Wheel loaders', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101529, 'Skid steer loaders', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101531, 'Snow blowers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101532, 'Track loaders', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101533, 'Treedozers', 22101500, 'Earth moving machinery', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101603, 'Road wideners', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101604, 'Vibratory plates', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101605, 'Asphalt finishers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101606, 'Chip Spreaders', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101607, 'Road pavers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101608, 'Cold planers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101609, 'Paving material mixers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101610, 'Aggregate spreaders', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101611, 'Bituminous material distributors', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101612, 'Road rooters', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101613, 'Road surface heater planers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101614, 'Concrete paving strike offs', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101615, 'Paving breakers', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101616, 'Curbing machines', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101617, 'Grouting machines', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101619, 'Scrubbing machines', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101620, 'Joint cleaning or refacing machines', 22101600, 'Paving equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101701, 'Earthmoving shovels', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101702, 'Earthmoving buckets or its parts or accessories', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101703, 'Blades or tooth or other cutting edges', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101704, 'Scarifiers', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101707, 'Taglines', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101709, 'Grapples', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101710, 'Snowplow attachments', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101711, 'Paving breaker tools or accessories', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101712, 'Pile driver tools or its parts or accessories', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101713, 'Backhoe boom or boom sections', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101715, 'Batching plants or feeders', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101724, 'Hydraulic breaker chisel', 22101700, 'Heavy equipment components', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101801, 'Manlift or personnel lift', 22101800, 'Aerial lifts', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101802, 'Platform lift', 22101800, 'Aerial lifts', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101803, 'Articulating boom lift', 22101800, 'Aerial lifts', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101804, 'Telescoping boom lift', 22101800, 'Aerial lifts', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101901, 'Concrete mixers or plants', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101902, 'Plaster or mortar mixers', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101903, 'Rotary tiller mixers', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101904, 'Curing machines', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101905, 'Concrete spreaders', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22101906, 'Shoring equipment', 22101900, 'Building construction machinery and accessories', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (22102001, 'Demolition equipment kits', 22102000, 'Building demolition machinery and equipment', 22100000, 'Heavy construction machinery and equipment', 22000000, 'Building and Construction Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101502, 'Drilling machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101504, 'Bending machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101505, 'Boring machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101506, 'Grinding machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101507, 'Molding machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101508, 'Cutting machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101509, 'Sanding machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101510, 'Polishing machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101511, 'Turning machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101512, 'Sawing machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101513, 'Milling machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101514, 'Planing machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101515, 'Engraving machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101517, 'Grit blast machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101518, 'Shot peen machine', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101519, 'Robot machines', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101521, 'Wire cathode electrode discharge machine', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101528, 'Drum sander', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101529, 'Glue roller spreader', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101530, 'Dovetail machine', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101532, 'Tenoner or tenoning machine', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101533, 'Cold press', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101534, 'Edge bander', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101537, 'Belt and disc sander', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23101538, 'Woodworking jointer', 23101500, 'Machinery for working wood and stone and ceramic and the like', 23100000, 'Raw materials processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23111507, 'Gas recovery machinery', 23111500, 'Petroleum distilling and processing machinery and equipment', 23110000, 'Petroleum processing machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121501, 'Embroidery making machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121502, 'Felting machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121503, 'Winding or reeling or spooling machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121504, 'Twisting machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121505, 'Stitch bonding machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121506, 'Knitting machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121507, 'Weaving machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121508, 'Finishing machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121509, 'Spinning machines', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121512, 'Carding machine', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121513, 'Yarn assembly winder', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121517, 'Fine spinning machine', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121518, 'Thread unravelling machine', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121520, 'Warping machine', 23121500, 'Textile processing machinery and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121603, 'Buttonhole machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121604, 'Cloth cutting machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121607, 'Bleaching machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121608, 'Fabric or cloth folding machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121609, 'Reeling or unreeling machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121610, 'Dyeing machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121611, 'Cutting or pinking machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121612, 'Sewing machine needles', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121614, 'Sewing machines', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23121617, 'Fabric frame', 23121600, 'Textile working machinery and equipment and accessories', 23120000, 'Textile and fabric machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131503, 'Grinding wheels', 23131500, 'Grinding and sanding and polishing equipment and supplies', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131506, 'Polishing wheels', 23131500, 'Grinding and sanding and polishing equipment and supplies', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131509, 'Tumblers or polishers', 23131500, 'Grinding and sanding and polishing equipment and supplies', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131513, 'Sanding blocks', 23131500, 'Grinding and sanding and polishing equipment and supplies', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131515, 'Grinding wheel dressers', 23131500, 'Grinding and sanding and polishing equipment and supplies', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131602, 'Faceting machines', 23131600, 'Faceting equipment and accessories', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23131603, 'Faceting laps', 23131600, 'Faceting equipment and accessories', 23130000, 'Lapidary machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23141605, 'Leather presses', 23141600, 'Leather preparing machinery and accessories', 23140000, 'Leatherworking repairing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23141701, 'Leather cutting machines', 23141700, 'Leather working and repairing machinery and accessories', 23140000, 'Leatherworking repairing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23141702, 'Leather riveting machines', 23141700, 'Leather working and repairing machinery and accessories', 23140000, 'Leatherworking repairing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23141703, 'Leather nailing machines', 23141700, 'Leather working and repairing machinery and accessories', 23140000, 'Leatherworking repairing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23141704, 'Leatherworking workshop equipment', 23141700, 'Leather working and repairing machinery and accessories', 23140000, 'Leatherworking repairing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151501, 'Blow molding machines', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151502, 'Coating machines', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151503, 'Extruders', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151504, 'Injection molding machines', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151506, 'Rubber or plastic presses', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151508, 'Vacuum molding machines', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151509, 'Vulcanizing machines', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151510, 'Plastic cutting machinery', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151512, 'Rubber or plastic mills', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151513, 'Rubber or plastic extrusion dies', 23151500, 'Rubber and plastic processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151601, 'Blowers or dryers', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151602, 'Crushers', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151604, 'Grinding or polishing machines', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151606, 'Cement or ceramic or glass or similar material molding machines', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151607, 'Presses', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151608, 'Sifters', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151609, 'Glass blowing instrument', 23151600, 'Cement and ceramics and glass industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151701, 'Lens grinding machines', 23151700, 'Optical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151702, 'Lens measuring equipment', 23151700, 'Optical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151703, 'Lens polishing equipment', 23151700, 'Optical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151705, 'Optical vacuum coating equipment', 23151700, 'Optical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151801, 'Ampoule filling equipment', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151804, 'Reactors or fermenters or digesters', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151805, 'Filling or sealing auger dose machines', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151806, 'Pharmaceutical filters or ultra filters', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151807, 'Freezedryers or lyophilzers', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151810, 'Sterile or aseptic processing or filling machines', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151812, 'Tablet counters', 23151800, 'Pharmaceutical industry machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151901, 'Cutters', 23151900, 'Paper making and paper processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151902, 'Slitters', 23151900, 'Paper making and paper processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23151911, 'Paper machine', 23151900, 'Paper making and paper processing machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152001, 'Corona treaters', 23152000, 'Web handling and control machinery and equipment and supplies', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152101, 'Vibratory separation equipment or parts or screens', 23152100, 'Separation machinery and equipment', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152102, 'Stationary separation equipment or parts or screens', 23152100, 'Separation machinery and equipment', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152104, 'Centrifugal separation equipment or parts or screens', 23152100, 'Separation machinery and equipment', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152203, 'Engine or component test stands', 23152200, 'Manufacturing tables and stands', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152204, 'Machine guarding', 23152200, 'Manufacturing tables and stands', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152901, 'Wrapping machinery', 23152900, 'Packaging machinery', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152902, 'Form or fill or seal machinery', 23152900, 'Packaging machinery', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152903, 'Packaging vacuum', 23152900, 'Packaging machinery', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23152904, 'Packaging hoppers', 23152900, 'Packaging machinery', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153002, 'Guide jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153007, 'Setting jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153010, 'Removal jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153015, 'Feeder jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153017, 'Alignment jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153018, 'Positioning jig', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153019, 'Lifter plate', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153020, 'Tape guide', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153022, 'Power feeder', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153029, 'Jig block', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153031, 'Measuring jigs', 23153000, 'Holding and positioning and guiding systems and devices', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153130, 'Machine mounts or vibration isolators', 23153100, 'Industrial machinery components and accessories', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153134, 'Feed or drive rollers', 23153100, 'Industrial machinery components and accessories', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153145, 'Spray gun', 23153100, 'Industrial machinery components and accessories', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153201, 'Paint robots', 23153200, 'Robotics', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153202, 'Pick or place robots', 23153200, 'Robotics', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153203, 'Sealant adhesive robots', 23153200, 'Robotics', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153204, 'Welding robots', 23153200, 'Robotics', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153205, 'Machine tending robot', 23153200, 'Robotics', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153401, 'Adhesive or glue application systems', 23153400, 'Assembly machines', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153403, 'Specialty assembly', 23153400, 'Assembly machines', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153417, 'Miscellaneous assembly machines', 23153400, 'Assembly machines', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153501, 'Paint application system', 23153500, 'Paint systems', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153503, 'Paint systems ovens', 23153500, 'Paint systems', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153606, 'Electro etcher marking machine', 23153600, 'Part marking machines', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23153802, 'Electrical coil winding machine', 23153800, 'Coating systems', 23150000, 'Industrial process machinery and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161501, 'Foundry blowers', 23161500, 'Foundry machines and equipment', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161503, 'Core drying ovens', 23161500, 'Foundry machines and equipment', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161506, 'Foundry crucibles', 23161500, 'Foundry machines and equipment', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161510, 'Casting machines', 23161500, 'Foundry machines and equipment', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161517, 'Die casting machine', 23161500, 'Foundry machines and equipment', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161603, 'Foundry flasks', 23161600, 'Foundry supplies', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161605, 'Foundry ladles', 23161600, 'Foundry supplies', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161606, 'Foundry molds', 23161600, 'Foundry supplies', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23161608, 'Foundry shovels', 23161600, 'Foundry supplies', 23160000, 'Foundry machines and equipment and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181501, 'Filling machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181502, 'Milling machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181504, 'Sifting machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181505, 'Dehydrating machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181507, 'Crushing machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181508, 'Blanching machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181509, 'Sorting machinery', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181510, 'Meat tyers', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181511, 'Forming machine', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181512, 'Cooling machine', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181513, 'Preduster', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181514, 'Cheese making machine', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181520, 'Cream separator', 23181500, 'Food preparation machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181601, 'Dicing machinery', 23181600, 'Food cutting machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181602, 'Slicing machinery', 23181600, 'Food cutting machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181603, 'Chopping machinery', 23181600, 'Food cutting machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181604, 'Cutting machinery', 23181600, 'Food cutting machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181701, 'Smoking machinery', 23181700, 'Food cooking and smoking machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181702, 'Roasting machinery', 23181700, 'Food cooking and smoking machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181703, 'Cooking machinery', 23181700, 'Food cooking and smoking machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181704, 'Steaming machinery', 23181700, 'Food cooking and smoking machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181705, 'Food sterilizing machine', 23181700, 'Food cooking and smoking machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181802, 'Juicing machinery', 23181800, 'Industrial beverage processing machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23181804, 'Ice cream machines', 23181800, 'Industrial beverage processing machinery', 23180000, 'Industrial food and beverage equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23191002, 'Helical blade mixer', 23191000, 'Batch mixers', 23190000, 'Mixers and their parts and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23191003, 'Double arm kneading mixers', 23191000, 'Batch mixers', 23190000, 'Mixers and their parts and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23191004, 'Intensive mixers', 23191000, 'Batch mixers', 23190000, 'Mixers and their parts and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23191101, 'Single screw mixers', 23191100, 'Continuous mixers', 23190000, 'Mixers and their parts and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23191102, 'Twin screw extruder', 23191100, 'Continuous mixers', 23190000, 'Mixers and their parts and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23201005, 'Bubble columns', 23201000, 'Gas liquid contacting systems', 23200000, 'Mass transfer equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23201201, 'Spray dryers', 23201200, 'Industrial drying equipment', 23200000, 'Mass transfer equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23201202, 'Air dryers', 23201200, 'Industrial drying equipment', 23200000, 'Mass transfer equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23201204, 'Food drying equipment', 23201200, 'Industrial drying equipment', 23200000, 'Mass transfer equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23211101, 'Semiconductor process systems', 23211100, 'Electronic manufacturing and processing machinery', 23210000, 'Electronic manufacturing machinery and equipment and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23211102, 'Printed circuit board making system', 23211100, 'Electronic manufacturing and processing machinery', 23210000, 'Electronic manufacturing machinery and equipment and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23211103, 'Wafer wire bonder', 23211100, 'Electronic manufacturing and processing machinery', 23210000, 'Electronic manufacturing machinery and equipment and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23211105, 'Vacuum impregnation or porosity sealing device', 23211100, 'Electronic manufacturing and processing machinery', 23210000, 'Electronic manufacturing machinery and equipment and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23221101, 'Stunner', 23221100, 'Killing and defeathering department machinery and equipment', 23220000, 'Chicken processing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23231101, 'Bandsaw wheel', 23231100, 'Bandsaws and accessories', 23230000, 'Sawmilling and lumber processing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23231102, 'Saw guide', 23231100, 'Bandsaws and accessories', 23230000, 'Sawmilling and lumber processing machinery and equipment', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241401, 'Bench grinder', 23241400, 'Metal grinding machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241402, 'Surface grinding machine', 23241400, 'Metal grinding machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241407, 'Cylindrical grinding machine', 23241400, 'Metal grinding machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241411, 'Buffing machine', 23241400, 'Metal grinding machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241503, 'Flame cutting machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241504, 'Gear cutting tool', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241505, 'Laser cutting machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241506, 'Plasma cutting machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241507, 'Sawing and cut-off machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241508, 'Water jet cutting machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241509, 'Metal band sawing machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241510, 'Metal shearing machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241511, 'Threading machine', 23241500, 'Metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241601, 'Boring tool', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241603, 'Countersink tool or counterbore tool', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241610, 'Pipe or tube cutter', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241611, 'Reamer', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241612, 'Shaper cutter', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241614, 'Solid milling cutter', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241615, 'Taps', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241616, 'Wire or cable cutter', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241617, 'Taper pin reamer', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241619, 'Pipe reamer', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241629, 'Metal slitting saw', 23241600, 'Metal cutting tools', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241701, 'Shot blasting machine', 23241700, 'Metal deburring machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241703, 'Vibratory or barrel finishing machine', 23241700, 'Metal deburring machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241801, 'Drill press or radial drill', 23241800, 'Metal drilling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241809, 'Bench drilling machine', 23241800, 'Metal drilling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241901, 'Horizontal boring machine', 23241900, 'Metal boring machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23241903, 'Metal broaching machines', 23241900, 'Metal boring machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242101, 'Bar or rod cutter', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242102, 'Electrode holder', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242104, 'Form tools or toolbits', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242107, 'Insert carbide', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242116, 'Tapping machine attachment', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242117, 'Threading machine attachment', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242118, 'Knurling tool', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242119, 'Lathe bit', 23242100, 'Metal cutting machine attachments', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242301, 'Automatic bar machine', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242302, 'Automatic lathe or chucking machine', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242303, 'Horizontal turning center', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242304, 'Tracer or duplicating or contouring lathe', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242305, 'Turret lathe', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242306, 'Vertical turning center', 23242300, 'Lathes and turning centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242401, 'Horizontal machining center', 23242400, 'Machining centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242402, 'Multi-tasking or universal machining center', 23242400, 'Machining centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242403, 'Vertical machining center', 23242400, 'Machining centers', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242503, 'Column and knee milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242504, 'Gantry milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242505, 'Profiling and duplicating milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242506, 'Traveling column milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242507, 'Universal milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242509, 'Turret milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242510, 'Planer style milling machine', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242511, 'Machine end mill', 23242500, 'Metal milling machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242602, 'Burnishing machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242603, 'Chamfering machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242604, 'Lapping machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242605, 'Metal polishing machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242609, 'Honing machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242612, 'Metal engraving machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242613, 'Tapping machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242614, 'Key seating machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23242615, 'Sheet metal grooving machine', 23242600, 'Specialized or miscellaneous metal cutting machines', 23240000, 'Metal cutting machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251501, 'Hydraulic press brake', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251502, 'Manual press brake', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251503, 'Metal folding machine', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251504, 'Tangent bender', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251505, 'Tube bending machine', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251506, 'Tube end finisher', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251507, 'Wing bender', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251508, 'Steel bar bending machine', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251509, 'Wire drawing machine', 23251500, 'Metal bending machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251602, 'Sheet metal forming machine', 23251600, 'Metal rolling machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251603, 'Rolling press', 23251600, 'Metal rolling machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251702, 'Impression and closed die forging press', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251703, 'Open die forging press', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251705, 'Roll forging machines', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251707, 'Trim press', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251709, 'Air hammer forging machine', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251712, 'Drop hammer forging machine', 23251700, 'Forging machines', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251802, 'Cutting die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251803, 'Die casting die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251805, 'Forge die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251808, 'Pipe bending mandrel', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251810, 'Stamping die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251812, 'Threading die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23251813, 'Cabling die', 23251800, 'Metal forming dies and tooling', 23250000, 'Metal forming machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23261501, 'Fused deposition modeling machine', 23261500, 'Rapid prototyping machines', 23260000, 'Rapid prototyping machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23261503, 'Laminated object manufacturing machine', 23261500, 'Rapid prototyping machines', 23260000, 'Rapid prototyping machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23261505, 'Selective laser sintering machine', 23261500, 'Rapid prototyping machines', 23260000, 'Rapid prototyping machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23261506, 'Stereolithography machine', 23261500, 'Rapid prototyping machines', 23260000, 'Rapid prototyping machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23261507, 'Three dimensional printing machine', 23261500, 'Rapid prototyping machines', 23260000, 'Rapid prototyping machinery and accessories', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271401, 'Submerged arc welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271402, 'Ultrasonic welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271404, 'Plasma arc welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271405, 'Laser welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271406, 'Spot welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271407, 'Tungsten inert gas welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271408, 'Metal inert gas welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271409, 'Shielded metal arc welding or stick welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271411, 'Plastic welder', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271413, 'Electron beam welding EBW machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271415, 'Cold pressure or contact welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271417, 'Braze welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271418, 'Flash butt welding machine', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271420, 'Seam welder', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271423, 'Alternating current AC arc welder', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271424, 'Direct current DC arc welder', 23271400, 'Welding machinery', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271601, 'Furnace soldering machine', 23271600, 'Soldering machines', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271603, 'Soldering iron', 23271600, 'Soldering machines', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271604, 'Wave soldering machine', 23271600, 'Soldering machines', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271607, 'Automatic soldering machine', 23271600, 'Soldering machines', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271701, 'Blow pipe', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271702, 'Blow torch', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271704, 'Desoldering Gun', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271705, 'Desoldering pump', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271707, 'Gas welding or brazing or cutting apparatus', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271708, 'Temperature indicating stick', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271709, 'Welding generator', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271710, 'Welding or brazing tip cleaner file', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271711, 'Welding or cutting tip', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271712, 'Welding or soldering kit', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271713, 'Welding positioner and manipulator', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271716, 'Welding tip dresser or accessories', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271717, 'Flashback arrestor', 23271700, 'Welding and soldering and brazing accessories', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271810, 'Welding electrode', 23271800, 'Welding and soldering and brazing supplies', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271813, 'Welding wire', 23271800, 'Welding and soldering and brazing supplies', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23271821, 'Welder torch', 23271800, 'Welding and soldering and brazing supplies', 23270000, 'Welding and soldering and brazing machinery and accessories and supplies', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281501, 'Anodizing machine', 23281500, 'Coating or plating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281502, 'Electrolytic bath machine', 23281500, 'Coating or plating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281503, 'Thermal spray machine', 23281500, 'Coating or plating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281601, 'Induction heating machine', 23281600, 'Heat treating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281602, 'Quench machine', 23281600, 'Heat treating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281603, 'Heat treating age hardening furnace', 23281600, 'Heat treating machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281702, 'Shot peening machine', 23281700, 'Mechanical surface treatment machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281703, 'Sand blasting machine', 23281700, 'Mechanical surface treatment machines', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281903, 'Mechanical or ultrasonic metal cleaner', 23281900, 'Metal cleaning machinery and supplies', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23281904, 'Aqueous cleaning and washing equipment', 23281900, 'Metal cleaning machinery and supplies', 23280000, 'Metal treatment machinery', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23291701, 'Reamer blade', 23291700, 'Industrial reaming tools', 23290000, 'Industrial machine tools', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (23291804, 'Threading insert', 23291800, 'Industrial threading tools', 23290000, 'Industrial machine tools', 23000000, 'Industrial Manufacturing and Processing Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101501, 'Carts', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101502, 'Bulk transporters', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101503, 'Dollies', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101504, 'Hand trucks or accessories', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101505, 'Pallet trucks', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101506, 'Pushcarts', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101507, 'Wheelbarrows', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101509, 'Wagons', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101510, 'Tilt trucks', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101512, 'Power buggies', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101513, 'Tugger', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101516, 'Powered platform truck', 24101500, 'Industrial trucks', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101601, 'Elevators', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101602, 'Hoists', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101603, 'Forklifts', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101604, 'Lifts', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101605, 'Loading equipment', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101606, 'Stackers', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101608, 'Winches', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101610, 'Manipulators', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101611, 'Slings', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101612, 'Jacks', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101613, 'Blocks or pulleys', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101614, 'Air bags for loading', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101616, 'Below the hook device', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101617, 'Scissor lift or lift table', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101618, 'Pipe layer', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101619, 'Bridge cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101620, 'Track cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101621, 'All terrain cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101622, 'Rough terrain cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101623, 'Tower cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101624, 'Hydraulic truck cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101625, 'Conventional truck cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101627, 'Girder trolleys', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101628, 'Adjustable forks', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101629, 'Forklift or elevator accessories or supplies', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101630, 'Workshop cranes', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101631, 'Suction cups', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101636, 'Counter weight bag and counterweight', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101637, 'Nylon fabric sling', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101641, 'Shackle', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101647, 'Material lifting clamp', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101651, 'Capstan', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101652, 'Jib crane', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101653, 'Overhead crane', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101657, 'Tractor mounted crane', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101661, 'Vehicle lift', 24101600, 'Lifting equipment and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101701, 'Conveyor roller', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101704, 'Conveyor feeders', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101705, 'Conveyor screw', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101707, 'Conveyor rails', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101708, 'Extendable conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101709, 'Roller conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101710, 'Package stops', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101711, 'Turntables', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101712, 'Belt conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101713, 'Bucket conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101714, 'Air conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101717, 'Conveyor idlers', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101722, 'Chain conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101727, 'Vibrating conveyors', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101730, 'Screw conveyor', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101749, 'Conveyor system', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101750, 'Overhead track conveyor', 24101700, 'Conveyors and accessories', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101803, 'Dock ramps', 24101800, 'Dock equipment', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101807, 'Dock plates', 24101800, 'Dock equipment', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101808, 'Wheel chocks', 24101800, 'Dock equipment', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101901, 'Drum openers', 24101900, 'Drum handling equipment', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24101902, 'Drum grabs', 24101900, 'Drum handling equipment', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102002, 'Bin handlers', 24102000, 'Shelving and storage', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102004, 'Storage racks or shelves', 24102000, 'Shelving and storage', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102005, 'Automated storage or retrieval systems', 24102000, 'Shelving and storage', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102006, 'Work benches', 24102000, 'Shelving and storage', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102101, 'Cargo handling equipment', 24102100, 'Warehousing equipment and supplies', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102104, 'Depalletizers', 24102100, 'Warehousing equipment and supplies', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102105, 'Palletizers', 24102100, 'Warehousing equipment and supplies', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102106, 'Industrial shrink wrap equipment', 24102100, 'Warehousing equipment and supplies', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102108, 'Packaging compactors', 24102100, 'Warehousing equipment and supplies', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102202, 'Box sealing tape dispensers', 24102200, 'Packing tools', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102204, 'Strapping dispenser', 24102200, 'Packing tools', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24102210, 'Baling press', 24102200, 'Packing tools', 24100000, 'Material handling machinery and equipment', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111501, 'Canvas bags', 24111500, 'Bags', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111802, 'Air or gas tanks or cylinders', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111803, 'Storage tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111804, 'Calibrating tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111805, 'Chemical tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111806, 'Dip tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111809, 'Processing tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111810, 'Water storage tanks', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24111814, 'Hot water tank', 24111800, 'Tanks and cylinders and their accessories', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112003, 'Non metallic bins', 24112000, 'Bins and baskets', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112004, 'Metallic bins', 24112000, 'Bins and baskets', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112006, 'Non metallic baskets', 24112000, 'Bins and baskets', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112007, 'Material handling racks', 24112000, 'Bins and baskets', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112402, 'Hazardous materials cabinets', 24112400, 'Storage chests and cabinets and trunks', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24112407, 'Mailboxes', 24112400, 'Storage chests and cabinets and trunks', 24110000, 'Containers and storage', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131503, 'Walk in refrigerators', 24131500, 'Industrial refrigerators', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131506, 'Refrigerated tanks', 24131500, 'Industrial refrigerators', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131601, 'Chest freezers', 24131600, 'Industrial freezers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131603, 'Low temperature freezers', 24131600, 'Industrial freezers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131605, 'Walk in freezers', 24131600, 'Industrial freezers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131606, 'Plate freezers', 24131600, 'Industrial freezers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131607, 'Blast freezers', 24131600, 'Industrial freezers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24131901, 'Ice cube makers', 24131900, 'Ice makers', 24130000, 'Industrial refrigeration', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24141506, 'Tarpaulins', 24141500, 'Securing and protecting supplies', 24140000, 'Packing supplies', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (24141511, 'Load binders', 24141500, 'Securing and protecting supplies', 24140000, 'Packing supplies', 24000000, 'Material Handling and Conditioning and Storage Machinery and their Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101501, 'Minibuses', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101502, 'Busses', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101503, 'Automobiles or cars', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101505, 'Minivans or vans', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101506, 'Limousines', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101507, 'Light trucks or sport utility vehicles', 25101500, 'Passenger motor vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101601, 'Dump trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101602, 'Tow trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101604, 'Delivery trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101609, 'Sludge or sewage handling trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101610, 'Water trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101611, 'Cargo trucks', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101612, 'Concrete transport truck', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101613, 'Concrete pump truck', 25101600, 'Product and material transport vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101701, 'Fire or rescue trucks', 25101700, 'Safety and rescue vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101702, 'Police vehicles', 25101700, 'Safety and rescue vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101703, 'Ambulances', 25101700, 'Safety and rescue vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101801, 'Motorcycles', 25101800, 'Motorized cycles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101803, 'Mopeds', 25101800, 'Motorized cycles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101901, 'Agricultural tractors', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101903, 'Snowmobiles or snow scooter', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101904, 'Golf carts', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101905, 'All terrain vehicles tracked or wheeled', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101906, 'Go cart', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101911, 'Aerial working platform truck', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101915, 'Oil tank truck', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101917, 'Flatbed truck', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101919, 'Road sweeper', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101931, 'Outside broadcasting van', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101935, 'Spray truck', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25101936, 'Vacuum truck', 25101900, 'Specialized and recreational vehicles', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25102101, 'Low cab forward tractors', 25102100, 'Truck tractors', 25100000, 'Motor vehicles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111501, 'Trawlers', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111502, 'Fishing boats', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111503, 'Cargo or container ships', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111505, 'Tankers', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111506, 'Tug boats', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111508, 'Passenger or automobile ferries', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111509, 'Cruise ships', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111510, 'Salvage ships', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111516, 'Inflatable rubber boat', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111527, 'Row boat', 25111500, 'Commercial marine craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111601, 'Lifeboats or liferafts', 25111600, 'Safety and rescue water craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111602, 'Fire fighting watercraft', 25111600, 'Safety and rescue water craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111603, 'Rescue ships or boats', 25111600, 'Safety and rescue water craft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111801, 'Recreational sailboats', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111802, 'Recreational motorboats', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111803, 'Recreational rowboats', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111804, 'Canoes or kayaks', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111805, 'Personal motorized watercraft', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111806, 'Rafts', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111807, 'Dinghies', 25111800, 'Recreational watercraft', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111901, 'Marine craft communications systems', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111904, 'Paddles', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111906, 'Anchor chocks', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111907, 'Anchor lines', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111908, 'Anchor retrievers', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111909, 'Anchor rollers', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111911, 'Boathooks', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111914, 'Dock rings', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111916, 'Emergency dye signals', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111920, 'Marine fenders', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111924, 'Radar reflectors', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111925, 'Marine rudders', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111927, 'Sail booms', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111934, 'Tillers', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25111938, 'Marine steering gear', 25111900, 'Marine craft systems and subassemblies', 25110000, 'Marine transport', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121501, 'Diesel freight locomotives', 25121500, 'Locomotives and electric trolleys', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121502, 'Electric freight locomotives', 25121500, 'Locomotives and electric trolleys', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121503, 'Diesel passenger locomotives', 25121500, 'Locomotives and electric trolleys', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121504, 'Electric passenger locomotives', 25121500, 'Locomotives and electric trolleys', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121601, 'Freight rail cars', 25121600, 'Railway and tramway cars', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121605, 'Streetcars or tramway cars', 25121600, 'Railway and tramway cars', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121607, 'Railway or tramway maintenance or service vehicle', 25121600, 'Railway and tramway cars', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121701, 'Rail switching systems', 25121700, 'Railroad support equipment and systems', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121705, 'Rail couplers', 25121700, 'Railroad support equipment and systems', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25121714, 'Heavy rail turnout switch', 25121700, 'Railroad support equipment and systems', 25120000, 'Railway and tramway machinery and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25131504, 'Commercial passenger propeller aircraft', 25131500, 'Powered fixed wing aircraft', 25130000, 'Aircraft', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25131603, 'Agricultural helicopters', 25131600, 'Civilian and commercial rotary wing aircraft', 25130000, 'Aircraft', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25131705, 'Target or reconnaissance drones', 25131700, 'Military fixed wing aircraft', 25130000, 'Aircraft', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25131801, 'Airships', 25131800, 'Specialty aircraft', 25130000, 'Aircraft', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25161501, 'Touring bicycles', 25161500, 'Pedal powered vehicles', 25160000, 'Non motorized cycles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25161505, 'Mountain bicycles', 25161500, 'Pedal powered vehicles', 25160000, 'Non motorized cycles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25161506, 'Racing bicycles', 25161500, 'Pedal powered vehicles', 25160000, 'Non motorized cycles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25161507, 'Bicycles', 25161500, 'Pedal powered vehicles', 25160000, 'Non motorized cycles', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25171603, 'Train defrosting or defogging systems', 25171600, 'Defrosting and defogging systems', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25171703, 'Train braking systems', 25171700, 'Braking systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25171718, 'Brake repair kits', 25171700, 'Braking systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172104, 'Seatbelts', 25172100, 'Vehicle safety and security systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172110, 'Vehicle horns', 25172100, 'Vehicle safety and security systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172113, 'Vehicle traction control systems', 25172100, 'Vehicle safety and security systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172114, 'Wheel clamps', 25172100, 'Vehicle safety and security systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172203, 'Automotive doors', 25172200, 'Vehicle doors', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172503, 'Heavy truck tires', 25172500, 'Tires and tire tubes', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172511, 'Tire repair kit', 25172500, 'Tires and tire tubes', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172802, 'Automotive hydraulic systems', 25172800, 'Hydraulic systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172901, 'Exterior automobile lighting', 25172900, 'Exterior vehicle lighting', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25172904, 'Exterior ship or boat lighting', 25172900, 'Exterior vehicle lighting', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25173107, 'Vehicular global positioning system GPS', 25173100, 'Location and navigation systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25173108, 'Vehicle navigation systems', 25173100, 'Location and navigation systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25173303, 'Automotive computer systems', 25173300, 'Master control systems', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25173701, 'Catalytic converters', 25173700, 'Exhaust and emission controls', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25174002, 'Engine radiators', 25174000, 'Engine coolant system', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25174101, 'Emergency vehicle exits', 25174100, 'Roof systems', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25174210, 'Power steering tuning cable', 25174200, 'Steering system', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25174803, 'Towing hook', 25174800, 'Specialized vehicle systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25174810, 'Vehicle jack', 25174800, 'Specialized vehicle systems and components', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25175003, 'Electric vehicle charging kit', 25175000, 'Electric vehicle charging systems', 25170000, 'Transportation components and systems', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181701, 'Container trailers', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181702, 'Flatbed trailers', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181703, 'Livestock trailers', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181704, 'Non temperature controlled tanker trailers', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181706, 'Temperature controlled container trailers', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181708, 'Trailer hitches', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181713, 'Boat Trailer', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25181717, 'Low bed trailer', 25181700, 'Product and material trailers', 25180000, 'Vehicle bodies and trailers', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191503, 'Integrated maintenance information systems', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191504, 'Aircraft flight simulators or trainers', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191505, 'Aircraft cargo handling equipment', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191507, 'Aircraft deicing equipment', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191509, 'Aircraft pushback or tow tractors', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191510, 'Ground power units for aircraft', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191520, 'Environmental test chamber', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191523, 'Airplane baggage tug or tractor', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191524, 'Airfreight conveyor truck', 25191500, 'Air transportation support systems and equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191701, 'Wheel balancing equipment', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191702, 'Wheel alignment equipment', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191703, 'Tire changing machines', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191704, 'Engine or vehicle stands', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191706, 'Railway rolling stock lifting jack', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191707, 'Railway lift table for engine and component', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191708, 'Carburetor balancer', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191711, 'Valve refacer', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191712, 'Valve seat cutter', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191714, 'Brake drum lathe', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191716, 'Brake spring pliers', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191719, 'Wheel nut or lug wrench', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191720, 'Spark plug wrench', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191725, 'Automotive boring machine', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191726, 'Automotive honing machine', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191729, 'Crankshaft grinder', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191730, 'Timing light', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191734, 'Valve spring compressor', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191735, 'Piston ring compressor', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191738, 'Tire spreader', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191742, 'Vehicle parts washing machine', 25191700, 'Vehicle servicing equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191801, 'Growler tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191806, 'Battery hydrometer', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191808, 'Brake tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191809, 'Side slip tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191813, 'Spark plug gap gauge', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191814, 'Spark plug tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191815, 'Armature tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191817, 'Compression pressure gauge', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191822, 'Engine injector tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191824, 'Engine tune up tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191834, 'Coil condenser resistance or ohm tester', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25191835, 'Tire pressure gauge', 25191800, 'Vehicle testing and measuring equipment', 25190000, 'Transportation services equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201602, 'Aircraft navigation beacons', 25201600, 'Aerospace location and navigation systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201604, 'Aircraft guidance systems', 25201600, 'Aerospace location and navigation systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201605, 'Aircraft steering controls', 25201600, 'Aerospace location and navigation systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201701, 'Aircraft communication systems', 25201700, 'Flight communications related systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201801, 'Flight computer systems', 25201800, 'Aircraft master control systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201901, 'Aircraft fire control or extinguishing systems', 25201900, 'Aircraft emergency systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201902, 'Aircraft escape or ejection systems', 25201900, 'Aircraft emergency systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201903, 'Aircraft warning systems', 25201900, 'Aircraft emergency systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25201904, 'Parachutes', 25201900, 'Aircraft emergency systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202003, 'Aircraft power supply units', 25202000, 'Aircraft power systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202103, 'Aerospace cockpit display panels', 25202100, 'Flight instrumentation', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202105, 'Aerospace head up display HUDs', 25202100, 'Flight instrumentation', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202201, 'Aircraft braking systems', 25202200, 'Aircraft landing and braking systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202202, 'Aircraft drag chutes', 25202200, 'Aircraft landing and braking systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202204, 'Landing gear assemblies', 25202200, 'Aircraft landing and braking systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202206, 'Aircraft anti skid controls', 25202200, 'Aircraft landing and braking systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202405, 'Aircraft fuel management systems', 25202400, 'Aircraft fuel tanks and systems', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202501, 'Aircraft hydraulic systems', 25202500, 'Aircraft equipment', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202505, 'Aircraft onboard defrosting or defogging systems', 25202500, 'Aircraft equipment', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202601, 'Aircraft environment controllers', 25202600, 'Aircraft environmental control systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202602, 'Aircraft environment regulators', 25202600, 'Aircraft environmental control systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202604, 'Aircraft cooling fans', 25202600, 'Aircraft environmental control systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202607, 'Aircraft oxygen equipment', 25202600, 'Aircraft environmental control systems and components', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (25202702, 'Pneumatic aircraft accumulators', 25202700, 'Aircraft accumulators', 25200000, 'Aerospace systems and components and equipment', 25000000, 'Commercial and Military and Private Vehicles and their Accessories and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101112, 'General purpose motor AC', 26101100, 'Electric alternating current AC motors', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101209, 'Brushless motor DC', 26101200, 'Electric direct current DC motors', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101304, 'Hydraulic motor', 26101300, 'Non electric motors', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101503, 'Gas engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101504, 'Diesel engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101505, 'Steam engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101506, 'Turbine engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101508, 'Thermal engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101509, 'Hydroelectric engines', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101515, 'Gasoline outboard motor', 26101500, 'Engines', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101702, 'Aircraft engine compressors', 26101700, 'Engine components and accessories', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101718, 'Engine ignition systems', 26101700, 'Engine components and accessories', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26101750, 'Throttle', 26101700, 'Engine components and accessories', 26100000, 'Power sources', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111516, 'Step drive or stepper drive or step indexer', 26111500, 'Kinetic power transmission', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111519, 'Torque converters', 26111500, 'Kinetic power transmission', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111527, 'Integrated motion control systems', 26111500, 'Kinetic power transmission', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111601, 'Diesel generators', 26111600, 'Power generators', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111604, 'Gas generators', 26111600, 'Power generators', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111606, 'Hydraulic generators', 26111600, 'Power generators', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111608, 'Steam generators', 26111600, 'Power generators', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111611, 'Auxiliary generator', 26111600, 'Power generators', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111704, 'Battery chargers', 26111700, 'Batteries and cells and accessories', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26111719, 'Battery testers', 26111700, 'Batteries and cells and accessories', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26112004, 'Clutch repair kits', 26112000, 'Clutch parts and accessories', 26110000, 'Batteries and generators and kinetic power transmission', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26121604, 'Signal cable', 26121600, 'Electrical cable and accessories', 26120000, 'Electrical wire and cable and harness', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26121623, 'Radio frequency RF cable', 26121600, 'Electrical cable and accessories', 26120000, 'Electrical wire and cable and harness', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26121630, 'Cable accessories', 26121600, 'Electrical cable and accessories', 26120000, 'Electrical wire and cable and harness', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26121635, 'Cable reels', 26121600, 'Electrical cable and accessories', 26120000, 'Electrical wire and cable and harness', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131504, 'Gas power plants', 26131500, 'Power plants', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131604, 'Fixed screens', 26131600, 'Exhaust structures or screening equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131605, 'Intake structures', 26131600, 'Exhaust structures or screening equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131608, 'Flare or vent stacks', 26131600, 'Exhaust structures or screening equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131611, 'Silencer sections', 26131600, 'Exhaust structures or screening equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131701, 'Combustible or hazardous gas detectors for power generators', 26131700, 'Power generation monitoring or detecting equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131801, 'Electrical control panels for generators', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131802, 'Compressor control panels', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131803, 'Generator control or protection panels', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131804, 'Gas turbine control panels', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131808, 'Substation load control switchgears', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26131813, 'Switchyard disconnect switches', 26131800, 'Power generation control equipment', 26130000, 'Power generation', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141702, 'Dosimeters', 26141700, 'Dosimetry equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141704, 'Phantom dosimeters', 26141700, 'Dosimetry equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141801, 'Hot cell remote handling equipment', 26141800, 'Hot cell devices', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141802, 'Hot cell remote viewing device', 26141800, 'Hot cell devices', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141902, 'Beta gauge measuring systems', 26141900, 'Industrial nucleonic instruments', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26141906, 'Industrial nucleonic moisture measuring systems', 26141900, 'Industrial nucleonic instruments', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26142001, 'Irradiation gamma sources', 26142000, 'Irradiation equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26142106, 'Nuclear reactor control rod systems', 26142100, 'Nuclear reactor equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26142117, 'Nuclear reactor earthquake instrumentation', 26142100, 'Nuclear reactor equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26142202, 'Nuclear fuel element failure detection systems', 26142200, 'Nuclear fuel equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (26142407, 'Radioactive waste disposal systems', 26142400, 'Radioactive waste equipment', 26140000, 'Atomic and nuclear energy machinery and equipment', 26000000, 'Power Generation and Distribution Machinery and Accessories');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111501, 'Knife blades', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111502, 'Razor knives', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111503, 'Utility knives', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111504, 'Pocket knives', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111505, 'Punches or nail sets or drifts', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111506, 'Shears', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111507, 'Metal cutters', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111508, 'Saws', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111509, 'Augers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111510, 'Stripping tools', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111511, 'Wire cutters', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111512, 'Bolt cutters', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111513, 'Hose cutter', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111514, 'Glass cutters', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111515, 'Hand or push drill', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111516, 'Punching pliers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111517, 'Knife blade sets or dispensers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111518, 'Wire lug crimping tool', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111519, 'Tinners snips', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111520, 'Nut splitters', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111521, 'Nibblers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111522, 'Flaring tool', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111525, 'Pincers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111526, 'Deburring tool', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111529, 'Insulated scissors', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111531, 'Hair scissors', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111532, 'Jeweler scissors', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111533, 'Butcher scissors', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111535, 'Wire scissors', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111536, 'Circle cutter', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111537, 'Wood auger bit', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111541, 'Bullet pilot point', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111549, 'Pad or keyhole saw', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111552, 'Coping saw', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111554, 'Blade sharpener', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111555, 'Center punch', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111556, 'Hollow punch', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111557, 'Taper punch', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111558, 'Parallel pin punch', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111559, 'Hacksaw', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111560, 'Mini pliers', 27111500, 'Cutting and crimping and punching tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111601, 'Mallets', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111602, 'Hammers', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111603, 'Anvils', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111604, 'Hatchets', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111605, 'Picks', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111607, 'Swaging tools', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111608, 'Manual wire straighteners', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111611, 'Stonemason hammer', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111612, 'Non sparking hammer or mallet', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111615, 'Sledge hammer', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111616, 'Ball peen hammer', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111617, 'Rubber mallet', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111618, 'Claw hammer', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111619, 'Cross and straight pein hammer', 27111600, 'Forming tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111701, 'Screwdrivers', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111702, 'Nut drivers', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111703, 'Socket sets', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111704, 'Sockets', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111705, 'Box end wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111706, 'Open end wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111707, 'Adjustable wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111708, 'Pipe wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111709, 'Screw extractors', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111710, 'Hex keys', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111711, 'Ratchets', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111712, 'Pullers', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111713, 'Combination wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111714, 'Specialty wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111715, 'Torque wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111716, 'Torx keys', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111717, 'Pipe extractors', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111718, 'Tap extractors', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111720, 'T handle tap wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111722, 'Die stocks', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111723, 'Tube wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111724, 'Hook wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111725, 'Offset socket wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111726, 'Spanner wrenches', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111727, 'Chuck keys', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111728, 'Screwdriver set', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111731, 'Precision screwdriver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111734, 'Multiple tip screwdriver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111736, 'Insulated screwdriver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111739, 'Torque screwdriver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111742, 'Impact screwdriver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111743, 'Ring wrench or spanner', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111749, 'Pipe wrench or stillson wrench', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111756, 'Crows foot wrench', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111763, 'Allen wrench', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111767, 'Offset screw driver', 27111700, 'Wrenches and drivers', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111801, 'Tape measures', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111802, 'Levels', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111803, 'Squares', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111804, 'Plumb bobs', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111807, 'Straight edges', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111809, 'Bevels', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111810, 'Stud finders', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111814, 'Inspection mirror', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111815, 'Combination square', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111822, 'Angle measuring instrument', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111823, 'Center gauge', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111824, 'Angle gauge', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111826, 'Precision surface plate', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111827, 'Adjustable angle plate', 27111800, 'Measuring and layout tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111901, 'Cold chisels', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111903, 'Planes', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111904, 'Rasps', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111905, 'Grinders', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111906, 'Wood chisels', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111907, 'Wire brushes', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111908, 'Sharpening stones or tools or kits', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111909, 'Spatulas', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111911, 'Cross cut chisels', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111912, 'Wood gouge', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111915, 'Stonemason chisel', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111918, 'Hand sander', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111919, 'Bastard cut file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111920, 'Second cut file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111921, 'Smooth cut file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111925, 'Needle file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111928, 'Cheesegrater file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111929, 'Flat hand file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111930, 'Round file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111931, 'Half round file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111932, 'Square file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111934, 'Flat taper file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111935, 'Knife file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111937, 'Laminate file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111940, 'Mill saw file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111943, 'Farmers own file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111944, 'Precision file', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111956, 'Burnisher', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27111958, 'Hand lapper', 27111900, 'Rough and finishing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112001, 'Machetes', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112002, 'Spades', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112003, 'Rakes', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112004, 'Shovels', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112005, 'Axes', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112007, 'Secateurs or pruning shears', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112008, 'Hoes', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112009, 'Scrapers', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112010, 'Garden forks', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112013, 'Post hole digger', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112014, 'Lawnmowers', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112015, 'Lawn scarifiers', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112016, 'Hedge clippers', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112017, 'Digging bars', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112019, 'Pruning saw', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112023, 'Hand cultivator', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112034, 'Root cutter', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112035, 'Hedge trimmer', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112036, 'Garden shredder', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112037, 'Brush cutter', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112038, 'Garden chainsaw', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112039, 'Lopper', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112040, 'Soil probe', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112041, 'Grafting knife', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112047, 'High branch shears', 27112000, 'Agriculture, forestry and garden handtools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112101, 'Pipe vises', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112102, 'Bench vises', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112103, 'Hand clamps', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112104, 'Tongs', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112105, 'Tweezers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112106, 'Linemans pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112107, 'Adjustable widemouth pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112108, 'Needlenose pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112109, 'Magnetic tools', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112110, 'Retaining ring pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112112, 'Tongue and groove pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112113, 'Slip or groove joint pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112114, 'Diagonal cut pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112115, 'Locking pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112117, 'End cut pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112119, 'Light bulb changer', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112120, 'C clamps', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112121, 'Corner clamps', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112122, 'Sheet metal pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112123, 'Bench dog', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112124, 'Tensioners', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112125, 'Round nose pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112126, 'Flat nose pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112127, 'Strap wrenches', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112128, 'Curved nose pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112132, 'Hold down clamps', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112134, 'Longnose pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112139, 'Combination pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112140, 'Circlip pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112142, 'Multi tool pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112144, 'Snap pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112145, 'Slip joint pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112146, 'Swivel base vise', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112147, 'Crimping pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112148, 'Electronics pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112150, 'Jewellers pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112151, 'Wire-stripping pliers', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112154, 'Milling vise', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112155, 'Piston ring expander', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112156, 'Hand vise', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112157, 'Drill vise', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112160, 'Wire twister', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112161, 'Wire wrapping tool', 27112100, 'Holding and clamping tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112201, 'Trowels', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112202, 'Floats', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112203, 'Edgers', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112205, 'Concrete vibrators', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112217, 'Tile cutter', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112218, 'Tile power saw', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112224, 'Profile gauge', 27112200, 'Masonry and concrete tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112302, 'Awls', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112303, 'Scribers', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112304, 'Chalk lines', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112305, 'Metal markers or holders', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112306, 'Metal stamps', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112312, 'Surface gauge', 27112300, 'Marking tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112401, 'Staple guns', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112402, 'Rivet tools', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112403, 'Banders', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112404, 'Anchor setting tools', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112406, 'Tag guns', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112407, 'Security tag detacher', 27112400, 'Fastener setting tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112501, 'Pipe bending tools', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112502, 'Pry bars', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112503, 'Conduit benders', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112504, 'Wedges', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112505, 'Packing hooks', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112506, 'Hickeys', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112507, 'Wrecking or crow bar', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112508, 'Cable bender', 27112500, 'Prying and bending tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112601, 'Putty knives', 27112600, 'Sealing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112603, 'Insertion tool', 27112600, 'Sealing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112701, 'Power blowers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112702, 'Power buffers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112703, 'Power drills', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112704, 'Power grinders', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112705, 'Demolition hammers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112706, 'Power planes', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112707, 'Power routers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112708, 'Power sanders', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112709, 'Power saws', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112710, 'Power screwguns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112711, 'Power staple guns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112712, 'Power trimmers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112713, 'Impact wrenches', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112714, 'Power caulking guns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112715, 'Power chippers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112716, 'Power nail guns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112717, 'Heat guns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112718, 'Engravers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112719, 'Glue guns', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112720, 'Torque tools', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112721, 'Biscuit jointers', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112723, 'Power shears', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112724, 'Power nibbler', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112725, 'Power riveter', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112728, 'Power flaring tool', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112730, 'Power grease gun', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112731, 'Power scissors', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112733, 'Angle cutter', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112734, 'Jigsaw', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112735, 'Scroll saw', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112737, 'Orbital sander', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112739, 'Belt sander', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112742, 'Disc sander', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112746, 'Chain saw', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112747, 'Reciprocating saw', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112748, 'Miter saw', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112749, 'Angle grinder', 27112700, 'Power tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112802, 'Saw blades', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112803, 'End mills', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112804, 'Stamping dies or punches', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112805, 'Threading dies', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112806, 'Threading taps', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112807, 'Chucks', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112808, 'Collets', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112809, 'Tool holders', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112810, 'Thread repair kits', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112811, 'Arbors', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112812, 'Countersinks', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112813, 'Extension pole', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112814, 'Screwdriver bits', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112820, 'Lug crimping tool dies', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112821, 'Router bits', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112825, 'Tool template sets', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112826, 'Hole saws', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112827, 'Magnetizer demagnetizer devices', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112830, 'Screwdriver accessories and supplies', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112831, 'Wrench accessories and supplies', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112832, 'Socket attachments and accessories', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112835, 'Machine reamer', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112837, 'Hand reamer', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112838, 'Cutting disc', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112839, 'Chisel bit', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112842, 'Hand drill bit for wood', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112845, 'Drill bit set', 27112800, 'Tool attachments and accessories', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112901, 'Grease guns', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112902, 'Industrial funnels', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112903, 'Hand sprayers', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112904, 'Resin guns', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112905, 'Oil can', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112906, 'Caulking guns', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112907, 'Broadcast spreaders', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112908, 'Oil gun', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112909, 'Roofing mop', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112912, 'Oil changer', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112913, 'Oil lubricator', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27112914, 'Grease lubricator', 27112900, 'Dispensing tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113001, 'Scratch brushes', 27113000, 'Brushes', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113002, 'Tube brushes', 27113000, 'Brushes', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113003, 'Applicator brushes', 27113000, 'Brushes', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113005, 'Roofing brush', 27113000, 'Brushes', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113101, 'Fish tape', 27113100, 'Pulling tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113102, 'Fuse pullers', 27113100, 'Pulling tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113103, 'Fids', 27113100, 'Pulling tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113201, 'General tool kits', 27113200, 'Tool kits', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113202, 'Bearing fitting tool kits', 27113200, 'Tool kits', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113203, 'Computer tool kits', 27113200, 'Tool kits', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113204, 'Electrician kits', 27113200, 'Tool kits', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27113301, 'Magnifying glass', 27113300, 'Precision hand tools', 27110000, 'Hand tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121502, 'Hydraulic press frames', 27121500, 'Hydraulic presses', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121504, 'Industrial hydraulic press', 27121500, 'Hydraulic presses', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121604, 'Hydraulic cylinder or component repair kits', 27121600, 'Hydraulic cylinders and pistons', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121701, 'Hydraulic quick connectors', 27121700, 'Hydraulic hose and tube fittings', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121802, 'Hydraulic accumulators', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121804, 'Hydraulic shears', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121805, 'Hydraulic extractor', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121810, 'Hydraulic hand crimp tool', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121813, 'Hydraulic classifier', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27121814, 'Compression die adaptor', 27121800, 'Hydraulic tools', 27120000, 'Hydraulic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131501, 'Pneumatic impact wrenches', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131502, 'Compressed air gun', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131504, 'Pneumatic hammer', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131505, 'Pneumatic drill', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131506, 'Pneumatic nail drivers', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131507, 'Pneumatic sanding machines', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131511, 'Pneumatic grinders', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131512, 'Pneumatic screwdriver', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131521, 'Pneumatic riveter', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131526, 'Pneumatic press', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131528, 'Pneumatic nail puller', 27131500, 'Pneumatic tools', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131601, 'Air manifolds', 27131600, 'Air fittings and connectors', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131604, 'Pneumatic lubricators', 27131600, 'Air fittings and connectors', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27131615, 'Pneumatic vacuum generator', 27131600, 'Air fittings and connectors', 27130000, 'Pneumatic machinery and equipment', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27141001, 'Trim or molding tools', 27141000, 'Body tools', 27140000, 'Automotive specialty tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (27141101, 'Steering wheel puller', 27141100, 'Suspension tools', 27140000, 'Automotive specialty tools', 27000000, 'Tools and General Machinery');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30121802, 'Tree protection rod', 30121800, 'Landscape architecture materials', 30120000, 'Roads and landscape', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30151610, 'Hip and ridge', 30151600, 'Roofing accessories', 30150000, 'Exterior finishing materials', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30161508, 'Wallpaper roller', 30161500, 'Wall finishing materials', 30160000, 'Interior finishing materials', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30171512, 'Door openers', 30171500, 'Doors', 30170000, 'Doors and windows and glass', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30181504, 'Sinks', 30181500, 'Sanitary ware', 30180000, 'Plumbing fixtures', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30181517, 'Whirlpool tub', 30181500, 'Sanitary ware', 30180000, 'Plumbing fixtures', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30181614, 'Soap dispenser', 30181600, 'Non sanitary residential fixtures', 30180000, 'Plumbing fixtures', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191501, 'Ladders', 30191500, 'Ladders and scaffolding', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191502, 'Scaffolding', 30191500, 'Ladders and scaffolding', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191505, 'Step stool', 30191500, 'Ladders and scaffolding', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191506, 'Platform step ladder', 30191500, 'Ladders and scaffolding', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191601, 'Scaffolding handrail', 30191600, 'Ladders and scaffolding accessories', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30191602, 'Scaffolding stabilizers', 30191600, 'Ladders and scaffolding accessories', 30190000, 'Construction and maintenance support equipment', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (30241508, 'Gin pole and accessories', 30241500, 'Portable Structure Consolidating Components', 30240000, 'Portable Structure Building Components', 30000000, 'Structures and Building and Construction and Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31141501, 'Plastic injection moldings', 31141500, 'Injection moldings', 31140000, 'Moldings', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31141503, 'Glass injection moldings', 31141500, 'Injection moldings', 31140000, 'Moldings', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31141603, 'Glass vacuum moldings', 31141600, 'Vacuum moldings', 31140000, 'Moldings', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151504, 'Nylon rope', 31151500, 'Ropes', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151505, 'Wire rope', 31151500, 'Ropes', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151507, 'String or twine', 31151500, 'Ropes', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151601, 'Safety chains', 31151600, 'Chains', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151703, 'Lifting cables', 31151700, 'Mechanical cable', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151902, 'Leather straps', 31151900, 'Straps', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31151906, 'Ratchet tie down strap', 31151900, 'Straps', 31150000, 'Rope and chain and cable and wire and strap', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31161610, 'Eye bolts', 31161600, 'Bolts', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31161816, 'Spacers or standoffs', 31161800, 'Washers', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162008, 'Drive pins', 31162000, 'Nails', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162103, 'Wall anchors', 31162100, 'Anchors', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162108, 'Tie down anchors', 31162100, 'Anchors', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162405, 'Turnbuckles', 31162400, 'Miscellaneous fasteners', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162407, 'Latch', 31162400, 'Miscellaneous fasteners', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162415, 'Pawls', 31162400, 'Miscellaneous fasteners', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162502, 'Angle brackets', 31162500, 'Brackets and braces', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162503, 'Braces', 31162500, 'Brackets and braces', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162601, 'Swivel hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162603, 'S hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162604, 'Safety hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162605, 'Lifting hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162606, 'J hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162608, 'Grab hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162609, 'Screw hooks', 31162600, 'Hooks', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162703, 'Sliders', 31162700, 'Rolling hardware', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162803, 'Shackles', 31162800, 'Miscellaneous hardware', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162807, 'Levers', 31162800, 'Miscellaneous hardware', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162810, 'Splices or splice plates', 31162800, 'Miscellaneous hardware', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162901, 'Ear clamps', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162903, 'Screw clamps', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162906, 'Hose or pipe clamps', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162907, 'Extending clamp', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162912, 'Sash clamp', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162913, 'Bench clamp', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162914, 'Web clamp', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31162918, 'Power clamp', 31162900, 'Clamps', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31163101, 'Quick disconnects', 31163100, 'Connectors', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31163301, 'Double ended stud', 31163300, 'Studs', 31160000, 'Hardware', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31171804, 'Sheaves or pulleys', 31171800, 'Industrial wheels', 31170000, 'Bearings and bushings and wheels and gears', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31181704, 'Stuffing box', 31181700, 'Packings and glands', 31180000, 'Packings glands boots and covers', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191504, 'Abrasive cloth', 31191500, 'Abrasives and abrasive media', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191506, 'Abrasive discs', 31191500, 'Abrasives and abrasive media', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191509, 'Abrasive polishers', 31191500, 'Abrasives and abrasive media', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191510, 'Abrasive stones', 31191500, 'Abrasives and abrasive media', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191519, 'Abrasive drums', 31191500, 'Abrasives and abrasive media', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31191603, 'Tungsten carbide abrasive wheels', 31191600, 'Abrasive wheels', 31190000, 'Grinding and polishing and smoothing materials', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31201527, 'Foam tapes', 31201500, 'Tape', 31200000, 'Adhesives and sealants', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211502, 'Water based paints', 31211500, 'Paints and primers', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211901, 'Drop cloths', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211902, 'Edging tools', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211903, 'Masking equipment', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211904, 'Paint brushes', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211905, 'Paint mixers', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211906, 'Paint rollers', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211908, 'Paint sprayers', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211914, 'Air brushes', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31211915, 'Paint strainers', 31211900, 'Paint applicators and painting accessories', 31210000, 'Paints and primers and finishes', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31241502, 'Prisms', 31241500, 'Lenses and prisms', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31241702, 'Metallic mirrors', 31241700, 'Mirrors', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31241703, 'Parabolic mirrors', 31241700, 'Mirrors', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31241804, 'Laser filters', 31241800, 'Optical filters', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31241807, 'Visual filters', 31241800, 'Optical filters', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242101, 'Optical mounts', 31242100, 'Optical device accessories', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242104, 'Optical rails or bases', 31242100, 'Optical device accessories', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242201, 'Optical beamsplitters', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242202, 'Polarizers', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242204, 'Optical diffusers', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242206, 'Optical flats', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242207, 'Optical breadboards', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31242208, 'Optical choppers', 31242200, 'Miscellaneous optical components', 31240000, 'Industrial optics', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31251501, 'Electric actuators', 31251500, 'Actuators', 31250000, 'Pneumatic and hydraulic and electric control systems', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31251502, 'Electronic actuators', 31251500, 'Actuators', 31250000, 'Pneumatic and hydraulic and electric control systems', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31251504, 'Pneumatic actuators', 31251500, 'Actuators', 31250000, 'Pneumatic and hydraulic and electric control systems', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (31251505, 'Valve actuators', 31251500, 'Actuators', 31250000, 'Pneumatic and hydraulic and electric control systems', 31000000, 'Manufacturing Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101514, 'Amplifiers', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101515, 'Attenuators', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101520, 'Dummy loads', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101522, 'Isolators', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101524, 'Phase shifters', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101527, 'Terminations', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101528, 'Modulators', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101535, 'Phase modulation circuit', 32101500, 'Circuit assemblies and radio frequency RF components', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101613, 'Transistor transistor logic TTL', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101625, 'Motor drive or control integrated circuits', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101626, 'Microprocessors', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101628, 'Microcontrollers', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101629, 'Operational amplifiers', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101631, 'Voltage comparator integrated circuits', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32101636, 'Digital Signal Processor DSP', 32101600, 'Integrated circuits', 32100000, 'Printed circuits and integrated circuits and microassemblies', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32111506, 'Photosensitive diodes', 32111500, 'Diodes', 32110000, 'Discrete semiconductor devices', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32121603, 'Variable resistors or varistors', 32121600, 'Resistors', 32120000, 'Passive discrete components', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32121610, 'Thermistor', 32121600, 'Resistors', 32120000, 'Passive discrete components', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32121701, 'Rectifiers', 32121700, 'Discrete components', 32120000, 'Passive discrete components', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32131001, 'Heat sinks', 32131000, 'Electronic component parts and raw materials and accessories', 32130000, 'Electronic hardware and component parts and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32131010, 'Bare printed circuit boards', 32131000, 'Electronic component parts and raw materials and accessories', 32130000, 'Electronic hardware and component parts and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32141009, 'Photo tubes', 32141000, 'Electron Tubes', 32140000, 'Electron tube devices and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32141101, 'Cathodes or emitters', 32141100, 'Electron tube parts and accessories', 32140000, 'Electron tube devices and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32141104, 'Deflecting devices', 32141100, 'Electron tube parts and accessories', 32140000, 'Electron tube devices and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (32151707, 'Programmable Logic Controller Programming Device', 32151700, 'Programmable Logic Controllers', 32150000, 'Automation control devices and components and accessories', 32000000, 'Electronic Components and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101602, 'Medical lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101605, 'Fluorescent lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101609, 'Stage or studio lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101612, 'Incandescent lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101613, 'Infrared lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101615, 'Mercury vapor lamp HID', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101616, 'Ultraviolet UV lamps', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101617, 'High pressure sodium lamp HID', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39101625, 'Xenon lamp', 39101600, 'Lamps and lightbulbs', 39100000, 'Lamps and lightbulbs and lamp components', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111504, 'Stage or projection or studio lighting system', 39111500, 'Interior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111542, 'Magnifying lamp', 39111500, 'Interior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111603, 'Roadway or highway lighting', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111606, 'Underwater lighting', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111609, 'Lighting pole or post and hardware', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111610, 'Flashlight', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111611, 'Flood light', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111612, 'Area lighting', 39111600, 'Exterior lighting fixtures and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111703, 'Storm lights', 39111700, 'Emergency lighting and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111705, 'Glow stick or light stick', 39111700, 'Emergency lighting and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111706, 'Strobe or warning lights', 39111700, 'Emergency lighting and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111709, 'Emergency light unit', 39111700, 'Emergency lighting and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111714, 'Signal Flare', 39111700, 'Emergency lighting and accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39111806, 'Light boxes', 39111800, 'Lighting accessories', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112201, 'Atmospheric effect apparatus', 39112200, 'Special effects devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112202, 'Bubble machine', 39112200, 'Special effects devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112401, 'Dimmers and accessories', 39112400, 'Stage and studio lighting dimming and control devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112501, 'Focus spots', 39112500, 'Stage and studio luminaires', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112502, 'Follow spots', 39112500, 'Stage and studio luminaires', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112601, 'Alcohol lamp', 39112600, 'Non electrical lighting devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112602, 'Candle holder', 39112600, 'Non electrical lighting devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39112603, 'Kerosene or propane or natural gas or butane lantern', 39112600, 'Non electrical lighting devices', 39110000, 'Lighting Fixtures and Accessories', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121002, 'Power supply transformers', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121003, 'Instrument transformers', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121007, 'Frequency converters', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121008, 'Signal converters', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121009, 'Electrical or power regulators', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121013, 'Electric rotary converters', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121015, 'Reactors', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121020, 'Signal conditioners', 39121000, 'Power conditioning equipment', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121108, 'Distribution or control board fixtures', 39121100, 'Distribution and control centers and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121409, 'Wire connectors', 39121400, 'Electrical lugs plugs and connectors', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121436, 'Electrodes', 39121400, 'Electrical lugs plugs and connectors', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121441, 'Electrical jumper cable', 39121400, 'Electrical lugs plugs and connectors', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121521, 'Motor starter controls', 39121500, 'Electrical controls and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121528, 'Photoelectric sensors', 39121500, 'Electrical controls and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121601, 'Circuit breakers', 39121600, 'Circuit protection devices and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121604, 'Time delay fuses', 39121600, 'Circuit protection devices and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121613, 'Grounding devices or assemblies', 39121600, 'Circuit protection devices and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121621, 'Lightning protection apparatus and accessories', 39121600, 'Circuit protection devices and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121643, 'Surge protector panel', 39121600, 'Circuit protection devices and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121705, 'Cable clamp and staple', 39121700, 'Electrical hardware and supplies', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121718, 'Cable splicing kits', 39121700, 'Electrical hardware and supplies', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121721, 'Electrical insulators', 39121700, 'Electrical hardware and supplies', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39121722, 'Wire and cable pulling device', 39121700, 'Electrical hardware and supplies', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39122213, 'Limit switch', 39122200, 'Electrical switches and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39122222, 'Foot switch', 39122200, 'Electrical switches and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39122329, 'Time relay', 39122300, 'Electrical relays and accessories', 39120000, 'Electrical equipment and components and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (39131505, 'Wire labeling tool and printer', 39131500, 'Wire Markers and Wire Marking Devices', 39130000, 'Electrical wire management devices and accessories and supplies', 39000000, 'Electrical Systems and Lighting and Components and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101502, 'Air exhausters', 40101500, 'Ventilation', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101504, 'Ventilation dampers', 40101500, 'Ventilation', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101601, 'Blowers', 40101600, 'Air circulation and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101604, 'Fans', 40101600, 'Air circulation and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101701, 'Air conditioners', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101702, 'Cooling exchangers', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101703, 'Evaporative coolers', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101704, 'Condensing units', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101705, 'Capillary tube assemblies', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101720, 'Unit cooler', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101721, 'Water cooled condensor', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101722, 'Steam condenser', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101723, 'Thermoelectric cooler', 40101700, 'Cooling equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101801, 'Radiators', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101802, 'Heat exchangers', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101805, 'Furnaces', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101806, 'Heat pumps', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101809, 'Circulation heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101815, 'Immersion heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101816, 'Kettle exchangers', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101818, 'Process air heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101819, 'Space heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101826, 'Commercial water heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101830, 'Heater elements', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101831, 'Induction heaters', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101833, 'Boiler or heater igniter', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101834, 'Burners', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101843, 'Electric furnace', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101844, 'High frequency induction vacuum melting furnace', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101846, 'Salt bath furnace', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101847, 'Carburization and nitrification electric furnace', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101848, 'Forced air heating system', 40101800, 'Heating equipment and parts and accessories', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101902, 'Dehumidifiers', 40101900, 'Humidity control', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40101903, 'Humidifiers', 40101900, 'Humidity control', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40102001, 'Fire tube boilers', 40102000, 'Boilers', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40102002, 'Water tube boiler', 40102000, 'Boilers', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40102003, 'Electric boilers', 40102000, 'Boilers', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40102004, 'Natural gas powered boilers', 40102000, 'Boilers', 40100000, 'Heating and ventilation and air circulation', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141604, 'Safety valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141606, 'Relief valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141607, 'Ball valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141609, 'Control valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141611, 'Globe valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141612, 'Expansion valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141613, 'Gate valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141628, 'Pilot valves', 40141600, 'Valves', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141735, 'Funnels', 40141700, 'Hardware and fittings', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141736, 'Grease fitting', 40141700, 'Hardware and fittings', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40141742, 'Atomizers', 40141700, 'Hardware and fittings', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142002, 'Air hoses', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142003, 'Drill hoses', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142005, 'Material handling hoses', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142007, 'Special hoses', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142008, 'Water hoses', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142011, 'Chemical hose', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142016, 'Vacuum hose', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142018, 'Spray hose', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142022, 'Hose reel', 40142000, 'Hoses', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142202, 'Fluid regulators', 40142200, 'Fluid and gas regulators', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142204, 'Welding regulator oxygen', 40142200, 'Fluid and gas regulators', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142207, 'Water level regulator', 40142200, 'Fluid and gas regulators', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142208, 'Gas mixer', 40142200, 'Fluid and gas regulators', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40142508, 'Basket strainer', 40142500, 'Traps and strainers', 40140000, 'Fluid and gas distribution', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151501, 'Air pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151502, 'Vacuum pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151503, 'Centrifugal pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151504, 'Circulating pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151506, 'Hand pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151508, 'Mud pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151509, 'Reciprocating pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151510, 'Water pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151511, 'Well pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151512, 'Sump pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151513, 'Submersible pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151517, 'Sewage pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151520, 'Sampling pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151521, 'Rotary pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151523, 'Positive displacement pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151524, 'Oil pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151526, 'Turbine pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151530, 'Dredge pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151531, 'Dewatering pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151532, 'Fuel pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151533, 'Hydraulic pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151534, 'Cryogenic pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151548, 'Diaphragm pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151551, 'Gear pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151552, 'Metering or injection or proportioning pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151553, 'Progressive cavity pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151557, 'Rotating piston pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151558, 'Screw Pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151563, 'Fire pump sets', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151564, 'Chemical pumps', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151572, 'Air lift pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151576, 'Mortar pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151577, 'Grouting pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151578, 'Diving air pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151579, 'Gravity pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151580, 'Lubricator pump', 40151500, 'Pumps', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151601, 'Air compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151604, 'Gas compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151605, 'Motor compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151606, 'Reciprocating compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151607, 'Refrigerant compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151608, 'Rotary compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151609, 'Screw compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40151612, 'Centrifugal compressors', 40151600, 'Compressors', 40150000, 'Industrial pumps and compressors', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161502, 'Water filters', 40161500, 'Filters', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161503, 'Dust collectors', 40161500, 'Filters', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161504, 'Oil filters', 40161500, 'Filters', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161505, 'Air filters', 40161500, 'Filters', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161506, 'Filtering machinery', 40161500, 'Filters', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161601, 'Air scrubbers', 40161600, 'Purification', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161602, 'Air cleaners', 40161600, 'Purification', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161603, 'Pipe and tube cleaning machine', 40161600, 'Purification', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161701, 'Centrifuges', 40161700, 'Separators', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161702, 'Wet scrubbers', 40161700, 'Separators', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161801, 'Metal fabric media', 40161800, 'Filter media', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161803, 'Filter papers', 40161800, 'Filter media', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40161808, 'Biological filter media', 40161800, 'Filter media', 40160000, 'Industrial filtering and purification', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (40174401, 'Carbon steel pipe spectacle blind flange', 40174400, 'Pipe spectacle blind flanges', 40170000, 'Pipe piping and pipe fittings', 40000000, 'Distribution and Conditioning Systems and Equipment and Components');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101502, 'Stomachers', 41101500, 'Laboratory blending and dispersing and homogenizing equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101503, 'Laboratory sprayers', 41101500, 'Laboratory blending and dispersing and homogenizing equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101504, 'Homogenizers', 41101500, 'Laboratory blending and dispersing and homogenizing equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101505, 'French pressure cells', 41101500, 'Laboratory blending and dispersing and homogenizing equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101518, 'Laboratory blenders or emulsifiers', 41101500, 'Laboratory blending and dispersing and homogenizing equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101701, 'Laboratory mills', 41101700, 'Laboratory boring and grinding and cutting and crushing and pressing equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101702, 'Pestle or mortars', 41101700, 'Laboratory boring and grinding and cutting and crushing and pressing equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101705, 'Laboratory crushers or pulverizers', 41101700, 'Laboratory boring and grinding and cutting and crushing and pressing equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101707, 'Laboratory presses', 41101700, 'Laboratory boring and grinding and cutting and crushing and pressing equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101801, 'Electron guns', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101802, 'X ray generators', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101803, 'Coulometers', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101806, 'Magnetometers', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101809, 'Optical diffraction apparatus', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101810, 'Diffractometers', 41101800, 'Laboratory electron and solid state physics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101902, 'Ion exchange apparatus', 41101900, 'Laboratory ionic equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41101903, 'Ion implantation equipment', 41101900, 'Laboratory ionic equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102401, 'Gas burners', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102402, 'Spirit burners', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102404, 'Laboratory heaters', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102405, 'Heating mantles or tapes', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102406, 'Laboratory hotplates', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102407, 'Warming cabinets', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102410, 'Infrared dryers', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102412, 'Hot air blowers', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102421, 'Temperature cycling chambers or thermal cyclers', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102422, 'Dry baths or heating blocks', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102423, 'Stirring hotplates', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102425, 'Slide dryers', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102426, 'Heating or drying equipment or accessories', 41102400, 'Laboratory heating and drying equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102501, 'Laboratory insect containers', 41102500, 'Laboratory entomological equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102503, 'Fabric or netting for entomology', 41102500, 'Laboratory entomological equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102507, 'Entomological catching equipment', 41102500, 'Laboratory entomological equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102604, 'Animal catching devices', 41102600, 'Animal laboratory equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102606, 'Laboratory animal restraints or harnesses', 41102600, 'Animal laboratory equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102702, 'Scintillation crystal assemblies', 41102700, 'Crystallography equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102703, 'Light scattering equipment', 41102700, 'Crystallography equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102704, 'X ray diffraction equipment', 41102700, 'Crystallography equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102705, 'Crystallizers', 41102700, 'Crystallography equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102706, 'Crystal growing equipment', 41102700, 'Crystallography equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102901, 'Tissue embedding stations', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102905, 'Histological staining apparatus', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102909, 'Tissue processors', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102910, 'Tissue culture apparatus', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102911, 'Histological knives or knife holders or blades', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102913, 'Histological hones or straps or compounds', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102914, 'Ultrasonic disintegrators', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102915, 'Histology sampling and dissecting stations', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102916, 'Microtomes', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102919, 'Solvent recyclers', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102920, 'Histology tissue cassettes', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102921, 'Histology paraffin', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41102922, 'Automated cover slipping equipment', 41102900, 'Histology equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103003, 'Cryostats', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103005, 'Ultra cold or ultralow upright cabinets or freezers', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103006, 'Cryogenic or liquid nitrogen freezers', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103007, 'Chilling units or cold water circulators', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103008, 'Refrigerated cooling modules', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103010, 'Blood bank refrigerators', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103011, 'General purpose refrigerators or refrigerator freezers', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103023, 'Laboratory chillers', 41103000, 'Laboratory cooling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103202, 'Laboratory washing machines', 41103200, 'Laboratory washing and cleaning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103203, 'Pipette washers', 41103200, 'Laboratory washing and cleaning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103207, 'Microplate washers', 41103200, 'Laboratory washing and cleaning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103208, 'Blood bank cell washers', 41103200, 'Laboratory washing and cleaning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103210, 'Laboratory ultraviolet UV sterilizers', 41103200, 'Laboratory washing and cleaning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103301, 'Liquid scintillation counters', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103302, 'Battery acid hydrometers', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103303, 'Densitometers', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103305, 'High vacuum equipment', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103306, 'Pneumatic vacuum equipment', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103307, 'Vacuum or mercury vapour equipment', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103308, 'High vacuum combustion apparatus', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103309, 'Flow injection analysis equipment', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103310, 'Gas or vapour concentration measuring instruments', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103311, 'Manometers', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103312, 'Viscosimeters', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103313, 'Depth indicators', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103314, 'Microscopic structure estimation apparatus', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103315, 'Solution strength estimation apparatus', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103316, 'Pycnometers', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103317, 'Surface tension measuring instruments', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103320, 'Density measurement instrument', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103327, 'Current meter', 41103300, 'Fluid mechanics equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103403, 'Microbiological aircontrol equipment', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103406, 'Isolation glove boxes', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103407, 'Anaerobic chamber', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103410, 'Refrigerated and heated reach in environmental or growth chambers', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103412, 'Heated walk in environmental or growth chambers', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103413, 'Refrigerated and heated walk in environmental or growth chambers', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103416, 'Temperature cycle chamber', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103417, 'Indoor air quality monitor', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103418, 'Temperature and humidity walk in environmental chamber', 41103400, 'Laboratory environmental conditioning equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103502, 'Fume hoods or cupboards', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103504, 'Laminar flow cabinets or stations', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103506, 'PCR enclosures', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103507, 'HEPA filtered enclosures', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103509, 'Laboratory scrubbers', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103511, 'Laboratory enclosure accessories', 41103500, 'Laboratory enclosures and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103701, 'Circulating baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103702, 'Thermostatic baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103706, 'Water baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103709, 'Refrigerated baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103710, 'Orbital shaking water baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103711, 'Reciprocating shaking water baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103712, 'Immersion circulators', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103714, 'Tissue flotation baths', 41103700, 'Laboratory baths', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103801, 'Laboratory mixers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103805, 'Laboratory vibrators', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103806, 'Magnetic stirrers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103808, 'Platelet mixers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103809, 'Hematology or chemistry mixers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103811, 'Orbital shakers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103813, 'Rotating shakers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103814, 'Vortex mixers', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103815, 'Tube rotators', 41103800, 'Laboratory mixing and stirring and shaking equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103901, 'Microcentrifuges', 41103900, 'Laboratory centrifuges and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103903, 'Benchtop centrifuges', 41103900, 'Laboratory centrifuges and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103904, 'Refrigerated benchtop centrifuges', 41103900, 'Laboratory centrifuges and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103905, 'Floor centrifuges', 41103900, 'Laboratory centrifuges and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41103907, 'Ultracentrifuges', 41103900, 'Laboratory centrifuges and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104001, 'Sample changers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104002, 'Sample oxidizer', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104004, 'Sample preparation bombs', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104005, 'Laboratory bailers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104006, 'Coliwasas', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104007, 'Water samplers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104008, 'Air samplers or collectors', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104009, 'Air sampling pumps', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104010, 'Reagent kits for use with air samplers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104011, 'Filters or other spare parts for samplers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104015, 'Plant samples analysis equipment', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104016, 'Air pollutant samplers', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104017, 'Sample holders', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104018, 'Solid phase extraction preparations', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104019, 'Sampling manifolds', 41104000, 'Sampling equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104102, 'Lancets', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104104, 'Tourniquets', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104105, 'Specimen collection or transport bags', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104106, 'Phlebotomy trays or accessories', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104107, 'Vacuum blood collection tubes or containers', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104108, 'Non vacuum blood collection tubes or containers', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104116, 'Swab collection or transport containers', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104117, 'Specimen holders', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104118, 'Specimen collection container', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104122, 'Stool collection containers without media', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104123, 'Sputum collection apparatus or containers', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104126, 'Histology or pathology specimen container', 41104100, 'Specimen collection and transport containers and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104202, 'Deionization or demineralization equipment', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104204, 'Reverse osmosis equipment', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104205, 'Ultra violet water purification units', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104206, 'Ultra pure water systems', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104207, 'Water analysis systems', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104208, 'Dehydrators', 41104200, 'Laboratory water purification equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104301, 'Standard fermentation units', 41104300, 'Fermentation equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104303, 'Anaerobic jars or accessories', 41104300, 'Fermentation equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104304, 'Digestion systems', 41104300, 'Fermentation equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104307, 'Microbiology fermentation equipment', 41104300, 'Fermentation equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104402, 'Forced air or mechanical convection general purpose incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104403, 'Tissue culture incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104405, 'Shaking incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104406, 'Plate incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104411, 'Dry wall single chamber carbon dioxide incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104415, 'Water jacketed single chamber three gas incubators', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104424, 'Incubator accessories', 41104400, 'Laboratory incubating equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104501, 'Laboratory mechanical convection ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104503, 'Ageing ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104504, 'Cleanroom ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104506, 'Laboratory safety ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104507, 'Laboratory microwave ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104508, 'Induction dryers', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104509, 'Vacuum ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104510, 'Drying cabinets or ovens', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104511, 'Hybridization ovens or incubators', 41104500, 'Laboratory ovens and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104601, 'Laboratory box furnaces', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104603, 'Tube furnaces', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104604, 'Programmable tube furnaces', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104605, 'Crucible furnaces', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104607, 'Furnace control console', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104609, 'Laboratory safety furnaces', 41104600, 'Laboratory furnaces and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104701, 'Freeze dryers or lyopholizers', 41104700, 'Laboratory freeze dryers and lyopholizers and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104801, 'Flask or retort units', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104802, 'Bi distillation units', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104803, 'Laboratory evaporators', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104804, 'Vacuum or rotary evaporators', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104806, 'Extracting equipment for laboratories', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104807, 'Fat extractors', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104809, 'Sedimentological analyzing unit', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104810, 'Fractionation apparatus', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104811, 'Density gradient fractionators', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104812, 'Distillation pipings or columns or fittings', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104814, 'Laboratory heat exchange condensers', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104815, 'Kjeldahl nitrogen determination apparatus', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104816, 'Vacuum or centrifugal concentrators', 41104800, 'Laboratory decanting and distilling and evaporating and extracting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104902, 'Gel filtration equipment', 41104900, 'Laboratory filtering equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104921, 'Laboratory membrane filters', 41104900, 'Laboratory filtering equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104925, 'Laboratory filtration hardware or accessories', 41104900, 'Laboratory filtering equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41104930, 'Molecular sieve', 41104900, 'Laboratory filtering equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105001, 'Laboratory separators', 41105000, 'Laboratory sieves and sifting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105002, 'Laboratory sifting equipment', 41105000, 'Laboratory sieves and sifting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105003, 'Test sieves', 41105000, 'Laboratory sieves and sifting equipment and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105101, 'Laboratory vacuum pumps', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105102, 'Peristaltic pumps', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105103, 'Laboratory centrifugal pumps', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105104, 'Syringe pumps', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105105, 'Metering pumps', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105108, 'Laboratory general purpose tubing', 41105100, 'Laboratory pumps and tubing', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105201, 'Histology or cytology slide stainers', 41105200, 'Laboratory slide stainer equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105203, 'Microbiology slide stainers', 41105200, 'Laboratory slide stainer equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105301, 'Gel boxes', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105302, 'Gel dryers', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105303, 'Electrophoresis system power supplies', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105304, 'Transilluminators', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105305, 'Electrophoresis system accessories', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105307, 'Instrumentation for capillary electrophoresis', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105311, 'Blotting or transfer apparatus', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105314, 'Gel documentation systems', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105315, 'Gel documentation accessories', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105316, 'Ultraviolet crosslinkers', 41105300, 'Laboratory electrophoresis and blotting system and supplies', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105505, 'High throughput screening HTS systems in nucleic acid purification', 41105500, 'Nucleic acid extraction and purification and quantitation kits and components', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41105903, 'Complementary deoxyribonucleic acid cDNA synthesis kits', 41105900, 'Libraries and related materials', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106103, 'Deoxyribonucleic acid DNA typing kits', 41106100, 'Deoxyribonucleic acid DNA analysis kits', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106203, 'Bacteria transformation kits', 41106200, 'Microorganism propagation and transformation media and kits and equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106208, 'Electroporation cuvettes', 41106200, 'Microorganism propagation and transformation media and kits and equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106217, 'Specialty plates for bacteria', 41106200, 'Microorganism propagation and transformation media and kits and equipment', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106312, 'Rapid amplification or complementary deoxyribonucleic acid ends RACE technology products', 41106300, 'Polymerase chain reaction PCR and reverse transcriptase polymerase chain reaction RT PCR products', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106610, 'General cloning vectors', 41106600, 'Vectors', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41106702, 'Photosynthesis measurement apparatus', 41106700, 'Laboratory botanical equipment and accessories', 41100000, 'Laboratory and scientific equipment', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111501, 'Electronic toploading balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111502, 'Laboratory balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111503, 'Mechanical balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111504, 'Pull spring balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111505, 'Calibration weights or weight sets', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111506, 'Animal weighing scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111507, 'Bench scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111508, 'Bodyweight measuring scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111509, 'Floor or platform scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111510, 'Postal scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111511, 'Truck or rail scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111512, 'Triple beam balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111513, 'Moisture balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111516, 'Weight measuring instrument accessories', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111517, 'Analytical balances', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111518, 'Axle load scales', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111519, 'Crane scale', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111520, 'Conveyor weighting scale', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111522, 'Hopper scale', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111526, 'Automatic selective scale', 41111500, 'Weight measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111601, 'Micrometers', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111602, 'Pedometers', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111603, 'Rangefinders', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111604, 'Rulers', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111605, 'Strain gauges', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111607, 'Thread counters or gauges', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111613, 'Distance meters', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111614, 'Height gauges', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111615, 'Laser measuring systems', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111616, 'Measuring wheels for distance', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111617, 'Feeler gauges', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111618, 'Gage block set', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111619, 'Go or no go gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111621, 'Calipers', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111622, 'Micrometer calipers', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111623, 'Thickness measuring devices', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111626, 'Gauge block', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111627, 'Vee block', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111630, 'Dial indicator or dial gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111631, 'Radius gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111632, 'Cylinder gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111641, 'Thread pitch gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111642, 'Rail joint gap gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111643, 'Wire gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111644, 'Pin gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111645, 'Sine bar', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111646, 'Telescoping gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111647, 'Hole gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111648, 'Taper gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111649, 'Tire depth gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111650, 'Drill gauge', 41111600, 'Length and thickness and distance measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111702, 'Monocular microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111703, 'Stereo or dissecting light microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111704, 'Illuminators for microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111705, 'Microscope objectives', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111706, 'Photo attachments for microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111707, 'Profile projectors', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111708, 'Video attachments for microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111709, 'Binocular light compound microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111711, 'Electron microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111712, 'Inverted microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111713, 'Magnifiers', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111714, 'Loupes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111715, 'Telescopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111716, 'Borescope inspection equipment', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111717, 'Binoculars', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111718, 'Metallurgical microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111719, 'Darkfield microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111720, 'Scanning electron microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111721, 'Transmission electron microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111722, 'Fluorescent microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111723, 'Scanning light or spinning disk or laser scanning microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111724, 'Scanning probe microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111725, 'Polarizing microscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111730, 'Microscope condensers', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111734, 'Microscope stages', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111735, 'Automated microscope stages', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111737, 'Videoscopes', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111740, 'Automated optical inspection system', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111743, 'Autocollimator', 41111700, 'Viewing and observing instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111801, 'Eddy current examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111802, 'Liquid penetrant examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111803, 'Magnetic particle examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111804, 'Ultrasonic examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111807, 'IR 192 radiography examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111808, 'X ray radiography examination equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111809, 'Leak testing equipment', 41111800, 'Non destructive examination equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111901, 'Counters', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111902, 'Electronic counters', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111903, 'Metal detectors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111905, 'Electronic measuring probes', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111906, 'Chart recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111907, 'Digital readout recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111908, 'Graphic recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111909, 'Magnetic tape recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111912, 'Physiological recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111913, 'Point plotting recorders', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111915, 'Bi metallic sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111916, 'Non contact sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111917, 'Digital testers', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111918, 'Gyroscopic instruments', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111919, 'Detection apparatus for non metallic objects', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111920, 'Coordinate measuring machines CMM', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111921, 'Speed sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111924, 'Oxygen sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111926, 'Proximity sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111927, 'Pressure sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111928, 'Current sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111929, 'Radiation detectors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111930, 'Electrical power sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111931, 'Flow sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111932, 'Liquid leak detectors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111934, 'Force or torque sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111937, 'Rotary position sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111938, 'Level sensors or transmitters', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111939, 'Acoustic sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111940, 'Color sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111942, 'Opacity or dust or visibility sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111943, 'Electrical resistance or conductance sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111945, 'Linear position sensors', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111948, 'Manual or electronic hematology differential cell counters', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111949, 'Hour meter', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111954, 'Liquid sensor', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111958, 'Manifold ambient pressure sensor', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111959, 'Fuel pressure sensor', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41111966, 'Humidity sensor', 41111900, 'Indicating and recording instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112101, 'Piezo electric crystals', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112103, 'Fiber sensors', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112105, 'Temperature transmitters', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112107, 'Electro pneumatic transducers', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112108, 'Loadcells', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112110, 'Pressure transducer', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112111, 'Displacement transducer', 41112100, 'Transducers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112201, 'Calorimeters', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112202, 'Heat tracing equipment', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112203, 'Melting point recorders', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112204, 'Pyrometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112205, 'Temperature regulators', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112206, 'Thermocouples', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112207, 'Thermographs', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112209, 'Thermostats', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112210, 'Remote reading thermometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112211, 'Resistance thermometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112212, 'Surface thermometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112213, 'Handheld thermometer', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112214, 'Cryogenic temperature controllers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112219, 'Thermocouple probes', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112220, 'Laboratory freezer or refrigerator thermometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112221, 'Laboratory incubator thermometers', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112222, 'Temperature gauge', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112224, 'Infrared thermometer', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112233, 'Melting point measuring instrument', 41112200, 'Temperature and heat measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112301, 'Hygrometers', 41112300, 'Humidity and moisture measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112302, 'Psychrometers', 41112300, 'Humidity and moisture measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112303, 'Temperature humidity testers', 41112300, 'Humidity and moisture measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112304, 'Moisture meters', 41112300, 'Humidity and moisture measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112401, 'Depth gauges', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112402, 'Manostats', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112403, 'Pressure indicators', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112404, 'Pressure regulator', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112405, 'Pressure or vacuum recorders', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112406, 'Vacuum gauges', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112407, 'Liquid level controls or instruments', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112410, 'Pressure transmitters', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112411, 'Pressure controllers', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112412, 'Pressure gauge', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112414, 'Pressure calibrator', 41112400, 'Pressure measuring and control instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112501, 'Flowmeters', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112502, 'Rheometers', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112503, 'Rotameters', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112504, 'Water meters', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112506, 'Venturis', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112508, 'Gas gauges', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112509, 'Air velocity and temperature monitors', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112511, 'Sight flow windows', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112513, 'Orifice plate', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112514, 'Oil gauges', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112516, 'Flow transmitters', 41112500, 'Liquid and gas flow measuring and observing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112701, 'Grain analyzers', 41112700, 'Seed and feed equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112801, 'Speedometers', 41112800, 'Transportation related equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112802, 'Tachometers', 41112800, 'Transportation related equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112901, 'Direction finding compasses', 41112900, 'Navigational equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112902, 'Radio navigation instruments', 41112900, 'Navigational equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112903, 'Sextants', 41112900, 'Navigational equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112904, 'Complex controlling devices', 41112900, 'Navigational equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41112906, 'Radio beacon', 41112900, 'Navigational equipment and instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113002, 'Chemiluminescence or bioluminescence analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113003, 'Electrogravimetry analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113004, 'Flame ionization analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113005, 'Ion analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113009, 'Thermal differential analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113010, 'Thermo gravimetry analyzers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113024, 'Hydrometers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113025, 'Monochromators', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113026, 'Nephelometers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113027, 'Osmometers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113033, 'Volumeters', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113034, 'pH test strips or papers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113035, 'Chemical test strips or papers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113036, 'Microplates', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113037, 'Microplate readers', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113051, 'Oxidation reduction tester', 41113000, 'Chemical evaluation instruments and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113101, 'Automotive exhaust emission analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113102, 'Catalytic combustion analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113103, 'Chemical absorption gas analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113104, 'Explosimeters', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113105, 'Hydrocarbons analyzers or detectors', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113106, 'Infra red or ultra violet absorption analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113107, 'Nitrogen gas analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113110, 'Oxygen gas analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113111, 'Ozone analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113112, 'Paramagnetic susceptibility analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113113, 'Sulfur dioxide analyzers or detectors', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113114, 'Thermal conductivity analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113115, 'Radon detectors', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113116, 'Gas detector tubes', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113117, 'Single gas monitors', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113118, 'Multi gas monitors', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113119, 'Dissolved carbon dioxide analyzers', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113120, 'Carbon monoxide analyzer', 41113100, 'Gas analyzers and monitors', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113302, 'Albuminometers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113308, 'Electrolyte analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113309, 'Enzyme analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113312, 'Lactate analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113314, 'Oil content monitors analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113315, 'Organic carbon analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113319, 'Water analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113320, 'Lubricating oil testing kit', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113321, 'Paint tester', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113322, 'Nitrogen or nitrate or nitrite analyzer', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113323, 'Sugar analyzers', 41113300, 'Liquid and solid and elemental analyzers', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113403, 'Beta counters', 41113400, 'Nuclear evaluation instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113404, 'Beta gamma counters', 41113400, 'Nuclear evaluation instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113405, 'Gamma counters', 41113400, 'Nuclear evaluation instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113601, 'Ammeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113602, 'Phasemeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113604, 'Capacitance meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113607, 'Heat stress monitors', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113614, 'Electromagnetic field meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113615, 'Electrometers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113616, 'Electronic loads', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113617, 'Field strength measuring equipment', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113619, 'Galvanometers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113620, 'High voltage cable detection', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113621, 'Impedance meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113622, 'Calibrated inductance coils or boxes', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113623, 'Insulation resistance meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113624, 'Insulation testers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113625, 'Ionization chambers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113626, 'Ionmeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113628, 'Megohmmeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113629, 'Microwave leakage meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113630, 'Multimeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113631, 'Ohmmeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113632, 'Oscillographs', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113633, 'Potentiometers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113634, 'Q Meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113635, 'Calibrated resistance measuring equipment', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113636, 'Level generators', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113637, 'Voltage or current meters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113638, 'Oscilloscopes', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113639, 'Accelerometers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113640, 'Wattmeters', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113641, 'GFI circuit testers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113642, 'Circuit tester', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113644, 'Circuit tracers', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113646, 'Temperature calibrator or simulator', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113647, 'Frequency calibrator or simulator', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113655, 'Generator test set', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113659, 'Var meter', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113668, 'Capacitor tester', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113672, 'Relay tester', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113684, 'Voltage and current meter calibrator', 41113600, 'Electrical measuring and testing equipment and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113702, 'Comparators', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113704, 'Integrated circuit testers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113706, 'Semiconductor testers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113707, 'Transistor circuit testers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113708, 'Power meters', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113709, 'Modulation meters', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113710, 'Level meter', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113711, 'Network analyzers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113715, 'Integrated services digital network ISDN testers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113716, 'Fiber optic fault locators', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113717, 'Fiber optic test sources', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113718, 'Protocol analyzers', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113723, 'Radio equipment tester', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113724, 'Telephone test set', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113727, 'Distortion meter', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113733, 'Antenna tester', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113740, 'Voice data video cable tester', 41113700, 'Electronic and communication measuring and testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113801, 'Geological compasses', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113802, 'Geological prospecting apparatus', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113803, 'Electromagnetic geophysical instruments', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113806, 'Magnetometer geophysical instruments', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113807, 'Resistivity geophysical instruments', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113808, 'Gravimeters', 41113800, 'Geophysical and geotechnical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113902, 'Dissolution or disintegration testers', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113903, 'Particle size measuring apparatus', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113904, 'Penetrometers', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113905, 'Permeability testing apparatus', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113906, 'Permeability or porosity estimation apparatus', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113907, 'Porosimeters', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113908, 'Sand testing apparatus', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113909, 'Soil core sampling apparatus', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41113910, 'Soil testing kits', 41113900, 'Soil measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114001, 'Clinometers', 41114000, 'Rock and strata measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114105, 'Portable seismic apparatus', 41114100, 'Seismological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114106, 'Seismic recorders or seismographs', 41114100, 'Seismological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114201, 'Measuring tapes', 41114200, 'Land surveying instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114202, 'Measuring rods', 41114200, 'Land surveying instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114203, 'Measuring tables', 41114200, 'Land surveying instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114204, 'Theodolites', 41114200, 'Land surveying instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114301, 'Open stream current meters', 41114300, 'Hydrological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114302, 'Logging instruments for water wells', 41114300, 'Hydrological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114303, 'Open stream water level recorders', 41114300, 'Hydrological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114401, 'Anemometers', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114402, 'Barometers', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114403, 'Precipitation or evaporation recorders', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114404, 'Radiosonde apparatus', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114405, 'Rainfall recorders', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114407, 'Solar radiation surface observing apparatus', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114408, 'Temperature or humidity surface observing apparatus', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114409, 'Wind surface observing apparatus', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114410, 'Weather stations', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114411, 'Meteorology instrument accessories', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114427, 'Wind vane', 41114400, 'Meteorological instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114501, 'Dynamometers', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114503, 'Extensometers', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114504, 'Pitch measuring instruments', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114506, 'Spherometers', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114508, 'Surface testers', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114509, 'Tensiometers', 41114500, 'Mechanical instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114601, 'Abrasion testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114602, 'Compression testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114603, 'Concrete or cement testing instruments', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114604, 'Corrosion testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114606, 'Creep testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114607, 'Ductility testing machines', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114608, 'Fatigue testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114610, 'Foundry testing apparatus', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114611, 'Hardness testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114612, 'Impact testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114613, 'Load frame', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114614, 'Metal testing instruments', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114615, 'Photoelastic testing instruments', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114618, 'Roughness measuring instruments', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114619, 'Shear strength testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114620, 'Shock testing apparatus', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114621, 'Tension testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114622, 'Torsion testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114623, 'Flexure or transverse testing machines', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114624, 'Vibration testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114625, 'Wear testers', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114632, 'Tensile strength tester', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114635, 'Jewel appraising tester', 41114600, 'Metals and metallurgy and structural materials testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41114705, 'Textile testing instruments', 41114700, 'Paper and wood and textile testing instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115201, 'Radarbased surveillance systems', 41115200, 'Radar and sonar systems and components', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115301, 'Light absorption meters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115302, 'Anechoic chambers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115303, 'Frequency analyzers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115304, 'Frequency counters or timer or dividers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115305, 'Electrical frequency meters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115306, 'Interferometers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115307, 'Lasers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115308, 'Lightmeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115309, 'Luxmeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115310, 'Optical calibration sets', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115311, 'Photometers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115312, 'Bench refractometers or polarimeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115313, 'Handheld refractometers or polarimeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115314, 'Polarimeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115315, 'Polariscopes', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115316, 'Reflectometers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115317, 'Stroboscopes', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115318, 'Colorimeters', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115320, 'Signal generators', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115321, 'Infrared imagers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115322, 'Laser beam analyzers', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115325, 'Thermal imager', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115329, 'Radiowave propagation measuring equipment', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115335, 'Vectorscope', 41115300, 'Light and wave generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115401, 'Spectrofluorimeters or fluorimeters', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115402, 'Spectrographs', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115403, 'Spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115404, 'Mass spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115405, 'Proton spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115406, 'Spectrophotometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115407, 'Atomic absorption AA spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115408, 'Infrared spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115409, 'Nuclear magnetic resonance NMR spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115411, 'Inductively coupled plasma ICP spectrometers', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115418, 'Spectrophotometer accessories', 41115400, 'Spectroscopic equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115501, 'Sonars', 41115500, 'Sound generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115502, 'Sonometers', 41115500, 'Sound generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115503, 'Sound measuring apparatus or decibel meter', 41115500, 'Sound generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115505, 'Acoustic testing rooms', 41115500, 'Sound generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115508, 'Sound detector', 41115500, 'Sound generating and measuring equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115602, 'Titration equipment', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115603, 'pH meters', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115604, 'pH electrodes', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115606, 'Ion selective electrode ISE meters', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115608, 'Ion selective electrode', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115609, 'Conductivity meters', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115610, 'Conductivity cells', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115611, 'Dissolved oxygen meters', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115613, 'Salinity meter', 41115600, 'Electrochemical measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115701, 'Chromatographic detectors', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115702, 'Chromatographic scanners', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115703, 'Gas chromatographs', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115704, 'Ion chromatographs', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115705, 'Liquid chromatographs', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115706, 'Thinlayer chromatographs', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115707, 'High pressure liquid chromatograph chromatography', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115712, 'Solid phase extraction SPE columns', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115713, 'Thin layer chromatography tanks', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115714, 'Autosamplers', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115715, 'Injectors', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115716, 'Liquid chromatography fittings', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115720, 'Chromatography tubing', 41115700, 'Chromatographic measuring instruments and accessories', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115801, 'Amino acid analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115803, 'Blood bank analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115805, 'Blood gas analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115807, 'Chemistry analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115809, 'Coagulation analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115811, 'Deoxyribonucleic sequence analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115813, 'Toxicology analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115815, 'Hematology analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115819, 'Immunology analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115821, 'Microbiology analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115823, 'Protein analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115827, 'Urinalysis analyzers', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115828, 'Urinalysis analyzer accessories or supplies', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41115835, 'Androgeny and fertility automated counter', 41115800, 'Clinical and diagnostic analyzers and accessories and supplies', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116104, 'Chemistry test kits or supplies', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116120, 'Hematology test kits or supplies', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116126, 'Immunology or serology test kits or supplies', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116128, 'Immunology or serology quality controls or calibrators or standards', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116138, 'Urinalysis test strips', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116146, 'Toxicology test kits or supplies', 41116100, 'Manual test kits and quality controls and calibrators and standards', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116201, 'Glucose monitors or meters', 41116200, 'Patient point of care testing supplies and equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116202, 'Cholesterol monitors or meters', 41116200, 'Patient point of care testing supplies and equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116209, 'Blood coagulation multiple parameter monitor or meter', 41116200, 'Patient point of care testing supplies and equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116210, 'Metabolic disorder breathalyzer monitor or meter', 41116200, 'Patient point of care testing supplies and equipment', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41116401, 'Impact hammers', 41116400, 'Acceleration and vibration measuring instruments', 41110000, 'Measuring and observing and testing instruments', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121501, 'Robotic or automated liquid handling systems', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121502, 'Laboratory diluters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121503, 'Manual multichannel air displacement pipetters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121504, 'Manual single channel air displacement pipetters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121505, 'Manual single channel positive displacement pipetters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121506, 'Manual single channel repeating pipetters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121508, 'Electronic multichannel pipetters', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121509, 'Pasteur or transfer pipettes', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121510, 'Volumetric pipettes', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121513, 'Dropping pipettes', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121514, 'Pipette pumps', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121515, 'Pipette bulbs', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121517, 'Pipetter inserts or accessories', 41121500, 'Pipettes and liquid handling equipment and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121701, 'Multipurpose or general test tubes', 41121700, 'Test Tubes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121703, 'Centrifuge tubes', 41121700, 'Test Tubes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121706, 'Culture tubes', 41121700, 'Test Tubes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121709, 'Capillary or hematocrit tubes', 41121700, 'Test Tubes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121802, 'Laboratory stirring rods', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121803, 'Laboratory beakers', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121804, 'Laboratory flasks', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121805, 'Laboratory graduated cylinders', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121806, 'Laboratory vials', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121808, 'Laboratory burets', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121809, 'Laboratory funnels', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121810, 'Laboratory staining dishes or jars', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121812, 'Laboratory dishes', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121813, 'Cuvettes', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121815, 'Laboratory adapters or connectors or fittings', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41121816, 'Laboratory glass tube', 41121800, 'General laboratory glassware and plasticware and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122001, 'Chromatography syringes', 41122000, 'Laboratory or sampling syringes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122004, 'Sampling syringes', 41122000, 'Laboratory or sampling syringes', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122101, 'Petri plates or dishes', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122102, 'Multiwell plates', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122103, 'Cell scrapers', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122104, 'Tissue culture flasks', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122106, 'Inoculating devices', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122107, 'Tissue culture coated plates or dishes or inserts', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122108, 'Microbiology inoculation loops or needles', 41122100, 'Tissue culture and high throughput screening supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122201, 'Glass crucibles', 41122200, 'Crucibles', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122202, 'Ceramic crucibles', 41122200, 'Crucibles', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122203, 'Metal crucibles', 41122200, 'Crucibles', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122401, 'Magnetic spin bars or stir bars or stirring beads', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122403, 'Laboratory spatulas', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122404, 'Laboratory tongs', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122405, 'Laboratory forceps', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122406, 'Laboratory knives', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122407, 'Laboratory scalpels', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122408, 'Laboratory scissors', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122409, 'Laboratory tools', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122413, 'Laboratory clamps', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122414, 'Laboratory spoon', 41122400, 'Laboratory implements', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122503, 'Laboratory cork borers', 41122500, 'Laboratory corks and stoppers and accessories', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122601, 'Microscope slides', 41122600, 'Laboratory microscope slides and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122604, 'Hemocytometers', 41122600, 'Laboratory microscope slides and supplies', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122802, 'Microscope slide racks', 41122800, 'Laboratory stands and racks and trays', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122804, 'Test tube racks', 41122800, 'Laboratory stands and racks and trays', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122805, 'Drying racks', 41122800, 'Laboratory stands and racks and trays', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41122808, 'General purpose trays', 41122800, 'Laboratory stands and racks and trays', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41123004, 'Vacuum desiccators', 41123000, 'Laboratory desiccators and desiccants', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41123303, 'Microscope slide cabinets', 41123300, 'General laboratory storage containers and cabinets', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41123305, 'Histology or tissue cassette cabinets', 41123300, 'General laboratory storage containers and cabinets', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (41123403, 'Dosing droppers', 41123400, 'Dosing devices', 41120000, 'Laboratory supplies and fixtures', 41000000, 'Laboratory and Measuring and Observing and Testing Equipment');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121501, 'Veterinary blood pressure testers', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121505, 'Veterinary electrocardiograph ECG', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121507, 'Veterinary injection or suction units or accessories', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121509, 'Veterinary clinical thermometers', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121512, 'Veterinary speculums', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121513, 'Veterinary castration instruments', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121515, 'Veterinary nail trimmers or cutters', 42121500, 'Veterinary equipment', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121605, 'Cardiovascular system veterinary products', 42121600, 'Veterinary products', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121801, 'Artificial inseminating machine', 42121800, 'Veterinary artificial insemination equipment and supplies', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121802, 'Semen collection instrument', 42121800, 'Veterinary artificial insemination equipment and supplies', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42121804, 'Semen packaging instrument', 42121800, 'Veterinary artificial insemination equipment and supplies', 42120000, 'Veterinary equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131601, 'Medical staff aprons or bibs', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131605, 'Medical staff coveralls', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131606, 'Medical staff isolation or surgical masks', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131608, 'Medical staff scrubs', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131611, 'Surgeon caps or hoods', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131612, 'Medical staff isolation or cover gown', 42131600, 'Medical staff clothing and related articles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131701, 'Surgical drapes', 42131700, 'Surgical textiles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42131707, 'Surgical isolation suits or helmets or facemasks or accessories', 42131700, 'Surgical textiles', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42132203, 'Medical exam or non surgical procedure gloves', 42132200, 'Medical gloves and accessories', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42132205, 'Surgical gloves', 42132200, 'Medical gloves and accessories', 42130000, 'Medical apparel and textiles', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141602, 'Bedpans for general use', 42141600, 'Basins and bedpans and urinals and admission kits', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141607, 'Patient urinals for general use', 42141600, 'Basins and bedpans and urinals and admission kits', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141702, 'Blanket frames or lifters', 42141700, 'Decubitus prevention products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141703, 'Extremities cradles', 42141700, 'Decubitus prevention products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141801, 'Electrotherapy combination units', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141804, 'Galvanic or faradic stimulators', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141805, 'Neuromuscular stimulators or kits', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141806, 'Short wave diathermy units', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141807, 'Transcutaneous electric nerve stimulation units', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141809, 'Muscle stimulator lead sets', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141813, 'Electroconvulsive device', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141815, 'High frequency electromagnetic wave stimulator', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141817, 'Magnetic pulse stimulator', 42141800, 'Electrotherapy equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42141903, 'Enema kits or accessories', 42141900, 'Enema administration supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142001, 'Floor grade forceps or hemostats', 42142000, 'Floor grade instruments', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142004, 'Floor grade nail nippers', 42142000, 'Floor grade instruments', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142005, 'Floor grade needle holders', 42142000, 'Floor grade instruments', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142007, 'Floor grade scissors', 42142000, 'Floor grade instruments', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142103, 'Medical heat lamps or accessories', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142104, 'Medical hydrocollators or accessories', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142105, 'Therapeutic heating or cooling units or systems', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142106, 'Therapeutic heating or cooling blankets or drapes', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142107, 'Therapeutic cryo compression therapy system and accessories', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142108, 'Therapeutic heating or cooling pads or compresses or packs', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142111, 'Therapeutic ice packs or pillows', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142112, 'Therapeutic paraffin baths or accessories', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142121, 'Moist steam cabinet', 42142100, 'Heat and cold therapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142201, 'Extremity hydrotherapy baths or tanks', 42142200, 'Hydrotherapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142202, 'Full body immersion hydrotherapy baths or tanks', 42142200, 'Hydrotherapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142203, 'Hydrotherapy bath or tank accessories', 42142200, 'Hydrotherapy products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142302, 'Medical charting systems components or accessories', 42142300, 'Medical documentation products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142303, 'Patient identification and information products', 42142300, 'Medical documentation products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142402, 'Medical suction cannulas or tubes or accessories', 42142400, 'Medical suction and vacuum products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142404, 'Medical suction or vacuum appliances', 42142400, 'Medical suction and vacuum products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142406, 'Medical suction sets or kits', 42142400, 'Medical suction and vacuum products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142503, 'Arterial needles', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142504, 'Biopsy needles', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142505, 'Blood collection needle holders', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142507, 'Butterfly needles', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142509, 'Epidural anesthesia kit or tray', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142514, 'Spinal anesthesia kit or tray', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142515, 'Vacuum tube needles', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142518, 'Biopsy aspirator products or accessories', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142519, 'Needle guides', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142521, 'Blood collection needle', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142523, 'Hypodermic needle', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142526, 'Needle protectors', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142531, 'Needle or blade or sharps disposal container or cart', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142532, 'Pericardiocentesis needles or kits or accessories', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142537, 'Thoracentesis set or tray', 42142500, 'Injection and aspiration needles and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142601, 'Medical aspiration or irrigation syringes', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142602, 'Medical bulb syringes', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142608, 'Medical syringe without needle', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142609, 'Medical syringe with needle', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142610, 'Oral liquid medication syringes', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142611, 'Tuberculin syringes', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142614, 'Hypodermic injection apparatus or accessories', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142616, 'Blood collection syringes', 42142600, 'Syringes and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142702, 'Urethral urinary catheters', 42142700, 'Urological supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142706, 'Urological procedure trays or packs or kits', 42142700, 'Urological supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142713, 'Urological sheaths or sets', 42142700, 'Urological supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142715, 'Urinary catheterization kit', 42142700, 'Urological supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142719, 'Urethrotome', 42142700, 'Urological supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142801, 'Vascular sequential compression devices or tubing', 42142800, 'Vascular and compression therapy equipment and supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142802, 'Vascular or compression apparel or support', 42142800, 'Vascular and compression therapy equipment and supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42142913, 'Contact lenses', 42142900, 'Vision correction or cosmetic eyewear and related products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143101, 'Intrauterine catheters or catheterization kits', 42143100, 'Obstetrical and gynecological equipment and supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143102, 'Uterine devices or accessories', 42143100, 'Obstetrical and gynecological equipment and supplies', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143513, 'Otological instruments or accessories', 42143500, 'Ear nose and throat ENT treatment products and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143601, 'Restraint vests and jackets', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143602, 'Torso and belt restraints', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143603, 'Extremity restraints', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143605, 'Restraint straps or buckles or accessories or supplies', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143606, 'Full body restraints', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143607, 'Patient motion sensors or alarms or accessories', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143608, 'Patient stabilization or fall prevention devices or accessories', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143609, 'Patient restraint boards or accessories', 42143600, 'Restraints and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42143709, 'Visible light radiator', 42143700, 'Phototherapy systems and accessories', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42144101, 'Pleural cavity drainage unit or container or accessories', 42144100, 'Pleural cavity drain products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42144102, 'Chest tube', 42144100, 'Pleural cavity drain products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42144103, 'Chest tube kit', 42144100, 'Pleural cavity drain products', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42144201, 'Acupuncture needle', 42144200, 'Acupuncture equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42144202, 'Acupuncture magnet pellet or seed', 42144200, 'Acupuncture equipment', 42140000, 'Patient care and treatment products and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151501, 'Cosmetic dentistry curing lights or accessories', 42151500, 'Cosmetic dentistry equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151507, 'Dental shades', 42151500, 'Cosmetic dentistry equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151601, 'Attachments or replacement parts for dental instruments', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151602, 'Bands for dental matrix', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151603, 'Calcium hydroxide placement tools', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151604, 'Composite placement tools', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151605, 'Crown or bridge removers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151606, 'Dental amalgam carvers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151610, 'Dental nippers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151612, 'Dental retractors', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151613, 'Dental burnishers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151614, 'Dental burs', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151615, 'Dental cryosurgical units', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151616, 'Dental depth gauges', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151617, 'Dental drills or drill bits', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151618, 'Dental elevators', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151619, 'Dental excavators', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151620, 'Dental files or rasps', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151621, 'Dental filler contouring instruments', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151623, 'Dental forceps', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151624, 'Dental hand pieces or accessories', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151625, 'Dental hygiene instruments', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151626, 'Dental instrument sharpening accessories', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151627, 'Dental mirrors or mirror handles', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151630, 'Dental placement instruments', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151631, 'Dental probes', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151632, 'Dental reamers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151634, 'Dental root tip picks', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151635, 'Dental saliva ejectors or oral suction devices or supplies', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151636, 'Dental scalers or accessories', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151638, 'Dental scissors', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151639, 'Dental spatulas', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151640, 'Dental tweezers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151641, 'Dental wax carvers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151643, 'Dental margin trimmers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151644, 'Dental mouth props', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151647, 'Dental absorbent holders', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151648, 'Dental calipers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151651, 'Dental tooth separators', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151652, 'Dental pin drivers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151655, 'Dental pulp or vitality testers', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151656, 'Dental spreaders', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151663, 'Dental wedges or sets', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151664, 'Dental cutting or separating discs', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151665, 'Dental gages or accessories', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151667, 'Dental matrices or sets', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151669, 'Dental dehydrators', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151673, 'Dental mallets', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151676, 'Dental knives', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151677, 'Dental pressure indicating kits', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151681, 'Dental anesthesia sets or accessories', 42151600, 'Dental and subspecialty instruments and devices', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151701, 'Dental examination chairs or related parts or accessories', 42151700, 'Dental clinical furniture', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151705, 'Combination furniture sets for dental procedures', 42151700, 'Dental clinical furniture', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151801, 'Amalgam carriers', 42151800, 'Dental fillers and finishing and polishing supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151802, 'Dental material pluggers or tips or accessories', 42151800, 'Dental fillers and finishing and polishing supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151804, 'Dental cord packers', 42151800, 'Dental fillers and finishing and polishing supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151805, 'Dental finishing or polishing discs', 42151800, 'Dental fillers and finishing and polishing supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151810, 'Dental finishing or polishing kits', 42151800, 'Dental fillers and finishing and polishing supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151902, 'Dental prophylaxis kits', 42151900, 'Dental hygiene and preventive care equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42151910, 'Teeth cleaning devices or accessories', 42151900, 'Dental hygiene and preventive care equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152002, 'Dental bite blocks or wings or tabs', 42152000, 'Dental imaging equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152003, 'Dental film processors', 42152000, 'Dental imaging equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152008, 'Dental x ray units', 42152000, 'Dental imaging equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152010, 'Dental radiology film', 42152000, 'Dental imaging equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152012, 'Dental x ray apparatus parts or kits or accessories', 42152000, 'Dental imaging equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152102, 'Dental formers', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152105, 'Dental impression trays', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152106, 'Dental plaster knives', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152108, 'Dental impression material syringes or accessories', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152109, 'Dental impression material water baths or accessories', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152110, 'Dental marking devices', 42152100, 'Dental impression and forming equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152202, 'Dental laboratory air abrasion units', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152203, 'Dental laboratory burners or torches', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152204, 'Dental laboratory casting machines or its parts or accessories', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152205, 'Dental laboratory curing units', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152206, 'Dental laboratory dies', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152207, 'Dental laboratory dust collectors', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152209, 'Dental laboratory furnaces', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152210, 'Dental laboratory gold platers or supplies', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152211, 'Dental laboratory lathes or accessories', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152212, 'Dental laboratory model trimmers or accessories', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152214, 'Dental laboratory plaster traps', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152215, 'Dental laboratory sandblasters or supplies', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152216, 'Dental laboratory soldering machines or supplies', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152217, 'Dental laboratory vacuum units or supplies', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152218, 'Dental laboratory vibrators', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152219, 'Dental laboratory waxing units', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152220, 'Dental stones', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152222, 'Crucibles for dental casting machines', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152224, 'Dental laboratory flasks', 42152200, 'Dental laboratory and sterilization equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152301, 'Dental lasers', 42152300, 'Dental lasers and illumination and fiber optic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152303, 'General dental lights or its accessories', 42152300, 'Dental lasers and illumination and fiber optic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152422, 'Dental obturating points', 42152400, 'Dental materials', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152434, 'Dental amalgamators', 42152400, 'Dental materials', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152503, 'Dental dam supplies', 42152500, 'General dental supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152508, 'Dental syringes or needles or syringes with needles', 42152500, 'General dental supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152512, 'Dental tongs', 42152500, 'General dental supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152518, 'Dental materials dispensers', 42152500, 'General dental supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152519, 'Dental syringe accessory kits', 42152500, 'General dental supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152604, 'Dental operatory retraction cords', 42152600, 'Dental operatory specific supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152608, 'Orthodontic ligature cartridges', 42152600, 'Dental operatory specific supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152701, 'Dental articulators or accessories', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152704, 'Dental retainers', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152705, 'Orthodontic appliance clasps', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152706, 'Orthodontic brackets', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152713, 'Orthodontic pliers', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152715, 'Orthodontic setter bands', 42152700, 'Orthodontic and prosthodontic equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152801, 'Periodontal chisels', 42152800, 'Periodontal equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152803, 'Periodontal hoes', 42152800, 'Periodontal equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152808, 'Periodontal curettes', 42152800, 'Periodontal equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42152809, 'Periodontal knives', 42152800, 'Periodontal equipment and supplies', 42150000, 'Dental equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42161503, 'Peritoneal dialysis administration or catheterization sets', 42161500, 'Peritoneal and equilibrium dialysis equipment and supplies', 42160000, 'Dialysis equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42161615, 'Hemodialysis dialyzer reprocessing systems', 42161600, 'Extracorporeal hemodialysis equipment and supplies', 42160000, 'Dialysis equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42161632, 'Hemodialysis units', 42161600, 'Extracorporeal hemodialysis equipment and supplies', 42160000, 'Dialysis equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42161801, 'Continuous arteriovenous dialysis CAVHD units or related products', 42161800, 'Continuous renal replacement therapy CRRT equipment and supplies', 42160000, 'Dialysis equipment and supplies', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171502, 'Emergency medical services triage tags', 42171500, 'Emergency medical services disaster management products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171603, 'Anti shock garments', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171604, 'Basket stretchers or accessories', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171605, 'Cinch rescue loops', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171607, 'Emergency medical services cervical or extrication collars', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171608, 'Emergency medical services head immobilizers', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171610, 'Emergency medical services torso immobilizers', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171611, 'Emergency response litters or stretchers or accessories', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171613, 'Spine boards', 42171600, 'Emergency medical services extricating and immobilizing and transporting products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171702, 'First aid blankets', 42171700, 'Emergency medical services blankets', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171803, 'Emergency medical services suction units or accessories', 42171800, 'Emergency medical services airway management equipment', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42171804, 'Emergency medical services tracheal tube or cricothyrotomy kits', 42171800, 'Emergency medical services airway management equipment', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172001, 'Emergency medical services first aid kits', 42172000, 'Emergency and field medical services kits', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172003, 'Emergency medical service intravenous IV kit', 42172000, 'Emergency and field medical services kits', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172006, 'Emergency medical services obstetrics kits', 42172000, 'Emergency and field medical services kits', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172007, 'Emergency medical services oxygen or resuscitation kits', 42172000, 'Emergency and field medical services kits', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172008, 'Emergency medical services rappel kits', 42172000, 'Emergency and field medical services kits', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172101, 'Automated external defibrillators AED or hard paddles', 42172100, 'Emergency medical services resuscitation products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172102, 'Cardiopulmonary resuscitation CPR protective shields or masks', 42172100, 'Emergency medical services resuscitation products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172103, 'Emergency resuscitator or aspirator kits', 42172100, 'Emergency medical services resuscitation products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172104, 'Cardio pulmonary resuscitation CPR boards', 42172100, 'Emergency medical services resuscitation products', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42172201, 'Emergency medical services tourniquets or clamps', 42172200, 'Emergency medical services supplies', 42170000, 'Emergency and field medical services products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181501, 'Tongue depressors or blades or sticks', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181502, 'Medical exam transilluminators', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181504, 'Hemacytometer sets', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181506, 'Sexual assault determination kits', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181507, 'Medical examining mirror headbands or accessories', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181511, 'Male impotence gages', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181516, 'Electromyography EMG units or accessories', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181522, 'Apparatus for gait analysis', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181527, 'Medical dynamometer', 42181500, 'Diagnostic assessment and exam products for general use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181602, 'Electronic blood pressure units', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181603, 'Mercury blood pressure units', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181607, 'Blood pressure recording units', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181608, 'Blood pressure measuring instrument accessories', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181610, 'Blood pressure cuff kits', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181611, 'Central venous pressure CVP manometer', 42181600, 'Blood pressure units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181701, 'Electrocardiography EKG units', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181708, 'Electrocardiography EKG electrode patch', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181712, 'Electrocardiography EKG unit analyzers', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181713, 'Long term continuous electrocardiography EKG or holter monitoring systems', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181716, 'Electrocardiography EKG accessories', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181719, 'Electrocardiography EKG transmitter or telemetry or accessories', 42181700, 'Electrocardiography EKG units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181801, 'Pulse oximeter units', 42181800, 'Pulse oximeters', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181805, 'Pulse oximeter unit accessories', 42181800, 'Pulse oximeters', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181901, 'Acute care fetal or maternal monitoring units or accessories', 42181900, 'Acute care monitoring units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181902, 'Intracranial pressure ICP monitoring units or accessories', 42181900, 'Acute care monitoring units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181903, 'Cardiac output CO monitoring units or accessories', 42181900, 'Acute care monitoring units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42181904, 'Multiparameter vital sign unit or accessories', 42181900, 'Acute care monitoring units and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182002, 'Anoscopes or proctoscopes', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182003, 'Colposcopes or vaginoscopes or accessories', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182004, 'Dermatoscopes', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182005, 'Ophthalmoscopes or otoscopes or scope sets', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182012, 'Nasal exam specula or dilators', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182013, 'Vaginal exam specula', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182016, 'Nasopharyngoscopes or accessories', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182018, 'Bronchoscopes or accessories', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182020, 'Angioscopes or accessories', 42182000, 'Scopes and specula and accessories for medical exam diagnostic use', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182101, 'Electronic stethoscopes or accessories', 42182100, 'Stethoscopes and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182102, 'Hand held doppler or accessories', 42182100, 'Stethoscopes and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182103, 'Medical acoustic stethoscope or accessory', 42182100, 'Stethoscopes and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182106, 'Stethoscopic phonocardiographs', 42182100, 'Stethoscopes and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182107, 'Stethoscope headsets', 42182100, 'Stethoscopes and related products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182201, 'Electronic medical thermometers', 42182200, 'Medical thermometers and accessories', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182207, 'Patient temperature continuous or trend monitors', 42182200, 'Medical thermometers and accessories', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182209, 'Thermometer probes', 42182200, 'Medical thermometers and accessories', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182301, 'Medical diagnostic pinwheels', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182302, 'Reflex hammers or mallets', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182306, 'Neurological discriminators', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182308, 'Electroencephalograph EEG or accessories', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182310, 'Electromyographs', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182311, 'Neurologic sensor', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182312, 'Electromyograph electrodes or sets', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182313, 'Neurological diagnostic sets', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182314, 'Biofeedback device', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182315, 'Electroencephalographic spectrum analyser', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182316, 'Evoked response detector', 42182300, 'Neurological exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182401, 'Audiometers or accessories', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182402, 'Audiometric bone vibrators or middle ear analyzers', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182403, 'Audiometric booths or acoustic hearing test chambers', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182405, 'Auditory function screening units', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182408, 'Electrocochleographs', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182409, 'Hearing aid analyzers or test systems', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182412, 'Medical tuning forks', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182416, 'Tympanometers or accessories', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182420, 'Aural probes', 42182400, 'Hearing testing products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182603, 'Medical exam headlights or headlamps or accessories', 42182600, 'Medical exam lights or lamps', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182604, 'Medical exam penlights', 42182600, 'Medical exam lights or lamps', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182701, 'Goniometers', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182702, 'Medical tape measures', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182703, 'Patient height rulers', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182704, 'Skinfold calipers', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182705, 'Body composition analyzer', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182707, 'Inclinometer', 42182700, 'Medical exam size measuring devices', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182802, 'Infant scales', 42182800, 'Medical weight scales', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182803, 'Patient bed or table scales for general use', 42182800, 'Medical weight scales', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42182805, 'Patient floor scales', 42182800, 'Medical weight scales', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183001, 'Eye charts or vision cards', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183002, 'Corneal topographers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183003, 'Exophthalmometers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183004, 'Keratoscopes', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183007, 'Ophthalmic drums or its accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183009, 'Ophthalmic eye test lenses or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183010, 'Ophthalmic lensometers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183011, 'Ophthalmic perimeters', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183013, 'Ophthalmic prisms', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183014, 'Ophthalmic retinoscopes', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183015, 'Ophthalmic slit lamps', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183016, 'Ophthalmic spectrophotometers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183017, 'Ophthalmic specula', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183018, 'Ophthalmic tonometers or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183019, 'Ophthalmic transilluminators', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183020, 'Ophthalmic visual field plotters', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183021, 'Ophthalmic visual function analyzers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183024, 'Ophthalmic instrument tables or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183026, 'Ophthalmodynamometers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183027, 'Tangent screen test objects kits or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183028, 'Ophthalmic retinoscope accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183029, 'Phoropter units', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183030, 'Eye occluders', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183034, 'Vision testing stereoscopes', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183035, 'Combination refractor keratometers', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183037, 'Chart projectors or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183039, 'Ophthalmic lens holders', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183040, 'Opticians tools or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183041, 'Color perception testing lanterns', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183042, 'Depth perception apparatus', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183045, 'Electroretinogram systems', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183046, 'Binocular vision test sets or accessories', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183049, 'Fundus camera', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183050, 'Nystagmograph', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183051, 'Pupillometer', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42183066, 'Corneal camera', 42183000, 'Ophthalmic diagnostic exam products', 42180000, 'Patient exam and monitoring products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191612, 'Hospital intercom systems', 42191600, 'Medical facility building systems', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191802, 'Clinical incubators or infant warmers', 42191800, 'Patient beds and accessories', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191806, 'Clinical trapeze bars', 42191800, 'Patient beds and accessories', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191807, 'Patient care beds or accessories for general use', 42191800, 'Patient beds and accessories', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191808, 'Patient care beds or accessories for specialty care', 42191800, 'Patient beds and accessories', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191906, 'Blanket or solution warmer cabinets', 42191900, 'Clinical cabinetry', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42191909, 'Computerized medication dispensing cabinet', 42191900, 'Clinical cabinetry', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192001, 'Medical exam or procedure tables for general use', 42192000, 'Clinical procedure and examination tables', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192003, 'Physical therapy massage table', 42192000, 'Clinical procedure and examination tables', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192101, 'Blood drawing or phlebotomy chairs or accessories', 42192100, 'Clinical seating and stools and related products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192103, 'Patient chairs', 42192100, 'Clinical seating and stools and related products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192202, 'Gurneys or scissor lifts', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192203, 'Geriatric chairs or accessories', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192206, 'Patient scooters', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192207, 'Patient stretchers or stretcher accessories', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192208, 'Wheelchair accessories', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192209, 'Wheelchair ramps', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192210, 'Wheelchairs', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192211, 'Patient shifting boards or accessories', 42192200, 'Patient transport products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192301, 'Patient lifts or accessories', 42192300, 'Patient lifts', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192302, 'Clinical hydraulic lifts or accessories', 42192300, 'Patient lifts', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192304, 'Patient ceiling hoists', 42192300, 'Patient lifts', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192401, 'Emergency or resuscitation carts', 42192400, 'Medical equipment transport and transfer products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192404, 'Medical carts or accessories', 42192400, 'Medical equipment transport and transfer products', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192602, 'Medication or pill dispensers or accessories', 42192600, 'Medication dispensing and measuring devices and supplies', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42192604, 'Drug delivery system or accessories', 42192600, 'Medication dispensing and measuring devices and supplies', 42190000, 'Medical facility products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201501, 'Medical computed tomography CT or CAT complete stationary unit installation', 42201500, 'Medical computed tomography CT or CAT systems and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201503, 'Medical computed tomography CT or CAT 3 dimensional system components', 42201500, 'Medical computed tomography CT or CAT systems and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201510, 'Medical computed tomography CT or CAT quality assurance or calibration phantoms or devices', 42201500, 'Medical computed tomography CT or CAT systems and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201511, 'Medical computed tomography CT or CAT scanners or tubes', 42201500, 'Medical computed tomography CT or CAT systems and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201513, 'Medical computed tomography CT or CAT ultrafast system components', 42201500, 'Medical computed tomography CT or CAT systems and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201601, 'Medical magnetic resonance imaging MRI complete stationary unit installation', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201603, 'Medical magnetic resonance imaging MRI 3 dimensional system components', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201604, 'Medical magnetic resonance imaging MRI quality assurance or calibration phantoms or devices', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201605, 'Medical magnetic resonance imaging MRI coils', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201607, 'Medical magnetic resonance imaging MRI monitors', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201608, 'Medical magnetic resonance imaging MRI primary or remote or secondary consoles', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201609, 'Medical magnetic resonance imaging MRI scanners', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201611, 'Medical magnetic resonance imaging MRI tables', 42201600, 'Medical magnetic resonance imaging MRI products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201701, 'Cardiac ultrasound or doppler or echo units or cardioscopes', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201702, 'Fetal or gynecological ultrasound or echo units', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201704, 'Medical ultrasound bone densitometers', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201706, 'Medical ultrasound or doppler or echo probes', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201709, 'Medical ultrasound or doppler or echo monitors', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201710, 'Medical ultrasound or doppler or echo printers', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201711, 'Medical ultrasound or doppler or echo transducers or accessories', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201712, 'Medical ultrasound or doppler or pulse echo or echography units for general diagnostic use', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201713, 'Medical ultrasound or doppler or echo three dimensional components', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201715, 'Vaginal ultrasound or echo probes or accessories', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201718, 'Medical ultrasound ophthalmic scanners', 42201700, 'Medical ultrasound and doppler and echo imaging products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201804, 'Medical c arm x ray units', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201805, 'Medical cine fluoroscopy equipment', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201806, 'Medical radiology and fluoroscopy RF equipment', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201807, 'Medical radioisotope scanners', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201808, 'Medical x ray buckys', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201809, 'Medical imaging contrast agent injectors or accessories', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201810, 'Medical x ray film or cassette', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201811, 'Medical x ray quality assurance or calibration devices', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201815, 'Medical x ray units for general diagnostic use', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201817, 'X ray bone densitometers', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201820, 'Medical radiographic equipment grids', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201828, 'Medical x ray apparatus filters', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201829, 'Radiographic locators', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201830, 'Medical x ray intensifying screens', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42201833, 'Radiographic film or cassette changers', 42201800, 'Medical diagnostic x ray products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202001, 'Medical gamma cameras for general use', 42202000, 'Medical diagnostic gamma cameras and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202006, 'Bone densitometer', 42202000, 'Medical diagnostic gamma cameras and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202105, 'Brachytherapy units', 42202100, 'Brachytherapy products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202202, 'Radiosurgical gamma knife units or scintillators', 42202200, 'Gamma radiation therapy products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202301, 'Medical linear accelerator intensity modulated radiation therapy IMRT two dimensional units', 42202300, 'Medical linear accelerator intensity modulated radiation therapy IMRT products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202302, 'Medical linear accelerator intensity modulated radiation therapy IMRT three dimensional units', 42202300, 'Medical linear accelerator intensity modulated radiation therapy IMRT products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202303, 'Medical linear accelerator intensity modulated radiation therapy IMRT collimators', 42202300, 'Medical linear accelerator intensity modulated radiation therapy IMRT products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202401, 'Medical positron emission tomography PET units', 42202400, 'Medical positron emission tomography PET equipment and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202501, 'Medical single photon emission computed tomography SPECT units', 42202500, 'Medical single photon emission computed tomography SPECT equipment and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42202701, 'Radiotherapy teletherapy cobalt 60 equipment', 42202700, 'Radiotherapy teletherapy products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203001, 'Mobile or transportable medical linear accelerators', 42203000, 'Medical linear accelerators and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203101, 'Radiobiological effect microdosimeters', 42203100, 'Radiobiological instruments', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203201, 'X ray and fluoroscopy RF radiotherapy planning simulators', 42203200, 'Radiotherapy simulators', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203202, 'Computed tomography CT or CAT radiotherapy simulators', 42203200, 'Radiotherapy simulators', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203401, 'Coronary stent', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203402, 'Diagnostic or interventional vascular catheters or sets', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203403, 'Diagnostic or interventional vascular catheter introducers or sets', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203404, 'Vascular imaging guidewire', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203405, 'Angioplasty balloon catheter', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203406, 'Removal devices of diagnostic or interventional vascular catheters or sets', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203407, 'Angiography contrast medium delivery set', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203408, 'Cardiovascular sheath kits', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203414, 'Vascular filter', 42203400, 'Vascular imaging and interventional cardiology and cardiac catheterization lab products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203501, 'Cardiac pacemaker generator or cardiac resynchronization therapy pacemaker CRT-P', 42203500, 'Cardiac pacemakers and related products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203601, 'Defense Digital Imaging Network DIN system equipment', 42203600, 'Medical radiological imaging information and archiving products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203602, 'Digital Imaging Communications in Medicine DICOM standard system equipment', 42203600, 'Medical radiological imaging information and archiving products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203603, 'Medical picture archiving computer systems PACS', 42203600, 'Medical radiological imaging information and archiving products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203605, 'Medical x ray film archiving system software', 42203600, 'Medical radiological imaging information and archiving products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203702, 'Medical imaging wet darkroom or daylight processors', 42203700, 'Medical imaging processing equipment and supplies', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203705, 'Medical imaging dry laser printers or imagers', 42203700, 'Medical imaging processing equipment and supplies', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203707, 'Medical x ray darkroom equipment or supplies', 42203700, 'Medical imaging processing equipment and supplies', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203802, 'Medical magnetic resonance imaging MRI positioning aids', 42203800, 'Medical radiological positioning aids', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203803, 'Medical radiological positioning aids for general radiological use', 42203800, 'Medical radiological positioning aids', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203901, 'Medical radiation dosimeters', 42203900, 'Medical radiation detection or monitoring products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42203902, 'Medical radiation films or badges', 42203900, 'Medical radiation detection or monitoring products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42204002, 'Medical radiological shielding aprons or masks or drapes', 42204000, 'Medical radiological shielding and protection products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42204003, 'Medical radiological shielding portable containers for radioactive materials', 42204000, 'Medical radiological shielding and protection products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42204005, 'Medical radiological shielding gloves', 42204000, 'Medical radiological shielding and protection products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42204006, 'Medical radiological shielding freestanding or portable screens', 42204000, 'Medical radiological shielding and protection products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42204007, 'Medical radiological shielding wall or ceiling or floor installed panels', 42204000, 'Medical radiological shielding and protection products', 42200000, 'Medical diagnostic imaging and nuclear medicine products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211501, 'Canes or cane accessories', 42211500, 'Ambulation and transfer and positioning aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211502, 'Crutches or crutch accessories', 42211500, 'Ambulation and transfer and positioning aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211503, 'Positioning devices', 42211500, 'Ambulation and transfer and positioning aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211504, 'Standers or standing aids', 42211500, 'Ambulation and transfer and positioning aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211506, 'Walkers or rollators', 42211500, 'Ambulation and transfer and positioning aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211610, 'Shower or bath chairs or seats for the physically challenged', 42211600, 'Bathroom and bathing aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211611, 'Sitz baths for the physically challenged', 42211600, 'Bathroom and bathing aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211701, 'Adaptive communication switches for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211702, 'Braille devices for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211704, 'Headpointers or mouthsticks for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211705, 'Hearing aids for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211706, 'Letter or symbol boards for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211707, 'Telecommunication devices TDD or teletypewriters TTY for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211710, 'Writing aids for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211711, 'Voice synthesizers for the physically challenged', 42211700, 'Communication aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211803, 'Dressing sticks for the physically challenged', 42211800, 'Dressing and grooming aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211907, 'Cutlery or utensils for the physically challenged', 42211900, 'Eating and drinking and food preparation aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42211908, 'Cutting or paring boards for the physically challenged', 42211900, 'Eating and drinking and food preparation aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42212107, 'Flotation or swimming aids for the physically challenged', 42212100, 'Leisure and recreational aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42212109, 'Handicraft tools or materials or equipment for the physically challenged', 42212100, 'Leisure and recreational aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42212110, 'Page turners for the physically challenged', 42212100, 'Leisure and recreational aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42212201, 'Pill crushers or splitters for the physically challenged', 42212200, 'Medication handling aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42212304, 'Reachers for the physically challenged', 42212300, 'Reaching and gripping aids for the physically challenged', 42210000, 'Independent living aids for the physically challenged', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (42221501, 'Arterial line catheters', 42221500, 'Intravenous and arterial cannulas and catheters and accessories', 42220000, 'Intravenous and arterial administration products', 42000000, 'Medical Equipment and Accessories and Supplies');
INSERT INTO unspsc_reference (commodity_code, commodity_title, class_code, class_title, family_code, family_title, segment_code, segment_title) VALUES (