CREATE TABLE task_statements (
  onetsoc_code CHARACTER(10) NOT NULL,
  task_id DECIMAL(8,0) NOT NULL,
  task CHARACTER VARYING(1000) NOT NULL,
  task_type CHARACTER VARYING(12),
  incumbents_responding DECIMAL(4,0),
  date_updated DATE NOT NULL,
  domain_source CHARACTER VARYING(30) NOT NULL,
  PRIMARY KEY (task_id),
  FOREIGN KEY (onetsoc_code) REFERENCES occupation_data(onetsoc_code));

INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8823, 'Direct or coordinate an organization''s financial or budget activities to fund operations, maximize investments, or increase efficiency.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8831, 'Appoint department heads or managers and assign or delegate responsibilities to them.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8825, 'Analyze operations to evaluate performance of a company or its staff in meeting objectives or to determine areas of potential cost reduction, program improvement, or policy change.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8826, 'Direct, plan, or implement policies, objectives, or activities of organizations or businesses to ensure continuing operations, to maximize returns on investments, or to increase productivity.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8827, 'Prepare budgets for approval, including those for funding or implementation of programs.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8824, 'Confer with board members, organization officials, or staff members to discuss issues, coordinate activities, or resolve problems.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8836, 'Implement corrective action plans to solve organizational or departmental problems.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8832, 'Direct human resources activities, including the approval of human resource plans or activities, the selection of directors or other high-level staff, or establishment or organization of major departments.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8835, 'Establish departmental responsibilities and coordinate functions among departments and sites.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8833, 'Preside over or serve on boards of directors, management committees, or other governing boards.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8829, 'Negotiate or approve contracts or agreements with suppliers, distributors, federal or state agencies, or other organizational entities.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8837, 'Coordinate the development or implementation of budgetary control systems, recordkeeping systems, or other administrative control processes.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8830, 'Review reports submitted by staff members to recommend approval or to suggest changes.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8839, 'Deliver speeches, write articles, or present information at meetings or conventions to promote services, exchange ideas, or accomplish objectives.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8843, 'Interpret and explain policies, rules, regulations, or laws to organizations, government or corporate officials, or individuals.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8834, 'Prepare or present reports concerning activities, expenses, budgets, government statutes or rulings, or other items affecting businesses or program services.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 20461, 'Review and analyze legislation, laws, or public policy and recommend changes to promote or support interests of the general population or special groups.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8846, 'Administer programs for selection of sites, construction of buildings, or provision of equipment or supplies.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8848, 'Direct or conduct studies or research on issues affecting areas of responsibility.', 'Core', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8828, 'Direct or coordinate activities of businesses or departments concerned with production, pricing, sales, or distribution of products.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8844, 'Make presentations to legislative or other government committees regarding policies, programs, or budgets.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8845, 'Refer major policy matters to elected representatives for final decisions.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8847, 'Direct or coordinate activities of businesses involved with buying or selling investment products or financial services.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8851, 'Conduct or direct investigations or hearings to resolve complaints or violations of laws or testify at such hearings.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8838, 'Direct non-merchandising departments, such as advertising, purchasing, credit, or accounting.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8853, 'Prepare bylaws approved by elected officials and ensure that bylaws are enforced.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8840, 'Serve as liaisons between organizations, shareholders, and outside organizations.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8849, 'Attend and participate in meetings of municipal councils or council committees.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8852, 'Represent organizations or promote their objectives at official functions or delegate representatives to do so.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8850, 'Organize or approve promotional campaigns.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.00', 8842, 'Nominate citizens to boards or commissions.', 'Supplemental', 87, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15384, 'Develop or execute strategies to address issues such as energy use, resource conservation, recycling, pollution reduction, waste elimination, transportation, education, and building design.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15372, 'Supervise employees or volunteers working on sustainability projects.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15376, 'Research environmental sustainability issues, concerns, or stakeholder interests.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15381, 'Develop methodologies to assess the viability or success of sustainability initiatives.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15382, 'Monitor and evaluate effectiveness of sustainability programs.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15377, 'Evaluate and approve proposals for sustainability projects, considering factors such as cost effectiveness, technical feasibility, and integration with other initiatives.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15380, 'Develop, or oversee the development of, marketing or outreach media for sustainability projects or events.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15379, 'Develop, or oversee the development of, sustainability evaluation or monitoring systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15370, 'Create and maintain sustainability program documents, such as schedules and budgets.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15383, 'Direct sustainability program operations to ensure compliance with environmental or governmental regulations.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15367, 'Identify educational, training, or other development opportunities for sustainability employees or volunteers.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15378, 'Develop sustainability reports, presentations, or proposals for supplier, employee, academia, media, government, public interest, or other groups.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15374, 'Review sustainability program objectives, progress, or status to ensure compliance with policies, standards, regulations, or laws.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15375, 'Formulate or implement sustainability campaign or marketing strategies.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15368, 'Identify and evaluate pilot projects or programs to enhance the sustainability research agenda.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15369, 'Conduct risk assessments related to sustainability and the environment.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15371, 'Write project proposals, grant applications, or other documents to pursue funding for environmental initiatives.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1011.03', 15373, 'Write and distribute financial or environmental impact reports.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20699, 'Review financial statements, sales or activity reports, or other performance data to measure productivity or goal achievement or to identify areas needing cost reduction or program improvement.', 'Core', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 933, 'Direct and coordinate activities of businesses or departments concerned with the production, pricing, sales, or distribution of products.', 'Core', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20700, 'Direct administrative activities directly related to making products or providing services.', 'Core', 156, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20701, 'Prepare staff work schedules and assign specific duties.', 'Core', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20702, 'Monitor suppliers to ensure that they efficiently and effectively provide needed goods or services within budgetary limits.', 'Core', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20703, 'Direct or coordinate financial or budget activities to fund operations, maximize investments, or increase efficiency.', 'Core', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20704, 'Establish or implement departmental policies, goals, objectives, or procedures in conjunction with board members, organization officials, or staff members.', 'Core', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20705, 'Perform personnel functions such as selection, training, or evaluation.', 'Core', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20706, 'Plan or direct activities such as sales promotions that require coordination with other department managers.', 'Core', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20707, 'Set prices or credit terms for goods or services based on forecasts of customer demand.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 20708, 'Manage the movement of goods into and out of production facilities to ensure efficiency, effectiveness, or sustainability of operations.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 944, 'Perform sales floor work, such as greeting or assisting customers, stocking shelves, or taking inventory.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 945, 'Develop or implement product-marketing strategies, including advertising campaigns or sales promotions.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 948, 'Recommend locations for new facilities or oversee the remodeling or renovating of current facilities.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 19501, 'Implement or oversee environmental management or sustainability programs addressing issues such as recycling, conservation, or waste management.', 'Supplemental', 157, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 947, 'Direct non-merchandising departments of businesses, such as advertising or purchasing.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1021.00', 949, 'Plan store layouts or design displays.', 'Supplemental', 158, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15267, 'Analyze and understand the local and national implications of proposed legislation.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15268, 'Appoint nominees to leadership posts, or approve such appointments.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15269, 'Confer with colleagues to formulate positions and strategies pertaining to pending issues.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15270, 'Debate the merits of proposals and bill amendments during floor sessions, following the appropriate rules of procedure.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15271, 'Develop expertise in subject matters related to committee assignments.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15272, 'Hear testimony from constituents, representatives of interest groups, board and commission members, and others with an interest in bills or issues under consideration.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15273, 'Keep abreast of the issues affecting constituents by making personal visits and phone calls, reading local newspapers, and viewing or listening to local broadcasts.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15274, 'Maintain knowledge of relevant national and international current events.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15275, 'Make decisions that balance the perspectives of private citizens, public officials, and party leaders.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15276, 'Negotiate with colleagues or members of other political parties in order to reconcile differing interests, and to create policies and agreements.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15277, 'Prepare drafts of amendments, government policies, laws, rules, regulations, budgets, programs and procedures.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15278, 'Read and review concerns of constituents or the general public and determine if governmental action is necessary.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15279, 'Represent their parties in negotiations with political executives or members of other parties, and when speaking with the media.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15280, 'Review bills in committee, and make recommendations about their future.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15281, 'Seek federal funding for local projects and programs.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15282, 'Serve on commissions, investigative panels, study groups, and committees in order to examine specialized areas and recommend action.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15283, 'Vote on motions, amendments, and decisions on whether or not to report a bill out from committee to the assembly floor.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15284, 'Write, prepare, and deliver statements for the Congressional Record.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15285, 'Alert constituents of government actions and programs by way of newsletters, personal appearances at town meetings, phone calls, and individual meetings.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15286, 'Attend receptions, dinners, and conferences to meet people, exchange views and information, and develop working relationships.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15287, 'Conduct "head counts" to help predict the outcome of upcoming votes.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15288, 'Determine campaign strategies for media advertising, positions on issues, and public appearances.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15289, 'Encourage and support party candidates for political office.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15290, 'Establish personal offices in local districts or states, and manage office staff.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15291, 'Evaluate the structure, efficiency, activities, and performance of government agencies.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15292, 'Organize and maintain campaign organizations and fundraisers, in order to raise money for election or re-election.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15293, 'Oversee expense allowances, ensuring that accounts are balanced at the end of each fiscal year.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15294, 'Promote the industries and products of their electoral districts.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15295, 'Represent their government at local, national, and international meetings and conferences.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-1031.00', 15296, 'Speak to students to encourage and support the development of future political leaders.', NULL, NULL, TO_DATE('2006-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3224, 'Plan and prepare advertising and promotional material to increase sales of products or services, working with customers, company officials, sales departments, and advertising agencies.', 'Core', 73, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3226, 'Inspect layouts and advertising copy and edit scripts, audio and video tapes, and other promotional material for adherence to specifications.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3225, 'Assist with annual budget development.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3231, 'Confer with department heads or staff to discuss topics such as contracts, selection of advertising media, or product to be advertised.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3242, 'Coordinate with the media to disseminate advertising.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3227, 'Coordinate activities of departments, such as sales, graphic arts, media, finance, and research.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3238, 'Plan and execute advertising policies and strategies for organizations.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3237, 'Direct, motivate, and monitor the mobilization of a campaign team to advance campaign goals.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3230, 'Gather and organize information to plan advertising campaigns.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 21038, 'Create media notices about events.', 'Core', 73, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3223, 'Prepare budgets and submit estimates for program costs as part of campaign plan development.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3243, 'Contact organizations to explain services and facilities offered.', 'Core', 74, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3233, 'Monitor and analyze sales promotion results to determine cost effectiveness of promotion campaigns.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3229, 'Identify and develop contacts for promotional campaigns and industry programs that meet identified buyer targets, such as dealers, distributors, or consumers.', 'Core', 73, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3239, 'Track program budgets, expenses, and campaign response rates to evaluate each campaign based on program objectives and industry norms.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3234, 'Read trade journals and professional literature to stay informed on trends, innovations, and changes that affect media planning.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 18586, 'Manage sales team including setting goals, providing incentives, and evaluating employee performance.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3228, 'Prepare and negotiate advertising and sales contracts.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3235, 'Formulate plans to extend business with established accounts and to transact business as agent for advertising accounts.', 'Supplemental', 69, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3241, 'Train and direct workers engaged in developing and producing advertisements.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3232, 'Confer with clients to provide marketing or technical advice.', 'Supplemental', 73, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3240, 'Assemble and communicate with a strong, diverse coalition of organizations or public figures, securing their cooperation, support, and action, to further campaign goals.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3236, 'Provide presentation and product demonstration support during the introduction of new products and services to field staff and customers.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3245, 'Represent company at trade association meetings to promote products.', 'Supplemental', 74, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3244, 'Direct and coordinate product research and development.', 'Supplemental', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.00', 3246, 'Consult publications to learn about conventions and social functions and to organize prospect files for promotional purposes.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19941, 'Analyze green product marketing or sales trends to forecast future conditions.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 15400, 'Analyze the effectiveness of marketing tactics or channels.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19940, 'Attend or participate in conferences, community events, and promotional events related to green products or technologies.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19939, 'Conduct research on consumer opinions and buying habits, and identify target audiences for green products, services, or technologies.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19942, 'Develop branding or sales initiatives for green products, such as solar energy systems, green cleaning products, or products using renewable or recycled materials.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19938, 'Develop communications materials, advertisements, presentations, or public relations initiatives to promote awareness of green products and technologies.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19943, 'Develop comprehensive marketing strategies, using knowledge of green products and technologies, markets, and regulations.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19937, 'Identify marketing channels for green products or services.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19936, 'Revise existing marketing plans or campaigns for green products, technologies, or services.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19935, 'Write marketing content for green product web sites, brochures, or other communication media.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 15401, 'Analyze regional energy markets, including energy pricing, market structures, energy generation competition, and energy transmission constraints.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19944, 'Coordinate with other marketing team members and workers such as graphic artists to develop and implement marketing programs.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 15389, 'Devise or evaluate methods and procedures for collecting data, such as surveys, opinion polls, and questionnaires.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19934, 'Generate or identify sales leads for green products and technologies.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 15387, 'Maintain portfolios of marketing campaigns, strategies, and other marketing products or ideas.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2011.01', 19933, 'Monitor green-related industry statistics or literature to identify trends.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 951, 'Identify, develop, or evaluate marketing strategy, based on knowledge of establishment objectives, market characteristics, and cost and markup factors.', 'Core', 117, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 20709, 'Formulate, direct, or coordinate marketing activities or policies to promote products or services, working with advertising or promotion managers.', 'Core', 117, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 952, 'Evaluate the financial aspects of product development, such as budgets, expenditures, research and development appropriations, or return-on-investment and profit-loss projections.', 'Core', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 950, 'Develop pricing strategies, balancing firm objectives and customer satisfaction.', 'Core', 117, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 957, 'Compile lists describing product or service offerings.', 'Core', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 954, 'Direct the hiring, training, or performance evaluations of marketing or sales staff and oversee their daily activities.', 'Core', 117, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 956, 'Consult with product development personnel on product specifications such as design, color, or packaging.', 'Core', 113, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 958, 'Use sales forecasting or strategic planning to ensure the sale and profitability of products, lines, or services, analyzing business developments and monitoring market trends.', 'Core', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 955, 'Negotiate contracts with vendors or distributors to manage product distribution, establishing distribution networks or developing distribution strategies.', 'Core', 115, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 961, 'Coordinate or participate in promotional activities or trade shows, working with developers, advertisers, or production managers, to market products or services.', 'Core', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 963, 'Initiate market research studies or analyze their findings.', 'Core', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 960, 'Confer with legal staff to resolve problems, such as copyright infringement or royalty sharing with outside producers or distributors.', 'Core', 115, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 964, 'Consult with buying personnel to gain advice regarding the types of products or services expected to be in demand.', 'Supplemental', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 19502, 'Consult with buying personnel to gain advice regarding environmentally sound or sustainable products.', 'Supplemental', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 965, 'Conduct economic or commercial surveys to identify potential markets for products or services.', 'Supplemental', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 19505, 'Recommend modifications to products, packaging, production processes, or other characteristics to improve the environmental soundness or sustainability of products.', 'Supplemental', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 962, 'Advise business or other groups on local, national, or international factors affecting the buying or selling of products or services.', 'Supplemental', 113, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 959, 'Select products or accessories to be displayed at trade or special production shows.', 'Supplemental', 115, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 19503, 'Develop business cases for environmental marketing strategies.', 'Supplemental', 115, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2021.00', 19504, 'Integrate environmental information into product or company marketing strategies, policies, or activities.', 'Supplemental', 116, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 3, 'Direct and coordinate activities involving sales of manufactured products, services, commodities, real estate or other subjects of sale.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 1, 'Resolve customer complaints regarding sales and service.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 5, 'Review operational records and reports to project sales and determine profitability.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 14, 'Oversee regional and local sales managers and their staffs.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 4, 'Determine price schedules and discount rates.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 9, 'Prepare budgets and approve budget expenditures.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 2, 'Monitor customer preferences to determine focus of sales efforts.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 11, 'Plan and direct staffing, training, and performance evaluations to develop and control sales and service programs.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 6, 'Direct, coordinate, and review activities in sales and service accounting and record-keeping, and in receiving and shipping operations.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 15, 'Direct clerical staff to keep records of export correspondence, bid requests, and credit collections, and to maintain current information on tariffs, licenses, and restrictions.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 8, 'Advise dealers and distributors on policies and operating procedures to ensure functional effectiveness of business.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 7, 'Confer or consult with department heads to plan advertising services and to secure information on equipment and customer specifications.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 10, 'Represent company at trade association meetings to promote products.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 13, 'Confer with potential customers regarding equipment needs and advise customers on types of equipment to purchase.', 'Supplemental', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 17, 'Assess marketing potential of new and existing store locations, considering statistics and expenditures.', 'Supplemental', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 12, 'Visit franchised dealers to stimulate interest in establishment or expansion of leasing programs.', 'Supplemental', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2022.00', 16, 'Direct foreign sales and service outlets of an organization.', 'Supplemental', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 18462, 'Identify main client groups and audiences, determine the best way to communicate publicity information to them, and develop and implement a communication plan.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3249, 'Develop and maintain the company''s corporate image and identity, which includes the use of logos and signage.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3251, 'Manage special events, such as sponsorship of races, parties introducing new products, or other activities the firm supports, to gain public attention through the media without advertising directly.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3248, 'Write interesting and effective press releases, prepare information for media kits, and develop and maintain company internet or intranet web pages.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 20939, 'Design and edit promotional publications, such as brochures.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 18461, 'Establish and maintain effective working relationships with clients, government officials, and media representatives and use these relationships to develop new business opportunities.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3254, 'Evaluate advertising and promotion programs for compatibility with public relations efforts.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3261, 'Facilitate consumer relations or the relationship between parts of the company, such as the managers and employees, or different branch offices.', 'Core', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3260, 'Establish goals for soliciting funds, develop policies for collection and safeguarding of contributions, and coordinate disbursement of funds.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3253, 'Assign, supervise, and review the activities of public relations staff.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3250, 'Manage communications budgets.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3252, 'Draft speeches for company executives and arrange interviews and other forms of contact for them.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3259, 'Respond to requests for information about employers'' activities or status.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3257, 'Direct activities of external agencies, establishments, and departments that develop and implement communication strategies and information programs.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 20940, 'Develop, implement, and maintain crisis communication plans.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3258, 'Formulate policies and procedures related to public information programs, working with public relations executives.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3264, 'Produce films and other video products, regulate their distribution, and operate film library.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3256, 'Confer with labor relations managers to develop internal communications that keep employees informed of company activities.', 'Supplemental', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3265, 'Observe and report on social, economic, and political trends that might affect employers.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3262, 'Maintain company archives.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-2031.00', 3263, 'Manage in-house communication courses.', 'Supplemental', 92, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 18, 'Monitor the facility to ensure that it remains safe, secure, and well-maintained.', 'Core', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 21, 'Prepare and review operational reports and schedules to ensure accuracy and efficiency.', 'Core', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 20, 'Set goals and deadlines for the department.', 'Core', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 23, 'Acquire, distribute and store supplies.', 'Core', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 22, 'Analyze internal processes and recommend and implement procedural or policy changes to improve operations, such as supply changes or the disposal of records.', 'Core', 134, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 30, 'Conduct classes to teach procedures to staff.', 'Core', 134, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 24, 'Plan, administer, and control budgets for contracts, equipment, and supplies.', 'Supplemental', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 26, 'Hire and terminate clerical and administrative personnel.', 'Supplemental', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 19, 'Direct or coordinate the supportive services department of a business, agency, or organization.', 'Supplemental', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 25, 'Oversee construction and renovation projects to improve efficiency and to ensure that facilities meet environmental, health, and security standards, and comply with government regulations.', 'Supplemental', 134, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 27, 'Oversee the maintenance and repair of machinery, equipment, and electrical and mechanical systems.', 'Supplemental', 134, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 28, 'Manage leasing of facility space.', 'Supplemental', 131, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 29, 'Participate in architectural and engineering planning and design, including space and installation management.', 'Supplemental', 133, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3011.00', 31, 'Dispose of, or oversee the disposal of, surplus or unclaimed property.', 'Supplemental', 134, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 968, 'Direct daily operations of department, analyzing workflow, establishing priorities, developing standards and setting deadlines.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 975, 'Meet with department heads, managers, supervisors, vendors, and others, to solicit cooperation and resolve problems.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 978, 'Review project plans to plan and coordinate project activity.', 'Core', 75, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 969, 'Assign and review the work of systems analysts, programmers, and other computer-related workers.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 15198, 'Provide users with technical support for computer problems.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 971, 'Develop computer information resources, providing for data security and control, strategic computing, and disaster recovery.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 977, 'Recruit, hire, train and supervise staff, or participate in staffing decisions.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 970, 'Stay abreast of advances in technology.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 967, 'Consult with users, management, vendors, and technicians to assess computing needs and system requirements.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 976, 'Develop and interpret organizational goals, policies, and procedures.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 973, 'Evaluate the organization''s technology use and needs and recommend improvements, such as hardware and software upgrades.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 972, 'Review and approve all systems charts and programs prior to their implementation.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 980, 'Prepare and review operational reports or project progress reports.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 979, 'Evaluate data processing proposals to assess project feasibility and requirements.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 974, 'Control operational budget and expenditures.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 981, 'Purchase necessary equipment.', 'Core', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3021.00', 966, 'Manage backup, security and user help systems.', 'Supplemental', 76, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8857, 'Supervise employees performing financial reporting, accounting, billing, collections, payroll, and budgeting duties.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8865, 'Coordinate and direct the financial planning, budgeting, procurement, or investment activities of all or part of an organization.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8866, 'Develop internal control policies, guidelines, and procedures for activities such as budget administration, cash and credit management, and accounting.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8859, 'Maintain current knowledge of organizational policies and procedures, federal and state policies and directives, and current accounting standards.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8856, 'Prepare or direct preparation of financial statements, business activity reports, financial position forecasts, annual budgets, or reports required by regulatory agencies.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8869, 'Provide direction and assistance to other organizational units regarding accounting and budgeting policies and procedures and efficient control and utilization of financial resources.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8867, 'Analyze the financial details of past, present, and expected operations to identify development opportunities and areas where improvement is needed.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8868, 'Advise management on short-term and long-term financial objectives, policies, and actions.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 20168, 'Monitor financial activities and details, such as cash flow and reserve levels, to ensure that all legal and regulatory requirements are met.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8870, 'Evaluate needs for procurement of funds and investment of surpluses and make appropriate recommendations.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8863, 'Monitor and evaluate the performance of accounting and other financial staff, recommending and implementing personnel actions, such as promotions and dismissals.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8864, 'Develop and maintain relationships with banking, insurance, and external accounting personnel to facilitate financial activities.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8861, 'Receive, record, and authorize requests for disbursements in accordance with company policies and procedures.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8858, 'Delegate authority for the receipt, disbursement, banking, protection, and custody of funds, securities, and financial instruments.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8860, 'Conduct or coordinate audits of company accounts and financial transactions to ensure compliance with state and federal requirements and statutes.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8871, 'Lead staff training and development in budgeting and financial management areas.', 'Core', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8855, 'Prepare and file annual tax returns or prepare financial information so that outside accountants can complete tax returns.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8873, 'Compute, withhold, and account for all payroll deductions.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 20169, 'Handle all aspects of employee insurance, benefits, and casualty programs, including monitoring changes in health insurance regulations and creating budgets for benefits and worker''s compensation.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8872, 'Receive cash and checks and make deposits.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8874, 'Perform tax planning work.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.01', 8875, 'Determine depreciation rates to apply to capitalized items and advise management on actions regarding the purchase, lease, or disposal of such items.', 'Supplemental', 30, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8878, 'Plan, direct, or coordinate the activities of workers in branches, offices, or departments of establishments, such as branch banks, brokerage firms, risk and insurance departments, or credit departments.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8876, 'Establish and maintain relationships with individual or business customers or provide assistance with problems these customers may encounter.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 20462, 'Recruit staff members.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8886, 'Prepare operational or risk reports for management analysis.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8891, 'Evaluate data pertaining to costs to plan budgets.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 20463, 'Oversee training programs.', 'Core', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8877, 'Examine, evaluate, or process loan applications.', 'Supplemental', 85, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8882, 'Approve, reject, or coordinate the approval or rejection of lines of credit or commercial, real estate, or personal loans.', 'Supplemental', 85, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8879, 'Oversee the flow of cash or financial instruments.', 'Supplemental', 85, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8883, 'Prepare financial or regulatory reports required by laws, regulations, or boards of directors.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8894, 'Develop or analyze information to assess the current or future financial status of firms.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8890, 'Communicate with stockholders or other investors to provide information or to raise capital.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8887, 'Evaluate financial reporting systems, accounting or collection procedures, or investment activities and make recommendations for changes to procedures, operating systems, budgets, or other financial control functions.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8892, 'Analyze and classify risks and investments to determine their potential impacts on companies.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8881, 'Network within communities to find and attract new business.', 'Supplemental', 85, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8885, 'Review collection reports to determine the status of collections and the amounts of outstanding balances.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8884, 'Establish procedures for custody or control of assets, records, loan collateral, or securities to ensure safekeeping.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8888, 'Plan, direct, and coordinate risk and insurance programs of establishments to control risks and losses.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8893, 'Review reports of securities transactions or price lists to analyze market conditions.', 'Supplemental', 85, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8895, 'Direct insurance negotiations, select insurance brokers or carriers, and place insurance.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3031.02', 8889, 'Submit delinquent accounts to attorneys or outside agencies for collection.', 'Supplemental', 86, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 34, 'Review processing schedules or production orders to make decisions concerning inventory requirements, staffing requirements, work procedures, or duty assignments, considering budgetary limitations and time constraints.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 32, 'Direct or coordinate production, processing, distribution, or marketing activities of industrial organizations.', 'Core', 116, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 40, 'Develop or implement production tracking or quality control systems, analyzing production, quality control, maintenance, or other operational reports to detect production problems.', 'Core', 118, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 35, 'Review operations and confer with technical or administrative staff to resolve production or processing problems.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 36, 'Hire, train, evaluate, or discharge staff or resolve personnel grievances.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 38, 'Prepare and maintain production reports or personnel records.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 39, 'Set and monitor product standards, examining samples of raw products or directing testing during processing, to ensure finished products are of prescribed quality.', 'Core', 118, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 33, 'Develop budgets or approve expenditures for supplies, materials, or human resources, ensuring that materials, labor, or equipment are used efficiently to meet production targets.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 37, 'Initiate or coordinate inventory or cost control programs.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 43, 'Coordinate or recommend procedures for facility or equipment maintenance or modification, including the replacement of machines.', 'Core', 118, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 41, 'Review plans and confer with research or support staff to develop new products or processes.', 'Core', 118, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 42, 'Institute employee suggestion or involvement programs.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 44, 'Maintain current knowledge of the quality control field, relying on current literature pertaining to materials use, technological advances, or statistical studies.', 'Core', 117, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.00', 45, 'Negotiate materials prices with suppliers.', 'Supplemental', 118, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15411, 'Collect and analyze production samples to evaluate quality.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15428, 'Analyze quality control test results and provide feedback and interpretation to production management or staff.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15405, 'Stop production if serious product defects are present.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15430, 'Monitor performance of quality control systems to ensure effectiveness and efficiency.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15427, 'Communicate quality control information to all relevant organizational departments, outside vendors, or contractors.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15421, 'Instruct staff in quality control and analytical procedures.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15416, 'Produce reports regarding nonconformance of products or processes, daily production quality, root cause analyses, or quality trends.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15417, 'Participate in the development of product specifications.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15407, 'Review statistical studies, technological advances, or regulatory standards and trends to stay abreast of issues in the field of quality control.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15422, 'Identify critical points in the manufacturing process and specify sampling procedures to be used at these points.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15425, 'Create and implement inspection and testing criteria or procedures.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15429, 'Oversee workers including supervisors, inspectors, or laboratory workers engaged in testing activities.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15423, 'Document testing procedures, methodologies, or criteria.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15415, 'Review and update standard operating procedures or quality assurance manuals.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15420, 'Identify quality problems or areas for improvement and recommend solutions.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15413, 'Verify that raw materials, purchased parts or components, in-process samples, and finished products meet established testing and inspection standards.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15414, 'Review quality documentation necessary for regulatory submissions and inspections.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15408, 'Generate and maintain quality control operating budgets.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15424, 'Direct the tracking of defects, test results, or other regularly reported quality control data.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15409, 'Evaluate new testing and sampling methodologies or technologies to determine usefulness.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15431, 'Direct product testing activities throughout production cycles.', 'Core', 59, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15419, 'Instruct vendors or contractors on quality guidelines, testing procedures, or ways to eliminate deficiencies.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15410, 'Coordinate the selection and implementation of quality control equipment, such as inspection gauges.', 'Core', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15418, 'Monitor development of new products to help identify possible problems for mass production.', 'Supplemental', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15426, 'Confer with marketing and sales departments to define client requirements and expectations.', 'Supplemental', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15406, 'Review and approve quality plans submitted by contractors.', 'Supplemental', 59, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.01', 15412, 'Audit and inspect subcontractor facilities including external laboratories.', 'Supplemental', 60, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15446, 'Supervise employees in geothermal power plants or well fields.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15447, 'Oversee geothermal plant operations, maintenance, and repairs to ensure compliance with applicable standards or regulations.', 'Core', 50, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15434, 'Communicate geothermal plant conditions to employees.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15443, 'Identify and evaluate equipment, procedural, or conditional inefficiencies involving geothermal plant systems.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15439, 'Perform or direct the performance of preventative maintenance on geothermal plant equipment.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15448, 'Inspect geothermal plant or injection well fields to verify proper equipment operations.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15445, 'Develop or manage budgets for geothermal operations.', 'Core', 52, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15433, 'Select and implement corrosion control or mitigation systems for geothermal plants.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15444, 'Develop operating plans and schedules for geothermal operations.', 'Core', 52, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15436, 'Record, review, or maintain daily logs, reports, maintenance, and other records associated with geothermal operations.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15441, 'Monitor geothermal operations, using programmable logic controllers.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15432, 'Conduct well field site assessments.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15442, 'Identify opportunities to improve plant electrical equipment, controls, or process control methodologies.', 'Core', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15437, 'Prepare environmental permit applications or compliance reports.', 'Supplemental', 52, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15440, 'Negotiate interconnection agreements with other utilities.', 'Supplemental', 50, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15438, 'Obtain permits for constructing, upgrading, or operating geothermal power plants.', 'Supplemental', 52, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.02', 15435, 'Troubleshoot and make minor repairs to geothermal plant instrumentation or electrical systems.', 'Supplemental', 51, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15454, 'Supervise production employees in the manufacturing of biofuels, such as biodiesel or ethanol.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15462, 'Manage operations at biofuels power generation facilities, including production, shipping, maintenance, or quality assurance activities.', 'Core', 65, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15450, 'Provide direction to employees to ensure compliance with biofuels plant safety, environmental, or operational standards and regulations.', 'Core', 64, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15453, 'Confer with technical and supervisory personnel to report or resolve conditions affecting biofuels plant safety, operational efficiency, and product quality.', 'Core', 62, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15456, 'Review logs, datasheets, or reports to ensure adequate production levels or to identify abnormalities with biofuels production equipment or processes.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15458, 'Monitor meters, flow gauges, or other real-time data to ensure proper operation of biofuels production equipment, implementing corrective measures as needed.', 'Core', 65, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15461, 'Adjust temperature, pressure, vacuum, level, flow rate, or transfer of biofuels to maintain processes at required levels.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15449, 'Provide training to subordinate or new employees to improve biofuels plant safety or increase the production of biofuels.', 'Core', 64, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15455, 'Shut down and restart biofuels plant or equipment in emergency situations or for equipment maintenance, repairs, or replacements.', 'Core', 64, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15451, 'Monitor transportation and storage of flammable or other potentially dangerous feedstocks or products to ensure adherence to safety guidelines.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15452, 'Draw samples of biofuels products or secondary by-products for quality control testing.', 'Core', 64, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15460, 'Approve proposals for the acquisition, replacement, or repair of biofuels processing equipment or the implementation of new production processes.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15457, 'Prepare and manage biofuels plant or unit budgets.', 'Core', 65, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.03', 15459, 'Conduct cost, material, and efficiency studies for biofuels production plants or operations.', 'Core', 63, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15470, 'Review logs, datasheets, or reports to ensure adequate production levels and safe production environments or to identify abnormalities with power production equipment or processes.', 'Core', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15471, 'Review biomass operations performance specifications to ensure compliance with regulatory requirements.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15478, 'Supervise biomass plant or substation operations, maintenance, repair, or testing activities.', 'Core', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15473, 'Prepare and manage biomass plant budgets.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15468, 'Supervise operations or maintenance employees in the production of power from biomass, such as wood, coal, paper sludge, or other waste or refuse.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15479, 'Monitor the operating status of biomass plants by observing control system parameters, distributed control systems, switchboard gauges, dials, or other indicators.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15476, 'Inspect biomass gasification processes, equipment, and facilities for ways to maximize capacity and minimize operating costs.', 'Core', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15480, 'Conduct field inspections of biomass plants, stations, or substations to ensure normal and safe operating conditions.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15474, 'Plan and schedule plant activities, such as wood, waste, or refuse fuel deliveries, ash removal, and regular maintenance.', 'Core', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15477, 'Evaluate power production or demand trends to identify opportunities for improved operations.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15472, 'Prepare reports on biomass plant operations, status, maintenance, and other information.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15464, 'Manage parts and supply inventories for biomass plants.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15465, 'Monitor and operate communications systems, such as mobile radios.', 'Core', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15466, 'Compile and record operational data on forms or in log books.', 'Supplemental', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15469, 'Shut down and restart biomass power plants or equipment in emergency situations or for equipment maintenance, repairs, or replacements.', 'Supplemental', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15463, 'Test, maintain, or repair electrical power distribution machinery or equipment, using hand tools, power tools, and testing devices.', 'Supplemental', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15467, 'Adjust equipment controls to generate specified amounts of electrical power.', 'Supplemental', 137, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.04', 15475, 'Operate controls to start, stop, or regulate biomass-fueled generators, generator units, boilers, engines, or auxiliary systems.', 'Supplemental', 138, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15501, 'Monitor and control liquid or gas landfill extraction systems.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15500, 'Oversee gas collection landfill operations, including leachate and gas management or rail operations.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15498, 'Develop or enforce procedures for normal operation, start-up, or shut-down of methane gas collection systems.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15499, 'Evaluate landfill gas collection service requirements to meet operational plans and productivity goals.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15497, 'Implement landfill operational and emergency procedures.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15496, 'Inspect landfill or conduct site audits to ensure adherence to safety and environmental regulations.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15495, 'Maintain records for landfill gas collection systems to demonstrate compliance with safety and environmental laws, regulations, or policies.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15494, 'Monitor gas collection systems emissions data, including biomethane or nitrous oxide levels.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15492, 'Monitor landfill permit requirements for updates.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15493, 'Operate computerized control panels to manage gas compression operations.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15491, 'Optimize gas collection landfill operational costs and productivity consistent with safety and environmental rules and regulations.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15490, 'Oversee landfill gas collection system construction, maintenance, and repair activities.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15488, 'Prepare and manage landfill gas collection system budgets.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15489, 'Prepare soil reports as required by regulatory or permitting agencies.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15487, 'Supervise landfill, well field, and other subordinate employees.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15486, 'Read meters, gauges, or automatic recording devices at specified intervals to verify gas collection systems operating conditions.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15485, 'Coordinate the repair, overhaul, or routine maintenance of diesel engines used in landfill operations.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15484, 'Diagnose or troubleshoot gas collection equipment and programmable logic controller (PLC) systems.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15483, 'Prepare reports on landfill operations and gas collection system productivity or efficiency.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15482, 'Recommend or implement practices to reduce turnaround time for trucks in and out of landfill site.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.05', 15481, 'Track volume and weight of landfill waste.', NULL, NULL, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15520, 'Direct operations, maintenance, or repair of hydroelectric power facilities.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15515, 'Identify and communicate power system emergencies.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15512, 'Maintain records of hydroelectric facility operations, maintenance, or repairs.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15509, 'Perform or direct preventive or corrective containment or cleanup to protect the environment.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15513, 'Monitor or inspect hydroelectric equipment, such as hydro-turbines, generators, or control systems.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15514, 'Inspect hydroelectric facilities, including switchyards, control houses, or relay houses, for normal operation or adherence to safety standards.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15519, 'Supervise or monitor hydroelectric facility operations to ensure that generation or mechanical equipment conform to applicable regulations or standards.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15508, 'Plan or coordinate hydroelectric production operations to meet customer requirements.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15518, 'Check hydroelectric operations for compliance with prescribed operating limits, such as loads, voltages, temperatures, lines, or equipment.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15504, 'Develop or implement projects to improve efficiency, economy, or effectiveness of hydroelectric plant operations.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15503, 'Provide technical direction in the erection or commissioning of hydroelectric equipment or supporting electrical or mechanical systems.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15505, 'Supervise hydropower plant equipment installations, upgrades, or maintenance.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15507, 'Plan or manage hydroelectric plant upgrades.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15506, 'Respond to problems related to ratepayers, water users, power users, government agencies, educational institutions, or other private or public power resource interests.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15516, 'Develop or review budgets, annual plans, power contracts, power rates, standing operating procedures, power reviews, or engineering studies.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15502, 'Develop or implement policy evaluation procedures for hydroelectric generation activities.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15510, 'Operate energized high- or low-voltage hydroelectric power transmission system substations, according to procedures and safety requirements.', 'Supplemental', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15517, 'Create or enforce hydrostation voltage schedules.', 'Supplemental', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3051.06', 15511, 'Negotiate power generation contracts with other public or private utilities.', 'Supplemental', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1030, 'Represent companies in negotiating contracts and formulating policies with suppliers.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 21039, 'Develop cost reduction strategies and savings plans.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1027, 'Develop and implement purchasing and contract management instructions, policies, and procedures.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1033, 'Prepare bid awards requiring board approval.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1032, 'Direct and coordinate activities of personnel engaged in buying, selling, and distributing materials, equipment, machinery, and supplies.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1021, 'Locate vendors of materials, equipment or supplies, and interview them to determine product availability and terms of sales.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1024, 'Interview and hire staff, and oversee staff training.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1022, 'Prepare and process requisitions and purchase orders for supplies and equipment.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1031, 'Review, evaluate, and approve specifications for issuing and awarding bids.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1023, 'Control purchasing department budgets.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1025, 'Review purchase order claims and contracts for conformance to company policy.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1029, 'Resolve vendor or contractor grievances, and claims against suppliers.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1035, 'Administer online purchasing systems.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1020, 'Maintain records of goods ordered and received.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1026, 'Analyze market and delivery systems to assess present and future material availability.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1028, 'Participate in the development of specifications for equipment, products, or substitute materials.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1034, 'Prepare reports regarding market conditions and merchandise costs.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3061.00', 1036, 'Arrange for disposal of surplus materials.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1038, 'Plan, organize, or manage the work of subordinate staff to ensure that the work is accomplished in a manner consistent with organizational requirements.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1037, 'Direct activities related to dispatching, routing, or tracking transportation vehicles, such as aircraft or railroad cars.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20464, 'Monitor operations to ensure that staff members comply with administrative policies and procedures, safety rules, union contracts, environmental policies, or government regulations.', 'Core', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1040, 'Serve as contact persons for all workers within assigned territories.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20465, 'Implement schedule or policy changes for transportation services.', 'Core', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1046, 'Monitor spending to ensure that expenses are consistent with approved budgets.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1044, 'Promote safe work activities by conducting safety audits, attending company safety meetings, or meeting with individual staff members.', 'Core', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1055, 'Prepare management recommendations, such as proposed fee and tariff increases or schedule changes.', 'Core', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1039, 'Direct investigations to verify and resolve customer or shipper complaints.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20466, 'Direct or coordinate the activities of operations department to obtain use of equipment, facilities, or human resources.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1050, 'Analyze expenditures and other financial information to develop plans, policies, or budgets for increasing profits or improving services.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1042, 'Collaborate with other managers or staff members to formulate and implement policies, procedures, goals, or objectives.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 19510, 'Plan or implement energy saving changes to transportation services, such as reducing routes, optimizing capacities, employing alternate modes of transportation, or minimizing idling.', 'Core', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20467, 'Direct staff performing repairs and maintenance to equipment, vehicles, or facilities.', 'Core', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1056, 'Conduct employee training sessions on subjects such as hazardous material handling, employee orientation, quality improvement, or computer use.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1054, 'Recommend or authorize capital expenditures for acquisition of new equipment or property to increase efficiency and services of operations department.', 'Core', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20468, 'Conduct investigations in cooperation with government agencies to determine causes of transportation accidents, coordinate cleanup activities, or improve safety procedures.', 'Supplemental', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1053, 'Set operations policies and standards, including determining safety procedures for the handling of dangerous goods.', 'Supplemental', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1045, 'Develop criteria, application instructions, procedural manuals, or contracts for federal or state public transportation programs.', 'Supplemental', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 19506, 'Develop or implement plans to improve transportation services control from regional to national or global load control center operations.', 'Supplemental', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 19507, 'Direct central load control centers to maximize efficiency and effectiveness of transportation services.', 'Supplemental', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20469, 'Supervise clerks assigning tariff classifications or preparing billing.', 'Supplemental', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20470, 'Negotiate, authorize, or monitor fulfillment of contracts with equipment or materials suppliers.', 'Supplemental', 95, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 19508, 'Evaluate transportation vehicles or auxiliary equipment for purchase by considering factors, such as fuel economy or aerodynamics.', 'Supplemental', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 19509, 'Identify or select transportation and communications system technologies to reduce costs or environmental impacts.', 'Supplemental', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1058, 'Provide administrative or technical assistance to those receiving transportation-related grants.', 'Supplemental', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 1059, 'Direct procurement processes including equipment research and testing, vendor contracts, or requisitions approval.', 'Supplemental', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.01', 20471, 'Participate in union contract negotiations or grievance settlements.', 'Supplemental', 96, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3291, 'Supervise the activities of workers engaged in receiving, storing, testing, and shipping products or materials.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3292, 'Plan, develop, or implement warehouse safety and security programs and activities.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3298, 'Inspect physical conditions of warehouses, vehicle fleets, or equipment and order testing, maintenance, repairs, or replacements.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3297, 'Respond to customers'' or shippers'' questions and complaints regarding storage and distribution services.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3299, 'Develop and document standard and emergency operating procedures for receiving, handling, storing, shipping, or salvaging products or materials.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3293, 'Review invoices, work orders, consumption reports, or demand forecasts to estimate peak delivery periods and to issue work assignments.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 20941, 'Monitor inventory levels of products or materials in warehouses.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19512, 'Develop storage and distribution models that include factors such as warehouse locations, customer locations, or available transportation modes to maximize operational efficiency or sustainability.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3310, 'Track and trace goods while they are en route to their destinations, expediting orders when necessary.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3309, 'Participate in setting transportation and service rates.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3304, 'Prepare and manage departmental budgets.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3302, 'Issue shipping instructions and provide routing information to ensure that delivery times and locations are coordinated.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3313, 'Evaluate locations for new warehouses or distribution networks to determine their potential usefulness.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3300, 'Examine products or materials to estimate quantities or weight and type of container required for storage or transport.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3295, 'Interview, select, and train warehouse and supervisory personnel.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3307, 'Advise sales and billing departments of transportation charges for customers'' accounts.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3305, 'Prepare or direct preparation of correspondence, reports, and operations, maintenance, and safety manuals.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3306, 'Arrange for necessary shipping documentation and contact customs officials to effect release of shipments.', 'Core', 22, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3296, 'Confer with department heads to coordinate warehouse activities, such as production, sales, records control, or purchasing.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3311, 'Arrange for storage facilities when required.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3303, 'Examine invoices and shipping manifests for conformity to tariff and customs regulations.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19513, 'Evaluate contractors or business partners for operational efficiency or safety or environmental performance records.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3301, 'Negotiate with carriers, warehouse operators, or insurance company representatives for services and preferential rates.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3308, 'Evaluate freight or inventory costs associated with transit times to ensure that costs are appropriate.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3312, 'Develop or implement plans for facility modification or expansion, such as equipment purchase or changes in space allocation or structural design.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19511, 'Develop or implement plans for storage and distribution activities that emphasize technological solutions for sustainability, such as investment in smart or eco-friendly containers, dynamic distribution networks, warehouse renovations, or fuel efficient fleets.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 3294, 'Schedule or monitor air or surface pickup, delivery, or distribution of products or materials.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19516, 'Plan or implement environmental training programs and activities.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19514, 'Evaluate the environmental implications of new warehouses or distribution networks.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19517, 'Select modes of transportation for the distribution of goods that minimize pollution, such as carbon output or other environmental impacts.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.02', 19515, 'Identify and implement carbon minimization activities to offset carbon emissions, such as by planting trees, purchasing carbon credits, or purchasing green technologies, such as air filtration or alternative energy vehicles or power.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15752, 'Collaborate with other departments to integrate logistics with business systems or processes, such as customer sales, order management, accounting, or shipping.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15754, 'Supervise the work of logistics specialists, planners, or schedulers.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15751, 'Create policies or procedures for logistics activities.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15749, 'Direct distribution center operation to ensure achievement of cost, productivity, accuracy, or timeliness objectives.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15740, 'Resolve problems concerning transportation, logistics systems, imports or exports, or customer issues.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15757, 'Analyze all aspects of corporate logistics to determine the most cost-effective or efficient means of transporting products or supplies.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15745, 'Negotiate transportation rates or services.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19987, 'Direct or coordinate comprehensive logistical or reverse logistical functions for product life cycles, including acquisition, distribution, internal allocation, delivery, recycling, reuse, or final disposal of resources.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15753, 'Analyze the financial impact of proposed logistics changes, such as routing, shipping modes, product volumes or mixes, or carriers.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15756, 'Direct inbound or outbound logistics operations, such as transportation or warehouse activities, safety performance, or logistics quality management.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15747, 'Establish or monitor specific supply chain-based performance measurement systems.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15744, 'Participate in carrier management processes, such as selection, qualification, or performance evaluation.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15746, 'Monitor product import or export processes to ensure compliance with regulatory or legal requirements.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15748, 'Ensure carrier compliance with company policies or procedures for product transit or delivery.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15742, 'Plan or implement improvements to internal or external logistics systems or processes.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15743, 'Recommend optimal transportation modes, routing, equipment, or frequency.', 'Core', 29, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15737, 'Maintain metrics, reports, process documentation, customer service logs, or training or safety records.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15739, 'Implement specific customer requirements, such as internal reporting or customized transportation metrics.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19988, 'Negotiate with suppliers or customers to improve supply chain efficiency or sustainability.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19989, 'Communicate freight transportation information to customers or suppliers, using transportation management, electronic logistics marketplace, or electronic freight information systems, to improve efficiency, speed, or quality of transportation services.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15755, 'Plan or implement material flow management systems to meet production requirements.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15741, 'Develop risk management programs to ensure continuity of supply in emergency scenarios.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15736, 'Train shipping department personnel in roles or responsibilities regarding global logistics strategies.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15738, 'Recommend purchase of new or improved technology, such as automated systems.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 15750, 'Design models for use in evaluating logistics programs or services.', 'Core', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19991, 'Prepare or file environmental certification applications.', 'Supplemental', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19990, 'Review global, national, or regional transportation or logistics reports for ways to improve efficiency or minimize the environmental impact of logistics activities.', 'Supplemental', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19992, 'Conduct or review environmental audits for logistics activities, such as storage, distribution, or transportation.', 'Supplemental', 30, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19993, 'Implement or monitor carbon or environmental management, accounting, or audit systems.', 'Supplemental', 29, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3071.03', 19994, 'Develop plans or set goals to reduce carbon emissions associated with storage or transport activities.', 'Supplemental', 29, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3272, 'Design, evaluate and modify benefits policies to ensure that programs are current, competitive, and in compliance with legal requirements.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3273, 'Analyze compensation policies, government regulations, and prevailing wage rates to develop competitive compensation plan.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3268, 'Administer, direct, and review employee benefit programs, including the integration of benefit programs following mergers and acquisitions.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3276, 'Fulfill all reporting requirements of all relevant government rules and regulations, including the Employee Retirement Income Security Act (ERISA).', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3274, 'Formulate policies, procedures and programs for recruitment, testing, placement, classification, orientation, benefits and compensation, and labor and industrial relations.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3267, 'Direct preparation and distribution of written and verbal information to inform employees of benefits, compensation, and personnel policies.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3285, 'Manage the design and development of tools to assist employees in benefits selection, and to guide managers through compensation decisions.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3283, 'Prepare detailed job descriptions and classification systems and define job levels and families, in partnership with other managers.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3290, 'Study legislation, arbitration decisions, and collective bargaining contracts to assess industry trends.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3270, 'Plan, direct, supervise, and coordinate work activities of subordinates and staff relating to employment, compensation, labor relations, and employee relations.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3271, 'Identify and implement benefits to increase the quality of life for employees by working with brokers and researching benefits issues.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3287, 'Prepare budgets for personnel operations.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3275, 'Mediate between benefits providers and employees, such as by assisting in handling employees'' benefits-related questions or taking suggestions.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3279, 'Develop methods to improve employment policies, processes, and practices, and recommend changes to management.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3266, 'Advise management on such matters as equal employment opportunity, sexual harassment, and discrimination.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3280, 'Negotiate bargaining agreements.', 'Supplemental', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3286, 'Conduct exit interviews to identify reasons for employee termination.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3281, 'Investigate and report on industrial accidents for insurance carriers.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3288, 'Prepare personnel forecasts to project employment needs.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3278, 'Analyze statistical data and reports to identify and determine causes of personnel problems and develop recommendations for improvement of organization''s personnel policies and practices.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3277, 'Maintain records and compile statistical reports concerning personnel-related data, such as hires, transfers, performance appraisals, and absenteeism rates.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3269, 'Plan and conduct new-employee orientations to foster positive attitude toward organizational objectives.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3282, 'Represent organization at personnel-related hearings and investigations.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3111.00', 3289, 'Contract with vendors to provide employee services, such as food services, transportation, or relocation service.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 990, 'Serve as a link between management and employees by handling questions, interpreting and administering contracts and helping resolve work-related problems.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 987, 'Advise managers on organizational policy matters, such as equal employment opportunity and sexual harassment, and recommend needed changes.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 988, 'Analyze and modify compensation and benefits policies to establish competitive programs and ensure compliance with legal requirements.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 986, 'Perform difficult staffing duties, including dealing with understaffing, refereeing disputes, firing employees, and administering disciplinary procedures.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 998, 'Represent organization at personnel-related hearings and investigations.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 999, 'Negotiate bargaining agreements and help interpret labor contracts.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 983, 'Identify staff vacancies and recruit, interview, and select applicants.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 991, 'Plan, direct, supervise, and coordinate work activities of subordinates and staff relating to employment, compensation, labor relations, and employee relations.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1000, 'Prepare personnel forecast to project employment needs.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 985, 'Provide current and prospective employees with information about policies, job duties, working conditions, wages, opportunities for promotion, and employee benefits.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 997, 'Investigate and report on industrial accidents for insurance carriers.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 982, 'Administer compensation, benefits, and performance management systems, and safety and recreation programs.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 994, 'Analyze statistical data and reports to identify and determine causes of personnel problems and develop recommendations for improvement of organization''s personnel policies and practices.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 995, 'Plan, organize, direct, control, or coordinate the personnel, training, or labor relations activities of an organization.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 984, 'Allocate human resources, ensuring appropriate matches between personnel.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1003, 'Oversee the evaluation, classification, and rating of occupations and job positions.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 989, 'Plan and conduct new employee orientation to foster positive attitude toward organizational objectives.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 992, 'Analyze training needs to design employee development, language training, and health and safety programs.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1004, 'Study legislation, arbitration decisions, and collective bargaining contracts to assess industry trends.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 993, 'Maintain records and compile statistical reports concerning personnel-related data such as hires, transfers, performance appraisals, and absenteeism rates.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1001, 'Prepare and follow budgets for personnel operations.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 996, 'Conduct exit interviews to identify reasons for employee termination.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1002, 'Develop, administer, and evaluate applicant tests.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1005, 'Develop or administer special projects in areas such as pay equity, savings bond programs, day care, and employee awards.', 'Core', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1007, 'Contract with vendors to provide employee services, such as food service, transportation, or relocation service.', 'Supplemental', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3121.00', 1006, 'Provide terminated employees with outplacement or relocation assistance.', 'Supplemental', 24, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1015, 'Analyze training needs to develop new training programs or modify and improve existing programs.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1009, 'Evaluate instructor performance and the effectiveness of training programs, providing recommendations for improvement.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1014, 'Plan, develop, and provide training and staff development programs, using knowledge of the effectiveness of methods such as classroom training, demonstrations, on-the-job training, meetings, conferences, and workshops.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1019, 'Prepare training budget for department or organization.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1012, 'Confer with management and conduct surveys to identify training needs based on projected production processes, changes, and other factors.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1013, 'Develop and organize training manuals, multimedia visual aids, and other educational materials.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1010, 'Develop testing and evaluation procedures.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1017, 'Train instructors and supervisors in techniques and skills for training and dealing with employees.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1008, 'Conduct orientation sessions and arrange on-the-job training for new hires.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1011, 'Conduct or arrange for ongoing technical training and personal development classes for staff members.', 'Core', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1016, 'Review and evaluate training and apprenticeship programs for compliance with government standards.', 'Supplemental', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-3131.00', 1018, 'Coordinate established courses with technical and professional courses provided by community schools and designate training procedures.', 'Supplemental', 27, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12811, 'Manage nurseries that grow horticultural plants for sale to trade or retail customers, for display or exhibition, or for research.', 'Core', 91, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12812, 'Identify plants as well as problems such as diseases, weeds, and insect pests.', 'Core', 91, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12813, 'Tour work areas to observe work being done, to inspect crops, and to evaluate plant and soil conditions.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12814, 'Assign work schedules and duties to nursery or greenhouse staff, and supervise their work.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12815, 'Determine plant growing conditions, such as greenhouses, hydroponics, or natural settings, and set planting and care schedules.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12816, 'Apply pesticides and fertilizers to plants.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12817, 'Hire employees, and train them in gardening techniques.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12818, 'Select and purchase seeds, plant nutrients, disease control chemicals, and garden and lawn care equipment.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12819, 'Determine types and quantities of horticultural plants to be grown, based on budgets, projected sales volumes, or executive directives.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12820, 'Explain and enforce safety regulations and policies.', 'Core', 91, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12821, 'Position and regulate plant irrigation systems, and program environmental and irrigation control computers.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12822, 'Inspect facilities and equipment for signs of disrepair, and perform necessary maintenance work.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12823, 'Coordinate clerical, record-keeping, inventory, requisitioning, and marketing activities.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12824, 'Prepare soil for planting, and plant or transplant seeds, bulbs, and cuttings.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12825, 'Confer with horticultural personnel to plan facility renovations or additions.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12826, 'Cut and prune trees, shrubs, flowers, and plants.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12827, 'Provide information to customers on the care of trees, shrubs, flowers, plants, and lawns.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12828, 'Construct structures and accessories such as greenhouses and benches.', 'Core', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12829, 'Negotiate contracts such as those for land leases or tree purchases.', 'Supplemental', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.01', 12830, 'Graft plants.', 'Supplemental', 92, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18826, 'Inspect orchards or fields to determine crop maturity or condition or to detect disease or insect infestation.', 'Core', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18804, 'Direct crop production operations, such as planning, tilling, planting, fertilizing, cultivating, spraying, or harvesting.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18810, 'Monitor activities, such as irrigation, chemical application, harvesting, milking, breeding, or grading, to ensure adherence to safety regulations or standards.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18816, 'Plan crop activities based on factors such as crop maturity or weather conditions.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18809, 'Maintain financial, operational, production, or employment records for farms or ranches.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18805, 'Direct the breeding or raising of stock, such as cattle, poultry, or honeybees, using recognized breeding practices to ensure stock improvement.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18813, 'Obtain financing necessary for purchases of machinery, land, supplies, or livestock.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18825, 'Inspect farm or ranch equipment to ensure proper functioning.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18812, 'Negotiate with buyers for the sale, storage, or shipment of crops or livestock.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18821, 'Analyze soil to determine types or quantities of fertilizer required for maximum crop production.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18806, 'Evaluate marketing or sales alternatives for farm or ranch products.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18817, 'Prepare budgets or financial reports for farm or ranch operations.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18803, 'Determine types or quantities of crops or livestock to be raised, according to factors such as market conditions, federal programs or incentives, or soil conditions.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18823, 'Demonstrate or explain working techniques, practices, or safety regulations to farm or ranch workers.', 'Core', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18807, 'Hire, train, or supervise workers engaged in planting, cultivating, irrigating, harvesting, or marketing crops, or in raising livestock.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18818, 'Select or purchase machinery, equipment, livestock, or supplies, such as seed, feed, fertilizer, or chemicals.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18820, 'Analyze market conditions to determine acreage allocations.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18808, 'Inspect farm or ranch structures, such as buildings, fences, or roads, ordering repair or maintenance activities, as needed.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18819, 'Supervise the construction of farm or ranch structures, such as buildings, fences, drainage systems, wells, or roads.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18814, 'Operate or oversee the operations of dairy farms that produce bulk milk.', 'Supplemental', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18828, 'Plan and direct development or production of hardier or higher-yield hybrid plant varieties.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18822, 'Buy or sell futures contracts or price farm products in advance of future sales to minimize risk or maximize profits.', 'Supplemental', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18827, 'Monitor and adjust irrigation systems to distribute water according to crop needs and to avoid wasting water.', 'Supplemental', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18811, 'Monitor pasture or grazing land use to ensure that livestock are properly fed or that conservation methods, such as rotational grazing, are used.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18824, 'Direct livestock or crop waste recycling operations.', 'Supplemental', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18829, 'Replace chemical insecticides with environmentally friendly practices, such as adding pest-repelling plants to fields.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.02', 18802, 'Change processes, such as drying, grading, storing, or shipping, to improve efficiency or profitability.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10810, 'Grow fish and shellfish as cash crops or for release into freshwater or saltwater.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10816, 'Monitor environments to ensure maintenance of optimum conditions for aquatic life.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10811, 'Supervise and train aquaculture and fish hatchery support workers.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10820, 'Determine, administer, and execute policies relating to operations administration and standards, and facility maintenance.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10812, 'Collect and record growth, production, and environmental data.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10817, 'Direct and monitor trapping and spawning of fish, egg incubation, and fry rearing, applying knowledge of management and fish culturing techniques.', 'Core', 19, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10819, 'Direct and monitor the transfer of mature fish to lakes, ponds, streams, or commercial tanks.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10814, 'Account for and disburse funds.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10822, 'Determine how to allocate resources and to respond to unanticipated problems, such as insect infestation, drought, and fire.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10813, 'Conduct and supervise stock examinations to identify diseases or parasites.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10815, 'Devise and participate in activities to improve fish hatching and growth rates, and to prevent disease in hatcheries.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10825, 'Prepare reports required by state and federal laws.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10826, 'Identify environmental requirements of a particular species, and select and oversee the preparation of sites for species cultivation.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10823, 'Operate and maintain cultivating and harvesting equipment.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10824, 'Confer with biologists, fish pathologists, and other fishery personnel to obtain data concerning fish habits, diseases, food, and environmental requirements.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10818, 'Coordinate the selection and maintenance of brood stock.', 'Core', 19, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10821, 'Collect information regarding techniques for fish collection and fertilization, spawn incubation, and treatment of spawn and fry.', 'Core', 19, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10828, 'Design and construct pens, floating stations, and collector strings or fences for sea farms.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9013.03', 10827, 'Scuba dive to inspect sea farm operations.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3314, 'Confer with supervisory personnel, owners, contractors, or design professionals to discuss and resolve matters such as work procedures, complaints, or construction problems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20332, 'Plan, schedule, or coordinate construction project activities to meet deadlines.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3326, 'Prepare and submit budget estimates, progress reports, or cost tracking reports.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3318, 'Inspect or review projects to monitor compliance with building and safety codes or other regulations.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19522, 'Inspect or review projects to monitor compliance with environmental regulations.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3315, 'Plan, organize, or direct activities concerned with the construction or maintenance of structures, facilities, or systems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3323, 'Study job specifications to determine appropriate construction methods.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20333, 'Investigate damage, accidents, or delays at construction sites to ensure that proper construction procedures are being followed.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20334, 'Prepare contracts or negotiate revisions to contractual agreements with architects, consultants, clients, suppliers, or subcontractors.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3327, 'Develop or implement quality control programs.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19520, 'Develop or implement environmental protection programs.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20335, 'Implement new or modified plans in response to delays, bad weather, or construction site emergencies.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20336, 'Interpret and explain plans and contract terms to representatives of the owner or developer, including administrative staff, workers, or clients.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19523, 'Perform, or contract others to perform, pre-building assessments, such as conceptual cost estimating, rough order of magnitude estimating, feasibility, or energy efficiency, environmental, and sustainability assessments.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20337, 'Apply for and obtain all necessary permits or licenses.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20338, 'Evaluate construction methods and determine cost-effectiveness of plans, using computer models.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20339, 'Contract or oversee craft work, such as painting or plumbing.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 20340, 'Direct and supervise construction or related workers.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3317, 'Determine labor requirements for dispatching workers to construction sites.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3325, 'Requisition supplies or materials to complete construction projects.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19521, 'Implement training programs on environmentally responsible building topics to update employee skills and knowledge.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19524, 'Secure third-party verification from sources such as Leadership in Energy Efficient Design (LEED) to ensure responsible design and building activities or to achieve favorable LEED ratings for building projects.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19519, 'Develop construction budgets to compare green and non-green construction alternatives, in terms of short-term costs, long-term costs, or environmental impacts.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 19518, 'Apply green building strategies to reduce energy costs or minimize carbon output or other sources of harm to the environment.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9021.00', 3331, 'Direct acquisition of land for construction projects.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5193, 'Confer with parents and staff to discuss educational activities and policies and students'' behavioral or learning problems.', 'Core', 91, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5196, 'Monitor students'' progress and provide students and teachers with assistance in resolving any problems.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5198, 'Recruit, hire, train, and evaluate primary and supplemental staff and recommend personnel actions for programs and services.', 'Core', 91, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5204, 'Teach classes or courses or provide direct care to children.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5195, 'Set educational standards and goals and help establish policies, procedures, and programs to carry them out.', 'Core', 89, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5202, 'Determine the scope of educational program offerings and prepare drafts of program schedules and descriptions to estimate staffing and facility requirements.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5197, 'Determine allocations of funds for staff, supplies, materials, and equipment and authorize purchases.', 'Core', 91, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5199, 'Direct and coordinate activities of teachers or administrators at daycare centers, schools, public agencies, or institutions.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5194, 'Prepare and maintain attendance, activity, planning, accounting, or personnel reports and records for officials and agencies, or direct preparation and maintenance activities.', 'Core', 89, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5200, 'Plan, direct, and monitor instructional methods and content of educational, vocational, or student activity programs.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5201, 'Review and interpret government codes and develop procedures to meet codes and to ensure facility safety, security, and maintenance.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5203, 'Review and evaluate new and current programs to determine their efficiency, effectiveness, and compliance with state, local, and federal regulations and recommend any necessary modifications.', 'Core', 89, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5207, 'Collect and analyze survey data, regulatory information, and demographic and employment trends to forecast enrollment patterns and the need for curriculum changes.', 'Core', 91, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5208, 'Inform businesses, community groups, and governmental agencies about educational needs, available programs, and program policies.', 'Core', 89, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5206, 'Write articles, manuals, and other publications and assist in the distribution of promotional literature about programs and facilities.', 'Core', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5205, 'Prepare and submit budget requests or grant proposals to solicit program funding.', 'Supplemental', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9031.00', 5209, 'Organize and direct committees of specialists, volunteers, and staff to provide technical and advisory assistance for programs.', 'Supplemental', 90, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5222, 'Evaluate curricula, teaching methods, and programs to determine their effectiveness, efficiency, and use, and to ensure that school activities comply with federal, state, and local regulations.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5226, 'Observe teaching methods and examine learning materials to evaluate and standardize curricula and teaching techniques, and to determine areas where improvement is needed.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5215, 'Counsel and provide guidance to students regarding personal, academic, vocational, or behavioral issues.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5232, 'Collaborate with teachers to develop and maintain curriculum standards, develop mission statements, and set performance goals and objectives.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5221, 'Direct and coordinate activities of teachers, administrators, and support staff at schools, public agencies, and institutions.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5224, 'Recruit, hire, train, and evaluate primary and supplemental staff.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5212, 'Confer with parents and staff to discuss educational activities, policies, and student behavioral or learning problems.', 'Core', 105, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5225, 'Enforce discipline and attendance rules.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 21040, 'Create school improvement plans by using student performance data.', 'Core', 105, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5223, 'Set educational standards and goals, and help establish policies and procedures to carry them out.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18587, 'Plan and lead professional development activities for teachers, administrators, and support staff.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18588, 'Participate in special education-related activities, such as attending meetings and providing support to special educators throughout the district.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5219, 'Plan and develop instructional methods and content for educational, vocational, or student activity programs.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5234, 'Determine the scope of educational program offerings, and prepare drafts of course schedules and descriptions to estimate staffing and facility requirements.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5213, 'Prepare and submit budget requests and recommendations, or grant proposals to solicit program funding.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5231, 'Recommend personnel actions related to programs and services.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5210, 'Review and approve new programs, or recommend modifications to existing programs, submitting program proposals for school board approval as necessary.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5220, 'Develop partnerships with businesses, communities, and other organizations to help meet identified educational needs and to provide school-to-work programs.', 'Core', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5228, 'Review and interpret government codes, and develop programs to ensure adherence to codes and facility safety, security, and maintenance.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5229, 'Determine allocations of funds for staff, supplies, materials, and equipment, and authorize purchases.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5214, 'Direct and coordinate school maintenance services and the use of school facilities.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5216, 'Organize and direct committees of specialists, volunteers, and staff to provide technical and advisory assistance for programs.', 'Core', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5211, 'Prepare, maintain, or oversee the preparation and maintenance of attendance, activity, planning, or personnel reports and records.', 'Core', 105, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18592, 'Mentor and support administrative staff members, such as superintendents and principals.', 'Supplemental', 102, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5227, 'Establish, coordinate, and oversee particular programs across school districts, such as programs to evaluate student academic achievement.', 'Supplemental', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18591, 'Coordinate and direct extracurricular activities and programs, such as after-school events and athletic contests.', 'Supplemental', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5218, 'Advocate for new schools to be built, or for existing facilities to be repaired or remodeled.', 'Supplemental', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18590, 'Plan, coordinate, and oversee school logistics programs, such as bus and food services.', 'Supplemental', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5217, 'Teach classes or courses to students.', 'Supplemental', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 18589, 'Meet with federal, state, and local agencies to keep updated on policies and to discuss improvements for education programs.', 'Supplemental', 103, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5230, 'Write articles, manuals, and other publications, and assist in the distribution of promotional literature about facilities and programs.', 'Supplemental', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9032.00', 5233, 'Collect and analyze survey data, regulatory information, and data on demographic and employment trends to forecast enrollment patterns and curriculum change needs.', 'Supplemental', 104, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 21041, 'Design or use assessments to monitor student learning outcomes.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5235, 'Recruit, hire, train, and terminate departmental personnel.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18594, 'Direct, coordinate, and evaluate the activities of personnel, including support staff engaged in administering academic institutions, departments, or alumni organizations.', 'Core', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18593, 'Advise students on issues such as course selection, progress toward graduation, and career decisions.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5236, 'Plan, administer, and control budgets, maintain financial records, and produce financial reports.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18595, 'Formulate strategic plans for the institution.', 'Core', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5240, 'Establish operational policies and procedures and make any necessary modifications, based on analysis of operations, demographics, and other research information.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5239, 'Provide assistance to faculty and staff in duties such as teaching classes, conducting orientation programs, issuing transcripts, and scheduling events.', 'Core', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5237, 'Represent institutions at community and campus events, in meetings with other institution personnel, and during accreditation processes.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 21042, 'Prepare reports on academic or institutional data.', 'Core', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18596, 'Promote the university by participating in community, state, and national events or meetings, and by developing partnerships with industry and secondary education institutions.', 'Core', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5238, 'Participate in faculty and college committee activities.', 'Core', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5243, 'Direct activities of administrative departments, such as admissions, registration, and career services.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5242, 'Appoint individuals to faculty positions, and evaluate their performance.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5244, 'Develop curricula, and recommend curricula revisions and additions.', 'Supplemental', 112, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5246, 'Consult with government regulatory and licensing agencies to ensure the institution''s conformance with applicable standards.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5249, 'Participate in student recruitment, selection, and admission, making admissions recommendations when required to do so.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5245, 'Determine course schedules, and coordinate teaching assignments and room assignments to ensure optimum use of buildings and equipment.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5248, 'Teach courses within their department.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5250, 'Review student misconduct reports requiring disciplinary action, and counsel students regarding such reports.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5255, 'Review registration statistics, and consult with faculty officials to develop registration policies.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5241, 'Confer with other academic staff to explain and formulate admission requirements and course credit policies.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5253, 'Direct scholarship, fellowship, and loan programs, performing activities such as selecting recipients and distributing aid.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5259, 'Direct and participate in institutional fundraising activities, and encourage alumni participation in such activities.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5254, 'Coordinate the production and dissemination of university publications, such as course catalogs and class schedules.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18597, 'Write grants to procure external funding, and supervise grant-funded projects.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5258, 'Plan and promote sporting events and social, cultural, and recreational activities.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 5256, 'Audit the financial status of student organizations and facility accounts.', 'Supplemental', 114, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9033.00', 18598, 'Oversee facilities management for the university, including construction, repair, and maintenance projects.', 'Supplemental', 113, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15539, 'Communicate to faculty, students, or other users availability of, or changes to, distance learning courses or materials, programs, services, or applications.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15536, 'Develop distance learning program goals or plans, including equipment replacement, quality assurance, or course offering plans.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15527, 'Supervise distance learning support staff.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15538, 'Assess distance-learning technological or educational needs and goals.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15525, 'Train instructors and distance learning staff in the use or support of distance learning applications, such as course management software.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15530, 'Prepare and manage distance learning program budgets.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15526, 'Troubleshoot and resolve problems with distance learning equipment or applications.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15540, 'Analyze data to assess distance learning program status or to inform decisions for distance learning programs.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15531, 'Prepare reports summarizing distance learning statistical data or describing distance learning program objectives and accomplishments.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15528, 'Purchase equipment or services in accordance with distance learning plans and budget constraints.', 'Core', 21, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15537, 'Create and maintain web sites or databases that support distance learning programs.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15533, 'Monitor technological developments in distance learning for technological means to educational or outreach goals.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15534, 'Evaluate the effectiveness of distance learning programs in promoting knowledge or skill acquisition.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15541, 'Provide technical or logistical support to users of distance learning classrooms, equipment, web sites, or services.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15543, 'Develop or provide technical resources, such as course management and videoconferencing systems, networking, and webcasting, for distance learning programs.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15522, 'Review distance learning content to ensure compliance with copyright, licensing, or other requirements.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15529, 'Select, direct, and monitor the work of vendors that provide products or services for distance learning programs.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15542, 'Prepare and distribute schedules of distance learning resources, such as course offerings, classrooms, laboratories, equipment, and web sites.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15524, 'Communicate technical or marketing information about distance learning via podcasts, webinars, and other technologies.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15532, 'Negotiate with academic units or instructors and vendors to ensure cost-effective and high-quality distance learning programs, services, or courses.', 'Core', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15535, 'Direct and support the technical operation of distance learning classrooms or equipment.', 'Core', 21, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15521, 'Write and submit grant applications or proposals to secure funding for distance learning programs.', 'Core', 21, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.01', 15523, 'Conduct inventories of distance learning equipment, summarizing equipment usage data.', 'Supplemental', 22, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15557, 'Manage or oversee fitness or recreation facilities, ensuring safe and clean facilities and equipment.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15545, 'Provide individual support or counseling in general wellness or nutrition.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15561, 'Supervise fitness or wellness specialists, such as fitness instructors, nutritionists, or health educators.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15548, 'Conduct needs assessments or surveys to determine interest in, or satisfaction with, wellness and fitness programs, events, or services.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15562, 'Develop or coordinate fitness and wellness programs or services.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15553, 'Prepare or implement budgets and strategic, operational, purchasing, or maintenance plans.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 20316, 'Track cost-containment strategies and programs to evaluate effectiveness.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15558, 'Maintain wellness- and fitness-related schedules, records, or reports.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15560, 'Develop fitness or wellness classes, such as yoga, aerobics, strength training, or aquatics, ensuring a diversity of class offerings.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15550, 'Select or supervise contractors, such as event hosts or health, fitness, and wellness practitioners.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15552, 'Recommend or approve new program or service offerings to promote wellness and fitness, produce revenues, or minimize costs.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15547, 'Develop marketing campaigns to promote a healthy lifestyle or participation in fitness or wellness programs.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15544, 'Track attendance, participation, or performance data related to wellness events.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15556, 'Demonstrate proper operation of fitness equipment, such as resistance machines, cardio machines, free weights, or fitness assessment devices.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 20315, 'Organize and oversee fitness or wellness programs, such as information presentations, blood drives, or training in first aid or cardiopulmonary resuscitation (CPR).', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15559, 'Conduct or facilitate training sessions or seminars for wellness and fitness staff.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15551, 'Respond to customer, public, or media requests for information about wellness programs or services.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 20314, 'Interpret insurance data or Health Reimbursement Account (HRA) data to develop programs that address specific needs of target populations.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15546, 'Maintain or arrange for maintenance of fitness equipment or facilities.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15554, 'Organize and oversee health screenings or other preventive measures, such as mammography, blood pressure, or cholesterol screenings or flu vaccinations.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 20317, 'Use computer skills and software to manage Web sites or databases, publish newsletters, or provide webinars.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15549, 'Teach fitness classes to improve strength, flexibility, cardiovascular conditioning, or general fitness of participants.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9039.02', 15555, 'Organize and oversee events such as organized runs or walks.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20170, 'Manage the coordination and overall integration of technical activities in architecture or engineering projects.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20171, 'Direct, review, or approve project design changes.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1060, 'Confer with management, production, or marketing staff to discuss project specifications or procedures.', 'Core', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1070, 'Present and explain proposals, reports, or findings to clients.', 'Core', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1071, 'Consult or negotiate with clients to prepare project specifications.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20172, 'Prepare budgets, bids, or contracts.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20173, 'Assess project feasibility by analyzing technology, resource needs, or market demand.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20174, 'Direct recruitment, placement, and evaluation of architecture or engineering project staff.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20175, 'Review, recommend, or approve contracts or cost estimates.', 'Core', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20176, 'Develop or implement policies, standards, or procedures for engineering and technical work.', 'Core', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1063, 'Plan or direct the installation, testing, operation, maintenance, or repair of facilities or equipment.', 'Core', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20177, 'Perform administrative functions, such as reviewing or writing reports, approving expenditures, enforcing rules, or purchasing of materials or services.', 'Core', 127, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20178, 'Establish scientific or technical goals within broad outlines provided by top management.', 'Supplemental', 124, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 19526, 'Evaluate environmental regulations or social pressures related to environmental issues to inform strategic or operational decision-making.', 'Supplemental', 126, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20179, 'Solicit project support by conferring with officials or providing information to the public.', 'Supplemental', 124, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 19525, 'Develop or implement programs to improve sustainability or reduce the environmental impacts of engineering or architecture activities or operations.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 19527, 'Evaluate the environmental impacts of engineering, architecture, or research and development activities.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1074, 'Direct the engineering of water control, treatment, or distribution projects.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 19528, 'Identify environmental threats or opportunities associated with the development and launch of new technologies.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 20180, 'Plan, direct, or coordinate survey work with other project activities.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.00', 1073, 'Administer highway planning, construction, or maintenance.', 'Supplemental', 125, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15574, 'Design or conduct applied biodiesel or biofuels research projects on topics, such as transport, thermodynamics, mixing, filtration, distillation, fermentation, extraction, and separation.', 'Core', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15578, 'Analyze data from biofuels studies, such as fluid dynamics, water treatments, or solvent extraction and recovery processes.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15567, 'Prepare, or oversee the preparation of, experimental plans for biofuels research or development.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15566, 'Provide technical or scientific guidance to technical staff in the conduct of biofuels research or development.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15580, 'Propose new biofuels products, processes, technologies or applications based on findings from applied biofuels or biomass research projects.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15576, 'Conduct experiments on biomass or pretreatment technologies.', 'Core', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15568, 'Prepare biofuels research and development reports for senior management or technical professionals.', 'Core', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15563, 'Develop lab scale models of industrial scale processes, such as fermentation.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15579, 'Oversee biodiesel/biofuels prototyping or development projects.', 'Core', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15577, 'Conduct experiments to test new or alternate feedstock fermentation processes.', 'Core', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15572, 'Develop methods to estimate the efficiency of biomass pretreatments.', 'Supplemental', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15565, 'Develop carbohydrates arrays and associated methods for screening enzymes involved in biomass conversion.', 'Supplemental', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15569, 'Perform protein functional analysis and engineering for processing of feedstock and creation of biofuels.', 'Supplemental', 97, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15581, 'Conduct research to breed or develop energy crops with improved biomass yield, environmental adaptability, pest resistance, production efficiency, bioprocessing characteristics, or reduced environmental impacts.', 'Supplemental', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15564, 'Develop computational tools or approaches to improve biofuels research and development activities.', 'Supplemental', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15570, 'Develop separation processes to recover biofuels.', 'Supplemental', 98, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15575, 'Design chemical conversion processes, such as etherification, esterification, interesterification, transesterification, distillation, hydrogenation, oxidation or reduction of fats and oils, and vegetable oil refining.', 'Supplemental', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15573, 'Design or execute solvent or product recovery experiments in laboratory or field settings.', 'Supplemental', 99, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9041.01', 15571, 'Develop methods to recover ethanol or other fuels from complex bioreactor liquid and gas streams.', 'Supplemental', 100, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1085, 'Keep records required by government agencies regarding sanitation or food subsidies.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1078, 'Investigate and resolve complaints regarding food quality, service, or accommodations.', 'Core', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1090, 'Maintain food and equipment inventories, and keep inventory records.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1080, 'Monitor food preparation methods, portion sizes, and garnishing and presentation of food to ensure that food is prepared and presented in an acceptable manner.', 'Core', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1079, 'Schedule and receive food and beverage deliveries, checking delivery contents to verify product quality and quantity.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1084, 'Coordinate assignments of cooking personnel to ensure economical use of food and timely preparation.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1083, 'Monitor compliance with health and fire regulations regarding food preparation and serving, and building maintenance in lodging and dining facilities.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 15199, 'Count money and make bank deposits.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1086, 'Establish standards for personnel performance and customer service.', 'Core', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1089, 'Perform some food preparation or service tasks, such as cooking, clearing tables, and serving food and drinks when necessary.', 'Core', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1098, 'Greet guests, escort them to their seats, and present them with menus and wine lists.', 'Core', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1077, 'Test cooked food by tasting and smelling it to ensure palatability and flavor conformity.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1082, 'Schedule staff hours and assign duties.', 'Core', 88, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1096, 'Arrange for equipment maintenance and repairs, and coordinate a variety of services, such as waste removal and pest control.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1093, 'Review menus and analyze recipes to determine labor and overhead costs, and assign prices to menu items.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1091, 'Organize and direct worker training programs, resolve personnel problems, hire new staff, and evaluate employee performance in dining and lodging facilities.', 'Core', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1088, 'Review work procedures and operational problems to determine ways to improve service, performance, or safety.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1095, 'Assess staffing needs and recruit staff, using methods such as newspaper advertisements or attendance at job fairs.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1092, 'Order and purchase equipment and supplies.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1094, 'Record the number, type, and cost of items sold to determine which items may be unpopular or less profitable.', 'Core', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1097, 'Monitor employee and patron activities to ensure liquor regulations are obeyed.', 'Supplemental', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1081, 'Monitor budgets and payroll records, and review financial transactions to ensure that expenditures are authorized and budgeted.', 'Supplemental', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1087, 'Estimate food, liquor, wine, and other beverage consumption to anticipate amounts to be purchased or requisitioned.', 'Supplemental', 88, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1103, 'Schedule use of facilities or catering services for events such as banquets or receptions, and negotiate details of arrangements with clients.', 'Supplemental', 91, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1102, 'Take dining reservations.', 'Supplemental', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1100, 'Plan menus and food utilization, based on anticipated number of guests, nutritional value, palatability, popularity, and costs.', 'Supplemental', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1099, 'Establish and enforce nutritional standards for dining establishments, based on accepted industry standards.', 'Supplemental', 90, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9051.00', 1101, 'Create specialty dishes and develop recipes to be used in dining facilities.', 'Supplemental', 89, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18832, 'Consult with families or friends of the deceased to arrange funeral details, such as obituary notice wording, casket selection, or plans for services.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18833, 'Direct and supervise work of embalmers, funeral attendants, death certificate clerks, cosmetologists, or other staff.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18842, 'Schedule funerals, burials, or cremations.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18843, 'Sell funeral services, products, or merchandise to clients.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18835, 'Monitor funeral service operations to ensure that they comply with applicable policies, regulations, and laws.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18837, 'Offer counsel and comfort to families and friends of the deceased.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18836, 'Negotiate contracts for prearranged funeral services.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18840, 'Respond to customer complaints, legal inquiries, payment negotiations, or other post-service matters.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18838, 'Plan and implement changes to service offerings to meet community needs or increase funeral home revenues.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18834, 'Direct or monitor administrative, support, repair, or maintenance services for funeral homes.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18851, 'Schedule work hours for funeral home or contract employees.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18844, 'Set marketing, sales, or other financial goals for funeral service establishments and monitor progress toward these goals.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18848, 'Explain goals, policies, or procedures to staff members.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18846, 'Complete and maintain records, such as state-required documents, tracking documents, or product inventories.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18847, 'Evaluate the performance of vendors, contract employees, or other service providers to ensure quality and cost-efficiency.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18845, 'Set prices or credit terms for funeral products or services.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18841, 'Review financial statements, sales or activity reports, or other performance data to identify opportunities for cost reductions or service improvements.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18849, 'Identify skill development needs for funeral home staff.', 'Core', 55, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18830, 'Attend or make presentations at community events to promote funeral home services or build community relationships.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18839, 'Plan and implement sales promotions or other marketing strategies and activities for funeral home operations.', 'Core', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18850, 'Interview and hire new employees.', 'Supplemental', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9061.00', 18831, 'Conduct market research and analyze industry trends.', 'Supplemental', 56, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7186, 'Remove suspected cheaters, such as card counters or other players who may have systems that shift the odds of winning to their favor.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7189, 'Circulate among gaming tables to ensure that operations are conducted properly, that dealers follow house rules, or that players are not cheating.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7190, 'Explain and interpret house rules, such as game rules or betting limits.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7196, 'Track supplies of money to tables and perform any required paperwork.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7185, 'Resolve customer complaints regarding problems, such as payout errors.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 20472, 'Market or promote the casino to bring in business.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7193, 'Prepare work schedules and station arrangements and keep attendance records.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7197, 'Set and maintain a bank and table limit for each game.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7187, 'Maintain familiarity with all games used at a facility, as well as strategies or tricks employed in those games.', 'Core', 90, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7191, 'Monitor staffing levels to ensure that games and tables are adequately staffed for each shift, arranging for staff rotations and breaks and locating substitute employees as necessary.', 'Core', 90, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7199, 'Review operational expenses, budget estimates, betting accounts, or collection reports for accuracy.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7188, 'Train new workers or evaluate their performance.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7192, 'Interview and hire workers.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7194, 'Direct the distribution of complimentary hotel rooms, meals, or other discounts or free items given to players, based on their length of play and betting totals.', 'Core', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7195, 'Establish policies on issues, such as the type of gambling offered and the odds, the extension of credit, or the serving of food and beverages.', 'Core', 90, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7200, 'Record, collect, or pay off bets, issuing receipts as necessary.', 'Supplemental', 90, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7201, 'Direct the compilation of summary sheets that show wager amounts and payoffs for races or events.', 'Supplemental', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7198, 'Monitor credit extended to players.', 'Supplemental', 91, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9071.00', 7202, 'Notify board attendants of table vacancies so that waiting patrons can play.', 'Supplemental', 90, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1105, 'Answer inquiries pertaining to hotel policies and services, and resolve occupants'' complaints.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1108, 'Participate in financial activities, such as the setting of room rates, the establishment of budgets, and the allocation of funds to departments.', 'Core', 48, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1109, 'Confer and cooperate with other managers to ensure coordination of hotel activities.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1104, 'Greet and register guests.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 18599, 'Monitor the revenue activity of the hotel or facility.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1111, 'Manage and maintain temporary or permanent lodging facilities.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1113, 'Train staff members.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1112, 'Observe and monitor staff performance to ensure efficient operations and adherence to facility''s policies and procedures.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1107, 'Coordinate front-office activities of hotels or motels, and resolve problems.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1116, 'Inspect guest rooms, public areas, and grounds for cleanliness and appearance.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1106, 'Assign duties to workers, and schedule shifts.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1123, 'Receive and process advance registration payments, mail letters of confirmation, or return checks when registrations cannot be accepted.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1118, 'Interview and hire applicants.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1119, 'Purchase supplies, and arrange for outside services, such as deliveries, laundry, maintenance and repair, and trash collection.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 18600, 'Collect payments and record data pertaining to funds and expenditures.', 'Core', 48, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1115, 'Develop and implement policies and procedures for the operation of a department or establishment.', 'Core', 48, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1117, 'Prepare required paperwork pertaining to departmental functions.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1114, 'Show, rent, or assign accommodations.', 'Core', 48, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1121, 'Perform marketing and public relations activities.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1122, 'Organize and coordinate the work of staff and convention personnel for meetings to be held at a particular facility.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1125, 'Provide assistance to staff members by inspecting rooms, setting tables, or doing laundry.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1120, 'Arrange telephone answering services, deliver mail and packages, or answer questions regarding locations for eating and entertainment.', 'Core', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1124, 'Meet with clients to schedule and plan details of conventions, banquets, receptions and other functions.', 'Supplemental', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9081.00', 1126, 'Book tickets for guests for local tours and attractions.', 'Supplemental', 49, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 49, 'Develop and maintain computerized record management systems to store and process data, such as personnel activities and information, and to produce reports.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 46, 'Direct, supervise and evaluate work activities of medical, nursing, technical, clerical, service, maintenance, and other personnel.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 48, 'Direct or conduct recruitment, hiring, and training of personnel.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 50, 'Develop and implement organizational policies and procedures for the facility or medical unit.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 51, 'Conduct and administer fiscal operations, including accounting, planning budgets, authorizing expenditures, establishing rates for services, and coordinating financial reporting.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 55, 'Maintain awareness of advances in medicine, computerized diagnostic and treatment equipment, data processing technology, government regulations, health insurance changes, and financing options.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 58, 'Plan, implement, and administer programs and services in a health care or medical facility, including personnel administration, training, and coordination of medical, nursing and physical plant staff.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 57, 'Prepare activity reports to inform management of the status and implementation plans of programs, services, and quality initiatives.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 52, 'Establish work schedules and assignments for staff, according to workload, space, and equipment availability.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 53, 'Maintain communication between governing boards, medical staff, and department heads by attending board meetings and coordinating interdepartmental functioning.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 47, 'Establish objectives and evaluative or operational criteria for units managed.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 61, 'Review and analyze facility activities and data to aid planning and cash and risk management and to improve service utilization.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 56, 'Manage change in integrated health care delivery systems, such as work restructuring, technological innovations, and shifts in the focus of care.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 63, 'Develop instructional materials and conduct in-service and community-based educational programs.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 54, 'Monitor the use of diagnostic services, inpatient beds, facilities, and staff to ensure effective use of resources and assess the need for additional staff, equipment, and services.', 'Supplemental', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 60, 'Inspect facilities and recommend building or equipment modifications to ensure emergency readiness and compliance to access, safety, and sanitation regulations.', 'Supplemental', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 62, 'Develop or expand and implement medical programs or health services that promote research, rehabilitation, and community health.', 'Supplemental', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9111.00', 59, 'Consult with medical, business, and community groups to discuss service problems, respond to community needs, enhance public relations, coordinate activities and plans, and promote health programs.', 'Supplemental', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7203, 'Confer with scientists, engineers, regulators, or others to plan or review projects or to provide technical assistance.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7204, 'Develop client relationships and communicate with clients to explain proposals, present research findings, establish specifications, or discuss project status.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7205, 'Plan or direct research, development, or production activities.', 'Core', 67, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7208, 'Review project activities and prepare and review research, testing, or operational reports.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7210, 'Determine scientific or technical goals within broad outlines provided by top management and make detailed plans to accomplish these goals.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7211, 'Develop or implement policies, standards, or procedures for the architectural, scientific, or technical work performed to ensure regulatory compliance or operations enhancement.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7209, 'Hire, supervise, or evaluate engineers, technicians, researchers, or other staff.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7207, 'Design or coordinate successive phases of problem analysis, solution proposals, or testing.', 'Core', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7215, 'Recruit personnel or oversee the development or maintenance of staff competence.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7206, 'Prepare project proposals.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7214, 'Conduct own research in field of expertise.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7217, 'Prepare and administer budgets, approve and review expenditures, and prepare financial reports.', 'Core', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7218, 'Make presentations at professional meetings to further knowledge in the field.', 'Core', 68, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7212, 'Develop innovative technology or train staff for its implementation.', 'Core', 70, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7213, 'Provide for stewardship of plant or animal resources or habitats, studying land use, monitoring animal populations, or providing shelter, resources, or medical treatment for animals.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.00', 7216, 'Advise or assist in obtaining patents or meeting other legal requirements.', 'Supplemental', 69, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15614, 'Maintain required records of study activity including case report forms, drug dispensation records, or regulatory forms.', 'Core', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15597, 'Oversee subject enrollment to ensure that informed consent is properly obtained and documented.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15613, 'Monitor study activities to ensure compliance with protocols and with all relevant local, federal, and state regulatory and institutional polices.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15594, 'Record adverse event and side effect data and confer with investigators regarding the reporting of events to oversight agencies.', 'Core', 73, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15610, 'Assess eligibility of potential subjects through methods such as screening interviews, reviews of medical records, or discussions with physicians and nurses.', 'Core', 74, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15585, 'Prepare for or participate in quality assurance audits conducted by study sponsors, federal agencies, or specially designated review groups.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15603, 'Identify protocol problems, inform investigators of problems, or assist in problem resolution efforts, such as protocol revisions.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15595, 'Prepare study-related documentation, such as protocol worksheets, procedural manuals, adverse event reports, institutional review board documents, or progress reports.', 'Core', 74, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15592, 'Track enrollment status of subjects and document dropout information such as dropout causes and subject contact efforts.', 'Core', 74, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15593, 'Review proposed study protocols to evaluate factors such as sample collection processes, data management plans, or potential subject risks.', 'Core', 70, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15609, 'Code, evaluate, or interpret collected study data.', 'Core', 74, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15586, 'Participate in preparation and management of research budgets and monetary disbursements.', 'Core', 73, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15596, 'Participate in the development of study protocols including guidelines for administration or data collection procedures.', 'Core', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15601, 'Instruct research staff in scientific and procedural aspects of studies including standards of care, informed consent procedures, or documentation procedures.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15607, 'Communicate with laboratories or investigators regarding laboratory findings.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15583, 'Review scientific literature, participate in continuing education activities, or attend conferences and seminars to maintain current knowledge of clinical studies affairs and issues.', 'Core', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15598, 'Order drugs or devices necessary for study completion.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15591, 'Confer with health care professionals to determine the best recruitment practices for studies.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15608, 'Collaborate with investigators to prepare presentations or reports of clinical study procedures, results, and conclusions.', 'Core', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15612, 'Schedule subjects for appointments, procedures, or inpatient stays as required by study protocols.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15587, 'Perform specific protocol procedures such as interviewing subjects, taking vital signs, and performing electrocardiograms.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15604, 'Dispense medical devices or drugs, and calculate dosages and provide instructions as necessary.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15600, 'Maintain contact with sponsors to schedule and coordinate site visits or to answer questions about issues such as incomplete data.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15602, 'Inform patients or caregivers about study aspects and outcomes to be expected.', 'Supplemental', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15605, 'Direct the requisition, collection, labeling, storage, or shipment of specimens.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15584, 'Register protocol patients with appropriate statistical centers as required.', 'Supplemental', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15588, 'Interpret protocols and advise treating physicians on appropriate dosage modifications or treatment calculations based on patient characteristics.', 'Supplemental', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15611, 'Arrange for research study sites and determine staff or equipment availability.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15606, 'Contact outside health care providers and communicate with subjects to obtain follow-up information.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15590, 'Contact industry representatives to ensure equipment and software specifications necessary for successful study completion.', 'Supplemental', 70, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15582, 'Solicit industry-sponsored trials through contacts and professional organizations.', 'Supplemental', 71, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15599, 'Organize space for study equipment and supplies.', 'Supplemental', 72, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.01', 15589, 'Develop advertising and other informational materials to be used in subject recruitment.', 'Supplemental', 70, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15618, 'Perform hydrologic, hydraulic, or water quality modeling.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15631, 'Conduct, or oversee the conduct of, investigations on matters such as water storage, wastewater discharge, pollutants, permits, or other compliance and regulatory issues.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15628, 'Develop plans to protect watershed health or rehabilitate watersheds.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15634, 'Develop strategies for watershed operations to meet water supply and conservation goals or to ensure regulatory compliance with clean water laws or regulations.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15627, 'Identify and characterize specific causes or sources of water pollution.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15621, 'Write proposals, project reports, informational brochures, or other documents on wastewater purification, water supply and demand, or other water resource subjects.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15624, 'Present water resource proposals to government, public interest groups, or community groups.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15616, 'Review or evaluate designs for water detention facilities, storm drains, flood control facilities, or other hydraulic structures.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15635, 'Conduct, or oversee the conduct of, chemical, physical, and biological water quality monitoring or sampling to ensure compliance with water quality standards.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15630, 'Conduct technical studies for water resources on topics such as pollutants and water treatment options.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15622, 'Recommend new or revised policies, procedures, or regulations to support water resource or conservation goals.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15626, 'Monitor water use, demand, or quality in a particular geographic area.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15633, 'Analyze storm water systems to identify opportunities for water resource improvements.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15623, 'Provide technical expertise to assist communities in the development or implementation of storm water monitoring or other water programs.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15619, 'Compile water resource data, using geographic information systems (GIS) or global position systems (GPS) software.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15632, 'Conduct cost-benefit studies for watershed improvement projects or water management alternatives.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15629, 'Develop or implement standardized water monitoring and assessment methods.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15617, 'Negotiate for water rights with communities or water facilities to meet water supply demands.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15620, 'Compile and maintain documentation on the health of a body of water.', 'Core', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15615, 'Supervise teams of workers who capture water from wells and rivers.', 'Supplemental', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9121.02', 15625, 'Identify methods for distributing purified wastewater into rivers, streams, or oceans.', 'Supplemental', 29, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 20842, 'Monitor employees'' work schedules and attendance for payroll purposes.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5260, 'Organize and supervise activities, such as the processing of incoming and outgoing mail.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5262, 'Resolve customer complaints.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5264, 'Prepare employee work schedules.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5261, 'Direct and coordinate operational, management, and supportive services of one or a number of postal facilities.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5263, 'Hire and train employees, and evaluate their performance.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5265, 'Prepare and submit detailed and summary reports of post office activities to designated supervisors.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5266, 'Negotiate labor disputes.', 'Core', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5270, 'Select and train postmasters and managers of associate postal units.', 'Supplemental', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5269, 'Inform the public of available services, and of postal laws and regulations.', 'Supplemental', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5268, 'Issue and cash money orders.', 'Supplemental', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5267, 'Collect rents for post office boxes.', 'Supplemental', 86, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9131.00', 5271, 'Confer with suppliers to obtain bids for proposed purchases and to requisition supplies, disbursing funds according to federal regulations.', 'Supplemental', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7224, 'Manage and oversee operations, maintenance, administration, and improvement of commercial, industrial, or residential properties.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7223, 'Plan, schedule, and coordinate general maintenance, major repairs, and remodeling or construction projects for commercial or residential properties.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7220, 'Direct collection of monthly assessments, rental fees, and deposits and payment of insurance premiums, mortgage, taxes, and incurred operating expenses.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7221, 'Inspect grounds, facilities, and equipment routinely to determine necessity of repairs or maintenance.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7236, 'Act as liaisons between on-site managers or tenants and owners.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7219, 'Meet with prospective tenants to show properties, explain terms of occupancy, and provide information about local areas.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7231, 'Market vacant space to prospective tenants through leasing agents, advertising, or other methods.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7228, 'Prepare detailed budgets and financial reports for properties.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7226, 'Maintain records of sales, rental or usage activity, special permits issued, maintenance and operating costs, or property availability.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7229, 'Direct and coordinate the activities of staff and contract personnel and evaluate their performance.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7241, 'Meet with clients to negotiate management and service contracts, determine priorities, and discuss the financial and operational status of properties.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7232, 'Solicit and analyze bids from contractors for repairs, renovations, and maintenance.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7234, 'Prepare and administer contracts for provision of property services, such as cleaning, maintenance, and security services.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7222, 'Investigate complaints, disturbances and violations and resolve problems, following management rules and regulations.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7233, 'Review rents to ensure that they are in line with rental markets.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7230, 'Maintain contact with insurance carriers, fire and police departments, and other agencies to ensure protection and compliance with codes and regulations.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7238, 'Meet with boards of directors and committees to discuss and resolve legal and environmental issues or disputes between neighbors.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7235, 'Purchase building and maintenance supplies, equipment, or furniture.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7227, 'Determine and certify the eligibility of prospective tenants, following government regulations.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7237, 'Confer regularly with community association members to ensure their needs are being met.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7225, 'Negotiate the sale, lease, or development of property and complete or review appropriate documents and forms.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7240, 'Clean common areas, change light bulbs, and make minor property repairs.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7242, 'Negotiate short- and long-term loans to finance construction and ownership of structures.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7239, 'Confer with legal authorities to ensure that renting and advertising practices are not discriminatory and that properties comply with state and federal regulations.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7245, 'Analyze information on property values, taxes, zoning, population growth, and traffic volume and patterns to determine if properties should be acquired.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7243, 'Contract with architectural firms to draw up detailed plans for new structures.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9141.00', 7244, 'Negotiate with government leaders, businesses, special interest representatives, and utility companies to gain support for new projects and to eliminate potential obstacles.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1131, 'Establish and oversee administrative procedures to meet objectives set by boards of directors or senior management.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1129, 'Direct activities of professional and technical staff members and volunteers.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1130, 'Evaluate the work of staff and volunteers to ensure that programs are of appropriate quality and that resources are used effectively.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1132, 'Participate in the determination of organizational policies regarding such issues as participant eligibility, program requirements, and program benefits.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1128, 'Prepare and maintain records and reports, such as budgets, personnel records, or training manuals.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 18463, 'Provide direct service and support to individuals or clients, such as handling a referral for child advocacy issues, conducting a needs evaluation, or resolving complaints.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1127, 'Establish and maintain relationships with other agencies and organizations in community to meet community needs and to ensure that services are not duplicated.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1135, 'Recruit, interview, and hire or sign up volunteers and staff.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1133, 'Research and analyze member or community needs to determine program directions and goals.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 18464, 'Implement and evaluate staff, volunteer, or community training programs.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1139, 'Act as consultants to agency staff and other community programs regarding the interpretation of program-related federal, state, and county regulations and policies.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1134, 'Speak to community groups to explain and interpret agency purposes, programs, and policies.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1138, 'Analyze proposed legislation, regulations, or rule changes to determine how agency services could be impacted.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1137, 'Plan and administer budgets for programs, equipment, and support services.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1136, 'Represent organizations in relations with governmental and media institutions.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9151.00', 1141, 'Direct fundraising activities and the preparation of public relations materials.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7253, 'Keep informed of activities or changes that could affect the likelihood of an emergency, as well as those that could affect response efforts and details of plan implementation.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7260, 'Prepare emergency situation status reports that describe response and recovery efforts, needs, and preliminary damage assessments.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7254, 'Prepare plans that outline operating procedures to be used in response to disasters or emergencies, such as hurricanes, nuclear accidents, and terrorist attacks, and in recovery from these events.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7257, 'Coordinate disaster response or crisis management activities, such as ordering evacuations, opening public shelters, and implementing special needs plans and programs.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7258, 'Develop and maintain liaisons with municipalities, county departments, and similar entities to facilitate plan development, response effort coordination, and exchanges of personnel and equipment.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7272, 'Apply for federal funding for emergency-management-related needs and administer and report on the progress of such grants.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7261, 'Design and administer emergency or disaster preparedness training courses that teach people how to effectively respond to major emergencies and disasters.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7266, 'Collaborate with other officials to prepare and analyze damage assessments following disasters or emergencies.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7263, 'Consult with officials of local and area governments, schools, hospitals, and other institutions to determine their needs and capabilities in the event of a natural disaster or other emergency.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7265, 'Attend meetings, conferences, and workshops related to emergency management to learn new information and to develop working relationships with other emergency management specialists.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7262, 'Inspect facilities and equipment, such as emergency management centers and communications equipment, to determine their operational and functional capabilities in emergency situations.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7255, 'Propose alteration of emergency response procedures based on regulatory changes, technological changes, or knowledge gained from outcomes of previous emergency situations.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7264, 'Develop and perform tests and evaluations of emergency management plans in accordance with state and federal regulations.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7259, 'Keep informed of federal, state, and local regulations affecting emergency plans and ensure that plans adhere to these regulations.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7269, 'Review emergency plans of individual organizations, such as medical facilities, to ensure their adequacy.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7267, 'Develop instructional materials for the public and make presentations to citizens'' groups to provide information on emergency plans and their implementation processes.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7256, 'Maintain and update all resource materials associated with emergency preparedness plans.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7268, 'Train local groups in the preparation of long-term plans that are compatible with federal and state plans.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7275, 'Provide communities with assistance in applying for federal funding for emergency management facilities, radiological instrumentation, and other related items.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7270, 'Conduct surveys to determine the types of emergency-related needs to be addressed in disaster planning or provide technical support to others conducting such surveys.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7271, 'Study emergency plans used elsewhere to gather information for plan development.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7273, 'Develop and implement training procedures and strategies for radiological protection, detection, and decontamination.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9161.00', 7274, 'Inventory and distribute nuclear, biological, and chemical detection and contamination equipment, providing instruction in its maintenance and use.', 'Supplemental', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18035, 'Provide responses to regulatory agencies regarding product information or issues.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18022, 'Direct the preparation and submission of regulatory agency applications, reports, or correspondence.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18037, 'Review all regulatory agency submission materials to ensure timeliness, accuracy, comprehensiveness, or compliance with regulatory standards.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18026, 'Develop regulatory strategies and implementation plans for the preparation and submission of new products.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18031, 'Manage activities such as audits, regulatory agency inspections, or product recalls.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18023, 'Formulate or implement regulatory affairs policies and procedures to ensure that regulatory compliance is maintained or enhanced.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18030, 'Maintain current knowledge of relevant regulations, including proposed and final rules.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18038, 'Review materials such as marketing literature or user manuals to ensure that regulatory agency requirements are met.', 'Core', 27, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18025, 'Communicate regulatory information to multiple departments and ensure that information is interpreted correctly.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18024, 'Provide regulatory guidance to departments or development project teams regarding design, development, evaluation, or marketing of products.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 21087, 'Direct documentation efforts to ensure compliance with domestic and international regulations and standards.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18032, 'Monitor emerging trends regarding industry regulations to determine potential impacts on organizational processes.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18029, 'Investigate product complaints and prepare documentation and submissions to appropriate regulatory agencies as necessary.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18036, 'Represent organizations before domestic or international regulatory agencies on major policy matters or decisions regarding company products.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18039, 'Train staff in regulatory policies or procedures.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18042, 'Develop and maintain standard operating procedures or local working practices.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18034, 'Participate in the development or implementation of clinical trial protocols.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18028, 'Implement or monitor complaint processing systems to ensure effective and timely resolution of all complaint investigations.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18040, 'Contribute to the development or implementation of business unit strategic and operating plans.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18043, 'Establish procedures or systems for publishing document submissions in hardcopy or electronic formats.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18041, 'Coordinate internal discoveries and depositions with legal department staff.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 19529, 'Develop relationships with state or federal environmental regulatory agencies to learn about and analyze the potential impacts of proposed environmental policy regulations.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18027, 'Establish regulatory priorities or budgets and allocate resources and workloads.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 18044, 'Evaluate new software publishing systems and confer with regulatory agencies concerning news or updates on electronic publishing of submissions.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 19531, 'Monitor regulatory affairs activities to ensure their alignment with corporate sustainability or green initiatives.', 'Core', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 19532, 'Monitor regulatory affairs trends related to environmental issues.', 'Supplemental', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.01', 19530, 'Evaluate regulatory affairs aspects that are specifically green, such as the use of toxic substances in packaging, carbon footprinting issues, or green policy implementation.', 'Supplemental', 28, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15645, 'Report violations of compliance or regulatory standards to duly authorized enforcement agencies as appropriate or required.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15650, 'Identify compliance issues that require follow-up or investigation.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21088, 'Discuss emerging compliance issues to ensure that management and employees are informed about compliance reporting systems, policies, and practices.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15653, 'File appropriate compliance reports with regulatory agencies.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15638, 'Maintain documentation of compliance activities, such as complaints received or investigation outcomes.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15639, 'Consult with corporate attorneys as necessary to address difficult legal compliance issues.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15656, 'Conduct or direct the internal investigation of compliance issues.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15644, 'Provide employee training on compliance related topics, policies, or procedures.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15637, 'Serve as a confidential point of contact for employees to communicate with management, seek clarification on issues or dilemmas, or report irregularities.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21089, 'Verify that all regulatory policies and procedures have been documented, implemented, and communicated.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15652, 'Disseminate written policies and procedures related to compliance activities.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15647, 'Prepare management reports regarding compliance operations and progress.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15655, 'Conduct periodic internal reviews or audits to ensure that compliance procedures are followed.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21090, 'Keep informed regarding pending industry changes, trends, or best practices.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15649, 'Monitor compliance systems to ensure their effectiveness.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21091, 'Direct the development or implementation of policies and procedures related to compliance throughout an organization.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15642, 'Advise internal management or business partners on the implementation or operation of compliance programs.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15654, 'Design or implement improvements in communication, monitoring, or enforcement of compliance standards.', 'Core', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15646, 'Provide assistance to internal or external auditors in compliance reviews.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15641, 'Collaborate with human resources departments to ensure the implementation of consistent disciplinary action strategies in cases of compliance standard violations.', 'Core', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21092, 'Develop risk management strategies based on assessment of product, compliance, or operational risks.', 'Supplemental', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19533, 'Advise technical professionals on the development or use of environmental compliance or reporting tools.', 'Supplemental', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19535, 'Develop or implement environmental compliance plans for programs, such as air quality, storm water, wastewater treatment, hazardous waste management, pollution prevention, or solid waste management.', 'Supplemental', 75, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19534, 'Conduct environmental audits to ensure adherence to environmental standards.', 'Supplemental', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19537, 'Evaluate testing procedures to meet the specifications of environmental monitoring programs.', 'Supplemental', 75, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19538, 'Review or modify policies or operating guidelines to comply with changes to environmental standards or regulations.', 'Supplemental', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15643, 'Review communications such as securities sales advertising to ensure there are no violations of standards or regulations.', 'Supplemental', 77, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 21093, 'Oversee internal reporting systems, such as corporate compliance hotlines.', 'Supplemental', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 15636, 'Verify that software technology is in place to adequately provide oversight and monitoring in all required areas.', 'Supplemental', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.02', 19536, 'Direct environmental programs, such as air or water compliance, aboveground or underground storage tanks, spill prevention or control, hazardous waste or materials management, solid waste recycling, medical waste management, indoor air quality, integrated pest management, employee training, or disaster preparedness.', 'Supplemental', 76, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15678, 'Manage investment funds to maximize return on client investments.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15679, 'Select specific investments or investment mixes for purchase by an investment fund.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15669, 'Monitor financial or operational performance of individual investments to ensure portfolios meet risk goals.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15676, 'Select or direct the execution of trades.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15675, 'Develop or implement fund investment policies or strategies.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15667, 'Perform or evaluate research, such as detailed company or industry analyses, to inform financial forecasting, decision making, or valuation.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15668, 'Present investment information, such as product risks, fees, or fund performance statistics.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15664, 'Develop, implement, or monitor security valuation policies.', 'Core', 80, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15671, 'Meet with investors to determine investment goals or to discuss investment strategies.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15665, 'Attend investment briefings or consult financial media to stay abreast of relevant investment markets.', 'Core', 80, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15660, 'Prepare for and respond to regulatory inquiries.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15674, 'Evaluate the potential of new product developments or market opportunities, according to factors such as business plans, technologies, or market potential.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15662, 'Hire or evaluate staff.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15670, 'Monitor regulatory or tax law changes to ensure fund compliance or to capitalize on development opportunities.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15673, 'Develop or direct development of offering documents or marketing materials.', 'Core', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15677, 'Analyze acquisitions to ensure conformance with strategic goals or regulatory requirements.', 'Supplemental', 79, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15661, 'Verify regulatory compliance of transaction reporting.', 'Supplemental', 79, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15666, 'Review offering documents or marketing materials to ensure regulatory compliance.', 'Supplemental', 80, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15672, 'Identify group or individual target investors for a specific fund.', 'Supplemental', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.03', 15663, 'Direct activities of accounting or operations departments.', 'Supplemental', 81, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20942, 'Determine appropriate equipment and staffing levels to load, unload, move, or store materials.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20943, 'Manage activities related to strategic or tactical purchasing, material requirements planning, controlling inventory, warehousing, or receiving.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15680, 'Select transportation routes to maximize economy by combining shipments or consolidating warehousing and distribution.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15695, 'Define performance metrics for measurement, comparison, or evaluation of supply chain factors, such as product cost or quality.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20944, 'Implement new or improved supply chain processes to improve efficiency or performance.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15700, 'Develop procedures for coordination of supply chain management with other functional areas, such as sales, marketing, finance, production, or quality assurance.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15694, 'Confer with supply chain planners to forecast demand or create supply plans that ensure availability of materials or products.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15696, 'Analyze inventories to determine how to increase inventory turns, reduce waste, or optimize customer service.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15685, 'Negotiate prices and terms with suppliers, vendors, or freight forwarders.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15697, 'Analyze information about supplier performance or procurement program success.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20945, 'Monitor suppliers'' activities to assess performance in meeting quality or delivery requirements.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15701, 'Design or implement supply chains that support business strategies adapted to changing market conditions, new business opportunities, or cost reduction strategies.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15688, 'Meet with suppliers to discuss performance metrics, to provide performance feedback, or to discuss production forecasts or changes.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20946, 'Monitor forecasts and quotas to identify changes and predict effects on supply chain activities.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15698, 'Participate in the coordination of engineering changes, product line extensions, or new product launches to ensure orderly and timely transitions in material or production flow.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20947, 'Identify or qualify new suppliers in collaboration with other departments, such as procurement, engineering, or quality assurance.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15693, 'Design or implement plant warehousing strategies for production materials or finished products.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19541, 'Design, implement, or oversee product take back or reverse logistics programs to ensure products are recycled, reused, or responsibly disposed.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15692, 'Develop or implement procedures or systems to evaluate or select suppliers.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15691, 'Document physical supply chain processes, such as workflows, cycle times, position responsibilities, or system flows.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 15681, 'Diagram supply chain models to help facilitate discussions with customers.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19542, 'Evaluate and select information or other technology solutions to improve tracking and reporting of materials or products distribution, storage, or inventory.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19543, 'Identify opportunities to reuse or recycle materials to minimize consumption of new materials, minimize waste, or to convert wastes to by-products.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19546, 'Review or update supply chain practices in accordance with new or changing environmental policies, standards, regulations, or laws.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19540, 'Design or implement supply chains that support environmental policies.', 'Core', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20948, 'Forecast material costs or develop standard cost lists.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19545, 'Locate or select biodegradable, non-toxic, or other environmentally friendly raw materials for manufacturing processes.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 20949, 'Appraise vendor manufacturing capabilities through on-site observations or other measurements.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19539, 'Conduct or oversee the conduct of life cycle analyses to determine the environmental impacts of products, processes, or systems.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.04', 19544, 'Investigate or review the carbon footprints and environmental performance records of current or potential storage and distribution service providers.', 'Supplemental', 21, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15780, 'Create or implement security standards, policies, and procedures.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15771, 'Identify, investigate, or resolve security breaches.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15768, 'Respond to medical emergencies, bomb threats, fire alarms, or intrusion alarms, following emergency response procedures.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20341, 'Monitor and ensure a sound, ethical environment.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15779, 'Plan, direct, or coordinate security activities to safeguard company assets, employees, guests, or others on company property.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20342, 'Develop, implement, manage, or evaluate policies and methods to protect personnel against harassment, threats, or violence.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20343, 'Develop, conduct, support, or assist in governmental reviews, internal corporate evaluations, or assessments of the overall effectiveness of facility and personnel security processes.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15759, 'Train subordinate security professionals or other organization members in security rules and procedures.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20344, 'Assess risks to mitigate potential consequences of incidents and develop a plan to respond to incidents.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15775, 'Communicate security status, updates, and actual or potential problems, using established protocols.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20345, 'Direct or participate in emergency management and contingency planning.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20346, 'Conduct threat or vulnerability analyses to determine probable frequency, criticality, consequence, or severity of natural or man-made disasters or criminal activity on the organization''s profitability or delivery of products or services.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20347, 'Supervise or provide leadership to subordinate security professionals, performing activities such as hiring, investigating applicants'' backgrounds, training, assigning work, evaluating performance, or disciplining.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15762, 'Develop budgets for security operations.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15758, 'Write or review security-related documents, such as incident reports, proposals, and tactical or strategic initiatives.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20348, 'Analyze and evaluate security operations to identify risks or opportunities for improvement through auditing, review, or assessment.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20349, 'Develop or manage integrated security controls to ensure confidentiality, accountability, recoverability, or auditability of sensitive or proprietary information or information technology resources.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15772, 'Monitor security policies, programs or procedures to ensure compliance with internal security policies, licensing requirements, or applicable government security requirements, policies, and directives.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15774, 'Conduct physical examinations of property to ensure compliance with security policies and regulations.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15776, 'Collect and analyze security data to determine security needs, security program goals, or program accomplishments.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15764, 'Coordinate security operations or activities with public law enforcement, fire and other agencies.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15761, 'Review financial reports to ensure efficiency and quality of security operations.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20350, 'Purchase security-related supplies, equipment, or technology.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20351, 'Develop or manage investigation programs, including collection and preservation of video and notes of surveillance processes or investigative interviews.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20352, 'Develop, arrange for, perform, or assess executive protection activities to reduce security risks.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15760, 'Plan security for special and high-risk events.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20353, 'Support efforts to reduce substance abuse or other illegal activities in the workplace.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 20354, 'Develop, recommend, or manage security procedures for operations or processes, such as security call centers, system acquisition, development, and maintenance, access control, program models, or reporting tools.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15770, 'Prepare reports or make presentations on internal investigations, losses, or violations of regulations, policies and procedures.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.07', 15765, 'Attend meetings, professional seminars, or conferences to keep abreast of changes in executive legislative directives or new technologies impacting security operations.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15800, 'Coordinate or conduct internal investigations of problems such as employee theft and violations of corporate loss prevention policies.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15807, 'Administer systems and programs to reduce loss, maintain inventory control, or increase safety.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15781, 'Review loss prevention exception reports and cash discrepancies to ensure adherence to guidelines.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15791, 'Train loss prevention staff, retail managers, or store employees on loss control and prevention measures.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15786, 'Investigate or interview individuals suspected of shoplifting or internal theft.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15783, 'Provide recommendations and solutions in crisis situations such as workplace violence, protests, and demonstrations.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15806, 'Identify potential for loss and develop strategies to eliminate it.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15795, 'Hire or supervise loss prevention staff.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15804, 'Advise retail managers on compliance with applicable codes, laws, regulations, or standards.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15799, 'Develop and maintain partnerships with federal, state, or local law enforcement agencies or members of the retail loss prevention community.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15794, 'Perform or direct inventory investigations in response to shrink results outside of acceptable ranges.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15796, 'Maintain documentation of all loss prevention activity.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15802, 'Assess security needs across locations to ensure proper deployment of loss prevention resources, such as staff and technology.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15805, 'Monitor compliance to operational, safety, or inventory control procedures, including physical security standards.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15790, 'Verify correct use and maintenance of physical security systems, such as closed-circuit television, merchandise tags, and burglar alarms.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15789, 'Visit stores to ensure compliance with company policies and procedures.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15803, 'Analyze retail data to identify current or emerging trends in theft or fraud.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15798, 'Direct loss prevention audit programs including target store audits, maintenance audits, safety audits, or electronic article surveillance (EAS) audits.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15801, 'Collaborate with law enforcement to investigate and solve external theft or fraud cases.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15797, 'Coordinate theft and fraud investigations involving career criminals or organized group activities.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15792, 'Supervise surveillance, detection, or criminal processing related to theft and criminal cases.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15782, 'Perform cash audits and deposit investigations to fully account for store cash.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15793, 'Recommend improvements in loss prevention programs, staffing, scheduling, or training.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15787, 'Direct installation of covert surveillance equipment, such as security cameras.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15784, 'Monitor and review paperwork procedures and systems to prevent error-related shortages.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15788, 'Advise retail establishments on development of loss-investigation procedures.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.08', 15785, 'Maintain databases such as bad check logs, reports on multiple offenders, and alarm activation lists.', 'Supplemental', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15809, 'Track and maintain records for wind operations, such as site performance, downtime events, parts usage, or substation events.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15823, 'Oversee the maintenance of wind field equipment or structures, such as towers, transformers, electrical collector systems, roadways, or other site assets.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15822, 'Supervise employees or subcontractors to ensure quality of work or adherence to safety regulations or policies.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15819, 'Develop relationships and communicate with customers, site managers, developers, land owners, authorities, utility representatives, or residents.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15813, 'Maintain operations records, such as work orders, site inspection forms, or other documentation.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15818, 'Establish goals, objectives, or priorities for wind field operations.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15816, 'Monitor and maintain records of daily facility operations.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15821, 'Prepare wind field operational budgets.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15808, 'Train or coordinate the training of employees in operations, safety, environmental issues, or technical issues.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15817, 'Estimate costs associated with operations, including repairs or preventive maintenance.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15814, 'Review, negotiate, or approve wind farm contracts.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15811, 'Manage warranty repair or replacement services.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15815, 'Recruit or select wind operations employees, contractors, or subcontractors.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15812, 'Order parts, tools, or equipment needed to maintain, restore, or improve wind field operations.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15820, 'Develop processes or procedures for wind operations, including transitioning from construction to commercial operations.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.09', 15810, 'Provide technical support to wind field customers, employees, or subcontractors.', 'Core', 85, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15836, 'Coordinate or direct development, energy assessment, engineering, or construction activities to ensure that wind project needs and objectives are met.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15834, 'Manage wind project costs to stay within budget limits.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15827, 'Lead or support negotiations involving tax agreements or abatements, power purchase agreements, land use, or interconnection agreements.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15838, 'Create wind energy project plans, including project scope, goals, tasks, resources, schedules, costs, contingencies, or other project information.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15824, 'Supervise the work of subcontractors or consultants to ensure quality and conformance to specifications or budgets.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15835, 'Develop scope of work for wind project functions, such as design, site assessment, environmental studies, surveying, or field support services.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15830, 'Provide verbal or written project status reports to project teams, management, subcontractors, customers, or owners.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15828, 'Update schedules, estimates, forecasts, or budgets for wind projects.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15837, 'Prepare or assist in the preparation of applications for environmental, building, or other required permits.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15829, 'Review or evaluate proposals or bids to make recommendations regarding awarding of contracts.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15826, 'Manage site assessments or environmental studies for wind fields.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15833, 'Prepare wind project documentation, including diagrams or layouts.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15831, 'Review civil design, engineering, or construction technical documentation to ensure compliance with applicable government or industrial codes, standards, requirements, or regulations.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15825, 'Prepare requests for proposals (RFPs) for wind project construction or equipment acquisition.', 'Core', 53, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.10', 15832, 'Provide technical support for the design, construction, or commissioning of wind farm projects.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15857, 'Coordinate on-site activities for environmental cleanup or remediation projects to ensure compliance with environmental laws, standards, regulations, or other requirements.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15850, 'Estimate costs for environmental cleanup and remediation of land redevelopment projects.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15847, 'Inspect sites to assess environmental damage or monitor cleanup progress.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15843, 'Prepare reports or presentations to communicate brownfield redevelopment needs, status, or progress.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15849, 'Identify environmental contamination sources.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15848, 'Plan or implement brownfield redevelopment projects to ensure safety, quality, and compliance with applicable standards or requirements.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15839, 'Review or evaluate environmental remediation project proposals.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15844, 'Negotiate contracts for services or materials needed for environmental remediation.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15859, 'Conduct feasibility or cost-benefit studies for environmental remediation projects.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15846, 'Maintain records of decisions, actions, and progress related to environmental redevelopment projects.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15852, 'Design or implement plans for surface or ground water remediation.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15855, 'Design or conduct environmental restoration studies.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15856, 'Coordinate the disposal of hazardous waste.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15845, 'Prepare and submit permit applications for demolition, cleanup, remediation, or construction projects.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15860, 'Develop or implement plans for the sustainable regeneration of brownfield sites to ensure regeneration of a wider area by providing environmental protection or economic and social benefits.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15858, 'Conduct quantitative risk assessments for human health, environmental, or other risks.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15840, 'Review or evaluate designs for contaminant treatment or disposal facilities.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15854, 'Design or implement measures to improve the water, air, and soil quality of military test sites, abandoned mine land, or other contaminated sites.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15853, 'Design or implement plans for structural demolition and debris removal.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15841, 'Provide training on hazardous material or waste cleanup procedures and technologies.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15851, 'Develop or implement plans for revegetation of brownfield sites.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('11-9199.11', 15842, 'Provide expert witness testimony on issues such as soil, air, or water contamination and associated cleanup measures.', 'Supplemental', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12865, 'Collect fees, commissions, or other payments, according to contract terms.', 'Core', 135, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12866, 'Confer with clients to develop strategies for their careers, and to explain actions taken on their behalf.', 'Core', 134, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12867, 'Develop contacts with individuals and organizations, and apply effective strategies and techniques to ensure their clients'' success.', 'Core', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12868, 'Schedule promotional or performance engagements for clients.', 'Core', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12869, 'Negotiate with managers, promoters, union officials, and other persons regarding clients'' contractual rights and obligations.', 'Core', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12870, 'Keep informed of industry trends and deals.', 'Core', 134, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12871, 'Manage business and financial affairs for clients, such as arranging travel and lodging, selling tickets, and directing marketing and advertising activities.', 'Core', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12872, 'Conduct auditions or interviews to evaluate potential clients.', 'Core', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12873, 'Arrange meetings concerning issues involving their clients.', 'Core', 134, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12874, 'Prepare periodic accounting statements for clients.', 'Supplemental', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12875, 'Advise clients on financial and legal matters such as investments and taxes.', 'Supplemental', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12876, 'Obtain information about or inspect performance facilities, equipment, and accommodations to ensure that they meet specifications.', 'Supplemental', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1011.00', 12877, 'Hire trainers or coaches to advise clients on performance matters such as training techniques or performance presentations.', 'Supplemental', 133, TO_DATE('2007-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12878, 'Purchase, for further processing or for resale, farm products, such as milk, grains, or Christmas trees.', 'Core', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12880, 'Arrange for processing or resale of purchased products.', 'Core', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12879, 'Negotiate contracts with farmers for the production or purchase of farm products.', 'Core', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12881, 'Arrange for transportation or storage of purchased products.', 'Core', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12883, 'Maintain records of business transactions and product inventories, reporting data to companies or government agencies as necessary.', 'Core', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12882, 'Review orders to determine product types and quantities required to meet demand.', 'Core', 70, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12884, 'Examine or test crops or products to estimate their value, determine their grade, or locate any evidence of disease or insect damage.', 'Supplemental', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12885, 'Coordinate or direct activities of workers engaged in cutting, transporting, storing, or milling products and maintaining records.', 'Supplemental', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12887, 'Sell supplies, such as seed, feed, fertilizers, or insecticides, arranging for loans or financing as necessary.', 'Supplemental', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12889, 'Advise farm groups or growers on land preparation or livestock care techniques that will maximize the quantity and quality of production.', 'Supplemental', 70, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12886, 'Calculate applicable government grain quotas.', 'Supplemental', 71, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1021.00', 12888, 'Estimate land production possibilities, surveying property and studying factors such as crop rotation history, soil fertility, or irrigation facilities.', 'Supplemental', 70, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20710, 'Buy merchandise or commodities for resale to wholesale or retail consumers.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20711, 'Negotiate prices, discount terms, or transportation arrangements with suppliers.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20712, 'Examine, select, order, or purchase merchandise consistent with quality, quantity, specification requirements, or other factors, such as environmental soundness.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20713, 'Recommend mark-up rates, markdown rates, or merchandise selling prices.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20714, 'Obtain information about customer needs or preferences by conferring with sales or purchasing personnel.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 68, 'Authorize payment of invoices or return of merchandise.', 'Core', 82, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 66, 'Monitor and analyze sales records, trends, or economic conditions to anticipate consumer buying patterns and determine what the company will sell and how much inventory is needed.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20715, 'Collaborate with vendors to obtain or develop desired products.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20716, 'Inspect merchandise or products to determine quality, value, or yield.', 'Core', 82, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 20717, 'Conduct sales meetings to introduce new merchandise.', 'Core', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 72, 'Consult with store or merchandise managers about budgets or goods to be purchased.', 'Supplemental', 82, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 77, 'Provide clerks with information to print on price tags, such as price, mark-ups or mark-downs, manufacturer number, season code, or style number.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 76, 'Train or supervise sales or clerical staff.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 78, 'Determine which products should be featured in advertising, the advertising medium to be used, or when the ads should be run.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 79, 'Monitor competitors'' sales activities by following their advertisements in newspapers or other media.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 19547, 'Analyze environmental aspects of competing merchandise when making buying decisions.', 'Supplemental', 82, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 19548, 'Compare transportation options to determine the most energy efficient options.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 19549, 'Develop strategies to advertise green products or merchandise to consumers.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 19550, 'Identify opportunities to buy green commodities, such as alternative energy, water, or carbon-neutral products for resale to consumers.', 'Supplemental', 82, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1022.00', 19551, 'Monitor consumer preferences or environmental trends to determine the best way to introduce new green products.', 'Supplemental', 81, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1146, 'Monitor and follow applicable laws and regulations.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1143, 'Prepare purchase orders, solicit bid proposals, and review requisitions for goods and services.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1147, 'Negotiate, renegotiate, and administer contracts with suppliers, vendors, and other representatives.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1142, 'Purchase the highest quality merchandise at the lowest possible price and in correct amounts.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1145, 'Analyze price proposals, financial reports, and other data and information to determine reasonable prices.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1159, 'Formulate policies and procedures for bid proposals and procurement of goods and services.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1156, 'Hire, train, or supervise purchasing clerks, buyers, and expediters.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1151, 'Maintain and review computerized or manual records of purchased items, costs, deliveries, product performance, and inventories.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1144, 'Research and evaluate suppliers, based on price, quality, selection, service, support, availability, reliability, production and distribution capabilities, and the supplier''s reputation and history.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1149, 'Confer with staff, users, and vendors to discuss defective or unacceptable goods or services and determine corrective action.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1150, 'Evaluate and monitor contract performance to ensure compliance with contractual obligations and to determine need for changes.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1148, 'Monitor shipments to ensure that goods come in on time, and resolve problems related to undelivered goods.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1153, 'Study sales records and inventory levels of current stock to develop strategic purchasing programs that facilitate employee access to supplies.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1157, 'Write and review product specifications, maintaining a working technical knowledge of the goods or services to be purchased.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1152, 'Review catalogs, industry periodicals, directories, trade journals, and Internet sites and consult with other department personnel to locate necessary goods and services.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1158, 'Monitor changes affecting supply and demand, tracking market conditions, price trends, or futures markets.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1154, 'Interview vendors and visit suppliers'' plants and distribution centers to examine and learn about products, services, and prices.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1155, 'Arrange the payment of duty and freight charges.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1023.00', 1160, 'Attend meetings, trade shows, conferences, conventions, and seminars to network with people in other purchasing departments.', 'Core', 23, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5272, 'Investigate, evaluate, and settle claims, applying technical knowledge and human relations skills to effect fair and prompt disposal of cases and to contribute to a reduced loss ratio.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5274, 'Adjust reserves or provide reserve recommendations to ensure that reserve activities are consistent with corporate policies.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5276, 'Resolve complex, severe exposure claims, using high service oriented file handling.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5273, 'Pay and process claims within designated authority level.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5279, 'Examine claims investigated by insurance adjusters, further investigating questionable claims to determine whether to authorize payments.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5278, 'Verify and analyze data used in settling claims to ensure that claims are valid and that settlements are made according to company practices and procedures.', 'Core', 63, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5275, 'Enter claim payments, reserves and new claims on computer system, inputting concise yet sufficient file documentation.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5282, 'Confer with legal counsel on claims requiring litigation.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5281, 'Contact or interview claimants, doctors, medical specialists, or employers to get additional information.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5277, 'Maintain claim files, such as records of settled claims and an inventory of claims requiring detailed analysis.', 'Core', 62, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5280, 'Present cases and participate in their discussion at claim committee meetings.', 'Core', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5285, 'Supervise claims adjusters to ensure that adjusters have followed proper methods.', 'Supplemental', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5286, 'Conduct detailed bill reviews to implement sound litigation management and expense control.', 'Supplemental', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5283, 'Report overpayments, underpayments, and other irregularities.', 'Supplemental', 62, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5284, 'Communicate with reinsurance brokers to obtain information necessary for processing claims.', 'Supplemental', 63, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.01', 5287, 'Prepare reports to be submitted to company''s data processing department.', 'Supplemental', 64, TO_DATE('2010-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1163, 'Examine claims forms and other records to determine insurance coverage.', 'Core', 81, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1164, 'Analyze information gathered by investigation and report findings and recommendations.', 'Core', 81, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 18467, 'Review police reports, medical treatment records, medical bills, or physical property damage to determine the extent of liability.', 'Core', 81, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 18465, 'Investigate and assess damage to property and create or review property damage estimates.', 'Core', 80, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1168, 'Interview or correspond with agents and claimants to correct errors or omissions and to investigate questionable claims.', 'Core', 81, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 18466, 'Interview or correspond with claimants, witnesses, police, physicians, or other relevant parties to determine claim settlement, denial, or review.', 'Core', 79, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1165, 'Negotiate claim settlements and recommend litigation when settlement cannot be negotiated.', 'Core', 80, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1166, 'Prepare report of findings of investigation.', 'Core', 78, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1169, 'Refer questionable claims to investigator or claims adjuster for investigation or settlement.', 'Core', 80, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1167, 'Collect evidence to support contested claims in court.', 'Core', 78, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1170, 'Examine titles to property to determine validity and act as company agent in transactions with property owners.', 'Supplemental', 78, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1172, 'Communicate with former associates to verify employment record and to obtain background information regarding persons or businesses applying for credit.', 'Supplemental', 80, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1031.02', 1171, 'Obtain credit information from banks and other credit services.', 'Supplemental', 81, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7249, 'Evaluate practicality of repair as opposed to payment of market value of vehicle before accident.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7247, 'Review repair cost estimates with automobile repair shop to secure agreement on cost of repairs.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7248, 'Examine damaged vehicle to determine extent of structural, body, mechanical, electrical, or interior damage.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7251, 'Prepare insurance forms to indicate repair cost estimates and recommendations.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7246, 'Estimate parts and labor to repair damage, using standard automotive labor and parts cost manuals and knowledge of automotive repair.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7250, 'Determine salvage value on total-loss vehicle.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1032.00', 7252, 'Arrange to have damage appraised by another appraiser to resolve disagreement with shop on repair cost.', 'Core', 57, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10830, 'Examine permits, licenses, applications, and records to ensure compliance with licensing requirements.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10833, 'Prepare written, oral, tabular, and graphic reports summarizing requirements and regulations, including enforcement and chain of custody documentation.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10829, 'Determine the nature of code violations and actions to be taken, and issue written notices of violation; participate in enforcement hearings as necessary.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10831, 'Prepare, organize, and maintain inspection records.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10839, 'Verify that hazardous chemicals are handled, stored, and disposed of in accordance with regulations.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10832, 'Interview individuals to determine the nature of suspected violations and to obtain evidence of violations.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10840, 'Research and keep informed of pertinent information and developments in areas such as EPA laws and regulations.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10843, 'Learn and observe proper safety precautions, rules, regulations, and practices so that unsafe conditions can be recognized and proper safety protocols implemented.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10834, 'Monitor follow-up actions in cases where violations were found, and review compliance monitoring reports.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10836, 'Inspect waste pretreatment, treatment, and disposal facilities and systems for conformance to federal, state, or local regulations.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10835, 'Investigate complaints and suspected violations regarding illegal dumping, pollution, pesticides, product quality, or labeling laws.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10844, 'Evaluate label information for accuracy and conformance to regulatory requirements.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10838, 'Determine sampling locations and methods, and collect water or wastewater samples for analysis, preserving samples with appropriate containers and preservation methods.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10837, 'Inform individuals and groups of pollution control regulations and inspection findings, and explain how problems can be corrected.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10848, 'Review and evaluate applications for registration of products containing dangerous materials, or for pollution control discharge permits.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10842, 'Observe and record field conditions, gathering, interpreting, and reporting data such as flow meter readings and chemical levels.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10841, 'Determine which sites and violation reports to investigate, and coordinate compliance and enforcement activities with other government agencies.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10845, 'Inform health professionals, property owners, and the public about harmful properties and related problems of water pollution and contaminated wastewater.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10850, 'Participate in the development of spill prevention programs and hazardous waste rules and regulations, and recommend corrective actions for hazardous waste problems.', 'Core', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10846, 'Analyze and implement state, federal or local requirements as necessary to maintain approved pretreatment, pollution prevention, and storm water runoff programs.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 20473, 'Prepare data to calculate sewer service charges and capacity fees.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10847, 'Perform laboratory tests on samples collected, such as analyzing the content of contaminated wastewater.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10851, 'Maintain and repair materials, worksites, and equipment.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10849, 'Research and perform calculations related to landscape allowances, discharge volumes, production-based and alternative limits, and wastewater strength classifications, then make recommendations and complete documentation.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10852, 'Conduct research on hazardous waste management projects in order to determine the magnitude of problems, and treatment or disposal alternatives and costs.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.01', 10853, 'Respond to questions and inquiries, such as those concerning service charges and capacity fees, or refer them to supervisors.', 'Supplemental', 21, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10859, 'Warn violators of infractions or penalties.', 'Core', 76, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10855, 'Evaluate applications, records, or documents to gather information about eligibility or liability issues.', 'Core', 78, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10858, 'Advise licensees or other individuals or groups concerning licensing, permit, or passport regulations.', 'Core', 78, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10860, 'Prepare reports of activities, evaluations, recommendations, or decisions.', 'Core', 77, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10863, 'Report law or regulation violations to appropriate boards or agencies.', 'Core', 78, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10862, 'Confer with or interview officials, technical or professional specialists, or applicants to obtain information or to clarify facts relevant to licensing decisions.', 'Core', 77, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10854, 'Issue licenses to individuals meeting standards.', 'Supplemental', 79, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 20718, 'Collect fees for licenses.', 'Supplemental', 79, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10856, 'Administer oral, written, road, or flight tests to license applicants.', 'Supplemental', 79, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10864, 'Visit establishments to verify that valid licenses or permits are displayed and that licensing standards are being upheld.', 'Supplemental', 78, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10857, 'Score tests and observe equipment operation and control to rate ability of applicants.', 'Supplemental', 79, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.02', 10861, 'Prepare correspondence to inform concerned parties of licensing decisions or appeals processes.', 'Supplemental', 76, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10865, 'Investigate employment practices or alleged violations of laws to document and correct discriminatory factors.', 'Core', 107, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 20719, 'Prepare reports related to investigations of equal opportunity complaints.', 'Core', 106, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 20720, 'Interview persons involved in equal opportunity complaints to verify case information.', 'Core', 108, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10867, 'Study equal opportunity complaints to clarify issues.', 'Core', 107, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10866, 'Interpret civil rights laws and equal opportunity regulations for individuals or employers.', 'Core', 109, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 20721, 'Meet with persons involved in equal opportunity complaints to arbitrate and settle disputes.', 'Core', 107, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 20722, 'Develop guidelines for nondiscriminatory employment practices.', 'Core', 107, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 20723, 'Monitor the implementation and impact of guidelines for nondiscriminatory employment practices.', 'Core', 106, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10869, 'Coordinate, monitor, or revise complaint procedures to ensure timely processing and review of complaints.', 'Core', 105, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10875, 'Provide information, technical assistance, or training to supervisors, managers, or employees on topics such as employee supervision, hiring, grievance procedures, or staff development.', 'Core', 104, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10871, 'Conduct surveys and evaluate findings to determine if systematic discrimination exists.', 'Core', 108, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10870, 'Prepare reports of selection, survey, or other statistics and recommendations for corrective action.', 'Supplemental', 105, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10879, 'Meet with job search committees or coordinators to explain the role of the equal opportunity coordinator, to provide resources for advertising, or to explain expectations for future contacts.', 'Supplemental', 106, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10877, 'Act as liaisons between minority placement agencies and employers or between job search committees and other equal opportunity administrators.', 'Supplemental', 106, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10874, 'Counsel newly hired members of minority or disadvantaged groups, informing them about details of civil rights laws.', 'Supplemental', 109, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10873, 'Review company contracts to determine actions required to meet governmental equal opportunity provisions.', 'Supplemental', 108, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10876, 'Verify that all job descriptions are submitted for review and approval and that descriptions meet regulatory standards.', 'Supplemental', 105, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10878, 'Consult with community representatives to develop technical assistance agreements in accordance with governmental regulations.', 'Supplemental', 107, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.03', 10880, 'Participate in the recruitment of employees through job fairs, career days, or advertising plans.', 'Supplemental', 106, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12890, 'Prepare correspondence, reports of inspections or investigations or recommendations for action.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12891, 'Examine records, reports, or other documents to establish facts or detect discrepancies.', 'Core', 51, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 20843, 'Inspect government property, such as construction sites or public housing, to ensure compliance with contract specifications or legal requirements.', 'Core', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 20844, 'Investigate alleged license or permit violations.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12894, 'Inspect manufactured or processed products to ensure compliance with contract specifications or legal requirements.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12893, 'Collect, identify, evaluate, or preserve case evidence.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12900, 'Submit samples of products to government laboratories for testing, as required.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12898, 'Inspect government-owned equipment or materials in the possession of private contractors to ensure compliance with contracts or regulations or to prevent misuse.', 'Supplemental', 51, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 20845, 'Investigate applications for special licenses or permits.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12899, 'Recommend legal or administrative action to protect government property.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12896, 'Testify in court or at administrative proceedings concerning investigation findings.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12895, 'Coordinate with or assist law enforcement agencies in matters of mutual concern.', 'Supplemental', 52, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12892, 'Monitor investigations of suspected offenders to ensure that they are conducted in accordance with constitutional requirements.', 'Supplemental', 51, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.04', 12901, 'Locate and interview plaintiffs, witnesses, or representatives of business or government to gather facts relevant to inspections or alleged violations.', 'Supplemental', 51, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8912, 'Perform medicolegal examinations and autopsies, conducting preliminary examinations of the body to identify victims, locate signs of trauma, and identify factors that would indicate time of death.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8913, 'Inquire into the cause, manner, and circumstances of human deaths and establish the identities of deceased persons.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8915, 'Complete death certificates, including the assignment of cause and manner of death.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8916, 'Observe and record the positions and conditions of bodies and related evidence.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8918, 'Observe, record, and preserve any objects or personal property related to deaths, including objects such as medication containers and suicide notes.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8921, 'Interview persons present at death scenes to obtain information useful in determining the manner of death.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8928, 'Arrange for the next of kin to be notified of deaths.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8919, 'Complete reports and forms required to finalize cases.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8917, 'Collect and document any pertinent medical history information.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 20181, 'Direct activities of workers conducting autopsies, performing pathological and toxicological analyses, and preparing documents for permanent records.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8925, 'Confer with officials of public health and law enforcement agencies to coordinate interdepartmental activities.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8923, 'Provide information concerning the circumstances of death to relatives of the deceased.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8924, 'Locate and document information regarding the next of kin, including their relationship to the deceased and the status of notification attempts.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8926, 'Inventory personal effects recovered from bodies, such as jewelry or wallets.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8927, 'Coordinate the release of personal effects to authorized persons and facilitate the disposition of unclaimed corpses and personal effects.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8920, 'Remove or supervise removal of bodies from death scenes, using the proper equipment and supplies, and arrange for transportation to morgues.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8922, 'Testify at inquests, hearings, and court trials.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8930, 'Collect wills, burial instructions, and other documentation needed for investigations and for handling of the remains.', 'Core', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8929, 'Record the disposition of minor children, as well as details of arrangements made for their care.', 'Supplemental', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.06', 8931, 'Witness and certify deaths that are the result of a judicial order.', 'Supplemental', 31, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18054, 'Coordinate efforts associated with the preparation of regulatory documents or submissions.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18045, 'Communicate with regulatory agencies regarding pre-submission strategies, potential regulatory pathways, compliance test requirements, or clarification and follow-up of submissions under review.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18061, 'Prepare or direct the preparation of additional information or responses as requested by regulatory agencies.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18048, 'Coordinate, prepare, or review regulatory submissions for domestic or international projects.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18062, 'Prepare or maintain technical files as necessary to obtain and sustain product approval.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18049, 'Interpret regulatory rules or rule changes and ensure that they are communicated through corporate policies and procedures.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18055, 'Determine the types of regulatory submissions or internal documentation that are required in situations such as proposed device changes or labeling changes.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18067, 'Coordinate recall or market withdrawal activities as necessary.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18052, 'Advise project teams on subjects such as premarket regulatory requirements, export and labeling requirements, or clinical study compliance issues.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18070, 'Review adverse drug reactions and file all related reports in accordance with regulatory agency guidelines.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18051, 'Review product promotional materials, labeling, batch records, specification sheets, or test methods for compliance with applicable regulations and policies.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 21094, 'Identify relevant guidance documents, international standards, or consensus standards.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18050, 'Provide technical review of data or reports to be incorporated into regulatory submissions to assure scientific rigor, accuracy, and clarity of presentation.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18065, 'Review clinical protocols to ensure collection of data needed for regulatory submissions.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 21095, 'Provide pre-, ongoing, and post-inspection follow-up assistance to governmental inspectors.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18058, 'Maintain current knowledge base of existing and emerging regulations, standards, or guidance documents.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18063, 'Recommend changes to company procedures in response to changes in regulations or standards.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18060, 'Participate in internal or external audits.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18053, 'Compile and maintain regulatory documentation databases or systems.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18066, 'Write or update standard operating procedures, work instructions, or policies.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18059, 'Obtain and distribute updated information regarding domestic or international laws, guidelines, or standards.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18068, 'Develop or track quality metrics.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18056, 'Develop or conduct employee regulatory training.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 21096, 'Recommend adjudication of product complaints.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19553, 'Determine requirements applying to treatment, storage, shipment, or disposal of potentially hazardous production-related waste.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18069, 'Direct the collection and preparation of laboratory samples as requested by regulatory agencies.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 18064, 'Prepare responses to customer requests for information, such as product data, written regulatory affairs statements, surveys, or questionnaires.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19557, 'Specialize in regulatory issues related to agriculture, such as the cultivation of green biotechnology crops or the post-market regulation of genetically altered crops.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19552, 'Determine regulations or procedures related to the management, collection, reuse, recovery, or recycling of packaging waste.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19554, 'Determine the legal implications of the production, supply, or use of ozone-depleting substances or equipment containing such substances.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19556, 'Obtain clearances for the use of recycled plastics in product packaging.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1041.07', 19555, 'Monitor national or international legislation on ozone-depleting substances or global warming.', 'Supplemental', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 20846, 'Collect historical cost data to estimate costs for current or future products.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 82, 'Consult with clients, vendors, personnel in other departments, or construction foremen to discuss and formulate estimates and resolve issues.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 84, 'Prepare estimates used by management for purposes such as planning, organizing, and scheduling work.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 80, 'Analyze blueprints and other documentation to prepare time, cost, materials, and labor estimates.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 83, 'Confer with engineers, architects, owners, contractors, and subcontractors on changes and adjustments to cost estimates.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 81, 'Assess cost effectiveness of products, projects or services, tracking actual costs relative to bids as the project develops.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 85, 'Prepare estimates for use in selecting vendors or subcontractors.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 89, 'Set up cost monitoring and reporting systems and procedures.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 90, 'Establish and maintain tendering process, and conduct negotiations.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 88, 'Prepare and maintain a directory of suppliers, contractors and subcontractors.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 86, 'Review material and labor requirements to decide whether it is more cost-effective to produce or purchase components.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 91, 'Conduct special studies to develop and establish standard hour and related cost data or to effect cost reduction.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 87, 'Prepare cost and expenditure statements and other necessary documentation at regular intervals for the duration of the project.', 'Supplemental', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1051.00', 92, 'Visit site and record information about access, drainage and topography, and availability of services such as water and electricity.', 'Supplemental', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18861, 'Interpret and explain human resources policies, procedures, laws, standards, or regulations.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18859, 'Hire employees and process hiring-related paperwork.', 'Core', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18864, 'Maintain current knowledge of Equal Employment Opportunity (EEO) and affirmative action guidelines and laws, such as the Americans with Disabilities Act (ADA).', 'Core', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18866, 'Prepare or maintain employment records related to events, such as hiring, termination, leaves, transfers, or promotions, using human resources management system software.', 'Core', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18852, 'Address employee relations issues, such as harassment allegations, work complaints, or other employee concerns.', 'Core', 125, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18868, 'Review employment applications and job orders to match applicants with job requirements.', 'Core', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18860, 'Inform job applicants of details such as duties and responsibilities, compensation, benefits, schedules, working conditions, or promotion opportunities.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18871, 'Select qualified job applicants or refer them to managers, making hiring recommendations when appropriate.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18870, 'Schedule or conduct new employee orientations.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18863, 'Maintain and update human resources documents, such as organizational charts, employee handbooks or directories, or performance evaluation forms.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18856, 'Confer with management to develop or implement personnel policies or procedures.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18857, 'Contact job applicants to inform them of the status of their applications.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18854, 'Conduct exit interviews and ensure that necessary employment termination paperwork is completed.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18862, 'Interview job applicants to obtain information on work history, training, education, or job skills.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18865, 'Perform searches for qualified job candidates, using sources such as computer databases, networking, Internet recruiting resources, media advertisements, job fairs, recruiting firms, or employee referrals.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18867, 'Provide management with information or training related to interviewing, performance appraisals, counseling techniques, or documentation of performance issues.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18853, 'Analyze employment-related data and prepare required reports.', 'Core', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18872, 'Advise management on organizing, preparing, or implementing recruiting or retention programs.', 'Core', 120, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18858, 'Develop or implement recruiting strategies to meet current or anticipated staffing needs.', 'Core', 122, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 21097, 'Administer employee benefit plans.', 'Supplemental', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18869, 'Schedule or administer skill, intelligence, psychological, or drug tests for current or prospective employees.', 'Supplemental', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18855, 'Conduct reference or background checks on job applicants.', 'Supplemental', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18876, 'Review and evaluate applicant qualifications or eligibility for specified licensing, according to established guidelines and designated licensing codes.', 'Supplemental', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18874, 'Evaluate recruitment or selection criteria to ensure conformance to professional, statistical, or testing standards, recommending revisions, as needed.', 'Supplemental', 124, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18873, 'Coordinate with outside staffing agencies to secure temporary employees, based on departmental needs.', 'Supplemental', 123, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1071.00', 18875, 'Evaluate selection or testing techniques by conducting research or follow-up activities and conferring with management or supervisory personnel.', 'Supplemental', 121, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14838, 'Pay wages of contracted farm laborers.', 'Core', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14839, 'Provide food, drinking water, and field sanitation facilities to contracted workers.', 'Core', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14840, 'Recruit and hire agricultural workers.', 'Core', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14841, 'Employ foremen to deal directly with workers when recruiting, hiring, instructing, assigning tasks, and enforcing work rules.', 'Core', 56, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14842, 'Supervise the work of contracted employees.', 'Core', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14843, 'Furnish tools for employee use.', 'Core', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14844, 'Direct and transport workers to appropriate work sites.', 'Supplemental', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1074.00', 14845, 'Provide check-cashing services to employees.', 'Supplemental', 57, TO_DATE('2008-06-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18886, 'Negotiate collective bargaining agreements.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18885, 'Monitor company or workforce adherence to labor agreements.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18889, 'Present the position of the company or of labor during arbitration or other labor negotiations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18895, 'Write letters related to labor relations activities, such as letters to amend collective bargaining agreements, letters of dispute or conciliation, or letters to seek clarification of contract terms.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18879, 'Draft contract proposals or counter-proposals for collective bargaining or other labor negotiations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18878, 'Call or meet with union, company, government, or other interested parties to discuss labor relations matters, such as contract negotiations or grievances.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18882, 'Interpret contractual agreements for employers and employees engaged in collective bargaining or other labor relations processes.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18897, 'Assess the impact of union proposals on company or government operations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18883, 'Investigate and evaluate union complaints or arguments to determine viability.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18891, 'Recommend collective bargaining strategies, goals, or objectives.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18900, 'Prepare evidence for disciplinary hearings, including preparing witnesses to testify.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18890, 'Propose resolutions for collective bargaining or other labor or contract negotiations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18884, 'Mediate discussions between employer and employee representatives in attempt to reconcile differences.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18892, 'Review and approve employee disciplinary actions, such as written reprimands, suspensions, or terminations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18896, 'Assess risk levels associated with collective bargaining strategies.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18877, 'Advise management on matters related to the administration of contracts or employee discipline or grievance procedures.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18903, 'Select mediators or arbitrators for labor disputes or contract negotiations.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18893, 'Review employer practices or employee data to ensure compliance with contracts on matters such as wages, hours, or conditions of employment.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18880, 'Draft rules or regulations to govern collective bargaining activities in collaboration with company, government, or employee representatives.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18904, 'Train managers or supervisors on topics related to labor relations, such as working conditions, safety, or equal opportunity practices.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18901, 'Provide expert testimony in legal proceedings related to labor relations or labor contracts.', 'Core', 19, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18881, 'Identify alternatives to proposals of unions, employees, companies, or government agencies.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18899, 'Develop methods to monitor employee satisfaction with policies or working conditions, including grievance or complaint procedures.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18902, 'Research case law or outcomes of previous case hearings.', 'Core', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18894, 'Schedule or coordinate the details of grievance hearings or other meetings.', 'Core', 19, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18887, 'Prepare and submit required governmental reports or forms related to labor relations matters, such as equal employment opportunity (EEO) forms, new hire forms, or minority compensation reports.', 'Supplemental', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18888, 'Prepare reports or presentations to communicate employee satisfaction or related data to management.', 'Supplemental', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1075.00', 18898, 'Develop employee health and safety policies.', 'Supplemental', 20, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8932, 'Maintain and develop positive business relationships with a customer''s key personnel involved in, or directly relevant to, a logistics activity.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8933, 'Develop an understanding of customers'' needs and take actions to ensure that such needs are met.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8950, 'Manage subcontractor activities, reviewing proposals, developing performance specifications, and serving as liaisons between subcontractors and organizations.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8943, 'Develop proposals that include documentation for estimates.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8937, 'Review logistics performance with customers against targets, benchmarks, and service agreements.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8934, 'Direct availability and allocation of materials, supplies, and finished products.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8949, 'Redesign the movement of goods to maximize value and minimize costs.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8942, 'Explain proposed solutions to customers, management, or other interested parties through written proposals and oral presentations.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8939, 'Direct team activities, establishing task priorities, scheduling and tracking work assignments, providing guidance, and ensuring the availability of resources.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 20847, 'Perform managerial duties such as hiring and training employees and overseeing facility needs or requirements.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8935, 'Collaborate with other departments as necessary to meet customer requirements, to take advantage of sales opportunities or, in the case of shortages, to minimize negative impacts on a business.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8940, 'Report project plans, progress, and results.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8936, 'Protect and control proprietary materials.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8948, 'Stay informed of logistics technology advances and apply appropriate technology to improve logistics processes.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8938, 'Develop and implement technical project management tools, such as plans, schedules, and responsibility and compliance matrices.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8945, 'Provide project management services, including the provision and analysis of technical data.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8951, 'Manage the logistical aspects of product life cycles, including coordination or provisioning of samples, and the minimization of obsolescence.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8952, 'Perform system lifecycle cost analysis and develop component studies.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8944, 'Plan, organize, and execute logistics support activities, such as maintenance planning, repair analysis, and test equipment recommendations.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8946, 'Participate in the assessment and review of design alternatives and design change proposal impacts.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8941, 'Direct and support the compilation and analysis of technical source data necessary for product development.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.00', 8947, 'Support the development of training materials and technical manuals.', 'Core', 24, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15867, 'Review contractual commitments, customer specifications, or related information to determine logistics or support requirements.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15874, 'Determine logistics support requirements, such as facility details, staffing needs, or safety or maintenance plans.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15861, 'Propose logistics solutions for customers.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15864, 'Direct the work of logistics analysts.', 'Core', 20, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15879, 'Evaluate effectiveness of current or future logistical processes.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15877, 'Provide logistics technology or information for effective and efficient support of product, equipment, or system manufacturing or service.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 19995, 'Evaluate the use of inventory tracking technology, Web-based warehousing software, or intelligent conveyor systems to maximize plant or distribution center efficiency.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 19996, 'Develop logistic metrics, internal analysis tools, or key performance indicators for business units.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15876, 'Analyze or interpret logistics data involving customer service, forecasting, procurement, manufacturing, inventory, transportation, or warehousing.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15868, 'Prepare or validate documentation on automated logistics or maintenance-data reporting or management information systems.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 19997, 'Identify cost-reduction or process-improvement logistic opportunities.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 19998, 'Evaluate the use of technologies, such as global positioning systems (GPS), radio-frequency identification (RFID), route navigation software, or satellite linkup systems, to improve transportation efficiency.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15872, 'Develop or maintain cost estimates, forecasts, or cost models.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15866, 'Develop specifications for equipment, tools, facility layouts, or material-handling systems.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15875, 'Conduct logistics studies or analyses, such as time studies, zero-base analyses, rate analyses, network analyses, flow-path analyses, or supply chain analyses.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15880, 'Apply logistics modeling techniques to address issues such as operational process improvement or facility design or layout.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 19999, 'Prepare logistic strategies or conceptual designs for production facilities.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15870, 'Identify or develop business rules or standard operating procedures to streamline operating processes.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20000, 'Design comprehensive supply chains that minimize environmental impacts or costs.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15863, 'Interview key staff or tour facilities to identify efficiency-improvement, cost-reduction, or service-delivery opportunities.', 'Core', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20001, 'Develop or document reverse logistics management processes to ensure maximal efficiency of product recycling, reuse, or final disposal.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15873, 'Determine feasibility of designing new facilities or modifying existing facilities, based on factors such as cost, available space, schedule, technical requirements, or ergonomics.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20002, 'Conduct environmental audits for logistics activities, such as storage, distribution, or transportation.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20003, 'Create models or scenarios to predict the impact of changing circumstances, such as fuel costs, road pricing, energy taxes, or carbon emissions legislation.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20004, 'Review global, national, or regional transportation or logistics reports for ways to improve efficiency or minimize the environmental impact of logistics activities.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20005, 'Determine requirements for compliance with environmental certification standards.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20006, 'Provide logistical facility or capacity planning analyses for distribution or transportation functions.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 15865, 'Design plant distribution centers.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20007, 'Develop or document procedures to minimize or mitigate carbon output resulting from the movement of materials or products.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.01', 20008, 'Assess the environmental impact or energy efficiency of logistics activities, using carbon mitigation software.', 'Supplemental', 22, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15898, 'Maintain databases of logistics information.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15903, 'Interpret data on logistics elements, such as availability, maintainability, reliability, supply chain management, strategic sourcing or distribution, supplier management, or transportation.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15894, 'Provide ongoing analyses in areas such as transportation costs, parts procurement, back orders, or delivery processes.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15895, 'Prepare reports on logistics performance measures.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15901, 'Confer with logistics management teams to determine ways to optimize service levels, maintain supply-chain efficiency, or minimize cost.', 'Core', 25, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20009, 'Remotely monitor the flow of vehicles or inventory, using Web-based logistics information systems to track vehicles or containers.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15890, 'Track product flow from origin to final delivery.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15893, 'Recommend improvements to existing or planned logistics processes.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15883, 'Enter logistics-related data into databases.', 'Core', 25, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15900, 'Develop or maintain models for logistics uses, such as cost estimating or demand forecasting.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15892, 'Review procedures, such as distribution or inventory management, to ensure maximum efficiency or minimum cost.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15904, 'Apply analytic methods or tools to understand, predict, or control logistics operations or processes.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15897, 'Monitor inventory transactions at warehouse facilities to assess receiving, storage, shipping, or inventory integrity.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15905, 'Analyze logistics data, using methods such as data mining, data modeling, or cost or benefit analysis.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15899, 'Maintain logistics records in accordance with corporate policies.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15902, 'Compute reporting metrics, such as on-time delivery rates, order fulfillment rates, or inventory turns.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15891, 'Write or revise standard operating procedures for logistics processes.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15882, 'Monitor industry standards, trends, or practices to identify developments in logistics planning or execution.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15881, 'Identify opportunities for inventory reductions.', 'Core', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15884, 'Develop or maintain payment systems to ensure accuracy of vendor payments.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15886, 'Develop or maintain freight rate databases for use by supply chain departments to determine the most economical modes of transportation.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15896, 'Manage systems to ensure that pricing structures adequately reflect logistics costing.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15889, 'Communicate with or monitor service providers, such as ocean carriers, air freight forwarders, global consolidators, customs brokers, or trucking companies.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20010, 'Reorganize shipping schedules to consolidate loads, maximize vehicle usage, or limit the movement of empty vehicles or containers.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15885, 'Determine packaging requirements.', 'Supplemental', 25, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15887, 'Contact potential vendors to determine material availability.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20011, 'Route or reroute drivers in real time with remote route navigation software, satellite linkup systems, or global positioning systems (GPS) to improve operational efficiencies.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20012, 'Arrange for sale or lease of excess storage or transport capacity to minimize losses or inefficiencies associated with empty space.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 15888, 'Contact carriers for rates or schedules.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20013, 'Compare locations or environmental policies of carriers or suppliers to make transportation decisions with lower environmental impact.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1081.02', 20014, 'Enter carbon-output or environmental-impact data into spreadsheets or environmental management or auditing software programs.', 'Supplemental', 26, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7282, 'Document findings of study and prepare recommendations for implementation of new systems, procedures, or organizational changes.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7281, 'Interview personnel and conduct on-site observation to ascertain unit functions, work performed, and methods, equipment, and personnel used.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7277, 'Analyze data gathered and develop solutions or alternative methods of proceeding.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7285, 'Plan study of work problems and procedures, such as organizational change, communications, information flow, integrated production methods, inventory control, or cost analysis.', 'Core', 25, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7278, 'Confer with personnel concerned to ensure successful functioning of newly implemented systems or procedures.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7276, 'Gather and organize information on problems or procedures.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7283, 'Prepare manuals and train workers in use of new forms, reports, procedures or equipment, according to organizational policy.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7280, 'Review forms and reports and confer with management and users about format, distribution, and purpose, identifying problems and improvements.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7279, 'Develop and implement records management program for filing, protection, and retrieval of records, and assure compliance with program.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7284, 'Design, evaluate, recommend, and approve changes of forms and reports.', 'Core', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1111.00', 7286, 'Recommend purchase of storage equipment and design area layout to locate equipment in space available.', 'Supplemental', 26, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1209, 'Consult with customers to determine objectives and requirements for events, such as meetings, conferences, and conventions.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1212, 'Review event bills for accuracy and approve payment.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1214, 'Coordinate services for events, such as accommodation and transportation for participants, facilities, catering, signage, displays, special needs requirements, printing and event security.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1215, 'Arrange the availability of audio-visual equipment, transportation, displays, and other event needs.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1211, 'Confer with staff at a chosen event site to coordinate details.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1216, 'Inspect event facilities to ensure that they conform to customer requirements.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1217, 'Maintain records of event aspects, including financial details.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1210, 'Monitor event activities to ensure compliance with applicable regulations and laws, satisfaction of participants, and resolution of any problems that arise.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1219, 'Negotiate contracts with such service providers and suppliers as hotels, convention centers, and speakers.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1222, 'Evaluate and select providers of services according to customer requirements.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1213, 'Plan and develop programs, agendas, budgets, and services according to customer requirements.', 'Core', 65, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1226, 'Hire, train, and supervise volunteers and support staff required for events.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1218, 'Conduct post-event evaluations to determine how future events could be improved.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1221, 'Direct administrative details, such as financial operations, dissemination of promotional materials, and responses to inquiries.', 'Core', 65, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1220, 'Meet with sponsors and organizing committees to plan scope and format of events, to establish and monitor budgets, or to review administrative procedures and event progress.', 'Core', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1223, 'Read trade publications, attend seminars, and consult with other meeting professionals to keep abreast of meeting management standards and trends.', 'Core', 64, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1224, 'Organize registration of event participants.', 'Supplemental', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1229, 'Develop event topics and choose featured speakers.', 'Supplemental', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1228, 'Promote conference, convention and trades show services by performing tasks such as meeting with professional and trade associations, and producing brochures and other publications.', 'Supplemental', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1225, 'Design and implement efforts to publicize events and promote sponsorships.', 'Supplemental', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1121.00', 1227, 'Obtain permits from fire and health departments to erect displays and exhibits and serve food at events.', 'Supplemental', 66, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18917, 'Identify and build relationships with potential donors.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18931, 'Write and send letters of thanks to donors.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18922, 'Secure commitments of participation or donation from individuals or corporate donors.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18910, 'Develop fundraising activity plans that maximize participation or contributions and minimize costs.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18912, 'Develop strategies to encourage new or increased contributions.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18907, 'Create or update donor databases.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18914, 'Direct or supervise fundraising staff, including volunteer staff members.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18911, 'Develop or implement fundraising activities, such as annual giving campaigns or direct mail programs.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18923, 'Solicit cash or in-kind donations or sponsorships from individual, business, or government donors.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18919, 'Monitor progress of fundraising drives.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18926, 'Conduct research to identify the goals, net worth, charitable donation history, or other data related to potential donors, potential investors, or general donor markets.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18925, 'Compile or develop materials to submit to granting or other funding organizations.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18915, 'Establish fundraising or participation goals for special events or specified time periods.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18918, 'Monitor budgets, expense reports, or other financial data for fundraising organizations.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18906, 'Contact corporate representatives, government officials, or community leaders to increase awareness of organizational causes, activities, or needs.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18921, 'Recruit sponsors, participants, or volunteers for fundraising events.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18932, 'Write reports or prepare presentations to communicate fundraising program data.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18908, 'Design or produce materials such as posters, Web sites, or newsletters to promote, market, or advertise fundraising events.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18924, 'Write speeches, press releases, or other promotional materials to increase awareness of the causes, missions, or goals of organizations seeking funds.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18916, 'Explain the tax advantages of contributions to potential donors.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18920, 'Plan and direct special events for fundraising, such as silent auctions, dances, golf events, or walks.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18905, 'Attend community events, meetings, or conferences to promote organizational goals or solicit donations or sponsorships.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18913, 'Direct or coordinate Web-based fundraising activities, such as online auctions or donation Web sites.', 'Core', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18909, 'Develop corporate fundraising programs, such as employer gift-matching.', 'Supplemental', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18930, 'Secure speakers for charitable events, community meetings, or conferences to increase awareness of charitable, nonprofit, or political causes.', 'Supplemental', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18929, 'Prepare materials such as fundraising envelopes, bid sheets, or gift bags for charitable events.', 'Supplemental', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18928, 'Develop and maintain media contact lists.', 'Supplemental', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1131.00', 18927, 'Coordinate transportation or delivery of materials, supplies, or donations for fundraising events.', 'Supplemental', 32, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3351, 'Evaluate job positions, determining classification, exempt or non-exempt status, and salary.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3352, 'Ensure company compliance with federal and state laws, including reporting requirements.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3356, 'Prepare occupational classifications, job descriptions, and salary scales.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3355, 'Provide advice on the resolution of classification and salary complaints.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3368, 'Research job and worker requirements, structural and functional relationships among jobs and occupations, and occupational trends.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3353, 'Advise managers and employees on state and federal employment regulations, collective agreements, benefit and compensation policies, personnel procedures, and classification programs.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3362, 'Perform multifactor data and cost analyses that may be used in areas such as support of collective bargaining agreements.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3358, 'Prepare reports, such as organization and flow charts, and career path reports to summarize job analysis and evaluation and compensation analysis information.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3354, 'Plan, develop, evaluate, improve, and communicate methods and techniques for selecting, promoting, compensating, evaluating, and training workers.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3366, 'Assess need for and develop job analysis instruments and materials.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3371, 'Consult with or serve as a technical liaison between business, industry, government, and union officials.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3370, 'Observe, interview, and survey employees and conduct focus group meetings to collect job, organizational, and occupational information.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3357, 'Assist in preparing and maintaining personnel records and handbooks.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3364, 'Analyze organizational, occupational, and industrial data to facilitate organizational functions and provide technical information to business, industry, and government.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3359, 'Administer employee insurance, pension and savings plans, working with insurance brokers and plan carriers.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3363, 'Research employee benefit and health and safety practices and recommend changes or modifications to existing policies.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3361, 'Develop, implement, administer and evaluate personnel and labor relations programs, including performance appraisal, affirmative action, and employment equity programs.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3365, 'Advise staff of individuals'' qualifications.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3360, 'Negotiate collective agreements on behalf of employers or workers, and mediate labor disputes and grievances.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3367, 'Review occupational data on Alien Employment Certification Applications to determine the appropriate occupational title and code, and provide local offices with information about immigration and occupations.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3369, 'Plan and develop curricula and materials for training programs and conduct training.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3373, 'Work with the Department of Labor and promote its use with employers.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3372, 'Prepare research results for publication in form of journals, books, manuals, and film.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1141.00', 3374, 'Speak at conferences and events to promote apprenticeships and related training programs.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 103, 'Assess training needs through surveys, interviews with employees, focus groups, or consultation with managers, instructors, or customer representatives.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 20474, 'Design, plan, organize, or direct orientation and training programs for employees or customers.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 97, 'Offer specific training programs to help workers maintain or improve job skills.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 94, 'Present information using a variety of instructional techniques or formats, such as role playing, simulations, team exercises, group discussions, videos, or lectures.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 20475, 'Obtain, organize, or develop training procedure manuals, guides, or course materials, such as handouts or visual materials.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 98, 'Monitor, evaluate, or record training activities or program effectiveness.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 102, 'Develop alternative training methods if expected improvements are not seen.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 101, 'Evaluate training materials prepared by instructors, such as outlines, text, or handouts.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 19559, 'Evaluate modes of training delivery, such as in-person or virtual to optimize training effectiveness, training costs, or environmental impacts.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 93, 'Keep up with developments in area of expertise by reading current journals, books, or magazine articles.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 108, 'Negotiate contracts with clients including desired training outcomes, fees, or expenses.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 99, 'Attend meetings or seminars to obtain information for use in training programs or to inform management of training program status.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 20476, 'Monitor training costs and prepare budget reports to justify expenditures.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 105, 'Select and assign instructors to conduct training.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 95, 'Schedule classes based on availability of classrooms, equipment, or instructors.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 20477, 'Supervise, evaluate, or refer instructors to skill development classes.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 106, 'Devise programs to develop executive potential among employees in lower-level positions.', 'Core', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 100, 'Coordinate recruitment and placement of training program participants.', 'Supplemental', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 19558, 'Develop or implement training programs related to efficiency, recycling, or other issues with environmental impacts.', 'Supplemental', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1151.00', 111, 'Refer trainees to employer relations representatives, to locations offering job placement assistance, or to appropriate social services agencies if warranted.', 'Supplemental', 36, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5434, 'Prepare reports of findings, illustrating data graphically and translating complex findings into written text.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5433, 'Collect and analyze data on customer demographics, preferences, needs, and buying habits to identify potential markets and factors affecting product demand.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5439, 'Conduct research on consumer opinions and marketing strategies, collaborating with marketing professionals, statisticians, pollsters, and other professionals.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5435, 'Measure and assess customer and employee satisfaction.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5443, 'Devise and evaluate methods and procedures for collecting data, such as surveys, opinion polls, or questionnaires, or arrange to obtain existing data.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5438, 'Measure the effectiveness of marketing, advertising, and communications programs and strategies.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5437, 'Seek and provide information to help companies determine their position in the marketplace.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5436, 'Forecast and track marketing and sales trends, analyzing collected data.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5441, 'Gather data on competitors and analyze their prices, sales, and method of marketing and distribution.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5442, 'Monitor industry statistics and follow trends in trade literature.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5440, 'Attend staff conferences to provide management with information and proposals concerning the promotion, distribution, design, and pricing of company products or services.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5445, 'Direct trained survey interviewers.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1161.00', 5444, 'Develop and implement procedures for identifying advertising needs.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18083, 'Identify opportunities to improve the operation, maintenance, or energy efficiency of building or process systems.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18082, 'Identify and prioritize energy-saving measures.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18076, 'Analyze technical feasibility of energy-saving measures, using knowledge of engineering, energy production, energy use, construction, maintenance, system operation, or process systems.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18073, 'Inspect or evaluate building envelopes, mechanical systems, electrical systems, or process systems to determine the energy consumption of each system.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 19561, 'Identify any health or safety issues related to planned weatherization projects.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18074, 'Prepare audit reports containing energy analysis results or recommendations for energy cost savings.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 19562, 'Inspect newly installed energy-efficient equipment to ensure that it was installed properly and is performing according to specifications.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18078, 'Collect and analyze field data related to energy usage.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18072, 'Perform tests such as blower-door tests to locate air leaks.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18077, 'Calculate potential for energy savings.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18071, 'Measure energy usage with devices such as data loggers, universal data recorders, light meters, sling psychrometers, psychrometric charts, flue gas analyzers, amp probes, watt meters, volt meters, thermometers, or utility meters.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18084, 'Quantify energy consumption to establish baselines for energy use or need.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18086, 'Prepare job specification sheets for home energy improvements, such as attic insulation, window retrofits, or heating system upgrades.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 19560, 'Examine commercial sites to determine the feasibility of installing equipment that allows building management systems to reduce electricity consumption during peak demand periods.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18085, 'Oversee installation of equipment such as water heater wraps, pipe insulation, weatherstripping, door sweeps, or low-flow showerheads to improve energy efficiency.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18081, 'Educate customers on energy efficiency or answer questions on topics such as the costs of running household appliances or the selection of energy-efficient appliances.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18087, 'Recommend energy-efficient technologies or alternate energy sources.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18080, 'Determine patterns of building use to show annual or monthly needs for heating, cooling, lighting, or other energy needs.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18079, 'Compare existing energy consumption levels to normative data.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 18075, 'Analyze energy bills, including utility rates or tariffs, to gather historical energy usage data.', 'Core', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.01', 19563, 'Verify income eligibility of participants in publicly financed weatherization programs.', 'Supplemental', 22, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15918, 'Engineer, install, maintain, or repair security systems, programmable logic controls, or other security-related electronic systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15919, 'Recommend improvements in security systems or procedures.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20355, 'Perform risk analyses so that appropriate countermeasures can be developed.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20356, 'Conduct security audits to identify potential vulnerabilities related to physical security, staff safety, or asset protection.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20357, 'Provide system design and integration recommendations.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15921, 'Design security policies, programs, or practices to ensure adequate security relating to asset protection, alarm response, access card use, and other security needs.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20358, 'Assess the nature and level of threats so that the scope of the problem can be determined.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20359, 'Design, implement, or establish requirements for security systems, video surveillance, motion detection, or closed-circuit television systems to ensure proper installation and operation.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15912, 'Respond to emergency situations on an on-call basis.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20360, 'Determine the value loss impact and criticality of assets.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15914, 'Prepare, maintain, or update security procedures, security system drawings, or related documentation.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15920, 'Develop or review specifications for design or construction of security systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20361, 'Outline system security criteria for pre-bid meetings with clients and companies to ensure comprehensiveness and appropriateness for implementation.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15911, 'Develop conceptual designs of security systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15915, 'Monitor the work of contractors in the design, construction, and startup phases of security systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15913, 'Train personnel in security procedures or use of security equipment.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15907, 'Review design drawings or technical documents for completeness, correctness, or appropriateness.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15916, 'Inspect security design features, installations, or programs to ensure compliance with applicable standards or regulations.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 20362, 'Test security measures for final acceptance and implement or provide procedures for ongoing monitoring and evaluation of the measures.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15910, 'Budget and schedule security design work.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15917, 'Inspect fire, intruder detection, or other security systems.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15906, 'Prepare documentation for case reports or court proceedings.', 'Core', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15909, 'Interview witnesses or suspects to identify persons responsible for security breaches or to establish losses, pursue prosecutions, or obtain restitution.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.02', 15908, 'Monitor tapes or digital recordings to identify the source of losses.', 'Supplemental', 26, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15945, 'Prepare and process import and export documentation according to customs regulations, laws, or procedures.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15946, 'Clear goods through customs and to their destinations for clients.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15936, 'Pay, or arrange for payment of, taxes and duties on shipments.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15942, 'Calculate duty and tariff payments owed on shipments.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15932, 'Request or compile necessary import documentation, such as customs invoices, certificates of origin, and cargo-control documents.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15941, 'Classify goods according to tariff coding system.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15933, 'Stay abreast of changes in import or export laws or regulations by reading current literature, attending meetings or conferences, or conferring with colleagues.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15924, 'Sign documents on behalf of clients, using powers of attorney.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15944, 'Advise customers on import and export restrictions, tariff systems, insurance requirements, quotas, or other customs-related matters.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15926, 'Post bonds for the products being imported or assist clients in obtaining bonds.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15934, 'Quote duty and tax rates on goods to be imported, based on federal tariffs and excise taxes.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15930, 'Arrange for transportation, warehousing, or product distribution of imported or exported products.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15937, 'Monitor or trace the location of goods.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15940, 'Confer with officials in various agencies to facilitate clearance of goods through customs and quarantine.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15939, 'Inform importers and exporters of steps to reduce duties and taxes.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15928, 'Obtain line releases for frequent shippers of low-risk commodities, high-volume entries, or multiple-container loads.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15925, 'Provide advice on transportation options, types of carriers, or shipping routes.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15929, 'Contract with freight forwarders for destination services.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15943, 'Apply for tariff concessions or for duty drawbacks and other refunds.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15927, 'Insure cargo against loss, damage, or pilferage.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15935, 'Prepare papers for shippers to appeal duty charges.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15931, 'Suggest best methods of packaging or labeling products.', 'Supplemental', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.03', 15938, 'Maintain relationships with customs brokers in other ports to expedite clearing of cargo.', 'Supplemental', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15965, 'Develop emergency management plans for recovery decision making and communications, continuity of critical departmental processes, or temporary shut-down of non-critical departments to ensure continuity of operation and governance.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15962, 'Develop disaster recovery plans for physical locations with critical assets, such as data centers.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15956, 'Test documented disaster recovery strategies and plans.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15960, 'Analyze impact on, and risk to, essential business functions or information systems to identify acceptable recovery time periods and resource requirements.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15947, 'Write reports to summarize testing activities, including descriptions of goals, planning, scheduling, execution, results, analysis, conclusions, and recommendations.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15957, 'Review existing disaster recovery, crisis management, or business continuity plans.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15963, 'Create scenarios to reestablish operations from various types of business disruptions.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15951, 'Establish, maintain, or test call trees to ensure appropriate communication during disaster.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15964, 'Conduct or oversee contingency plan integration and operation.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15961, 'Identify opportunities for strategic improvement or mitigation of business interruption and other risks caused by business, regulatory, or industry-specific change initiatives.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15949, 'Interpret government regulations and applicable codes to ensure compliance.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15954, 'Create or administer training and awareness presentations or materials.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15959, 'Prepare reports summarizing operational results, financial performance, or accomplishments of specified objectives, goals, or plans.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15955, 'Attend professional meetings, read literature, and participate in training or other educational offerings to keep abreast of new developments and technologies related to disaster recovery and business continuity.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15958, 'Recommend or implement methods to monitor, evaluate, or enable resolution of safety, operations, or compliance interruptions.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15953, 'Create business continuity and disaster recovery budgets.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15948, 'Maintain and update organization information technology applications and network systems blueprints.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15952, 'Design or implement products and services to mitigate risk or facilitate use of technology-based tools and methods.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15967, 'Analyze corporate intelligence data to identify trends, patterns, or warnings indicating threats to security of people, assets, information, or infrastructure.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15966, 'Conduct or oversee collection of corporate intelligence to avoid fraud, financial crime, cyber-attack, terrorism, and infrastructure failure.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.04', 15950, 'Identify individual or transaction targets to direct intelligence collection.', 'Supplemental', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15975, 'Create or maintain plans or other documents related to sustainability projects.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15981, 'Develop sustainability project goals, objectives, initiatives, or strategies in collaboration with other sustainability professionals.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15979, 'Assess or propose sustainability initiatives, considering factors such as cost effectiveness, technical feasibility, and acceptance.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15973, 'Provide technical or administrative support for sustainability programs or issues.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15980, 'Monitor or track sustainability indicators, such as energy usage, natural resource usage, waste generation, and recycling.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15969, 'Research or review regulatory, technical, or market issues related to sustainability.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15968, 'Review and revise sustainability proposals or policies.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15978, 'Collect information about waste stream management or green building practices to inform decision makers.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15976, 'Develop reports or presentations to communicate the effectiveness of sustainability initiatives.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15974, 'Identify or procure needed resources to implement sustainability programs or projects.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15977, 'Create marketing or outreach media, such as brochures or Web sites, to communicate sustainability issues, procedures, or objectives.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15972, 'Write grant applications, rebate applications, or project proposals to secure funding for sustainability projects.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15971, 'Identify or create new sustainability indicators.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.05', 15970, 'Identify or investigate violations of natural resources, waste management, recycling, or other environmental policies.', 'Supplemental', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15718, 'Fill customer orders by packaging sold items and documentation for direct shipping or by transferring orders to manufacturers or third-party distributors.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15731, 'Receive and process payments from customers, using electronic transaction services.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15710, 'Create, manage, or automate orders or invoices, using order management or invoicing software.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15709, 'Deliver e-mail confirmation of completed transactions and shipment.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15728, 'Correspond with online customers via electronic mail, telephone, or other electronic messaging to address questions or complaints about products, policies, or shipping methods.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15733, 'Purchase new or used items from online or physical sources for resale via retail or auction Web site.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15707, 'Determine and set product prices.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15730, 'Calculate purchase subtotals, taxes, and shipping costs for submission to customers.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15734, 'Compose descriptions of merchandise for posting to online storefront, auction sites, or other shopping Web sites.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15729, 'Compose images of products, using video or still cameras, lighting equipment, props, or photo or video editing software.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15703, 'Upload digital media, such as photos, video, or scanned images to online storefront, auction sites, or other shopping Web sites.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15735, 'Calculate revenue, sales, and expenses, using financial accounting or spreadsheet software.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15714, 'Cancel orders based on customer requests or inventory or delivery problems.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15732, 'Prepare or organize online storefront marketing material, including product descriptions or subject lines, optimizing content to search engine criteria.', 'Core', 72, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15704, 'Order or purchase merchandise to maintain optimal inventory levels.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15726, 'Determine location for product listings to maximize exposure to online traffic.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15711, 'Create or maintain database of customer accounts.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15717, 'Promote products in online communities through weblog or discussion-forum postings, e-mail marketing programs, or online advertising.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15713, 'Collaborate with search engine shopping specialists to place marketing content in desired online locations.', 'Core', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15721, 'Investigate products or markets to determine areas for opportunity or viability for merchandising specific products, using online or offline sources.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15705, 'Maintain inventory of shipping supplies, such as boxes, labels, tape, bubble wrap, loose packing materials, or tape guns.', 'Core', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15719, 'Measure and analyze Web site usage data to maximize search engine returns or refine customer interfaces.', 'Core', 72, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15725, 'Develop or revise business plans for online business, emphasizing factors such as product line, pricing, inventory, or marketing strategy.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15708, 'Disclose merchant information and terms and policies of transactions in online or offline materials.', 'Core', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15727, 'Design customer interface of online storefront, using web programming or e-commerce software.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15716, 'Select and purchase technical web services, such as web hosting services, online merchant accounts, shopping cart software, payment gateway software, or spyware.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15715, 'Transfer digital media, such as music, video, or software, to customers via the Internet.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15724, 'Devise, select, or purchase domain name and web address.', 'Supplemental', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15722, 'Initiate online auctions through auction hosting sites or auction management software.', 'Supplemental', 75, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15723, 'Implement security practices to preserve assets, minimize liabilities, or ensure customer privacy, using parallel servers, hardware redundancy, fail-safe technology, information encryption, or firewalls.', 'Supplemental', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15720, 'Investigate sources, such as auctions, estate sales, liquidators, wholesalers, or trade shows for new items, used items, or collectibles.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15702, 'Participate in online forums or conferences to stay abreast of online retailing trends, techniques, or security threats.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15706, 'Integrate online retailing strategy with physical or catalogue retailing operations.', 'Supplemental', 74, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-1199.06', 15712, 'Create or distribute offline promotional material, such as brochures, pamphlets, business cards, stationary, or signage.', 'Supplemental', 73, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 117, 'Develop, maintain, and analyze budgets, preparing periodic reports that compare budgeted costs to actual costs.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 112, 'Prepare, examine, or analyze accounting records, financial statements, or other financial reports to assess accuracy, completeness, and conformance to reporting and procedural standards.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 21043, 'Review accounts for discrepancies and reconcile differences.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 21044, 'Prepare adjusting journal entries.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 116, 'Establish tables of accounts and assign entries to proper accounts.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 114, 'Analyze business operations, trends, costs, revenues, financial commitments, and obligations to project future revenues and expenses or to provide advice.', 'Core', 132, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 115, 'Report to management regarding the finances of establishment.', 'Core', 133, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 118, 'Develop, implement, modify, and document recordkeeping and accounting systems, making use of current computer technology.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 122, 'Advise management about issues such as resource utilization, tax strategies, and the assumptions underlying budget forecasts.', 'Core', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 128, 'Maintain or examine the records of government agencies.', 'Supplemental', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 113, 'Compute taxes owed and prepare tax returns, ensuring compliance with payment, reporting, or other tax requirements.', 'Supplemental', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 124, 'Advise clients in areas such as compensation, employee health care benefits, the design of accounting or data processing systems, or long-range tax or estate plans.', 'Supplemental', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 126, 'Represent clients before taxing authorities and provide support during litigation involving financial issues.', 'Supplemental', 132, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 123, 'Provide internal and external auditing services for businesses or individuals.', 'Supplemental', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 119, 'Prepare forms and manuals for accounting and bookkeeping personnel and direct their work activities.', 'Supplemental', 133, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 127, 'Appraise, evaluate, and inventory real property and equipment, recording information such as the description, value, and location of property.', 'Supplemental', 132, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.01', 120, 'Survey operations to ascertain accounting needs and to recommend, develop, or maintain solutions to business and financial problems.', 'Supplemental', 131, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1232, 'Prepare detailed reports on audit findings.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1231, 'Report to management about asset utilization and audit results, and recommend changes in operations and financial activities.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1230, 'Collect and analyze data to detect deficient controls, duplicated effort, extravagance, fraud, or non-compliance with laws, regulations, and management policies.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1236, 'Supervise auditing of establishments, and determine scope of investigation required.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1234, 'Inspect account books and accounting systems for efficiency, effectiveness, and use of accepted accounting procedures to record transactions.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1237, 'Prepare, analyze, and verify annual reports, financial statements, and other records, using accepted accounting and statistical procedures to assess financial condition and facilitate financial planning.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1233, 'Review data about material assets, net worth, liabilities, capital stock, surplus, income, and expenditures.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1235, 'Examine and evaluate financial and information systems, recommending controls to ensure system reliability and data integrity.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1238, 'Confer with company officials about financial and regulatory matters.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1239, 'Inspect cash on hand, notes receivable and payable, negotiable securities, and canceled checks to confirm records are accurate.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1242, 'Examine records and interview workers to ensure recording of transactions and compliance with laws and regulations.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1240, 'Examine inventory to verify journal and ledger entries.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1247, 'Evaluate taxpayer finances to determine tax liability, using knowledge of interest and discount rates, annuities, valuation of stocks and bonds, and amortization valuation of depletable assets.', 'Core', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1241, 'Examine whether the organization''s objectives are reflected in its management activities, and whether employees understand the objectives.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1249, 'Audit payroll and personnel records to determine unemployment insurance premiums, workers'' compensation coverage, liabilities, and compliance with tax laws.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1246, 'Review taxpayer accounts, and conduct audits on-site, by correspondence, or by summoning taxpayer to office.', 'Supplemental', 21, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1248, 'Examine records, tax returns, and related documents pertaining to settlement of decedent''s estate.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1244, 'Produce up-to-the-minute information, using internal computer systems, to allow management to base decisions on actual, not historical, data.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1243, 'Direct activities of personnel engaged in filing, recording, compiling, and transmitting financial records.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2011.02', 1245, 'Conduct pre-implementation audits to determine if systems and programs under development will work as planned.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3376, 'Inspect new construction and major improvements to existing structures to determine values.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3375, 'Determine taxability and value of properties, using methods such as field inspection, structural measurement, calculation, sales analysis, market trend studies, and income and expense analysis.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3379, 'Prepare and maintain current data on each parcel assessed, including maps of boundaries, inventories of land and structures, property characteristics, and any applicable exemptions.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3377, 'Explain assessed values to property owners and defend appealed assessments at public hearings.', 'Core', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3380, 'Identify the ownership of each piece of taxable property.', 'Core', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3378, 'Inspect properties, considering factors such as market value, location, and building or replacement costs to determine appraisal value.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3382, 'Complete and maintain assessment rolls that show the assessed values and status of all property in a municipality.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3384, 'Review information about transfers of property to ensure its accuracy, checking basic information on buyers, sellers, and sales prices and making corrections as necessary.', 'Core', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3389, 'Write and submit appraisal and tax reports for public record.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 21098, 'Explain real and personal property taxes to property owners.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3381, 'Conduct regular reviews of property within jurisdictions to determine changes in property due to construction or demolition.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3383, 'Issue notices of assessments and taxes.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3388, 'Establish uniform and equitable systems for assessing all classes and kinds of property.', 'Core', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3385, 'Maintain familiarity with aspects of local real estate markets.', 'Core', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3393, 'Calculate tax bills for properties by multiplying assessed values by jurisdiction tax rates.', 'Supplemental', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3387, 'Approve applications for property tax exemptions or deductions.', 'Supplemental', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3390, 'Serve on assessment review boards.', 'Supplemental', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 20015, 'Supervise staff members.', 'Supplemental', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3386, 'Analyze trends in sales prices, construction costs, and rents, to assess property values or determine the accuracy of assessments.', 'Supplemental', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 21099, 'Assist in the training of new staff.', 'Supplemental', 59, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3392, 'Provide sales analyses to be used for equalization of school aid.', 'Supplemental', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.01', 3391, 'Hire staff members.', 'Supplemental', 58, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7288, 'Compute final estimation of property values, taking into account such factors as depreciation, replacement costs, value comparisons of similar properties, and income potential.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7287, 'Prepare written reports that estimate property values, outline methods by which the estimations were made, and meet appraisal standards.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 20478, 'Collect and analyze relevant data to identify real estate market trends.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7290, 'Inspect properties to evaluate construction, condition, special features, and functional design, and to take property measurements.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7297, 'Examine income records and operating costs of income properties.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7292, 'Evaluate land and neighborhoods where properties are situated, considering locations and trends or impending changes that could influence future values.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7289, 'Search public records for transactions such as sales, leases, and assessments.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7295, 'Check building codes and zoning bylaws to determine any effects on the properties being appraised.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7294, 'Verify legal descriptions of properties by comparing them to county records.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7298, 'Interview persons familiar with properties and immediate surroundings, such as contractors, home owners, and realtors, to obtain pertinent information.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7291, 'Photograph interiors and exteriors of properties to assist in estimating property value, substantiate findings, and complete appraisal reports.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7293, 'Obtain county land values and sales information about nearby properties to aid in establishment of property values.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7299, 'Examine the type and location of nearby services, such as shopping centers, schools, parks, and other neighborhood features, to evaluate their impact on property values.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7296, 'Estimate building replacement costs, using building valuation manuals and professional cost estimators.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7300, 'Draw land diagrams to be used in appraisal reports to support findings.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2021.02', 7301, 'Testify in court as to the value of a piece of real estate property.', 'Core', 20, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3399, 'Summarize budgets and submit recommendations for the approval or disapproval of funds requests.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3394, 'Analyze monthly department budgeting and accounting reports to maintain expenditure controls.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3402, 'Examine budget estimates for completeness, accuracy, and conformance with procedures and regulations.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3395, 'Direct the preparation of regular and special budget reports.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3398, 'Provide advice and technical assistance with cost analysis, fiscal allocation, and budget preparation.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3405, 'Compile and analyze accounting records and other data to determine the financial resources required to implement a program.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3401, 'Review operating budgets to analyze trends affecting budget needs.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3404, 'Interpret budget directives and establish policies for carrying out directives.', 'Core', 110, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3397, 'Match appropriations for specific programs with appropriations for broader programs, including items for emergency funds.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3396, 'Consult with managers to ensure that budget adjustments are made in accordance with program changes.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3403, 'Perform cost-benefit analyses to compare operating programs, review financial requests, or explore alternative financing methods.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3400, 'Seek new ways to improve efficiency and increase profits.', 'Core', 112, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2031.00', 3406, 'Testify before examining and fund-granting authorities, clarifying and promoting the proposed budgets.', 'Supplemental', 108, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1250, 'Analyze credit data and financial statements to determine the degree of risk involved in extending credit or lending money.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1255, 'Generate financial ratios, using computer programs, to evaluate customers'' financial status.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1258, 'Consult with customers to resolve complaints and verify financial and credit transactions.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1251, 'Prepare reports that include the degree of risk involved in extending credit or lending money.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1257, 'Compare liquidity, profitability, and credit histories of establishments being evaluated with those of similar establishments in the same industries and geographic locations.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1256, 'Review individual or commercial customer files to identify and select delinquent accounts for collection.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1253, 'Confer with credit association and other business representatives to exchange credit information.', 'Core', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1254, 'Complete loan applications, including credit analyses and summaries of loan requests, and submit to loan committees for approval.', 'Supplemental', 30, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1259, 'Analyze financial data such as income growth, quality of management, and market share to determine expected profitability of loans.', 'Supplemental', 29, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2041.00', 1252, 'Evaluate customer records and recommend payment plans, based on earnings, savings data, payment history, and purchase activity.', 'Supplemental', 29, TO_DATE('2009-06-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7303, 'Inform investment decisions by analyzing financial information to forecast business, industry, or economic conditions.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7309, 'Prepare plans of action for investment, using financial analyses.', 'Core', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7310, 'Evaluate and compare the relative quality of various securities in a given industry.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7307, 'Recommend investments and investment timing to companies, investment firm staff, or the public.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7311, 'Present oral or written reports on general economic trends, individual corporations, and entire industries.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7306, 'Monitor fundamental economic, industrial, and corporate developments by analyzing information from financial publications and services, investment banking firms, government agencies, trade publications, company sources, or personal interviews.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7305, 'Interpret data on price, yield, stability, future investment-risk trends, economic influences, and other factors affecting investment programs.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 20848, 'Purchase investments for companies in accordance with company policy.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7304, 'Monitor developments in the fields of industrial technology, business, finance, and economic theory.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7302, 'Draw charts and graphs, using computer spreadsheets, to illustrate technical reports.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7308, 'Determine the prices at which securities should be syndicated and offered to the public.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 7313, 'Collaborate with investment bankers to attract new corporate clients to securities firms.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19564, 'Conduct financial analyses related to investments in green construction or green retrofitting projects.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19567, 'Forecast or analyze financial costs associated with climate change or other environmental factors, such as clean water supply and demand.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19568, 'Identify potential financial investments that are environmentally sound, considering issues such as carbon emissions and biodiversity.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19565, 'Determine the financial viability of alternative energy generation or fuel production systems, based on power source or feedstock quality, financing costs, potential revenue, and total project costs.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19566, 'Evaluate financial viability and potential environmental benefits of cleantech innovations to secure capital investments from sources such as venture capital firms and government green fund grants.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2051.00', 19569, 'Research and recommend environmentally-related financial products, such as energy futures, water rights, carbon credits, government environmental funds, and cleantech industry funds and company stocks.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12907, 'Interview clients to determine their current income, expenses, insurance coverage, tax status, financial objectives, risk tolerance, or other information needed to develop a financial plan.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12905, 'Answer clients'' questions about the purposes and details of financial plans and strategies.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20182, 'Recommend to clients strategies in cash management, insurance coverage, investment planning, or other areas to help them achieve their financial goals.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12904, 'Analyze financial information obtained from clients to determine strategies for meeting clients'' financial objectives.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12909, 'Implement financial planning recommendations or refer clients to someone who can assist them with plan implementation.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20183, 'Review clients'' accounts and plans regularly to determine whether life changes, economic changes, environmental concerns, or financial performance indicate a need for plan reassessment.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20184, 'Manage client portfolios, keeping client plans up-to-date.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12915, 'Contact clients periodically to determine any changes in their financial status.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12913, 'Prepare or interpret for clients information such as investment performance reports, financial document summaries, or income projections.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20185, 'Recruit and maintain client bases.', 'Core', 26, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20186, 'Explain to clients the personal financial advisor''s responsibilities and the types of services to be provided.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20187, 'Investigate available investment opportunities to determine compatibility with client financial plans.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12914, 'Guide clients in the gathering of information, such as bank account records, income tax returns, life and disability insurance records, pension plans, or wills.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20188, 'Monitor financial market trends to ensure that client plans are responsive.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 20189, 'Recommend financial products, such as stocks, bonds, mutual funds, or insurance.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12916, 'Meet with clients'' other advisors, such as attorneys, accountants, trust officers, or investment bankers, to fully understand clients'' financial goals and circumstances.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12917, 'Devise debt liquidation plans that include payoff priorities and timelines.', 'Core', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12918, 'Open accounts for clients and disburse funds from accounts to creditors as agent for clients.', 'Supplemental', 27, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 19570, 'Inform clients about tax benefits, government rebates, or other financial benefits of alternative fuel vehicle purchases or energy efficient home construction, improvements, or remodeling.', 'Supplemental', 27, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 12919, 'Conduct seminars or workshops on financial planning topics, such as retirement planning, estate planning, or the evaluation of severance packages.', 'Supplemental', 28, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2052.00', 19571, 'Recommend environmentally responsible investments, such as cleantech, alternative energy, or conservation technologies, companies, or funds.', 'Supplemental', 27, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 21045, 'Examine documents to determine degree of risk from factors such as applicant health, financial standing and value, and condition of property.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1261, 'Decline excessive risks.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1262, 'Write to field representatives, medical personnel, or others to obtain further information, quote rates, or explain company underwriting policies.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1263, 'Evaluate possibility of losses due to catastrophe or excessive insurance.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1265, 'Review company records to determine amount of insurance in force on single risk or group of closely related risks.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1264, 'Decrease value of policy when risk is substandard and specify applicable endorsements or apply rating to ensure safe, profitable distribution of risks, using reference materials.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2053.00', 1266, 'Authorize reinsurance of policy when risk is high.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7314, 'Investigate activities of institutions to enforce laws and regulations and to ensure legality of transactions and operations or financial solvency.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7319, 'Prepare reports, exhibits and other supporting schedules that detail an institution''s safety and soundness, compliance with laws and regulations, and recommended solutions to questionable financial conditions.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7317, 'Recommend actions to ensure compliance with laws and regulations, or to protect solvency of institutions.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7327, 'Resolve problems concerning the overall financial integrity of banking institutions including loan investment portfolios, capital, earnings, and specific or large troubled accounts.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7324, 'Direct and participate in formal and informal meetings with bank directors, trustees, senior management, counsels, outside accountants and consultants to gather information and discuss findings.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7320, 'Review balance sheets, operating income and expense accounts, and loan documentation to confirm institution assets and liabilities.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7316, 'Plan, supervise, and review work of assigned subordinates.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7321, 'Review audit reports of internal and external auditors to monitor adequacy of scope of reports or to discover specific weaknesses in internal routines.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7322, 'Train other examiners in the financial examination process.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7315, 'Review and analyze new, proposed, or revised laws, regulations, policies, and procedures to interpret their meaning and determine their impact.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7318, 'Examine the minutes of meetings of directors, stockholders and committees to investigate the specific authority extended at various levels of management.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7329, 'Confer with officials of real estate, securities, or financial institution industries to exchange views and discuss issues or pending cases.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7323, 'Establish guidelines for procedures and policies that comply with new and revised regulations and direct their implementation.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7328, 'Evaluate data processing applications for institutions under examination to develop recommendations for coordinating existing systems with examination procedures.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7325, 'Verify and inspect cash reserves, assigned collateral, and bank-owned securities to check internal control procedures.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 20190, 'Provide regulatory compliance training to employees.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2061.00', 7326, 'Review applications for mergers, acquisitions, establishment of new institutions, acceptance in Federal Reserve System, or registration of securities sales to determine their public interest value and conformance to regulations, and recommend acceptance or rejection.', 'Core', 25, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18934, 'Assess clients'' overall financial situations by reviewing income, assets, debts, expenses, credit reports, or other financial information.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18936, 'Create debt management plans, spending plans, or budgets to assist clients to meet financial goals.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18935, 'Calculate clients'' available monthly income to meet debt obligations.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18943, 'Prioritize client debt repayment to avoid dire consequences, such as bankruptcy or foreclosure or to reduce overall costs, such as by paying high-interest or short-term loans first.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18945, 'Recommend strategies for clients to meet their financial goals, such as borrowing money through loans or loan programs, declaring bankruptcy, making budget adjustments, or enrolling in debt management plans.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18939, 'Interview clients by telephone or in person to gather financial information.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18952, 'Explain general financial topics to clients, such as credit report ratings, bankruptcy laws, consumer protection laws, wage attachments, or collection actions.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18948, 'Advise clients on housing matters, such as housing rental, homeownership, mortgage delinquency, or foreclosure prevention.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18942, 'Prepare written documents to establish contracts with or communicate financial recommendations to clients.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18938, 'Explain services or policies to clients, such as debt management program rules, advantages and disadvantages of using services, or creditor concession policies.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18940, 'Maintain or update records of client account activity, including financial transactions, counseling session notes, correspondence, document images, or client inquiries.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18933, 'Advise clients or respond to inquiries about financial matters in person or via phone, email, Web site, or Internet chat.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18946, 'Refer clients to social service or community resources for needs beyond those of credit or debt counseling.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18937, 'Estimate time for debt repayment, given amount of debt, interest rates, and available funds.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18941, 'Negotiate with creditors on behalf of clients to arrange for payment adjustments, interest rate reductions, time extensions, or payment plans.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18944, 'Recommend educational materials or resources to clients on matters such as financial planning, budgeting, or credit.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18947, 'Review changes to financial, family, or employment situations to determine whether changes to existing debt management plans, spending plans, or budgets are needed.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18950, 'Create action plans to assist clients in obtaining permanent housing via rent or mortgage programs.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18955, 'Teach courses or seminars on topics such as budgeting, management of personal finances, or financial literacy.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18953, 'Explain loan information to clients, such as available loan types, eligibility requirements, or loan restrictions.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18949, 'Conduct research to help clients avoid repossessions or foreclosures or remove levies or wage garnishments.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18954, 'Investigate missing checks, payment histories, held funds, returned checks, or other related issues to resolve client or creditor problems.', 'Core', 33, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.00', 18951, 'Disburse funds from client accounts to creditors.', 'Supplemental', 32, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7338, 'Maintain current knowledge of credit regulations.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7337, 'Contact applicants or creditors to resolve questions about applications or to assist with completion of paperwork.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7352, 'Counsel clients on personal and family financial problems, such as excessive spending or borrowing of funds.', 'Core', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7345, 'Confer with underwriters to resolve mortgage application problems.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 20849, 'Advise students on available financial-aid awards.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7334, 'Analyze applicants'' financial status, credit, and property evaluations to determine feasibility of granting loans.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7350, 'Contact borrowers with delinquent accounts to obtain payment in full or to negotiate repayment plans.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7344, 'Assist in selection of financial award candidates using electronic databases to certify loan eligibility.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7332, 'Approve loans within specified limits.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7341, 'Review billing for accuracy.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7347, 'Match students'' needs and eligibility with available financial aid programs to provide informed recommendations.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7346, 'Inform individuals and groups about the financial assistance available to college or university students.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7336, 'Establish payment priorities according to credit terms and interest rates to reduce clients'' overall costs.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7342, 'Supervise loan personnel.', 'Supplemental', 58, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7335, 'Interview applicants and request specified information for loan applications.', 'Supplemental', 58, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7330, 'Check loan agreements to ensure that they are complete and accurate, according to policies.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7333, 'Submit applications to credit analysts for verification and recommendation.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7351, 'Compare data on student aid applications with eligibility requirements of assistance programs.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7356, 'Authorize or sign mail collection letters.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7353, 'Review accounts to determine write-offs for collection agencies.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 20850, 'Provide entrance or exit loan counseling to students.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7343, 'Maintain and review account records, updating and recategorizing them according to status changes.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7339, 'Calculate amount of debt and funds available to plan methods of payoff and to estimate time for debt liquidation.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7331, 'Refer loans to loan committees for approval.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7357, 'Open accounts for clients and disburse funds from clients'' accounts to creditors.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7340, 'Analyze potential loan markets to find opportunities to promote loans and financial services.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7354, 'Locate debtors using post office directories, utility services account listings, or mailing lists.', 'Supplemental', 59, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2071.01', 7348, 'Contact creditors to explain clients'' financial situations and to arrange for payment adjustments so that payments are feasible for clients and agreeable to creditors.', 'Supplemental', 60, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3409, 'Analyze applicants'' financial status, credit, and property evaluations to determine feasibility of granting loans.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3411, 'Obtain and compile copies of loan applicants'' credit histories, corporate financial statements, and other financial information.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3408, 'Meet with applicants to obtain information for loan applications and to answer questions about the process.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3410, 'Explain to customers the different types of loans and credit options that are available, as well as the terms of those services.', 'Core', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3413, 'Review loan agreements to ensure that they are complete and accurate according to policy.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3407, 'Approve loans within specified limits, and refer loan applications outside those limits to management for approval.', 'Core', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3417, 'Handle customer complaints and take appropriate action to resolve them.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3415, 'Stay abreast of new types of loans and other financial services and products to better meet customers'' needs.', 'Core', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3412, 'Review and update credit and loan files.', 'Core', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3416, 'Submit applications to credit analysts for verification and recommendation.', 'Core', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3414, 'Compute payment schedules.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3425, 'Analyze potential loan markets and develop referral networks to locate prospects for loans.', 'Core', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3423, 'Set credit policies, credit lines, procedures and standards in conjunction with senior managers.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3419, 'Confer with underwriters to aid in resolving mortgage application problems.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3421, 'Market bank products to individuals and firms, promoting bank services that may meet customers'' needs.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3418, 'Work with clients to identify their financial goals and to find ways of reaching those goals.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3420, 'Negotiate payment arrangements with customers who have delinquent loans.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3426, 'Prepare reports to send to customers whose accounts are delinquent, and forward irreconcilable accounts for collector action.', 'Supplemental', 105, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3422, 'Supervise loan personnel.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3428, 'Interview, hire, and train new employees.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3424, 'Provide special services such as investment banking for clients with more specialized needs.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3427, 'Arrange for maintenance and liquidation of delinquent properties.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2072.00', 3429, 'Petition courts to transfer titles and deeds of collateral to banks.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5288, 'Collect taxes from individuals or businesses according to prescribed laws and regulations.', 'Core', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5289, 'Maintain knowledge of tax code changes, and of accounting procedures and theory to properly evaluate financial information.', 'Core', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5290, 'Maintain records for each case, including contacts, telephone numbers, and actions taken.', 'Core', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5292, 'Contact taxpayers by mail or telephone to address discrepancies and to request supporting documentation.', 'Core', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5293, 'Send notices to taxpayers when accounts are delinquent.', 'Core', 109, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5302, 'Check tax forms to verify that names and taxpayer identification numbers are correct, that computations have been performed correctly, or that amounts match those on supporting documentation.', 'Core', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 20016, 'Answer questions from taxpayers and assist them in completing tax forms.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5301, 'Impose payment deadlines on delinquent taxpayers and monitor payments to ensure that deadlines are met.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5294, 'Notify taxpayers of any overpayment or underpayment, and either issue a refund or request further payment.', 'Core', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5291, 'Confer with taxpayers or their representatives to discuss the issues, laws, and regulations involved in returns, and to resolve problems with returns.', 'Supplemental', 109, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5298, 'Enter tax return information into computers for processing.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5295, 'Conduct independent field audits and investigations of income tax returns to verify information or to amend tax liabilities.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5297, 'Review selected tax returns to determine the nature and extent of audits to be performed on them.', 'Supplemental', 109, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5310, 'Investigate claims of inability to pay taxes by researching court information for the status of liens, mortgages, or financial statements, or by locating assets through third parties.', 'Supplemental', 105, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5300, 'Process individual and corporate income tax returns, and sales and excise tax returns.', 'Supplemental', 111, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5304, 'Recommend criminal prosecutions or civil penalties.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5299, 'Examine accounting systems and records to determine whether accounting methods used were appropriate and in compliance with statutory provisions.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5296, 'Review filed tax returns to determine whether claimed tax credits and deductions are allowed by law.', 'Supplemental', 110, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5312, 'Participate in informal appeals hearings on contested cases from other agents.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5303, 'Examine and analyze tax assets and liabilities to determine resolution of delinquent tax problems.', 'Supplemental', 107, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5308, 'Direct service of legal documents, such as subpoenas, warrants, notices of assessment, and garnishments.', 'Supplemental', 109, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5306, 'Secure a taxpayer''s agreement to discharge a tax assessment or submit contested determinations to other administrative or judicial conferees for appeals hearings.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5305, 'Determine appropriate methods of debt settlement, such as offers of compromise, wage garnishment, or seizure and sale of property.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5309, 'Request that the state or federal revenue service prepare a return on a taxpayer''s behalf in cases where taxes have not been filed.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5307, 'Prepare briefs and assist in searching and seizing records to prepare charges and documentation for court cases.', 'Supplemental', 108, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2081.00', 5311, 'Install systems of recording costs or other financial and budgetary data or provide advice on such systems, based on examination of current financial records.', 'Supplemental', 106, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7361, 'Interview clients to obtain additional information on taxable income and deductible expenses and allowances.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7360, 'Use all appropriate adjustments, deductions, and credits to keep clients'' taxes to a minimum.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7359, 'Prepare or assist in preparing simple to complex tax returns for individuals or small businesses.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7358, 'Compute taxes owed or overpaid, using adding machines or personal computers, and complete entries on forms, following tax form instructions and tax tables.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7363, 'Furnish taxpayers with sufficient information and advice to ensure correct tax form completion.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7366, 'Check data input or verify totals on forms prepared by others to detect errors in arithmetic, data entry, or procedures.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7364, 'Consult tax law handbooks or bulletins to determine procedures for preparation of atypical returns.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7365, 'Calculate form preparation fees according to return complexity and processing time required.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 20363, 'Answer questions and provide future tax planning to clients.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 7362, 'Review financial records such as income statements and documentation of expenditures to determine forms needed to prepare tax returns.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2082.00', 20364, 'Explain federal and state tax laws to individuals and companies.', 'Core', 20, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15990, 'Develop core analytical capabilities or model libraries, using advanced statistical, quantitative, or econometric techniques.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15983, 'Provide application or analytical support to researchers or traders on issues such as valuations or data.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15995, 'Research or develop analytical tools to address issues such as portfolio construction or optimization, performance measurement, attribution, profit and loss measurement, or pricing models.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15987, 'Maintain or modify all financial analytic models in use.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15997, 'Apply mathematical or statistical techniques to address practical issues in finance, such as derivative valuation, securities trading, risk management, or financial market regulation.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15986, 'Research new financial products or analytics to determine their usefulness.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15996, 'Devise or apply independent models or tools to help verify results of analytical systems.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15991, 'Define or recommend model specifications or data collection methods.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15993, 'Confer with other financial engineers or analysts on trading strategies, market dynamics, or trading system performance to inform development of quantitative techniques.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15989, 'Interpret results of financial analysis procedures.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15994, 'Collaborate with product development teams to research, model, validate, or implement quantitative structured solutions for new or expanded markets.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15988, 'Produce written summary reports of financial research results.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15992, 'Consult traders or other financial industry personnel to determine the need for new or improved analytical applications.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15984, 'Identify, track, or maintain metrics for trading system operations.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15982, 'Prepare requirements documentation for use by software developers.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 15985, 'Collaborate in the development or testing of new analytical software to ensure compliance with user requirements, specifications, or scope.', 'Core', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 19575, 'Develop solutions to help clients hedge carbon exposure or risk.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 19572, 'Analyze pricing or risks of carbon trading products.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 19574, 'Develop methods of assessing or measuring corporate performance in terms of environmental, social, and governance (ESG) issues.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 19576, 'Develop tools to assess green technologies or green financial products, such as green hedge funds or social responsibility investment funds.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.01', 19573, 'Assess the potential impact of climate change on business financial issues, such as damage repairs, insurance costs, or potential disruptions of daily activities.', 'Supplemental', 23, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16002, 'Develop contingency plans to deal with emergencies.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16007, 'Recommend ways to control or reduce risk.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 21046, 'Analyze areas of potential risk to the assets, earning capacity, or success of organizations.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16012, 'Document, and ensure communication of, key risks.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16001, 'Maintain input or data quality of risk management systems.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16010, 'Gather risk-related data from internal or external resources.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16011, 'Develop or implement risk-assessment models or methodologies.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 21047, 'Devise systems or processes to monitor validity of risk assessments.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16000, 'Meet with clients to answer queries on subjects such as risk exposure, market scenarios, or values-at-risk calculations.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16008, 'Produce reports or presentations that outline findings, explain risk positions, or recommend changes.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 21048, 'Contribute to development of risk management systems.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16014, 'Conduct statistical analyses to quantify risk, using statistical analysis software or econometric models.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16006, 'Analyze new legislation to determine impact on risk exposure.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 15998, 'Provide statistical modeling advice to other departments.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16004, 'Consult financial literature to ensure use of the latest models or statistical techniques.', 'Core', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 19580, 'Evaluate the risks related to green investments, such as renewable energy company stocks.', 'Supplemental', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16017, 'Confer with traders to identify and communicate risks associated with specific trading strategies or positions.', 'Supplemental', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 19577, 'Determine potential environmental impacts of new products or processes on long-term growth and profitability.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16005, 'Track, measure, or report on aspects of market risk for traded issues.', 'Supplemental', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16015, 'Identify key risks and mitigating factors of potential investments, such as asset types and values, legal and ownership structures, professional reputations, customer bases, or industry segments.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 16003, 'Devise scenario analyses reflecting possible severe market events.', 'Supplemental', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 15999, 'Review or draft risk disclosures for offer documents.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 19579, 'Evaluate the risks and benefits involved in implementing green building technologies.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.02', 19578, 'Determine potential liability related to the use of more sustainable methods of product packaging, such as biodegradable food containers.', 'Supplemental', 21, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16031, 'Advise clients on aspects of capitalization, such as amounts, sources, or timing.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16030, 'Analyze financial or operational performance of companies facing financial difficulties to identify or recommend remedies.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 19581, 'Arrange deals involving green investments in areas such as alternative energy product development, green technologies, or sustainable agriculture.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16034, 'Arrange financing of deals from sources such as financial institutions, agencies, or public or private companies.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16020, 'Assess companies as investments for clients by examining company facilities.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16028, 'Collaborate on projects with other professionals, such as lawyers, accountants, or public relations experts.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16029, 'Confer with clients to restructure debt, refinance debt, or raise new debt.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16027, 'Coordinate due diligence processes and the negotiation or execution of purchase or sale agreements.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16026, 'Create client presentations of plan details.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16024, 'Develop and maintain client relationships.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16032, 'Direct communications between corporate issuers of new securities and the general public.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16023, 'Employ financial models to develop solutions to financial problems or to assess the financial or capital impact of transactions.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16025, 'Evaluate capital needs of clients and assess market conditions to inform structuring of financial packages.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16022, 'Perform securities valuation or pricing.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16021, 'Prepare all materials for transactions or execution of deals.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 19582, 'Specialize in green financial instruments, such as socially responsible mutual funds or exchange-traded funds (ETF) that are comprised of green companies.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16018, 'Structure marketing campaigns to find buyers for new securities.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16033, 'Structure or negotiate deals, such as corporate mergers, sales, or acquisitions.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.03', 16019, 'Supervise, train, or mentor junior team members.', NULL, NULL, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16053, 'Document all investigative activities.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16046, 'Prepare written reports of investigation findings.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16057, 'Analyze financial data to detect irregularities in areas such as billing trends, financial relationships, and regulatory compliance procedures.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16051, 'Gather financial documents related to investigations.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16049, 'Interview witnesses or suspects and take statements.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16045, 'Review reports of suspected fraud to determine need for further investigation.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16056, 'Conduct in-depth investigations of suspicious financial activity, such as suspected money-laundering efforts.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16048, 'Lead, or participate in, fraud investigation teams.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16038, 'Prepare evidence for presentation in court.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16055, 'Coordinate investigative efforts with law enforcement officers and attorneys.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16043, 'Testify in court regarding investigation findings.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16047, 'Recommend actions in fraud cases.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16052, 'Evaluate business operations to identify risk areas for fraud.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16054, 'Create and maintain logs, records, or databases of information about fraudulent activity.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16035, 'Maintain knowledge of current events and trends in such areas as money laundering and criminal tools and techniques.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16044, 'Advise businesses or agencies on ways to improve fraud detection.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16040, 'Negotiate with responsible parties to arrange for recovery of losses due to fraud.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16036, 'Train others in fraud detection and prevention techniques.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16050, 'Design, implement, or maintain fraud detection tools or procedures.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16041, 'Conduct field surveillance to gather case-related information.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16037, 'Research or evaluate new technologies for use in fraud detection systems.', 'Core', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16042, 'Arrest individuals to be charged with fraud.', 'Supplemental', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('13-2099.04', 16039, 'Obtain and serve subpoenas.', 'Supplemental', 25, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14623, 'Analyze problems to develop solutions involving computer hardware and software.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14626, 'Apply theoretical expertise and innovation to create or apply new technology, such as adapting principles for applying computers to new uses.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14624, 'Assign or schedule tasks to meet work priorities and goals.', 'Core', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14628, 'Meet with managers, vendors, and others to solicit cooperation and resolve problems.', 'Core', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14633, 'Design computers and the software that runs them.', 'Core', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14629, 'Conduct logical analyses of business, scientific, engineering, and other technical problems, formulating mathematical models of problems for solution by computers.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14625, 'Evaluate project plans and proposals to assess feasibility issues.', 'Core', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14635, 'Participate in multidisciplinary projects in areas such as virtual reality, human-computer interaction, or robotics.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14627, 'Consult with users, management, vendors, and technicians to determine computing needs and system requirements.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14630, 'Develop and interpret organizational goals, policies, and procedures.', 'Core', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14632, 'Develop performance standards, and evaluate work in light of established standards.', 'Core', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14634, 'Maintain network hardware and software, direct network security measures, and monitor networks to ensure availability to system users.', 'Supplemental', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14637, 'Direct daily operations of departments, coordinating project activities with other departments.', 'Supplemental', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14631, 'Participate in staffing decisions and direct training of subordinates.', 'Supplemental', 48, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1111.00', 14636, 'Approve, prepare, monitor, and adjust operational budgets.', 'Supplemental', 49, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3465, 'Test, maintain, and monitor computer programs and systems, including coordinating the installation of computer programs and systems.', 'Core', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 20950, 'Troubleshoot program and system malfunctions to restore normal functioning.', 'Core', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3470, 'Expand or modify system to serve new purposes or improve work flow.', 'Core', 99, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3482, 'Use the computer in the analysis and solution of business problems, such as development of integrated production and inventory control and cost analysis systems.', 'Core', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3469, 'Consult with management to ensure agreement on system principles.', 'Core', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3467, 'Confer with clients regarding the nature of the information processing or computation needs a computer program is to address.', 'Core', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3477, 'Develop, document and revise system design procedures, test procedures, and quality standards.', 'Core', 99, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3473, 'Train staff and users to work with computer systems and programs.', 'Core', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3468, 'Coordinate and link the computer systems within an organization to increase compatibility and so information can be shared.', 'Core', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3475, 'Assess the usefulness of pre-developed application packages and adapt them to a user environment.', 'Core', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3476, 'Define the goals of the system and devise flow charts and diagrams describing logical operational steps of programs.', 'Core', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3464, 'Provide staff and users with assistance solving computer related problems, such as malfunctions and program problems.', 'Core', 98, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3466, 'Use object-oriented programming languages, as well as client and server applications development processes and multimedia and Internet technology.', 'Supplemental', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3478, 'Review and analyze computer printouts and performance indicators to locate code problems, and correct errors by correcting codes.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3481, 'Supervise computer programmers or other systems analysts or serve as project leaders for particular systems projects.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3480, 'Read manuals, periodicals, and technical reports to learn how to develop programs that meet staff and user requirements.', 'Supplemental', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3472, 'Determine computer software or hardware needed to set up or alter system.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3474, 'Analyze information processing or computation needs and plan and design computer systems, using techniques such as structured analysis, data modeling and information engineering.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3471, 'Interview or survey workers, observe job performance or perform the job to determine what information is processed and how it is processed.', 'Supplemental', 98, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3484, 'Specify inputs accessed by the system and plan the distribution and use of the results.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3483, 'Prepare cost-benefit and return-on-investment analyses to aid in decisions on system implementation.', 'Supplemental', 101, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.00', 3479, 'Recommend new equipment or software packages.', 'Supplemental', 100, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18090, 'Translate nursing practice information between nurses and systems engineers, analysts, or designers using object-oriented models or other techniques.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18096, 'Apply knowledge of computer science, information science, nursing, and informatics theory to nursing practice, education, administration, or research, in collaboration with other health informatics specialists.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18088, 'Design, develop, select, test, implement, and evaluate new or modified informatics solutions, data structures, and decision-support mechanisms to support patients, health care professionals, and their information management and human-computer and human-technology interactions within health care contexts.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18094, 'Analyze and interpret patient, nursing, or information systems data to improve nursing services.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18093, 'Develop, implement, or evaluate health information technology applications, tools, processes, or structures to assist nurses with data management.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18101, 'Identify, collect, record, or analyze data that are relevant to the nursing care of patients.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18092, 'Use informatics science to design or implement health information technology applications to resolve clinical or health care administrative problems.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18103, 'Provide consultation to nurses regarding hardware or software configuration.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18095, 'Analyze computer and information technologies to determine applicability to nursing practice, education, administration, and research.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18100, 'Develop strategies, policies or procedures for introducing, evaluating, or modifying information technology applied to nursing practice, administration, education, or research.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18097, 'Develop or implement policies or practices to ensure the privacy, confidentiality, or security of patient information.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18102, 'Read current literature, talk with colleagues, and participate in professional organizations or conferences to keep abreast of developments in informatics.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18099, 'Develop or deliver training programs for health information technology, creating operating manuals as needed.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18089, 'Disseminate information about nursing informatics science and practice to the profession, other health care professions, nursing students, and the public.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18098, 'Design, conduct, or provide support to nursing informatics research.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18104, 'Inform local, state, national, and international health policies related to information management and communication, confidentiality and security, patient safety, infrastructure development, and economics.', 'Core', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1121.01', 18091, 'Plan, install, repair, or troubleshoot telehealth technology applications or systems in homes.', 'Supplemental', 22, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5314, 'Develop plans to safeguard computer files against accidental or unauthorized modification, destruction, or disclosure and to meet emergency data processing needs.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5316, 'Monitor current reports of computer viruses to determine when to update virus protection systems.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5321, 'Encrypt data transmissions and erect firewalls to conceal confidential information as it is being transmitted and to keep out tainted digital transfers.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5320, 'Perform risk assessments and execute tests of data processing system to ensure functioning of data processing activities and security measures.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5317, 'Modify computer security files to incorporate new software, correct errors, or change individual access status.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5323, 'Review violations of computer security procedures and discuss procedures with violators to ensure violations are not repeated.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5322, 'Document computer security and emergency measures policies, procedures, and tests.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5315, 'Confer with users to discuss issues such as computer data access needs, security violations, and programming changes.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5319, 'Monitor use of data files and regulate access to safeguard information in computer files.', 'Core', 71, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5318, 'Coordinate implementation of computer system plan with establishment personnel and outside vendors.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5313, 'Train users and promote security awareness to ensure system security and to improve server and network efficiency.', 'Core', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1122.00', 5324, 'Maintain permanent fleet cryptologic and carry-on direct support systems required in special land, sea surface and subsurface operations.', 'Supplemental', 72, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1273, 'Write, analyze, review, and rewrite programs, using workflow chart and diagram, and applying knowledge of computer capabilities, subject matter, and symbolic logic.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1267, 'Correct errors by making appropriate changes and rechecking the program to ensure that the desired results are produced.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1272, 'Perform or direct revision, repair, or expansion of existing programs to increase operating efficiency or adapt to new requirements.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1270, 'Write, update, and maintain computer programs or software packages to handle specific jobs such as tracking inventory, storing or retrieving data, or controlling other equipment.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1271, 'Consult with managerial, engineering, and technical personnel to clarify program intent, identify problems, and suggest changes.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1268, 'Conduct trial runs of programs and software applications to be sure they will produce the desired information and that the instructions are correct.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1276, 'Prepare detailed workflow charts and diagrams that describe input, output, and logical operation, and convert them into a series of instructions coded in a computer language.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1269, 'Compile and write documentation of program development and subsequent revisions, inserting comments in the coded instructions so others can understand the program.', 'Core', 69, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1278, 'Consult with and assist computer operators or system analysts to define and resolve problems in running computer programs.', 'Core', 69, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1277, 'Perform systems analysis and programming tasks to maintain and control the use of computer systems software as a systems programmer.', 'Core', 69, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1274, 'Write or contribute to instructions or manuals to guide end users.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1275, 'Investigate whether networks, workstations, the central processing unit of the system, or peripheral equipment are responding to a program''s instructions.', 'Core', 69, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1279, 'Assign, coordinate, and review work and activities of programming personnel.', 'Core', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1281, 'Train subordinates in programming and program coding.', 'Supplemental', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 21049, 'Develop Web sites.', 'Supplemental', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 21050, 'Train users on the use and function of computer programs.', 'Supplemental', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1131.00', 1280, 'Collaborate with computer manufacturers and other users to develop new programming methods.', 'Supplemental', 70, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3431, 'Modify existing software to correct errors, allow it to adapt to new hardware, or to improve its performance.', 'Core', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3432, 'Analyze user needs and software requirements to determine feasibility of design within time and cost constraints.', 'Core', 89, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3430, 'Confer with systems analysts, engineers, programmers and others to design system and to obtain information on project limitations and capabilities, performance requirements and interfaces.', 'Core', 89, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3442, 'Store, retrieve, and manipulate data for analysis of system capabilities and requirements.', 'Core', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3435, 'Design, develop and modify software systems, using scientific analysis and mathematical models to predict and measure outcome and consequences of design.', 'Core', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3436, 'Develop and direct software system testing and validation procedures, programming, and documentation.', 'Core', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3438, 'Supervise the work of programmers, technologists and technicians and other engineering and scientific personnel.', 'Core', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3440, 'Determine system performance standards.', 'Core', 89, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3434, 'Coordinate software system installation and monitor equipment functioning to ensure specifications are met.', 'Core', 87, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3433, 'Consult with customers about software system design and maintenance.', 'Supplemental', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3437, 'Analyze information to determine, recommend, and plan computer specifications and layouts, and peripheral equipment modifications.', 'Supplemental', 89, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3439, 'Obtain and evaluate information on factors such as reporting formats required, costs, and security needs to determine hardware configuration.', 'Supplemental', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3441, 'Train users to use new or modified equipment.', 'Supplemental', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3443, 'Specify power supply requirements and configuration.', 'Supplemental', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1132.00', 3444, 'Recommend purchase of equipment to control dust, temperature, and humidity in area of system installation.', 'Supplemental', 88, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3445, 'Modify existing software to correct errors, to adapt it to new hardware, or to upgrade interfaces and improve performance.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3449, 'Develop or direct software system testing or validation procedures.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3450, 'Direct software programming and development of documentation.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3451, 'Consult with customers or other departments on project status, proposals, or technical issues, such as software system design or maintenance.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3448, 'Analyze information to determine, recommend, and plan installation of a new system or modification of an existing system.', 'Core', 114, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3447, 'Consult with engineering staff to evaluate interface between hardware and software, develop specifications and performance requirements, or resolve customer problems.', 'Core', 114, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3446, 'Design or develop software systems, using scientific analysis and mathematical models to predict and measure outcome and consequences of design.', 'Core', 116, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3457, 'Prepare reports or correspondence concerning project specifications, activities, or status.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3456, 'Confer with data processing or project managers to obtain information on limitations or capabilities for data processing projects.', 'Core', 116, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3455, 'Store, retrieve, and manipulate data for analysis of system capabilities and requirements.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3453, 'Coordinate installation of software system.', 'Core', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3454, 'Monitor functioning of equipment to ensure system operates in conformance with specifications.', 'Supplemental', 116, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3459, 'Supervise and assign work to programmers, designers, technologists, technicians, or other engineering or scientific personnel.', 'Supplemental', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3452, 'Advise customer about or perform maintenance of software system.', 'Supplemental', 114, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3460, 'Train users to use new or modified equipment.', 'Supplemental', 114, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3463, 'Specify power supply requirements and configuration.', 'Supplemental', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3458, 'Evaluate factors such as reporting formats required, cost constraints, or need for security restrictions to determine hardware configuration.', 'Supplemental', 114, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3461, 'Use microcontrollers to develop control signals, implement control algorithms, or measure process variables, such as temperatures, pressures, or positions.', 'Supplemental', 115, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1133.00', 3462, 'Recommend purchase of equipment to control dust, temperature, or humidity in area of system installation.', 'Supplemental', 116, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14707, 'Write supporting code for Web applications or Web sites.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14694, 'Design, build, or maintain Web sites, using authoring or scripting languages, content creation tools, management tools, and digital media.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14698, 'Back up files from Web sites to local directories for instant recovery in case of problems.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14696, 'Write, design, or edit Web page content, or direct others producing content.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14711, 'Select programming languages, design tools, or applications.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14700, 'Evaluate code to ensure that it is valid, is properly structured, meets industry standards, and is compatible with browsers, devices, or operating systems.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14699, 'Identify problems uncovered by testing or customer feedback, and correct problems or refer problems to appropriate personnel for correction.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14704, 'Develop databases that support Web applications and Web sites.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14710, 'Perform Web site tests according to planned schedules, or after any Web site or product revision.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14695, 'Perform or direct Web site updates.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14701, 'Maintain understanding of current Web technologies or programming practices through continuing education, reading, or participation in professional conferences, workshops, or groups.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14702, 'Analyze user needs to determine technical requirements.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14709, 'Design and implement Web site security measures, such as firewalls or message encryption.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14712, 'Incorporate technical considerations into Web site design plans, such as budgets, equipment, performance requirements, or legal issues including accessibility and privacy.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14713, 'Respond to user email inquiries, or set up automated systems to send responses.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14705, 'Renew domain name registrations.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14697, 'Confer with management or development teams to prioritize needs, resolve conflicts, develop content criteria, or choose solutions.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14708, 'Communicate with network personnel or Web site hosting agencies to address hardware or software issues affecting Web sites.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14706, 'Collaborate with management or users to develop e-commerce strategies and to integrate these strategies with Web sites.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14726, 'Document test plans, testing procedures, or test results.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14716, 'Develop Web site maps, application models, image templates, or page templates that meet project goals, user needs, or industry standards.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14715, 'Develop and document style guidelines for Web site content.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14718, 'Identify or maintain links to and from other Web sites and check links to ensure proper functioning.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14717, 'Establish appropriate server directory trees.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14703, 'Develop or validate test routines and schedules to ensure that test cases mimic external interfaces and address all browser and device types.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14719, 'Recommend and implement performance improvements.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14721, 'Register Web sites with search engines to increase Web site traffic.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14728, 'Document technical factors such as server load, bandwidth, database performance, and browser and device types.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14714, 'Develop or implement procedures for ongoing Web site revision.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14724, 'Create Web models or prototypes that include physical, interface, logical, or data models.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14722, 'Provide clear, detailed descriptions of Web site specifications, such as product features, activities, software, communication protocols, programming languages, and operating systems software and hardware.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14725, 'Evaluate or recommend server hardware or software.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14720, 'Create searchable indices for Web page content.', 'Core', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14723, 'Monitor security system performance logs to identify problems and notify security specialists when problems occur.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14729, 'Install and configure hypertext transfer protocol (HTTP) servers and associated operating systems.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14727, 'Research, document, rate, or select alternatives for Web architecture or technologies.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1134.00', 14730, 'Develop system interaction or sequence diagrams.', 'Supplemental', 24, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1300, 'Test programs or databases, correct errors, and make necessary modifications.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1301, 'Plan, coordinate and implement security measures to safeguard information in computer files against accidental or unauthorized damage, modification or disclosure.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1299, 'Modify existing databases and database management systems or direct programmers and analysts to make changes.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1305, 'Specify users and user access levels for each segment of database.', 'Core', 49, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1313, 'Write and code logical and physical database descriptions and specify identifiers of database to management system or direct others in coding descriptions.', 'Core', 49, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1307, 'Develop methods for integrating different products so they work properly together such as customizing commercial databases to fit specific needs.', 'Core', 48, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1298, 'Develop standards and guidelines to guide the use and acquisition of software and to protect vulnerable information.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1310, 'Work as part of a project team to coordinate database development and determine project scope and limitations.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1309, 'Review procedures in database management system manuals for making changes to database.', 'Core', 49, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1315, 'Revise company definition of data as defined in data dictionary.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1308, 'Review project requests describing database user needs to estimate time and cost required to accomplish project.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1303, 'Train users and answer questions.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1314, 'Review workflow charts developed by programmer analyst to understand tasks computer will perform, such as updating records.', 'Core', 49, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1302, 'Approve, schedule, plan, and supervise the installation and testing of new products and improvements to computer systems, such as the installation of new databases.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1312, 'Identify and evaluate industry trends in database systems to serve as a source of information and advice for upper management.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1306, 'Develop data model describing data elements and how they are used, following procedures and using pen, template or computer software.', 'Core', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1311, 'Select and enter codes to monitor database performance and to create production database.', 'Supplemental', 50, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1141.00', 1304, 'Establish and calculate optimum values for database parameters, using manuals and calculator.', 'Supplemental', 49, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1318, 'Maintain and administer computer networks and related computing environments including computer hardware, systems software, applications software, and all configurations.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1317, 'Perform data backups and disaster recovery operations.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 15205, 'Diagnose, troubleshoot, and resolve hardware, software, or other network and system problems, and replace defective components when necessary.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 15206, 'Configure, monitor, and maintain email applications or virus protection software.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1320, 'Operate master consoles to monitor the performance of computer systems and networks, and to coordinate computer network access and use.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1325, 'Monitor network performance to determine whether adjustments need to be made, and to determine where changes will need to be made in the future.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1319, 'Plan, coordinate, and implement network security measures to protect data, software, and hardware.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1329, 'Analyze equipment performance records to determine the need for repair or replacement.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1324, 'Confer with network users about how to solve existing system problems.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1323, 'Recommend changes to improve systems and network configurations, and determine hardware or software requirements related to such changes.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1322, 'Design, configure, and test computer hardware, networking software and operating system software.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1321, 'Perform routine network startup and shutdown procedures, and maintain control records.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1327, 'Load computer tapes and disks, and install software and printer paper or forms.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1326, 'Train people in computer system use.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1330, 'Maintain logs related to network functions, as well as maintenance and repair records.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1328, 'Gather data pertaining to customer needs, and use the information to identify, predict, interpret, and evaluate system and network requirements.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1333, 'Coordinate with vendors and with company personnel to facilitate purchases.', 'Core', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 15208, 'Implement and provide technical support for voice services and equipment, such as private branch exchange, voice mail system, and telecom system.', 'Supplemental', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 1332, 'Maintain an inventory of parts for emergency repairs.', 'Supplemental', 123, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1142.00', 15207, 'Research new technologies by attending seminars, reading trade articles, or taking classes, and implement or recommend the implementation of new technologies.', 'Supplemental', 122, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18971, 'Develop or recommend network security measures, such as firewalls, network security audits, or automated security probes.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18968, 'Develop disaster recovery plans.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18979, 'Monitor and analyze network performance and reports on data input or output to detect problems, identify inefficient use of computer resources, or perform capacity planning.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18961, 'Coordinate network or design activities with designers of associated networks.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18967, 'Develop conceptual, logical, or physical network designs.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18965, 'Develop and implement solutions for network problems.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18964, 'Determine specific network hardware or software requirements, such as platforms, interfaces, bandwidths, or routine schemas.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18958, 'Communicate with system users to ensure accounts are set up properly or to diagnose and solve operational problems.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18987, 'Visit vendors, attend conferences or training sessions, or study technical journals to keep up with changes in technology.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18975, 'Evaluate network designs to determine whether customer requirements are met efficiently and effectively.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18980, 'Participate in network technology upgrade or expansion projects, including installation of hardware and software and integration testing.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18956, 'Adjust network sizes to meet volume or capacity demands.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18982, 'Prepare detailed network specifications, including diagrams, charts, equipment configurations, or recommended technologies.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18969, 'Develop network-related documentation.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18974, 'Estimate time and materials needed to complete projects.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18985, 'Supervise engineers or other staff in the design or implementation of network solutions.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18960, 'Coordinate network operations, maintenance, repairs, or upgrades.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18973, 'Develop procedures to track, project, or report network availability, reliability, capacity, or utilization.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18984, 'Research and test new or modified hardware or software products to determine performance and interoperability.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18957, 'Communicate with customers, sales staff, or marketing staff to determine customer needs.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18981, 'Prepare design presentations and proposals for staff or customers.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18962, 'Design, build, or operate equipment configuration prototypes, including network hardware, software, servers, or server operation systems.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18983, 'Prepare or monitor project schedules, budgets, or cost control systems.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18972, 'Develop plans or budgets for network equipment replacement.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18959, 'Coordinate installation of new equipment.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18976, 'Explain design specifications to integration or test engineers.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18970, 'Develop or maintain project reporting systems.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18986, 'Use network computer-aided design (CAD) software packages to optimize network designs.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18978, 'Maintain or coordinate the maintenance of network peripherals, such as printers.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18966, 'Develop and write procedures for installation, use, or troubleshooting of communications hardware or software.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18988, 'Communicate with vendors to gather information about products, alert them to future needs, resolve problems, or address system maintenance issues.', 'Core', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18977, 'Maintain networks by performing activities such as file addition, deletion, or backup.', 'Supplemental', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.00', 18963, 'Design, organize, and deliver product awareness, skills transfer, or product education sessions for staff or suppliers.', 'Supplemental', 22, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16081, 'Communicate with telecommunications vendors to obtain pricing and technical specifications for available hardware, software, or services.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16058, 'Keep abreast of changes in industry practices and emerging telecommunications technology by reviewing current literature, talking with colleagues, participating in educational programs, attending meetings or workshops, or participating in professional organizations or conferences.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16074, 'Implement or perform preventive maintenance, backup, or recovery procedures.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16080, 'Consult with users, administrators, and engineers to identify business and technical requirements for proposed system modifications or technology purchases.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16082, 'Assess existing facilities'' needs for new or modified telecommunications systems.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 20365, 'Order or maintain inventory of telecommunications equipment for customer premises equipment (CPE), facilities, access networks, or backbone networks.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16083, 'Install, or coordinate installation of, new or modified hardware, software, or programming modules of telecommunications systems.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16060, 'Develop, maintain, or implement telecommunications disaster recovery plans to ensure business continuity.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16069, 'Monitor and analyze system performance, such as network traffic, security, and capacity.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16059, 'Estimate costs for system or component implementation and operation.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16073, 'Implement system renovation projects in collaboration with technical staff, engineering consultants, installers, and vendors.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16064, 'Provide user support by diagnosing network and device problems and implementing technical or procedural solutions.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16078, 'Document procedures for hardware and software installation and use.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16061, 'Test and evaluate hardware and software to determine efficiency, reliability, or compatibility with existing systems.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16079, 'Work with personnel and facilities management staff to install, remove, or relocate user connectivity equipment and devices.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16072, 'Inspect sites to determine physical configuration, such as device locations and conduit pathways.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16062, 'Supervise maintenance of telecommunications equipment.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16063, 'Review and evaluate requests from engineers, managers, and technicians for system modifications.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16076, 'Document user support activity, such as system problems, corrective actions, resolution status, and completed equipment installations.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16066, 'Prepare purchase requisitions for computer hardware and software, networking and telecommunications equipment, test equipment, cabling, or tools.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16077, 'Document technical specifications and operating standards for telecommunications equipment.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 20366, 'Instruct in use of voice, video, and data communications systems.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16065, 'Prepare system activity and performance reports.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16067, 'Use computer-aided design (CAD) software to prepare or evaluate network diagrams, floor plans, or site configurations for existing facilities, renovations, or new systems.', 'Core', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16075, 'Implement controls to provide security for operating systems, software, and data.', 'Supplemental', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1143.01', 16070, 'Manage user access to systems and equipment through account management and password administration.', 'Supplemental', 23, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1282, 'Answer user inquiries regarding computer software or hardware operation to resolve problems.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1285, 'Oversee the daily performance of computer systems.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1288, 'Read technical manuals, confer with users, or conduct computer diagnostics to investigate and resolve problems or to provide technical assistance and support.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1286, 'Set up equipment for employee use, performing or ensuring proper installation of cables, operating systems, or appropriate software.', 'Core', 115, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1290, 'Develop training materials and procedures, or train users in the proper use of hardware or software.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1291, 'Refer major hardware or software problems or defective products to vendors or technicians for service.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1283, 'Enter commands and observe system functioning to verify correct operations and detect errors.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1287, 'Maintain records of daily data communication transactions, problems and remedial actions taken, or installation activities.', 'Core', 115, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1284, 'Install and perform minor repairs to hardware, software, or peripheral equipment, following design or installation specifications.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1292, 'Prepare evaluations of software or hardware, and recommend improvements or upgrades.', 'Core', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1289, 'Confer with staff, users, and management to establish requirements for new systems or modifications.', 'Core', 115, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1296, 'Modify and customize commercial programs for internal needs.', 'Supplemental', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1295, 'Inspect equipment and read order sheets to prepare for delivery to users.', 'Supplemental', 115, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1297, 'Conduct office automation feasibility studies, including workflow analysis, space design, or cost comparison analysis.', 'Supplemental', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 1293, 'Read trade magazines and technical manuals, or attend conferences and seminars to maintain knowledge of hardware and software.', 'Supplemental', 116, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1151.00', 15204, 'Hire, supervise, and direct workers engaged in special project work, problem solving, monitoring, and installing data communication equipment and software.', 'Supplemental', 115, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19004, 'Back up network data.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18991, 'Configure security settings or access permissions for groups or individuals.', 'Core', 118, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19003, 'Analyze and report computer network security breaches or attempted breaches.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18995, 'Identify the causes of networking problems, using diagnostic testing software and equipment.', 'Core', 118, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18993, 'Document network support activities.', 'Core', 115, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18992, 'Configure wide area network (WAN) or local area network (LAN) routers or related equipment.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18997, 'Install network software, including security or firewall software.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19002, 'Troubleshoot network or connectivity problems for users or user groups.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19010, 'Provide telephone support related to networking or connectivity issues.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18994, 'Evaluate local area network (LAN) or wide area network (WAN) performance data to ensure sufficient availability or speed, to identify network problems, or for disaster recovery purposes.', 'Core', 118, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18989, 'Analyze network data to determine network usage, disk space availability, or server function.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19000, 'Perform routine maintenance or standard repairs to networking components or equipment.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18990, 'Configure and define parameters for installation or testing of local area network (LAN), wide area network (WAN), hubs, routers, switches, controllers, multiplexers, or related networking equipment.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18998, 'Install new hardware or software systems or components, ensuring integration with existing network systems.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19001, 'Test computer software or hardware, using standard diagnostic testing equipment and procedures.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18999, 'Install or repair network cables, including fiber optic cables.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19009, 'Monitor industry websites or publications for information about patches, releases, viruses, or potential problem identification.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19006, 'Create or update technical documentation for network installations or changes to existing installations.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19014, 'Train users in procedures related to network applications software or related systems.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19013, 'Test repaired items to ensure proper operation.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 18996, 'Install and configure wireless networking equipment.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19008, 'Maintain logs of network activity.', 'Core', 115, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19007, 'Document help desk requests and resolutions.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19011, 'Research hardware or software products to meet technical networking or security needs.', 'Core', 117, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19005, 'Create or revise user instructions, procedures, or manuals.', 'Core', 116, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1152.00', 19012, 'Run monthly network reports.', 'Core', 115, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14638, 'Design test plans, scenarios, scripts, or procedures.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14641, 'Document software defects, using a bug tracking system, and report defects to software developers.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14642, 'Identify, analyze, and document problems with program function, output, online screen, or content.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14640, 'Develop testing programs that address areas such as database impacts, software scenarios, regression testing, negative testing, error or bug retests, or usability.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14646, 'Participate in product design reviews to provide input on functional requirements, product designs, schedules, or potential problems.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14648, 'Document test procedures to ensure replicability and compliance with standards.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14645, 'Plan test schedules or strategies in accordance with project scope or delivery dates.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14655, 'Conduct software compatibility tests with programs, hardware, operating systems, or network environments.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14639, 'Test system modifications to prepare for implementation.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14643, 'Monitor bug resolution efforts and track successes.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14647, 'Review software documentation to ensure technical accuracy, compliance, or completeness, or to mitigate risks.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14653, 'Provide feedback and recommendations to developers on software usability and functionality.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14650, 'Update automated test scripts to ensure currency.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14644, 'Create or maintain databases of known test defects.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14652, 'Install, maintain, or use software testing programs.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14656, 'Install and configure recreations of software production environments to allow testing of software performance.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14654, 'Monitor program performance to ensure efficient and problem-free operations.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14658, 'Identify program deviance from standards, and suggest modifications to ensure compliance.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14649, 'Develop or specify standards, methods, or procedures to determine product quality or release readiness.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14659, 'Design or develop automated testing tools.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14651, 'Investigate customer problems referred by technical support.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14664, 'Conduct historical analyses of test results.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14661, 'Perform initial debugging procedures by reviewing configuration files, logs, or code pieces to determine breakdown source.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14663, 'Evaluate or recommend software for testing or bug tracking.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14660, 'Coordinate user or third-party testing.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14657, 'Collaborate with field staff or customers to evaluate or diagnose problems and recommend possible solutions.', 'Core', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14662, 'Visit beta testing sites to evaluate software performance.', 'Supplemental', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.01', 14665, 'Provide technical support during software installation or configuration.', 'Supplemental', 27, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14669, 'Verify stability, interoperability, portability, security, or scalability of system architecture.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14682, 'Develop system engineering, software engineering, system integration, or distributed system architectures.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14670, 'Collaborate with engineers or software developers to select appropriate design solutions or ensure the compatibility of system components.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14673, 'Identify system data, hardware, or software components required to meet user needs.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14666, 'Communicate with staff or clients to understand specific system requirements.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14686, 'Research, test, or verify proper functioning of software patches and fixes.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14667, 'Provide advice on project costs, design concepts, or design changes.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14691, 'Perform security analyses of developed or packaged software components.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14672, 'Provide technical guidance or support for the development or troubleshooting of systems.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14668, 'Document design specifications, installation instructions, and other system-related information.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14687, 'Communicate project information through presentations, technical reports, or white papers.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14681, 'Define and analyze objectives, scope, issues, or organizational impact of information systems.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14675, 'Monitor system operation to detect potential problems.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14683, 'Design and conduct hardware or software tests.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14671, 'Evaluate current or emerging technologies to consider factors such as cost, portability, compatibility, or usability.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14674, 'Provide customers or installation teams guidelines for implementing secure systems.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14684, 'Establish functional or system standards to address operational requirements, quality requirements, and design constraints.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14677, 'Investigate system component suitability for specified purposes and make recommendations regarding component use.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14688, 'Complete models and simulations, using manual or automated tools, to analyze or predict system performance under different operating conditions.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14680, 'Develop or approve project plans, schedules, or budgets.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14693, 'Develop efficient and effective system controllers.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14685, 'Evaluate existing systems to determine effectiveness and suggest changes to meet organizational requirements.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14679, 'Configure servers to meet functional specifications.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14676, 'Direct the analysis, development, and operation of complete computer systems.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14692, 'Develop application-specific software.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14678, 'Perform ongoing hardware and software maintenance operations, including installing or upgrading hardware or software.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14689, 'Direct the installation of operating systems, network or application software, or computer or network hardware.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.02', 14690, 'Train system users in system operation or maintenance.', 'Core', 30, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14734, 'Monitor systems for intrusions or denial of service attacks, and report security breaches to appropriate personnel.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14741, 'Identify or document backup or recovery plans.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14731, 'Back up or modify applications and related data to provide for disaster recovery.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14758, 'Correct testing-identified problems, or recommend actions for their resolution.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14748, 'Identify, standardize, and communicate levels of access and security.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14732, 'Determine sources of Web page or server problems, and take action to correct such problems.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14740, 'Implement updates, upgrades, and patches in a timely manner to limit loss of service.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14735, 'Implement Web site security measures, such as firewalls or message encryption.', 'Core', 19, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14737, 'Collaborate with development teams to discuss, analyze, or resolve usability issues.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14750, 'Test issues such as system integration, performance, and system security on a regular schedule or after any major program modifications.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14756, 'Perform user testing or usage analyses to determine Web sites'' effectiveness or usability.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14753, 'Document application and Web site changes or change procedures.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14749, 'Track, compile, and analyze Web site usage data.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14738, 'Test backup or recovery plans regularly and resolve any problems.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14751, 'Recommend Web site improvements, and develop budgets to support recommendations.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14733, 'Review or update Web page content or links in a timely manner, using appropriate tools.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14743, 'Install or configure Web server software or hardware to ensure that directory structure is well-defined, logical, and secure, and that files are named properly.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14744, 'Gather, analyze, or document user feedback to locate or resolve sources of problems.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14762, 'Set up or maintain monitoring tools on Web servers or Web sites.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14739, 'Monitor Web developments through continuing education, reading, or participation in professional conferences, workshops, or groups.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14759, 'Develop or document style guidelines for Web site content.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14745, 'Develop Web site performance metrics.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14742, 'Collaborate with Web developers to create and operate internal and external Web sites, or to manage projects, such as e-marketing campaigns.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14746, 'Identify or address interoperability requirements.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14754, 'Develop or implement procedures for ongoing Web site revision.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14761, 'Check and analyze operating system or application log files regularly to verify proper system performance.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14755, 'Provide training or technical assistance in Web site implementation or use.', 'Core', 19, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14764, 'Evaluate testing routines or procedures for adequacy, sufficiency, and effectiveness.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14752, 'Inform Web site users of problems, problem resolutions, or application changes and updates.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14747, 'Document installation or configuration procedures to allow maintenance and repetition.', 'Core', 19, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14763, 'Develop testing routines and procedures.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14765, 'Test new software packages for use in Web operations or other applications.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14760, 'Develop and implement marketing plans for home pages, including print advertising or advertisement rotation.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14757, 'Evaluate or recommend server hardware or software.', 'Core', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.03', 14736, 'Administer internet or intranet infrastructure, including Web, file, and mail servers.', 'Supplemental', 20, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18116, 'Produce data layers, maps, tables, or reports, using spatial analysis procedures or Geographic Information Systems (GIS) technology, equipment, or systems.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18121, 'Provide technical expertise in Geographic Information Systems (GIS) technology to clients or users.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18109, 'Perform computer programming, data analysis, or software development for Geographic Information Systems (GIS) applications, including the maintenance of existing systems or research and development for future enhancements.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18118, 'Read current literature, talk with colleagues, continue education, or participate in professional organizations or conferences to keep abreast of developments in Geographic Information Systems (GIS) technology, equipment, or systems.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18119, 'Lead, train, or supervise technicians or related staff in the conduct of Geographic Information Systems (GIS) analytical procedures.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18105, 'Perform integrated or computerized Geographic Information Systems (GIS) analyses to address scientific problems.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18111, 'Collect, compile, or integrate Geographic Information Systems (GIS) data, such as remote sensing or cartographic data for inclusion in map manuscripts.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18112, 'Conduct or coordinate research, data analysis, systems design, or support for software such as Geographic Information Systems (GIS) or Global Positioning Systems (GPS) mapping software.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18122, 'Create, edit, or analyze geospatial data, using Global Positioning Systems (GPS) or digitizing techniques.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18126, 'Meet with clients to discuss topics such as technical specifications, customized solutions, or operational problems.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18114, 'Document, design, code, or test Geographic Information Systems (GIS) models, internet mapping solutions, or other applications.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18123, 'Create, analyze, report, convert, or transfer data, using specialized applications program software.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 19584, 'Develop new applications for geospatial technology in areas such as farmland preservation, pollution measurement, or utilities operations management.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18113, 'Design, program, or model Geographic Information Systems (GIS) applications or procedures.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18117, 'Coordinate the development or administration of Geographic Information Systems (GIS) projects, including the development of technical priorities, client reporting and interface, or coordination and review of schedules and budgets.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18106, 'Develop specialized computer software routines, internet-based Geographic Information Systems (GIS) databases, or business applications to customize geographic information.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18115, 'Make recommendations regarding upgrades, considering implications of new or revised Geographic Information Systems (GIS) software, equipment, or applications.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18110, 'Assist users in formulating Geographic Information Systems (GIS) requirements or understanding the implications of alternatives.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18108, 'Create visual representations of geospatial data, using complex procedures such as analytical modeling, three-dimensional renderings, or plot creation.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18120, 'Prepare training materials for, or make presentations to, Geographic Information Systems (GIS) users.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18125, 'Coordinate or direct research or publication activities of technicians or related staff.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18107, 'Provide technical support for computer-based Geographic Information Systems (GIS) mapping software.', 'Core', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 18124, 'Conduct feasibility studies or identify system, time, equipment, or cost requirements for projects.', 'Supplemental', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.04', 19583, 'Apply three-dimensional (3D) or four-dimensional (4D) technologies to geospatial data to allow for new or different analyses or applications.', 'Supplemental', 23, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16096, 'Design or prepare graphic representations of Geographic Information Systems (GIS) data, using GIS hardware or software applications.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16092, 'Analyze Geographic Information Systems (GIS) data to identify spatial relationships or display results of analyses, using maps, graphs, or tabular data.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16094, 'Maintain or modify existing Geographic Information Systems (GIS) databases.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16095, 'Enter data into Geographic Information Systems (GIS) databases, using techniques such as coordinate geometry, keyboard entry of tabular data, manual digitizing of maps, scanning or automatic conversion to vectors, or conversion of other sources of digital data.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16090, 'Review existing or incoming data for currency, accuracy, usefulness, quality, or completeness of documentation.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16093, 'Perform geospatial data building, modeling, or analysis, using advanced spatial analysis, data manipulation, or cartography software.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16097, 'Design or coordinate the development of integrated Geographic Information Systems (GIS) spatial or non-spatial databases.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16088, 'Select cartographic elements needed for effective presentation of information.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16085, 'Provide technical support to users or clients regarding the maintenance, development, or operation of Geographic Information Systems (GIS) databases, equipment, or applications.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16091, 'Interpret aerial or ortho photographs.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16084, 'Recommend procedures or equipment or software upgrades to increase data accessibility or ease of use.', 'Core', 55, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16086, 'Read current literature, talk with colleagues, continue education, or participate in professional organizations or conferences to keep abreast of developments in Geographic Information Systems (GIS) technology, equipment, or systems.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16087, 'Confer with users to analyze, configure, or troubleshoot applications.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 16089, 'Transfer or rescale information from original photographs onto maps or other photographs.', 'Core', 56, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 19585, 'Analyze Geographic Information Systems (GIS) data for use in urban planning applications that promote better land use or reduce environmental impacts of development.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 19586, 'Analyze Geographic Information Systems (GIS) data to determine the best locations for renewable energy sites, including solar or wind energy installations.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 19587, 'Apply Geographic Information Systems (GIS) data in transportation routing settings to determine the best routing to reduce pollution or energy consumption.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 19588, 'Confer with biologists or other researchers in the use of Geographic Information Systems (GIS) data to define wildlife areas or corridors for land use planning.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.05', 19589, 'Participate in projects that map changes in carbon emissions levels across different geographic locations, using Geographic Information Systems (GIS) data.', NULL, NULL, TO_DATE('2011-07-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16109, 'Design databases to support business applications, ensuring system scalability, security, performance and reliability.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16114, 'Develop database architectural strategies at the modeling, design and implementation stages to address business or industry requirements.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16113, 'Collaborate with system architects, software architects, design analysts, and others to understand business or industry requirements.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16108, 'Develop data models for applications, metadata tables, views or related database structures.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16100, 'Set up database clusters, backup, or recovery processes.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16112, 'Create and enforce database development standards.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16115, 'Develop and document database architectures.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16110, 'Design database applications, such as interfaces, data transfer mechanisms, global temporary tables, data partitions, and function-based indexes to enable efficient access of the generic database structure.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16103, 'Monitor and report systems resource consumption trends to assure production systems meet availability requirements and hardware enhancements are scheduled appropriately.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16105, 'Document and communicate database schemas, using accepted notations.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16101, 'Identify, evaluate and recommend hardware or software technologies to achieve desired database performance.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16111, 'Demonstrate database technical functionality, such as performance, security and reliability.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16106, 'Develop or maintain archived procedures, procedural codes, or queries for applications.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16098, 'Test changes to database applications or systems.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16107, 'Develop load-balancing processes to eliminate down time for backup processes.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16099, 'Provide technical support to junior staff or clients.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16104, 'Identify and correct deviations from database development standards.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.06', 16102, 'Plan and install upgrades of database management system software to enhance database performance.', 'Core', 24, TO_DATE('2015-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16132, 'Develop data warehouse process models, including sourcing, loading, transformation, and extraction.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16121, 'Verify the structure, accuracy, or quality of warehouse data.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16124, 'Map data between source systems, data warehouses, and data marts.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16126, 'Develop and implement data extraction procedures from other systems, such as administration, billing, or claims.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16128, 'Design and implement warehouse database structures.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16127, 'Develop or maintain standards, such as organization, structure, or nomenclature, for the design of data warehouse elements, such as data architectures, models, tools, and databases.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16118, 'Provide or coordinate troubleshooting support for data warehouses.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16120, 'Write new programs or modify existing programs to meet customer requirements, using current programming languages and technologies.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16133, 'Design, implement, or operate comprehensive data warehouse systems to balance optimization of data access with batch loading and resource utilization factors, according to customer requirements.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16123, 'Perform system analysis, data analysis or programming, using a variety of computer languages and procedures.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16129, 'Create supporting documentation, such as metadata and diagrams of entity relationships, business processes, and process flow.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16131, 'Create or implement metadata processes and frameworks.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16117, 'Review designs, codes, test plans, or documentation to ensure quality.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16130, 'Create plans, test files, and scripts for data warehouse testing, ranging from unit to integration testing.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16122, 'Select methods, techniques, or criteria for data warehousing evaluative procedures.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16125, 'Implement business rules via stored procedures, middleware, or other technologies.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16119, 'Prepare functional or technical documentation for data warehouses.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.07', 16116, 'Test software systems or applications for software enhancements or new products.', 'Core', 23, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16148, 'Analyze competitive market strategies through analysis of related product, market, or share trends.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16149, 'Synthesize current business intelligence or trend data to support recommendations for action.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16138, 'Communicate with customers, competitors, suppliers, professional organizations, or others to stay abreast of industry or business trends.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16140, 'Manage timely flow of business intelligence information to users.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16146, 'Collect business intelligence data from available industry reports, public information, field reports, or purchased sources.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16141, 'Identify and analyze industry or geographic trends with business strategy implications.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16147, 'Analyze technology trends to identify markets for future product development or to improve sales of existing products.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16150, 'Generate standard or custom reports summarizing business, financial, or economic data for review by executives, managers, clients, and other stakeholders.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16136, 'Identify or monitor current and potential customers, using business intelligence tools.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16139, 'Maintain or update business intelligence tools, databases, dashboards, systems, or methods.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16135, 'Maintain library of model documents, templates, or other reusable knowledge assets.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16144, 'Create business intelligence tools or systems, including design of related databases, spreadsheets, or outputs.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16145, 'Conduct or coordinate tests to ensure that intelligence is consistent with defined needs.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16143, 'Disseminate information regarding tools, reports, or metadata enhancements.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16142, 'Document specifications for business intelligence or information technology reports, dashboards, or other outputs.', 'Supplemental', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16137, 'Create or review technical design documentation to ensure the accurate development of reporting solutions.', 'Supplemental', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.08', 16134, 'Provide technical support for existing reports, dashboards, or other tools.', 'Supplemental', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16169, 'Manage project execution to ensure adherence to budget, schedule, and scope.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16154, 'Confer with project personnel to identify and resolve problems.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16157, 'Monitor or track project milestones and deliverables.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16152, 'Submit project deliverables, ensuring adherence to quality standards.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16155, 'Assess current or future customer needs and priorities by communicating directly with customers, conducting surveys, or other methods.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16159, 'Initiate, review, or approve modifications to project plans.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16156, 'Schedule and facilitate meetings related to information technology projects.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16163, 'Direct or coordinate activities of project personnel.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16164, 'Develop implementation plans that include analyses such as cost-benefit or return on investment (ROI).', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16162, 'Identify need for initial or supplemental project resources.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16170, 'Develop or update project plans for information technology projects including information such as project objectives, technologies, systems, information specifications, schedules, funding, and staffing.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16151, 'Perform risk assessments to develop response strategies.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16168, 'Prepare project status reports by collecting, analyzing, and summarizing information and trends.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16160, 'Identify, review, or select vendors or consultants to meet project needs.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16166, 'Develop and manage annual budgets for information technology projects.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16161, 'Establish and execute a project communication plan.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16171, 'Develop and manage work breakdown structure (WBS) of information technology projects.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16153, 'Monitor the performance of project team members, providing and documenting performance feedback.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16165, 'Coordinate recruitment or selection of project personnel.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16167, 'Assign duties, responsibilities, and spans of authority to project personnel.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.09', 16158, 'Negotiate with project stakeholders or suppliers to obtain resources or materials.', 'Core', 21, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16192, 'Collect and analyze Web metrics, such as visits, time on site, page views per visit, transaction volume and revenue, traffic mix, click-through rates, conversion rates, cost per acquisition, or cost per click.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20326, 'Identify appropriate Key Performance Indicators (KPIs) and report key metrics from digital campaigns.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20318, 'Assist in setting up or optimizing analytics tools for tracking visitors'' behaviors.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20320, 'Coordinate with developers to optimize Web site architecture, server configuration, or page construction for search engine consumption and optimal visibility.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16191, 'Conduct online marketing initiatives, such as paid ad placement, affiliate programs, sponsorship programs, email promotions, or viral marketing campaigns on social media Web sites.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16182, 'Participate in the development or implementation of online marketing strategy.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20327, 'Improve search-related activities through ongoing analysis, experimentation, or optimization tests, using A/B or multivariate methods.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20329, 'Optimize digital assets, such as text, graphics, or multimedia assets, for search engine optimization (SEO) or for display and usability on internet-connected devices.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20321, 'Create content strategies for digital media.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20328, 'Manage tracking and reporting of search-related activities and provide analyses to marketing executives.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16190, 'Optimize Web site exposure by analyzing search engine patterns to direct online placement of keywords or other content.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20319, 'Combine secondary data sources with keyword research to more accurately profile and satisfy user intent.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16188, 'Communicate and collaborate with merchants, Webmasters, bloggers, or online editors to strategically place hyperlinks.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20330, 'Optimize shopping cart experience or Web site conversion rates against Key Performance Indicators (KPIs).', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20322, 'Evaluate new emerging media or technologies and make recommendations for their application within Internet marketing or search marketing campaigns.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16189, 'Collaborate with other marketing staff to integrate and complement marketing strategies across multiple sales channels.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20325, 'Execute or manage social media campaigns to inform search marketing tactics.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16179, 'Propose online or multiple-sales-channel campaigns to marketing executives.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16186, 'Conduct market research analysis to identify search query trends, real-time search and news media activity, popular social media topics, electronic commerce trends, market opportunities, or competitor performance.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20331, 'Purchase or negotiate placement of listings in local search engines, directories, or digital mapping technologies.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16187, 'Conduct financial modeling for online marketing programs or Web site revenue forecasting.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20324, 'Execute or manage banner, video, or other non-text link ad campaigns.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 20323, 'Execute and manage communications with digital journalists or bloggers.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16185, 'Coordinate sales or other promotional strategies with merchandising, operations, or inventory control staff to ensure product catalogs are current, accurate, and organized for best findability against user intent.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16177, 'Define product requirements, based on market research analysis, in collaboration with user interface design and engineering staff.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16193, 'Collaborate with Web, multimedia, or art design staffs to create multimedia Web sites or other internet content that conforms to brand and company visual format.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16178, 'Assist in the evaluation or negotiation of contracts with vendors or online partners.', 'Core', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16174, 'Implement online customer service processes to ensure positive and consistent user experiences.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16173, 'Resolve product availability problems in collaboration with customer service staff.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16184, 'Develop transactional Web applications, using Web programming software and knowledge of programming languages, such as hypertext markup language (HTML) and extensible markup language (XML).', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16181, 'Prepare electronic commerce designs or prototypes, such as storyboards, mock-ups, or other content, using graphics design software.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16175, 'Identify, evaluate, or procure hardware or software for implementing online marketing campaigns.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16180, 'Assist in the development of online transaction or security policies.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16183, 'Identify and develop commercial or technical specifications, such as usability, pricing, checkout, or data security, to promote transactional internet-enabled commerce functionality.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16176, 'Identify methods for interfacing Web application technologies with enterprise resource planning or other system software.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.10', 16172, 'Keep abreast of government regulations and emerging Web technology to ensure regulatory compliance by reviewing current literature, talking with colleagues, participating in educational programs, attending meetings or workshops, or participating in professional organizations or conferences.', 'Supplemental', 23, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16199, 'Balance and adjust gameplay experiences to ensure the critical and commercial success of the product.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16198, 'Provide feedback to designers and other colleagues regarding game design features.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16217, 'Create core game features including storylines, role-play mechanics, and character biographies for a new video game or game franchise.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16208, 'Devise missions, challenges, or puzzles to be encountered in game play.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16207, 'Guide design discussions between development teams.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16209, 'Develop and maintain design level documentation, including mechanics, guidelines, and mission outlines.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16212, 'Create and manage documentation, production schedules, prototyping goals, and communication plans in collaboration with production staff.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16204, 'Present new game design concepts to management and technical colleagues, including artists, animators, and programmers.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16214, 'Conduct regular design reviews throughout the game development process.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16201, 'Solicit, obtain, and integrate feedback from design and technical staff into original game design.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16216, 'Document all aspects of formal game design, using mock-up screenshots, sample menu layouts, gameplay flowcharts, and other graphical devices.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16202, 'Provide feedback to production staff regarding technical game qualities or adherence to original design.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16203, 'Prepare two-dimensional concept layouts or three-dimensional mock-ups.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16213, 'Consult with multiple stakeholders to define requirements and implement online features.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16206, 'Oversee gameplay testing to ensure intended gaming experience and game adherence to original vision.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16196, 'Keep abreast of game design technology and techniques, industry trends, or audience interests, reactions, and needs by reviewing current literature, talking with colleagues, participating in educational programs, attending meetings or workshops, or participating in professional organizations or conferences.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16211, 'Create gameplay prototypes for presentation to creative and technical staff and management.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16200, 'Write or supervise the writing of game text and dialogue.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16215, 'Collaborate with artists to achieve appropriate visual style.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16210, 'Determine supplementary virtual features, such as currency, item catalog, menu design, and audio direction.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16194, 'Review or evaluate competitive products, film, music, television, and other art forms to generate new game design ideas.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16205, 'Prepare and revise initial game sketches using two- and three-dimensional graphical design software.', 'Core', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16195, 'Provide test specifications to quality assurance staff.', 'Supplemental', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.11', 16197, 'Create gameplay test plans for internal and external test groups.', 'Supplemental', 21, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16231, 'Conduct needs assessments to identify document management requirements of departments or end users.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16230, 'Consult with end users regarding problems in accessing electronic content.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16219, 'Monitor regulatory activity to maintain compliance with records and document management laws.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16234, 'Assist in determining document management policies to facilitate efficient, legal, and secure access to electronic content.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16238, 'Implement electronic document processing, retrieval, and distribution systems in collaboration with other information technology specialists.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16237, 'Administer document and system access rights and revision control to ensure security of system and integrity of master documents.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16240, 'Develop or configure document management system features, such as user interfaces, access profiles, and document workflow procedures.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16233, 'Assist in the assessment, acquisition, or deployment of new electronic document management systems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16221, 'Search electronic sources, such as databases or repositories, or manual sources for information.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 20367, 'Keep abreast of developments in document management technologies and techniques by reviewing current literature, talking with colleagues, participating in educational programs, attending meetings or workshops, or participating in professional organizations or conferences.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16222, 'Retrieve electronic assets from repository for distribution to users, collecting and returning to repository, if necessary.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16229, 'Develop, document, or maintain standards, best practices, or system usage procedures.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16220, 'Write, review, or execute plans for testing new or established document management systems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16227, 'Implement scanning or other automated data entry procedures, using imaging devices and document imaging software.', 'Core', 24, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16239, 'Identify and classify documents or other electronic content according to characteristics such as security level, function, and metadata.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 20368, 'Prepare and record changes to official documents and confirm changes with legal and compliance management staff, including enterprise-wide records management staff.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16232, 'Assist in the development of document or content classification taxonomies to facilitate information capture, search, and retrieval.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16224, 'Prepare support documentation and training materials for end users of document management systems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16223, 'Propose recommendations for improving content management system capabilities.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16236, 'Operate data capture technology to import digitized documents into document management system.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16228, 'Document technical functions and specifications for new or proposed content management systems.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16226, 'Exercise security surveillance over document processing, reproduction, distribution, storage, or archiving.', 'Core', 24, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-1199.12', 16235, 'Analyze, interpret, or disseminate system performance data.', 'Core', 25, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3500, 'Ascertain premium rates required and cash reserves and liabilities necessary to ensure payment of future benefits.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3502, 'Design, review and help administer insurance, annuity and pension plans, determining financial soundness and calculating premiums.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3504, 'Determine or help determine company policy, and explain complex technical matters to company executives, government officials, shareholders, policyholders, or the public.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3506, 'Provide advice to clients on a contract basis, working as a consultant.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3501, 'Analyze statistical information to estimate mortality, accident, sickness, disability, and retirement rates.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3508, 'Construct probability tables for events such as fires, natural disasters, and unemployment, based on analysis of statistical data and other pertinent information.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 20951, 'Negotiate terms and conditions of reinsurance with other companies.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3503, 'Collaborate with programmers, underwriters, accounts, claims experts, and senior management to help companies develop plans for new lines of business or improvements to existing business.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3512, 'Determine equitable basis for distributing surplus earnings under participating insurance and annuity contracts in mutual companies.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3505, 'Testify before public agencies on proposed legislation affecting businesses.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3509, 'Determine policy contract provisions for each type of insurance.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3507, 'Testify in court as expert witness or to provide legal evidence on matters such as the value of potential lifetime earnings of a person who is disabled or killed in an accident.', 'Core', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3511, 'Provide expertise to help financial institutions manage risks and maximize returns associated with investment products or credit offerings.', 'Supplemental', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3510, 'Manage credit and help price corporate security offerings.', 'Supplemental', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2011.00', 3513, 'Explain changes in contract provisions to customers.', 'Supplemental', 32, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7368, 'Develop computational methods for solving problems that occur in areas of science and engineering or that come from applications in business or industry.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7367, 'Apply mathematical theories and techniques to the solution of practical problems in business, engineering, the sciences, or other fields.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7371, 'Develop mathematical or statistical models of phenomena to be used for analysis or for computational simulation.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7372, 'Assemble sets of assumptions and explore the consequences of each set.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7369, 'Maintain knowledge in the field by reading professional journals, talking with other mathematicians, and attending professional conferences.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7373, 'Address the relationships of quantities, magnitudes, and forms through the use of numbers and symbols.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 20191, 'Disseminate research by writing reports, publishing papers, or presenting at professional conferences.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7370, 'Perform computations and apply methods of numerical analysis to data.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7374, 'Develop new principles and new relationships between existing mathematical principles to advance mathematical science.', 'Core', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7375, 'Design, analyze, and decipher encryption systems designed to transmit military, political, financial, or law-enforcement-related information in code.', 'Supplemental', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2021.00', 7376, 'Conduct research to extend mathematical knowledge in traditional areas, such as algebra, geometry, probability, and logic.', 'Supplemental', 24, TO_DATE('2012-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7377, 'Formulate mathematical or simulation models of problems, relating constants and variables, restrictions, alternatives, conflicting objectives, and their numerical parameters.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7380, 'Perform validation and testing of models to ensure adequacy and reformulate models as necessary.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7381, 'Collaborate with senior managers and decision makers to identify and solve a variety of problems and to clarify management objectives.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 20952, 'Present the results of mathematical modeling and data analysis to management or other end users.', 'Core', 19, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7378, 'Collaborate with others in the organization to ensure successful implementation of chosen problem solutions.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7379, 'Analyze information obtained from management to conceptualize and define operational problems.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7383, 'Study and analyze information about alternative courses of action to determine which plan will offer the best outcomes.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7384, 'Prepare management reports defining and evaluating problems and recommending solutions.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7382, 'Define data requirements and gather and validate information, applying judgment and statistical tests.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7387, 'Observe the current system in operation and gather and analyze information about each of the parts of component problems, using a variety of sources.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7385, 'Break systems into their components, assign numerical values to each component, and examine the mathematical relationships between them.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7388, 'Design, conduct, and evaluate experimental operational models in cases where models cannot be developed from existing data.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 20953, 'Educate staff in the use of mathematical models.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7386, 'Specify manipulative or computational methods to be applied to models.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7389, 'Develop and apply time and cost networks to plan, control, and review large projects.', 'Core', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2031.00', 7390, 'Develop business methods and procedures, including accounting systems, file systems, office systems, logistics systems, and production schedules.', 'Supplemental', 20, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8956, 'Analyze and interpret statistical data to identify significant differences in relationships among sources of information.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8955, 'Identify relationships and trends in data, as well as any factors that could affect the results of research.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 21100, 'Determine whether statistical methods are appropriate, based on user needs or research questions of interest.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8957, 'Prepare data for processing by organizing information, checking for inaccuracies, and adjusting and weighting the raw data.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 20194, 'Present statistical and nonstatistical results, using charts, bullets, and graphs, in meetings or conferences to audiences such as clients, peers, and students.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8953, 'Report results of statistical analyses, including information in the form of graphs, charts, and tables.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8961, 'Design research projects that apply valid scientific techniques and use information obtained from baselines or historical data to structure uncompromised and efficient analyses.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8954, 'Process large amounts of data for statistical modeling and graphic analysis, using computers.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8965, 'Adapt statistical methods to solve specific problems in many fields, such as economics, biology, and engineering.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8958, 'Evaluate the statistical methods and procedures used to obtain data to ensure validity, applicability, efficiency, and accuracy.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 20192, 'Report results of statistical analyses in peer-reviewed papers and technical manuals.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8959, 'Evaluate sources of information to determine any limitations, in terms of reliability or usability.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8966, 'Develop and test experimental designs, sampling techniques, and analytical methods.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8960, 'Plan data collection methods for specific projects and determine the types and sizes of sample groups to be used.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8963, 'Supervise and provide instructions for workers collecting and tabulating data.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8967, 'Examine theories, such as those of probability and inference, to discover mathematical bases for new or improved methods of obtaining and evaluating numerical data.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 21101, 'Prepare and structure data warehouses for storing data.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 20193, 'Develop software applications or programming to use for statistical modeling and graphic analysis.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.00', 8964, 'Apply sampling techniques or use complete enumeration bases to determine and define groups to be surveyed.', 'Core', 20, TO_DATE('2019-08-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16254, 'Draw conclusions or make predictions, based on data summaries or statistical analyses.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16258, 'Design research studies in collaboration with physicians, life scientists, or other professionals.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16265, 'Analyze clinical or survey data, using statistical approaches such as longitudinal analysis, mixed-effect modeling, logistic regression analyses, and model-building techniques.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16263, 'Provide biostatistical consultation to clients or colleagues.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16241, 'Write research proposals or grant applications for submission to external bodies.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16245, 'Prepare articles for publication or presentation at professional conferences.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16246, 'Calculate sample size requirements for clinical studies.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16250, 'Write detailed analysis plans and descriptions of analyses and findings for research protocols or reports.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16253, 'Monitor clinical trials or experiments to ensure adherence to established procedures or to verify the quality of data collected.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16262, 'Review clinical or other medical research protocols and recommend appropriate statistical analyses.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16252, 'Prepare tables and graphs to present clinical data or results.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16257, 'Develop or implement data analysis algorithms.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16244, 'Prepare statistical data for inclusion in reports to data monitoring committees, federal regulatory agencies, managers, or clients.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16249, 'Write program code to analyze data with statistical analysis software.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16243, 'Read current literature, attend meetings or conferences, and talk with colleagues to keep abreast of methodological or conceptual developments in fields such as biostatistics, pharmacology, life sciences, and social sciences.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16248, 'Assign work to biostatistical assistants or programmers.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16242, 'Teach graduate or continuing education courses or seminars in biostatistics.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16251, 'Plan or direct research studies related to life sciences.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16247, 'Determine project plans, timelines, or technical objectives for statistical aspects of biological research studies.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16264, 'Apply research or simulation results to extend biological theory or recommend new research projects.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16260, 'Collect data through surveys or experimentation.', 'Core', 24, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16259, 'Design or maintain databases of biological data.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16255, 'Develop or use mathematical models to track changes in biological phenomena, such as the spread of infectious diseases.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16261, 'Analyze archival data, such as birth, death, and disease records.', 'Core', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.01', 16256, 'Design surveys to assess health issues.', 'Supplemental', 25, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16281, 'Design and validate clinical databases, including designing or testing logic checks.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16284, 'Process clinical data, including receipt, entry, verification, or filing of information.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16280, 'Generate data queries, based on validation checks or errors and omissions identified during data entry, to resolve identified problems.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16285, 'Develop project-specific data management plans that address areas such as coding, reporting, or transfer of data, database locks, and work flow processes.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16279, 'Monitor work productivity or quality to ensure compliance with standard operating procedures.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16268, 'Prepare appropriate formatting to data sets as requested.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16286, 'Design forms for receiving, processing, or tracking data.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16277, 'Prepare data analysis listings and activity, performance, or progress reports.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16282, 'Confer with end users to define or implement clinical system requirements such as data release formats, delivery schedules, and testing protocols.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16278, 'Perform quality control audits to ensure accuracy, completeness, or proper usage of clinical systems and data.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16283, 'Analyze clinical data using appropriate statistical tools.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16269, 'Evaluate processes and technologies, and suggest revisions to increase productivity and efficiency.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16270, 'Develop technical specifications for data management programming and communicate needs to information technology staff.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16273, 'Write work instruction manuals, data capture guidelines, or standard operating procedures.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16274, 'Track the flow of work forms, including in-house data flow or electronic forms transfer.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16276, 'Supervise the work of data management project staff.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16272, 'Contribute to the compilation, organization, and production of protocols, clinical study reports, regulatory submissions, or other controlled documentation.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16266, 'Read technical literature and participate in continuing education or professional associations to maintain awareness of current database technology and best practices.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16275, 'Train staff on technical procedures or software program usage.', 'Core', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16271, 'Develop or select specific software programs for various research scenarios.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2041.02', 16267, 'Provide support and information to functional areas such as marketing, clinical monitoring, and medical affairs.', 'Supplemental', 20, TO_DATE('2016-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15297, 'Apply standardized mathematical formulas, principles, and methodology to the solution of technological problems involving engineering or physical science.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15298, 'Process data for analysis, using computers.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15299, 'Reduce raw data to meaningful terms, using the most practical and accurate combination and sequence of computational methods.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15300, 'Translate data into numbers, equations, flow charts, graphs, or other forms.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15301, 'Confer with scientific or engineering personnel to plan projects.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('15-2091.00', 15302, 'Modify standard formulas so that they conform to project needs and data processing methods.', NULL, NULL, TO_DATE('2003-03-01', 'yyyy-mm-dd'), 'Analyst');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20479, 'Prepare scale drawings or architectural designs, using computer-aided design or other tools.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19596, 'Plan or design structures such as residences, office buildings, theatres, factories, or other structural properties in accordance with environmental, safety, or other regulations.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20480, 'Direct activities of technicians engaged in preparing drawings or specification documents.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 134, 'Prepare contract documents for building contractors.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 130, 'Prepare information regarding design, structure specifications, materials, color, equipment, estimated costs, or construction time.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20481, 'Meet with clients to review or discuss architectural drawings.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 136, 'Integrate engineering elements into unified architectural designs.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 138, 'Administer construction contracts.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 131, 'Consult with clients to determine functional or spatial requirements of structures.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20482, 'Develop marketing materials, proposals, or presentation to generate new work opportunities.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20483, 'Develop final construction plans that include aesthetic representations of the structure or details for its construction.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20484, 'Conduct periodic on-site observations of construction work to monitor compliance with plans.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20485, 'Monitor the work of specialists, such as electrical engineers, mechanical engineers, interior designers, or sound specialists to ensure optimal form or function of designs or final structures.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20486, 'Plan layouts of structural architectural projects.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19592, 'Design or plan construction of green building projects to minimize adverse environmental impact or conserve energy.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 139, 'Represent clients in obtaining bids or awarding construction contracts.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19593, 'Design structures that incorporate environmentally friendly building practices or concepts, such as Leadership in Energy and Environmental Design (LEED) standards.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19595, 'Perform predesign services, such as feasibility or environmental impact studies.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20487, 'Inspect proposed building sites to determine suitability for construction.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 20488, 'Create three-dimensional or interactive representations of designs, using computer-assisted design software.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19591, 'Design environmentally sound structural upgrades to existing buildings, such as natural lighting systems, green roofs, or rainwater collection systems.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19594, 'Gather information related to projects'' environmental sustainability or operational efficiency.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 140, 'Prepare operating and maintenance manuals, studies, or reports.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1011.00', 19590, 'Calculate potential energy savings by comparing estimated energy consumption of proposed design to baseline standards.', 'Core', 27, TO_DATE('2014-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20369, 'Confer with clients, engineering personnel, or architects on landscape projects.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20370, 'Prepare site plans, specifications, or cost estimates for land development.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20371, 'Analyze data on conditions such as site location, drainage, or structure location for environmental reports or landscaping plans.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20372, 'Develop marketing materials, proposals, or presentation to generate new work opportunities.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20373, 'Inspect landscape work to ensure compliance with specifications, evaluate quality of materials or work, or advise clients or construction personnel.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 18470, 'Prepare graphic representations or drawings of proposed plans or designs.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20374, 'Present project plans or designs to public stakeholders, such as government agencies or community groups.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20375, 'Integrate existing land features or landscaping into designs.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20376, 'Manage the work of subcontractors to ensure quality control.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 19598, 'Create landscapes that minimize water consumption such as by incorporating drought-resistant grasses or indigenous plants.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 19597, 'Collaborate with architects or related professionals on whole building design to maximize the aesthetic features of structures or surrounding land and to improve energy efficiency.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20377, 'Research latest products, technology, or design trends to stay current in the field.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20378, 'Inspect proposed sites to identify structural elements of land areas or other important site information, such as soil condition, existing landscaping, or the proximity of water management facilities.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20379, 'Develop planting plans to help clients garden productively or to achieve particular aesthetic effects.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 19600, 'Identify and select appropriate sustainable materials for use in landscape designs, such as recycled wood or recycled concrete boards for structural elements or recycled tires for playground bedding.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 19599, 'Design and integrate rainwater harvesting or gray and reclaimed water systems to conserve water into building or land designs.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20380, 'Collaborate with estimators to cost projects, create project plans, or coordinate bids from landscaping contractors.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20381, 'Prepare conceptual drawings, graphics, or other visual representations of land areas to show predicted growth or development of land areas over time.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1012.00', 20382, 'Provide follow-up consultations for clients to ensure landscape designs are maturing or developing as planned.', 'Core', 28, TO_DATE('2013-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3517, 'Compile data required for map preparation, including aerial photographs, survey notes, records, reports, and original maps.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3522, 'Delineate aerial photographic detail, such as control points, hydrography, topography, and cultural features, using precision stereoplotting apparatus or drafting instruments.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3524, 'Prepare and alter trace maps, charts, tables, detailed drawings, and three-dimensional optical models of terrain using stereoscopic plotting and computer graphics equipment.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3526, 'Study legal records to establish boundaries of local, national, and international properties.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3518, 'Inspect final compositions to ensure completeness and accuracy.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3516, 'Revise existing maps and charts, making all necessary corrections and adjustments.', 'Core', 59, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3514, 'Identify, scale, and orient geodetic points, elevations, and other planimetric or topographic features, applying standard mathematical formulas.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3515, 'Collect information about specific features of the Earth, using aerial photography and other digital remote sensing techniques.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3520, 'Examine and analyze data from ground surveys, reports, aerial photographs, and satellite images to prepare topographic maps, aerial-photograph mosaics, and related charts.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3523, 'Build and update digital databases.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3519, 'Determine map content and layout, as well as production specifications such as scale, size, projection, and colors, and direct production to ensure that specifications are followed.', 'Core', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3525, 'Determine guidelines that specify which source material is acceptable for use.', 'Supplemental', 59, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3521, 'Select aerial photographic and remote sensing techniques and plotting equipment needed to meet required standards of accuracy.', 'Supplemental', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1021.00', 3527, 'Travel over photographed areas to observe, identify, record, and verify all relevant features.', 'Supplemental', 60, TO_DATE('2018-08-01', 'yyyy-mm-dd'), 'Incumbent');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3529, 'Verify the accuracy of survey data, including measurements and calculations conducted at survey sites.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3530, 'Direct or conduct surveys to establish legal boundaries for properties, based on legal deeds and titles.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3533, 'Prepare or supervise preparation of all data, charts, plots, maps, records, and documents related to surveys.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3528, 'Prepare and maintain sketches, maps, reports, and legal descriptions of surveys to describe, certify, and assume liability for work performed.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3534, 'Write descriptions of property boundary surveys for use in deeds, leases, or other legal documents.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3536, 'Search legal records, survey records, and land titles to obtain information about property boundaries in areas to be surveyed.', 'Core', 31, TO_DATE('2017-07-01', 'yyyy-mm-dd'), 'Occupational Expert');
INSERT INTO task_statements (onetsoc_code, task_id, task, task_type, incumbents_responding, date_updated, domain_source) VALUES ('17-1022.00', 3537, 'Coordinate findings with the work of engineering and architectural personnel, clients, and others concerned with proj